/*
 * ProgressInfo.hpp  --  Part of the CinePaint plug-in "Bracketing_to_HDR"
 *
 * Copyright 2005  Hartmut Sbosny  <hartmut.sbosny@gmx.de>
 *
 * LICENSE:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/**
  ProgressInfo.hpp

  Abstract ProgressInfo class. Shall to be available in (numerical) algorithms
    without referencing to a concrete GUI, which can change as generally known.
    Concrete GUI has to be implementable subsequently. Happens by deriving from
    this base class and overwriting the virtual functions value() and text().
    The pre-sequent numerical algorithms ply either with a global ProgressInfo
    pointer or such one is handed over in their Ctor. In the superior GUI
    layer the global pointer is to point then suitably.
    
  Inzwischen weitere virt. Funktionen show() und hide() dazugekommen, weil ich
    auch in GUI-Klassen unterhalb der Hauptfenster-Klasse den Fortschrittsbalken
    schon ein- und ausschalten musste. Gefaellt mir eigentlich nicht so, naja, mal
    sehen. Namen "show()" und "hide()" auch zu konkret.
  
  Beim Gebrauch des Zeigers `__progressinfo' ist durch die Abfrage 
  ``if (__progressinfo) ...'' der Nichtinitialisierungs-Fall immer abzusichern. 
*/
#ifndef ProgressInfo_hpp
#define ProgressInfo_hpp

class ProgressInfo 
{
public:
  virtual void value (float v) = 0;    // Convention: v \in [0,1]
  virtual void text (const char*) = 0;
  virtual void show () = 0;
  virtual void hide () = 0;
  
  virtual ~ProgressInfo() {}  // avoids warnings (we have abstract fncts)
};

// Declaration of the global pointer to the ProgressInfo class
//  (later better less globally) 
extern ProgressInfo* __progressinfo;

#endif

// END OF FILE
