/*
 * br_messages.cpp  --  Part of the CinePaint plug-in "Bracketing_to_HDR"
 *
 * Copyright (c) 2005-2006  Hartmut Sbosny  <hartmut.sbosny@gmx.de>
 *
 * LICENSE:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/**
  br_messages.cpp
*/

#include <cstdarg>          // va_start(), va_end(), va_list
#include <cstdio>           // printf(), vfprintf()
#include "br_messages.hpp"

namespace br {

/**+*************************************************************************\n
  Output formated string to stderr.
******************************************************************************/
void e_printf (const char *fmt, ...) 
{
    va_list p;
    if (fmt)
    {   va_start (p,fmt);
        vfprintf (stderr, fmt, p);
        va_end (p);
    }
}

/**+*************************************************************************\n
  NOTE: A final '\n' is added here, so avoid it in `text and `fmt.
******************************************************************************/

void core_msg_alert (const char* text)
{
    fprintf(stderr, "Br2Hdr-ALERT **: %s\n", text);
}

void core_msg_message (const char* text)
{
    fprintf(stderr, "Br2Hdr-MESSAGE: %s\n", text);
}

static void 
core_msg_v_alert (const char* fmt, ...)
{
    fprintf(stderr, "Br2Hdr-ALERT **: ");
    va_list p;
    if (fmt) {   
      va_start (p,fmt);
      vfprintf (stderr, fmt, p);
      va_end (p);
    }
    fputc ('\n', stderr);
}

static void 
core_msg_v_message (const char* fmt, ...)
{
    fprintf(stderr, "Br2Hdr-MESSAGE: ");
    va_list p;
    if (fmt) {   
      va_start (p,fmt);
      vfprintf (stderr, fmt, p);
      va_end (p);
    }
    fputc ('\n', stderr);
}



/*****************************************************************************
  Default setting for the global message function pointers: 
******************************************************************************/

MsgFuncAlert        alert       =  core_msg_alert;
MsgFuncMessage      message     =  core_msg_message;
FmtMsgFuncAlert     v_alert     =  core_msg_v_alert;
FmtMsgFuncMessage   v_message   =  core_msg_v_message;


}  // namespace "br"

// END OF FILE
