#include "cp_types.h"
#include "cp_proto.h"

/* Vertices: read string specified by dpoint of vertex indices from p, 
create link list, return pointer, and set endptr to NULL or first 
inapprop char encountered. hits=0 ==> no expressions parsed. */

struct Vertlist *Node_link_parse(struct p_data *p,char *dpoint,
				 char **endptr,int *hits,
				 struct Vertlist **Vlist,
				 struct Edgelist **Elist,
				 struct Vertlist **Flist,
				 Region *region,struct Pathlist *pathlist,
				 int pathlength)
{
  int i,length,count,nextvert,stopvert,v1,v2,n,j,cflg,
    q,qcount,q_flag,cf_flag=1,*tmpverts,done,vert,hts;
  char next[256],*nextptr,*lastptr,*ptr,phold[1],*edptr;
  double rad,dist;
  complex ctr;
  struct K_data *pK_ptr,*qK_ptr=NULL;
  struct R_data *pR_ptr;
  struct Vertlist *vertlist=NULL,*trace,*clobber,*tmp_ptr,*vtlist=NULL; 
  struct Vertlist *vlptr=NULL,*cvptr=NULL,*vtrace,*facelist=NULL;
  struct Edgelist *elptr=NULL,*ceptr=NULL,*etrace,*heptr,*getptr;
  struct RedList *rtrace,*hold;
  XPoint *Xptr;
  extern XPoint *path_XPoints();

  pK_ptr=p->packK_ptr;pR_ptr=p->packR_ptr;
  nextptr=lastptr=dpoint;
  *endptr=NULL;
  count=*hits=0;  
  if (*nextptr == '\0' || !grab_next(&nextptr,next)) return NULL;
  vertlist=(struct Vertlist *)calloc((size_t)1,sizeof(struct Vertlist));
  trace=vertlist;
  clobber=trace;
  /* note: trace points to newly allocated space, still without 
     data, clobber points (once we get started) to last data. */
  do
    {
      lastptr += notspace(lastptr);
/* 'all' specification */
      if (*next=='a') 
	{
	  lastptr++;
	  lastptr=lastptr+notspace(lastptr);
	  if (*lastptr!='(') /* run thru whole complex */
	    {v1=1;v2=p->nodecount;}
	  else if (!paren_parse(&lastptr,&v1,&v2) || v1>v2)
	    goto GETOUT;	/* malformed expression */
	  if (v1<1) v1=1;
	  if (v2>p->nodecount) v2=p->nodecount;
				/* now should have valid v1 and v2 */
	  if (lastptr>nextptr) nextptr=lastptr;
	  for (n=v1;n<=v2;n++)
	    {
	      trace->v=n;
	      trace->next=(struct Vertlist *)
		calloc((size_t)1,sizeof(struct Vertlist));
	      clobber=trace;
	      trace=trace->next;
	      count++;
	    }
	} /* finished with 'all' */
/* use Vlist or Elist */
      else if (strncmp(next+1,"list",4)==0) 
	{
	  if (((*next=='V' && (cvptr=(*Vlist) )) 
	       || (*next=='v' && (cvptr=p->vlist))))
	    {
	      if (*(next+5)=='[')
		{
		  if (*(next+6)=='r') /* rotate list */
		    {
		      vlptr=cvptr;
		      while (vlptr && vlptr->next) vlptr=vlptr->next;
		      vlptr->next=(struct Vertlist *)
			calloc((size_t)1,sizeof(struct Vertlist));
		      vlptr->next->v=cvptr->v;
		    }
		  if (*(next+6)=='n' || *(next+6)=='r')
		    {
		      j=consume_one_index(&cvptr);
		      if (*next=='V') (*Vlist)=cvptr;
		      else p->vlist=cvptr;
		    }
		  else if (sscanf(next+5,"[%d]",&n) && n>=0)
		    {
		      vlptr=cvptr;
		      while (n-- > 1 && vlptr->next)
			vlptr=vlptr->next;
		      if (n==0 && vlptr) j=vlptr->v;
		      else j=0;
		    }
		  else j=0;
		  if (j>0 && j<=p->nodecount ) 
		    {
		      trace->v=j;
		      trace->next=(struct Vertlist *)
			calloc((size_t)1,sizeof(struct Vertlist));
		      clobber=trace;
		      trace=trace->next;
		      count++;
		    }	
		  vlptr=(struct Vertlist *)NULL;
		}
	      else if (*next=='V') vlptr=(*Vlist); /* adjoint Vlist */
	      else if (*next=='v') vlptr=p->vlist; /* adjoint pack vlist */
	      while (vlptr && (n=vlptr->v)>0 && n<=p->nodecount)
		{
		  trace->v=n;
		  trace->next=(struct Vertlist *)
		    calloc((size_t)1,sizeof(struct Vertlist));
		  clobber=trace;
		  trace=trace->next;
		  vlptr=vlptr->next;
		  count++;
		}
	    }
	  if (((*next=='E' && (ceptr=*Elist )) 
	       || (*next=='e' && (ceptr=p->elist))))
	    {
	      if (*(next+5)=='[')
		{
		  if (*(next+6)=='r') /* rotate list */
		    {
		      elptr=ceptr;
		      while (elptr && elptr->next) elptr=elptr->next;
		      elptr->next=(struct Edgelist *)
			calloc((size_t)1,sizeof(struct Edgelist));
		      elptr->next->v=ceptr->v;
		      elptr->next->w=ceptr->w;
		    }
		  if (*(next+6)=='n' || *(next+6)=='r')
		    {
		      consume_one_edge(&ceptr,&v1,&v2);
		      if (*next=='E') (*Elist)=ceptr;
		      else p->elist=ceptr;
		    }
		  else if (sscanf(next+5,"[%d]",&j) && j>=0)
		    {
		      elptr=ceptr;
		      while (j-- > 1 && elptr->next)
			elptr=elptr->next;
		      if (j==0 && elptr)
			{
			  v1=elptr->v;
			  v2=elptr->w;
			}
		      else v1=0;
		    }
		  else v1=0;
		  if (v1>0 && v1<=p->nodecount 
		      && v2>0 && v2<=p->nodecount ) 
		    {
		      trace->v=v1;
		      trace->next=(struct Vertlist *)
			calloc((size_t)1,sizeof(struct Vertlist));
		      trace->next->v=v2;
		      trace->next->next=(struct Vertlist *)
			calloc((size_t)1,sizeof(struct Vertlist));
		      clobber=trace->next;
		      trace=trace->next->next;
		      count += 2;
		    }	
		  elptr=(struct Edgelist *)NULL;
		}
	      else if (*next=='E') elptr=(*Elist); /* adjoint Elist */
	      else if (*next=='e') elptr=p->elist; /* adjoint pack elist */
	      while (elptr && (v1=elptr->v)>0 && v1<=p->nodecount
		     && (v2=elptr->w)>0 && v2<=p->nodecount)
		{
		      trace->v=v1;
		      trace->next=(struct Vertlist *)
			calloc((size_t)1,sizeof(struct Vertlist));
		      trace->next->v=v2;
		      trace->next->next=(struct Vertlist *)
			calloc((size_t)1,sizeof(struct Vertlist));
		      clobber=trace->next;
		      trace=trace->next->next;
		      elptr=elptr->next;
		      count += 2;
		}
	    }
	}
/* boundary verts */
      else if (next[0]=='b') 
	{
	  lastptr++;
	  lastptr=lastptr+notspace(lastptr);
	  if (*lastptr!='(') /* run thru whole bdry */
	    {
	      for (j=1;j<=p->num_bdry_comp;j++)
		{
		  v1=p->bdry_starts[j];
		  v2=pK_ptr[v1].flower[pK_ptr[v1].num];
		  trace->v=v1;
		  trace->next=(struct Vertlist *)
		    calloc((size_t)1,sizeof(struct Vertlist));
		  clobber=trace;
		  trace=trace->next;
		  count++;
		  if (v2!=v1)
		    {
		      stopvert=pK_ptr[v2].flower[0];
		      nextvert=v1;
		      while 
			( (nextvert=pK_ptr[nextvert].flower[0]) 
			  != stopvert )
			{
			  trace->v=nextvert;
			  trace->next=(struct Vertlist *)
			    calloc((size_t)1,sizeof(struct Vertlist));
			  clobber=trace;
			  trace=trace->next;
			  count++;
			}
		    }
		}
	    } /* end whole bdry case */
	  else if (!paren_parse(&lastptr,&v1,&v2)
		   || v1<1 || v1>p->nodecount 
		   || v2<1 || v2>p->nodecount 
		   || !pK_ptr[v1].bdry_flag 
		   || !pK_ptr[v2].bdry_flag )
	    goto GETOUT; /* malformed expression */
	  else 
	    {
	      /* now should have valid v1 and v2 */
	      trace->v=v1;
	      trace->next=(struct Vertlist *)
		calloc((size_t)1,sizeof(struct Vertlist));
	      clobber=trace;
	      trace=trace->next;
	      count++;
	      if (v2==v1) 
		v2=pK_ptr[v1].flower[pK_ptr[v1].num];
	      stopvert=pK_ptr[v2].flower[0];
	      nextvert=v1;
	      while ( (nextvert=pK_ptr[nextvert].flower[0]) 
		      != stopvert && count < p->nodecount)
		{
		  trace->v=nextvert;
		  trace->next=(struct Vertlist *)
		    calloc((size_t)1,sizeof(struct Vertlist));
		  clobber=trace;
		  trace=trace->next;
		  count++;
		}
	    } /* end (v1,v2) case */
	  if (lastptr>nextptr) nextptr=lastptr;
	} /* finished with boundary case */
/* hex-extended edge lists: caution, assume rest of input 
   string specifies edges; resets nextptr */
      else if (*next=='e') 
	{
	  lastptr++;
	  lastptr=lastptr+notspace(lastptr);
	  if ((elptr=Node_pair_link(p,lastptr,endptr,hits,Vlist,Elist,Flist,
				    region,pathlist,pathlength)))
	    {
	      nextptr=*endptr;
	      etrace=elptr;
	      while (etrace) /* expand pairs into hex-extended edge
				sublist */
		{
		  heptr=etrace->next;
		  if ((getptr=get_extended_edge(p,etrace->v,etrace->w,256))
		      && getptr->next)
		    {
		      *etrace=*getptr; /* throw out old, put in beginning
					  of new sublist */
		      while(getptr->next) getptr=getptr->next;
		      getptr->next=heptr;
		    }
		  etrace=heptr;
		}

	      etrace=elptr;
	      while (etrace && (v1=etrace->v) && (v2=etrace->w))
		{
		  if (v1!=clobber->v)
		    {
		      trace->v=v1;
		      trace->next=(struct Vertlist *)
			calloc((size_t)1,sizeof(struct Vertlist));
		      clobber=trace;
		      trace=trace->next;
		      count++;
		    }
		  if (v2!=clobber->v)
		    {
		      trace->v=v2;
		      trace->next=(struct Vertlist *)
			calloc((size_t)1,sizeof(struct Vertlist));
		      clobber=trace;
		      trace=trace->next;
		      count++;
		    }
		  etrace=etrace->next;
		}
	      edge_free(&elptr);
	    }
	}
/* bounding faces: for each indicated face, adjoin 4-vertex 
   closed chain of its vertices in positive orientation. 
   Caution: rest of data string assumed to define faces;
   nextptr is reset. */
      else if (*next=='f')
	{
	  lastptr++;
	  if ((facelist=Face_link_parse(p,lastptr,endptr,&hts,Vlist,
					Elist,Flist,region,pathlist,
					pathlength)))
	    {
	      nextptr=*endptr;
	      vtrace=facelist;
	      while(vtrace)
		{
		  for (j=0;j<4;j++)
		    {
		      vert=p->faces[vtrace->v].vert[j%3];
		      trace->v=vert;
		      trace->next=(struct Vertlist *)
			calloc((size_t)1,sizeof(struct Vertlist));
		      clobber=trace;
		      trace=trace->next;
		      count++;
		    }
		  vtrace=vtrace->next;
		}
	      vert_free(&facelist);
	    }

	}
/* interior */
      else if (*next=='i') 
	{
	  lastptr++;
	  lastptr=lastptr+notspace(lastptr);
	  if (*lastptr!='(') /* run thru whole complex */
	    {v1=1;v2=p->nodecount;}
	  else if (!paren_parse(&lastptr,&v1,&v2) || v1>v2)
	    goto GETOUT; /* malformed expression */
	  if (v1<1) v1=1;
	  if (v2>p->nodecount) v2=p->nodecount;
	  if (lastptr>nextptr) nextptr=lastptr;
				/* reaching here, should have v1 and v2 */
	  for (n=v1;n<=v2;n++)
	    if (!pK_ptr[n].bdry_flag)
	      {
		trace->v=n;
		trace->next=(struct Vertlist *)
		  calloc((size_t)1,sizeof(struct Vertlist));
		clobber=trace;
		trace=trace->next;
		count++;
	      }
	} 
/* marked */
      else if (*next=='m') 
	{
	  qcount=0;
	  if ((cflg=(next[1]=='c'))) lastptr++; 
				/* 1==>complement of marked */
	  if (next[1]=='p' || (cflg && next[2]=='p') )
				/* take marking from pack q */
	    {
	      lastptr++;
	      if (next[1]=='p') phold[0]=next[2];
	      else phold[0]=next[3];
	      q=atoi(phold);
	      if (q>=0 && packdata[q].status) 
		{
		  lastptr++;
		  q_flag=1;
		  qK_ptr=packdata[q].packK_ptr;
		  qcount=packdata[q].nodecount;
		}
	      else q_flag=0;
	    }
	  else q_flag=0;				
	  lastptr++;
	  lastptr=lastptr+notspace(lastptr);
	  if (*lastptr!='(') /* run thru whole complex */
	    {v1=1;v2=p->nodecount;}
	  else if (!paren_parse(&lastptr,&v1,&v2) || v1>v2)
	    goto GETOUT; /* malformed expression */
	  if (v1<1) v1=1;
	  if (v2>p->nodecount) v2=p->nodecount;
	  if (lastptr>nextptr) nextptr=lastptr;
				/* now should have valid v1 and v2 */
	  for (n=v1;n<=v2;n++)
	    if ( (!cflg && !q_flag && pK_ptr[n].mark) 
		 || (cflg && !q_flag && !pK_ptr[n].mark) 
		 || (!cflg && q_flag && n<=qcount
		     && qK_ptr[n].mark)
		 || (cflg && q_flag && n<=qcount
		     && !qK_ptr[n].mark) )
	      {
		trace->v=n;
		trace->next=(struct Vertlist *)
		  calloc((size_t)1,sizeof(struct Vertlist));
		clobber=trace;
		trace=trace->next;
		count++;
	      }
	} 
/* curly bracketed stuff */
      else if (*next=='{')
	{
	  tmp_ptr=brace_parse(p,lastptr,&cf_flag,&lastptr,packdata);
	  if (tmp_ptr!=NULL) /* fit into growing list */
	    {
	      if (vertlist==trace) vertlist=tmp_ptr;
	      free(trace);
	      clobber=tmp_ptr;
	      count++;
	      while (clobber->next!=NULL)
		{
		  count++;
		  clobber=clobber->next;
		}
	      clobber->next=(struct Vertlist *)
		calloc((size_t)1,sizeof(struct Vertlist));
	      trace=clobber->next;
	    }
	}
/* certers inside specified disc; Caution: must be at end of data string. */
      else if (*next=='D')
	/* must have structured data following D:
	   EITHER v <n> for center vertex OR c <x y> for
	   complex center AND r <x> for radius of disc. */
	{
	  done=qcount=3; /* 1-bit for center, 2-bit for radius */
	  while (qcount && done>0 && done<16)
	    {
	      qcount--;
	      if ((done & 1) && (ptr=after_char(nextptr,"v")))
		/* use center of vert */
		{

		  /* fixup: put recursive call to Node_link_parse
		     here so we can specify v with more general
		     calls (like "v" for active). See mend_call. */

		  if (!grab_next(&ptr,next) || !(vtlist=
		      Node_link_parse(p,next,&edptr,&hts,Vlist,Elist,Flist,
				      region,pathlist,pathlength)))
		    done = 16; /* some error */
		  else
		    {
		      done -= 1;
		      vert=vtlist->v;
		      vert_free(&vtlist);
		      ctr=p->packR_ptr[vert].center;
		    }
		}
	      if ((done & 1) && (ptr=after_char(nextptr,"c"))) 
		/* give x,y coords for center */
		{
		  if (sscanf(ptr,"%lf %lf",&ctr.re,&ctr.im)!=2)
		    done=16; /* some error */
		  else done -= 1;
		}
	      if ((ptr=after_char(nextptr,"r"))) /* radius */
		{
		  if (!sscanf(ptr,"%lf",&rad) || rad<m_toler
		      || (p->hes>0 && rad>0.25))
		    done=16; /* error */
		  else
		    {
		      done -= 2;
		      if (p->hes>0) rad *= M_PI;
		    }
		}
	    } /* end of while */
	  if (!done) /* okay, got both center and radius */
	    {
	      qcount=0;
	      for (i=1;i<=p->nodecount;i++)
		if ((p->hes<0 
		     && (dist=h_dist(p->packR_ptr[i].center,ctr,0))>=0
		     && dist<=rad)
		    || (p->hes>0 
			&& (dist=s_dist(p->packR_ptr[i].center,ctr))<=rad)
		    || (p->hes==0 
			&& (dist=cAbs(csub(p->packR_ptr[i].center,ctr)))<=rad))
		  {
		    trace->v=i;
		    trace->next=(struct Vertlist *)
		      calloc((size_t)1,sizeof(struct Vertlist));
		    clobber=trace;
		    trace=trace->next;
		    qcount++;
		  }
	      if (qcount) /* some vertices found */
		count++;
	    }
	  while (grab_next(&nextptr,next)); /* toss rest of dpoint data */
	}
	  
/* inside x-y-path (same side as alpha) */
      else if (*next=='g' && p->hes<okerr && pathlist) 
	{
	  tmpverts=(int *)calloc((size_t)(p->nodecount+1),sizeof(int));
	  length=pathlength;
	  Xptr=path_XPoints(p->screen,pathlist,&length);
	  (*region)=XPolygonRegion(Xptr,length,WindingRule);
	  free(Xptr);
	  for (i=1;i<=p->nodecount;i++)
	    if (path_wrap(p,pR_ptr[i].center))
	      tmpverts[i]=1;
	  XDestroyRegion(*region);
	  if (!tmpverts[p->alpha]) /* alpha in complement */
	    for (i=1;i<=p->nodecount;i++)
	      {
		if (tmpverts[i]) tmpverts[i]=0;
		else tmpverts[i]=1;
	      }
	  for (i=1;i<=p->nodecount;i++)
	    if (tmpverts[i])
	      {
		trace->v=i;
		trace->next=(struct Vertlist *)
		  calloc((size_t)1,sizeof(struct Vertlist));
		clobber=trace;
		trace=trace->next;
		count++;
	      } 
	  free(tmpverts);
	} /* finished with g */

/* 'inside' edge-path. Caution: recursive call; rest of input
   string assumed to be list of verts as edge-path; nextptr reset.
   Return list of vertices 'inside' that edge-path.
   To designate 'inside', look down list until 2 form an edge 
   with vert v on its left NOT in list; otherwise, v is first
   vert NOT in list. v is taken as seed, return connected
   component of verts NOT in the list and containing v.
   Note: intended to be like 'g' option, only we have an
   edge-path instead of an xy-path. */
      else if (*next=='w')
	{
	  lastptr++;
	  if ((vlptr=Node_link_parse(p,lastptr,endptr,&hts,Vlist,Elist,
				     Flist,region,pathlist,pathlength)))
	    {
	      nextptr=*endptr;
	      vert=0;
	      for (i=1;i<=p->nodecount;i++) pK_ptr[i].util_flag=0;
	      tmp_ptr=vlptr;
	      while (tmp_ptr) 
		{
		  pK_ptr[tmp_ptr->v].util_flag=-1;
		  tmp_ptr=tmp_ptr->next;
		}
	      tmp_ptr=vlptr;
	      while (!vert && tmp_ptr && tmp_ptr->next) 
		/* search for seed by looking at successive verts
		   in list; if they are nghbs and to left is not
		   in list, then done. */
		{
		  v1=tmp_ptr->v;
		  v2=tmp_ptr->next->v;
		  tmp_ptr=tmp_ptr->next;
		  j=nghb(p,v1,v2);
		  if (j>=0 && (!pK_ptr[v1].bdry_flag || j<pK_ptr[v1].num))
		    {
		      nextvert=pK_ptr[v1].flower[(j+1)%(pK_ptr[v1].num)];
		      if (!pK_ptr[nextvert].util_flag)
			vert=nextvert;
		    }
		} 
	      vert_free(&vlptr);
	      if (!vert) /* still didn't find a seed; take first
			    vert not in vlptr list */
		{
		  j=1;
		  while (!vert && j<=p->nodecount)
		    if (!pK_ptr[j++].util_flag) vert=j-1;
		}
	      if (vert) /* finally found a seed; now used linked
			   lists to find component. */
		{
		  pK_ptr[vert].util_flag=1;
		  trace->v=vert;
		  trace->next=(struct Vertlist *)
		    calloc((size_t)1,sizeof(struct Vertlist));
		  clobber=trace;
		  trace=trace->next;
		  count++;

		  vlptr=(struct Vertlist *) 
		    calloc((size_t)1,sizeof(struct Vertlist));
		  vlptr->v=vert;
		  while (vlptr)
		    {
		      vtlist=vlptr; /* process old list */
		      vlptr=vtrace=(struct Vertlist *) /* create new list */
			calloc((size_t)1,sizeof(struct Vertlist));
		      do
			{
			  n=vtlist->v;
			  for (i=0;i<=pK_ptr[n].num;i++)
			    if (!pK_ptr[(j=pK_ptr[n].flower[i])].util_flag)
			      {
				pK_ptr[j].util_flag=1;
				trace->v=j;
				trace->next=(struct Vertlist *)
				  calloc((size_t)1,sizeof(struct Vertlist));
				clobber=trace;
				trace=trace->next;
				count++;
				vtrace=vtrace->next=(struct Vertlist *)
				  calloc((size_t)1,sizeof(struct Vertlist));
				vtrace->v=j;
			      }
			  tmp_ptr=vtlist;
			  vtlist=vtlist->next;
			  free(tmp_ptr);
			} while (vtlist);
		      tmp_ptr=vlptr;
		      vlptr=vlptr->next; /* first position was empty */
		      free(tmp_ptr);
		    }
		}
	    }
	} /* finished with w */
/* max circle index */
      else if (*next=='M') 
	{
	  trace->v=p->nodecount;
	  trace->next=(struct Vertlist *)
	    calloc((size_t)1,sizeof(struct Vertlist));
	  clobber=trace;
	  trace=trace->next;
	  count++;
	}
/* list of circles on outside of red chain */
      else if (*next=='r' && (rtrace=p->redfaces))
	{
	  if (!p->redfaces->next_edge)
	    {
	      rtrace=rtrace->next;
	      while (!rtrace->next_edge && rtrace!=p->redfaces) 
		trace=trace->next;
	      if (rtrace==p->redfaces) rtrace=NULL;
	    }
	  if (rtrace->next_edge)
	    {
	      hold=rtrace;
	      trace->v=p->faces[rtrace->face].vert[rtrace->v_flag];
	      trace->next=(struct Vertlist *)
		calloc((size_t)1,sizeof(struct Vertlist));
	      clobber=trace;
	      trace=trace->next;
	      count++;
	      while ((rtrace=rtrace->next_edge)!=hold)
		{
		  trace->v=p->faces[rtrace->face].vert[rtrace->v_flag];
		  trace->next=(struct Vertlist *)
		    calloc((size_t)1,sizeof(struct Vertlist));
		  clobber=trace;
		  trace=trace->next;
		  count++;
		}
	    }
	}
/* plot_flag not set? */
      else if (*next=='x') 
	{
	  for (n=1;n<=p->nodecount;n++)
	    if (!p->packK_ptr[n].plot_flag)
	      {
		trace->v=n;
		trace->next=(struct Vertlist *)
		  calloc((size_t)1,sizeof(struct Vertlist));
		clobber=trace;
		trace=trace->next;
		count++;
	      }
	}
/* active node */
      else if (*next=='v') 
	{
	  if ((n=p->active_node)>0 && n <= p->nodecount)
	    {
	      trace->v=n;
	      trace->next=(struct Vertlist *)
		calloc((size_t)1,sizeof(struct Vertlist));
	      clobber=trace;
	      trace=trace->next;
	      count++;
	    }
	}
/* just an ordinary vertex number */ 
      else if (sscanf(next,"%d",&v1) && v1>0 && v1<=p->nodecount)
	{
	  trace->v=v1;
	  trace->next=(struct Vertlist *)
	    calloc((size_t)1,sizeof(struct Vertlist));
	  clobber=trace;
	  trace=trace->next;
	  count++;
	}
/* inappropriate entry */
      else goto GETOUT;   

      stripsp(nextptr);
      lastptr=nextptr;
    }
  while (*nextptr!='-' && grab_next(&nextptr,next));
  *endptr=nextptr;
 GETOUT: /* clean up and leave */
  *hits=count;
  if (trace!=clobber) 
    {
      clobber->next=NULL; /* clobber should be last valid data */
      free(trace);trace=NULL;
    }
  if (!count) /* no data; should have trace=clobber=vertlist */
    {
      free(trace);
      return NULL;
    }
  return vertlist;
} /* Node_link_parse */

int grab_one_vert(struct p_data *p,char **ptr)
     /* shortcut to grab first legel vertex in ptr, advance ptr.
Return 0 on error or no data. */
{
  int v,hits;
  char next[256],*endptr;
  struct Vertlist *vlist=NULL;

  if (!grab_next(ptr,next) 
      || !(vlist=Node_link_parse(p,next,&endptr,&hits,&Vlist,&Elist,&Flist,
				 &region,pathlist,pathlength)))
    return 0;
  v=vlist->v;
  vert_free(&vlist);
  return v;
} /* grab_one_vert */
  
