/* cp_cmd.c  to parse and call routines specified by command-line or
mouse-selected text. */

#include "cp_head.h"

extern Menu_item brush_m_item;
static char buff[BUFSIZE],cmd[2*BUFSIZE],data[2*BUFSIZE],next[BUFSIZE];

int sort_cmd(char *cmd_stream,int *targ_p)
/* pick off individual commands in a stream. Apply to pack targ_p. 
Return 1 if at least one parsing succeeded. Note: can have nested calls 
to this when executing named script cmds. */
{
  int count=0,flag=0,n;
  char *command,local_stream[BUFSIZE],*token_ptr;

  strncpy(local_stream,cmd_stream,BUFSIZE-1);
  local_stream[BUFSIZE-1]='\0';
  token_ptr=local_stream;
  while (*(token_ptr)==';' || *(token_ptr)==' ') token_ptr++;
  stripsp(token_ptr);
  if ( (n=strcspn(token_ptr,";"))>0)
    {
      /* get first command. fixup: command might be just white space */
      command=token_ptr;
      /* position pointer for next command */
      token_ptr += n;
      if (*(token_ptr)==';') 
	{
	  *(token_ptr)='\0';
	  token_ptr += 1;
	  stripsp(token_ptr);
	}
      while (*(token_ptr)==';' || *(token_ptr)==' ') token_ptr++;
      /* process first command */
      stripsp(command);
      if ( (flag=count=(handle_cmd(command,targ_p)!=0) ) 
	   && *command!='!' && !cmd_search_depth) 
	strcpy(cmd_history,command);
      while ( flag && (n=strcspn(token_ptr,";"))>0 )
	{
	  flag=0;
	  /* get current command */
	  command=token_ptr;
	  /* position pointer for next command */
	  token_ptr += n;
	  if (*(token_ptr)==';') 
	    {
	      *(token_ptr)='\0';
	      flag=1;
	      token_ptr += 1;	      
	      stripsp(token_ptr);
	    }
	  while (*(token_ptr)==';' || *(token_ptr)==' ') token_ptr++;
	  /* process current command */
	  stripsp(command);
	  if (!handle_cmd(command,targ_p))
	    {
	      flag=0;
	      continue;
	    }
	  if (!cmd_search_depth && *command!='!')
	    {
	      if (count) 
		{
		  strcat(cmd_history,";");
		  strcat(cmd_history,command);
		}
	      else strcpy(cmd_history,command);
	    }
	  count++;
	} /* end of while */
    }
  sprintf(msgbuf," (%d cmds)",count);
  msg();
  return count;
} /* sort_cmd */

int handle_cmd(char *command,int *targ_p)
/* takes care of a single command only */
{
  int pnum,count,hflag=0,i;
  char *dpoint;
	
  if (*targ_p<0 || *targ_p>=NUM_PACKS) *targ_p=current_p;
  stripsp(command);
  dpoint=command;
  if (!grab_next(&dpoint,cmd)) return 0; /* command was empty */
  if (*dpoint==' ') dpoint++; /* should be a blank next */
  stripsp(dpoint);
  if (strncmp(dpoint,"-p",2)) pnum=*targ_p;
  else /* pack number is specified */
    {
      dpoint +=2;
      if (!grab_next(&dpoint,next) 
	  || (next[0]!='-' && strlen(next)>1)) return 0;
      if (next[0]=='a' || next[0]=='-') pnum=current_p;
      else if ((i=atoi(next))>=0 && i<NUM_PACKS) pnum=i;
      else return 0; /* no pack specified */
    }
  strcpy(data,dpoint); /* rest is data */
  stripsp(data);
  if ((count=parse_cmd(&packdata[pnum],&hflag,targ_p)) && hflag)
    /* if hflag is set, put cmd in history */
    {
      sprintf(buf,"%s -p%d %s\n",cmd,pnum,data); 
      hmsg(buf);
    }
  return count;
} /* handle_cmd */

int parse_cmd(struct p_data *p,int *hflag,int *targ_p)
 /* set hflag to 1 to put this command (assuming successful) 
into the history file. targ_p is the target packing, passed through 
from sort_cmd in case sort_cmd is called recursively. */
{
  int v,w,p1,spec_num,i=0,count=0,vert,n;
  int pass,d,j,hits,pnum=pack_num(p);
  char *dpoint,*nextpoint,*endptr;
  char filename[NAME_MAX],named_cmd[32];
  double radius,factor,ang,dum,x,y;
  struct Vertlist *vertlist,*trace;
  struct Edgelist *holde;
  struct Vertlist *holdv;
  complex ctr,a;
  Rect rect;
  Mobius *newMob;

  dpoint=data;

  /* UNLOCKED cases (locked packings skip these commands) */

  if (!p->locks)
    {

      switch (cmd[0]) /* unlocked, either GUI or cmd mode */
	{
case 'a':
 {
				/* ============ add barycenter ======== */
   if (!strncmp(cmd,"add_b",5))
     {
       return (*hflag=add_barys(p,data));
     }
   
				/* ============ add circle ============ */
   if (!strncmp(cmd,"add_cir",7))
     {
       return (*hflag=add_circles_call(p,data));
     }
				/* ========= add vert to edge =========== */
   if (!strncmp(cmd,"add_e",5))
     {
       return (*hflag=split_flips(p,data,1));
     }
				/* ========== add generations ======= */
   if (!strncmp(cmd,"add_gen",7))
     {
       if (sscanf(data,"%d %d",&n,&d)!=2 
	   || n<1 || d<3 || d>MAX_PETALS) return 0;
       j=1;
       for (i=1;i<=n;i++)
	 {
	   if (!p->num_bdry_comp)
	     {
	       sprintf(msgbuf,"No boundary component "
		       "for 'add_gen'.");
	       emsg();
	       goto BREAK_OUT;
	     }
	   else for (j=1;j<=p->num_bdry_comp;j++)
	     {
	       count += add_layer(p, 
				  p->bdry_starts[j],
				  p->bdry_starts[j],d,&hits);
	       j *= hits;
	     }
	 }
     BREAK_OUT: 
       if (!j)
	 {
	   sprintf(msgbuf,"add_gen: Some circles "
		   "exceeded %d degree.",d);
	   emsg();
	 }
       return (*hflag=count);		
     }
				/* ========== add ideal vertex ======= */
   if (!strncmp(cmd,"add_ideal",9))
     {
       if ( p->num_bdry_comp==1  /* only 1 bdry comp? */
	    && (v=p->bdry_starts[1])>0 
	    && v<=p->nodecount 
	    && p->packK_ptr[v].bdry_flag );
       else if (sscanf(data,"%d",&v)!=1 || v < 1 
		|| v>p->nodecount 
		|| !p->packK_ptr[v].bdry_flag)
	 return 0;
       if (!ideal_bdry_node(p,v)) return 0;
       choose_alpha(p);
       choose_beta(p);
       complex_count(p,FALSE);
       facedraworder(p,0);
       set_aim_default(p);
       return 1;
     }
				/* ============== add layers ========== */
   if (!strncmp(cmd,"add_lay",7))
     {
       if (sscanf(data,"%d %d %d",&v,&w,&d)!=3
	   || d<3 || d>MAX_PETALS 
	   || !p->packK_ptr[v].bdry_flag
	   || !p->packK_ptr[w].bdry_flag) return 0;
       if (w==v) v=p->packK_ptr[w].flower[0];
       j=add_layer(p,v,w,d,&hits);
       if (!hits)
	 {
	   sprintf(msgbuf,"add_layer: Some circles "
		   "exceeded %d degree.",
		   d);
	   emsg();
	 }
       return (*hflag=j);
     }
				/* ============= set alpha ========== */
   if (!strncmp(cmd,"alpha",5) )
     {
       if ((holdv=node_link_parse(p,data,&endptr,&hits))!=NULL)
	 {
	   v=holdv->v;
	   vert_free(&holdv);
	   return (set_alpha(p,v));
	 }
       else return 0;
     }
   break;
 }
case 'b':
 {
				/* ============== set beta =========== */
   if (!strncmp(cmd,"beta",4) )
     {
       if (sscanf(data,"%d",&vert)==1) 
	 return (set_beta(p,vert));
       else return 0;
     }
   break;
 }
case 'c':
 {
				/* ============== cir_invert ======= */
   if (!strncmp(cmd,"cir_invert",10))
     {
       return (*hflag=cir_invert_call(p,data));
     }
				/* ============== compute: centers ======= */
   if (!strncmp(cmd,"compute_cent",12))
     {
       return (comp_pack_centers(p,0,0,2,okerr));
     }
				/* ============== cookie cutting ======= */
   if (!strncmp(cmd,"cookie",6))
     {
       return (*hflag=cookie_call(p,data));
     }
   break;
 }
case 'd':
 {
				/* ============== double ========== */
   if (!strncmp(cmd,"double",12))
     {
       if (!double_K(p,data))
	 {
	   sprintf(msgbuf,"doubling failed.");
	   emsg();
	   return 0;
	 }
       else return (*hflag=1);
     }
   break;
 }
case 'e':
 {
				/* ============ enclose ============ */
   if (!strncmp(cmd,"enclose",7))
     {
       if ((*hflag=enfoldcall(p,data))) return 1;
       return 0;
     }
				/* ========== e_to_h (outdated) ======== */
   if (!strncmp(cmd,"e_to_h",6))
     {
       if (p->hes<0)
	 {strcpy(msgbuf,"Pack is already hyperbolic.");
	 emsg();return 1;}
       geom_to_h_call(p,data);
       return (*hflag=1);
     }
				/* ========== e_to_s (outdated) ========== */
   if (!strncmp(cmd,"e_to_s",6))
     {
       if (p->hes>0)
	 {strcpy(msgbuf,"Pack is already spherical.");emsg();return 1;}
       geom_to_s_call(p,data);
       return (*hflag=1);
     }
   break;
 }
case 'F':
 {
				/* ==== redo all housekeeping ======== */
   if (!strncmp(cmd,"Fix",3))
     {
       return (*hflag=fix_call(p," -F"));
     }
   break;
 }
case 'f':
 {
				/* == fix: comp centers and-or ang sums === */
   
   if (!strncmp(cmd,"fix",3))
     {
       return (*hflag=fix_call(p,data));
     }
				/* ============= flat_hex ========= */
   if (!strncmp(cmd,"flat_h",6))
     {
       return (*hflag=flat_hex(p,data));
     }
				/* ============= flip edge ========= */
   if (!strncmp(cmd,"flip",4))
     {
       return (*hflag=split_flips(p,data,2));
     }
   break;
 }
case 'g':
 {
                                /* ========== gen_cut ================ */
   if (!strncmp(cmd,"gen_cut",7))
     {
       return (*hflag=gen_cut_call(p,data));
     }
   
				/* ========== geom_to_h ================ */
   if (!strncmp(cmd,"geom_to_h",9))
     {
       if (p->hes<0)
	 {strcpy(msgbuf,"Pack is already hyperbolic.");emsg();return 1;}
       geom_to_h_call(p,data);
       return (*hflag=1);
     }
				/* ========== geom_to_s ================ */
   if (!strncmp(cmd,"geom_to_s",9))
     {
       if (p->hes>0)
	 {strcpy(msgbuf,"Pack is already spherical.");emsg();return 1;}
       geom_to_s_call(p,data);
       return (*hflag=1);
     }
				/* ========== geom_to_e ======== */
   if (!strncmp(cmd,"geom_to_e",9))
     {
       if (p->hes==0)
	 {strcpy(msgbuf,"Pack is already euclidean.");emsg();return 1;}
       geom_to_e_call(p,data);
       return (*hflag=1);
     }
   break;
 }
case 'h':
 {
				/* ========== h_to_e (outdated) ======== */
   if (!strncmp(cmd,"h_to_e",6))
     {
       if (p->hes==0)
	 {strcpy(msgbuf,"Pack is already euclidean.");emsg();return 1;}
       geom_to_e_call(p,data);
       return (*hflag=1);
     }
				/* ============ hex_refine ======== */
   if (!strncmp(cmd,"hex_refine",10))
     {
       if ((*hflag=hex_refine(p))) return 1;
       return 0;
     }
				/* ============ hex_walk ======== */
   if (!strncmp(cmd,"hex_walk",8))
     {
       if (sscanf(data,"%d %d %d",&v,&w,&n)!=3) 
	 {strcpy(msgbuf,"Usage: hex_walk v w n");emsg();return 0;}
       if ((*hflag=hex_parallel_call(p,v,w,n,&a,1))) 
	 {
	   sprintf(msgbuf,"hex_walk: pack %d modulus = %f+i%f; "
		   "abs val = %f",
		   pnum,a.re,a.im,cAbs(a));
	   msg();
	   return 1;
	 }
       return 0;
     }
   break;
 }
case 'i':
 {
				/* ========== increment rad ========== */
   if (!strncmp(cmd,"inc_rad",7))
     {
       factor=inc_factor;
       return (crement_radii(p,factor,data));
     }
				/* ========== infile_read ========== */
   if (!strncmp(cmd,"infile_read",11))
     {
       return (read_infile(p,data));
     }
   break;
 }
case 'j':
 {
				/* ========== j_ftn ============= */
   if (!strncmp(cmd,"j_ftn",5))
     {
       return (*hflag=(j_ftn_call(p,data)>0));
     }
   break;
 }
case 'm':
  {
				/* ========== max_pack ============= */
    if (!strncmp(cmd,"max_p",5))
      {
	return (max_pack(p,data));
      }
				/* ============ mend ============== */
    if (!strncmp(cmd,"mend",4) )
      {
	return (*hflag=mend_call(p,data));
      }
				/* ===== molify_centers ============= */
    if (!strncmp(cmd,"molify_cent",11))
      {
	return (molify_call(p,data));
      }
    break;
  }
case 'M':
 {
				/* ========== Mobius_inv ============= */
   if (!strncmp(cmd,"Mobius_inv",10))
     {
       return (apply_Mobius(p,data,-1,Mob));
     }
				/* ========== Mobius ============= */
   if (!strncmp(cmd,"Mobius",6))
     {
       return (apply_Mobius(p,data,1,Mob));
     }
   break;
 }
case 'N':
 {
				/* ========== NSpole ============= */
   if (!strncmp(cmd,"NSpole",6))
     {
       return (NSpole_call(p,data));
     }
   break;
 }
case 'n':
 {
 				/* ========== norm_scale =========== */
   if (!strncmp(cmd,"norm_scale",10))
     {
       norm_scale_call(p,data);
       return 1;
     }
   break;
 }
case 'p':
 {
 				/* =========== pfacered ============ */
   if (!strncmp(cmd,"pfacered",8))
     {
       return (pfacered(p));
     }	
				/* =========== poison ============ */
   if (!strncmp(cmd,"poison",6))
     {
       set_poison(p,data);
       return 1;
     }
   				/* =========== pre_flip ============ */
   if (!strncmp(cmd,"pre_flip",8))
     {
       if (r_flip) {free(r_flip);r_flip=NULL;}
       if (b_flip) {free(b_flip);b_flip=NULL;}
       b_flip=(struct Edgelist *)
	 calloc(1,sizeof(struct Edgelist));
       b_flip->v=b_flip->w=0;
       sprintf(msgbuf,"Choose vertices to 'flip' with left-mouse");
       msg();
       return 1;
     }
				/* =========== puncture ============ */
   if (!strncmp(cmd,"puncture",8))
     {
       return (puncture_call(p,data));
     }
   break;	
 }
case 'r':
 {
				/* ====== read = Caution, no confirm === */
   if (!strncmp(cmd,"read",4) && strncmp(cmd,"read_p",6))
     {
       if (sscanf(data,"%s",filename)!=1) return 0; /* blank */
       set_packing_path();
       strcpy(buff,path);
       strcat(buff,filename);
       strcpy(filename,buff); /* now have full pathname */
       return (*hflag=readcall(p,filename));
     }
				/* ========= reorient ======= */
   if (!strncmp(cmd,"reorient",8))
     {
       return (*hflag=reverse_orient_call(p));
     }		
				/* ========== repack ======== */
   if (!strncmp(cmd,"repack",6))
     {
       stripsp(data);
       nextpoint=data;
       pass=totalpasses;
       if (p->overlap_status) n=0; /* old repack routine */
       else n=1;
       while (grab_next(&nextpoint,next))
	 {
	   if (next[0]=='-')
	     {
	       if (next[1]=='v') /* just certain verts */
		 {
		   if ( (vertlist=node_link_parse(p,
			nextpoint,&endptr,&hits))!=NULL)
		     {
		       trace=vertlist;
		       do {
			 if (p->packR_ptr[trace->v].aim>=0)
			   {
			     if (p->hes<0)
			       h_riffle_vert(p,trace->v);
			     else if (p->hes==0)
			       e_riffle_vert(p,trace->v);
			     else if (p->hes>0)
			       s_riffle_vert(p,trace->v);
			     count++;
			   }
			 trace=trace->next;
		       } while (trace!=NULL);
		       vert_free(&vertlist);
		     }
		   else
		     {
		       if (p->hes<0) 
			 h_riffle_vert(p,p->active_node);
		       else if (p->hes==0)
			 e_riffle_vert(p,p->active_node);
		       else if (p->hes>0)
			 s_riffle_vert(p,p->active_node);
		       count++;
		     }
		   return (*hflag=count);
		 }
	       else if (next[1]=='n') n=1; /* superstep routine */
	       else if (p->hes==0 && next[1]=='t') n=2; /* superstep2 (eucl) */
	       else if (next[1]=='o') 
		 n=0; /* use old reliable routines */
	     }
	   else if (sscanf(next,"%d",&pass)!=1 || pass < 1 || pass > 100010)
	     pass = totalpasses;
	 } /* end of while */
       riffle_call(p,pass,1,n);
       return (*hflag=1);
     }
				/* ========= remove bdry circle ======== */
   if (!strncmp(cmd,"rm_cir",6))
     {
       return (*hflag=remove_circle(p,data));
     }		
				/* ============ remove edge ============ */
   if (!strncmp(cmd,"rm_edge",7))
     {
       if (sscanf(data,"%d %d",&v,&w)!=2) return 0;
       return (*hflag=remove_edge(p,v,w));
     }
				/* ============ remove quad vert ======== */
   if (!strncmp(cmd,"rm_quad",7))
     {
       return (*hflag=remove_quad_vert(p,data));
     }
   break;
 }
case 's':
 {
				/* ========== eucl scaling ====*/
   if (!strncmp(cmd,"scale",5))
     {
       if (!p->status) return 0;
       if (!strlen(data) || !sscanf(data,"%lf",&factor) 
	   || factor==0)
	 factor=eucl_factor;
       eucl_scale(p,factor);
       return (*hflag=1);
     }
				/* ========== seed ======== */
   if (!strncmp(cmd,"seed",4))
     {
       if (seed_start_call(p,data))
	 {
	   sprintf(buf,"seed -p%d %s\n",pnum,data); 
	   hmsg(buf);
	   return 1;
	 }
       else return 0;
     }
				/* ========== set_aim ======= */
   if (!strncmp(cmd,"set_aim",7))
     {
       return (*hflag=set_aim_call(p,data));
     }
				/* ============= set_overlaps ==========*/
   if (!strncmp(cmd,"set_over",8))
     {
       return (*hflag=set_overlapscall(p,data));
     }
				/* ========== set_radii ===== */
   if (!strncmp(cmd,"set_rad",7))
     {
       n=strcspn(data," ");
       strncpy(buf,data,n);
       *(buf+n)='\0';
       if (n==0 ||strpbrk(buf,".")==NULL 
	   || sscanf(buf,"%lf",&radius)!=1 ) 
	 {
	   strcpy(msgbuf,"Indicate doubleing point radius "
		  "first (with decimal pt).");
	   emsg();
	   return 0;
	 }
       if (p->hes>=0 && radius<=0)
	 {
	   strcpy(msgbuf,"Radius positive for eucl "
		  "and spherical packs.");
	   emsg();
	   return 0;
	 }
       return (*hflag=set_radii(p,radius,data+n+1));
     }
				/* ===== set_random radii/overlaps = */
   if (!strncmp(cmd,"set_rand",8))
     {
       return (*hflag=randize(p,data));
     }
				/* ========== set_center ===== */
   if (!strncmp(cmd,"set_center",7))
     {
       if (sscanf(data,"%lf %lf %d",&x,&y,&v)!=3 
	   || v<1 || v>p->nodecount)
	 {
	   strcpy(msgbuf,"Usage: x, y, v.");
	   emsg();
	   return 0;
	 }
       if (p->hes< 0 && (x*x+y*y)>=1.0)
	 {
	   strcpy(msgbuf,"Center must be in disc for "
		  "hyperbolic packs.");
	   emsg();
	   return 0;
	 }
       p->packR_ptr[v].center.re=x;
       p->packR_ptr[v].center.im=y;
       return (*hflag=1);
     }
				/* ========== slit ================= */
   if (!strncmp(cmd,"slit",4))
     {
       return (*hflag=slit_complex(p,data));
     }
				/* ========== special command ======== */
   if (!strncmp(cmd,"special",7))
     {
       if (!sscanf(cmd+7,"%d",&spec_num)) 
	 {
	   strcpy(msgbuf,"Can't read special number.");
	   emsg();
	   return 0;
	 }
       stripsp(data);
       if (*data=='\0') return 0; 
       if (spec_num==1) 
	 {
	   sprintf(buff,"%d ",pnum);
	   strcat(buff,data);
	   return (*hflag=special1(buff));
	 }
       if (spec_num==2) return (*hflag=special2(data));
       if (spec_num==3) return (*hflag=special3(data));
       if (spec_num==4) return (*hflag=special4(data));
       if (spec_num==5) return (*hflag=special5(data));
       if (spec_num==6) return (*hflag=special6(data));
       if (spec_num==7) return (*hflag=special7(data));
       if (spec_num==8) return (*hflag=special8(data));
       if (spec_num==9) return (*hflag=special9(data));
       else return 0;
     }
				/* ========== spiral ======== */
   if (!strncmp(cmd,"spiral",6))
     {
       return (*hflag=spiral_call(pnum,data) );
     }
				/* ==========  swap nodes ========== */
   if (!strncmp(cmd,"swap",4))
     {
       return (*hflag=swap_nodes_call(p,data));
     }
   break;
 }
case 'u':
 {
				/* ====== unflip ======= */
   if (!strncmp(cmd,"unflip",6))
     {
       return (*hflag=split_flips(p,data,3));
     }
   break;
 }
case 'v':
 {
				/* ====== vert_map_off ======= */
   if (!strncmp(cmd,"vert_map_off",12))
     {
       edge_free(&(p->vertex_map));
       return (1);
     }
   break;
 }
case 'w':
 {
				/* ====== weld =========== */
   if (!strncmp(cmd,"weld",4))
     {
       return (*hflag=weldcall(data));
     }
   break;
 }

	} /* end of unlocked switch */
    } /* end of if: unlocked only */



/* =======================================================
     LOCKED and UNLOCKED packings both go through here 
==========================================================*/

  if (!cmd_mode) /* only do if in GUI mode */
    {
      switch (cmd[0])
	{

case 'c':
 {
				/* ========= close various windows ====== */
   if (!cmd_mode && !strncmp(cmd,"close",5))
     {
       nextpoint=data;
       stripsp(data);
       if (!grab_next(&nextpoint,next)) {next[0]='s';next[1]='\0';}
       if (next[0]=='c') xv_set(cmd_frame,WIN_SHOW,FALSE,0);
       else if (next[0]=='h') xv_set(history_frame,WIN_SHOW,FALSE,0);
       else if (next[0]=='m') xv_set(msg_frame,WIN_SHOW,FALSE,0);
       else if (next[0]=='p') xv_set(setup_frame,WIN_SHOW,FALSE,0);
       else if (next[0]=='w') xv_set(text_frame,WIN_SHOW,FALSE,0); 
       else if (next[0]=='?') xv_set(help_frame,WIN_SHOW,FALSE,0);
       else if (next[0]=='d') xv_set(script_frame,WIN_SHOW,FALSE,0);
       else if (next[0]=='p') xv_set(setup_frame,WIN_SHOW,FALSE,0);
       else if (next[0]=='s' && next[1]=='m') 
	 {manip_frame_done_proc(manip_frame[pnum]);}
       else if (next[0]=='s' && next[1]=='p') 
	 xv_set(screen_frame[pnum],WIN_SHOW,FALSE,0);
       else if (next[0]=='s') canvas_life(pnum,0);
       else return 0;
       return 1;
     }
   break;
 }
case 'o':
 {
				/* ======= open various windows ===== */
   if (!cmd_mode && !strncmp(cmd,"open",4))
     {
       nextpoint=data;
       stripsp(data);
       if (!grab_next(&nextpoint,next)) {next[0]='s';next[1]='\0';}
       if (next[0]=='c') xv_set(cmd_frame,WIN_SHOW,TRUE,0);
       else if (next[0]=='h') xv_set(history_frame,WIN_SHOW,TRUE,0);
       else if (next[0]=='m') xv_set(msg_frame,WIN_SHOW,TRUE,0);
       else if (next[0]=='p') xv_set(setup_frame,WIN_SHOW,TRUE,0);
       else if (next[0]=='w') xv_set(text_frame,WIN_SHOW,TRUE,0); 
       else if (next[0]=='?') xv_set(help_frame,WIN_SHOW,TRUE,0);
       else if (next[0]=='d') xv_set(script_frame,WIN_SHOW,TRUE,0);
       else if (next[0]=='s' && next[1]=='m')
	 {
	   if ((int)xv_get(canvas_frame[pnum],WIN_SHOW)) 
	     {
	       frame_get_rect(canvas_frame[pnum],&rect);
	       xv_set(manip_frame[pnum],
		      WIN_X,(int)(rect.r_left+rect.r_width+5),
		      WIN_Y,(int)rect.r_top,WIN_SHOW,TRUE,0);
	     }
	 }
       else if (next[0]=='s' && next[1]=='p') 
	 {
	   if ((int)xv_get(canvas_frame[pnum],WIN_SHOW)) 
	     xv_set(screen_frame[pnum],WIN_SHOW,TRUE,0);
	 }
       else if (next[0]=='s') canvas_life(pnum,1);
       else return 0;
       return 1;
     }
   break;
 }
case 'w':
 {
                                /* =========== win_save ============= */
   if (!strncmp(cmd,"win_save",8))
     {
       return (*hflag=save_workspace());
     }
 }

	} /* end of switch: unlocked and GUI mode */
    } 

  switch (cmd[0]) /* ALL cmds go through here */
    {
case '[':
 {
				/* == exe named cmd in script file == */
   strncpy(named_cmd,cmd+1,30);
   named_cmd[31]='\0';
   n=strcspn(named_cmd,"]\0");
   if (named_cmd[n]!=']') return 0;
   named_cmd[n]='\0';
   if (exe_named_cmd(named_cmd,targ_p)) return 1;
   return 0;
   
 }
case 'a':
 {
				/* ========== active pack =========== */
   if (!strncmp(cmd,"act",3))
     {
       if (strlen(data) && sscanf(data,"%d",&n) 
	   && n>=0 && n<NUM_PACKS)
	 {chg_active_pack(n); *targ_p=n;return 1;}
       return 0;
     }
				/* ============ adjacency ============ */
   if (!strncmp(cmd,"adjac",5))
     {
       if ((*hflag=adjacency_call(p,data))) return 1;
       return 0;
     }
				/* ============ adjoin ============ */
   if (!strncmp(cmd,"adjoin",6))
     {
       if ((*hflag=adjoincall(data))) return 1;
       return 0;
     }
   break;
 }
case 'b':
 {
				/* ============ blend ============ */
   if (!strncmp(cmd,"blend",5))
     {
       if ((*hflag=blend_call(p,data))) return 1;
       return 0;
     }
   break;
 }
case 'c':
 {
				/* ============ center pt ============ */
   if (!strncmp(cmd,"center_point",12))
     {
       if (sscanf(data,"%lf %lf",&(ctr.re),&(ctr.im))!=2) return 0;
       return (center_point(p,ctr));
     }
				/* ============ center vert ============ */
   if (!strncmp(cmd,"center_vert",11))
     {
       if ((holdv=node_link_parse(p,data,&endptr,&hits))!=NULL)
	 {
	   v=holdv->v;
	   vert_free(&holdv);
	 }
       else v=p->active_node;
       return (center_point(p,p->packR_ptr[v].center));
     }
				/* ============ change directory ====== */
   if (!strcmp(cmd,"cd")) 
     {
       buf[0]='\0';
       stripsp(data);
       if (!strlen(data)) strcpy(next,"~\0");
       else sscanf(data,"%s",next);
       if (next[0]=='~') 
	 {
	   sprintf(buf,"%s/",home_dir);
	   next[0]=' ';
	   stripsp(next);
	 }
       strcat(buf,next);
       if (chdir(buf))
	 {
	   sprintf(msgbuf,"No directory %s.",buf);
	   emsg();
	 }
       getcwd(buf,BUFSIZE);
       working_dir=(char *)malloc((strlen(buf)+2)*sizeof(char));
       strcpy(working_dir,buf);
       sprintf(buf,"CirclePack (dir; %s)",working_dir);
       if (!cmd_mode) xv_set(base_frame,XV_LABEL,buf,0);
       return 1;
     }
   
				/* === set colors: circles/tris  ==== */
   if (!strncmp(cmd,"color",9))
     {
       nextpoint=data;
       stripsp(data);
       if (!grab_next(&nextpoint,next) || next[0]!='-') return 0;
       if (next[1]=='c') /* color circles */
	 {
	   data[0]=' ';data[1]=' ';
	   stripsp(data);
	   if (!strncmp(data,"bg",2)) 
	     return (color_circles(p,4,"\0"));
	   if (!strncmp(data,"fg",2)) 
	     return (color_circles(p,5,"\0"));
	   if (!strncmp(data,"rad",3))
	     return (color_circles(p,1,"\0"));
	   if (!strncmp(data,"-q",2)) /* compare to q */
	     {
	       *data=' ';*(data+1)=' ';
	       return (color_circles(p,3,data));
	     }
	   if (!strncmp(data,"-p",2)) /* copy from pack p */
	     {
	       *data=' ';*(data+1)=' ';
	       return (color_circles(p,7,data));
	     }
	   if (!strncmp(data,"-k",2)) /* by curvature */
	     {
	       *data=' ';*(data+1)=' ';
	       return (color_circles(p,8,data));
	     }
	   else return (color_circles(p,6,data));
	 }
       if (next[1]=='f') /* color faces */
	 {
	   data[0]=' ';data[1]=' ';
	   stripsp(data);
	   if (!strncmp(data,"bg",2)) 
	     return (color_faces(p,4,"\0"));
	   if (!strncmp(data,"fg",2)) 
	     return (color_faces(p,5,"\0"));
	   if (!strncmp(data,"area",3))
	     return (color_faces(p,1,"\0"));
	   if (!strncmp(data,"-q",2)) /* compare to q */
	     {
	       *data=' ';*(data+1)=' ';
	       return (color_faces(p,3,data));
	     }
	   if (!strncmp(data,"-p",2)) /* copy from pack p */
	     {
	       *data=' ';*(data+1)=' ';
	       return (color_faces(p,7,data));
	     }
	   else return (color_faces(p,6,data));
	 }
       else return 0;
     }
				/* ========== copy ======== */
   if (!strncmp(cmd,"copy",4)) 
     {
       if (!sscanf(data,"%d",&p1)) return 0;
       sprintf(buff,"%d %d",pnum,p1);
       copy_packcall(buff);
       return (*hflag=1);
     }
   break;
 }
case 'd':
 {
				/* ========== diagnostic routines ========*/
   if (!strncmp(cmd,"diag",4))
     {
       return (diag_call(p,data));
     }
 				/* ========== drawing operations ========*/
   if (!cmd_mode && !strncmp(cmd,"disp",4))
     {
       return (display_call(p,data));
     }
  
				/* ========== delay ============== */
   if (!strncmp(cmd,"delay",5))
     {
       if (sscanf(data,"%d",&n) && n>0) timedelay((double)n);
       return 1;
     }
				/* ========== decrement radius ======= */ 
   if (!strncmp(cmd,"dec_rad",7))
     {
       factor=(1.0)/inc_factor;
       return (crement_radii(p,factor,data));
     }
   break;
 }
case 'e':
 {
 				/* ============ exec  =============== */
   if (!strncmp(cmd,"exec",4))
     {
       return (*hflag=init_remote(data));
     }
 				/* ============ export_cmd ============ */
   if (!strncmp(cmd,"export_cmd",10))
     {
       return (cmd_export(p,data));
     }
				/* ============ eucl_write ============ */
   if (!strncmp(cmd,"eucl_write",10))
     {
       if (sscanf(data,"%s",filename)!=1) return 0; /* blank */
       set_packing_path();
       strcpy(buff,path);
       strcat(buff,filename);
       strcpy(filename,buff); /* now have full pathname */
       return (*hflag=writeeucldata(p,filename));
     }	
   break;
 }
case 'f':
 {
   /* ===== fexec ======= */
   if (!strncmp(cmd,"fexec",5))
     {
       return (*hflag=fexec_call(data));
     }
	                        /* ==== set 'next_face' indices ==== */
   if (!strncmp(cmd,"f_next",6))
     {
       return (set_face_next(p,data));
     }
				/* ==== set 'index_flag' of faces ==== */
   if (!strncmp(cmd,"f_index",7))
     {
       return (set_face_index(p,data));
     }
   if (!strncmp(cmd,"f_red",5))
     {
       return (set_face_red(p,data));
     }
   if (!strncmp(cmd,"f_rnext",7))
     {
       return (set_face_rnext(p,data));
     }
   if (!strncmp(cmd,"focus",5))
     {
       return (focus_call(p,data));
     }
   break;
 }
case 'g':
 {
				/* ============ set gamma ============== */
   if (!strncmp(cmd,"gamma",5) )
     {
       if (sscanf(data,"%d",&vert)==1) 
	 return (set_gamma(p,vert));
       else return 0;
     }
                                /* ========== gen_mark ================ */
   if (!strncmp(cmd,"gen_mark",8))
     {
       return (*hflag=gen_mark_call(p,data));
     }
                                /* ========== get_data ================ */
   if (!strncmp(cmd,"get_data",8))
     {
       return (*hflag=get_put_data_call(p,data,0));
     }
   break;
 }
case 'h':
 {
                                /* ============ h_dist ================ */
   if (!strncmp(cmd,"h_dist",6))
     {
       return (h_dist_call(data));
     }
   break;
 }
case 'i':
 {
 				/* ========== import_cmd ======== */
   if (!strncmp(cmd,"import_cmd",10))
     {
       return (cmd_import(data));
     }
				/* ========== infile_path ========== */
   if (!strncmp(cmd,"infile_path",11))
     {
       return (path_infile(data));
     }
				/* ========== infile_cmds ======== */
   if (!strncmp(cmd,"infile_cmds",11))
     {
       return (cmds_infile(data));
     }
   break;
 }
case 'm':
 {
                                /* ===== map circle/face indices ==== */
   if (!strncmp(cmd,"map",3))
     {
       return (map_list_call(p,data));
     }
				/* ====== mark circles/faces ======== */ 
   if (!strncmp(cmd,"mark",4))
     {
       marking(p,data);
       return 1;
     }
				/* ====== match ================= */ 
   if (!strncmp(cmd,"match",5))
     {
       return (match_call(p,data));
     }
				/* ====== msg_remote: to process === */ 
   if (!strncmp(cmd,"msg_r",5) || !strncmp(cmd,"m_r",3) 
       || !strncmp(cmd,"mr",2))
     {
       nextpoint=data;
       stripsp(data);
       if (sscanf(data," %s %[^\n]1000",next,msgbuf)<2) 
	 return 0; /* empty message */
       if ((v=atoi(next))) /* numerical name of routine */
	 {
	   if (v>=NUM_PROC) /* take v as actual pid */
	     {
	       w=-1;
	       for (i=0;i<NUM_PROC;i++)
		 if (remote[i].pid==v) {w=i;break;}
	       if (w<0) return 0;
	     }
	   else if (v>=0 && v<NUM_PROC && remote[v].pid) w=v;
	 }
       else /* string name of routine */
	 {
	   w=-1;
	   for (i=0;i<NUM_PROC;i++)
	     if (strcmp(remote[i].moniker,next)==0) 
	       {w=i;break;}
	   if (w<0) return 0;
	 }
       msg_remote(w);
       return 1;		
     }
   
				/* ========== display a msg ====== */ 
   if (!strncmp(cmd,"msg",3))
     {
       strncpy(msgbuf,data,300);
       msg();
       return 1;
     }
   break;
 }
case 'n':
 {
				/* ========== set active node ======== */
   if (!strncmp(cmd,"node_active",11) )
     {
       if (sscanf(data,"%d",&vert)==1 && vert>0 
	   && vert<=p->nodecount)
	 {
	   p->active_node=vert;
	   return 1;
	 }
       else return 0;
     }
   break;
 }
case 'P':
 {
				/* =========== Paginate ============== */
   if (!strncmp(cmd,"Pag",3))
     {
       return (*hflag=renumber_ps_Pages(data));
     }
   break;
 }
case 'p':
 {
				/* =========== pair_mob ============== */
   if (!strncmp(cmd,"pair_m",6))
     {
       return (*hflag=apply_pair_mobius(p,data));
     }
				/* =========== path_construct  ======= */
   if (!strncmp(cmd,"path_c",6)) 
     {
       return (path_construct_call(p,data));
     }
				/* =========== print (postscript) ======= */
   if (!strncmp(cmd,"print",11)) 
     {
       if (!p->status)
	 {
	   strcpy(msgbuf,"Note, pack is empty.");
	   msg();
	   return 0;
	 }
       return (*hflag=post_canvas(p));
     }
				/* ============ custom printing ========*/
   if (!strncmp(cmd,"post",4))
     {
       if (!cmd_mode)
	 {
	   strcpy(ps_file_name,
		  (char *)xv_get(ps_file_item,PANEL_VALUE));
	   strcpy(print_cmd,(char *)get_print_cmd());
	 }
       n=print_call(&custom_fp,p,ps_file_name,
		    data,user_name,CPVersion,print_cmd);
       return (*hflag=n);
     } 
				/* ============ print working directory =*/
   if (!strncmp(cmd,"pwd",3))
     {
       getcwd(buf,BUFSIZE);
       sprintf(msgbuf,"\nCurrent directory: %s.",buf);
       msg();
       return 0;	 	
     }
                                /* ========== put_data ================ */
   if (!strncmp(cmd,"put_data",8))
     {
       return (*hflag=get_put_data_call(p,data,1));
     }
   break;		
 }
case 'q':
 {
				/* ======== quit (no confirmation) ==== */
   if (!strncmp(cmd,"quit",4) || !strncmp(cmd,"exit",4) )
     { quit(0);return 0;}
   break;
 }
case 'r':
 {
				/* ============ read_path ============ */
   if (!strncmp(cmd,"read_path",9))
     {
       if (sscanf(data,"%s",filename)!=1) return 0; /* blank */
       return (read_path_file(filename));
     }
				/* ============ rotate ============ */
   if (!strncmp(cmd,"rotate",6))
     {
       if (sscanf(data,"%lf",&ang)!=1) return 0;
       return (rotate(p,ang*M_PI));
     }
				/* ============ rect_orient ========== */
   if (!strncmp(cmd,"rect_orient",11))
     {
       sprintf(buf,"-h %s",data);
       return (e_norm_scale(p,buf));
     }
				/* ============ rect_ratio ========== */
   if (!strncmp(cmd,"rect_ratio",10))
     {
       return (rect_ratio_call(p,data));
     } 	break;
 }
case 's':
 {
				/* ==== open/load script file  ==== */
   if (!strncmp(cmd,"script",6))
     {
       if (!cmd_mode)
	 {
	   xv_set(script_frame,WIN_SHOW,TRUE,0);
	   if (sscanf(data,"%s",filename)==1)
	     {
	       if ((int)xv_get(script_sw,TEXTSW_MODIFIED))
		 {
		   sprintf(buf,
			   "Script contents have been modified: overwrite??");
		   if (!confirm_action(buf)) return 0;
		 }
	       xv_set(script_sw,
		      TEXTSW_FILE,filename,
		      TEXTSW_FIRST,0,
		      TEXTSW_INSERTION_POINT,0,
		      0);
	     }
	   return 1;
	 }
       if (script_fp) 
	 {
	   fclose(script_fp);
	   script_fp=NULL;
	   script_name[0]='\0';
	 }
       if (!(sscanf(data,"%s",script_name)) || 
	   !(script_fp=fopen(script_name,"r")))
	 {
	   script_name[0]='\0';
	   return 0;
	 }
       return 1;   
     }
				/* ============ set ============== */
   
   if (!strncmp(cmd,"set_",3))
     {
       cmd[0]=cmd[1]=cmd[2]=cmd[3]=' ';
       stripsp(cmd);
       if (!strncmp(cmd,"accur",5) &&
	   sscanf(data,"%lf",&dum)==1 && dum>0 && dum<.10)
	 {
	   if (dum<0.0000000000000001) dum=0.0000000000000001;
	   /* represents max of about 15 decimal accur */
	   toler=dum;
	   if (okerr>(.01)*toler) okerr = (.01)*toler;
	   return 1;
	 }
       if (!strncmp(cmd,"active",6) 
	   && (vertlist=node_link_parse(p,data,&endptr,&hits)))
	 {
	   p->active_node=vertlist->v;
	   vert_free(&vertlist);
	   return 1;
	 }
       
       if (!strncmp(cmd,"cycle",5) &&
	   sscanf(data,"%d",&i)==1 && i>0 && i<100010)
	 {
	   totalpasses=i;
	   return 1;
	 }
       if (!strncmp(cmd,"dir",3))
	 {
	   strcpy(packing_dir_name,data);
	   if (!cmd_mode)
	     panel_set_value(dir_name_item,data);
	   return 1;
	 }
       if (!cmd_mode && !strncmp(cmd,"draw",4))
	 {
	   if (data[0]=='f') draw_speed=0; /* fast */
	   else if (data[0]=='s') draw_speed=1; /* slow */
	   else draw_speed= (draw_speed) ? 0 : 1;
	 }
       if (!strncmp(cmd+1,"list",4)) /* various lists */
	 {
	   if (*cmd=='e' || *cmd=='E') /* elist */
	     {
	       holde=node_pair_link(p,data,&endptr,&hits);
	       if (*cmd=='e')
		 {
		   edge_free(&(p->elist));
		   p->elist=holde;
		 }
	       else
		 {
		   edge_free(&Elist);
		   Elist=holde;
		 }
	       return 1;
	     }
	   else if (*cmd=='v' || *cmd=='V') /* vlist */
	     {
	       holdv=node_link_parse(p,data,&endptr,&hits);
	       if (*cmd=='v')
		 {
		   vert_free(&(p->vlist));
		   p->vlist=holdv;
		 }
	       else
		 {
		   vert_free(&Vlist);
		   Vlist=holdv;
		 }
	       return 1;
	     }
	   else if (*cmd=='f' || *cmd=='F') /* flist */
	     {
	       holdv=face_link_parse(p,data,&endptr,&hits);
	       if (*cmd=='f')
		 {
		   vert_free(&(p->flist));
		   p->flist=holdv;
		 }
	       else
		 {
		   vert_free(&Flist);
		   Flist=holdv;
		 }
	       return 1;
	     }
	 }
       if (!strncmp(cmd,"toler",5) &&
	   sscanf(data,"%lf",&dum)==1 && dum>0 && dum<.10)
	 {
	   toler=dum;
	   return 1;
	 }
       if (!strncmp(cmd,"err",3) &&
	   sscanf(data,"%lf",&dum)==1 && dum>0 && dum<.10)
	 {
	   if (dum<=(.01)*toler) {okerr=dum;return 1;}
	   return 0;
	 }
       if (!strncmp(cmd,"iter",4) &&
	   sscanf(data,"%d",&i)==1 && i>0 && i<15)
	 {
	   iterates=i;
	   return 1;
	 }
       if (!strncmp(cmd,"post",4) &&
	   sscanf(data,"%d",&i)==1 && i>0 && i<8)
	 {
	   sc_print_size=i;
	   return 1;
	 }
       if (!strncmp(cmd,"brush",10)
	   && sscanf(data,"%d",&i)==1 && i>0 && i<15)
	 {
	   line_thick=i;
	   ps_linewidth=(1+2*(i-1))*PS_UNIT_LINEWIDTH;
	   if (custom_fp) /* if custom print file is open,
			     set new 'ourlinewidth' */
	     fprintf(custom_fp,"%f ourlinewidth\n",ps_linewidth);
	   if (!cmd_mode)
	     XSetLineAttributes(display,gc,line_thick,
				LineSolid,CapRound,JoinRound);
	   return 1;
	 }
       
       if (!strncmp(cmd,"eucl_scale",10))
	 {
	   if (sscanf(data,"%lf",&dum)==1 && dum>=.5 && dum<=1.5)
	     {
	       eucl_factor=dum;
	       if (!cmd_mode) xv_set(Eucl_factor,PANEL_VALUE,
				     (int)(dum*100.0),0);
	       return 1;
	     }
	 }
       if (!strncmp(cmd,"inc_factor",10))
	 {
	   if (sscanf(data,"%lf",&dum)==1 && dum>=1.0 && dum<=2.0)
	     {
	       inc_factor=dum;
	       if (!cmd_mode) xv_set(radius_inc,PANEL_VALUE,
				     (int)((dum-1.0)*100.0),0);
	       return 1;
	     }
	 }
       if (!strncmp(cmd,"Mobius",6))
	 {
	   newMob=(Mobius *)malloc(sizeof(Mobius));
	   if ((n=sscanf(data,"%lf %lf %lf %lf %lf %lf "
			 "%lf %lf %d",
			 &(newMob->a.re),&(newMob->a.im),
			 &(newMob->b.re),&(newMob->b.im),
			 &(newMob->c.re),&(newMob->c.im),
			 &(newMob->d.re),&(newMob->d.im), 
			 &(newMob->flip)))>=8 )
	     {
	       if (cAbs(csub(cmult(newMob->a,newMob->d),
			     cmult(newMob->b,newMob->c)))>okerr )
		 {
		   if (n==8) newMob->flip=0; /* default */	
		   Mob=*newMob;
		   free(newMob);
		   return 1;
		 }
	     }
	   else
	     {
	       sprintf(msgbuf,"Mobius usage: "
		       "8 reals (and a 1 to reverse "
		       "orientation).");
	       emsg();
	       free(newMob);
	       return 0;
	     }
	 }
       if (!strncmp(cmd,"fill_pattern",12))
	 {
	   if (!strncmp(data,"solid",5)) 
	     {
	       if (!cmd_mode) 
		 {
		   XSetFillStyle(display,gc_fill,FillSolid);
		   xv_set(fill_pattern,PANEL_VALUE,1,0);
		 }
	       return 1;
	     }
	   else 
	     {
	       if (!cmd_mode) 
		 {
		   XSetFillStyle(display,gc_fill,FillStippled);
		   xv_set(fill_pattern,PANEL_VALUE,0,0);
		 }
	       return 1;
	     }
	 }
       if (!strncmp(cmd,"sphere_view",11) || !strncmp(cmd,"sv",2))
	 {
	   return sphere_view(p->screen,data);
	 }
       if (!strncmp(cmd,"sph_pts",7) && sscanf(data,"%d",&i)==1 
	   && i>10 && i<500)
	 {
	   num_plot=i;
	   return 1;
	 }
       if (!strncmp(cmd,"screen",6))
	 {
	   return set_screen(p,data);
	 }
       if (!strncmp(cmd,"custom",6))
	 {
	   return (set_postfile_call(1,data));
	 }
       if (!strncmp(cmd,"print",5))
	 {
	   return (set_postfile_call(0,data));
	 }
       if (!strncmp(cmd,"plot_flags",10))
	 {
	   return (set_plot_flags(p,data));
	 }
     } /* end of "set_" commands */
	 			/* ========== show red chain ======== */
   if (!strncmp(cmd,"show_red",8))
     {
       return (*hflag=pfacered(p));
     }
   break;
 }
case 't':
 {
				/* ====== test_repack ======= */
   if (!strncmp(cmd,"test_re",7))
     {
       return (*hflag=call_test_repack(p,data));
     }
   break;
 }
case 'v':
 {
   				/* ====== vert_order ======= */
   if (!strncmp(cmd,"vert_ord",8))
     {
       return (vert_draw_order(p));
     }
   break;
 }
case 'w':
  {
				/* ====== write_path ======= */
    if (!strncmp(cmd,"write_path",10))
      {
	nextpoint=data;
	if (!grab_next(&nextpoint,next) 
	    || sscanf(next,"%s",filename)!=1) 
	  return 0;
	return (*hflag=write_path_file(filename));
      }
                                /* ==== write_light_raw
				   (ie., p_light format w/o 
				   key words ==== */
    else if (!strncmp(cmd,"write_light_raw",15))
      {
	return (*hflag=write_light_call(p,data,1));
      }
                                /* ==== write_light =====  */
    else if (!strncmp(cmd,"write_light",11))
      {
	return (*hflag=write_light_call(p,data,0));
      }
                                /* ==== write =====  */
    else if (!strncmp(cmd,"write",5))
      {
	return (*hflag=write_parse(p,data));
      }
    
    break;
  }
case '!':
  {
				/* ======= repeat last ====== */
    if (!strncmp(cmd,"!!",2) && !cmd_search_depth) 
      /* note: not permitted when executing named script cmd */ 
      {
	sort_cmd(cmd_history,targ_p);
	return 1;
      }
    break;
  }
case '?':
 {
				/* ============ inquiries =========== */
   if (!strncmp(cmd,"?pack",5))
     return (print_inq_data(p,1,data));
   if (!strncmp(cmd,"?vert",5)) 
     return (print_inq_data(p,2,data));
   if (!strncmp(cmd,"?flower",7))
     return (print_inq_data(p,7,data));
   if (!strncmp(cmd,"?rad",4))
     return (print_inq_data(p,8,data));
   if (!strncmp(cmd,"?ang_sum",8))
     return (print_inq_data(p,9,data));
   if (!strncmp(cmd,"?aim",4))
     return (print_inq_data(p,10,data));
   if (!strncmp(cmd,"?face",5))
     return (print_inq_data(p,11,data));
   if (!strncmp(cmd,"?over",5))
     return (print_inq_data(p,12,data));
   if (!strncmp(cmd,"?cent",5))
     return (print_inq_data(p,13,data));
   if (!strncmp(cmd,"?alt_rad",8))
     return (print_inq_data(p,14,data));
   if (!strncmp(cmd,"?kap",4))
     return (print_inq_data(p,15,data));
   if (!strncmp(cmd,"?antip",6))
     return (print_inq_data(p,16,data));
   if (!strncmp(cmd,"?screen",7))
     return (print_inq_data(p,20,data));
   if (!strncmp(cmd,"?param",6))
     return (print_inq_data(p,21,data));
   if (!strncmp(cmd,"?pk_stat",7))
     return (print_inq_data(p,25,data));
   if (!strncmp(cmd,"?bdry_dist",10))
     return (print_inq_data(p,26,data));
   if (!strncmp(cmd,"?edge_pairings",14))
     return (print_inq_data(p,27,data));
   if (!strncmp(cmd,"?ratio_ftn",10))
     return (print_inq_data(p,28,data));
   if (!strncmp(cmd,"?conduct",8))
     return (print_inq_data(p,29,data));
   if (!strncmp(cmd,"?remote",7))
     return (print_inq_data(p,30,data));
   if (!strncmp(cmd,"?bdry_length",12))
     return (print_inq_data(p,31,data));
   if (!strncmp(cmd,"?energy",7))
     return (print_energy(p));
   if (!strncmp(cmd,"?script",8))
     return (print_inq_data(p,33,data));
   
   break;
 }
    } /* end of switch */

  return 0;
} /* parse_cmd */
  
