#include "cp_types.h"
#include "cp_proto.h"

/* converts path to list of XPoints w.r.t. screen q, returns ptr, 
max pts is length, returns new length*/

XPoint *path_XPoints(struct s_data *q,struct Pathlist *path,int *length)
{
  int count=0;
  XPoint *Xptr=NULL;
  struct Pathlist *trace;
  complex pt,normpt;

  if (path==NULL 
      || ((Xptr=(XPoint *)malloc((*length)*sizeof(XPoint)))==NULL) )
    return (NULL); /* no path */
  trace=path;
  while (trace!=NULL && count<*length)
    {
      pt.re=trace->x;pt.im=trace->y;
      r_to_pix(pt,&normpt,q->pix_box,
	       q->box);
      (Xptr+count)->x=(short)(normpt.re);
      (Xptr+count)->y=(short)(normpt.im);
      trace=trace->next;
      count++;
    }
  *length=count;
  return (Xptr);
} /* path_XPoints */
