<?php
/*
+--------------------------------------------------------------------+
| CiviCRM version 4.7                                                |
+--------------------------------------------------------------------+
| Copyright CiviCRM LLC (c) 2004-2016                                |
+--------------------------------------------------------------------+
| This file is a part of CiviCRM.                                    |
|                                                                    |
| CiviCRM is free software; you can copy, modify, and distribute it  |
| under the terms of the GNU Affero General Public License           |
| Version 3, 19 November 2007 and the CiviCRM Licensing Exception.   |
|                                                                    |
| CiviCRM is distributed in the hope that it will be useful, but     |
| WITHOUT ANY WARRANTY; without even the implied warranty of         |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               |
| See the GNU Affero General Public License for more details.        |
|                                                                    |
| You should have received a copy of the GNU Affero General Public   |
| License and the CiviCRM Licensing Exception along                  |
| with this program; if not, contact CiviCRM LLC                     |
| at info[AT]civicrm[DOT]org. If you have questions about the        |
| GNU Affero General Public License or the licensing of CiviCRM,     |
| see the CiviCRM license FAQ at http://civicrm.org/licensing        |
+--------------------------------------------------------------------+
*/
/**
 * @package CRM
 * @copyright CiviCRM LLC (c) 2004-2016
 *
 * Generated from xml/schema/CRM/Core/StatusPreference.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 */
require_once 'CRM/Core/DAO.php';
require_once 'CRM/Utils/Type.php';
class CRM_Core_DAO_StatusPreference extends CRM_Core_DAO
{
  /**
   * static instance to hold the table name
   *
   * @var string
   */
  static $_tableName = 'civicrm_status_pref';
  /**
   * static instance to hold the field values
   *
   * @var array
   */
  static $_fields = null;
  /**
   * static instance to hold the keys used in $_fields for each field.
   *
   * @var array
   */
  static $_fieldKeys = null;
  /**
   * static instance to hold the FK relationships
   *
   * @var string
   */
  static $_links = null;
  /**
   * static instance to hold the values that can
   * be imported
   *
   * @var array
   */
  static $_import = null;
  /**
   * static instance to hold the values that can
   * be exported
   *
   * @var array
   */
  static $_export = null;
  /**
   * static value to see if we should log any modifications to
   * this table in the civicrm_log table
   *
   * @var boolean
   */
  static $_log = false;
  /**
   * Unique Status Preference ID
   *
   * @var int unsigned
   */
  public $id;
  /**
   * Which Domain is this Status Preference for
   *
   * @var int unsigned
   */
  public $domain_id;
  /**
   * Name of the status check this preference references.
   *
   * @var string
   */
  public $name;
  /**
   * expires ignore_severity.  NULL never hushes.
   *
   * @var date
   */
  public $hush_until;
  /**
   * Hush messages up to and including this severity.
   *
   * @var int unsigned
   */
  public $ignore_severity;
  /**
   * These settings are per-check, and can't be compared across checks.
   *
   * @var string
   */
  public $prefs;
  /**
   * These values are per-check, and can't be compared across checks.
   *
   * @var string
   */
  public $check_info;
  /**
   * class constructor
   *
   * @return civicrm_status_pref
   */
  function __construct()
  {
    $this->__table = 'civicrm_status_pref';
    parent::__construct();
  }
  /**
   * Returns foreign keys and entity references
   *
   * @return array
   *   [CRM_Core_Reference_Interface]
   */
  static function getReferenceColumns()
  {
    if (!self::$_links) {
      self::$_links = static ::createReferenceColumns(__CLASS__);
      self::$_links[] = new CRM_Core_Reference_Basic(self::getTableName() , 'domain_id', 'civicrm_domain', 'id');
    }
    return self::$_links;
  }
  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  static function &fields()
  {
    if (!(self::$_fields)) {
      self::$_fields = array(
        'id' => array(
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Status Preference ID') ,
          'description' => 'Unique Status Preference ID',
          'required' => true,
        ) ,
        'domain_id' => array(
          'name' => 'domain_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Setting Domain') ,
          'description' => 'Which Domain is this Status Preference for',
          'required' => true,
          'FKClassName' => 'CRM_Core_DAO_Domain',
          'pseudoconstant' => array(
            'table' => 'civicrm_domain',
            'keyColumn' => 'id',
            'labelColumn' => 'name',
          )
        ) ,
        'name' => array(
          'name' => 'name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Status Check Name') ,
          'description' => 'Name of the status check this preference references.',
          'required' => true,
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'import' => true,
          'where' => 'civicrm_status_pref.name',
          'headerPattern' => '',
          'dataPattern' => '',
          'export' => true,
        ) ,
        'hush_until' => array(
          'name' => 'hush_until',
          'type' => CRM_Utils_Type::T_DATE,
          'title' => ts('Snooze Status Notifications Until') ,
          'description' => 'expires ignore_severity.  NULL never hushes.',
          'import' => true,
          'where' => 'civicrm_status_pref.hush_until',
          'headerPattern' => '',
          'dataPattern' => '',
          'export' => true,
          'default' => 'NULL',
        ) ,
        'ignore_severity' => array(
          'name' => 'ignore_severity',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Ignore Severity') ,
          'description' => 'Hush messages up to and including this severity.',
          'import' => true,
          'where' => 'civicrm_status_pref.ignore_severity',
          'headerPattern' => '',
          'dataPattern' => '',
          'export' => true,
          'default' => '1',
          'pseudoconstant' => array(
            'callback' => 'CRM_Utils_Check::getSeverityList',
          )
        ) ,
        'prefs' => array(
          'name' => 'prefs',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Status Preferences') ,
          'description' => 'These settings are per-check, and can\'t be compared across checks.',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
        ) ,
        'check_info' => array(
          'name' => 'check_info',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Check Info') ,
          'description' => 'These values are per-check, and can\'t be compared across checks.',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
        ) ,
      );
    }
    return self::$_fields;
  }
  /**
   * Returns an array containing, for each field, the arary key used for that
   * field in self::$_fields.
   *
   * @return array
   */
  static function &fieldKeys()
  {
    if (!(self::$_fieldKeys)) {
      self::$_fieldKeys = array(
        'id' => 'id',
        'domain_id' => 'domain_id',
        'name' => 'name',
        'hush_until' => 'hush_until',
        'ignore_severity' => 'ignore_severity',
        'prefs' => 'prefs',
        'check_info' => 'check_info',
      );
    }
    return self::$_fieldKeys;
  }
  /**
   * Returns the names of this table
   *
   * @return string
   */
  static function getTableName()
  {
    return self::$_tableName;
  }
  /**
   * Returns if this table needs to be logged
   *
   * @return boolean
   */
  function getLog()
  {
    return self::$_log;
  }
  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &import($prefix = false)
  {
    if (!(self::$_import)) {
      self::$_import = array();
      $fields = self::fields();
      foreach($fields as $name => $field) {
        if (CRM_Utils_Array::value('import', $field)) {
          if ($prefix) {
            self::$_import['status_pref'] = & $fields[$name];
          } else {
            self::$_import[$name] = & $fields[$name];
          }
        }
      }
    }
    return self::$_import;
  }
  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &export($prefix = false)
  {
    if (!(self::$_export)) {
      self::$_export = array();
      $fields = self::fields();
      foreach($fields as $name => $field) {
        if (CRM_Utils_Array::value('export', $field)) {
          if ($prefix) {
            self::$_export['status_pref'] = & $fields[$name];
          } else {
            self::$_export[$name] = & $fields[$name];
          }
        }
      }
    }
    return self::$_export;
  }
}
