<?php

/**
 * @package CRM
 * @copyright CiviCRM LLC (c) 2004-2018
 *
 * Generated from xml/schema/CRM/Core/Country.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:e01f7b6fdc1c22bcf6fbc125ea2d894a)
 */

/**
 * Database access object for the Country entity.
 */
class CRM_Core_DAO_Country extends CRM_Core_DAO {

  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  static $_tableName = 'civicrm_country';

  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var bool
   */
  static $_log = FALSE;

  /**
   * Country Id
   *
   * @var int unsigned
   */
  public $id;

  /**
   * Country Name
   *
   * @var string
   */
  public $name;

  /**
   * ISO Code
   *
   * @var string
   */
  public $iso_code;

  /**
   * National prefix to be used when dialing TO this country.
   *
   * @var string
   */
  public $country_code;

  /**
   * Foreign key to civicrm_address_format.id.
   *
   * @var int unsigned
   */
  public $address_format_id;

  /**
   * International direct dialing prefix from within the country TO another country
   *
   * @var string
   */
  public $idd_prefix;

  /**
   * Access prefix to call within a country to a different area
   *
   * @var string
   */
  public $ndd_prefix;

  /**
   * Foreign key to civicrm_worldregion.id.
   *
   * @var int unsigned
   */
  public $region_id;

  /**
   * Should state/province be displayed as abbreviation for contacts from this country?
   *
   * @var boolean
   */
  public $is_province_abbreviated;

  /**
   * Class constructor.
   */
  public function __construct() {
    $this->__table = 'civicrm_country';
    parent::__construct();
  }

  /**
   * Returns foreign keys and entity references.
   *
   * @return array
   *   [CRM_Core_Reference_Interface]
   */
  public static function getReferenceColumns() {
    if (!isset(Civi::$statics[__CLASS__]['links'])) {
      Civi::$statics[__CLASS__]['links'] = static ::createReferenceColumns(__CLASS__);
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName(), 'address_format_id', 'civicrm_address_format', 'id');
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName(), 'region_id', 'civicrm_worldregion', 'id');
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'links_callback', Civi::$statics[__CLASS__]['links']);
    }
    return Civi::$statics[__CLASS__]['links'];
  }

  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  public static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = [
        'id' => [
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Country ID'),
          'description' => 'Country Id',
          'required' => TRUE,
          'table_name' => 'civicrm_country',
          'entity' => 'Country',
          'bao' => 'CRM_Core_BAO_Country',
          'localizable' => 0,
        ],
        'name' => [
          'name' => 'name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Country'),
          'description' => 'Country Name',
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
          'import' => TRUE,
          'where' => 'civicrm_country.name',
          'headerPattern' => '/country/i',
          'dataPattern' => '/^[A-Z][a-z]+\.?(\s+[A-Z][a-z]+){0,3}$/',
          'export' => TRUE,
          'table_name' => 'civicrm_country',
          'entity' => 'Country',
          'bao' => 'CRM_Core_BAO_Country',
          'localizable' => 0,
        ],
        'iso_code' => [
          'name' => 'iso_code',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Country ISO Code'),
          'description' => 'ISO Code',
          'maxlength' => 2,
          'size' => CRM_Utils_Type::TWO,
          'table_name' => 'civicrm_country',
          'entity' => 'Country',
          'bao' => 'CRM_Core_BAO_Country',
          'localizable' => 0,
        ],
        'country_code' => [
          'name' => 'country_code',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Country Phone Prefix'),
          'description' => 'National prefix to be used when dialing TO this country.',
          'maxlength' => 4,
          'size' => CRM_Utils_Type::FOUR,
          'table_name' => 'civicrm_country',
          'entity' => 'Country',
          'bao' => 'CRM_Core_BAO_Country',
          'localizable' => 0,
        ],
        'address_format_id' => [
          'name' => 'address_format_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Address Format'),
          'description' => 'Foreign key to civicrm_address_format.id.',
          'table_name' => 'civicrm_country',
          'entity' => 'Country',
          'bao' => 'CRM_Core_BAO_Country',
          'localizable' => 0,
          'FKClassName' => 'CRM_Core_DAO_AddressFormat',
        ],
        'idd_prefix' => [
          'name' => 'idd_prefix',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Outgoing Phone Prefix'),
          'description' => 'International direct dialing prefix from within the country TO another country',
          'maxlength' => 4,
          'size' => CRM_Utils_Type::FOUR,
          'table_name' => 'civicrm_country',
          'entity' => 'Country',
          'bao' => 'CRM_Core_BAO_Country',
          'localizable' => 0,
        ],
        'ndd_prefix' => [
          'name' => 'ndd_prefix',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Area Code'),
          'description' => 'Access prefix to call within a country to a different area',
          'maxlength' => 4,
          'size' => CRM_Utils_Type::FOUR,
          'table_name' => 'civicrm_country',
          'entity' => 'Country',
          'bao' => 'CRM_Core_BAO_Country',
          'localizable' => 0,
        ],
        'region_id' => [
          'name' => 'region_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Region'),
          'description' => 'Foreign key to civicrm_worldregion.id.',
          'required' => TRUE,
          'table_name' => 'civicrm_country',
          'entity' => 'Country',
          'bao' => 'CRM_Core_BAO_Country',
          'localizable' => 0,
          'FKClassName' => 'CRM_Core_DAO_Worldregion',
        ],
        'is_province_abbreviated' => [
          'name' => 'is_province_abbreviated',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Abbreviate Province?'),
          'description' => 'Should state/province be displayed as abbreviation for contacts from this country?',
          'table_name' => 'civicrm_country',
          'entity' => 'Country',
          'bao' => 'CRM_Core_BAO_Country',
          'localizable' => 0,
        ],
      ];
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }

  /**
   * Return a mapping from field-name to the corresponding key (as used in fields()).
   *
   * @return array
   *   Array(string $name => string $uniqueName).
   */
  public static function &fieldKeys() {
    if (!isset(Civi::$statics[__CLASS__]['fieldKeys'])) {
      Civi::$statics[__CLASS__]['fieldKeys'] = array_flip(CRM_Utils_Array::collect('name', self::fields()));
    }
    return Civi::$statics[__CLASS__]['fieldKeys'];
  }

  /**
   * Returns the names of this table
   *
   * @return string
   */
  public static function getTableName() {
    return self::$_tableName;
  }

  /**
   * Returns if this table needs to be logged
   *
   * @return bool
   */
  public function getLog() {
    return self::$_log;
  }

  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &import($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'country', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &export($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'country', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of indices
   *
   * @param bool $localize
   *
   * @return array
   */
  public static function indices($localize = TRUE) {
    $indices = [
      'UI_name_iso_code' => [
        'name' => 'UI_name_iso_code',
        'field' => [
          0 => 'name',
          1 => 'iso_code',
        ],
        'localizable' => FALSE,
        'unique' => TRUE,
        'sig' => 'civicrm_country::1::name::iso_code',
      ],
    ];
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }

}
