# CiviCRM 4.7.17

Released March 8, 2017

- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**

## <a name="features"></a>Features

### Core CiviCRM

- **[CRM-19815](https://issues.civicrm.org/jira/browse/CRM-19815) Make
  pseudoconstant code generic in advanced search
  ([9908](https://github.com/civicrm/civicrm-core/pull/9908),
  [9885](https://github.com/civicrm/civicrm-core/pull/9885), and
  [9799](https://github.com/civicrm/civicrm-core/pull/9799))**

  This modifies handling of pseudoconstants (site-wide lists of options) from
  specific hard-coded situations to metadata-based fields.  This results in
  removing slow joins and improves speed.

- **[CRM-19492](https://issues.civicrm.org/jira/browse/CRM-19492) When merging:
  require row to be taken across before changing row settings
  ([9902](https://github.com/civicrm/civicrm-core/pull/9902))**

  The interface for merging contacts is clarified so that merge options such as
  location type on a field are not available unless the field is marked to be
  merged from the contact which is to be deleted.

- **[CRM-20175](https://issues.civicrm.org/jira/browse/CRM-20175) Increase pager
  support to 9999 pages
  ([9894](https://github.com/civicrm/civicrm-core/pull/9894))**

  The page number box on search results now allows four-digit page numbers.

- **[CRM-19934](https://issues.civicrm.org/jira/browse/CRM-19934) Performance
  improvement on civicrm_acl_contact_cache
  ([9807](https://github.com/civicrm/civicrm-core/pull/9807)) (Partial work)**

  The query for building an ACL cache is simplified to avoid a taxing `OR`
  clause.

- **[CRM-19816](https://issues.civicrm.org/jira/browse/CRM-19816) Improve
  activity search filters
  ([9841](https://github.com/civicrm/civicrm-core/pull/9841))**

  Using the API to search for activities involving a specific contact is
  simplified and standardized across the assignee, source, and target, plus the
  generic `contact_id` parameter.

- **[CRM-19883](https://issues.civicrm.org/jira/browse/CRM-19883) Activity
  Priority Field is Not Included in Advanced Search or Activity Reports
  ([9816](https://github.com/civicrm/civicrm-core/pull/9816) and
  [9800](https://github.com/civicrm/civicrm-core/pull/9800))**

  The Priority field is now available in the Activity Detail and Activity
  Summary reports.

- **[CRM-19938](https://issues.civicrm.org/jira/browse/CRM-19938) Make Civi to
  CMS email sync optional
  ([9765](https://github.com/civicrm/civicrm-core/pull/9765))**

  There is now an option to disable synchronization of a contact's email address
  with their CMS user account.

- **[CRM-19930](https://issues.civicrm.org/jira/browse/CRM-19930) Patch
  DB_DataObject::toArray() to sprintf only as needed
  ([9735](https://github.com/civicrm/civicrm-core/pull/9735) and
  [177](https://github.com/civicrm/civicrm-packages/pull/177))**

  Database query performance is improved by only running strings through
  `sprintf()` when actually necessary.

- **Extension.download API - Allow downloading without installing
  ([9898](https://github.com/civicrm/civicrm-core/pull/9898))**

  The Extension.download API still defaults to downloading and installing an
  extension, but a new parameter `install` can be set to `FALSE` in order to
  download without installing.

- **[CRM-20034](https://issues.civicrm.org/jira/browse/CRM-20034) Support "OR"
  params in api get
  ([9844](https://github.com/civicrm/civicrm-core/pull/9844))**

  Many entities can now be queried with sets of `OR` parameters, returning rows
  that meet one of several criteria.  The API Explorer displays the `AND`/`OR`
  option when it is available.

  Separately, the Activity.get API now allows for searching by the ID of
  attached files and allows for joining on EntityTag.

- **[CRM-19943](https://issues.civicrm.org/jira/browse/CRM-19943) Improve tag
  management UI ([9918](https://github.com/civicrm/civicrm-core/pull/9918) and
  [9787](https://github.com/civicrm/civicrm-core/pull/9787))**

  A new drag-and-drop interface allows for editing, nesting, and coloring tags.

- **[CRM-20061](https://issues.civicrm.org/jira/browse/CRM-20061) Allow 'tables'
  as a parameter on the revert api
  ([9862](https://github.com/civicrm/civicrm-core/pull/9862))**

  This adds the opportunity to specify which tables to revert for a logged
  change.

### CiviContribute

- **[CRM-20158](https://issues.civicrm.org/jira/browse/CRM-20158) Store card
  type and last 4 digits of credit card
  ([9876](https://github.com/civicrm/civicrm-core/pull/9876)) (Preliminary
  work)**

  The `civicrm_financial_trxn` table now contains fields to store credit card
  type (e.g. Visa, MasterCard, etc.) and the last four digits of the card
  number, if available.  The fields are not yet used by any functions.

- **[CRM-20022](https://issues.civicrm.org/jira/browse/CRM-20022) Add Batch
  Title to Columns, Grouping tabs on Contribution Summary report
  ([9838](https://github.com/civicrm/civicrm-core/pull/9838))**

  The Contribution Summary report now has an option to display the title of the
  corresponding financial transaction batch.

### CiviEvent

- **[CRM-19999](https://issues.civicrm.org/jira/browse/CRM-19999) Soften error
  message when registration is closed for an event
  ([9823](https://github.com/civicrm/civicrm-core/pull/9823))**

  CiviCRM now says "Sorry" when you attempt to register for an event where
  registration is closed.

### CiviMail

- **[CRM-20196](https://issues.civicrm.org/jira/browse/CRM-20196) Add a useful
  message when the user didn't setup bounce processing properly
  ([9906](https://github.com/civicrm/civicrm-core/pull/9906))**

  If you fail to set a domain in the Mail Accounts and send a message through
  CiviMail, a log message will note the situation.

### Backdrop Integration

- **Add a default layout for CiviCRM admin and ability to configure/set to
  default.
  ([15](https://github.com/civicrm/civicrm-backdrop/issues/15) and
  [20](https://github.com/civicrm/civicrm-backdrop/pull/20))**

  CiviCRM for Backdrop now has a default layout for administration pages.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **[CRM-19929](https://issues.civicrm.org/jira/browse/CRM-19929) Implement pre
  hook for entityTag
  ([9733](https://github.com/civicrm/civicrm-core/pull/9733))**

  Updates to `civicrm_entity_tag`--tagging or untagging a contact or
  activity--now invoke `hook_civicrm_pre()`.

- **[CRM-20201](https://issues.civicrm.org/jira/browse/CRM-20201) Manage Tags
  page does not work if a tag set does not have created by set
  ([9919](https://github.com/civicrm/civicrm-core/pull/9919) and
  [9913](https://github.com/civicrm/civicrm-core/pull/9913))**

- **(Regression) CRM_Mailing_ActionTokens - Degrade gracefully
  ([9874](https://github.com/civicrm/civicrm-core/pull/9874))**

  This fixes an issue where scheduled reminders and other non-CiviMail messages
  would fail if they inadvertently use CiviMail action tokens.

- **[CRM-19453](https://issues.civicrm.org/jira/browse/CRM-19453) In Windows
  System->Directories fails to display under Joomla
  ([9890](https://github.com/civicrm/civicrm-core/pull/9890))**

  This allows Joomla users on Windows to view the Directories settings page
  without errors.

- **[CRM-20144](https://issues.civicrm.org/jira/browse/CRM-20144) API
  contact.get group='x' yields ""DB Error: no such field""
  ([9884](https://github.com/civicrm/civicrm-core/pull/9884) and
  [9867](https://github.com/civicrm/civicrm-core/pull/9867))**

  This reinstates the feature allowing for contacts to be searched by group
  (including smart group) using the API.

- **Display error message for activity processing
  ([9882](https://github.com/civicrm/civicrm-core/pull/9882))**

  The activity processor scheduled job now records the actual error message that
  occurred rather than a generic failure message.

- **ApiExplorer - Fix js error
  ([9883](https://github.com/civicrm/civicrm-core/pull/9883))**

- **[CRM-19693](https://issues.civicrm.org/jira/browse/CRM-19693) Don't show
  options for disabled components
  ([9459](https://github.com/civicrm/civicrm-core/pull/9459))**

- **[CRM-19657](https://issues.civicrm.org/jira/browse/CRM-19657) recurring
  contribution receipt comes from logged in user
  ([9856](https://github.com/civicrm/civicrm-core/pull/9856) and
  [9842](https://github.com/civicrm/civicrm-core/pull/9842))**

  This fixes a bug where receipts triggered by an administrator's actions or a
  scheduled job now come from system-wide information or the default email
  rather than the contact associated with the user who is triggering them.

- **[CRM-19972](https://issues.civicrm.org/jira/browse/CRM-19972) Add in Post
  upgrade message for addition of manage tags permission
  ([9808](https://github.com/civicrm/civicrm-core/pull/9808))**

  The "manage tags" permission was added in 4.7.13, but site administrators were
  not alerted about it when upgrading.

- **[CRM-19184](https://issues.civicrm.org/jira/browse/CRM-19184) Activities
  target contact list does not truncate
  ([9846](https://github.com/civicrm/civicrm-core/pull/9846))**

  When viewing activities, the list of contacts the activity is with should be
  limited to the first several.  This fixes a regression that listed all the
  contacts.

- **[CRM-18811](https://issues.civicrm.org/jira/browse/CRM-18811) MySQL table
  and column aliases can contain spaces
  ([8548](https://github.com/civicrm/civicrm-core/pull/8548))**

  This fixes a problem displaying profiles that have location details for a
  location type that contains a space.

- **[CRM-20015](https://issues.civicrm.org/jira/browse/CRM-20015) token values
  with ampersand cause error when generating docx letter
  ([9834](https://github.com/civicrm/civicrm-core/pull/9834))**

- **[CRM-19950](https://issues.civicrm.org/jira/browse/CRM-19950) Wrong param
  passed to checkPermission function
  ([9832](https://github.com/civicrm/civicrm-core/pull/9832) and
  [9810](https://github.com/civicrm/civicrm-core/pull/9810))**

- **[CRM-18464](https://issues.civicrm.org/jira/browse/CRM-18464) Database Error
  upgrading to Civicrm 4.7
  ([9679](https://github.com/civicrm/civicrm-core/pull/9679))**

  Some legacy sites had a foreign key from `civicrm_action_schedule` to
  `mapping_id` set as an index rather than a proper foreign key.  Dropping that
  key as part of the upgrade to 4.7.alpha1 resulted in a failed upgrade.  The
  key is now dropped more safely.

- **[CRM-19979](https://issues.civicrm.org/jira/browse/CRM-19979)
  GroupContact.delete does not work for contacts with status of Pending
  ([9797](https://github.com/civicrm/civicrm-core/pull/9797))**

- **[CRM-19957](https://issues.civicrm.org/jira/browse/CRM-19957) DB Syntax
  Error on all Search Form submission
  ([9767](https://github.com/civicrm/civicrm-core/pull/9767))**

- **[CRM-19955](https://issues.civicrm.org/jira/browse/CRM-19955) custom field
  image display in contact record retrieve incorrectly
  ([9758](https://github.com/civicrm/civicrm-core/pull/9758))**

  This fixes a problem where files uploaded to custom fields were retrieved
  according to the ID of the entity they're attached to, not the ID of the files
  themselves.

- **[CRM-19926](https://issues.civicrm.org/jira/browse/CRM-19926) Constituent
  Summary Report Filtered by Groups ignores children groups
  ([9732](https://github.com/civicrm/civicrm-core/pull/9732))**

- **[CRM-18427](https://issues.civicrm.org/jira/browse/CRM-18427) Submitted
  custom data values not reloaded on form when validation fails
  ([9752](https://github.com/civicrm/civicrm-core/pull/9752))**

- **[CRM-19927](https://issues.civicrm.org/jira/browse/CRM-19927) Error message
  when "Add to Group" is pressed with no group selected
  ([9731](https://github.com/civicrm/civicrm-core/pull/9731))**

- **[CRM-19864](https://issues.civicrm.org/jira/browse/CRM-19864) Incorrect URL
  in CiviCRM Resources dashlet on Joomla
  ([9668](https://github.com/civicrm/civicrm-core/pull/9668))**

  The Configuration Checklist link in the Resources menu was a frontend link in
  WordPress and Joomla.

- **[CRM-20180](https://issues.civicrm.org/jira/browse/CRM-20180) Several
  documentation links are malformed
  ([9897](https://github.com/civicrm/civicrm-core/pull/9897))**

- **Handle date formats through metadata (see
  [CRM-19490](https://issues.civicrm.org/jira/browse/CRM-19490),
  [CRM-18387](https://issues.civicrm.org/jira/browse/CRM-18387),
  [CRM-20012](https://issues.civicrm.org/jira/browse/CRM-20012),
  [CRM-20011](https://issues.civicrm.org/jira/browse/CRM-20011),
  [CRM-15948](https://issues.civicrm.org/jira/browse/CRM-15948), and
  [CRM-19911](https://issues.civicrm.org/jira/browse/CRM-19911))
  (([9888](https://github.com/civicrm/civicrm-core/pull/9888),
  [9845](https://github.com/civicrm/civicrm-core/pull/9845),
  [9843](https://github.com/civicrm/civicrm-core/pull/9843), and
  [9830](https://github.com/civicrm/civicrm-core/pull/9830))) (Preliminary work)**

  A variety of problems periodically emerge with date fields, mainly due to the
  practically-unique ways of defining and handling each date field.  The goal of
  this work is to define all date fields through metadata.  Changes so far
  define the metadata for date fields, but the fields are still generated the
  old way.

- **[CRM-19887](https://issues.civicrm.org/jira/browse/CRM-19887) Activity
  Summary report gives DB error on sort by email
  ([9690](https://github.com/civicrm/civicrm-core/pull/9690))**

- **[CRM-19982](https://issues.civicrm.org/jira/browse/CRM-19982) Can't enter
  dates in 4.7.16. Can only enter characters in word "birth"
  ([9831](https://github.com/civicrm/civicrm-core/pull/9831))**

- **[CRM-19947](https://issues.civicrm.org/jira/browse/CRM-19947) custom multi
  profile: file upload display issue
  ([9754](https://github.com/civicrm/civicrm-core/pull/9754))**

  On profiles including fields from multi-record custom data sets, files
  uploaded in one record were appearing in other records on the same contact.

### CiviCase

- **[CRM-19956](https://issues.civicrm.org/jira/browse/CRM-19956) Moving/Copying
  activities between Cases
  ([9766](https://github.com/civicrm/civicrm-core/pull/9766))**

  This fixes an issue preventing the selection of a destination case when moving
  or copying activities.

### CiviContribute

- **[CRM-19830](https://issues.civicrm.org/jira/browse/CRM-19830) Cleanup
  contribution search by making non-exportable fields exportable
  ([9718](https://github.com/civicrm/civicrm-core/pull/9718))**

- **[CRM-19793](https://issues.civicrm.org/jira/browse/CRM-19793) Redirect
  payment processors that fail result in ugly fatal - be prettier
  ([9762](https://github.com/civicrm/civicrm-core/pull/9762))**

- **[CRM-19949](https://issues.civicrm.org/jira/browse/CRM-19949) Notice appear
  when setup profiles contain common field with contribution page
  ([9753](https://github.com/civicrm/civicrm-core/pull/9753))**

- **[CRM-19881](https://issues.civicrm.org/jira/browse/CRM-19881): Time
  clobbered in receive_date and trxn_date for api contribution repeattransaction
  and completetransaction
  ([9680](https://github.com/civicrm/civicrm-core/pull/9680))**

  The API spec for the contribution `gettransaction` and `repeattransaction`
  actions did not contain time, so the receive date and transaction dates were
  set to midnight.

- **[CRM-20145](https://issues.civicrm.org/jira/browse/CRM-20145) line_item with
  $0 amount may error when creating civicrm_entity_financial_trxn
  ([9866](https://github.com/civicrm/civicrm-core/pull/9866))**

- **[CRM-20048](https://issues.civicrm.org/jira/browse/CRM-20048) PayPal IPNs
  not processed if "receiver_email" != "business"
  ([9858](https://github.com/civicrm/civicrm-core/pull/9858))**

  This resolves problems if a site's PayPal account has a `receiver_email` that
  is different from the main email address for their business account.  CiviCRM
  now looks for the `business` email.

- **[CRM-19908](https://issues.civicrm.org/jira/browse/CRM-19908) Fundamental
  Fixes for Tax Math Calculations.
  ([9711](https://github.com/civicrm/civicrm-core/pull/9711))**

  This change defers rounding of tax amounts until after being multiplied by an
  item's quantity and avoids deriving a tax rate from the amount of tax on a
  line item.

- **[CRM-19517](https://issues.civicrm.org/jira/browse/CRM-19517) Show price
  field Options that use disabled Financial Types so they can be edited.
  ([9763](https://github.com/civicrm/civicrm-core/pull/9763))**

- **[CRM-19802](https://issues.civicrm.org/jira/browse/CRM-19802) Contribution
  page : missing translation
  ([9587](https://github.com/civicrm/civicrm-core/pull/9587))**

  This fixes the wrapping of translatable strings in Javascript within page
  templates.

- **[CRM-19873](https://issues.civicrm.org/jira/browse/CRM-19873)
  contribute.repeattransaction fails when contribution_recur_id is a test
  recurring contribtuion
  ([9674](https://github.com/civicrm/civicrm-core/pull/9674))**

### CiviEvent

- **[CRM-20004](https://issues.civicrm.org/jira/browse/CRM-20004) Event payment
  receipt sent twice
  ([9933](https://github.com/civicrm/civicrm-core/pull/9933))**

- **[CRM-19964](https://issues.civicrm.org/jira/browse/CRM-19964) Event
  registration creates contribution without line item
  ([9774](https://github.com/civicrm/civicrm-core/pull/9774))**

  This situation occurred if a price set was enabled, no price field was
  required, and a user registered for the event without any of the price fields
  having a value.

- **[CRM-19918](https://issues.civicrm.org/jira/browse/CRM-19918) Price field
  "Active on" date ignored in Edit Event Registration > "Change Selections"
  ([9764](https://github.com/civicrm/civicrm-core/pull/9764))**

- **[CRM-20170](https://issues.civicrm.org/jira/browse/CRM-20170) Fix attendee
  count on event summary report for free events
  ([9887](https://github.com/civicrm/civicrm-core/pull/9887))**

- **[CRM-20013](https://issues.civicrm.org/jira/browse/CRM-20013) Localization
  for participant status on Event Income Report (Summary)
  ([9833](https://github.com/civicrm/civicrm-core/pull/9833))**

  The participant status was showing the field name rather than the translated
  label.

### CiviMail

- **[CRM-20016](https://issues.civicrm.org/jira/browse/CRM-20016) Fatal error
  processing bounces when email_id IS NULL
  ([9837](https://github.com/civicrm/civicrm-core/pull/9837))**

- **[CRM-19924](https://issues.civicrm.org/jira/browse/CRM-19924) Unsubscribe
  from a mailing sent to a parent group silently fails
  ([9730](https://github.com/civicrm/civicrm-core/pull/9730))**

### CiviMember

- **[CRM-19871](https://issues.civicrm.org/jira/browse/CRM-19871) Default
  Membership Type not selected - Contribution Form
  ([9704](https://github.com/civicrm/civicrm-core/pull/9704))**

  The membership type on contribution pages was defaulting according to weight
  rather than the type marked as default.

- **[CRM-19936](https://issues.civicrm.org/jira/browse/CRM-19936) Membership
  line items are duplicated when a membership is created or renewed with
  priceset containing multiple memberships
  ([9744](https://github.com/civicrm/civicrm-core/pull/9744)) (Partially
  fixed)**

  Bug was as described.  The cause has been repaired, but the issue is still
  pending an action to repair the duplicate line items.

- **[CRM-20010](https://issues.civicrm.org/jira/browse/CRM-20010) Membership
  period_type is required in frontend but not in API.
  ([9829](https://github.com/civicrm/civicrm-core/pull/9829))**

- **[CRM-19945](https://issues.civicrm.org/jira/browse/CRM-19945)
  api.contribute.repeattransaction fails to renew membership under certain
  conditions ([9792](https://github.com/civicrm/civicrm-core/pull/9792))**

### Drupal Integration Modules

- **[CRM-19910](https://issues.civicrm.org/jira/browse/CRM-19910) Drupal view
  contact sub type IN query
  ([424](https://github.com/civicrm/civicrm-drupal/pull/424))**

  Views was attempting to filter contact subtype as a single-value field rather
  than a delimited multi-value field.

- **[CRM-20051](https://issues.civicrm.org/jira/browse/CRM-20051) Drupal 8 user
  view page, Profile information not displaying
  ([428](https://github.com/civicrm/civicrm-drupal/pull/428))**

  CiviCRM's implementation of `hook_user_view()` needed to reflect a change to
  the hook function signature.

- **[CRM-19960](https://issues.civicrm.org/jira/browse/CRM-19960) Drupal 8
  Standard Page title does not immediately disappear on contact record screen
  ([9770](https://github.com/civicrm/civicrm-core/pull/9770))**

- **[CRM-19545](https://issues.civicrm.org/jira/browse/CRM-19545) Custom field
  groups which do not directly extend the base 'Contact' disappear from Drupal
  view after applying patch CRM-18776
  ([417](https://github.com/civicrm/civicrm-drupal/pull/417))**

  This reverts a change for
  [CRM-18776](https://issues.civicrm.org/jira/browse/CRM-18776), which in turn
  was attempting to fix a bug with custom fields that apply to only certain
  types of an entity (e.g. activity types or financial types).  That original
  issue is still outstanding.

## <a name="misc"></a>Miscellany

- **[CRM-20154](https://issues.civicrm.org/jira/browse/CRM-20154) dedupe code
  improvement, remove unused autoflip parameter
  ([9893](https://github.com/civicrm/civicrm-core/pull/9893) and
  [9873](https://github.com/civicrm/civicrm-core/pull/9873))**

  This cleans up code and removes a parameter called `autoFlip` that was never
  fully implemented in the merging of duplicate contacts.

- **[CRM-20181](https://issues.civicrm.org/jira/browse/CRM-20181) Deprecate
  CRM_Core_Error::fatal()
  ([9900](https://github.com/civicrm/civicrm-core/pull/9900))**

- **MailingGroup API - Tighten up deprecations
  ([9892](https://github.com/civicrm/civicrm-core/pull/9892))**

- **More test output on intermittant error
  ([9871](https://github.com/civicrm/civicrm-core/pull/9871))**

  A test of reverting tables now sleeps for a second.

- **Remove mispelt param.
  ([9853](https://github.com/civicrm/civicrm-core/pull/9853))**

- **remove markdown files in /docs
  ([9771](https://github.com/civicrm/civicrm-core/pull/9771))**

- **civicrm_webtest.install - Restore access to edit message templates and tags
  ([9785](https://github.com/civicrm/civicrm-core/pull/9785))**

- **Update Test generated examples
  ([9798](https://github.com/civicrm/civicrm-core/pull/9798))**

- **[CRM-20007](https://issues.civicrm.org/jira/browse/CRM-20007)
  RepeatTransaction API does not use the Payment Processor's payment Instrument
  to determine Payment Instrument
  ([9826](https://github.com/civicrm/civicrm-core/pull/9826))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Andie Hunt; Australian Greens - Seamus Lee; Chanun
Chirattikanon; CiviCRM - Coleman Watts, Kurund Jalmi, Monish Deb, Tim Otten;
Francesc Bassas i Bullich; Freeform Solutions - Herb van den Dool; Fuzion -
Chris Burgess, Eileen McNaughton; Hartmann Computer Consulting - Peter Hartmann;
JMA Consulting - Edsel Lopez, Pradeep Nayak; John Kingsnorth; Lighthouse Design
and Consulting - Brian Shaughnessy; Matthew Wire; MongoDB - A. Jesse Jiryu
Davis; Sean Madsen; Semper IT - Karin Gerritsen; Skvare - Mark Hanna; Stephen
Palmstrom; Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Agileware - Agileware Team; Andrew Cormick-Dockery; Andrew McNaughton; Andrew
Thompson; Blackfly Solutions - Alan Dixon; Borislav Zlatanov; Circle Interactive -
Dave Jenkins; City of Winnipeg, Manitoba - Matt Allard; CiviCoop - Jaap Jansma;
CiviCRM - Jitendra Purohit, Yashodha Chaku; CiviDesk - Nicolas Ganivet, Steve
Kessler, Sunil Pawar; CompuCorp - Alessandro Verdura, Guanhuan Chen; Coop
SymbioTIC - Mathieu Lutfy, Stéphane Lussier; Davi Alexandre; Erich Schulz;
Jesper Angelo; JMA Consulting - Joe Murray, Jon Goldberg; Joinery - Allen Shaw;
Klangsoft - David Reedy Jr; Korlon - Stuart Gaston; MC3 - Graham Mitchell;
Monadnock Developmental Services - Charlie Wilder; Oxfam Germany - Thomas
Schüttler; Palante Technology Cooperative - Joseph Lacey; Progressive Technology
Project - Jamie McClelland; Skylark Technology - Owen Pearson; Spry Digital -
Ellen Hendricks; Squiffle Consulting - Aidan Saunders; Systopia - Björn Endres;
Tadpole Collective - Kevin Cristiano; Third Sector Design - Michael McAndrew;
Upleaf - Osvaldo Gomez; Vakees K; Valéry Gouleau; Veda Consulting - Kajakaran
Balakrishnan;
