(in-package :contextl)

(defclass partial-object (standard-object)
  ()
  (:default-initargs :allow-other-keys t))

#|
;; The following method ensures that partial objects accept all initargs.
(defmethod shared-initialize :after
  ((object partial-object) slot-names &key &allow-other-keys)
  (declare (ignore slot-names)))
|#

(defclass partial-class (standard-class)
  ((defining-classes :initarg :defining-classes
                     :initform ()
                     :accessor partial-class-defining-classes)
   (defining-metaclass :initarg :defining-metaclass
                       :initform (find-class 'standard-class)
                       :accessor partial-class-defining-metaclass)))

(defmethod validate-superclass
           ((class partial-class)
            (superclass standard-class))
  t)

(defmethod validate-superclass
           ((class standard-class)
            (superclass partial-class))
  t)

#+allegro
(defmethod finalize-inheritance :after ((class partial-class))
  (mapc #'finalize-inheritance (rest (class-precedence-list class))))

(defmethod initialize-instance :around
  ((class partial-class) &rest initargs
   &key name
   (in-layer '(t))
   (defining-metaclass '(standard-class)))
  (declare (dynamic-extent initargs))
  (when (cdr defining-metaclass)
    (error "Malformed :defining-metaclass option for class ~S." name))
  (let ((in-layer-name (layer-name (car in-layer)))
        (definer (car defining-metaclass))
        (direct-superclasses (list (find-class 'partial-object)))
        (defining-classes ()))
    (let ((defined-class
           (apply #'make-instance definer
                  (loop for (key value) on initargs by #'cddr
                        unless (member key '(:name :defining-metaclass))
                        nconc (list key value)))))
      (push defined-class direct-superclasses)
      (setf (getf defining-classes in-layer-name) defined-class))
    (unless (eq in-layer-name 't)
      (let ((defined-class (make-instance definer :in-layer in-layer)))
        (push defined-class direct-superclasses)
        (setf (getf defining-classes 't) defined-class)))
    (call-next-method class
                      :name name
                      :direct-superclasses direct-superclasses
                      :defining-classes defining-classes)))

(defmethod reinitialize-instance :around
  ((class partial-class) &rest initargs
   &key (name (class-name class))
   (in-layer '(t))
   (defining-metaclass (list (partial-class-defining-metaclass class))))
  (declare (dynamic-extent initargs))
  (when (cdr defining-metaclass)
    (error "Malformed :defining-metaclass option for class ~S." name))
  (let ((in-layer-name (layer-name (car in-layer)))
        (definer (car defining-metaclass)))
    (let ((defined-class (getf (partial-class-defining-classes class) in-layer-name)))
      (if defined-class
          (progn
            (apply #'reinitialize-instance defined-class
                   (loop for (key value) on initargs by #'cddr
                         unless (member key '(:name :defining-metaclass))
                         nconc (list key value)))
            (call-next-method class))
        (let ((defined-class
               (apply #'make-instance definer
                      (loop for (key value) on initargs by #'cddr
                            unless (member key '(:name :defining-metaclass))
                            nconc (list key value)))))
          (call-next-method class
                            :direct-superclasses
                            (append (remove (find-class 'partial-object)
                                            (class-direct-superclasses class))
                                    (list defined-class)
                                    (list (find-class 'partial-object)))
                            :defining-classes
                            (list* in-layer-name defined-class
                                   (partial-class-defining-classes class))))))))
