;;; -*- Syntax: Ansi-Common-Lisp; Base: 10; Mode: lisp; Package: odcl -*-
;;; $Id: currency.lisp,v 1.8 2003/09/23 22:32:26 craig Exp $
;;;
;;; Copyright (c) 2000 - 2003 onShore Development, Inc.

;;; Manipulation of amounts of money
;;;
;;; Amounts of money are stored as integers in lisp, and numeric(x,2)
;;; types in SQL.
;;;
;;; TODO: write lisp accessors for dollars, cents, math functions.
;; Localize.

(in-package :odcl)

(defstruct (decimal-currency (:print-function print-decimal-currency))
  amount)

(defun print-decimal-currency (currency stream depth)
  (declare (ignore depth))
  (print-unreadable-object (currency stream :type t :identity t)
    (multiple-value-bind (dollars cents)
        (floor (decimal-currency-amount currency) 100)
      (format stream "$~d.~2,'0d" dollars cents))))

;; ------------------------------------------------------------
;; function: parse-currency
;;
;; Accept a string of the form "$[dollars].[cents]", and return a
;; decimal-currency structure.

(defun parse-currency (string &key (return-type :integer))
  (when (integerp string)
    (return-from parse-currency string))
  (let ((dollars 0)
        (cents 0))
    (typecase string
      (string
       (let* ((string (remove-if-not #'(lambda (a) (find a "-.0123456789")) string))
              (decimal-pt (position #\. string)))
         (setf dollars (or (parse-integer string :junk-allowed t) 0))
         (setf cents (or (and decimal-pt
                              (< decimal-pt (length string))
                              (parse-integer string :start (+ 1 decimal-pt)
                                             :junk-allowed t))
                         0))
         (when (and cents dollars)
           (when (and (< cents 10)
                      decimal-pt
                      (not (char= (aref string (1+ decimal-pt)) #\0)))
             (setf cents (* 10 cents)))
           (do ((c cents (round (/ c 10))))
               ((< c 100) (setq cents c)))))))
    (case return-type
      (:struct
       (make-decimal-currency :amount (+ (* 100 dollars) cents)))
      (t
       (+ (* 100 dollars) (if (minusp dollars) (- cents) cents))))))

;; Store as RDBMs records

#+disabled
(eval-when (:compile-toplevel :load-toplevel)

  (defmethod maisql-sys::database-output-sql-as-type ((type (eql 'decimal-currency)) currency database)
    (declare (ignore database))
    (/ (decimal-currency-amount currency) 100.00))
  
  (defmethod maisql-sys::database-get-type-specifier
    ((type (eql 'decimal-currency)) args database)
    (declare (ignore database args))
    "NUMERIC(7,2)")

  (defmethod maisql-sys::read-sql-value
    (val (type (eql 'decimal-currency)) database)
    (declare (ignore database))
    (parse-currency val))
  )                                     ; eval-when
