#!/usr/bin/env python

########################################################################
# Chris's Lame Filebrowser 4 (Main Widget Creation Script: Toolbar, Layouts, etc.)
# Copyright 2004, Gabe Ginorio <gabe@zevallos.com.br>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
######################################################################

import string, os, os.path, commands, textwrap
import pygtk, gtk, gtk.gdk
from Create import *

#####################################################
# Initialize the main widget
#####################################################
def initialize(parent_table):

	# Create the paned widget for the main notebook and the sidebar notebook
	main_pane = gtk.HPaned()
	parent_table.attach(main_pane, 0,2,2,3, gtk.EXPAND|gtk.FILL)

	# Create the main notebook
	Notebook = notebook.create()
	main_pane.pack2(Notebook.main_notebook, resize=True, shrink=False)
	
	
	# Create the widget toolbar
	Toolbar = toolbar.create(Notebook)
	parent_table.attach(Toolbar.handle_box, 0, 2, 0, 1, gtk.EXPAND|gtk.FILL, gtk.FILL)

	# Create the address bar for the main widget
	Addressbar = addressbar.create(Notebook)
	parent_table.attach(Addressbar.handle_box, 0,2,1,2, gtk.EXPAND|gtk.FILL, gtk.FILL)

	# Create the function section
	Sidebar = system_bar.create(Notebook)
	main_pane.pack1(Sidebar.main_notebook, resize=True, shrink=True)
	main_pane.show_all()

	main_pane.set_property('position', 110)
	
	# Create the info bar and the list button
	bottom_box = infobar.create(Notebook)
	parent_table.attach(bottom_box, 0,2,4,5, gtk.FILL, gtk.SHRINK)
	
	# Let the notebook know about the info bar
	Notebook.addInfoBar(bottom_box.get_children()[0])

