#!/usr/bin/env python

########################################################################
# Chris's Lame Filebrowser 4 (Creates the find dialog and list)
# Copyright 2004, Gabe Ginorio <gabe@zevallos.com.br>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
######################################################################

import commands, os.path, string
import gtk, pygtk, gtk.gdk
import mimetype


def create(Notebook, query_string):
	'''The class creates a dialog that lists the results of the find command'''

	# Create the main widget, a scrolled window and a tree view
	main_window = gtk.Window(gtk.WINDOW_TOPLEVEL)
	main_window.set_title("Claw 4 File Finder")
	main_window.connect("delete-event", __quit_dialog__)
	main_window.resize(200, 200)

	main_scroll = gtk.ScrolledWindow()
	main_window.add(main_scroll)

	main_treestore = gtk.TreeStore(str, str)
	main_treeview = gtk.TreeView(main_treestore)
	main_treeview.set_events(gtk.gdk.BUTTON_PRESS_MASK)
	main_treeview.connect("button_press_event", __fileSelected__, Notebook)
	main_scroll.add_with_viewport(main_treeview)	

	tree_column_name = gtk.TreeViewColumn()
	tree_column_location = gtk.TreeViewColumn()

	text_renderer = gtk.CellRendererText()

	tree_column_name.pack_start(text_renderer, True)
	tree_column_location.pack_start(text_renderer, False)

	tree_column_name.add_attribute(text_renderer,  "text", 0)
	tree_column_location.add_attribute(text_renderer , "text", 1)
	
	main_treeview.append_column(tree_column_name)
	main_treeview.append_column(tree_column_location)

	main_window.show_all()

	# Get the query results using "locate"
	results = __findFiles__(query_string)

	# Add the results to the tree
	__populate__(main_treestore, results)

	# Resize the whole thing (Once it's done, that is)
	while gtk.events_pending():
		gtk.main_iteration()

	width = main_treeview.allocation.width
	if width < 485:
		main_window.resize(width + 15, 200)
	else:
		main_window.resize(500, 200)


def __findFiles__(query_string):
	'''The function trys to "locate" the files in the query string '''

	results =	commands.getstatusoutput("locate " + __returnClean__(query_string))
	results = string.split(results[1], "\n")

	return results

def __populate__(main_treestore, results):
	'''This function adds one row per result of the locate command'''
	
	for location in results:
		main_treestore.append(None,  [os.path.basename(location), location])


def __fileSelected__(main_treeview, event, Notebook):
	'''This is the callback for a clicked tree view'''

	# Get the selected location (If on exists)
	selection =  main_treeview.get_selection()
	main_tree_store, selected_iter = selection.get_selected()
	
	if selected_iter:
		location = main_tree_store.get_value(selected_iter, 1)

		if os.path.exists(location):
		
			# A right click opens the file's location in a new tab 
			if event.button == 3:
				Notebook.newNotebookPage(os.path.dirname(location))

			# A double left click tries to open the file with it first associated application 
			elif event.button == 1 and event.type == gtk.gdk._2BUTTON_PRESS|gtk.gdk.BUTTON_PRESS:
				mime_type = mimetype.getTypes(None, location)
				associated_app = mimetype.get_associated_applications(mime_type[location])[0]

				if associated_app == None:
					print "ERROR: This file type has no associated application"
				elif associated_app == "EXECUTABLE":
					os.popen2(location)
				else:
					os.popen2(associated_app + " " + __returnClean__(location))


def __returnClean__(text):

	badChars = [" ","\'","&","(",")"]
	goodChars=["\ ","\\'","\&","\(","\)"]

	# Replace the bad with the good
	for x in range(len(badChars)):
		text = string.replace(text, badChars[x], goodChars[x])

	# Return the "cleaned", BASH friendly text
	return text


def __quit_dialog__(main_window, event):
	main_window.destroy()