use Language::INTERCAL;
use Language::INTERCAL::Runtime::Library;

print "1..12\n";

fiddle Language::INTERCAL 'bug=0', 'ubug=0';

my $parse_tree = parse Language::INTERCAL '
	@@{@@M]@@@|
	@@{@@M]@@@|
	@@{@@M]@@@|
	@@{@@M]@@@|
	@K@L`@{
	@K@L`@{
	@@K@@@{@N@{
	@@K@@@{@N@{
	@K@@{
	@K@@{
	@K@@{
	@K@@{
	@@
M]	@@|@@|
M]	@@|@@|
	@@@M]
	@@@[[|@
	@@|@@[|
	@@
M]	@z@L`@[|@J@{
	@@@z
	@@
M]	@z@L`@[|@J@{
	@@@z
	@@
';

my @foo;

backend $parse_tree 'Perl', 'prog';

@foo = ();
eval { prog(0, \@foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 1\n";
print @foo == 4 ? "" : "not ", "ok 2\n";
print "II\n" eq (shift @foo) ? "" : "not ", "ok 3\n";
print "VIII\n" eq (shift @foo) ? "" : "not ", "ok 4\n";
print "V\n" eq (shift @foo) ? "" : "not ", "ok 5\n";
print "XXXV\n" eq (shift @foo) ? "" : "not ", "ok 6\n";

optimise $parse_tree;
backend $parse_tree 'Perl', 'prog_o';

@foo = ();
eval { prog_o(0, \@foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 7\n";
print @foo == 4 ? "" : "not ", "ok 8\n";
print "II\n" eq (shift @foo) ? "" : "not ", "ok 9\n";
print "VIII\n" eq (shift @foo) ? "" : "not ", "ok 10\n";
print "V\n" eq (shift @foo) ? "" : "not ", "ok 11\n";
print "XXXV\n" eq (shift @foo) ? "" : "not ", "ok 12\n";

