###########################################################################
# clive, video extraction utility
# Copyright (C) 2007 Toni Gundogdu
#
# clive is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 0.1.2-1307 USA
###########################################################################

import urllib2
import gzip
import os.path
import time
import md5
import mimetools

from cStringIO import StringIO


__all__ = ['HTTPGet']


class HTTPGet:
  """
  Wraps urllib2 for user-agent and gzip encoding.
    NOTE: gzip is disabled for .get() calls with 'saveas' parameter
    NOTE: authenticated proxy support remains untested
    NOTE: privoxy 3.0.6 forces uncompressed encoding (configurable?)
  """
  def __init__(
      self,
      proxy=(True,None,None,None), # useproxy, host, username, password
      agent=None,
      progresshook=None,
      cookies=(False,None), # usecookies, cookiefile
      gzip=True):
    """Constructor"""
    self.agent = agent
    self.progresshook = progresshook
    self.gzip = gzip
    self._newopener(cookies,proxy)

  def get(self, url, saveas=None, referer=None):
    # Disable gzip if saveas parameter is being used
    if self.gzip and saveas:
      use_gzip = False
    else:
      use_gzip = self.gzip

    req = self._newreq(url,referer,use_gzip)
    #print req.headers
    o = self.opener.open(req)
    #print o.info()
    
    self.length = self._getlength(o.headers)
    self.data = ''
    self.read = 0
    self.file = None

    if saveas:
      self.file = open(saveas,'w')

    while 1:
      b = o.read(1024)
      if not b: break
      self._handledata(b)
      if self.progresshook:
        self.progresshook(self.read, self.length)

    if o.headers.get('content-encoding') == 'gzip':
      self.data = gzip.GzipFile(fileobj=StringIO(self.data)).read()
      if self.length == -1:
        self.length = len(self.data)

    o.close()

    if self.file:
      self.file.close()

  def submit(self, url, data, read=True):
    req = self._newreq(url,None,self.gzip)
    o = self.opener.open(req,data)
    if read:
      self.length = self._getlength(o.headers)
      self.data = o.read()
      if o.headers.get('content-encoding') == 'gzip':
        self.data = gzip.GzipFile(fileobj=StringIO(self.data)).read()
        if self.length == -1:
          self.length = len(self.data)    
    o.close()

  def reqlength(self, url, referer=None):
    """
    Open the URL and retrieve content-length information
    """
    # Keep a backup of the progresshook
    # Disable the hook for content-length retrieval
    hook = self.progresshook
    self.progresshook = None
    # Retrieve length
    req = self._newreq(url,referer,gzip=False)
    o = self.opener.open(req)
    length = self._getlength(o.headers)
    o.close()
    # Restore the progresshook backup
    self.progresshook = hook
    return length

  def addcookie(self, name, host, value=None, expire=None):
    """
    Append a new cookie to the cookie jar.
    """
    if self.cjar != None:
      gmt = time.gmtime(time.time())
      if not value:
        value = time.asctime(gmt)
        value = md5.new(value).hexdigest()
      if not expire:
        now = list(gmt)
        now[0] += 10
        now = time.mktime(tuple(now))
        if self.lcookie:
          expire = self.lcookie.time2isoz(now)
        else:
          expire = self.ccookie.time2isoz(now)
      headers = ['Set-Cookie: %s=%s; expire=%s;' % (name,value,expire)]
      req = self.Request(host)
      res = FakeResponse(headers,host)
      cookies = self.cjar.make_cookies(res,req)
      cookies[0].discard = False
      self.cjar.set_cookie(cookies[0])

  # Non-public

  def _newopener(self, cookies, proxy):
    """Construct a new opener"""
    (ph,auth) = self._setproxy(proxy)
    ch = self._setcjar(cookies)
    self.opener = urllib2.build_opener(ph,auth,ch)

  def _setproxy(self, proxy):
    """Set proxy for the connection"""
    auth = None
    proxies = None # Default: use http_proxy env. variable for proxy
    (useproxy,host,username,password) = proxy
    if useproxy:
      if host:
        proxies = {'http':host}
        if username:
          if not password: password = ''
          mgr = urllib2.HTTPPasswordMgrWithDefaultRealm()
          mgr.add_password(None, host, username, password)
          auth = urllib2.ProxyBasicAuthHandler(mgr)
    else:
      proxies = {} # Disable proxy support
    return (urllib2.ProxyHandler(proxies),auth)

  def _setcjar(self, cookies):
    """Based on voidspace.org.uk example"""
    (self.usecookies, self.cookiefile) = cookies
    self.cjar = None
    self.ccookie = None
    self.lcookie = None

    try:
      import cookielib
    except ImportError:
      try:
        import ClientCookie
      except ImportError:
        if self.usecookies:
          raise CliveError('error : no cookie support')
        self.usecookies = False
        self.urlopen = urllib2.urlopen
        self.Request = urllib2.Request
      else:
        self.urlopen = ClientCookie.urlopen
        self.Request = ClientCookie.Request
        self.cjar = ClientCookie.LWPCookieJar()
        self.ccookie = ClientCookie
    else:
      self.urlopen = urllib2.urlopen
      self.Request = urllib2.Request
      self.cjar = cookielib.LWPCookieJar()
      self.lcookie = cookielib

    if self.cjar != None and self.cookiefile:
      # Open cookie file (if avail.) and create
      # a HTTP cookie processor for the opener
      if os.path.isfile(self.cookiefile):
        self.cjar.load(self.cookiefile, ignore_discard=True)
      if self.lcookie:
        return urllib2.HTTPCookieProcessor(self.cjar)
      else:
        return self.ccookie.build_opener( \
          self.ccookie.HTTPCookieProcessor(self.cjar))
    return None

  def _newreq(self, url, referer, gzip):
    """
    Create a new request, append customized
    header elements as needed.
    """
    req = self.Request(url)
    if self.agent:
      req.add_header('user-agent',self.agent)
    if gzip:
      req.add_header('accept-encoding','gzip')
    if referer:
      req.add_header('referer',referer)
    return req

  def _handledata(self, data):
    """
    Stores received data to a specified file
    or an internal buffer.

    NOTE: Opens the specified file if needed
    """
    self.read += len(data)
    if self.file:
      self.file.write(data)
    else:
      self.data += data

  def _getlength(self, headers):
    """
    Returns numeric content-length, sets None as -1
    """
    length = headers.get('content-length')
    if not length:
      length = -1
    return long(length)


class FakeResponse:
  """
  Used as a response for creating cookies
  manually.

  Blatantly copied from the cookielib unit tests.
  """
  def __init__(self, headers=[], url=None):
    f = StringIO('\n'.join(headers))
    self._headers = mimetools.Message(f)
    self._url = url

  def info(self):
    return self._headers
