// Copyright (c) 2000-2002 Clifton Labs, Inc.  
// All rights reserved.

// Clifton Labs MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  Clifton Labs SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Dale E. Martin   dmartin@cliftonlabs.com

#include <iostream>
#include "ArgumentParserTest.h"
#include "ConfigurationParserTest.h"
#include "FileManagerTest.h"
#include "PluginManagerTest.h"
#include "FieldIteratorTest.h"
using std::cerr;
using std::endl;

bool oneFailed = false;

void testFileManager(){
  int fileManagerStatus = FileManagerTest::instance()->regressionTest();
  if( fileManagerStatus != 0 ){
    cerr << "FileManager test failed." << endl;
    oneFailed = true;
  }
  else{
    cerr << "FileManager test passed." << endl;
  }
}

void testPluginManager(){
  int pluginManagerStatus = PluginManagerTest::instance()->regressionTest();
  if( pluginManagerStatus != 0 ){
    cerr << "PluginManager test failed." << endl;
    oneFailed = true;
  }
  else{
    cerr << "PluginManager test passed." << endl;
  }
}

void testConfigurationParser(){
  int configurationParserStatus = ConfigurationParserTest::instance()->regressionTest();
  if( configurationParserStatus != 0 ){
    cerr << "ConfigurationParser test failed." << endl;
    oneFailed = true;
  }
  else{
    cerr << "ConfigurationParser test passed." << endl;
  }
}

void testArgumentParser(){
  int argParserStatus = ArgumentParserTest::instance()->regressionTest();
  if( argParserStatus != 0 ){
    cerr << "ArgumentParser test failed." << endl;
    oneFailed = true;
  }
  else{
    cerr << "ArgumentParser test passed." << endl;
  }
}

void testFieldIterator(){
  int tokenizingIteratorStatus = FieldIteratorTest::instance()->regressionTest();
  if( tokenizingIteratorStatus != 0 ){
    cerr << "FieldIterator test failed." << endl;
    oneFailed = true;
  }
  else{
    cerr << "FieldIterator test passed." << endl;
  }
}

int
main( int argc, char *argv[] ){
  testArgumentParser();
  testConfigurationParser();
  testFileManager();
  testPluginManager();
  testFieldIterator();

  if( oneFailed == true ){
    cerr << "WARNING - AT LEAST ONE TEST FAILED" << endl;
  }
  else{
    cerr << "All tests passed" << endl;
  }
}

