/*
 * Copyright 2010 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of either or both of the following licenses:
 *
 * 1) the GNU Lesser General Public License version 3, as published by the
 * Free Software Foundation; and/or
 * 2) the GNU Lesser General Public License version 2.1, as published by
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the applicable version of the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of both the GNU Lesser General Public
 * License version 3 and version 2.1 along with this program.  If not, see
 * <http://www.gnu.org/licenses/>
 *
 * Authored by: Mirco Müller <mirco.mueller@canonical.com>
 */

#ifndef _CTK_LAYER_H_
#define _CTK_LAYER_H_

#include <glib.h>
#include <clutter/clutter.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

G_BEGIN_DECLS

#define CTK_TYPE_LAYER (ctk_layer_get_type ())

#define CTK_LAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	CTK_TYPE_LAYER, CtkLayer))

#define CTK_LAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	CTK_TYPE_LAYER, CtkLayerClass))

#define CTK_IS_LAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	CTK_TYPE_LAYER))

#define CTK_IS_LAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	CTK_TYPE_LAYER))

#define CTK_LAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	CTK_TYPE_LAYER, CtkLayerClass))

typedef enum _CtkLayerRepeatMode
{
  CTK_LAYER_REPEAT_NONE = 0,
  CTK_LAYER_REPEAT_X,
  CTK_LAYER_REPEAT_Y,
} CtkLayerRepeatMode;

typedef struct _CtkLayer        CtkLayer;
typedef struct _CtkLayerClass   CtkLayerClass;
typedef struct _CtkLayerPrivate CtkLayerPrivate;

struct _CtkLayer
{
  GObject          parent;
  CtkLayerPrivate* priv;
};

struct _CtkLayerClass
{
  GObjectClass parent_class;

  /*< private >*/
  void (*_layer_padding1) (void);
  void (*_layer_padding2) (void);
  void (*_layer_padding3) (void);
  void (*_layer_padding4) (void);
  void (*_layer_padding5) (void);
  void (*_layer_padding6) (void);
};

GType
ctk_layer_get_type (void) G_GNUC_CONST;

CtkLayer*
ctk_layer_new (guint              width,
               guint              height,
               CtkLayerRepeatMode image_repeat,
               CtkLayerRepeatMode mask_repeat);

guint
ctk_layer_get_width (CtkLayer* self);

void
ctk_layer_set_width (CtkLayer* self,
                     guint     width);

guint
ctk_layer_get_height (CtkLayer* self);

void
ctk_layer_set_height (CtkLayer* self,
                      guint     height);

void
ctk_layer_get_color (CtkLayer*     self,
                     ClutterColor* color);

void
ctk_layer_set_color (CtkLayer*     self,
                     ClutterColor* color);

guint8
ctk_layer_get_opacity (CtkLayer* self);

void
ctk_layer_set_opacity (CtkLayer* self,
                       guint8    opacity);

void
ctk_layer_set_image_pixbuf (CtkLayer*  self,
                            GdkPixbuf* pixbuf);

GdkPixbuf*
ctk_layer_get_image_pixbuf (CtkLayer* self);

void
ctk_layer_set_mask_pixbuf (CtkLayer*  self,
                           GdkPixbuf* pixbuf);

GdkPixbuf*
ctk_layer_get_mask_pixbuf (CtkLayer* self);

void
ctk_layer_set_image_from_file (CtkLayer* self,
                               gchar*    filename);

void
ctk_layer_set_image_from_pixbuf (CtkLayer*  self,
                                 GdkPixbuf* pixbuf);

void
ctk_layer_set_image_from_surface (CtkLayer*        self,
                                  cairo_surface_t* surface);

void
ctk_layer_set_mask_from_file (CtkLayer* self,
                              gchar*    filename);

void
ctk_layer_set_mask_from_pixbuf (CtkLayer*  self,
                                GdkPixbuf* pixbuf);

void
ctk_layer_set_mask_from_surface (CtkLayer*        self,
                                 cairo_surface_t* surface);

void
ctk_layer_set_image_from_id (CtkLayer*        self,  guint id);

void
ctk_layer_set_mask_from_id (CtkLayer*        self,  guint id);

guint
ctk_layer_get_image_id (CtkLayer* self);

guint
ctk_layer_get_mask_id (CtkLayer* self);

void
ctk_layer_set_image_repeat_mode (CtkLayer*          self,
                                 CtkLayerRepeatMode repeat);

CtkLayerRepeatMode
ctk_layer_get_image_repeat_mode (CtkLayer* self);

void
ctk_layer_set_mask_repeat_mode (CtkLayer*          self,
                                CtkLayerRepeatMode repeat);

CtkLayerRepeatMode
ctk_layer_get_mask_repeat_mode (CtkLayer* self);

gboolean
ctk_layer_is_valid (CtkLayer* self);

gboolean
ctk_layer_get_enabled (CtkLayer* self);

void
ctk_layer_set_enabled (CtkLayer* self,
                       gboolean  enabled);


G_END_DECLS

#endif /* _CTK_LAYER_H_ */
