/*
 * Copyright (C) 2009 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include <glib.h>
#include <stdlib.h>
#include <clutk/clutk.h>

static void test_allocation (void);

void
test_effect_context_create_suite (void)
{
#define DOMAIN "/EffectContext"

  g_test_add_func (DOMAIN"/Allocation", test_allocation);
}

static void
test_allocation (void)
{
  ClutterStage     *stage = NULL;
  CtkEffectContext *ctx = NULL;
  ClutterActor     *actor;

  /* Make sure we can't create a CtkEffectContext unless without a real
   * stage
   */
  if (g_test_trap_fork (0,
                         G_TEST_TRAP_SILENCE_STDOUT|G_TEST_TRAP_SILENCE_STDERR))
    ctx = ctk_effect_context_get_default_for_stage (stage);
  g_test_trap_assert_failed ();

  /* Make sure it works with a real stage */
  stage = (ClutterStage *)clutter_stage_get_default ();
  ctx = ctk_effect_context_get_default_for_stage (stage);
  g_assert (CTK_IS_EFFECT_CONTEXT (ctx));

  /* Make sure the same ctx is returned for the same stage */
  g_assert (ctx == ctk_effect_context_get_default_for_stage (stage));

  /* Make sure we don't get a context for an actor that hasn't been added to a
   * stage
   */
  actor = clutter_rectangle_new ();
  if (g_test_trap_fork (0,
                         G_TEST_TRAP_SILENCE_STDOUT|G_TEST_TRAP_SILENCE_STDERR))
      ctx = ctk_effect_context_get_default_for_actor (actor);
  g_test_trap_assert_failed ();
 
  /* And now it should work */
  clutter_container_add_actor (CLUTTER_CONTAINER (stage), actor);
  g_assert (ctx == ctk_effect_context_get_default_for_actor (actor));

  /* Test that the context only has one reference regardless of n get_default */
  g_object_unref (ctx);
  g_assert (CTK_IS_EFFECT_CONTEXT (ctx) == FALSE);
}
