;;; cmail-use-simap4.el --- use simap4 to access email

;; Author: Takeshi Morishima (tm@onepost.net)
;; Keywords: mail
;; Created at: Sat Feb 26 15:39:56 JST 2000

;; This file is part of cmail (a mail utility for GNU Emacs)

;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License as
;; published by the Free Software Foundation; either version 2, or (at
;; your option) any later version.

;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to
;; the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary:

;; This is a cmail option feature module for simap4.el.

;;; Code:

(require 'path-util)
(require 'cmail-vars)
(require 'cmail-modes)
(require 'cmail-folders)

;;; Customize variables
(cmail-i18n-defgroup cmail-simap4-group nil
  ((ja_JP . "simap4.el$B$rMxMQ$7$F(BIMAP4$B%5!<%P$K%"%/%;%9$9$k$?$a$N@_Dj!#(B")
   (en_US . "Customization for accessing mail servers using simap4.el."))
  :group 'cmail-other-features)

(defun cmail-set-simap4 (var flag)
  (set var flag)
  (if flag (cmail-use-simap4-setup)
    (cmail-use-simap4-unsetup)))

(defun cmail-use-simap4-setup ()

  (setq cmail-content-supply-function 'cmail-simap4-supply-body)
  (autoload 'cmail-simap4-supply-body "cmail-simap4")

  (setq cmail-message-copy-function 'cmail-simap4-copy-message)
  (autoload 'cmail-simap4-copy-body "cmail-simap4")

  (setq cmail-message-delete-function 'cmail-simap4-delete-message)
  (autoload 'cmail-simap4-delete-message "cmail-simap4")

  (setq cmail-message-mark-function 'cmail-simap4-mark-message)
  (autoload 'cmail-simap4-mark-message "cmail-simap4")

  (setq cmail-message-status-function 'cmail-simap4-message-status)
  (autoload 'cmail-simap4-message-status "cmail-simap4")

  (setq cmail-message-expunge-function 'cmail-simap4-expunge-messages)
  (autoload 'cmail-simap4-expunge-messages "cmail-simap4")

  (setq cmail-mailbox-open-function 'cmail-simap4-open-mailbox)
  (autoload 'cmail-simap4-open-mailbox "cmail-simap4")

  (setq cmail-mailbox-delete-function 'cmail-simap4-delete-mailbox)
  (autoload 'cmail-simap4-delete-mailbox "cmail-simap4")

  (setq cmail-mailbox-rename-function 'cmail-simap4-rename-mailbox)
  (autoload 'cmail-simap4-rename-mailbox "cmail-simap4")

  (setq cmail-mailbox-copy-function 'cmail-simap4-copy-mailbox)
  (autoload 'cmail-simap4-copy-mailbox "cmail-simap4")

  (setq cmail-mailbox-search-function 'cmail-simap4-search-mailbox)
  (autoload 'cmail-simap4-search-mailbox "cmail-simap4")

  (setq cmail-folders-update-function 'cmail-simap4-sync-folders)
  (autoload 'cmail-simap4-sync-folders "cmail-simap4")

  (setq cmail-folders-search-function 'cmail-simap4-search-folders)
  (autoload 'cmail-simap4-search-folders "cmail-simap4")

  (setq cmail-summary-message-fetch-function 'cmail-simap4-get-new-messages)
  (autoload 'cmail-simap4-sync-folders "cmail-simap4")

  (setq cmail-virtual-folder-check-function 'cmail-simap4-firtual-folder-p)
  (autoload 'cmail-simap4-sync-folders "cmail-simap4")

  (add-hook 'cmail-open-folder-hook 'cmail-simap4-open-folder-hook)
  (autoload 'cmail-simap4-open-folder-hook "cmail-simap4")

  (add-hook 'cmail-quit-hook 'cmail-simap4-quit)
  (autoload 'cmail-simap4-quit "cmail-simap4")

  (define-key cmail-summary-mode-map "\C-c " 'cmail-simap4-force-read-content)
  (autoload 'cmail-simap4-force-read-content "cmail-simap4" "" t)
  (define-key cmail-summary-mode-map "G" 'cmail-simap4-sync-folder)
  (autoload 'cmail-simap4-sync-folder "cmail-simap4" "" t)
  (define-key cmail-folders-mode-map "G" 'cmail-simap4-sync-all-folders)
  (autoload 'cmail-simap4-sync-all-folder "cmail-simap4" "" t)
  (define-key cmail-summary-mode-map "\M-s" 'cmail-simap4-search)
  (define-key cmail-folders-mode-map "\M-s" 'cmail-simap4-search)
  (autoload 'cmail-simap4-search "cmail-simap4" "" t))

(defun cmail-use-simap4-unsetup ()
  (setq cmail-content-supply-function nil)
  (setq cmail-message-copy-function nil)
  (setq cmail-message-delete-function nil)
  (setq cmail-message-mark-function nil)
  (setq cmail-message-status-function nil)
  (setq cmail-message-expunge-function nil)
  (setq cmail-mailbox-open-function nil)
  (setq cmail-mailbox-delete-function nil)
  (setq cmail-mailbox-rename-function nil)
  (setq cmail-mailbox-copy-function nil)
  (setq cmail-mailbox-search-function nil)
  (setq cmail-folders-update-function nil)
  (setq cmail-folders-search-function nil)
  (setq cmail-summary-message-fetch-function nil)
  (setq cmail-virtual-folder-check-function nil)
  (remove-hook 'cmail-open-folder-hook 'cmail-simap4-open-folder-hook)
  (remove-hook 'cmail-quit-hook 'cmail-simap4-quit)
  (define-key cmail-summary-mode-map "\C-c " nil)
  (define-key cmail-summary-mode-map "\M-s" nil)
  (define-key cmail-folders-mode-map "\M-s" nil)
  (if (featurep 'cmail-simap4) (unload-feature 'cmail-simap4)))

(cmail-i18n-defcustom cmail-use-simap4 nil
  ((ja_JP . "\
*Non nil $B$J$i$P(B simap4.el $B$rMxMQ$7$F(B IMAP4 $B%5!<%P$K%"%/%;%9$9$k!#(B")
   (en_US . "\
*Non nil means use simap4.el to access IMAP4 servers."))
  :type 'boolean
  :set 'cmail-set-simap4
  :group 'cmail-all-variables
  :group 'cmail-simap4-group)
(cmail-custom-add-init 'cmail-set-simap4 'cmail-use-simap4)

(cmail-i18n-defcustom cmail-simap4-servers nil
  ((ja_JP . "\
*Simple IMAP4 $BMQ$N%5!<%P@_Dj!#(B

$B3F%U%#!<%k%I$O<!$N0UL#$K$J$j$^$9!#(B

Record Format: $B%l%3!<%I$N%U%)!<%^%C%H%P!<%8%g%s!#JQ99$G$-$^$;$s!#(B
Record State: $B$3$N%5!<%P$K@\B3$7$?$/$J$$>l9g(B inactive $B$K$7$^$9!#(B
Server: IMAP4 $B%5!<%PL>!#(B
UserID: IMAP4 $B%5!<%P$K%m%0%$%s$9$k;~$N%f!<%6<1JLJ8;zNs!#(B
TopDir: $B%m!<%+%k%[%9%H>e$N%G%#%l%/%H%j!#(Bcmail-path $B$+$iAjBP%Q%9!#(B
        $B@_Dj$5$l$F$$$J$1$l$P%f!<%6(BID@$B%5!<%PL>$,%G%#%l%/%H%j$H$J(B
        $B$j$^$9!#(B
Virtual Folder: $B%m!<%+%k%[%9%H>e$G2>A[%U%)%k%@$r;HMQ$9$k$+!#2>(B
        $BA[%U%)%k%@$@$H!"(Bcmail $B=*N;;~%@%&%s%m!<%I>pJs$O>C$($F$7(B
        $B$^$$$^$9!#(B
Mailboxes to Hide: $B%U%)%k%@F14|$GL5;k$9$k(B mailbox $BL>$NJ8;zNs$N(B
        $B%j%9%H!#(B \"regexp: \" $B$G;O$^$k>l9g@55,I=8=$H$_$J$5$l$^$9!#(B
DraftMbox: $B%I%i%U%H$rJ]B8$9$k(B mailbox $BL>$NJ8;zNs!#(B($B$^$@%5%]!<%H(B
        $B$7$F$^$;$s!#(B)
CFfile: $B$3$N%5!<%P@lMQ$N<+F0J,N`%k!<%k$J$I$rJ]B8$9$k%U%!%$%kL>!#(B
        ($B$^$@%5%]!<%H$7$F$^$;$s!#(B)
Startup Folder Sync Mode:  $B%9%?!<%H$7$F:G=i$NF14|$r$I$N$h$&$K$H$k$+!#(B
        Default: $B2>A[%U%)%k%@$r;HMQ$7$F$$$J$$>l9g(B Quick scan $B$r;H$&(B
                 $B2>A[%U%)%k%@$r;HMQ$7$F$$$J$$>l9g(B Full sync $B$r;H$&(B
        Desginated folders only: \"Mailboxes to sync\" $B$K@_Dj$5$l$?(B
                 mailbox $B$N$_$rF14|$9$k!#%U%i%0$,99?7$5$l$k$+$I$&$+(B
                 $B$O(BFlag synchronization option $B$NCM$K$h$k!#(B
        Quick scan: $B1#$5$l$F$$$J$$(B mailbox $B$r$9$Y$F%A%'%C%/$7?7$7$$(B
                 $B%a!<%k$,Mh$F$$$l$PF14|$9$k!#%U%i%0$N99?7$,$"$C$?$+(B
                 $B$O%A%'%C%/$5$l$J$$!#F14|$K$$$/>l9g!"%U%i%0$,99?7(B
                 $B$5$l$k$+$I$&$+$O(BFlag synchronization option $B$NCM(B
                 $B$K$h$k!#(B
        Full sync: $B1#$5$l$F$$$J$$(B mailbox $B$O%U%i%0$N99?7$r4^$a$F(B
                 $BF14|$5$l$k!#(B
Folder Sync Mode: $B?7$7$$%a!<%k$r<h$j$K$$$/%3%^%s%I$,%U%)%k%@0lMw(B
        $B%b!<%I$G<B9T$5$l$?;~$K(B(\\[cmail-folders-get-newmail])$BF14|(B
        $B$r$I$N$h$&$K$H$k$+!#CM$O(B Default $B$r=|$-(B Startup Folder Sync
        Mode $B$HF1MM!#(B
Flag synchronization option: $B?7$7$$%a%C%;!<%8$,E~Ce$7$F$$$k$J$I$G(B
        $B%U%)%k%@$NF14|$r$H$k$H$-!"(BFull sync $B0J30$N%*%W%7%g%s$G(B
        $B%U%i%0$NF14|$r$*$3$J$&$+$I$&$+$,$-$^$k!#(B \"Sync flags as
        well\" $B$N>l9g$O!"%m!<%+%k%3%T!<$K$"$k%a%C%;!<%8$b%U%i%0$,(B
        $B%5!<%P>e$G99?7$5$l$F$$$l$PF14|$5$l$k!#$=$&$G$J$1$l$P%U%i%0(B
        $B$O99?7$7$J$$!#(B
Mailboxes to sync: $B%U%)%k%@F14|$r9T$&(B mailbox $BL>$NJ8;zNs$N(B
        $B%j%9%H!#(B\"regexp: \" $B$G;O$^$k>l9g@55,I=8=$H$_$J$5$l$^$9!#(B
        \"Mailboxes to hide\" $B$,M%@h$5$l$^$9!#(B
Default regexp for mailboxes to search: $B%G%U%)%k%H$N8!:wBP>]%a!<%k(B
        $B%\%C%/%9$NL>A0$K%^%C%A$9$k@55,I=8=!#(Bcmail $B$N%U%)%k%@$G$O$J(B
        $B$/%5!<%P>e$N%a!<%k%\%C%/%9$NL>A0$G$"$k$3$H$KCm0U!#8!:w$K(B
        $B:]$7$FF~NO$r5a$a$i$l$k$N$G$=$N>l$GJQ992DG=$@$,!"(BEnter $B$@$1(B
        $B$G6uJ8;zNs$,F~NO$5$l$?>l9g$3$N%G%U%)%k%H$,%a!<%k%\%C%/%9$N(B
        $BA*JL$K;HMQ$5$l$k!#(B
Message fetch mode: $B%a%C%;!<%8$,$I$N$h$&$K%@%&%s%m!<%I$5$l$k$+$r(B
        $B;XDj$9$k!#(B
        Default: $B2>A[%U%)%k%@$G$OL5$$>l9g!"Bg0hJQ?t$N(B
                 `cmail-simap4-fetch-mode' $B$N;XDj$K=>$&!#(B
                 $B2>A[%U%)%k%@$N>l9g!"(B Headers only/No cache $B$r;HMQ!#(B
        Unspecified: $BBg0hJQ?t$N(B `cmail-simap4-fetch-mode'
                 $B$N;XDj$K=>$&!#(B
        Headers only: `cmail-simap4-fetch-mode' $B$r;2>H(B
        Headers only/Local cache: `cmail-simap4-fetch-mode' $B$r;2>H(B
        Partial Download: `cmail-simap4-fetch-mode' $B$r;2>H(B
        Full Download: `cmail-simap4-fetch-mode' $B$r;2>H(B
Message max size: $B%a%C%;!<%8$N%@%&%s%m!<%I$r@)8B$9$k$?$a$K;HMQ$5(B
        $B$l$k>e8B%5%$%:!#C10L(B Byte.
Message part/body size: $B%a%C%;!<%8%Q!<%H$N%@%&%s%m!<%I$r@)8B$9$k(B
        $B$?$a$K;HMQ$5$l$k>e8B%5%$%:!#C10L(B Byte.
Connection Timeout: $B%5!<%P$K@\B3$9$k;~$N%?%$%`%"%&%HCM(B($BIC(B)
Server Response Timeout: $B%5!<%P$N1~Ez$rBT$D;~$N%?%$%`%"%&%HCM(B($BIC(B)
")
   (en_US . "\
*Server configuration for Simple IMAP4.

Each field has the following meaning.

Record Format: Version of the format of this variable. Cannot be modified.
Record State: Set to inactive to exculde this server from the active list.
Server: IMAP4 server name for this account.
UserID: IMAP4 user identification string on this server for this account.
TopDir: Local host directory for this account, which is a relative path
        from cmail-path. If this is set to an empty string,
        userid@servername will be used.
Virtual Folder: Whether or not local folders should be virtual folders
        to make them completely volatile. If virtual folders are used,
        when exiting cmail, all downloaded information during the session
        will be discarded, and complete synchronization would be done at
        the time of next access.
Mailboxes to Hide: A list of mailbox names which should be ignored when
        synchronizing the folders. A string starting with \"regexp: \"
        is considered as regular expression.
DraftMbox:  A name of IMAP4 mailbox, which is used to store draft
        messages. (Not yet supported.)
CFfile: A file name to save configuration such as auto refile rules
        specific to this account. (Not yet supported.)
Startup Folder Sync Mode:  Specify how default synchronization should
        be done during initial start up time.
        Default: For non-virtual folder case, Quick scan is used.
                 For virtual folder case, Full sync is used.
        Desginated folders only: Only those mailboxes specified in
                 \"Mailboxes to sync\" will be fully synchronized,
                 including flags. Depending on Flag synchronization
                 option, flags may or may not be synchronized.
        Quick scan: All non-hidden mailboxes are visited and checked if
                 any new arrived message is found. (No flag change is
                 scanned.) If new message is found, the mailbox will
                 be synchronized. Depending on Flag synchronization
                 option, flags may or may not be synchronized.
        Full sync: All non-hidden mailboxes are visited and checked if
                 any new arrived message and flag changes are found.
Folder Sync Mode:  Specify how default synchronization should be
        be done when get new message command is entered in folders mode
        buffer. (\\[cmail-folders-get-newmail]).
        See description option for Startup Folder Sync Mode. (Note:
        Default option in Startup Folder Sync Modeis not applicable.)
Flag synchronization option: When full sync is not the option
        for example, quick scan mode, if new arrived message is detected,
        the mailbox will be synchronized. If this option is set to
        \"Sync flags as well\", flags for the messages that exists on
        local copy are also synchronized.  Otherwise not, flags will not
        be updated and may show old status.  Note that if new message
        is retrieved, it will reflect initial flags.
Mailboxes to sync: A list of mailbox names which should be synched when
        synchronizing the folders. A string starting with \"regexp: \"
        is considered as regular expression.
Default regexp for mailboxes to search: A default regular expression
        that matches to mailboxes when IMAP4 on-server searching is
        used.  This is not the one matches to cmail folder names,
        but to mailbox names on the IMAP4 server. The user will be
        given a prompt for a change when search command is executed,
        but if an empty string is entered, this default is used to
        filter mailboxes.
Message fetch mode: Specifies how the messages should be downloaded
        for the 1st fetch.
        Default: For non-virtual folder case, follow global option
                 specified by `cmail-simap4-fetch-mode'.
                 For virtual folder case, Headers only/No cache mode
                 is used.
        Unspecified: follow global option specified by
                 `cmail-simap4-fetch-mode'.
        Headers only: Please see detailed info in
                 `cmail-simap4-fetch-mode'.
        Headers only/Local cache: Please see detailed info in
                 `cmail-simap4-fetch-mode'.
        Partial Download: Please see detailed info in
                 `cmail-simap4-fetch-mode'.
        Full Download: Please see detailed info in
                 `cmail-simap4-fetch-mode'.
Message max size: Message size in bytes used to determine whether to
        download message. 
Message part/body size: Message part size in bytes used to determine
        whether or not to download that part.
Connection Timeout: Timeout value in seconds used when opening a
        server connection.
Server Response Timeout: Timeout value in seconds used when waiting
        for a server response.
"))
  :type '(repeat
	  (list
	   (const :tag "Record Format: 1.2" "1.2")
	   (choice :tag "Record State"
		   (const :tag "Record active" nil)
		   (const :tag "Record inactive" t))
	   (string :tag "Server")
	   (string :tag "UserID")
	   (string :tag "TopDir")
	   (choice :tag "Virtual Folder"
		   (const :tag "Don't use virtual folder" nil)
		   (const :tag "Use virtual folder" t))
	   (repeat :tag "Mailboxes to Hide" (string))
	   (string :tag "DraftMbox")
	   (string :tag "CFfile")
	   (choice :tag "Startup Folder Sync Mode"
		   (const :tag "Default (See note)" default)
		   (const :tag "Designated folders only" spec-mbox-only)
		   (const :tag "Quick scan (See note)" quick-scan)
		   (const :tag "Full sync (See note)" full-sync)
		   )
	   (choice :tag "Folder Sync Mode"
		   (const :tag "Designated folders only" spec-mbox-only)
		   (const :tag "Quick scan (See note)" quick-scan)
		   (const :tag "Full sync (See note)" full-sync)
		   )
	   (choice :tag "Flag synchronization option"
		   (const :tag "Sync flags as well" t)
		   (const :tag "Don't sync flags" nil))
	   (repeat :tag "Mailboxes to sync (See notes)"
		   :value ("INBOX") (string))
	   (string :tag "Default regexp for mailboxes to search (See notes)"
		   :value "")
	   (choice :tag "Message fetch mode"
		   (const :tag "Default (See note)" default)
		   (const :tag "Unspecified (Use global option)" unspec)
		   (const :tag "Headers Only" headers-only)
		   (const :tag "Headers Only/Local cache" headers-only-lc)
		   (const :tag "Partial Download" partial-download)
		   (const :tag "Full Download" full-download)
		   )
	   (integer :tag "Message max size" 40000)
	   (integer :tag "Message part/body size" 8000)
	   (integer :tag "Connection Timeout" 60)
	   (integer :tag "Server Response Timeout" 20)
	   ))
  :group 'cmail-all-variables
  :group 'cmail-simap4-group)

(cmail-i18n-defcustom cmail-simap4-search-key-list
    '("TEXT" "FROM" "SUBJECT" "KEYWORD" "HEADER" 
      "FLAG" "TO" "CC" "BODY")
  ((ja_JP . "\
*$B8!:wJ8;zNs$r$?$:$M$F$/$k8!:w%-!<$N=gHV!#(B

$B%G%U%)%k%H0J30$N8!:w%-!<$O;HMQ=PMh$^$;$s$,!"$h$/;H$&%-!<$r@hF,$K$*$/$H(B
$B$3$N=gHV$K8!:wJ8;zNs$r$?$:$M$F$/$k$N$G>/$$%-!<%9%H%m!<%/$G8!:w$G$-$^$9!#(B
")
   (en_US . "\
*Specifies the order of search key prompt.

Although search keys other than listed as default here will not work,
as it propmpts for search string in the order it appears in this list,
it may help reducing key strokes for search."))
  :type '(repeat (string))
  :group 'cmail-all-variables
  :group 'cmail-simap4-group)


(cmail-i18n-defcustom cmail-simap4-fetch-mode 'headers-only
  ((ja_JP . "\
*$B%a%C%;!<%8$r$I$N$h$&$K<h$j9~$`$+!#(B

$B8=:_$O<!$N%b!<%I$,B8:_$9$k!#(B

   $B%X%C%@$N$_(B (headers-only): $B%a%C%;!<%8$,%5!<%P>e$G%U%)%k%@$K?7$7$/DI(B
$B2C$5$l$?>l9g:G=i$K(B RFC-822 $B%X%C%@$@$1<h$j9~$s$G$*$$$F<+F0%"!<%+%$%VEy(B
$B$r9T$&!#K\J8$OI=<(;~$K0lIt%@%&%s%m!<%I%b!<%I$G$=$NETEY<h$j9~$^$l%;!<%V(B
$B$5$l$J$$!#9bB.@~$G$N>o;~@\B3$GI=<(;~$N%@%&%s%m!<%I$,%9%H%l%9$K$J$i$J$$(B
$B>l9g!"$^$?$OBgNL$N%a!<%k$rFI$^$:$K%?%$%H%k$GA*Br$9$k>l9gEy$rA[Dj$7$F$$(B
$B$k!#(B

   $B%X%C%@$N$_(B/$BK\J8%m!<%+%k%-%c%C%7%e(B (headers-only-lc): $B4pK\E*$K%X%C%@(B
$B$N$_$N%*%W%7%g%s$HF1$8$@$,!"I=<(;~$K<h$j9~$^$l$?K\J8$O%m!<%+%k$N%U%)%k(B
$B%@$N0lIt$H$7$F%-%c%C%7%e$5$l$k!#(B

   $B0lIt%@%&%s%m!<%I(B (partial-download): $B%5!<%P@_Dj%*%W%7%g%s$N:GBg%a%C(B
$B%;!<%8%5%$%:(B \"Max message size\" $B$NogCM$h$j%a%C%;!<%8$,Bg$-$$>l9g!"4p(B
$BK\E*$K(B 7bit $B$N(B Text/plain $B$N$_$r%@%&%s%m!<%I$7$FE:IU%U%!%$%k$J$I$r%@%&(B
$B%s%m!<%I$7$J$$%b!<%I!#DcB.2s@~7PM3$G$[$H$s$I$N$N%a!<%k$r<h$j9~$s$G$*$$(B
$B$F%*%U%i%$%s:n6H$9$k>l9g$rA[Dj$7$F$$$k!#A4J8%@%&%s%m!<%I$O%5%^%j%b!<%I(B
$B$+$i%3%^%s%I$G<B9T$G$-$k!#(B

   $BA4J8%@%&%s%m!<%I(B(full-download): $BE:IU%U%!%$%k$J$I$r4^$a$?K\J8A4$F$r(B
$B%@%&%s%m!<%I$9$k!#E:IU%U%!%$%k$,$=$l$[$IL5$$$+!"9bB.2s@~$GA4%@%&%s%m!<(B
$B%I$,$=$l$[$I%9%H%l%9$K$J$i$J$$>l9g$G%*%U%i%$%s:n6H$N$?$a$K%a!<%k$r%m!<(B
$B%+%k$K%@%&%s%m!<%I$9$k>l9g$rA[Dj$7$F$$$k!#(B")
   
   (en_US . "\
*Specifies how the messages should be downloaded.

A choice of the following.

    Headers Only (headers-only): Download message headers for quick
view and auto-archiving. The message body will be download in full
download mode when displayed. The downloaded body will not be
saved. This may be used when the server is always connected and
accessed through a high bandwidth network, and does not cause too much
trouble to download body on the fly.

    Headers Only/Local cache (headers-only-lc): Mostly the same as
Headers only mode, however, downloaded message will be cached as part
of local folder.

    Partial Download: When the message size is larger than the
threshold value specified by one of the server configuration options
\"Max message size\", download only parts of a message, mainly mime part
of text/Plain with 7bit transfer encoding, and will not download large
attachments. This may be used when the server is not always connected
and/or connected through a low bandwidth line, and you would like to
look at all the messages off-line anyway. Full download can be
performed from the summary mode if needed manually.

    Full Download: Download whole message including all the attachment
files. This may be used when you do not normally receive messages with
large attatchments, or the server is accessed through very high
bandwidth network and you do not care to download everything. (Or when
you have no chice because you need the attachments for off-line
meeting etc.)"))
  :type '(choice (const :tag "Headers only" headers-only)
		 (const :tag "Partial Download" partial-download)
		 (const :tag "Full Download" full-download))
  :group 'cmail-all-variables
  :group 'cmail-simap4-group)

(cmail-i18n-defcustom cmail-simap4-num-msg-cache 100
  ((ja_JP . "\
*headers-only $B<h9~%b!<%I$G$$$/$D$N%a%C%;!<%8$r%a%b%j$K%-%c%7%e$9$k$+!#(B")
   (en_US . "\
*Number of messages to cache in memory when headers-only mode is used."))
  :type 'integer
  :group 'cmail-all-variables
  :group 'cmail-simap4-group)


;;; (cmail-i18n-defcustom cmail-simap4-max-msg-size 20000
;;;   ((ja_JP . "\
;;; *$B%a%C%;!<%8$N%@%&%s%m!<%I$r@)8B$9$k$?$a$K;HMQ$5$l$k>e8B%5%$%:!#(B")
;;;    (en_US . "\
;;; *Message size used to determine whether to download message."))
;;;   :type 'integer
;;;   :group 'cmail-all-variables
;;;   :group 'cmail-simap4-group)

;;; (cmail-i18n-defcustom cmail-simap4-max-body-size 2000
;;;   ((ja_JP . "\
;;; *$B%a%C%;!<%8%Q!<%H$N%@%&%s%m!<%I$r@)8B$9$k$?$a$K;HMQ$5$l$k>e8B%5%$%:!#(B")
;;;    (en_US . "\
;;; *Message part size used to determine whether to download part."))
;;;   :type 'integer
;;;   :group 'cmail-all-variables
;;;   :group 'cmail-simap4-group)

;;; (cmail-i18n-defcustom cmail-simap4-connection-timeout 60
;;;   ((ja_JP . "\
;;; *$B%5!<%P$K@\B3$9$k;~$N%?%$%`%"%&%HCM(B($BIC(B)")
;;;    (en_US . "\
;;; *Timeout value in seconds used when opening a server connection."))
;;;   :type 'integer
;;;   :group 'cmail-all-variables
;;;   :group 'cmail-simap4-group)

;;; (cmail-i18n-defcustom cmail-simap4-command-timeout 20
;;;   ((ja_JP . "\
;;; *$B%5!<%P$N1~Ez$rBT$D;~$N%?%$%`%"%&%HCM(B($BIC(B)")
;;;    (en_US . "\
;;; *Timeout value in seconds used when waiting for a server response."))
;;;   :type 'integer
;;;   :group 'cmail-all-variables
;;;   :group 'cmail-simap4-group)

;;; server option format conversion
(let ((specs cmail-simap4-servers)
      spec new-spec new-specs)
  (while specs
    (setq spec (car specs))
    (setq specs (cdr specs))
    (setq new-spec nil)
    (cond
     ;; current.
     ((string= (elt spec 0) "1.2"))
     ;; 1.1 to current update
     ((string= (elt spec 0) "1.1")
      (setq new-spec '("1.2"))
      (setq new-spec (cons (elt spec 1) new-spec))
      (setq new-spec (cons (elt spec 2) new-spec))
      (setq new-spec (cons (elt spec 3) new-spec))
      (setq new-spec (cons (elt spec 4) new-spec))
      (setq new-spec (cons (elt spec 5) new-spec))
      (setq new-spec (cons (elt spec 6) new-spec))
      (setq new-spec (cons (elt spec 7) new-spec))
      (setq new-spec (cons (elt spec 8) new-spec))
      (setq new-spec (cons (elt spec 9) new-spec))
      (setq new-spec (cons (elt spec 10) new-spec))
      (setq new-spec (cons (elt spec 11) new-spec))
      (setq new-spec (cons (elt spec 12) new-spec))
      (setq new-spec (cons "^INBOX.*" new-spec))
      (setq new-spec (cons (elt spec 13) new-spec))
      (setq new-spec (cons (elt spec 14) new-spec))
      (setq new-spec (cons (elt spec 15) new-spec))
      (setq new-spec (cons (elt spec 16) new-spec))
      (setq new-spec (cons (elt spec 17) new-spec))
      (setq new-specs (cons (reverse new-spec) new-specs)))
     ;; 1.0 to current update.
     ((string= (elt spec 0) "1.0")
      (setq new-spec '("1.2"))
      (setq new-spec (cons (elt spec 1) new-spec))
      (setq new-spec (cons (elt spec 2) new-spec))
      (setq new-spec (cons (elt spec 3) new-spec))
      (setq new-spec (cons (elt spec 4) new-spec))
      (setq new-spec (cons (elt spec 5) new-spec))
      (setq new-spec (cons (elt spec 6) new-spec))
      (setq new-spec (cons (elt spec 7) new-spec))
      (setq new-spec (cons (elt spec 8) new-spec))
      (setq new-spec (cons 'default new-spec))
      (setq new-spec (cons 'quick-scan new-spec))
      (setq new-spec (cons nil new-spec))
      (setq new-spec (cons '("INBOX") new-spec))
      (setq new-spec (cons "^INBOX.*" new-spec))
      (setq new-spec (cons 'default new-spec))
      (setq new-spec (cons 40000 new-spec))
      (setq new-spec (cons 8000 new-spec))
      (setq new-spec (cons 60 new-spec))
      (setq new-spec (cons 20 new-spec))
      (setq new-specs (cons (reverse new-spec) new-specs))
      )))
  (if new-specs
      ;; This may casue an error if older version on custom is used.
      (custom-set-variables
       (list 'cmail-simap4-servers
	     (list 'quote (reverse new-specs)) 'now))))

(defun cmail-use-simap4 nil)
(provide 'cmail-use-simap4)

;; end-of-file
