# pylint: skip-file
"""
Database of known variable names
NOTE: this file is automatically generated by the script
python -Bm cmake_format.tools.parse_cmake_help variables
"""
import re


PATTERNS = [
    "(?P<PROJECT_NAME>.*)_BINARY_DIR",
    "(?P<PROJECT_NAME>.*)_SOURCE_DIR",
    "(?P<PROJECT_NAME>.*)_VERSION",
    "(?P<PROJECT_NAME>.*)_VERSION_MAJOR",
    "(?P<PROJECT_NAME>.*)_VERSION_MINOR",
    "(?P<PROJECT_NAME>.*)_VERSION_PATCH",
    "(?P<PROJECT_NAME>.*)_VERSION_TWEAK",
    "ANDROID",
    "APPLE",
    "BORLAND",
    "BUILD_SHARED_LIBS",
    "CMAKE_(?P<CONFIG>.*)_POSTFIX",
    "CMAKE_(?P<LANG>.*)_ANDROID_TOOLCHAIN_MACHINE",
    "CMAKE_(?P<LANG>.*)_ANDROID_TOOLCHAIN_PREFIX",
    "CMAKE_(?P<LANG>.*)_ANDROID_TOOLCHAIN_SUFFIX",
    "CMAKE_(?P<LANG>.*)_ARCHIVE_APPEND",
    "CMAKE_(?P<LANG>.*)_ARCHIVE_CREATE",
    "CMAKE_(?P<LANG>.*)_ARCHIVE_FINISH",
    "CMAKE_(?P<LANG>.*)_CLANG_TIDY",
    "CMAKE_(?P<LANG>.*)_COMPILER",
    "CMAKE_(?P<LANG>.*)_COMPILER_ABI",
    "CMAKE_(?P<LANG>.*)_COMPILER_AR",
    "CMAKE_(?P<LANG>.*)_COMPILER_ARCHITECTURE_ID",
    "CMAKE_(?P<LANG>.*)_COMPILER_EXTERNAL_TOOLCHAIN",
    "CMAKE_(?P<LANG>.*)_COMPILER_ID",
    "CMAKE_(?P<LANG>.*)_COMPILER_LAUNCHER",
    "CMAKE_(?P<LANG>.*)_COMPILER_LOADED",
    "CMAKE_(?P<LANG>.*)_COMPILER_PREDEFINES_COMMAND",
    "CMAKE_(?P<LANG>.*)_COMPILER_RANLIB",
    "CMAKE_(?P<LANG>.*)_COMPILER_TARGET",
    "CMAKE_(?P<LANG>.*)_COMPILER_VERSION",
    "CMAKE_(?P<LANG>.*)_COMPILER_VERSION_INTERNAL",
    "CMAKE_(?P<LANG>.*)_COMPILE_OBJECT",
    "CMAKE_(?P<LANG>.*)_CPPCHECK",
    "CMAKE_(?P<LANG>.*)_CPPLINT",
    "CMAKE_(?P<LANG>.*)_CREATE_SHARED_LIBRARY",
    "CMAKE_(?P<LANG>.*)_CREATE_SHARED_MODULE",
    "CMAKE_(?P<LANG>.*)_CREATE_STATIC_LIBRARY",
    "CMAKE_(?P<LANG>.*)_FLAGS",
    "CMAKE_(?P<LANG>.*)_FLAGS_DEBUG",
    "CMAKE_(?P<LANG>.*)_FLAGS_DEBUG_INIT",
    "CMAKE_(?P<LANG>.*)_FLAGS_INIT",
    "CMAKE_(?P<LANG>.*)_FLAGS_MINSIZEREL",
    "CMAKE_(?P<LANG>.*)_FLAGS_MINSIZEREL_INIT",
    "CMAKE_(?P<LANG>.*)_FLAGS_RELEASE",
    "CMAKE_(?P<LANG>.*)_FLAGS_RELEASE_INIT",
    "CMAKE_(?P<LANG>.*)_FLAGS_RELWITHDEBINFO",
    "CMAKE_(?P<LANG>.*)_FLAGS_RELWITHDEBINFO_INIT",
    "CMAKE_(?P<LANG>.*)_GHS_KERNEL_FLAGS_DEBUG",
    "CMAKE_(?P<LANG>.*)_GHS_KERNEL_FLAGS_MINSIZEREL",
    "CMAKE_(?P<LANG>.*)_GHS_KERNEL_FLAGS_RELEASE",
    "CMAKE_(?P<LANG>.*)_GHS_KERNEL_FLAGS_RELWITHDEBINFO",
    "CMAKE_(?P<LANG>.*)_IGNORE_EXTENSIONS",
    "CMAKE_(?P<LANG>.*)_IMPLICIT_INCLUDE_DIRECTORIES",
    "CMAKE_(?P<LANG>.*)_IMPLICIT_LINK_DIRECTORIES",
    "CMAKE_(?P<LANG>.*)_IMPLICIT_LINK_FRAMEWORK_DIRECTORIES",
    "CMAKE_(?P<LANG>.*)_IMPLICIT_LINK_LIBRARIES",
    "CMAKE_(?P<LANG>.*)_INCLUDE_WHAT_YOU_USE",
    "CMAKE_(?P<LANG>.*)_LIBRARY_ARCHITECTURE",
    "CMAKE_(?P<LANG>.*)_LINKER_PREFERENCE",
    "CMAKE_(?P<LANG>.*)_LINKER_PREFERENCE_PROPAGATES",
    "CMAKE_(?P<LANG>.*)_LINK_EXECUTABLE",
    "CMAKE_(?P<LANG>.*)_OUTPUT_EXTENSION",
    "CMAKE_(?P<LANG>.*)_PLATFORM_ID",
    "CMAKE_(?P<LANG>.*)_SIMULATE_ID",
    "CMAKE_(?P<LANG>.*)_SIMULATE_VERSION",
    "CMAKE_(?P<LANG>.*)_SIZEOF_DATA_PTR",
    "CMAKE_(?P<LANG>.*)_SOURCE_FILE_EXTENSIONS",
    "CMAKE_(?P<LANG>.*)_STANDARD_INCLUDE_DIRECTORIES",
    "CMAKE_(?P<LANG>.*)_STANDARD_LIBRARIES",
    "CMAKE_(?P<LANG>.*)_VISIBILITY_PRESET",
    "CMAKE_ABSOLUTE_DESTINATION_FILES",
    "CMAKE_ANDROID_ANT_ADDITIONAL_OPTIONS",
    "CMAKE_ANDROID_API",
    "CMAKE_ANDROID_API_MIN",
    "CMAKE_ANDROID_ARCH",
    "CMAKE_ANDROID_ARCH_ABI",
    "CMAKE_ANDROID_ARM_MODE",
    "CMAKE_ANDROID_ARM_NEON",
    "CMAKE_ANDROID_ASSETS_DIRECTORIES",
    "CMAKE_ANDROID_GUI",
    "CMAKE_ANDROID_JAR_DEPENDENCIES",
    "CMAKE_ANDROID_JAR_DIRECTORIES",
    "CMAKE_ANDROID_JAVA_SOURCE_DIR",
    "CMAKE_ANDROID_NATIVE_LIB_DEPENDENCIES",
    "CMAKE_ANDROID_NATIVE_LIB_DIRECTORIES",
    "CMAKE_ANDROID_NDK",
    "CMAKE_ANDROID_NDK_DEPRECATED_HEADERS",
    "CMAKE_ANDROID_NDK_TOOLCHAIN_HOST_TAG",
    "CMAKE_ANDROID_NDK_TOOLCHAIN_VERSION",
    "CMAKE_ANDROID_PROCESS_MAX",
    "CMAKE_ANDROID_PROGUARD",
    "CMAKE_ANDROID_PROGUARD_CONFIG_PATH",
    "CMAKE_ANDROID_SECURE_PROPS_PATH",
    "CMAKE_ANDROID_SKIP_ANT_STEP",
    "CMAKE_ANDROID_STANDALONE_TOOLCHAIN",
    "CMAKE_ANDROID_STL_TYPE",
    "CMAKE_APPBUNDLE_PATH",
    "CMAKE_AR",
    "CMAKE_ARCHIVE_OUTPUT_DIRECTORY",
    "CMAKE_ARCHIVE_OUTPUT_DIRECTORY_(?P<CONFIG>.*)",
    "CMAKE_ARGC",
    "CMAKE_ARGV0",
    "CMAKE_AUTOMOC",
    "CMAKE_AUTOMOC_COMPILER_PREDEFINES",
    "CMAKE_AUTOMOC_DEPEND_FILTERS",
    "CMAKE_AUTOMOC_MACRO_NAMES",
    "CMAKE_AUTOMOC_MOC_OPTIONS",
    "CMAKE_AUTOMOC_RELAXED_MODE",
    "CMAKE_AUTORCC",
    "CMAKE_AUTORCC_OPTIONS",
    "CMAKE_AUTOUIC",
    "CMAKE_AUTOUIC_OPTIONS",
    "CMAKE_AUTOUIC_SEARCH_PATHS",
    "CMAKE_BACKWARDS_COMPATIBILITY",
    "CMAKE_BINARY_DIR",
    "CMAKE_BUILD_RPATH",
    "CMAKE_BUILD_TOOL",
    "CMAKE_BUILD_TYPE",
    "CMAKE_BUILD_WITH_INSTALL_NAME_DIR",
    "CMAKE_BUILD_WITH_INSTALL_RPATH",
    "CMAKE_CACHEFILE_DIR",
    "CMAKE_CACHE_MAJOR_VERSION",
    "CMAKE_CACHE_MINOR_VERSION",
    "CMAKE_CACHE_PATCH_VERSION",
    "CMAKE_CFG_INTDIR",
    "CMAKE_CL_64",
    "CMAKE_CODEBLOCKS_EXCLUDE_EXTERNAL_FILES",
    "CMAKE_CODELITE_USE_TARGETS",
    "CMAKE_COLOR_MAKEFILE",
    "CMAKE_COMMAND",
    "CMAKE_COMPILER_2005",
    "CMAKE_COMPILER_IS_GNUCC",
    "CMAKE_COMPILER_IS_GNUCXX",
    "CMAKE_COMPILER_IS_GNUG77",
    "CMAKE_COMPILE_PDB_OUTPUT_DIRECTORY",
    "CMAKE_COMPILE_PDB_OUTPUT_DIRECTORY_(?P<CONFIG>.*)",
    "CMAKE_CONFIGURATION_TYPES",
    "CMAKE_CROSSCOMPILING",
    "CMAKE_CROSSCOMPILING_EMULATOR",
    "CMAKE_CTEST_COMMAND",
    "CMAKE_CUDA_EXTENSIONS",
    "CMAKE_CUDA_HOST_COMPILER",
    "CMAKE_CUDA_STANDARD",
    "CMAKE_CUDA_STANDARD_REQUIRED",
    "CMAKE_CUDA_TOOLKIT_INCLUDE_DIRECTORIES",
    "CMAKE_CURRENT_BINARY_DIR",
    "CMAKE_CURRENT_LIST_DIR",
    "CMAKE_CURRENT_LIST_FILE",
    "CMAKE_CURRENT_LIST_LINE",
    "CMAKE_CURRENT_SOURCE_DIR",
    "CMAKE_CXX_COMPILE_FEATURES",
    "CMAKE_CXX_EXTENSIONS",
    "CMAKE_CXX_STANDARD",
    "CMAKE_CXX_STANDARD_REQUIRED",
    "CMAKE_C_COMPILE_FEATURES",
    "CMAKE_C_EXTENSIONS",
    "CMAKE_C_STANDARD",
    "CMAKE_C_STANDARD_REQUIRED",
    "CMAKE_DEBUG_POSTFIX",
    "CMAKE_DEBUG_TARGET_PROPERTIES",
    "CMAKE_DEPENDS_IN_PROJECT_ONLY",
    "CMAKE_DIRECTORY_LABELS",
    "CMAKE_DISABLE_FIND_PACKAGE_(?P<PackageName>.*)",
    "CMAKE_DL_LIBS",
    "CMAKE_ECLIPSE_GENERATE_LINKED_RESOURCES",
    "CMAKE_ECLIPSE_GENERATE_SOURCE_PROJECT",
    "CMAKE_ECLIPSE_MAKE_ARGUMENTS",
    "CMAKE_ECLIPSE_VERSION",
    "CMAKE_EDIT_COMMAND",
    "CMAKE_ENABLE_EXPORTS",
    "CMAKE_ERROR_DEPRECATED",
    "CMAKE_ERROR_ON_ABSOLUTE_INSTALL_DESTINATION",
    "CMAKE_EXECUTABLE_SUFFIX",
    "CMAKE_EXE_LINKER_FLAGS",
    "CMAKE_EXE_LINKER_FLAGS_(?P<CONFIG>.*)",
    "CMAKE_EXE_LINKER_FLAGS_(?P<CONFIG>.*)_INIT",
    "CMAKE_EXE_LINKER_FLAGS_INIT",
    "CMAKE_EXPORT_COMPILE_COMMANDS",
    "CMAKE_EXPORT_NO_PACKAGE_REGISTRY",
    "CMAKE_EXTRA_GENERATOR",
    "CMAKE_EXTRA_SHARED_LIBRARY_SUFFIXES",
    "CMAKE_FIND_APPBUNDLE",
    "CMAKE_FIND_FRAMEWORK",
    "CMAKE_FIND_LIBRARY_CUSTOM_LIB_SUFFIX",
    "CMAKE_FIND_LIBRARY_PREFIXES",
    "CMAKE_FIND_LIBRARY_SUFFIXES",
    "CMAKE_FIND_NO_INSTALL_PREFIX",
    "CMAKE_FIND_PACKAGE_NAME",
    "CMAKE_FIND_PACKAGE_NO_PACKAGE_REGISTRY",
    "CMAKE_FIND_PACKAGE_NO_SYSTEM_PACKAGE_REGISTRY",
    "CMAKE_FIND_PACKAGE_SORT_DIRECTION",
    "CMAKE_FIND_PACKAGE_SORT_ORDER",
    "CMAKE_FIND_PACKAGE_WARN_NO_MODULE",
    "CMAKE_FIND_ROOT_PATH",
    "CMAKE_FIND_ROOT_PATH_MODE_INCLUDE",
    "CMAKE_FIND_ROOT_PATH_MODE_LIBRARY",
    "CMAKE_FIND_ROOT_PATH_MODE_PACKAGE",
    "CMAKE_FIND_ROOT_PATH_MODE_PROGRAM",
    "CMAKE_FRAMEWORK_PATH",
    "CMAKE_Fortran_FORMAT",
    "CMAKE_Fortran_MODDIR_DEFAULT",
    "CMAKE_Fortran_MODDIR_FLAG",
    "CMAKE_Fortran_MODOUT_FLAG",
    "CMAKE_Fortran_MODULE_DIRECTORY",
    "CMAKE_GENERATOR",
    "CMAKE_GENERATOR_PLATFORM",
    "CMAKE_GENERATOR_TOOLSET",
    "CMAKE_GNUtoMS",
    "CMAKE_HOME_DIRECTORY",
    "CMAKE_HOST_APPLE",
    "CMAKE_HOST_SOLARIS",
    "CMAKE_HOST_SYSTEM",
    "CMAKE_HOST_SYSTEM_NAME",
    "CMAKE_HOST_SYSTEM_PROCESSOR",
    "CMAKE_HOST_SYSTEM_VERSION",
    "CMAKE_HOST_UNIX",
    "CMAKE_HOST_WIN32",
    "CMAKE_IGNORE_PATH",
    "CMAKE_IMPORT_LIBRARY_PREFIX",
    "CMAKE_IMPORT_LIBRARY_SUFFIX",
    "CMAKE_INCLUDE_CURRENT_DIR",
    "CMAKE_INCLUDE_CURRENT_DIR_IN_INTERFACE",
    "CMAKE_INCLUDE_DIRECTORIES_BEFORE",
    "CMAKE_INCLUDE_DIRECTORIES_PROJECT_BEFORE",
    "CMAKE_INCLUDE_PATH",
    "CMAKE_INSTALL_DEFAULT_COMPONENT_NAME",
    "CMAKE_INSTALL_MESSAGE",
    "CMAKE_INSTALL_NAME_DIR",
    "CMAKE_INSTALL_PREFIX",
    "CMAKE_INSTALL_PREFIX_INITIALIZED_TO_DEFAULT",
    "CMAKE_INSTALL_RPATH",
    "CMAKE_INSTALL_RPATH_USE_LINK_PATH",
    "CMAKE_INTERNAL_PLATFORM_ABI",
    "CMAKE_INTERPROCEDURAL_OPTIMIZATION",
    "CMAKE_INTERPROCEDURAL_OPTIMIZATION_(?P<CONFIG>.*)",
    "CMAKE_IOS_INSTALL_COMBINED",
    "CMAKE_JOB_POOL_COMPILE",
    "CMAKE_JOB_POOL_LINK",
    "CMAKE_LIBRARY_ARCHITECTURE",
    "CMAKE_LIBRARY_ARCHITECTURE_REGEX",
    "CMAKE_LIBRARY_OUTPUT_DIRECTORY",
    "CMAKE_LIBRARY_OUTPUT_DIRECTORY_(?P<CONFIG>.*)",
    "CMAKE_LIBRARY_PATH",
    "CMAKE_LIBRARY_PATH_FLAG",
    "CMAKE_LINK_DEF_FILE_FLAG",
    "CMAKE_LINK_DEPENDS_NO_SHARED",
    "CMAKE_LINK_INTERFACE_LIBRARIES",
    "CMAKE_LINK_LIBRARY_FILE_FLAG",
    "CMAKE_LINK_LIBRARY_FLAG",
    "CMAKE_LINK_LIBRARY_SUFFIX",
    "CMAKE_LINK_SEARCH_END_STATIC",
    "CMAKE_LINK_SEARCH_START_STATIC",
    "CMAKE_LINK_WHAT_YOU_USE",
    "CMAKE_MACOSX_BUNDLE",
    "CMAKE_MACOSX_RPATH",
    "CMAKE_MAJOR_VERSION",
    "CMAKE_MAKE_PROGRAM",
    "CMAKE_MAP_IMPORTED_CONFIG_(?P<CONFIG>.*)",
    "CMAKE_MATCH_(?P<n>.*)",
    "CMAKE_MATCH_COUNT",
    "CMAKE_MFC_FLAG",
    "CMAKE_MINIMUM_REQUIRED_VERSION",
    "CMAKE_MINOR_VERSION",
    "CMAKE_MODULE_LINKER_FLAGS",
    "CMAKE_MODULE_LINKER_FLAGS_(?P<CONFIG>.*)",
    "CMAKE_MODULE_LINKER_FLAGS_(?P<CONFIG>.*)_INIT",
    "CMAKE_MODULE_LINKER_FLAGS_INIT",
    "CMAKE_MODULE_PATH",
    "CMAKE_MSVCIDE_RUN_PATH",
    "CMAKE_NINJA_OUTPUT_PATH_PREFIX",
    "CMAKE_NOT_USING_CONFIG_FLAGS",
    "CMAKE_NO_BUILTIN_CHRPATH",
    "CMAKE_NO_SYSTEM_FROM_IMPORTED",
    "CMAKE_OBJECT_PATH_MAX",
    "CMAKE_OSX_ARCHITECTURES",
    "CMAKE_OSX_DEPLOYMENT_TARGET",
    "CMAKE_OSX_SYSROOT",
    "CMAKE_PARENT_LIST_FILE",
    "CMAKE_PATCH_VERSION",
    "CMAKE_PDB_OUTPUT_DIRECTORY",
    "CMAKE_PDB_OUTPUT_DIRECTORY_(?P<CONFIG>.*)",
    "CMAKE_POLICY_DEFAULT_CMP(?P<NNNN>.*)",
    "CMAKE_POLICY_WARNING_CMP(?P<NNNN>.*)",
    "CMAKE_POSITION_INDEPENDENT_CODE",
    "CMAKE_PREFIX_PATH",
    "CMAKE_PROGRAM_PATH",
    "CMAKE_PROJECT_(?P<PROJECT_NAME>.*)_INCLUDE",
    "CMAKE_PROJECT_DESCRIPTION",
    "CMAKE_PROJECT_NAME",
    "CMAKE_RANLIB",
    "CMAKE_ROOT",
    "CMAKE_RUNTIME_OUTPUT_DIRECTORY",
    "CMAKE_RUNTIME_OUTPUT_DIRECTORY_(?P<CONFIG>.*)",
    "CMAKE_SCRIPT_MODE_FILE",
    "CMAKE_SHARED_LIBRARY_PREFIX",
    "CMAKE_SHARED_LIBRARY_SUFFIX",
    "CMAKE_SHARED_LINKER_FLAGS",
    "CMAKE_SHARED_LINKER_FLAGS_(?P<CONFIG>.*)",
    "CMAKE_SHARED_LINKER_FLAGS_(?P<CONFIG>.*)_INIT",
    "CMAKE_SHARED_LINKER_FLAGS_INIT",
    "CMAKE_SHARED_MODULE_PREFIX",
    "CMAKE_SHARED_MODULE_SUFFIX",
    "CMAKE_SIZEOF_VOID_P",
    "CMAKE_SKIP_BUILD_RPATH",
    "CMAKE_SKIP_INSTALL_ALL_DEPENDENCY",
    "CMAKE_SKIP_INSTALL_RPATH",
    "CMAKE_SKIP_INSTALL_RULES",
    "CMAKE_SKIP_RPATH",
    "CMAKE_SOURCE_DIR",
    "CMAKE_STAGING_PREFIX",
    "CMAKE_STATIC_LIBRARY_PREFIX",
    "CMAKE_STATIC_LIBRARY_SUFFIX",
    "CMAKE_STATIC_LINKER_FLAGS",
    "CMAKE_STATIC_LINKER_FLAGS_(?P<CONFIG>.*)",
    "CMAKE_STATIC_LINKER_FLAGS_(?P<CONFIG>.*)_INIT",
    "CMAKE_STATIC_LINKER_FLAGS_INIT",
    "CMAKE_SUBLIME_TEXT_2_ENV_SETTINGS",
    "CMAKE_SUBLIME_TEXT_2_EXCLUDE_BUILD_TREE",
    "CMAKE_SYSROOT",
    "CMAKE_SYSROOT_COMPILE",
    "CMAKE_SYSROOT_LINK",
    "CMAKE_SYSTEM",
    "CMAKE_SYSTEM_APPBUNDLE_PATH",
    "CMAKE_SYSTEM_FRAMEWORK_PATH",
    "CMAKE_SYSTEM_IGNORE_PATH",
    "CMAKE_SYSTEM_INCLUDE_PATH",
    "CMAKE_SYSTEM_LIBRARY_PATH",
    "CMAKE_SYSTEM_NAME",
    "CMAKE_SYSTEM_PREFIX_PATH",
    "CMAKE_SYSTEM_PROCESSOR",
    "CMAKE_SYSTEM_PROGRAM_PATH",
    "CMAKE_SYSTEM_VERSION",
    "CMAKE_Swift_LANGUAGE_VERSION",
    "CMAKE_TOOLCHAIN_FILE",
    "CMAKE_TRY_COMPILE_CONFIGURATION",
    "CMAKE_TRY_COMPILE_PLATFORM_VARIABLES",
    "CMAKE_TRY_COMPILE_TARGET_TYPE",
    "CMAKE_TWEAK_VERSION",
    "CMAKE_USER_MAKE_RULES_OVERRIDE",
    "CMAKE_USER_MAKE_RULES_OVERRIDE_(?P<LANG>.*)",
    "CMAKE_USE_RELATIVE_PATHS",
    "CMAKE_VERBOSE_MAKEFILE",
    "CMAKE_VERSION",
    "CMAKE_VISIBILITY_INLINES_HIDDEN",
    "CMAKE_VS_DEVENV_COMMAND",
    "CMAKE_VS_INCLUDE_INSTALL_TO_DEFAULT_BUILD",
    "CMAKE_VS_INCLUDE_PACKAGE_TO_DEFAULT_BUILD",
    "CMAKE_VS_INTEL_Fortran_PROJECT_VERSION",
    "CMAKE_VS_MSBUILD_COMMAND",
    "CMAKE_VS_NsightTegra_VERSION",
    "CMAKE_VS_PLATFORM_NAME",
    "CMAKE_VS_PLATFORM_TOOLSET",
    "CMAKE_VS_PLATFORM_TOOLSET_CUDA",
    "CMAKE_VS_PLATFORM_TOOLSET_HOST_ARCHITECTURE",
    "CMAKE_VS_WINDOWS_TARGET_PLATFORM_VERSION",
    "CMAKE_WARN_DEPRECATED",
    "CMAKE_WARN_ON_ABSOLUTE_INSTALL_DESTINATION",
    "CMAKE_WIN32_EXECUTABLE",
    "CMAKE_WINDOWS_EXPORT_ALL_SYMBOLS",
    "CMAKE_XCODE_ATTRIBUTE_(?P<an_attribute>.*)",
    "CMAKE_XCODE_GENERATE_SCHEME",
    "CMAKE_XCODE_PLATFORM_TOOLSET",
    "CPACK_ABSOLUTE_DESTINATION_FILES",
    "CPACK_COMPONENT_INCLUDE_TOPLEVEL_DIRECTORY",
    "CPACK_ERROR_ON_ABSOLUTE_INSTALL_DESTINATION",
    "CPACK_INCLUDE_TOPLEVEL_DIRECTORY",
    "CPACK_INSTALL_SCRIPT",
    "CPACK_PACKAGING_INSTALL_PREFIX",
    "CPACK_SET_DESTDIR",
    "CPACK_WARN_ON_ABSOLUTE_INSTALL_DESTINATION",
    "CTEST_BINARY_DIRECTORY",
    "CTEST_BUILD_COMMAND",
    "CTEST_BUILD_NAME",
    "CTEST_BZR_COMMAND",
    "CTEST_BZR_UPDATE_OPTIONS",
    "CTEST_CHANGE_ID",
    "CTEST_CHECKOUT_COMMAND",
    "CTEST_CONFIGURATION_TYPE",
    "CTEST_CONFIGURE_COMMAND",
    "CTEST_COVERAGE_COMMAND",
    "CTEST_COVERAGE_EXTRA_FLAGS",
    "CTEST_CURL_OPTIONS",
    "CTEST_CUSTOM_COVERAGE_EXCLUDE",
    "CTEST_CUSTOM_ERROR_EXCEPTION",
    "CTEST_CUSTOM_ERROR_MATCH",
    "CTEST_CUSTOM_ERROR_POST_CONTEXT",
    "CTEST_CUSTOM_ERROR_PRE_CONTEXT",
    "CTEST_CUSTOM_MAXIMUM_FAILED_TEST_OUTPUT_SIZE",
    "CTEST_CUSTOM_MAXIMUM_NUMBER_OF_ERRORS",
    "CTEST_CUSTOM_MAXIMUM_NUMBER_OF_WARNINGS",
    "CTEST_CUSTOM_MAXIMUM_PASSED_TEST_OUTPUT_SIZE",
    "CTEST_CUSTOM_MEMCHECK_IGNORE",
    "CTEST_CUSTOM_POST_MEMCHECK",
    "CTEST_CUSTOM_POST_TEST",
    "CTEST_CUSTOM_PRE_MEMCHECK",
    "CTEST_CUSTOM_PRE_TEST",
    "CTEST_CUSTOM_TEST_IGNORE",
    "CTEST_CUSTOM_WARNING_EXCEPTION",
    "CTEST_CUSTOM_WARNING_MATCH",
    "CTEST_CVS_CHECKOUT",
    "CTEST_CVS_COMMAND",
    "CTEST_CVS_UPDATE_OPTIONS",
    "CTEST_DROP_LOCATION",
    "CTEST_DROP_METHOD",
    "CTEST_DROP_SITE",
    "CTEST_DROP_SITE_CDASH",
    "CTEST_DROP_SITE_PASSWORD",
    "CTEST_DROP_SITE_USER",
    "CTEST_EXTRA_COVERAGE_GLOB",
    "CTEST_GIT_COMMAND",
    "CTEST_GIT_INIT_SUBMODULES",
    "CTEST_GIT_UPDATE_CUSTOM",
    "CTEST_GIT_UPDATE_OPTIONS",
    "CTEST_HG_COMMAND",
    "CTEST_HG_UPDATE_OPTIONS",
    "CTEST_LABELS_FOR_SUBPROJECTS",
    "CTEST_MEMORYCHECK_COMMAND",
    "CTEST_MEMORYCHECK_COMMAND_OPTIONS",
    "CTEST_MEMORYCHECK_SANITIZER_OPTIONS",
    "CTEST_MEMORYCHECK_SUPPRESSIONS_FILE",
    "CTEST_MEMORYCHECK_TYPE",
    "CTEST_NIGHTLY_START_TIME",
    "CTEST_P4_CLIENT",
    "CTEST_P4_COMMAND",
    "CTEST_P4_OPTIONS",
    "CTEST_P4_UPDATE_OPTIONS",
    "CTEST_SCP_COMMAND",
    "CTEST_SITE",
    "CTEST_SOURCE_DIRECTORY",
    "CTEST_SVN_COMMAND",
    "CTEST_SVN_OPTIONS",
    "CTEST_SVN_UPDATE_OPTIONS",
    "CTEST_TEST_LOAD",
    "CTEST_TEST_TIMEOUT",
    "CTEST_TRIGGER_SITE",
    "CTEST_UPDATE_COMMAND",
    "CTEST_UPDATE_OPTIONS",
    "CTEST_UPDATE_VERSION_ONLY",
    "CTEST_USE_LAUNCHERS",
    "CYGWIN",
    "ENV",
    "EXECUTABLE_OUTPUT_PATH",
    "GHS-MULTI",
    "LIBRARY_OUTPUT_PATH",
    "MINGW",
    "MSVC",
    "MSVC10",
    "MSVC11",
    "MSVC12",
    "MSVC14",
    "MSVC60",
    "MSVC70",
    "MSVC71",
    "MSVC80",
    "MSVC90",
    "MSVC_IDE",
    "MSVC_VERSION",
    "PROJECT_BINARY_DIR",
    "PROJECT_DESCRIPTION",
    "PROJECT_NAME",
    "PROJECT_SOURCE_DIR",
    "PROJECT_VERSION",
    "PROJECT_VERSION_MAJOR",
    "PROJECT_VERSION_MINOR",
    "PROJECT_VERSION_PATCH",
    "PROJECT_VERSION_TWEAK",
    "UNIX",
    "WIN32",
    "WINCE",
    "WINDOWS_PHONE",
    "WINDOWS_STORE",
    "XCODE",
    "XCODE_VERSION",
]


def stripped_patterns():
  """
  Remove named groups from patterns so we can join them together without
  a name collision.
  """
  regex = re.compile(r"\?P<[\w_]+>")
  return [regex.sub("", pattern) for pattern in PATTERNS]


CASE_SENSITIVE_REGEX = re.compile(
    "|".join(stripped_patterns()))
CASE_INSENSITIVE_REGEX = re.compile(
    "|".join(stripped_patterns()), re.IGNORECASE)
