
%{
#include "cint.h"
FILE* yyin;
Prog* program = NULL;
%}
%union {
  char*   id;
  int     num;
  Func*   func;
  Formal* formal;
  Stmt*   stmt;
  Decl*   decl;
  Exp*    exp;
}


%token IF
%token ELSE
%token WHIL
%token RETN
%token INT
%token <id>  ID
%token <num> NUM
%type <func> prog
%type <func> fundefs
%type <func> func
%type <formal> formals
%type <stmt> compound
%type <decl> decls
%type <decl> decl
%type <stmt> stmts
%type <stmt> stmt
%type <exp>  exp
%right '='
%left EQL NEQ
%left '>' GEQ '<' LEQ
%left '-' '+'
%left '*' '/'
%right UMI '!'


%start prog

%%

prog:     fundefs                     { program = PROG($1); }

fundefs:  func                        { }
        | prog func                   { $$->next = $2; }
        | prog ';' func               { $$->next = $3; }

func:     ID '(' formals ')' compound { $$ = FUNC($1, $3, $5, NULL); }
        | INT ID '(' formals ')' compound { $$ = FUNC($2, $4, $6, NULL); }
        
formals:                              { $$ = NULL; }
        | ID                          { $$ = FORMAL($1, NULL); }
        | ID ',' formals              { $$ = FORMAL($1, $3); }
        | INT ID                      { $$ = FORMAL($2, NULL); }
        | INT ID ',' formals          { $$ = FORMAL($2, $4); }

compound: '{' decls stmts '}'         { $$ = COMPOUND($2, $3, NULL); }

decls:                                { $$ = NULL; }
        | decl ';' decls              { $$->next = $3; }

decl:     type ID                     { $$ = DECL($2, NULL); }

type:     INT

stmts:                                { $$ = NULL; }
        | stmt stmts                  { $$->next = $2; }

stmt:     ';'                         { $$ = NULL; }
        | exp ';'                     { $$ = EXPRESSION($1, NULL); }
        | IF '(' exp ')' stmt ELSE stmt { $$ = IFELSE($3, $5, $7, NULL); }
        | WHIL '(' exp ')' stmt       { $$ = WHILE($3, $5, NULL); }
        | RETN ';'                    { $$ = RETURN(NULL, NULL); }
        | RETN exp ';'                { $$ = RETURN($2, NULL); }
        | compound                    { }
					  
exp:      exp '+' exp                 { $$ = BINOP(Plus  , $1, $3); }
        | exp '-' exp                 { $$ = BINOP(Minus , $1, $3); }
        | exp '*' exp                 { $$ = BINOP(Times , $1, $3); }
        | exp '/' exp                 { $$ = BINOP(Divide, $1, $3); }
        | exp '=' exp                 { $$ = BINOP(Assign, $1, $3); }
        | exp EQL exp                 { $$ = BINOP(EQ    , $1, $3); }
        | exp NEQ exp                 { $$ = BINOP(NE    , $1, $3); }
        | exp GEQ exp                 { $$ = BINOP(GE    , $1, $3); }
        | exp LEQ exp                 { $$ = BINOP(LE    , $1, $3); }
        | exp '>' exp                 { $$ = BINOP(GT    , $1, $3); }
        | exp '<' exp                 { $$ = BINOP(LT    , $1, $3); }
        | '!' exp                     { $$ = UNOP(UnNeg, $2); }
        | UMI exp                     { $$ = UNOP(UnMinus, $2); }
        | ID                          { $$ = VAR($1); }
        | NUM                         { $$ = CONST($1); }
  

%%

yyerror (char *s)
{
  fprintf (stderr, "error: %s\n", s);
}

void readProg(Prog** p, char* filename) {
  if (!program) {
    yyin = fopen(filename, "r");
    fprintf(stderr, "reading program file `%s'...", filename);
    if (yyparse()) exit(1);
    fclose(yyin);
    fprintf(stderr, "done.\n");
  };
  *p = program;
  return;
}
