/*
 * Author:	Peter Holst Andersen
 * Last change:	August, 1994
 * Contents:	Functions for showing the image using SRGP
 *		(Simple Raster Graphics Package).
 */

#ifdef HAVE_LIBSRGP

#include <stdio.h>
#include <stdlib.h>
#include <srgp.h>
#include "ray.h"

int init_srgp(char *title, int height, int width)
{
	int i, j, m;
	unsigned short k;
	
	SRGP_begin(title, width, height, 0, FALSE);
	SRGP_refresh();
	i = SRGP_inquireCanvasDepth();
	j = (1 << i);
	for(m = 0; m < j - 2; m++) {
	    k = 256*256*m/j;
	    SRGP_loadColorTable(m + 2, 1, &k, &k, &k);
	}
	return j;
}

void plot(int x, int y, colorType color)
{
    int i;
    
    i = (color.red * 0.299 + color.green * 0.587 + color.blue * 0.114) *
      number_of_colors + (RANDOM()%100000)/100000.0;

#ifdef DEBUG
    if (i < 0 || i >= number_of_colors)
	fprintf(stderr, "plot: color of out range (0-%d): %d\n",
		number_of_colors-1, i);
#endif
	
    if (i <= 0)
	i = SRGP_BLACK;
    else if (i >= number_of_colors - 1)
	i = SRGP_WHITE;
    else
	i++;

    SRGP_setColor(i);
    SRGP_pointCoord(x, y);
}	

#endif /* HAVE_LIBSRGP */
