/*
//
//  Copyright 1997-2009 Torsten Rohlfing
//
//  Copyright 2004-2012 SRI International
//
//  This file is part of the Computational Morphometry Toolkit.
//
//  http://www.nitrc.org/projects/cmtk/
//
//  The Computational Morphometry Toolkit is free software: you can
//  redistribute it and/or modify it under the terms of the GNU General Public
//  License as published by the Free Software Foundation, either version 3 of
//  the License, or (at your option) any later version.
//
//  The Computational Morphometry Toolkit is distributed in the hope that it
//  will be useful, but WITHOUT ANY WARRANTY; without even the implied
//  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along
//  with the Computational Morphometry Toolkit.  If not, see
//  <http://www.gnu.org/licenses/>.
//
//  $Revision: 3964 $
//
//  $LastChangedDate: 2012-03-06 09:46:25 -0800 (Tue, 06 Mar 2012) $
//
//  $LastChangedBy: torstenrohlfing $
//
*/

#ifndef __cmtkImagePairSimilarityMeasureWithGradient_h_included_
#define __cmtkImagePairSimilarityMeasureWithGradient_h_included_

#include <cmtkconfig.h>

#include <Registration/cmtkImagePairSimilarityMeasure.h>

#include <Base/cmtkScalarImageGradientField.h>

#include <System/cmtkSmartPtr.h>

namespace
cmtk
{

/** \addtogroup Registration */
//@{

/** Base class for voxel metrics with pre-converted image data and floating image gradient.
 */
class ImagePairSimilarityMeasureWithGradient
  : public ImagePairSimilarityMeasure
{
public:
  /// This type.
  typedef ImagePairSimilarityMeasureWithGradient Self;

  /// Parent class.
  typedef ImagePairSimilarityMeasure Self;

  /// Smart pointer.
  typedef SmartPointer<Self> SmartPtr;

  /// Return type: same as cmtk::Functional.
  typedef Functional::ReturnType ReturnType;

  /** Constructor.
   */
  ImagePairSimilarityMeasureWithGradient( const UniformVolume::SmartConstPtr& refVolume /*!< The reference image.*/,
					  const UniformVolume::SmartConstPtr& fltVolume /*!< The floating image.*/,
					  const Interpolators::InterpolationEnum interpolation = Interpolators::DEFAULT /*!< User-selected interpolation kernel*/ ) : Superclass( refVolume, fltVolume, interpolation ) 
  {
    this->m_FloatingImageGradient = ScalarImageGradientField( fltVolume ).Get();
  }

  /** Default constructor.
   */
  ImagePairSimilarityMeasureWithGradient( const Interpolators::InterpolationEnum interpolation = Interpolators::DEFAULT /*!< User-selected interpolation kernel*/ ) : Superclass( interpolation ) {}

  /// Virtual destructor.
  virtual ~ImagePairSimilarityMeasureWithGradient() {};

  /** Set floating volume.
   * When the floating volume is set, its gradient map is also updated before handing the new volume to the corresponding base class member function.
   */
  virtual void SetFloatingVolume( const UniformVolume::SmartConstPtr& fltVolume )
  {
    this->m_FloatingImageGradient = ScalarImageGradientField( fltVolume ).Get();
    Superclass::SetFloatingVolume( fltVolume );
  }

private:
  /// Smart pointer to reference volume.
  ScalarImageGradientField::GradientFieldType::SmartConstPtr m_FloatingImageGradient;
};

//@}

} // namespace cmtk

#endif // #ifndef __cmtkImagePairSimilarityMeasureWithGradient_h_included_
