#! /bin/sh

#BEGIN DEPEND------------------------------------------------------------------
INPUT_MANAGE='src/lib/perl5/COD/CIF/Tags/Manage.pm'
INPUT_PRINT='src/lib/perl5/COD/CIF/Tags/Print.pm'
#END DEPEND--------------------------------------------------------------------

perl <<'END_SCRIPT'
#------------------------------------------------------------------------------
#$Author: andrius $
#$Date: 2019-03-15 13:25:57 +0200 (Fri, 15 Mar 2019) $ 
#$Revision: 6791 $
#$URL: svn+ssh://www.crystallography.net/home/coder/svn-repositories/cod-tools/tags/v3.0.1/tests/shtests/print_cif_001.sh $
#------------------------------------------------------------------------------
#*
#  Unit test for the COD::CIF::Tags::Print::print_cif() subroutine.
#**

use strict;
use warnings;

use COD::CIF::Tags::Manage qw( new_datablock );
use COD::CIF::Tags::Print qw( print_cif );

# Test the way a properly formed loop is printed
my $data_block = new_datablock( 'data' );
my $save_block = new_datablock( 'save' );
push @{$data_block->{save_blocks}}, $save_block;

print_cif( $data_block );

END_SCRIPT
