#------------------------------------------------------------------------
#$Author: antanas $
#$Date: 2022-05-31 15:26:53 +0300 (Tue, 31 May 2022) $
#$Revision: 9322 $
#$URL: svn+ssh://www.crystallography.net/home/coder/svn-repositories/cod-tools/tags/v3.6.0/src/lib/perl5/COD/Spacegroups/Lookup/COD.pm $
#------------------------------------------------------------------------
#*
#**

package COD::Spacegroups::Lookup::COD;

use strict;
use warnings;

require Exporter;
our @ISA = qw( Exporter );
our @EXPORT_OK = qw(
    @table @extra_settings
);

# NOTE: some code using this table (cif_cod_check) assumes that
# rhombohedral space groups in hexagonal setting have universal_h_m
# field matching the pattern /^H|:H$/ (e.g. 'R 3 2 :H' or 'H 3 2'), and
# for the rhombohedral setting universal_h_m values do not match this
# pattern.

@COD::Spacegroups::Lookup::COD::table =
(
{
    number          => 1,
    hall            => 'P 1',
    schoenflies     => 'C1^1',
    hermann_mauguin => 'P 1',
    universal_h_m   => 'P 1',
    crystal_class   => 'triclinic',
    constraints     => '1',
    symops => [
        'x,y,z',
    ],
    ncsym => [
        'x,y,z',
    ]
},

{
    number          => 2,
    hall            => '-P 1',
    schoenflies     => 'Ci^1',
    hermann_mauguin => 'P -1',
    universal_h_m   => 'P -1',
    crystal_class   => 'triclinic',
    constraints     => '1',
    symops => [
        'x,y,z',
        '-x,-y,-z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,-z',
    ]
},

{
    number          => 3,
    hall            => 'P 2y',
    schoenflies     => 'C2^1',
    hermann_mauguin => 'P 1 2 1',
    universal_h_m   => 'P 1 2 1',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y,-z',
    ],
    ncsym => [
        'x,y,z',
        '-x,y,-z',
    ]
},

{
    number          => 3,
    hall            => 'P 2',
    schoenflies     => 'C2^1',
    hermann_mauguin => 'P 1 1 2',
    universal_h_m   => 'P 1 1 2',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
    ]
},

{
    number          => 3,
    hall            => 'P 2x',
    schoenflies     => 'C2^1',
    hermann_mauguin => 'P 2 1 1',
    universal_h_m   => 'P 2 1 1',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,-y,-z',
    ],
    ncsym => [
        'x,y,z',
        'x,-y,-z',
    ]
},

{
    number          => 4,
    hall            => 'P 2yb',
    schoenflies     => 'C2^2',
    hermann_mauguin => 'P 1 21 1',
    universal_h_m   => 'P 1 21 1',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        '-x,y+1/2,-z',
    ]
},

{
    number          => 4,
    hall            => 'P 2c',
    schoenflies     => 'C2^2',
    hermann_mauguin => 'P 1 1 21',
    universal_h_m   => 'P 1 1 21',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        '-x,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
    ]
},

{
    number          => 4,
    hall            => 'P 2xa',
    schoenflies     => 'C2^2',
    hermann_mauguin => 'P 21 1 1',
    universal_h_m   => 'P 21 1 1',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,-y,-z',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,-y,-z',
    ]
},

{
    number          => 5,
    hall            => 'C 2y',
    schoenflies     => 'C2^3',
    hermann_mauguin => 'C 1 2 1',
    universal_h_m   => 'C 1 2 1',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y,-z',
        'x+1/2,y+1/2,z',
        '-x+1/2,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        '-x,y,-z',
    ]
},

{
    number          => 5,
    hall            => 'A 2y',
    schoenflies     => 'C2^3',
    hermann_mauguin => 'A 1 2 1',
    universal_h_m   => 'A 1 2 1',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y,-z',
        'x,y+1/2,z+1/2',
        '-x,y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,y,-z',
    ]
},

{
    number          => 5,
    hall            => 'I 2y',
    schoenflies     => 'C2^3',
    hermann_mauguin => 'I 1 2 1',
    universal_h_m   => 'I 1 2 1',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y,-z',
        'x+1/2,y+1/2,z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,y,-z',
    ]
},

{
    number          => 5,
    hall            => 'A 2',
    schoenflies     => 'C2^3',
    hermann_mauguin => 'A 1 1 2',
    universal_h_m   => 'A 1 1 2',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x,y+1/2,z+1/2',
        '-x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
    ]
},

{
    number          => 5,
    hall            => 'B 2',
    schoenflies     => 'C2^3',
    hermann_mauguin => 'B 1 1 2',
    universal_h_m   => 'B 1 1 2',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x+1/2,y,z+1/2',
        '-x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
    ]
},

{
    number          => 5,
    hall            => 'I 2',
    schoenflies     => 'C2^3',
    hermann_mauguin => 'I 1 1 2',
    universal_h_m   => 'I 1 1 2',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x+1/2,y+1/2,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
    ]
},

{
    number          => 5,
    hall            => 'B 2x',
    schoenflies     => 'C2^3',
    hermann_mauguin => 'B 2 1 1',
    universal_h_m   => 'B 2 1 1',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,-y,-z',
        'x+1/2,y,z+1/2',
        'x+1/2,-y,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,-y,-z',
    ]
},

{
    number          => 5,
    hall            => 'C 2x',
    schoenflies     => 'C2^3',
    hermann_mauguin => 'C 2 1 1',
    universal_h_m   => 'C 2 1 1',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,-y,-z',
        'x+1/2,y+1/2,z',
        'x+1/2,-y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        'x,-y,-z',
    ]
},

{
    number          => 5,
    hall            => 'I 2x',
    schoenflies     => 'C2^3',
    hermann_mauguin => 'I 2 1 1',
    universal_h_m   => 'I 2 1 1',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,-y,-z',
        'x+1/2,y+1/2,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,-y,-z',
    ]
},

{
    number          => 6,
    hall            => 'P -2y',
    schoenflies     => 'Cs^1',
    hermann_mauguin => 'P 1 m 1',
    universal_h_m   => 'P 1 m 1',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,-y,z',
    ],
    ncsym => [
        'x,y,z',
        'x,-y,z',
    ]
},

{
    number          => 6,
    hall            => 'P -2',
    schoenflies     => 'Cs^1',
    hermann_mauguin => 'P 1 1 m',
    universal_h_m   => 'P 1 1 m',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        'x,y,-z',
    ],
    ncsym => [
        'x,y,z',
        'x,y,-z',
    ]
},

{
    number          => 6,
    hall            => 'P -2x',
    schoenflies     => 'Cs^1',
    hermann_mauguin => 'P m 1 1',
    universal_h_m   => 'P m 1 1',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,y,z',
    ]
},

{
    number          => 7,
    hall            => 'P -2yc',
    schoenflies     => 'Cs^2',
    hermann_mauguin => 'P 1 c 1',
    universal_h_m   => 'P 1 c 1',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,-y,z+1/2',
    ]
},

{
    number          => 7,
    hall            => 'P -2yac',
    schoenflies     => 'Cs^2',
    hermann_mauguin => 'P 1 n 1',
    universal_h_m   => 'P 1 n 1',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,-y,z+1/2',
    ]
},

{
    number          => 7,
    hall            => 'P -2ya',
    schoenflies     => 'Cs^2',
    hermann_mauguin => 'P 1 a 1',
    universal_h_m   => 'P 1 a 1',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,-y,z',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,-y,z',
    ]
},

{
    number          => 7,
    hall            => 'P -2a',
    schoenflies     => 'Cs^2',
    hermann_mauguin => 'P 1 1 a',
    universal_h_m   => 'P 1 1 a',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        'x+1/2,y,-z',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y,-z',
    ]
},

{
    number          => 7,
    hall            => 'P -2ab',
    schoenflies     => 'Cs^2',
    hermann_mauguin => 'P 1 1 n',
    universal_h_m   => 'P 1 1 n',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        'x+1/2,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y+1/2,-z',
    ]
},

{
    number          => 7,
    hall            => 'P -2b',
    schoenflies     => 'Cs^2',
    hermann_mauguin => 'P 1 1 b',
    universal_h_m   => 'P 1 1 b',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        'x,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        'x,y+1/2,-z',
    ]
},

{
    number          => 7,
    hall            => 'P -2xb',
    schoenflies     => 'Cs^2',
    hermann_mauguin => 'P b 1 1',
    universal_h_m   => 'P b 1 1',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,y+1/2,z',
    ]
},

{
    number          => 7,
    hall            => 'P -2xbc',
    schoenflies     => 'Cs^2',
    hermann_mauguin => 'P n 1 1',
    universal_h_m   => 'P n 1 1',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,y+1/2,z+1/2',
    ]
},

{
    number          => 7,
    hall            => 'P -2xc',
    schoenflies     => 'Cs^2',
    hermann_mauguin => 'P c 1 1',
    universal_h_m   => 'P c 1 1',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,y,z+1/2',
    ]
},

{
    number          => 8,
    hall            => 'C -2y',
    schoenflies     => 'Cs^3',
    hermann_mauguin => 'C 1 m 1',
    universal_h_m   => 'C 1 m 1',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,-y,z',
        'x+1/2,y+1/2,z',
        'x+1/2,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        'x,-y,z',
    ]
},

{
    number          => 8,
    hall            => 'A -2y',
    schoenflies     => 'Cs^3',
    hermann_mauguin => 'A 1 m 1',
    universal_h_m   => 'A 1 m 1',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,-y,z',
        'x,y+1/2,z+1/2',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,-y,z',
    ]
},

{
    number          => 8,
    hall            => 'I -2y',
    schoenflies     => 'Cs^3',
    hermann_mauguin => 'I 1 m 1',
    universal_h_m   => 'I 1 m 1',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,-y,z',
        'x+1/2,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,-y,z',
    ]
},

{
    number          => 8,
    hall            => 'A -2',
    schoenflies     => 'Cs^3',
    hermann_mauguin => 'A 1 1 m',
    universal_h_m   => 'A 1 1 m',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        'x,y,-z',
        'x,y+1/2,z+1/2',
        'x,y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,y,-z',
    ]
},

{
    number          => 8,
    hall            => 'B -2',
    schoenflies     => 'Cs^3',
    hermann_mauguin => 'B 1 1 m',
    universal_h_m   => 'B 1 1 m',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        'x,y,-z',
        'x+1/2,y,z+1/2',
        'x+1/2,y,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,y,-z',
    ]
},

{
    number          => 8,
    hall            => 'I -2',
    schoenflies     => 'Cs^3',
    hermann_mauguin => 'I 1 1 m',
    universal_h_m   => 'I 1 1 m',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        'x,y,-z',
        'x+1/2,y+1/2,z+1/2',
        'x+1/2,y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,y,-z',
    ]
},

{
    number          => 8,
    hall            => 'B -2x',
    schoenflies     => 'Cs^3',
    hermann_mauguin => 'B m 1 1',
    universal_h_m   => 'B m 1 1',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y,z',
        'x+1/2,y,z+1/2',
        '-x+1/2,y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,y,z',
    ]
},

{
    number          => 8,
    hall            => 'C -2x',
    schoenflies     => 'Cs^3',
    hermann_mauguin => 'C m 1 1',
    universal_h_m   => 'C m 1 1',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y,z',
        'x+1/2,y+1/2,z',
        '-x+1/2,y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,y,z',
    ]
},

{
    number          => 8,
    hall            => 'I -2x',
    schoenflies     => 'Cs^3',
    hermann_mauguin => 'I m 1 1',
    universal_h_m   => 'I m 1 1',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y,z',
        'x+1/2,y+1/2,z+1/2',
        '-x+1/2,y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,y,z',
    ]
},

{
    number          => 9,
    hall            => 'C -2yc',
    schoenflies     => 'Cs^4',
    hermann_mauguin => 'C 1 c 1',
    universal_h_m   => 'C 1 c 1',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,-y,z+1/2',
        'x+1/2,y+1/2,z',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,-y,z+1/2',
    ]
},

{
    number          => 9,
    hall            => 'A -2yab',
    schoenflies     => 'Cs^4',
    hermann_mauguin => 'A 1 n 1',
    universal_h_m   => 'A 1 n 1',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,-y+1/2,z',
        'x,y+1/2,z+1/2',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,-y+1/2,z',
    ]
},

{
    number          => 9,
    hall            => 'I -2ya',
    schoenflies     => 'Cs^4',
    hermann_mauguin => 'I 1 a 1',
    universal_h_m   => 'I 1 a 1',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,-y,z',
        'x+1/2,y+1/2,z+1/2',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,-y,z',
    ]
},

{
    number          => 9,
    hall            => 'A -2ya',
    schoenflies     => 'Cs^4',
    hermann_mauguin => 'A 1 a 1',
    universal_h_m   => 'A 1 a 1',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,-y,z',
        'x,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,-y,z',
    ]
},

{
    number          => 9,
    hall            => 'C -2yac',
    schoenflies     => 'Cs^4',
    hermann_mauguin => 'C 1 n 1',
    universal_h_m   => 'C 1 n 1',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,-y,z+1/2',
        'x+1/2,y+1/2,z',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,-y,z+1/2',
    ]
},

{
    number          => 9,
    hall            => 'I -2yc',
    schoenflies     => 'Cs^4',
    hermann_mauguin => 'I 1 c 1',
    universal_h_m   => 'I 1 c 1',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,-y,z+1/2',
        'x+1/2,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        'x,-y,z+1/2',
    ]
},

{
    number          => 9,
    hall            => 'A -2a',
    schoenflies     => 'Cs^4',
    hermann_mauguin => 'A 1 1 a',
    universal_h_m   => 'A 1 1 a',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        'x+1/2,y,-z',
        'x,y+1/2,z+1/2',
        'x+1/2,y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y,-z',
    ]
},

{
    number          => 9,
    hall            => 'B -2ab',
    schoenflies     => 'Cs^4',
    hermann_mauguin => 'B 1 1 n',
    universal_h_m   => 'B 1 1 n',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        'x+1/2,y+1/2,-z',
        'x+1/2,y,z+1/2',
        'x,y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y+1/2,-z',
    ]
},

{
    number          => 9,
    hall            => 'I -2b',
    schoenflies     => 'Cs^4',
    hermann_mauguin => 'I 1 1 b',
    universal_h_m   => 'I 1 1 b',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        'x,y+1/2,-z',
        'x+1/2,y+1/2,z+1/2',
        'x+1/2,y,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,y+1/2,-z',
    ]
},

{
    number          => 9,
    hall            => 'B -2b',
    schoenflies     => 'Cs^4',
    hermann_mauguin => 'B 1 1 b',
    universal_h_m   => 'B 1 1 b',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        'x,y+1/2,-z',
        'x+1/2,y,z+1/2',
        'x+1/2,y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,y+1/2,-z',
    ]
},

{
    number          => 9,
    hall            => 'A -2ab',
    schoenflies     => 'Cs^4',
    hermann_mauguin => 'A 1 1 n',
    universal_h_m   => 'A 1 1 n',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        'x+1/2,y+1/2,-z',
        'x,y+1/2,z+1/2',
        'x+1/2,y,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y+1/2,-z',
    ]
},

{
    number          => 9,
    hall            => 'I -2a',
    schoenflies     => 'Cs^4',
    hermann_mauguin => 'I 1 1 a',
    universal_h_m   => 'I 1 1 a',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        'x+1/2,y,-z',
        'x+1/2,y+1/2,z+1/2',
        'x,y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y,-z',
    ]
},

{
    number          => 9,
    hall            => 'B -2xb',
    schoenflies     => 'Cs^4',
    hermann_mauguin => 'B b 1 1',
    universal_h_m   => 'B b 1 1',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y+1/2,z',
        'x+1/2,y,z+1/2',
        '-x+1/2,y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,y+1/2,z',
    ]
},

{
    number          => 9,
    hall            => 'C -2xac',
    schoenflies     => 'Cs^4',
    hermann_mauguin => 'C n 1 1',
    universal_h_m   => 'C n 1 1',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y,z+1/2',
        'x+1/2,y+1/2,z',
        '-x,y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,y,z+1/2',
    ]
},

{
    number          => 9,
    hall            => 'I -2xc',
    schoenflies     => 'Cs^4',
    hermann_mauguin => 'I c 1 1',
    universal_h_m   => 'I c 1 1',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y,z+1/2',
        'x+1/2,y+1/2,z+1/2',
        '-x+1/2,y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,y,z+1/2',
    ]
},

{
    number          => 9,
    hall            => 'C -2xc',
    schoenflies     => 'Cs^4',
    hermann_mauguin => 'C c 1 1',
    universal_h_m   => 'C c 1 1',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y,z+1/2',
        'x+1/2,y+1/2,z',
        '-x+1/2,y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,y,z+1/2',
    ]
},

{
    number          => 9,
    hall            => 'B -2xab',
    schoenflies     => 'Cs^4',
    hermann_mauguin => 'B n 1 1',
    universal_h_m   => 'B n 1 1',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y+1/2,z',
        'x+1/2,y,z+1/2',
        '-x,y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,y+1/2,z',
    ]
},

{
    number          => 9,
    hall            => 'I -2xb',
    schoenflies     => 'Cs^4',
    hermann_mauguin => 'I b 1 1',
    universal_h_m   => 'I b 1 1',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y+1/2,z',
        'x+1/2,y+1/2,z+1/2',
        '-x+1/2,y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,y+1/2,z',
    ]
},

{
    number          => 10,
    hall            => '-P 2y',
    schoenflies     => 'C2h^1',
    hermann_mauguin => 'P 1 2/m 1',
    universal_h_m   => 'P 1 2/m 1',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y,-z',
        '-x,-y,-z',
        'x,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,y,-z',
        '-x,-y,-z',
        'x,-y,z',
    ]
},

{
    number          => 10,
    hall            => '-P 2',
    schoenflies     => 'C2h^1',
    hermann_mauguin => 'P 1 1 2/m',
    universal_h_m   => 'P 1 1 2/m',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        '-x,-y,-z',
        'x,y,-z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        '-x,-y,-z',
        'x,y,-z',
    ]
},

{
    number          => 10,
    hall            => '-P 2x',
    schoenflies     => 'C2h^1',
    hermann_mauguin => 'P 2/m 1 1',
    universal_h_m   => 'P 2/m 1 1',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,-y,-z',
        '-x,-y,-z',
        '-x,y,z',
    ],
    ncsym => [
        'x,y,z',
        'x,-y,-z',
        '-x,-y,-z',
        '-x,y,z',
    ]
},

{
    number          => 11,
    hall            => '-P 2yb',
    schoenflies     => 'C2h^2',
    hermann_mauguin => 'P 1 21/m 1',
    universal_h_m   => 'P 1 21/m 1',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'x,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'x,-y+1/2,z',
    ]
},

{
    number          => 11,
    hall            => '-P 2c',
    schoenflies     => 'C2h^2',
    hermann_mauguin => 'P 1 1 21/m',
    universal_h_m   => 'P 1 1 21/m',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        '-x,-y,z+1/2',
        '-x,-y,-z',
        'x,y,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
        '-x,-y,-z',
        'x,y,-z+1/2',
    ]
},

{
    number          => 11,
    hall            => '-P 2xa',
    schoenflies     => 'C2h^2',
    hermann_mauguin => 'P 21/m 1 1',
    universal_h_m   => 'P 21/m 1 1',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,-y,-z',
        '-x,-y,-z',
        '-x+1/2,y,z',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,-y,-z',
        '-x,-y,-z',
        '-x+1/2,y,z',
    ]
},

{
    number          => 12,
    hall            => '-C 2y',
    schoenflies     => 'C2h^3',
    hermann_mauguin => 'C 1 2/m 1',
    universal_h_m   => 'C 1 2/m 1',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y,-z',
        '-x,-y,-z',
        'x,-y,z',
        'x+1/2,y+1/2,z',
        '-x+1/2,y+1/2,-z',
        '-x+1/2,-y+1/2,-z',
        'x+1/2,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,y,-z',
        '-x,-y,-z',
        'x,-y,z',
    ]
},

{
    number          => 12,
    hall            => '-A 2y',
    schoenflies     => 'C2h^3',
    hermann_mauguin => 'A 1 2/m 1',
    universal_h_m   => 'A 1 2/m 1',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y,-z',
        '-x,-y,-z',
        'x,-y,z',
        'x,y+1/2,z+1/2',
        '-x,y+1/2,-z+1/2',
        '-x,-y+1/2,-z+1/2',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,y,-z',
        '-x,-y,-z',
        'x,-y,z',
    ]
},

{
    number          => 12,
    hall            => '-I 2y',
    schoenflies     => 'C2h^3',
    hermann_mauguin => 'I 1 2/m 1',
    universal_h_m   => 'I 1 2/m 1',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y,-z',
        '-x,-y,-z',
        'x,-y,z',
        'x+1/2,y+1/2,z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,y,-z',
        '-x,-y,-z',
        'x,-y,z',
    ]
},

{
    number          => 12,
    hall            => '-A 2',
    schoenflies     => 'C2h^3',
    hermann_mauguin => 'A 1 1 2/m',
    universal_h_m   => 'A 1 1 2/m',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        '-x,-y,-z',
        'x,y,-z',
        'x,y+1/2,z+1/2',
        '-x,-y+1/2,z+1/2',
        '-x,-y+1/2,-z+1/2',
        'x,y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        '-x,-y,-z',
        'x,y,-z',
    ]
},

{
    number          => 12,
    hall            => '-B 2',
    schoenflies     => 'C2h^3',
    hermann_mauguin => 'B 1 1 2/m',
    universal_h_m   => 'B 1 1 2/m',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        '-x,-y,-z',
        'x,y,-z',
        'x+1/2,y,z+1/2',
        '-x+1/2,-y,z+1/2',
        '-x+1/2,-y,-z+1/2',
        'x+1/2,y,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        '-x,-y,-z',
        'x,y,-z',
    ]
},

{
    number          => 12,
    hall            => '-I 2',
    schoenflies     => 'C2h^3',
    hermann_mauguin => 'I 1 1 2/m',
    universal_h_m   => 'I 1 1 2/m',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        '-x,-y,-z',
        'x,y,-z',
        'x+1/2,y+1/2,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        '-x,-y,-z',
        'x,y,-z',
    ]
},

{
    number          => 12,
    hall            => '-B 2x',
    schoenflies     => 'C2h^3',
    hermann_mauguin => 'B 2/m 1 1',
    universal_h_m   => 'B 2/m 1 1',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,-y,-z',
        '-x,-y,-z',
        '-x,y,z',
        'x+1/2,y,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x+1/2,-y,-z+1/2',
        '-x+1/2,y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,-y,-z',
        '-x,-y,-z',
        '-x,y,z',
    ]
},

{
    number          => 12,
    hall            => '-C 2x',
    schoenflies     => 'C2h^3',
    hermann_mauguin => 'C 2/m 1 1',
    universal_h_m   => 'C 2/m 1 1',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,-y,-z',
        '-x,-y,-z',
        '-x,y,z',
        'x+1/2,y+1/2,z',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,-y+1/2,-z',
        '-x+1/2,y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        'x,-y,-z',
        '-x,-y,-z',
        '-x,y,z',
    ]
},

{
    number          => 12,
    hall            => '-I 2x',
    schoenflies     => 'C2h^3',
    hermann_mauguin => 'I 2/m 1 1',
    universal_h_m   => 'I 2/m 1 1',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,-y,-z',
        '-x,-y,-z',
        '-x,y,z',
        'x+1/2,y+1/2,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,-y,-z',
        '-x,-y,-z',
        '-x,y,z',
    ]
},

{
    number          => 13,
    hall            => '-P 2yc',
    schoenflies     => 'C2h^4',
    hermann_mauguin => 'P 1 2/c 1',
    universal_h_m   => 'P 1 2/c 1',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'x,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'x,-y,z+1/2',
    ]
},

{
    number          => 13,
    hall            => '-P 2yac',
    schoenflies     => 'C2h^4',
    hermann_mauguin => 'P 1 2/n 1',
    universal_h_m   => 'P 1 2/n 1',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y,-z+1/2',
        '-x,-y,-z',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,y,-z+1/2',
        '-x,-y,-z',
        'x+1/2,-y,z+1/2',
    ]
},

{
    number          => 13,
    hall            => '-P 2ya',
    schoenflies     => 'C2h^4',
    hermann_mauguin => 'P 1 2/a 1',
    universal_h_m   => 'P 1 2/a 1',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x+1/2,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x+1/2,-y,z',
    ]
},

{
    number          => 13,
    hall            => '-P 2a',
    schoenflies     => 'C2h^4',
    hermann_mauguin => 'P 1 1 2/a',
    universal_h_m   => 'P 1 1 2/a',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z',
        '-x,-y,-z',
        'x+1/2,y,-z',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z',
        '-x,-y,-z',
        'x+1/2,y,-z',
    ]
},

{
    number          => 13,
    hall            => '-P 2ab',
    schoenflies     => 'C2h^4',
    hermann_mauguin => 'P 1 1 2/n',
    universal_h_m   => 'P 1 1 2/n',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
    ]
},

{
    number          => 13,
    hall            => '-P 2b',
    schoenflies     => 'C2h^4',
    hermann_mauguin => 'P 1 1 2/b',
    universal_h_m   => 'P 1 1 2/b',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z',
        '-x,-y,-z',
        'x,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z',
        '-x,-y,-z',
        'x,y+1/2,-z',
    ]
},

{
    number          => 13,
    hall            => '-P 2xb',
    schoenflies     => 'C2h^4',
    hermann_mauguin => 'P 2/b 1 1',
    universal_h_m   => 'P 2/b 1 1',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,-y+1/2,-z',
        '-x,-y,-z',
        '-x,y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        'x,-y+1/2,-z',
        '-x,-y,-z',
        '-x,y+1/2,z',
    ]
},

{
    number          => 13,
    hall            => '-P 2xbc',
    schoenflies     => 'C2h^4',
    hermann_mauguin => 'P 2/n 1 1',
    universal_h_m   => 'P 2/n 1 1',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,-y+1/2,-z+1/2',
        '-x,-y,-z',
        '-x,y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,-y+1/2,-z+1/2',
        '-x,-y,-z',
        '-x,y+1/2,z+1/2',
    ]
},

{
    number          => 13,
    hall            => '-P 2xc',
    schoenflies     => 'C2h^4',
    hermann_mauguin => 'P 2/c 1 1',
    universal_h_m   => 'P 2/c 1 1',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,-y,-z+1/2',
        '-x,-y,-z',
        '-x,y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,-y,-z+1/2',
        '-x,-y,-z',
        '-x,y,z+1/2',
    ]
},

{
    number          => 14,
    hall            => '-P 2ybc',
    schoenflies     => 'C2h^5',
    hermann_mauguin => 'P 1 21/c 1',
    universal_h_m   => 'P 1 21/c 1',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x,-y+1/2,z+1/2',
    ]
},

{
    number          => 14,
    hall            => '-P 2yn',
    schoenflies     => 'C2h^5',
    hermann_mauguin => 'P 1 21/n 1',
    universal_h_m   => 'P 1 21/n 1',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x+1/2,-y+1/2,z+1/2',
    ]
},

{
    number          => 14,
    hall            => '-P 2yab',
    schoenflies     => 'C2h^5',
    hermann_mauguin => 'P 1 21/a 1',
    universal_h_m   => 'P 1 21/a 1',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y+1/2,-z',
        '-x,-y,-z',
        'x+1/2,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,y+1/2,-z',
        '-x,-y,-z',
        'x+1/2,-y+1/2,z',
    ]
},

{
    number          => 14,
    hall            => '-P 2ac',
    schoenflies     => 'C2h^5',
    hermann_mauguin => 'P 1 1 21/a',
    universal_h_m   => 'P 1 1 21/a',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        '-x,-y,-z',
        'x+1/2,y,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        '-x,-y,-z',
        'x+1/2,y,-z+1/2',
    ]
},

{
    number          => 14,
    hall            => '-P 2n',
    schoenflies     => 'C2h^5',
    hermann_mauguin => 'P 1 1 21/n',
    universal_h_m   => 'P 1 1 21/n',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z+1/2',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y+1/2,z+1/2',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z+1/2',
    ]
},

{
    number          => 14,
    hall            => '-P 2bc',
    schoenflies     => 'C2h^5',
    hermann_mauguin => 'P 1 1 21/b',
    universal_h_m   => 'P 1 1 21/b',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z+1/2',
        '-x,-y,-z',
        'x,y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z+1/2',
        '-x,-y,-z',
        'x,y+1/2,-z+1/2',
    ]
},

{
    number          => 14,
    hall            => '-P 2xab',
    schoenflies     => 'C2h^5',
    hermann_mauguin => 'P 21/b 1 1',
    universal_h_m   => 'P 21/b 1 1',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,-y+1/2,-z',
        '-x,-y,-z',
        '-x+1/2,y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,-y+1/2,-z',
        '-x,-y,-z',
        '-x+1/2,y+1/2,z',
    ]
},

{
    number          => 14,
    hall            => '-P 2xn',
    schoenflies     => 'C2h^5',
    hermann_mauguin => 'P 21/n 1 1',
    universal_h_m   => 'P 21/n 1 1',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,-y+1/2,-z+1/2',
        '-x,-y,-z',
        '-x+1/2,y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,-y+1/2,-z+1/2',
        '-x,-y,-z',
        '-x+1/2,y+1/2,z+1/2',
    ]
},

{
    number          => 14,
    hall            => '-P 2xac',
    schoenflies     => 'C2h^5',
    hermann_mauguin => 'P 21/c 1 1',
    universal_h_m   => 'P 21/c 1 1',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,-y,-z+1/2',
        '-x,-y,-z',
        '-x+1/2,y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,-y,-z+1/2',
        '-x,-y,-z',
        '-x+1/2,y,z+1/2',
    ]
},

{
    number          => 15,
    hall            => '-C 2yc',
    schoenflies     => 'C2h^6',
    hermann_mauguin => 'C 1 2/c 1',
    universal_h_m   => 'C 1 2/c 1',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'x,-y,z+1/2',
        'x+1/2,y+1/2,z',
        '-x+1/2,y+1/2,-z+1/2',
        '-x+1/2,-y+1/2,-z',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'x,-y,z+1/2',
    ]
},

{
    number          => 15,
    hall            => '-A 2yab',
    schoenflies     => 'C2h^6',
    hermann_mauguin => 'A 1 2/n 1',
    universal_h_m   => 'A 1 2/n 1',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y+1/2,-z',
        '-x,-y,-z',
        'x+1/2,-y+1/2,z',
        'x,y+1/2,z+1/2',
        '-x+1/2,y,-z+1/2',
        '-x,-y+1/2,-z+1/2',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,y+1/2,-z',
        '-x,-y,-z',
        'x+1/2,-y+1/2,z',
    ]
},

{
    number          => 15,
    hall            => '-I 2ya',
    schoenflies     => 'C2h^6',
    hermann_mauguin => 'I 1 2/a 1',
    universal_h_m   => 'I 1 2/a 1',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x+1/2,-y,z',
        'x+1/2,y+1/2,z+1/2',
        '-x,y+1/2,-z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x+1/2,-y,z',
    ]
},

{
    number          => 15,
    hall            => '-A 2ya',
    schoenflies     => 'C2h^6',
    hermann_mauguin => 'A 1 2/a 1',
    universal_h_m   => 'A 1 2/a 1',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x+1/2,-y,z',
        'x,y+1/2,z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-x,-y+1/2,-z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x+1/2,-y,z',
    ]
},

{
    number          => 15,
    hall            => '-C 2yac',
    schoenflies     => 'C2h^6',
    hermann_mauguin => 'C 1 2/n 1',
    universal_h_m   => 'C 1 2/n 1',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y,-z+1/2',
        '-x,-y,-z',
        'x+1/2,-y,z+1/2',
        'x+1/2,y+1/2,z',
        '-x,y+1/2,-z+1/2',
        '-x+1/2,-y+1/2,-z',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,y,-z+1/2',
        '-x,-y,-z',
        'x+1/2,-y,z+1/2',
    ]
},

{
    number          => 15,
    hall            => '-I 2yc',
    schoenflies     => 'C2h^6',
    hermann_mauguin => 'I 1 2/c 1',
    universal_h_m   => 'I 1 2/c 1',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'x,-y,z+1/2',
        'x+1/2,y+1/2,z+1/2',
        '-x+1/2,y+1/2,-z',
        '-x+1/2,-y+1/2,-z+1/2',
        'x+1/2,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'x,-y,z+1/2',
    ]
},

{
    number          => 15,
    hall            => '-A 2a',
    schoenflies     => 'C2h^6',
    hermann_mauguin => 'A 1 1 2/a',
    universal_h_m   => 'A 1 1 2/a',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z',
        '-x,-y,-z',
        'x+1/2,y,-z',
        'x,y+1/2,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        '-x,-y+1/2,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z',
        '-x,-y,-z',
        'x+1/2,y,-z',
    ]
},

{
    number          => 15,
    hall            => '-B 2ab',
    schoenflies     => 'C2h^6',
    hermann_mauguin => 'B 1 1 2/n',
    universal_h_m   => 'B 1 1 2/n',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
        'x+1/2,y,z+1/2',
        '-x,-y+1/2,z+1/2',
        '-x+1/2,-y,-z+1/2',
        'x,y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
    ]
},

{
    number          => 15,
    hall            => '-I 2b',
    schoenflies     => 'C2h^6',
    hermann_mauguin => 'I 1 1 2/b',
    universal_h_m   => 'I 1 1 2/b',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z',
        '-x,-y,-z',
        'x,y+1/2,-z',
        'x+1/2,y+1/2,z+1/2',
        '-x+1/2,-y,z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        'x+1/2,y,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z',
        '-x,-y,-z',
        'x,y+1/2,-z',
    ]
},

{
    number          => 15,
    hall            => '-B 2b',
    schoenflies     => 'C2h^6',
    hermann_mauguin => 'B 1 1 2/b',
    universal_h_m   => 'B 1 1 2/b',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z',
        '-x,-y,-z',
        'x,y+1/2,-z',
        'x+1/2,y,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        '-x+1/2,-y,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z',
        '-x,-y,-z',
        'x,y+1/2,-z',
    ]
},

{
    number          => 15,
    hall            => '-A 2ab',
    schoenflies     => 'C2h^6',
    hermann_mauguin => 'A 1 1 2/n',
    universal_h_m   => 'A 1 1 2/n',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
        'x,y+1/2,z+1/2',
        '-x+1/2,-y,z+1/2',
        '-x,-y+1/2,-z+1/2',
        'x+1/2,y,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
    ]
},

{
    number          => 15,
    hall            => '-I 2a',
    schoenflies     => 'C2h^6',
    hermann_mauguin => 'I 1 1 2/a',
    universal_h_m   => 'I 1 1 2/a',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z',
        '-x,-y,-z',
        'x+1/2,y,-z',
        'x+1/2,y+1/2,z+1/2',
        '-x,-y+1/2,z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        'x,y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z',
        '-x,-y,-z',
        'x+1/2,y,-z',
    ]
},

{
    number          => 15,
    hall            => '-B 2xb',
    schoenflies     => 'C2h^6',
    hermann_mauguin => 'B 2/b 1 1',
    universal_h_m   => 'B 2/b 1 1',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,-y+1/2,-z',
        '-x,-y,-z',
        '-x,y+1/2,z',
        'x+1/2,y,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        '-x+1/2,-y,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,-y+1/2,-z',
        '-x,-y,-z',
        '-x,y+1/2,z',
    ]
},

{
    number          => 15,
    hall            => '-C 2xac',
    schoenflies     => 'C2h^6',
    hermann_mauguin => 'C 2/n 1 1',
    universal_h_m   => 'C 2/n 1 1',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,-y,-z+1/2',
        '-x,-y,-z',
        '-x+1/2,y,z+1/2',
        'x+1/2,y+1/2,z',
        'x,-y+1/2,-z+1/2',
        '-x+1/2,-y+1/2,-z',
        '-x,y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,-y,-z+1/2',
        '-x,-y,-z',
        '-x+1/2,y,z+1/2',
    ]
},

{
    number          => 15,
    hall            => '-I 2xc',
    schoenflies     => 'C2h^6',
    hermann_mauguin => 'I 2/c 1 1',
    universal_h_m   => 'I 2/c 1 1',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,-y,-z+1/2',
        '-x,-y,-z',
        '-x,y,z+1/2',
        'x+1/2,y+1/2,z+1/2',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,-y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        'x,-y,-z+1/2',
        '-x,-y,-z',
        '-x,y,z+1/2',
    ]
},

{
    number          => 15,
    hall            => '-C 2xc',
    schoenflies     => 'C2h^6',
    hermann_mauguin => 'C 2/c 1 1',
    universal_h_m   => 'C 2/c 1 1',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,-y,-z+1/2',
        '-x,-y,-z',
        '-x,y,z+1/2',
        'x+1/2,y+1/2,z',
        'x+1/2,-y+1/2,-z+1/2',
        '-x+1/2,-y+1/2,-z',
        '-x+1/2,y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,-y,-z+1/2',
        '-x,-y,-z',
        '-x,y,z+1/2',
    ]
},

{
    number          => 15,
    hall            => '-B 2xab',
    schoenflies     => 'C2h^6',
    hermann_mauguin => 'B 2/n 1 1',
    universal_h_m   => 'B 2/n 1 1',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,-y+1/2,-z',
        '-x,-y,-z',
        '-x+1/2,y+1/2,z',
        'x+1/2,y,z+1/2',
        'x,-y+1/2,-z+1/2',
        '-x+1/2,-y,-z+1/2',
        '-x,y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,-y+1/2,-z',
        '-x,-y,-z',
        '-x+1/2,y+1/2,z',
    ]
},

{
    number          => 15,
    hall            => '-I 2xb',
    schoenflies     => 'C2h^6',
    hermann_mauguin => 'I 2/b 1 1',
    universal_h_m   => 'I 2/b 1 1',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,-y+1/2,-z',
        '-x,-y,-z',
        '-x,y+1/2,z',
        'x+1/2,y+1/2,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        '-x+1/2,y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,-y+1/2,-z',
        '-x,-y,-z',
        '-x,y+1/2,z',
    ]
},

{
    number          => 16,
    hall            => 'P 2 2',
    schoenflies     => 'D2^1',
    hermann_mauguin => 'P 2 2 2',
    universal_h_m   => 'P 2 2 2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
    ]
},

{
    number          => 17,
    hall            => 'P 2c 2',
    schoenflies     => 'D2^2',
    hermann_mauguin => 'P 2 2 21',
    universal_h_m   => 'P 2 2 21',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z+1/2',
        'x,-y,-z',
        '-x,y,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
        'x,-y,-z',
        '-x,y,-z+1/2',
    ]
},

{
    number          => 17,
    hall            => 'P 2a 2a',
    schoenflies     => 'D2^2',
    hermann_mauguin => 'P 21 2 2',
    universal_h_m   => 'P 21 2 2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x+1/2,-y,-z',
        '-x,y,-z',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x+1/2,-y,-z',
        '-x,y,-z',
    ]
},

{
    number          => 17,
    hall            => 'P 2 2b',
    schoenflies     => 'D2^2',
    hermann_mauguin => 'P 2 21 2',
    universal_h_m   => 'P 2 21 2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x,-y+1/2,-z',
        '-x,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y+1/2,-z',
        '-x,y+1/2,-z',
    ]
},

{
    number          => 18,
    hall            => 'P 2 2ab',
    schoenflies     => 'D2^3',
    hermann_mauguin => 'P 21 21 2',
    universal_h_m   => 'P 21 21 2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,y+1/2,-z',
    ]
},

{
    number          => 18,
    hall            => 'P 2bc 2',
    schoenflies     => 'D2^3',
    hermann_mauguin => 'P 2 21 21',
    universal_h_m   => 'P 2 21 21',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z+1/2',
        'x,-y,-z',
        '-x,y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z+1/2',
        'x,-y,-z',
        '-x,y+1/2,-z+1/2',
    ]
},

{
    number          => 18,
    hall            => 'P 2ac 2ac',
    schoenflies     => 'D2^3',
    hermann_mauguin => 'P 21 2 21',
    universal_h_m   => 'P 21 2 21',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x,y,-z',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x,y,-z',
    ]
},

{
    number          => 19,
    hall            => 'P 2ac 2ab',
    schoenflies     => 'D2^4',
    hermann_mauguin => 'P 21 21 21',
    universal_h_m   => 'P 21 21 21',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y+1/2,-z',
        '-x,y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y+1/2,-z',
        '-x,y+1/2,-z+1/2',
    ]
},

{
    number          => 20,
    hall            => 'C 2c 2',
    schoenflies     => 'D2^5',
    hermann_mauguin => 'C 2 2 21',
    universal_h_m   => 'C 2 2 21',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z+1/2',
        'x,-y,-z',
        '-x,y,-z+1/2',
        'x+1/2,y+1/2,z',
        '-x+1/2,-y+1/2,z+1/2',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
        'x,-y,-z',
        '-x,y,-z+1/2',
    ]
},

{
    number          => 20,
    hall            => 'A 2a 2a',
    schoenflies     => 'D2^5',
    hermann_mauguin => 'A 21 2 2',
    universal_h_m   => 'A 21 2 2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x+1/2,-y,-z',
        '-x,y,-z',
        'x,y+1/2,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        '-x,y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x+1/2,-y,-z',
        '-x,y,-z',
    ]
},

{
    number          => 20,
    hall            => 'B 2 2b',
    schoenflies     => 'D2^5',
    hermann_mauguin => 'B 2 21 2',
    universal_h_m   => 'B 2 21 2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x,-y+1/2,-z',
        '-x,y+1/2,-z',
        'x+1/2,y,z+1/2',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y+1/2,-z',
        '-x,y+1/2,-z',
    ]
},

{
    number          => 21,
    hall            => 'C 2 2',
    schoenflies     => 'D2^6',
    hermann_mauguin => 'C 2 2 2',
    universal_h_m   => 'C 2 2 2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        'x+1/2,y+1/2,z',
        '-x+1/2,-y+1/2,z',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
    ]
},

{
    number          => 21,
    hall            => 'A 2 2',
    schoenflies     => 'D2^6',
    hermann_mauguin => 'A 2 2 2',
    universal_h_m   => 'A 2 2 2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        'x,y+1/2,z+1/2',
        '-x,-y+1/2,z+1/2',
        'x,-y+1/2,-z+1/2',
        '-x,y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
    ]
},

{
    number          => 21,
    hall            => 'B 2 2',
    schoenflies     => 'D2^6',
    hermann_mauguin => 'B 2 2 2',
    universal_h_m   => 'B 2 2 2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        'x+1/2,y,z+1/2',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x+1/2,y,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
    ]
},

{
    number          => 22,
    hall            => 'F 2 2',
    schoenflies     => 'D2^7',
    hermann_mauguin => 'F 2 2 2',
    universal_h_m   => 'F 2 2 2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        'x,y+1/2,z+1/2',
        '-x,-y+1/2,z+1/2',
        'x,-y+1/2,-z+1/2',
        '-x,y+1/2,-z+1/2',
        'x+1/2,y,z+1/2',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x+1/2,y,-z+1/2',
        'x+1/2,y+1/2,z',
        '-x+1/2,-y+1/2,z',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
    ]
},

{
    number          => 23,
    hall            => 'I 2 2',
    schoenflies     => 'D2^8',
    hermann_mauguin => 'I 2 2 2',
    universal_h_m   => 'I 2 2 2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        'x+1/2,y+1/2,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
    ]
},

{
    number          => 24,
    hall            => 'I 2b 2c',
    schoenflies     => 'D2^9',
    hermann_mauguin => 'I 21 21 21',
    universal_h_m   => 'I 21 21 21',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x,-y,-z+1/2',
        '-x,y+1/2,-z+1/2',
        'x+1/2,y+1/2,z+1/2',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,y,-z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x,-y,-z+1/2',
        '-x,y+1/2,-z+1/2',
    ]
},

{
    number          => 25,
    hall            => 'P 2 -2',
    schoenflies     => 'C2v^1',
    hermann_mauguin => 'P m m 2',
    universal_h_m   => 'P m m 2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        '-x,y,z',
        'x,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        '-x,y,z',
        'x,-y,z',
    ]
},

{
    number          => 25,
    hall            => 'P -2 2',
    schoenflies     => 'C2v^1',
    hermann_mauguin => 'P 2 m m',
    universal_h_m   => 'P 2 m m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,y,-z',
        'x,-y,-z',
        'x,-y,z',
    ],
    ncsym => [
        'x,y,z',
        'x,y,-z',
        'x,-y,-z',
        'x,-y,z',
    ]
},

{
    number          => 25,
    hall            => 'P -2 -2',
    schoenflies     => 'C2v^1',
    hermann_mauguin => 'P m 2 m',
    universal_h_m   => 'P m 2 m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,y,-z',
        '-x,y,z',
        '-x,y,-z',
    ],
    ncsym => [
        'x,y,z',
        'x,y,-z',
        '-x,y,z',
        '-x,y,-z',
    ]
},

{
    number          => 26,
    hall            => 'P 2c -2',
    schoenflies     => 'C2v^2',
    hermann_mauguin => 'P m c 21',
    universal_h_m   => 'P m c 21',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z+1/2',
        '-x,y,z',
        'x,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
        '-x,y,z',
        'x,-y,z+1/2',
    ]
},

{
    number          => 26,
    hall            => 'P 2c -2c',
    schoenflies     => 'C2v^2',
    hermann_mauguin => 'P c m 21',
    universal_h_m   => 'P c m 21',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z+1/2',
        '-x,y,z+1/2',
        'x,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
        '-x,y,z+1/2',
        'x,-y,z',
    ]
},

{
    number          => 26,
    hall            => 'P -2a 2a',
    schoenflies     => 'C2v^2',
    hermann_mauguin => 'P 21 m a',
    universal_h_m   => 'P 21 m a',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,y,-z',
        'x+1/2,-y,-z',
        'x,-y,z',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y,-z',
        'x+1/2,-y,-z',
        'x,-y,z',
    ]
},

{
    number          => 26,
    hall            => 'P -2 2a',
    schoenflies     => 'C2v^2',
    hermann_mauguin => 'P 21 a m',
    universal_h_m   => 'P 21 a m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,y,-z',
        'x+1/2,-y,-z',
        'x+1/2,-y,z',
    ],
    ncsym => [
        'x,y,z',
        'x,y,-z',
        'x+1/2,-y,-z',
        'x+1/2,-y,z',
    ]
},

{
    number          => 26,
    hall            => 'P -2 -2b',
    schoenflies     => 'C2v^2',
    hermann_mauguin => 'P b 21 m',
    universal_h_m   => 'P b 21 m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,y,-z',
        '-x,y+1/2,z',
        '-x,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        'x,y,-z',
        '-x,y+1/2,z',
        '-x,y+1/2,-z',
    ]
},

{
    number          => 26,
    hall            => 'P -2b -2',
    schoenflies     => 'C2v^2',
    hermann_mauguin => 'P m 21 b',
    universal_h_m   => 'P m 21 b',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,y+1/2,-z',
        '-x,y,z',
        '-x,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        'x,y+1/2,-z',
        '-x,y,z',
        '-x,y+1/2,-z',
    ]
},

{
    number          => 27,
    hall            => 'P 2 -2c',
    schoenflies     => 'C2v^3',
    hermann_mauguin => 'P c c 2',
    universal_h_m   => 'P c c 2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        '-x,y,z+1/2',
        'x,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        '-x,y,z+1/2',
        'x,-y,z+1/2',
    ]
},

{
    number          => 27,
    hall            => 'P -2a 2',
    schoenflies     => 'C2v^3',
    hermann_mauguin => 'P 2 a a',
    universal_h_m   => 'P 2 a a',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,y,-z',
        'x,-y,-z',
        'x+1/2,-y,z',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y,-z',
        'x,-y,-z',
        'x+1/2,-y,z',
    ]
},

{
    number          => 27,
    hall            => 'P -2b -2b',
    schoenflies     => 'C2v^3',
    hermann_mauguin => 'P b 2 b',
    universal_h_m   => 'P b 2 b',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,y+1/2,-z',
        '-x,y+1/2,z',
        '-x,y,-z',
    ],
    ncsym => [
        'x,y,z',
        'x,y+1/2,-z',
        '-x,y+1/2,z',
        '-x,y,-z',
    ]
},

{
    number          => 28,
    hall            => 'P 2 -2a',
    schoenflies     => 'C2v^4',
    hermann_mauguin => 'P m a 2',
    universal_h_m   => 'P m a 2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        '-x+1/2,y,z',
        'x+1/2,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        '-x+1/2,y,z',
        'x+1/2,-y,z',
    ]
},

{
    number          => 28,
    hall            => 'P 2 -2b',
    schoenflies     => 'C2v^4',
    hermann_mauguin => 'P b m 2',
    universal_h_m   => 'P b m 2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        '-x,y+1/2,z',
        'x,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        '-x,y+1/2,z',
        'x,-y+1/2,z',
    ]
},

{
    number          => 28,
    hall            => 'P -2b 2',
    schoenflies     => 'C2v^4',
    hermann_mauguin => 'P 2 m b',
    universal_h_m   => 'P 2 m b',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,y+1/2,-z',
        'x,-y,-z',
        'x,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        'x,y+1/2,-z',
        'x,-y,-z',
        'x,-y+1/2,z',
    ]
},

{
    number          => 28,
    hall            => 'P -2c 2',
    schoenflies     => 'C2v^4',
    hermann_mauguin => 'P 2 c m',
    universal_h_m   => 'P 2 c m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,y,-z+1/2',
        'x,-y,-z',
        'x,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,y,-z+1/2',
        'x,-y,-z',
        'x,-y,z+1/2',
    ]
},

{
    number          => 28,
    hall            => 'P -2c -2c',
    schoenflies     => 'C2v^4',
    hermann_mauguin => 'P c 2 m',
    universal_h_m   => 'P c 2 m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,y,-z+1/2',
        '-x,y,z+1/2',
        '-x,y,-z',
    ],
    ncsym => [
        'x,y,z',
        'x,y,-z+1/2',
        '-x,y,z+1/2',
        '-x,y,-z',
    ]
},

{
    number          => 28,
    hall            => 'P -2a -2a',
    schoenflies     => 'C2v^4',
    hermann_mauguin => 'P m 2 a',
    universal_h_m   => 'P m 2 a',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,y,-z',
        '-x+1/2,y,z',
        '-x,y,-z',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y,-z',
        '-x+1/2,y,z',
        '-x,y,-z',
    ]
},

{
    number          => 29,
    hall            => 'P 2c -2ac',
    schoenflies     => 'C2v^5',
    hermann_mauguin => 'P c a 21',
    universal_h_m   => 'P c a 21',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z+1/2',
        '-x+1/2,y,z+1/2',
        'x+1/2,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
        '-x+1/2,y,z+1/2',
        'x+1/2,-y,z',
    ]
},

{
    number          => 29,
    hall            => 'P 2c -2b',
    schoenflies     => 'C2v^5',
    hermann_mauguin => 'P b c 21',
    universal_h_m   => 'P b c 21',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z+1/2',
        '-x,y+1/2,z',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
        '-x,y+1/2,z',
        'x,-y+1/2,z+1/2',
    ]
},

{
    number          => 29,
    hall            => 'P -2b 2a',
    schoenflies     => 'C2v^5',
    hermann_mauguin => 'P 21 a b',
    universal_h_m   => 'P 21 a b',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,y+1/2,-z',
        'x+1/2,-y,-z',
        'x+1/2,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        'x,y+1/2,-z',
        'x+1/2,-y,-z',
        'x+1/2,-y+1/2,z',
    ]
},

{
    number          => 29,
    hall            => 'P -2ac 2a',
    schoenflies     => 'C2v^5',
    hermann_mauguin => 'P 21 c a',
    universal_h_m   => 'P 21 c a',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,y,-z+1/2',
        'x+1/2,-y,-z',
        'x,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y,-z+1/2',
        'x+1/2,-y,-z',
        'x,-y,z+1/2',
    ]
},

{
    number          => 29,
    hall            => 'P -2bc -2c',
    schoenflies     => 'C2v^5',
    hermann_mauguin => 'P c 21 b',
    universal_h_m   => 'P c 21 b',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,y+1/2,-z+1/2',
        '-x,y,z+1/2',
        '-x,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        'x,y+1/2,-z+1/2',
        '-x,y,z+1/2',
        '-x,y+1/2,-z',
    ]
},

{
    number          => 29,
    hall            => 'P -2a -2ab',
    schoenflies     => 'C2v^5',
    hermann_mauguin => 'P b 21 a',
    universal_h_m   => 'P b 21 a',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,y,-z',
        '-x+1/2,y+1/2,z',
        '-x,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y,-z',
        '-x+1/2,y+1/2,z',
        '-x,y+1/2,-z',
    ]
},

{
    number          => 30,
    hall            => 'P 2 -2bc',
    schoenflies     => 'C2v^6',
    hermann_mauguin => 'P n c 2',
    universal_h_m   => 'P n c 2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        '-x,y+1/2,z+1/2',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        '-x,y+1/2,z+1/2',
        'x,-y+1/2,z+1/2',
    ]
},

{
    number          => 30,
    hall            => 'P 2 -2ac',
    schoenflies     => 'C2v^6',
    hermann_mauguin => 'P c n 2',
    universal_h_m   => 'P c n 2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        '-x+1/2,y,z+1/2',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        '-x+1/2,y,z+1/2',
        'x+1/2,-y,z+1/2',
    ]
},

{
    number          => 30,
    hall            => 'P -2ac 2',
    schoenflies     => 'C2v^6',
    hermann_mauguin => 'P 2 n a',
    universal_h_m   => 'P 2 n a',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,y,-z+1/2',
        'x,-y,-z',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y,-z+1/2',
        'x,-y,-z',
        'x+1/2,-y,z+1/2',
    ]
},

{
    number          => 30,
    hall            => 'P -2ab 2',
    schoenflies     => 'C2v^6',
    hermann_mauguin => 'P 2 a n',
    universal_h_m   => 'P 2 a n',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,y+1/2,-z',
        'x,-y,-z',
        'x+1/2,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y+1/2,-z',
        'x,-y,-z',
        'x+1/2,-y+1/2,z',
    ]
},

{
    number          => 30,
    hall            => 'P -2ab -2ab',
    schoenflies     => 'C2v^6',
    hermann_mauguin => 'P b 2 n',
    universal_h_m   => 'P b 2 n',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,y+1/2,-z',
        '-x+1/2,y+1/2,z',
        '-x,y,-z',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y+1/2,-z',
        '-x+1/2,y+1/2,z',
        '-x,y,-z',
    ]
},

{
    number          => 30,
    hall            => 'P -2bc -2bc',
    schoenflies     => 'C2v^6',
    hermann_mauguin => 'P n 2 b',
    universal_h_m   => 'P n 2 b',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,y+1/2,-z+1/2',
        '-x,y+1/2,z+1/2',
        '-x,y,-z',
    ],
    ncsym => [
        'x,y,z',
        'x,y+1/2,-z+1/2',
        '-x,y+1/2,z+1/2',
        '-x,y,-z',
    ]
},

{
    number          => 31,
    hall            => 'P 2ac -2',
    schoenflies     => 'C2v^7',
    hermann_mauguin => 'P m n 21',
    universal_h_m   => 'P m n 21',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        '-x,y,z',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        '-x,y,z',
        'x+1/2,-y,z+1/2',
    ]
},

{
    number          => 31,
    hall            => 'P 2bc -2bc',
    schoenflies     => 'C2v^7',
    hermann_mauguin => 'P n m 21',
    universal_h_m   => 'P n m 21',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z+1/2',
        '-x,y+1/2,z+1/2',
        'x,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z+1/2',
        '-x,y+1/2,z+1/2',
        'x,-y,z',
    ]
},

{
    number          => 31,
    hall            => 'P -2ab 2ab',
    schoenflies     => 'C2v^7',
    hermann_mauguin => 'P 21 m n',
    universal_h_m   => 'P 21 m n',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,y+1/2,-z',
        'x+1/2,-y+1/2,-z',
        'x,-y,z',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y+1/2,-z',
        'x+1/2,-y+1/2,-z',
        'x,-y,z',
    ]
},

{
    number          => 31,
    hall            => 'P -2 2ac',
    schoenflies     => 'C2v^7',
    hermann_mauguin => 'P 21 n m',
    universal_h_m   => 'P 21 n m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,y,-z',
        'x+1/2,-y,-z+1/2',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,y,-z',
        'x+1/2,-y,-z+1/2',
        'x+1/2,-y,z+1/2',
    ]
},

{
    number          => 31,
    hall            => 'P -2 -2bc',
    schoenflies     => 'C2v^7',
    hermann_mauguin => 'P n 21 m',
    universal_h_m   => 'P n 21 m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,y,-z',
        '-x,y+1/2,z+1/2',
        '-x,y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,y,-z',
        '-x,y+1/2,z+1/2',
        '-x,y+1/2,-z+1/2',
    ]
},

{
    number          => 31,
    hall            => 'P -2ab -2',
    schoenflies     => 'C2v^7',
    hermann_mauguin => 'P m 21 n',
    universal_h_m   => 'P m 21 n',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,y+1/2,-z',
        '-x,y,z',
        '-x+1/2,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y+1/2,-z',
        '-x,y,z',
        '-x+1/2,y+1/2,-z',
    ]
},

{
    number          => 32,
    hall            => 'P 2 -2ab',
    schoenflies     => 'C2v^8',
    hermann_mauguin => 'P b a 2',
    universal_h_m   => 'P b a 2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y+1/2,z',
    ]
},

{
    number          => 32,
    hall            => 'P -2bc 2',
    schoenflies     => 'C2v^8',
    hermann_mauguin => 'P 2 c b',
    universal_h_m   => 'P 2 c b',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,y+1/2,-z+1/2',
        'x,-y,-z',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,y+1/2,-z+1/2',
        'x,-y,-z',
        'x,-y+1/2,z+1/2',
    ]
},

{
    number          => 32,
    hall            => 'P -2ac -2ac',
    schoenflies     => 'C2v^8',
    hermann_mauguin => 'P c 2 a',
    universal_h_m   => 'P c 2 a',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,y,-z+1/2',
        '-x+1/2,y,z+1/2',
        '-x,y,-z',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y,-z+1/2',
        '-x+1/2,y,z+1/2',
        '-x,y,-z',
    ]
},

{
    number          => 33,
    hall            => 'P 2c -2n',
    schoenflies     => 'C2v^9',
    hermann_mauguin => 'P n a 21',
    universal_h_m   => 'P n a 21',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z',
    ]
},

{
    number          => 33,
    hall            => 'P 2c -2ab',
    schoenflies     => 'C2v^9',
    hermann_mauguin => 'P b n 21',
    universal_h_m   => 'P b n 21',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z+1/2',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y+1/2,z+1/2',
    ]
},

{
    number          => 33,
    hall            => 'P -2bc 2a',
    schoenflies     => 'C2v^9',
    hermann_mauguin => 'P 21 n b',
    universal_h_m   => 'P 21 n b',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,y+1/2,-z+1/2',
        'x+1/2,-y,-z',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,y+1/2,-z+1/2',
        'x+1/2,-y,-z',
        'x+1/2,-y+1/2,z+1/2',
    ]
},

{
    number          => 33,
    hall            => 'P -2n 2a',
    schoenflies     => 'C2v^9',
    hermann_mauguin => 'P 21 c n',
    universal_h_m   => 'P 21 c n',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,y+1/2,-z+1/2',
        'x+1/2,-y,-z',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y+1/2,-z+1/2',
        'x+1/2,-y,-z',
        'x,-y+1/2,z+1/2',
    ]
},

{
    number          => 33,
    hall            => 'P -2n -2ac',
    schoenflies     => 'C2v^9',
    hermann_mauguin => 'P c 21 n',
    universal_h_m   => 'P c 21 n',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,y+1/2,-z+1/2',
        '-x+1/2,y,z+1/2',
        '-x,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y+1/2,-z+1/2',
        '-x+1/2,y,z+1/2',
        '-x,y+1/2,-z',
    ]
},

{
    number          => 33,
    hall            => 'P -2ac -2n',
    schoenflies     => 'C2v^9',
    hermann_mauguin => 'P n 21 a',
    universal_h_m   => 'P n 21 a',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,y,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        '-x,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        '-x,y+1/2,-z',
    ]
},

{
    number          => 34,
    hall            => 'P 2 -2n',
    schoenflies     => 'C2v^10',
    hermann_mauguin => 'P n n 2',
    universal_h_m   => 'P n n 2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ]
},

{
    number          => 34,
    hall            => 'P -2n 2',
    schoenflies     => 'C2v^10',
    hermann_mauguin => 'P 2 n n',
    universal_h_m   => 'P 2 n n',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,y+1/2,-z+1/2',
        'x,-y,-z',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y+1/2,-z+1/2',
        'x,-y,-z',
        'x+1/2,-y+1/2,z+1/2',
    ]
},

{
    number          => 34,
    hall            => 'P -2n -2n',
    schoenflies     => 'C2v^10',
    hermann_mauguin => 'P n 2 n',
    universal_h_m   => 'P n 2 n',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        '-x,y,-z',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        '-x,y,-z',
    ]
},

{
    number          => 35,
    hall            => 'C 2 -2',
    schoenflies     => 'C2v^11',
    hermann_mauguin => 'C m m 2',
    universal_h_m   => 'C m m 2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        '-x,y,z',
        'x,-y,z',
        'x+1/2,y+1/2,z',
        '-x+1/2,-y+1/2,z',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        '-x,y,z',
        'x,-y,z',
    ]
},

{
    number          => 35,
    hall            => 'A -2 2',
    schoenflies     => 'C2v^11',
    hermann_mauguin => 'A 2 m m',
    universal_h_m   => 'A 2 m m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,y,-z',
        'x,-y,-z',
        'x,-y,z',
        'x,y+1/2,z+1/2',
        'x,y+1/2,-z+1/2',
        'x,-y+1/2,-z+1/2',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,y,-z',
        'x,-y,-z',
        'x,-y,z',
    ]
},

{
    number          => 35,
    hall            => 'B -2 -2',
    schoenflies     => 'C2v^11',
    hermann_mauguin => 'B m 2 m',
    universal_h_m   => 'B m 2 m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,y,-z',
        '-x,y,z',
        '-x,y,-z',
        'x+1/2,y,z+1/2',
        'x+1/2,y,-z+1/2',
        '-x+1/2,y,z+1/2',
        '-x+1/2,y,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,y,-z',
        '-x,y,z',
        '-x,y,-z',
    ]
},

{
    number          => 36,
    hall            => 'C 2c -2',
    schoenflies     => 'C2v^12',
    hermann_mauguin => 'C m c 21',
    universal_h_m   => 'C m c 21',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z+1/2',
        '-x,y,z',
        'x,-y,z+1/2',
        'x+1/2,y+1/2,z',
        '-x+1/2,-y+1/2,z+1/2',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
        '-x,y,z',
        'x,-y,z+1/2',
    ]
},

{
    number          => 36,
    hall            => 'C 2c -2c',
    schoenflies     => 'C2v^12',
    hermann_mauguin => 'C c m 21',
    universal_h_m   => 'C c m 21',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z+1/2',
        '-x,y,z+1/2',
        'x,-y,z',
        'x+1/2,y+1/2,z',
        '-x+1/2,-y+1/2,z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
        '-x,y,z+1/2',
        'x,-y,z',
    ]
},

{
    number          => 36,
    hall            => 'A -2a 2a',
    schoenflies     => 'C2v^12',
    hermann_mauguin => 'A 21 m a',
    universal_h_m   => 'A 21 m a',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,y,-z',
        'x+1/2,-y,-z',
        'x,-y,z',
        'x,y+1/2,z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y,-z',
        'x+1/2,-y,-z',
        'x,-y,z',
    ]
},

{
    number          => 36,
    hall            => 'A -2 2a',
    schoenflies     => 'C2v^12',
    hermann_mauguin => 'A 21 a m',
    universal_h_m   => 'A 21 a m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,y,-z',
        'x+1/2,-y,-z',
        'x+1/2,-y,z',
        'x,y+1/2,z+1/2',
        'x,y+1/2,-z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,y,-z',
        'x+1/2,-y,-z',
        'x+1/2,-y,z',
    ]
},

{
    number          => 36,
    hall            => 'B -2 -2b',
    schoenflies     => 'C2v^12',
    hermann_mauguin => 'B b 21 m',
    universal_h_m   => 'B b 21 m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,y,-z',
        '-x,y+1/2,z',
        '-x,y+1/2,-z',
        'x+1/2,y,z+1/2',
        'x+1/2,y,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,y,-z',
        '-x,y+1/2,z',
        '-x,y+1/2,-z',
    ]
},

{
    number          => 36,
    hall            => 'B -2b -2',
    schoenflies     => 'C2v^12',
    hermann_mauguin => 'B m 21 b',
    universal_h_m   => 'B m 21 b',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,y+1/2,-z',
        '-x,y,z',
        '-x,y+1/2,-z',
        'x+1/2,y,z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-x+1/2,y,z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,y+1/2,-z',
        '-x,y,z',
        '-x,y+1/2,-z',
    ]
},

{
    number          => 37,
    hall            => 'C 2 -2c',
    schoenflies     => 'C2v^13',
    hermann_mauguin => 'C c c 2',
    universal_h_m   => 'C c c 2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        '-x,y,z+1/2',
        'x,-y,z+1/2',
        'x+1/2,y+1/2,z',
        '-x+1/2,-y+1/2,z',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        '-x,y,z+1/2',
        'x,-y,z+1/2',
    ]
},

{
    number          => 37,
    hall            => 'A -2a 2',
    schoenflies     => 'C2v^13',
    hermann_mauguin => 'A 2 a a',
    universal_h_m   => 'A 2 a a',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,y,-z',
        'x,-y,-z',
        'x+1/2,-y,z',
        'x,y+1/2,z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        'x,-y+1/2,-z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y,-z',
        'x,-y,-z',
        'x+1/2,-y,z',
    ]
},

{
    number          => 37,
    hall            => 'B -2b -2b',
    schoenflies     => 'C2v^13',
    hermann_mauguin => 'B b 2 b',
    universal_h_m   => 'B b 2 b',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,y+1/2,-z',
        '-x,y+1/2,z',
        '-x,y,-z',
        'x+1/2,y,z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        '-x+1/2,y,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,y+1/2,-z',
        '-x,y+1/2,z',
        '-x,y,-z',
    ]
},

{
    number          => 38,
    hall            => 'A 2 -2',
    schoenflies     => 'C2v^14',
    hermann_mauguin => 'A m m 2',
    universal_h_m   => 'A m m 2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        '-x,y,z',
        'x,-y,z',
        'x,y+1/2,z+1/2',
        '-x,-y+1/2,z+1/2',
        '-x,y+1/2,z+1/2',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        '-x,y,z',
        'x,-y,z',
    ]
},

{
    number          => 38,
    hall            => 'B 2 -2',
    schoenflies     => 'C2v^14',
    hermann_mauguin => 'B m m 2',
    universal_h_m   => 'B m m 2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        '-x,y,z',
        'x,-y,z',
        'x+1/2,y,z+1/2',
        '-x+1/2,-y,z+1/2',
        '-x+1/2,y,z+1/2',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        '-x,y,z',
        'x,-y,z',
    ]
},

{
    number          => 38,
    hall            => 'B -2 2',
    schoenflies     => 'C2v^14',
    hermann_mauguin => 'B 2 m m',
    universal_h_m   => 'B 2 m m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,y,-z',
        'x,-y,-z',
        'x,-y,z',
        'x+1/2,y,z+1/2',
        'x+1/2,y,-z+1/2',
        'x+1/2,-y,-z+1/2',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,y,-z',
        'x,-y,-z',
        'x,-y,z',
    ]
},

{
    number          => 38,
    hall            => 'C -2 2',
    schoenflies     => 'C2v^14',
    hermann_mauguin => 'C 2 m m',
    universal_h_m   => 'C 2 m m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,y,-z',
        'x,-y,-z',
        'x,-y,z',
        'x+1/2,y+1/2,z',
        'x+1/2,y+1/2,-z',
        'x+1/2,-y+1/2,-z',
        'x+1/2,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        'x,y,-z',
        'x,-y,-z',
        'x,-y,z',
    ]
},

{
    number          => 38,
    hall            => 'C -2 -2',
    schoenflies     => 'C2v^14',
    hermann_mauguin => 'C m 2 m',
    universal_h_m   => 'C m 2 m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,y,-z',
        '-x,y,z',
        '-x,y,-z',
        'x+1/2,y+1/2,z',
        'x+1/2,y+1/2,-z',
        '-x+1/2,y+1/2,z',
        '-x+1/2,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        'x,y,-z',
        '-x,y,z',
        '-x,y,-z',
    ]
},

{
    number          => 38,
    hall            => 'A -2 -2',
    schoenflies     => 'C2v^14',
    hermann_mauguin => 'A m 2 m',
    universal_h_m   => 'A m 2 m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,y,-z',
        '-x,y,z',
        '-x,y,-z',
        'x,y+1/2,z+1/2',
        'x,y+1/2,-z+1/2',
        '-x,y+1/2,z+1/2',
        '-x,y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,y,-z',
        '-x,y,z',
        '-x,y,-z',
    ]
},

# Renamed from 'A b m 2' to 'A e m 2' as described in
# the International Tables of Crystallography Volume A
{
    number          => 39,
    hall            => 'A 2 -2b',
    schoenflies     => 'C2v^15',
    hermann_mauguin => 'A e m 2',
    universal_h_m   => 'A e m 2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        '-x,y+1/2,z',
        'x,-y+1/2,z',
        'x,y+1/2,z+1/2',
        '-x,-y+1/2,z+1/2',
        '-x,y,z+1/2',
        'x,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        '-x,y+1/2,z',
        'x,-y+1/2,z',
    ]
},

# Renamed from 'B m a 2' to 'B m e 2' as described in
# the International Tables of Crystallography Volume A
{
    number          => 39,
    hall            => 'B 2 -2a',
    schoenflies     => 'C2v^15',
    hermann_mauguin => 'B m e 2',
    universal_h_m   => 'B m e 2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        '-x+1/2,y,z',
        'x+1/2,-y,z',
        'x+1/2,y,z+1/2',
        '-x+1/2,-y,z+1/2',
        '-x,y,z+1/2',
        'x,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        '-x+1/2,y,z',
        'x+1/2,-y,z',
    ]
},

# Renamed from 'B 2 c m' to 'B 2 e m' as described in
# the International Tables of Crystallography Volume A
{
    number          => 39,
    hall            => 'B -2a 2',
    schoenflies     => 'C2v^15',
    hermann_mauguin => 'B 2 e m',
    universal_h_m   => 'B 2 e m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,y,-z',
        'x,-y,-z',
        'x+1/2,-y,z',
        'x+1/2,y,z+1/2',
        'x,y,-z+1/2',
        'x+1/2,-y,-z+1/2',
        'x,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y,-z',
        'x,-y,-z',
        'x+1/2,-y,z',
    ]
},

# Renamed from 'C 2 m b' to 'C 2 m e' as described in
# the International Tables of Crystallography Volume A
{
    number          => 39,
    hall            => 'C -2a 2',
    schoenflies     => 'C2v^15',
    hermann_mauguin => 'C 2 m e',
    universal_h_m   => 'C 2 m e',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,y,-z',
        'x,-y,-z',
        'x+1/2,-y,z',
        'x+1/2,y+1/2,z',
        'x,y+1/2,-z',
        'x+1/2,-y+1/2,-z',
        'x,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y,-z',
        'x,-y,-z',
        'x+1/2,-y,z',
    ]
},

# Renamed from 'C m 2 a' to 'C m 2 e' as described in
# the International Tables of Crystallography Volume A
{
    number          => 39,
    hall            => 'C -2a -2a',
    schoenflies     => 'C2v^15',
    hermann_mauguin => 'C m 2 e',
    universal_h_m   => 'C m 2 e',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,y,-z',
        '-x+1/2,y,z',
        '-x,y,-z',
        'x+1/2,y+1/2,z',
        'x,y+1/2,-z',
        '-x,y+1/2,z',
        '-x+1/2,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y,-z',
        '-x+1/2,y,z',
        '-x,y,-z',
    ]
},

# Renamed from 'A c 2 m' to 'A e 2 m' as described in
# the International Tables of Crystallography Volume A
{
    number          => 39,
    hall            => 'A -2b -2b',
    schoenflies     => 'C2v^15',
    hermann_mauguin => 'A e 2 m',
    universal_h_m   => 'A e 2 m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,y+1/2,-z',
        '-x,y+1/2,z',
        '-x,y,-z',
        'x,y+1/2,z+1/2',
        'x,y,-z+1/2',
        '-x,y,z+1/2',
        '-x,y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,y+1/2,-z',
        '-x,y+1/2,z',
        '-x,y,-z',
    ]
},

{
    number          => 40,
    hall            => 'A 2 -2a',
    schoenflies     => 'C2v^16',
    hermann_mauguin => 'A m a 2',
    universal_h_m   => 'A m a 2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        '-x+1/2,y,z',
        'x+1/2,-y,z',
        'x,y+1/2,z+1/2',
        '-x,-y+1/2,z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        '-x+1/2,y,z',
        'x+1/2,-y,z',
    ]
},

{
    number          => 40,
    hall            => 'B 2 -2b',
    schoenflies     => 'C2v^16',
    hermann_mauguin => 'B b m 2',
    universal_h_m   => 'B b m 2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        '-x,y+1/2,z',
        'x,-y+1/2,z',
        'x+1/2,y,z+1/2',
        '-x+1/2,-y,z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        '-x,y+1/2,z',
        'x,-y+1/2,z',
    ]
},

{
    number          => 40,
    hall            => 'B -2b 2',
    schoenflies     => 'C2v^16',
    hermann_mauguin => 'B 2 m b',
    universal_h_m   => 'B 2 m b',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,y+1/2,-z',
        'x,-y,-z',
        'x,-y+1/2,z',
        'x+1/2,y,z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        'x+1/2,-y,-z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,y+1/2,-z',
        'x,-y,-z',
        'x,-y+1/2,z',
    ]
},

{
    number          => 40,
    hall            => 'C -2c 2',
    schoenflies     => 'C2v^16',
    hermann_mauguin => 'C 2 c m',
    universal_h_m   => 'C 2 c m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,y,-z+1/2',
        'x,-y,-z',
        'x,-y,z+1/2',
        'x+1/2,y+1/2,z',
        'x+1/2,y+1/2,-z+1/2',
        'x+1/2,-y+1/2,-z',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,y,-z+1/2',
        'x,-y,-z',
        'x,-y,z+1/2',
    ]
},

{
    number          => 40,
    hall            => 'C -2c -2c',
    schoenflies     => 'C2v^16',
    hermann_mauguin => 'C c 2 m',
    universal_h_m   => 'C c 2 m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,y,-z+1/2',
        '-x,y,z+1/2',
        '-x,y,-z',
        'x+1/2,y+1/2,z',
        'x+1/2,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        '-x+1/2,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        'x,y,-z+1/2',
        '-x,y,z+1/2',
        '-x,y,-z',
    ]
},

{
    number          => 40,
    hall            => 'A -2a -2a',
    schoenflies     => 'C2v^16',
    hermann_mauguin => 'A m 2 a',
    universal_h_m   => 'A m 2 a',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,y,-z',
        '-x+1/2,y,z',
        '-x,y,-z',
        'x,y+1/2,z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        '-x,y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y,-z',
        '-x+1/2,y,z',
        '-x,y,-z',
    ]
},

# Renamed from 'A b a 2' to 'A e a 2' as described in the International
# Tables of Crystallography Volume A
{
    number          => 41,
    hall            => 'A 2 -2ab',
    schoenflies     => 'C2v^17',
    hermann_mauguin => 'A e a 2',
    universal_h_m   => 'A e a 2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y+1/2,z',
        'x,y+1/2,z+1/2',
        '-x,-y+1/2,z+1/2',
        '-x+1/2,y,z+1/2',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y+1/2,z',
    ]
},

# Renamed from 'B b a 2' to 'B b e 2' as described in the International
# Tables of Crystallography Volume A
{
    number          => 41,
    hall            => 'B 2 -2ab',
    schoenflies     => 'C2v^17',
    hermann_mauguin => 'B b e 2',
    universal_h_m   => 'B b e 2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y+1/2,z',
        'x+1/2,y,z+1/2',
        '-x+1/2,-y,z+1/2',
        '-x,y+1/2,z+1/2',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y+1/2,z',
    ]
},

# Renamed from 'B 2 c b' to 'B 2 e b' as described in the International
# Tables of Crystallography Volume A
{
    number          => 41,
    hall            => 'B -2ab 2',
    schoenflies     => 'C2v^17',
    hermann_mauguin => 'B 2 e b',
    universal_h_m   => 'B 2 e b',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,y+1/2,-z',
        'x,-y,-z',
        'x+1/2,-y+1/2,z',
        'x+1/2,y,z+1/2',
        'x,y+1/2,-z+1/2',
        'x+1/2,-y,-z+1/2',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y+1/2,-z',
        'x,-y,-z',
        'x+1/2,-y+1/2,z',
    ]
},

# Renamed from 'C 2 c b' to 'C 2 e b' as described in the International
# Tables of Crystallography Volume A
{
    number          => 41,
    hall            => 'C -2ac 2',
    schoenflies     => 'C2v^17',
    hermann_mauguin => 'C 2 e b',
    universal_h_m   => 'C 2 e b',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,y,-z+1/2',
        'x,-y,-z',
        'x+1/2,-y,z+1/2',
        'x+1/2,y+1/2,z',
        'x,y+1/2,-z+1/2',
        'x+1/2,-y+1/2,-z',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y,-z+1/2',
        'x,-y,-z',
        'x+1/2,-y,z+1/2',
    ]
},

# Renamed from 'C c 2 a' to 'C c 2 e' as described in the International
# Tables of Crystallography Volume A
{
    number          => 41,
    hall            => 'C -2ac -2ac',
    schoenflies     => 'C2v^17',
    hermann_mauguin => 'C c 2 e',
    universal_h_m   => 'C c 2 e',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,y,-z+1/2',
        '-x+1/2,y,z+1/2',
        '-x,y,-z',
        'x+1/2,y+1/2,z',
        'x,y+1/2,-z+1/2',
        '-x,y+1/2,z+1/2',
        '-x+1/2,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y,-z+1/2',
        '-x+1/2,y,z+1/2',
        '-x,y,-z',
    ]
},

# Renamed from 'A c 2 a' to 'A e 2 a' as described in the International
# Tables of Crystallography Volume A
{
    number          => 41,
    hall            => 'A -2ab -2ab',
    schoenflies     => 'C2v^17',
    hermann_mauguin => 'A e 2 a',
    universal_h_m   => 'A e 2 a',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,y+1/2,-z',
        '-x+1/2,y+1/2,z',
        '-x,y,-z',
        'x,y+1/2,z+1/2',
        'x+1/2,y,-z+1/2',
        '-x+1/2,y,z+1/2',
        '-x,y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y+1/2,-z',
        '-x+1/2,y+1/2,z',
        '-x,y,-z',
    ]
},

{
    number          => 42,
    hall            => 'F 2 -2',
    schoenflies     => 'C2v^18',
    hermann_mauguin => 'F m m 2',
    universal_h_m   => 'F m m 2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        '-x,y,z',
        'x,-y,z',
        'x,y+1/2,z+1/2',
        '-x,-y+1/2,z+1/2',
        '-x,y+1/2,z+1/2',
        'x,-y+1/2,z+1/2',
        'x+1/2,y,z+1/2',
        '-x+1/2,-y,z+1/2',
        '-x+1/2,y,z+1/2',
        'x+1/2,-y,z+1/2',
        'x+1/2,y+1/2,z',
        '-x+1/2,-y+1/2,z',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        '-x,y,z',
        'x,-y,z',
    ]
},

{
    number          => 42,
    hall            => 'F -2 2',
    schoenflies     => 'C2v^18',
    hermann_mauguin => 'F 2 m m',
    universal_h_m   => 'F 2 m m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,y,-z',
        'x,-y,-z',
        'x,-y,z',
        'x,y+1/2,z+1/2',
        'x,y+1/2,-z+1/2',
        'x,-y+1/2,-z+1/2',
        'x,-y+1/2,z+1/2',
        'x+1/2,y,z+1/2',
        'x+1/2,y,-z+1/2',
        'x+1/2,-y,-z+1/2',
        'x+1/2,-y,z+1/2',
        'x+1/2,y+1/2,z',
        'x+1/2,y+1/2,-z',
        'x+1/2,-y+1/2,-z',
        'x+1/2,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        'x,y,-z',
        'x,-y,-z',
        'x,-y,z',
    ]
},

{
    number          => 42,
    hall            => 'F -2 -2',
    schoenflies     => 'C2v^18',
    hermann_mauguin => 'F m 2 m',
    universal_h_m   => 'F m 2 m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,y,-z',
        '-x,y,z',
        '-x,y,-z',
        'x,y+1/2,z+1/2',
        'x,y+1/2,-z+1/2',
        '-x,y+1/2,z+1/2',
        '-x,y+1/2,-z+1/2',
        'x+1/2,y,z+1/2',
        'x+1/2,y,-z+1/2',
        '-x+1/2,y,z+1/2',
        '-x+1/2,y,-z+1/2',
        'x+1/2,y+1/2,z',
        'x+1/2,y+1/2,-z',
        '-x+1/2,y+1/2,z',
        '-x+1/2,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        'x,y,-z',
        '-x,y,z',
        '-x,y,-z',
    ]
},

{
    number          => 43,
    hall            => 'F 2 -2d',
    schoenflies     => 'C2v^19',
    hermann_mauguin => 'F d d 2',
    universal_h_m   => 'F d d 2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        '-x+1/4,y+1/4,z+1/4',
        'x+3/4,-y+3/4,z+1/4',
        'x,y+1/2,z+1/2',
        '-x,-y+1/2,z+1/2',
        '-x+1/4,y+3/4,z+3/4',
        'x+3/4,-y+1/4,z+3/4',
        'x+1/2,y,z+1/2',
        '-x+1/2,-y,z+1/2',
        '-x+3/4,y+1/4,z+3/4',
        'x+1/4,-y+3/4,z+3/4',
        'x+1/2,y+1/2,z',
        '-x+1/2,-y+1/2,z',
        '-x+3/4,y+3/4,z+1/4',
        'x+1/4,-y+1/4,z+1/4',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        '-x+1/4,y+1/4,z+1/4',
        'x+3/4,-y+3/4,z+1/4',
    ]
},

{
    number          => 43,
    hall            => 'F -2d 2',
    schoenflies     => 'C2v^19',
    hermann_mauguin => 'F 2 d d',
    universal_h_m   => 'F 2 d d',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/4,y+1/4,-z+1/4',
        'x,-y,-z',
        'x+1/4,-y+1/4,z+1/4',
        'x,y+1/2,z+1/2',
        'x+1/4,y+3/4,-z+3/4',
        'x,-y+1/2,-z+1/2',
        'x+1/4,-y+3/4,z+3/4',
        'x+1/2,y,z+1/2',
        'x+3/4,y+1/4,-z+3/4',
        'x+1/2,-y,-z+1/2',
        'x+3/4,-y+1/4,z+3/4',
        'x+1/2,y+1/2,z',
        'x+3/4,y+3/4,-z+1/4',
        'x+1/2,-y+1/2,-z',
        'x+3/4,-y+3/4,z+1/4',
    ],
    ncsym => [
        'x,y,z',
        'x+1/4,y+1/4,-z+1/4',
        'x,-y,-z',
        'x+1/4,-y+1/4,z+1/4',
    ]
},

{
    number          => 43,
    hall            => 'F -2d -2d',
    schoenflies     => 'C2v^19',
    hermann_mauguin => 'F d 2 d',
    universal_h_m   => 'F d 2 d',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/4,y+1/4,-z+1/4',
        '-x+1/4,y+1/4,z+1/4',
        '-x+1/2,y+1/2,-z',
        'x,y+1/2,z+1/2',
        'x+1/4,y+3/4,-z+3/4',
        '-x+1/4,y+3/4,z+3/4',
        '-x+1/2,y,-z+1/2',
        'x+1/2,y,z+1/2',
        'x+3/4,y+1/4,-z+3/4',
        '-x+3/4,y+1/4,z+3/4',
        '-x,y+1/2,-z+1/2',
        'x+1/2,y+1/2,z',
        'x+3/4,y+3/4,-z+1/4',
        '-x+3/4,y+3/4,z+1/4',
        '-x,y,-z',
    ],
    ncsym => [
        'x,y,z',
        'x+1/4,y+1/4,-z+1/4',
        '-x+1/4,y+1/4,z+1/4',
        '-x+1/2,y+1/2,-z',
    ]
},

{
    number          => 44,
    hall            => 'I 2 -2',
    schoenflies     => 'C2v^20',
    hermann_mauguin => 'I m m 2',
    universal_h_m   => 'I m m 2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        '-x,y,z',
        'x,-y,z',
        'x+1/2,y+1/2,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        '-x,y,z',
        'x,-y,z',
    ]
},

{
    number          => 44,
    hall            => 'I -2 2',
    schoenflies     => 'C2v^20',
    hermann_mauguin => 'I 2 m m',
    universal_h_m   => 'I 2 m m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,y,-z',
        'x,-y,-z',
        'x,-y,z',
        'x+1/2,y+1/2,z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,y,-z',
        'x,-y,-z',
        'x,-y,z',
    ]
},

{
    number          => 44,
    hall            => 'I -2 -2',
    schoenflies     => 'C2v^20',
    hermann_mauguin => 'I m 2 m',
    universal_h_m   => 'I m 2 m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,y,-z',
        '-x,y,z',
        '-x,y,-z',
        'x+1/2,y+1/2,z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,y,-z',
        '-x,y,z',
        '-x,y,-z',
    ]
},

{
    number          => 45,
    hall            => 'I 2 -2c',
    schoenflies     => 'C2v^21',
    hermann_mauguin => 'I b a 2',
    universal_h_m   => 'I b a 2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        '-x,y,z+1/2',
        'x,-y,z+1/2',
        'x+1/2,y+1/2,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        '-x,y,z+1/2',
        'x,-y,z+1/2',
    ]
},

{
    number          => 45,
    hall            => 'I -2a 2',
    schoenflies     => 'C2v^21',
    hermann_mauguin => 'I 2 c b',
    universal_h_m   => 'I 2 c b',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,y,-z',
        'x,-y,-z',
        'x+1/2,-y,z',
        'x+1/2,y+1/2,z+1/2',
        'x,y+1/2,-z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y,-z',
        'x,-y,-z',
        'x+1/2,-y,z',
    ]
},

{
    number          => 45,
    hall            => 'I -2b -2b',
    schoenflies     => 'C2v^21',
    hermann_mauguin => 'I c 2 a',
    universal_h_m   => 'I c 2 a',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,y+1/2,-z',
        '-x,y+1/2,z',
        '-x,y,-z',
        'x+1/2,y+1/2,z+1/2',
        'x+1/2,y,-z+1/2',
        '-x+1/2,y,z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,y+1/2,-z',
        '-x,y+1/2,z',
        '-x,y,-z',
    ]
},

{
    number          => 46,
    hall            => 'I 2 -2a',
    schoenflies     => 'C2v^22',
    hermann_mauguin => 'I m a 2',
    universal_h_m   => 'I m a 2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        '-x+1/2,y,z',
        'x+1/2,-y,z',
        'x+1/2,y+1/2,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        '-x,y+1/2,z+1/2',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        '-x+1/2,y,z',
        'x+1/2,-y,z',
    ]
},

{
    number          => 46,
    hall            => 'I 2 -2b',
    schoenflies     => 'C2v^22',
    hermann_mauguin => 'I b m 2',
    universal_h_m   => 'I b m 2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        '-x,y+1/2,z',
        'x,-y+1/2,z',
        'x+1/2,y+1/2,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        '-x+1/2,y,z+1/2',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        '-x,y+1/2,z',
        'x,-y+1/2,z',
    ]
},

{
    number          => 46,
    hall            => 'I -2b 2',
    schoenflies     => 'C2v^22',
    hermann_mauguin => 'I 2 m b',
    universal_h_m   => 'I 2 m b',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,y+1/2,-z',
        'x,-y,-z',
        'x,-y+1/2,z',
        'x+1/2,y+1/2,z+1/2',
        'x+1/2,y,-z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,y+1/2,-z',
        'x,-y,-z',
        'x,-y+1/2,z',
    ]
},

{
    number          => 46,
    hall            => 'I -2c 2',
    schoenflies     => 'C2v^22',
    hermann_mauguin => 'I 2 c m',
    universal_h_m   => 'I 2 c m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,y,-z+1/2',
        'x,-y,-z',
        'x,-y,z+1/2',
        'x+1/2,y+1/2,z+1/2',
        'x+1/2,y+1/2,-z',
        'x+1/2,-y+1/2,-z+1/2',
        'x+1/2,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        'x,y,-z+1/2',
        'x,-y,-z',
        'x,-y,z+1/2',
    ]
},

{
    number          => 46,
    hall            => 'I -2c -2c',
    schoenflies     => 'C2v^22',
    hermann_mauguin => 'I c 2 m',
    universal_h_m   => 'I c 2 m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,y,-z+1/2',
        '-x,y,z+1/2',
        '-x,y,-z',
        'x+1/2,y+1/2,z+1/2',
        'x+1/2,y+1/2,-z',
        '-x+1/2,y+1/2,z',
        '-x+1/2,y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,y,-z+1/2',
        '-x,y,z+1/2',
        '-x,y,-z',
    ]
},

{
    number          => 46,
    hall            => 'I -2a -2a',
    schoenflies     => 'C2v^22',
    hermann_mauguin => 'I m 2 a',
    universal_h_m   => 'I m 2 a',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,y,-z',
        '-x+1/2,y,z',
        '-x,y,-z',
        'x+1/2,y+1/2,z+1/2',
        'x,y+1/2,-z+1/2',
        '-x,y+1/2,z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y,-z',
        '-x+1/2,y,z',
        '-x,y,-z',
    ]
},

{
    number          => 47,
    hall            => '-P 2 2',
    schoenflies     => 'D2h^1',
    hermann_mauguin => 'P m m m',
    universal_h_m   => 'P m m m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        '-x,-y,-z',
        'x,y,-z',
        '-x,y,z',
        'x,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        '-x,-y,-z',
        'x,y,-z',
        '-x,y,z',
        'x,-y,z',
    ]
},

{
    number          => 48,
    hall            => 'P 2 2 -1n',
    schoenflies     => 'D2h^2',
    hermann_mauguin => 'P n n n',
    universal_h_m   => 'P n n n :1',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        '-x+1/2,-y+1/2,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        '-x+1/2,-y+1/2,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ]
},

{
    number          => 48,
    hall            => '-P 2ab 2bc',
    schoenflies     => 'D2h^2',
    hermann_mauguin => 'P n n n',
    universal_h_m   => 'P n n n :2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x,-y+1/2,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
        '-x,y+1/2,z+1/2',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x,-y+1/2,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
        '-x,y+1/2,z+1/2',
        'x+1/2,-y,z+1/2',
    ]
},

{
    number          => 49,
    hall            => '-P 2 2c',
    schoenflies     => 'D2h^3',
    hermann_mauguin => 'P c c m',
    universal_h_m   => 'P c c m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z+1/2',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'x,y,-z',
        '-x,y,z+1/2',
        'x,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z+1/2',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'x,y,-z',
        '-x,y,z+1/2',
        'x,-y,z+1/2',
    ]
},

{
    number          => 49,
    hall            => '-P 2a 2',
    schoenflies     => 'D2h^3',
    hermann_mauguin => 'P m a a',
    universal_h_m   => 'P m a a',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x,-y,-z',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x,y,z',
        'x+1/2,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x,-y,-z',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x,y,z',
        'x+1/2,-y,z',
    ]
},

{
    number          => 49,
    hall            => '-P 2b 2b',
    schoenflies     => 'D2h^3',
    hermann_mauguin => 'P b m b',
    universal_h_m   => 'P b m b',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x,-y+1/2,-z',
        '-x,y,-z',
        '-x,-y,-z',
        'x,y+1/2,-z',
        '-x,y+1/2,z',
        'x,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x,-y+1/2,-z',
        '-x,y,-z',
        '-x,-y,-z',
        'x,y+1/2,-z',
        '-x,y+1/2,z',
        'x,-y,z',
    ]
},

{
    number          => 50,
    hall            => 'P 2 2 -1ab',
    schoenflies     => 'D2h^4',
    hermann_mauguin => 'P b a n',
    universal_h_m   => 'P b a n :1',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        '-x+1/2,-y+1/2,-z',
        'x+1/2,y+1/2,-z',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        '-x+1/2,-y+1/2,-z',
        'x+1/2,y+1/2,-z',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y+1/2,z',
    ]
},

{
    number          => 50,
    hall            => '-P 2ab 2b',
    schoenflies     => 'D2h^4',
    hermann_mauguin => 'P b a n',
    universal_h_m   => 'P b a n :2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x,-y+1/2,-z',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
        '-x,y+1/2,z',
        'x+1/2,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x,-y+1/2,-z',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
        '-x,y+1/2,z',
        'x+1/2,-y,z',
    ]
},

{
    number          => 50,
    hall            => 'P 2 2 -1bc',
    schoenflies     => 'D2h^4',
    hermann_mauguin => 'P n c b',
    universal_h_m   => 'P n c b :1',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        '-x,-y+1/2,-z+1/2',
        'x,y+1/2,-z+1/2',
        '-x,y+1/2,z+1/2',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        '-x,-y+1/2,-z+1/2',
        'x,y+1/2,-z+1/2',
        '-x,y+1/2,z+1/2',
        'x,-y+1/2,z+1/2',
    ]
},

{
    number          => 50,
    hall            => '-P 2b 2bc',
    schoenflies     => 'D2h^4',
    hermann_mauguin => 'P n c b',
    universal_h_m   => 'P n c b :2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x,-y+1/2,-z+1/2',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'x,y+1/2,-z',
        '-x,y+1/2,z+1/2',
        'x,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x,-y+1/2,-z+1/2',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'x,y+1/2,-z',
        '-x,y+1/2,z+1/2',
        'x,-y,z+1/2',
    ]
},

{
    number          => 50,
    hall            => 'P 2 2 -1ac',
    schoenflies     => 'D2h^4',
    hermann_mauguin => 'P c n a',
    universal_h_m   => 'P c n a :1',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        '-x+1/2,-y,-z+1/2',
        'x+1/2,y,-z+1/2',
        '-x+1/2,y,z+1/2',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        '-x+1/2,-y,-z+1/2',
        'x+1/2,y,-z+1/2',
        '-x+1/2,y,z+1/2',
        'x+1/2,-y,z+1/2',
    ]
},

{
    number          => 50,
    hall            => '-P 2a 2c',
    schoenflies     => 'D2h^4',
    hermann_mauguin => 'P c n a',
    universal_h_m   => 'P c n a :2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x,-y,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x,y,z+1/2',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x,-y,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x,y,z+1/2',
        'x+1/2,-y,z+1/2',
    ]
},

{
    number          => 51,
    hall            => '-P 2a 2a',
    schoenflies     => 'D2h^5',
    hermann_mauguin => 'P m m a',
    universal_h_m   => 'P m m a',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x+1/2,-y,-z',
        '-x,y,-z',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x+1/2,y,z',
        'x,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x+1/2,-y,-z',
        '-x,y,-z',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x+1/2,y,z',
        'x,-y,z',
    ]
},

{
    number          => 51,
    hall            => '-P 2b 2',
    schoenflies     => 'D2h^5',
    hermann_mauguin => 'P m m b',
    universal_h_m   => 'P m m b',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x,-y,-z',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'x,y+1/2,-z',
        '-x,y,z',
        'x,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x,-y,-z',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'x,y+1/2,-z',
        '-x,y,z',
        'x,-y+1/2,z',
    ]
},

{
    number          => 51,
    hall            => '-P 2 2b',
    schoenflies     => 'D2h^5',
    hermann_mauguin => 'P b m m',
    universal_h_m   => 'P b m m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x,-y+1/2,-z',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'x,y,-z',
        '-x,y+1/2,z',
        'x,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y+1/2,-z',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'x,y,-z',
        '-x,y+1/2,z',
        'x,-y+1/2,z',
    ]
},

{
    number          => 51,
    hall            => '-P 2c 2c',
    schoenflies     => 'D2h^5',
    hermann_mauguin => 'P c m m',
    universal_h_m   => 'P c m m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z+1/2',
        'x,-y,-z+1/2',
        '-x,y,-z',
        '-x,-y,-z',
        'x,y,-z+1/2',
        '-x,y,z+1/2',
        'x,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
        'x,-y,-z+1/2',
        '-x,y,-z',
        '-x,-y,-z',
        'x,y,-z+1/2',
        '-x,y,z+1/2',
        'x,-y,z',
    ]
},

{
    number          => 51,
    hall            => '-P 2c 2',
    schoenflies     => 'D2h^5',
    hermann_mauguin => 'P m c m',
    universal_h_m   => 'P m c m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z+1/2',
        'x,-y,-z',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'x,y,-z+1/2',
        '-x,y,z',
        'x,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
        'x,-y,-z',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'x,y,-z+1/2',
        '-x,y,z',
        'x,-y,z+1/2',
    ]
},

{
    number          => 51,
    hall            => '-P 2 2a',
    schoenflies     => 'D2h^5',
    hermann_mauguin => 'P m a m',
    universal_h_m   => 'P m a m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x+1/2,-y,-z',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x,y,-z',
        '-x+1/2,y,z',
        'x+1/2,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x+1/2,-y,-z',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x,y,-z',
        '-x+1/2,y,z',
        'x+1/2,-y,z',
    ]
},

{
    number          => 52,
    hall            => '-P 2a 2bc',
    schoenflies     => 'D2h^6',
    hermann_mauguin => 'P n n a',
    universal_h_m   => 'P n n a',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x,-y+1/2,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x,-y+1/2,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ]
},

{
    number          => 52,
    hall            => '-P 2b 2n',
    schoenflies     => 'D2h^6',
    hermann_mauguin => 'P n n b',
    universal_h_m   => 'P n n b',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x+1/2,-y+1/2,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-x,-y,-z',
        'x,y+1/2,-z',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x+1/2,-y+1/2,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-x,-y,-z',
        'x,y+1/2,-z',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,-y,z+1/2',
    ]
},

{
    number          => 52,
    hall            => '-P 2n 2b',
    schoenflies     => 'D2h^6',
    hermann_mauguin => 'P b n n',
    universal_h_m   => 'P b n n',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z+1/2',
        'x,-y+1/2,-z',
        '-x+1/2,y,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-x,y+1/2,z',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y+1/2,z+1/2',
        'x,-y+1/2,-z',
        '-x+1/2,y,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-x,y+1/2,z',
        'x+1/2,-y,z+1/2',
    ]
},

{
    number          => 52,
    hall            => '-P 2ab 2c',
    schoenflies     => 'D2h^6',
    hermann_mauguin => 'P c n n',
    universal_h_m   => 'P c n n',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x,-y,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
        '-x,y,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x,-y,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
        '-x,y,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ]
},

{
    number          => 52,
    hall            => '-P 2ab 2n',
    schoenflies     => 'D2h^6',
    hermann_mauguin => 'P n c n',
    universal_h_m   => 'P n c n',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x+1/2,-y+1/2,-z+1/2',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
        '-x+1/2,y+1/2,z+1/2',
        'x,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x+1/2,-y+1/2,-z+1/2',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
        '-x+1/2,y+1/2,z+1/2',
        'x,-y,z+1/2',
    ]
},

{
    number          => 52,
    hall            => '-P 2n 2bc',
    schoenflies     => 'D2h^6',
    hermann_mauguin => 'P n a n',
    universal_h_m   => 'P n a n',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z+1/2',
        'x,-y+1/2,-z+1/2',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-x,y+1/2,z+1/2',
        'x+1/2,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y+1/2,z+1/2',
        'x,-y+1/2,-z+1/2',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-x,y+1/2,z+1/2',
        'x+1/2,-y,z',
    ]
},

{
    number          => 53,
    hall            => '-P 2ac 2',
    schoenflies     => 'D2h^7',
    hermann_mauguin => 'P m n a',
    universal_h_m   => 'P m n a',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        'x,-y,-z',
        '-x+1/2,y,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y,-z+1/2',
        '-x,y,z',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        'x,-y,-z',
        '-x+1/2,y,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y,-z+1/2',
        '-x,y,z',
        'x+1/2,-y,z+1/2',
    ]
},

{
    number          => 53,
    hall            => '-P 2bc 2bc',
    schoenflies     => 'D2h^7',
    hermann_mauguin => 'P n m b',
    universal_h_m   => 'P n m b',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z+1/2',
        'x,-y+1/2,-z+1/2',
        '-x,y,-z',
        '-x,-y,-z',
        'x,y+1/2,-z+1/2',
        '-x,y+1/2,z+1/2',
        'x,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z+1/2',
        'x,-y+1/2,-z+1/2',
        '-x,y,-z',
        '-x,-y,-z',
        'x,y+1/2,-z+1/2',
        '-x,y+1/2,z+1/2',
        'x,-y,z',
    ]
},

{
    number          => 53,
    hall            => '-P 2ab 2ab',
    schoenflies     => 'D2h^7',
    hermann_mauguin => 'P b m n',
    universal_h_m   => 'P b m n',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x+1/2,-y+1/2,-z',
        '-x,y,-z',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
        '-x+1/2,y+1/2,z',
        'x,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x+1/2,-y+1/2,-z',
        '-x,y,-z',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
        '-x+1/2,y+1/2,z',
        'x,-y,z',
    ]
},

{
    number          => 53,
    hall            => '-P 2 2ac',
    schoenflies     => 'D2h^7',
    hermann_mauguin => 'P c n m',
    universal_h_m   => 'P c n m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x+1/2,-y,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-x,-y,-z',
        'x,y,-z',
        '-x+1/2,y,z+1/2',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x+1/2,-y,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-x,-y,-z',
        'x,y,-z',
        '-x+1/2,y,z+1/2',
        'x+1/2,-y,z+1/2',
    ]
},

{
    number          => 53,
    hall            => '-P 2 2bc',
    schoenflies     => 'D2h^7',
    hermann_mauguin => 'P n c m',
    universal_h_m   => 'P n c m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x,-y+1/2,-z+1/2',
        '-x,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x,y,-z',
        '-x,y+1/2,z+1/2',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y+1/2,-z+1/2',
        '-x,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x,y,-z',
        '-x,y+1/2,z+1/2',
        'x,-y+1/2,z+1/2',
    ]
},

{
    number          => 53,
    hall            => '-P 2ab 2',
    schoenflies     => 'D2h^7',
    hermann_mauguin => 'P m a n',
    universal_h_m   => 'P m a n',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x,-y,-z',
        '-x+1/2,y+1/2,-z',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
        '-x,y,z',
        'x+1/2,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x,-y,-z',
        '-x+1/2,y+1/2,-z',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
        '-x,y,z',
        'x+1/2,-y+1/2,z',
    ]
},

{
    number          => 54,
    hall            => '-P 2a 2ac',
    schoenflies     => 'D2h^8',
    hermann_mauguin => 'P c c a',
    universal_h_m   => 'P c c a',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x+1/2,-y,-z+1/2',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x+1/2,y,z+1/2',
        'x,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x+1/2,-y,-z+1/2',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x+1/2,y,z+1/2',
        'x,-y,z+1/2',
    ]
},

{
    number          => 54,
    hall            => '-P 2b 2c',
    schoenflies     => 'D2h^8',
    hermann_mauguin => 'P c c b',
    universal_h_m   => 'P c c b',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x,-y,-z+1/2',
        '-x,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x,y+1/2,-z',
        '-x,y,z+1/2',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x,-y,-z+1/2',
        '-x,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x,y+1/2,-z',
        '-x,y,z+1/2',
        'x,-y+1/2,z+1/2',
    ]
},

{
    number          => 54,
    hall            => '-P 2a 2b',
    schoenflies     => 'D2h^8',
    hermann_mauguin => 'P b a a',
    universal_h_m   => 'P b a a',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x,-y+1/2,-z',
        '-x+1/2,y+1/2,-z',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x,y+1/2,z',
        'x+1/2,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x,-y+1/2,-z',
        '-x+1/2,y+1/2,-z',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x,y+1/2,z',
        'x+1/2,-y+1/2,z',
    ]
},

{
    number          => 54,
    hall            => '-P 2ac 2c',
    schoenflies     => 'D2h^8',
    hermann_mauguin => 'P c a a',
    universal_h_m   => 'P c a a',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        'x,-y,-z+1/2',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x+1/2,y,-z+1/2',
        '-x,y,z+1/2',
        'x+1/2,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        'x,-y,-z+1/2',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x+1/2,y,-z+1/2',
        '-x,y,z+1/2',
        'x+1/2,-y,z',
    ]
},

{
    number          => 54,
    hall            => '-P 2bc 2b',
    schoenflies     => 'D2h^8',
    hermann_mauguin => 'P b c b',
    universal_h_m   => 'P b c b',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z+1/2',
        'x,-y+1/2,-z',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'x,y+1/2,-z+1/2',
        '-x,y+1/2,z',
        'x,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z+1/2',
        'x,-y+1/2,-z',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'x,y+1/2,-z+1/2',
        '-x,y+1/2,z',
        'x,-y,z+1/2',
    ]
},

{
    number          => 54,
    hall            => '-P 2b 2ab',
    schoenflies     => 'D2h^8',
    hermann_mauguin => 'P b a b',
    universal_h_m   => 'P b a b',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x,y+1/2,-z',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x,y+1/2,-z',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y,z',
    ]
},

{
    number          => 55,
    hall            => '-P 2 2ab',
    schoenflies     => 'D2h^9',
    hermann_mauguin => 'P b a m',
    universal_h_m   => 'P b a m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,y+1/2,-z',
        '-x,-y,-z',
        'x,y,-z',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,y+1/2,-z',
        '-x,-y,-z',
        'x,y,-z',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y+1/2,z',
    ]
},

{
    number          => 55,
    hall            => '-P 2bc 2',
    schoenflies     => 'D2h^9',
    hermann_mauguin => 'P m c b',
    universal_h_m   => 'P m c b',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z+1/2',
        'x,-y,-z',
        '-x,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x,y+1/2,-z+1/2',
        '-x,y,z',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z+1/2',
        'x,-y,-z',
        '-x,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x,y+1/2,-z+1/2',
        '-x,y,z',
        'x,-y+1/2,z+1/2',
    ]
},

{
    number          => 55,
    hall            => '-P 2ac 2ac',
    schoenflies     => 'D2h^9',
    hermann_mauguin => 'P c m a',
    universal_h_m   => 'P c m a',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x,y,-z',
        '-x,-y,-z',
        'x+1/2,y,-z+1/2',
        '-x+1/2,y,z+1/2',
        'x,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x,y,-z',
        '-x,-y,-z',
        'x+1/2,y,-z+1/2',
        '-x+1/2,y,z+1/2',
        'x,-y,z',
    ]
},

{
    number          => 56,
    hall            => '-P 2ab 2ac',
    schoenflies     => 'D2h^10',
    hermann_mauguin => 'P c c n',
    universal_h_m   => 'P c c n',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x+1/2,-y,-z+1/2',
        '-x,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
        '-x+1/2,y,z+1/2',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x+1/2,-y,-z+1/2',
        '-x,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
        '-x+1/2,y,z+1/2',
        'x,-y+1/2,z+1/2',
    ]
},

{
    number          => 56,
    hall            => '-P 2ac 2bc',
    schoenflies     => 'D2h^10',
    hermann_mauguin => 'P n a a',
    universal_h_m   => 'P n a a',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        'x,-y+1/2,-z+1/2',
        '-x+1/2,y+1/2,-z',
        '-x,-y,-z',
        'x+1/2,y,-z+1/2',
        '-x,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        'x,-y+1/2,-z+1/2',
        '-x+1/2,y+1/2,-z',
        '-x,-y,-z',
        'x+1/2,y,-z+1/2',
        '-x,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z',
    ]
},

{
    number          => 56,
    hall            => '-P 2bc 2ab',
    schoenflies     => 'D2h^10',
    hermann_mauguin => 'P b n b',
    universal_h_m   => 'P b n b',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z+1/2',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,y,-z+1/2',
        '-x,-y,-z',
        'x,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z+1/2',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,y,-z+1/2',
        '-x,-y,-z',
        'x,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y,z+1/2',
    ]
},

{
    number          => 57,
    hall            => '-P 2c 2b',
    schoenflies     => 'D2h^11',
    hermann_mauguin => 'P b c m',
    universal_h_m   => 'P b c m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z+1/2',
        'x,-y+1/2,-z',
        '-x,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x,y,-z+1/2',
        '-x,y+1/2,z',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
        'x,-y+1/2,-z',
        '-x,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x,y,-z+1/2',
        '-x,y+1/2,z',
        'x,-y+1/2,z+1/2',
    ]
},

{
    number          => 57,
    hall            => '-P 2c 2ac',
    schoenflies     => 'D2h^11',
    hermann_mauguin => 'P c a m',
    universal_h_m   => 'P c a m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x,y,-z+1/2',
        '-x+1/2,y,z+1/2',
        'x+1/2,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x,y,-z+1/2',
        '-x+1/2,y,z+1/2',
        'x+1/2,-y,z',
    ]
},

{
    number          => 57,
    hall            => '-P 2ac 2a',
    schoenflies     => 'D2h^11',
    hermann_mauguin => 'P m c a',
    universal_h_m   => 'P m c a',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y,-z',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y,-z+1/2',
        '-x+1/2,y,z',
        'x,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y,-z',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y,-z+1/2',
        '-x+1/2,y,z',
        'x,-y,z+1/2',
    ]
},

{
    number          => 57,
    hall            => '-P 2b 2a',
    schoenflies     => 'D2h^11',
    hermann_mauguin => 'P m a b',
    universal_h_m   => 'P m a b',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x+1/2,-y,-z',
        '-x+1/2,y+1/2,-z',
        '-x,-y,-z',
        'x,y+1/2,-z',
        '-x+1/2,y,z',
        'x+1/2,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x+1/2,-y,-z',
        '-x+1/2,y+1/2,-z',
        '-x,-y,-z',
        'x,y+1/2,-z',
        '-x+1/2,y,z',
        'x+1/2,-y+1/2,z',
    ]
},

{
    number          => 57,
    hall            => '-P 2a 2ab',
    schoenflies     => 'D2h^11',
    hermann_mauguin => 'P b m a',
    universal_h_m   => 'P b m a',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x+1/2,-y+1/2,-z',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x+1/2,y+1/2,z',
        'x,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x+1/2,-y+1/2,-z',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x+1/2,y+1/2,z',
        'x,-y+1/2,z',
    ]
},

{
    number          => 57,
    hall            => '-P 2bc 2c',
    schoenflies     => 'D2h^11',
    hermann_mauguin => 'P c m b',
    universal_h_m   => 'P c m b',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z+1/2',
        'x,-y,-z+1/2',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'x,y+1/2,-z+1/2',
        '-x,y,z+1/2',
        'x,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z+1/2',
        'x,-y,-z+1/2',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'x,y+1/2,-z+1/2',
        '-x,y,z+1/2',
        'x,-y+1/2,z',
    ]
},

{
    number          => 58,
    hall            => '-P 2 2n',
    schoenflies     => 'D2h^12',
    hermann_mauguin => 'P n n m',
    universal_h_m   => 'P n n m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x+1/2,-y+1/2,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x,y,-z',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x+1/2,-y+1/2,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x,y,-z',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ]
},

{
    number          => 58,
    hall            => '-P 2n 2',
    schoenflies     => 'D2h^12',
    hermann_mauguin => 'P m n n',
    universal_h_m   => 'P m n n',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z+1/2',
        'x,-y,-z',
        '-x+1/2,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-x,y,z',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y+1/2,z+1/2',
        'x,-y,-z',
        '-x+1/2,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-x,y,z',
        'x+1/2,-y+1/2,z+1/2',
    ]
},

{
    number          => 58,
    hall            => '-P 2n 2n',
    schoenflies     => 'D2h^12',
    hermann_mauguin => 'P n m n',
    universal_h_m   => 'P n m n',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        '-x,y,-z',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y+1/2,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        '-x,y,-z',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x,-y,z',
    ]
},

{
    number          => 59,
    hall            => 'P 2 2ab -1ab',
    schoenflies     => 'D2h^13',
    hermann_mauguin => 'P m m n',
    universal_h_m   => 'P m m n :1',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,y+1/2,-z',
        '-x+1/2,-y+1/2,-z',
        'x+1/2,y+1/2,-z',
        '-x,y,z',
        'x,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,y+1/2,-z',
        '-x+1/2,-y+1/2,-z',
        'x+1/2,y+1/2,-z',
        '-x,y,z',
        'x,-y,z',
    ]
},

{
    number          => 59,
    hall            => '-P 2ab 2a',
    schoenflies     => 'D2h^13',
    hermann_mauguin => 'P m m n',
    universal_h_m   => 'P m m n :2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x+1/2,-y,-z',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
        '-x+1/2,y,z',
        'x,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x+1/2,-y,-z',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
        '-x+1/2,y,z',
        'x,-y+1/2,z',
    ]
},

{
    number          => 59,
    hall            => 'P 2bc 2 -1bc',
    schoenflies     => 'D2h^13',
    hermann_mauguin => 'P n m m',
    universal_h_m   => 'P n m m :1',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z+1/2',
        'x,-y,-z',
        '-x,y+1/2,-z+1/2',
        '-x,-y+1/2,-z+1/2',
        'x,y,-z',
        '-x,y+1/2,z+1/2',
        'x,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z+1/2',
        'x,-y,-z',
        '-x,y+1/2,-z+1/2',
        '-x,-y+1/2,-z+1/2',
        'x,y,-z',
        '-x,y+1/2,z+1/2',
        'x,-y,z',
    ]
},

{
    number          => 59,
    hall            => '-P 2c 2bc',
    schoenflies     => 'D2h^13',
    hermann_mauguin => 'P n m m',
    universal_h_m   => 'P n m m :2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z+1/2',
        'x,-y+1/2,-z+1/2',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'x,y,-z+1/2',
        '-x,y+1/2,z+1/2',
        'x,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
        'x,-y+1/2,-z+1/2',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'x,y,-z+1/2',
        '-x,y+1/2,z+1/2',
        'x,-y+1/2,z',
    ]
},

{
    number          => 59,
    hall            => 'P 2ac 2ac -1ac',
    schoenflies     => 'D2h^13',
    hermann_mauguin => 'P m n m',
    universal_h_m   => 'P m n m :1',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x,y,-z',
        '-x+1/2,-y,-z+1/2',
        'x,y,-z',
        '-x,y,z',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x,y,-z',
        '-x+1/2,-y,-z+1/2',
        'x,y,-z',
        '-x,y,z',
        'x+1/2,-y,z+1/2',
    ]
},

{
    number          => 59,
    hall            => '-P 2c 2a',
    schoenflies     => 'D2h^13',
    hermann_mauguin => 'P m n m',
    universal_h_m   => 'P m n m :2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z+1/2',
        'x+1/2,-y,-z',
        '-x+1/2,y,-z+1/2',
        '-x,-y,-z',
        'x,y,-z+1/2',
        '-x+1/2,y,z',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
        'x+1/2,-y,-z',
        '-x+1/2,y,-z+1/2',
        '-x,-y,-z',
        'x,y,-z+1/2',
        '-x+1/2,y,z',
        'x+1/2,-y,z+1/2',
    ]
},

{
    number          => 60,
    hall            => '-P 2n 2ab',
    schoenflies     => 'D2h^14',
    hermann_mauguin => 'P b c n',
    universal_h_m   => 'P b c n',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z+1/2',
        'x+1/2,-y+1/2,-z',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z',
        'x,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y+1/2,z+1/2',
        'x+1/2,-y+1/2,-z',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z',
        'x,-y,z+1/2',
    ]
},

{
    number          => 60,
    hall            => '-P 2n 2c',
    schoenflies     => 'D2h^14',
    hermann_mauguin => 'P c a n',
    universal_h_m   => 'P c a n',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z+1/2',
        'x,-y,-z+1/2',
        '-x+1/2,y+1/2,-z',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-x,y,z+1/2',
        'x+1/2,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y+1/2,z+1/2',
        'x,-y,-z+1/2',
        '-x+1/2,y+1/2,-z',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-x,y,z+1/2',
        'x+1/2,-y+1/2,z',
    ]
},

{
    number          => 60,
    hall            => '-P 2a 2n',
    schoenflies     => 'D2h^14',
    hermann_mauguin => 'P n c a',
    universal_h_m   => 'P n c a',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x+1/2,-y+1/2,-z+1/2',
        '-x,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x+1/2,y+1/2,z+1/2',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x+1/2,-y+1/2,-z+1/2',
        '-x,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x+1/2,y+1/2,z+1/2',
        'x,-y+1/2,z+1/2',
    ]
},

{
    number          => 60,
    hall            => '-P 2bc 2n',
    schoenflies     => 'D2h^14',
    hermann_mauguin => 'P n a b',
    universal_h_m   => 'P n a b',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,-y,z',
    ]
},

{
    number          => 60,
    hall            => '-P 2ac 2b',
    schoenflies     => 'D2h^14',
    hermann_mauguin => 'P b n a',
    universal_h_m   => 'P b n a',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        'x,-y+1/2,-z',
        '-x+1/2,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y,-z+1/2',
        '-x,y+1/2,z',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        'x,-y+1/2,-z',
        '-x+1/2,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y,-z+1/2',
        '-x,y+1/2,z',
        'x+1/2,-y+1/2,z+1/2',
    ]
},

{
    number          => 60,
    hall            => '-P 2b 2ac',
    schoenflies     => 'D2h^14',
    hermann_mauguin => 'P c n b',
    universal_h_m   => 'P c n b',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x+1/2,-y,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x,y+1/2,-z',
        '-x+1/2,y,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x+1/2,-y,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x,y+1/2,-z',
        '-x+1/2,y,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ]
},

{
    number          => 61,
    hall            => '-P 2ac 2ab',
    schoenflies     => 'D2h^15',
    hermann_mauguin => 'P b c a',
    universal_h_m   => 'P b c a',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y+1/2,-z',
        '-x,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y,-z+1/2',
        '-x+1/2,y+1/2,z',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y+1/2,-z',
        '-x,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y,-z+1/2',
        '-x+1/2,y+1/2,z',
        'x,-y+1/2,z+1/2',
    ]
},

{
    number          => 61,
    hall            => '-P 2bc 2ac',
    schoenflies     => 'D2h^15',
    hermann_mauguin => 'P c a b',
    universal_h_m   => 'P c a b',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x+1/2,y+1/2,-z',
        '-x,-y,-z',
        'x,y+1/2,-z+1/2',
        '-x+1/2,y,z+1/2',
        'x+1/2,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x+1/2,y+1/2,-z',
        '-x,-y,-z',
        'x,y+1/2,-z+1/2',
        '-x+1/2,y,z+1/2',
        'x+1/2,-y+1/2,z',
    ]
},

{
    number          => 62,
    hall            => '-P 2ac 2n',
    schoenflies     => 'D2h^16',
    hermann_mauguin => 'P n m a',
    universal_h_m   => 'P n m a',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'x+1/2,y,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'x+1/2,y,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x,-y+1/2,z',
    ]
},

{
    number          => 62,
    hall            => '-P 2bc 2a',
    schoenflies     => 'D2h^16',
    hermann_mauguin => 'P m n b',
    universal_h_m   => 'P m n b',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z+1/2',
        'x+1/2,-y,-z',
        '-x+1/2,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x,y+1/2,-z+1/2',
        '-x+1/2,y,z',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z+1/2',
        'x+1/2,-y,-z',
        '-x+1/2,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x,y+1/2,-z+1/2',
        '-x+1/2,y,z',
        'x+1/2,-y+1/2,z+1/2',
    ]
},

{
    number          => 62,
    hall            => '-P 2c 2ab',
    schoenflies     => 'D2h^16',
    hermann_mauguin => 'P b n m',
    universal_h_m   => 'P b n m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z+1/2',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x,y,-z+1/2',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x,y,-z+1/2',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y+1/2,z+1/2',
    ]
},

{
    number          => 62,
    hall            => '-P 2n 2ac',
    schoenflies     => 'D2h^16',
    hermann_mauguin => 'P c m n',
    universal_h_m   => 'P c m n',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-x+1/2,y,z+1/2',
        'x,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y+1/2,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-x+1/2,y,z+1/2',
        'x,-y+1/2,z',
    ]
},

{
    number          => 62,
    hall            => '-P 2n 2a',
    schoenflies     => 'D2h^16',
    hermann_mauguin => 'P m c n',
    universal_h_m   => 'P m c n',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z+1/2',
        'x+1/2,-y,-z',
        '-x,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-x+1/2,y,z',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y+1/2,z+1/2',
        'x+1/2,-y,-z',
        '-x,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-x+1/2,y,z',
        'x,-y+1/2,z+1/2',
    ]
},

{
    number          => 62,
    hall            => '-P 2c 2n',
    schoenflies     => 'D2h^16',
    hermann_mauguin => 'P n a m',
    universal_h_m   => 'P n a m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        '-x+1/2,y+1/2,-z',
        '-x,-y,-z',
        'x,y,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        '-x+1/2,y+1/2,-z',
        '-x,-y,-z',
        'x,y,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z',
    ]
},

{
    number          => 63,
    hall            => '-C 2c 2',
    schoenflies     => 'D2h^17',
    hermann_mauguin => 'C m c m',
    universal_h_m   => 'C m c m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z+1/2',
        'x,-y,-z',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'x,y,-z+1/2',
        '-x,y,z',
        'x,-y,z+1/2',
        'x+1/2,y+1/2,z',
        '-x+1/2,-y+1/2,z+1/2',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,y+1/2,-z+1/2',
        '-x+1/2,-y+1/2,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
        'x,-y,-z',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'x,y,-z+1/2',
        '-x,y,z',
        'x,-y,z+1/2',
    ]
},

{
    number          => 63,
    hall            => '-C 2c 2c',
    schoenflies     => 'D2h^17',
    hermann_mauguin => 'C c m m',
    universal_h_m   => 'C c m m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z+1/2',
        'x,-y,-z+1/2',
        '-x,y,-z',
        '-x,-y,-z',
        'x,y,-z+1/2',
        '-x,y,z+1/2',
        'x,-y,z',
        'x+1/2,y+1/2,z',
        '-x+1/2,-y+1/2,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        '-x+1/2,y+1/2,-z',
        '-x+1/2,-y+1/2,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
        'x,-y,-z+1/2',
        '-x,y,-z',
        '-x,-y,-z',
        'x,y,-z+1/2',
        '-x,y,z+1/2',
        'x,-y,z',
    ]
},

{
    number          => 63,
    hall            => '-A 2a 2a',
    schoenflies     => 'D2h^17',
    hermann_mauguin => 'A m m a',
    universal_h_m   => 'A m m a',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x+1/2,-y,-z',
        '-x,y,-z',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x+1/2,y,z',
        'x,-y,z',
        'x,y+1/2,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        '-x,y+1/2,-z+1/2',
        '-x,-y+1/2,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x+1/2,-y,-z',
        '-x,y,-z',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x+1/2,y,z',
        'x,-y,z',
    ]
},

{
    number          => 63,
    hall            => '-A 2 2a',
    schoenflies     => 'D2h^17',
    hermann_mauguin => 'A m a m',
    universal_h_m   => 'A m a m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x+1/2,-y,-z',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x,y,-z',
        '-x+1/2,y,z',
        'x+1/2,-y,z',
        'x,y+1/2,z+1/2',
        '-x,-y+1/2,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-x,-y+1/2,-z+1/2',
        'x,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x+1/2,-y,-z',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x,y,-z',
        '-x+1/2,y,z',
        'x+1/2,-y,z',
    ]
},

{
    number          => 63,
    hall            => '-B 2 2b',
    schoenflies     => 'D2h^17',
    hermann_mauguin => 'B b m m',
    universal_h_m   => 'B b m m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x,-y+1/2,-z',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'x,y,-z',
        '-x,y+1/2,z',
        'x,-y+1/2,z',
        'x+1/2,y,z+1/2',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-x+1/2,-y,-z+1/2',
        'x+1/2,y,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y+1/2,-z',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'x,y,-z',
        '-x,y+1/2,z',
        'x,-y+1/2,z',
    ]
},

{
    number          => 63,
    hall            => '-B 2b 2',
    schoenflies     => 'D2h^17',
    hermann_mauguin => 'B m m b',
    universal_h_m   => 'B m m b',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x,-y,-z',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'x,y+1/2,-z',
        '-x,y,z',
        'x,-y+1/2,z',
        'x+1/2,y,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-x+1/2,-y,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-x+1/2,y,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x,-y,-z',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'x,y+1/2,-z',
        '-x,y,z',
        'x,-y+1/2,z',
    ]
},

# Renamed from 'C m c a' to 'C m c e' as described in the International
# Tables of Crystallography Volume A
{
    number          => 64,
    hall            => '-C 2ac 2',
    schoenflies     => 'D2h^18',
    hermann_mauguin => 'C m c e',
    universal_h_m   => 'C m c e',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        'x,-y,-z',
        '-x+1/2,y,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y,-z+1/2',
        '-x,y,z',
        'x+1/2,-y,z+1/2',
        'x+1/2,y+1/2,z',
        '-x,-y+1/2,z+1/2',
        'x+1/2,-y+1/2,-z',
        '-x,y+1/2,-z+1/2',
        '-x+1/2,-y+1/2,-z',
        'x,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        'x,-y,-z',
        '-x+1/2,y,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y,-z+1/2',
        '-x,y,z',
        'x+1/2,-y,z+1/2',
    ]
},

# Renamed from 'C c m b' to 'C c m e' as described in the International
# Tables of Crystallography Volume A
{
    number          => 64,
    hall            => '-C 2ac 2ac',
    schoenflies     => 'D2h^18',
    hermann_mauguin => 'C c m e',
    universal_h_m   => 'C c m e',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x,y,-z',
        '-x,-y,-z',
        'x+1/2,y,-z+1/2',
        '-x+1/2,y,z+1/2',
        'x,-y,z',
        'x+1/2,y+1/2,z',
        '-x,-y+1/2,z+1/2',
        'x,-y+1/2,-z+1/2',
        '-x+1/2,y+1/2,-z',
        '-x+1/2,-y+1/2,-z',
        'x,y+1/2,-z+1/2',
        '-x,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x,y,-z',
        '-x,-y,-z',
        'x+1/2,y,-z+1/2',
        '-x+1/2,y,z+1/2',
        'x,-y,z',
    ]
},

# Renamed from 'A b m a' to 'A e m a' as described in the International
# Tables of Crystallography Volume A
{
    number          => 64,
    hall            => '-A 2ab 2ab',
    schoenflies     => 'D2h^18',
    hermann_mauguin => 'A e m a',
    universal_h_m   => 'A e m a',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x+1/2,-y+1/2,-z',
        '-x,y,-z',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
        '-x+1/2,y+1/2,z',
        'x,-y,z',
        'x,y+1/2,z+1/2',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x,y+1/2,-z+1/2',
        '-x,-y+1/2,-z+1/2',
        'x+1/2,y,-z+1/2',
        '-x+1/2,y,z+1/2',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x+1/2,-y+1/2,-z',
        '-x,y,-z',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
        '-x+1/2,y+1/2,z',
        'x,-y,z',
    ]
},

# Renamed from 'A c a m' to 'A e a m' as described in the International
# Tables of Crystallography Volume A
{
    number          => 64,
    hall            => '-A 2 2ab',
    schoenflies     => 'D2h^18',
    hermann_mauguin => 'A e a m',
    universal_h_m   => 'A e a m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,y+1/2,-z',
        '-x,-y,-z',
        'x,y,-z',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y+1/2,z',
        'x,y+1/2,z+1/2',
        '-x,-y+1/2,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-x,-y+1/2,-z+1/2',
        'x,y+1/2,-z+1/2',
        '-x+1/2,y,z+1/2',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,y+1/2,-z',
        '-x,-y,-z',
        'x,y,-z',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y+1/2,z',
    ]
},

# Renamed from 'B b c m' to 'B b e m' as described in the International
# Tables of Crystallography Volume A
{
    number          => 64,
    hall            => '-B 2 2ab',
    schoenflies     => 'D2h^18',
    hermann_mauguin => 'B b e m',
    universal_h_m   => 'B b e m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,y+1/2,-z',
        '-x,-y,-z',
        'x,y,-z',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y+1/2,z',
        'x+1/2,y,z+1/2',
        '-x+1/2,-y,z+1/2',
        'x,-y+1/2,-z+1/2',
        '-x,y+1/2,-z+1/2',
        '-x+1/2,-y,-z+1/2',
        'x+1/2,y,-z+1/2',
        '-x,y+1/2,z+1/2',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,y+1/2,-z',
        '-x,-y,-z',
        'x,y,-z',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y+1/2,z',
    ]
},

# Renamed from 'B m a b' to 'B m e b' as described in the International
# Tables of Crystallography Volume A
{
    number          => 64,
    hall            => '-B 2ab 2',
    schoenflies     => 'D2h^18',
    hermann_mauguin => 'B m e b',
    universal_h_m   => 'B m e b',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x,-y,-z',
        '-x+1/2,y+1/2,-z',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
        '-x,y,z',
        'x+1/2,-y+1/2,z',
        'x+1/2,y,z+1/2',
        '-x,-y+1/2,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x,y+1/2,-z+1/2',
        '-x+1/2,-y,-z+1/2',
        'x,y+1/2,-z+1/2',
        '-x+1/2,y,z+1/2',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x,-y,-z',
        '-x+1/2,y+1/2,-z',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
        '-x,y,z',
        'x+1/2,-y+1/2,z',
    ]
},

{
    number          => 65,
    hall            => '-C 2 2',
    schoenflies     => 'D2h^19',
    hermann_mauguin => 'C m m m',
    universal_h_m   => 'C m m m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        '-x,-y,-z',
        'x,y,-z',
        '-x,y,z',
        'x,-y,z',
        'x+1/2,y+1/2,z',
        '-x+1/2,-y+1/2,z',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,y+1/2,-z',
        '-x+1/2,-y+1/2,-z',
        'x+1/2,y+1/2,-z',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        '-x,-y,-z',
        'x,y,-z',
        '-x,y,z',
        'x,-y,z',
    ]
},

{
    number          => 65,
    hall            => '-A 2 2',
    schoenflies     => 'D2h^19',
    hermann_mauguin => 'A m m m',
    universal_h_m   => 'A m m m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        '-x,-y,-z',
        'x,y,-z',
        '-x,y,z',
        'x,-y,z',
        'x,y+1/2,z+1/2',
        '-x,-y+1/2,z+1/2',
        'x,-y+1/2,-z+1/2',
        '-x,y+1/2,-z+1/2',
        '-x,-y+1/2,-z+1/2',
        'x,y+1/2,-z+1/2',
        '-x,y+1/2,z+1/2',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        '-x,-y,-z',
        'x,y,-z',
        '-x,y,z',
        'x,-y,z',
    ]
},

{
    number          => 65,
    hall            => '-B 2 2',
    schoenflies     => 'D2h^19',
    hermann_mauguin => 'B m m m',
    universal_h_m   => 'B m m m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        '-x,-y,-z',
        'x,y,-z',
        '-x,y,z',
        'x,-y,z',
        'x+1/2,y,z+1/2',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-x+1/2,-y,-z+1/2',
        'x+1/2,y,-z+1/2',
        '-x+1/2,y,z+1/2',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        '-x,-y,-z',
        'x,y,-z',
        '-x,y,z',
        'x,-y,z',
    ]
},

{
    number          => 66,
    hall            => '-C 2 2c',
    schoenflies     => 'D2h^20',
    hermann_mauguin => 'C c c m',
    universal_h_m   => 'C c c m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z+1/2',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'x,y,-z',
        '-x,y,z+1/2',
        'x,-y,z+1/2',
        'x+1/2,y+1/2,z',
        '-x+1/2,-y+1/2,z',
        'x+1/2,-y+1/2,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-x+1/2,-y+1/2,-z',
        'x+1/2,y+1/2,-z',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z+1/2',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'x,y,-z',
        '-x,y,z+1/2',
        'x,-y,z+1/2',
    ]
},

{
    number          => 66,
    hall            => '-A 2a 2',
    schoenflies     => 'D2h^20',
    hermann_mauguin => 'A m a a',
    universal_h_m   => 'A m a a',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x,-y,-z',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x,y,z',
        'x+1/2,-y,z',
        'x,y+1/2,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        'x,-y+1/2,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-x,-y+1/2,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-x,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x,-y,-z',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x,y,z',
        'x+1/2,-y,z',
    ]
},

{
    number          => 66,
    hall            => '-B 2b 2b',
    schoenflies     => 'D2h^20',
    hermann_mauguin => 'B b m b',
    universal_h_m   => 'B b m b',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x,-y+1/2,-z',
        '-x,y,-z',
        '-x,-y,-z',
        'x,y+1/2,-z',
        '-x,y+1/2,z',
        'x,-y,z',
        'x+1/2,y,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-x+1/2,-y,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x,-y+1/2,-z',
        '-x,y,-z',
        '-x,-y,-z',
        'x,y+1/2,-z',
        '-x,y+1/2,z',
        'x,-y,z',
    ]
},

# According to ITC, Volume A, Hermann-Mauguin symbols of space group number 67
# should be written using the 'e' ('e' replaces some instances of 'a', 'b' and
# 'c'). However, since symmetry operators in these groups differ and renaming
# them would introduce ambiguity, it is not done in this dataset.
{
    number          => 67,
    hall            => '-C 2a 2',
    schoenflies     => 'D2h^21',
    hermann_mauguin => 'C m m a',
    universal_h_m   => 'C m m a',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x,-y,-z',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x,y,z',
        'x+1/2,-y,z',
        'x+1/2,y+1/2,z',
        '-x,-y+1/2,z',
        'x+1/2,-y+1/2,-z',
        '-x,y+1/2,-z',
        '-x+1/2,-y+1/2,-z',
        'x,y+1/2,-z',
        '-x+1/2,y+1/2,z',
        'x,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x,-y,-z',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x,y,z',
        'x+1/2,-y,z',
    ]
},

{
    number          => 67,
    hall            => '-C 2a 2a',
    schoenflies     => 'D2h^21',
    hermann_mauguin => 'C m m b',
    universal_h_m   => 'C m m b',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x+1/2,-y,-z',
        '-x,y,-z',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x+1/2,y,z',
        'x,-y,z',
        'x+1/2,y+1/2,z',
        '-x,-y+1/2,z',
        'x,-y+1/2,-z',
        '-x+1/2,y+1/2,-z',
        '-x+1/2,-y+1/2,-z',
        'x,y+1/2,-z',
        '-x,y+1/2,z',
        'x+1/2,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x+1/2,-y,-z',
        '-x,y,-z',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x+1/2,y,z',
        'x,-y,z',
    ]
},

{
    number          => 67,
    hall            => '-A 2b 2b',
    schoenflies     => 'D2h^21',
    hermann_mauguin => 'A b m m',
    universal_h_m   => 'A b m m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x,-y+1/2,-z',
        '-x,y,-z',
        '-x,-y,-z',
        'x,y+1/2,-z',
        '-x,y+1/2,z',
        'x,-y,z',
        'x,y+1/2,z+1/2',
        '-x,-y,z+1/2',
        'x,-y,-z+1/2',
        '-x,y+1/2,-z+1/2',
        '-x,-y+1/2,-z+1/2',
        'x,y,-z+1/2',
        '-x,y,z+1/2',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x,-y+1/2,-z',
        '-x,y,-z',
        '-x,-y,-z',
        'x,y+1/2,-z',
        '-x,y+1/2,z',
        'x,-y,z',
    ]
},

{
    number          => 67,
    hall            => '-A 2 2b',
    schoenflies     => 'D2h^21',
    hermann_mauguin => 'A c m m',
    universal_h_m   => 'A c m m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x,-y+1/2,-z',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'x,y,-z',
        '-x,y+1/2,z',
        'x,-y+1/2,z',
        'x,y+1/2,z+1/2',
        '-x,-y+1/2,z+1/2',
        'x,-y,-z+1/2',
        '-x,y,-z+1/2',
        '-x,-y+1/2,-z+1/2',
        'x,y+1/2,-z+1/2',
        '-x,y,z+1/2',
        'x,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y+1/2,-z',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'x,y,-z',
        '-x,y+1/2,z',
        'x,-y+1/2,z',
    ]
},

{
    number          => 67,
    hall            => '-B 2 2a',
    schoenflies     => 'D2h^21',
    hermann_mauguin => 'B m c m',
    universal_h_m   => 'B m c m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x+1/2,-y,-z',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x,y,-z',
        '-x+1/2,y,z',
        'x+1/2,-y,z',
        'x+1/2,y,z+1/2',
        '-x+1/2,-y,z+1/2',
        'x,-y,-z+1/2',
        '-x,y,-z+1/2',
        '-x+1/2,-y,-z+1/2',
        'x+1/2,y,-z+1/2',
        '-x,y,z+1/2',
        'x,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x+1/2,-y,-z',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x,y,-z',
        '-x+1/2,y,z',
        'x+1/2,-y,z',
    ]
},

{
    number          => 67,
    hall            => '-B 2a 2',
    schoenflies     => 'D2h^21',
    hermann_mauguin => 'B m a m',
    universal_h_m   => 'B m a m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x,-y,-z',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x,y,z',
        'x+1/2,-y,z',
        'x+1/2,y,z+1/2',
        '-x,-y,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x,y,-z+1/2',
        '-x+1/2,-y,-z+1/2',
        'x,y,-z+1/2',
        '-x+1/2,y,z+1/2',
        'x,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x,-y,-z',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x,y,z',
        'x+1/2,-y,z',
    ]
},

# Renamed symmetry groups 'C c c a :1' and 'C c c b :1' to 'C c c e :1' as
# described in the International Tables of Crystallography Volume A since
# they contain identical symmetry operators.
{
    number          => 68,
    hall            => 'C 2 2 -1ac',
    schoenflies     => 'D2h^22',
    hermann_mauguin => 'C c c e',
    universal_h_m   => 'C c c e :1',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        '-x+1/2,-y,-z+1/2',
        'x+1/2,y,-z+1/2',
        '-x+1/2,y,z+1/2',
        'x+1/2,-y,z+1/2',
        'x+1/2,y+1/2,z',
        '-x+1/2,-y+1/2,z',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,y+1/2,-z',
        '-x,-y+1/2,-z+1/2',
        'x,y+1/2,-z+1/2',
        '-x,y+1/2,z+1/2',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        '-x+1/2,-y,-z+1/2',
        'x+1/2,y,-z+1/2',
        '-x+1/2,y,z+1/2',
        'x+1/2,-y,z+1/2',
    ]
},

{
    number          => 68,
    hall            => '-C 2a 2ac',
    schoenflies     => 'D2h^22',
    hermann_mauguin => 'C c c a',
    universal_h_m   => 'C c c a :2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x+1/2,-y,-z+1/2',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x+1/2,y,z+1/2',
        'x,-y,z+1/2',
        'x+1/2,y+1/2,z',
        '-x,-y+1/2,z',
        'x,-y+1/2,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-x+1/2,-y+1/2,-z',
        'x,y+1/2,-z',
        '-x,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x+1/2,-y,-z+1/2',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x+1/2,y,z+1/2',
        'x,-y,z+1/2',
    ]
},

{
    number          => 68,
    hall            => '-C 2a 2c',
    schoenflies     => 'D2h^22',
    hermann_mauguin => 'C c c b',
    universal_h_m   => 'C c c b :2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x,-y,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x,y,z+1/2',
        'x+1/2,-y,z+1/2',
        'x+1/2,y+1/2,z',
        '-x,-y+1/2,z',
        'x+1/2,-y+1/2,-z+1/2',
        '-x,y+1/2,-z+1/2',
        '-x+1/2,-y+1/2,-z',
        'x,y+1/2,-z',
        '-x+1/2,y+1/2,z+1/2',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x,-y,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x,y,z+1/2',
        'x+1/2,-y,z+1/2',
    ]
},

# Renamed symmetry groups 'A b a a :1' and 'A c a a :1' to 'A e a a :1' as
# described in the International Tables of Crystallography Volume A since
# they contain identical symmetry operators.
{
    number          => 68,
    hall            => 'A 2 2 -1ab',
    schoenflies     => 'D2h^22',
    hermann_mauguin => 'A e a a',
    universal_h_m   => 'A e a a :1',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        '-x+1/2,-y+1/2,-z',
        'x+1/2,y+1/2,-z',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y+1/2,z',
        'x,y+1/2,z+1/2',
        '-x,-y+1/2,z+1/2',
        'x,-y+1/2,-z+1/2',
        '-x,y+1/2,-z+1/2',
        '-x+1/2,-y,-z+1/2',
        'x+1/2,y,-z+1/2',
        '-x+1/2,y,z+1/2',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        '-x+1/2,-y+1/2,-z',
        'x+1/2,y+1/2,-z',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y+1/2,z',
    ]
},

{
    number          => 68,
    hall            => '-A 2a 2b',
    schoenflies     => 'D2h^22',
    hermann_mauguin => 'A b a a',
    universal_h_m   => 'A b a a :2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x,-y+1/2,-z',
        '-x+1/2,y+1/2,-z',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x,y+1/2,z',
        'x+1/2,-y+1/2,z',
        'x,y+1/2,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        'x,-y,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-x,-y+1/2,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-x,y,z+1/2',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x,-y+1/2,-z',
        '-x+1/2,y+1/2,-z',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x,y+1/2,z',
        'x+1/2,-y+1/2,z',
    ]
},

{
    number          => 68,
    hall            => '-A 2ab 2b',
    schoenflies     => 'D2h^22',
    hermann_mauguin => 'A c a a',
    universal_h_m   => 'A c a a :2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x,-y+1/2,-z',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
        '-x,y+1/2,z',
        'x+1/2,-y,z',
        'x,y+1/2,z+1/2',
        '-x+1/2,-y,z+1/2',
        'x,-y,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-x,-y+1/2,-z+1/2',
        'x+1/2,y,-z+1/2',
        '-x,y,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x,-y+1/2,-z',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
        '-x,y+1/2,z',
        'x+1/2,-y,z',
    ]
},

# Renamed symmetry groups 'B b a b :1' and 'B b c b :1' to 'B b e b :1' as
# described in the International Tables of Crystallography Volume A since
# they contain identical symmetry operators.
{
    number          => 68,
    hall            => 'B 2 2 -1ab',
    schoenflies     => 'D2h^22',
    hermann_mauguin => 'B b e b',
    universal_h_m   => 'B b e b :1',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        '-x+1/2,-y+1/2,-z',
        'x+1/2,y+1/2,-z',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y+1/2,z',
        'x+1/2,y,z+1/2',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-x,-y+1/2,-z+1/2',
        'x,y+1/2,-z+1/2',
        '-x,y+1/2,z+1/2',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        '-x+1/2,-y+1/2,-z',
        'x+1/2,y+1/2,-z',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y+1/2,z',
    ]
},

{
    number          => 68,
    hall            => '-B 2ab 2b',
    schoenflies     => 'D2h^22',
    hermann_mauguin => 'B b c b',
    universal_h_m   => 'B b c b :2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x,-y+1/2,-z',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
        '-x,y+1/2,z',
        'x+1/2,-y,z',
        'x+1/2,y,z+1/2',
        '-x,-y+1/2,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        '-x,y,-z+1/2',
        '-x+1/2,-y,-z+1/2',
        'x,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x,-y+1/2,-z',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
        '-x,y+1/2,z',
        'x+1/2,-y,z',
    ]
},

{
    number          => 68,
    hall            => '-B 2b 2ab',
    schoenflies     => 'D2h^22',
    hermann_mauguin => 'B b a b',
    universal_h_m   => 'B b a b :2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x,y+1/2,-z',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y,z',
        'x+1/2,y,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        'x,-y+1/2,-z+1/2',
        '-x,y,-z+1/2',
        '-x+1/2,-y,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-x,y+1/2,z+1/2',
        'x,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x,y+1/2,-z',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y,z',
    ]
},

{
    number          => 69,
    hall            => '-F 2 2',
    schoenflies     => 'D2h^23',
    hermann_mauguin => 'F m m m',
    universal_h_m   => 'F m m m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        '-x,-y,-z',
        'x,y,-z',
        '-x,y,z',
        'x,-y,z',
        'x,y+1/2,z+1/2',
        '-x,-y+1/2,z+1/2',
        'x,-y+1/2,-z+1/2',
        '-x,y+1/2,-z+1/2',
        '-x,-y+1/2,-z+1/2',
        'x,y+1/2,-z+1/2',
        '-x,y+1/2,z+1/2',
        'x,-y+1/2,z+1/2',
        'x+1/2,y,z+1/2',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-x+1/2,-y,-z+1/2',
        'x+1/2,y,-z+1/2',
        '-x+1/2,y,z+1/2',
        'x+1/2,-y,z+1/2',
        'x+1/2,y+1/2,z',
        '-x+1/2,-y+1/2,z',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,y+1/2,-z',
        '-x+1/2,-y+1/2,-z',
        'x+1/2,y+1/2,-z',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        '-x,-y,-z',
        'x,y,-z',
        '-x,y,z',
        'x,-y,z',
    ]
},

{
    number          => 70,
    hall            => 'F 2 2 -1d',
    schoenflies     => 'D2h^24',
    hermann_mauguin => 'F d d d',
    universal_h_m   => 'F d d d :1',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        '-x+1/4,-y+1/4,-z+1/4',
        'x+1/4,y+1/4,-z+1/4',
        '-x+1/4,y+1/4,z+1/4',
        'x+1/4,-y+1/4,z+1/4',
        'x,y+1/2,z+1/2',
        '-x,-y+1/2,z+1/2',
        'x,-y+1/2,-z+1/2',
        '-x,y+1/2,-z+1/2',
        '-x+1/4,-y+3/4,-z+3/4',
        'x+1/4,y+3/4,-z+3/4',
        '-x+1/4,y+3/4,z+3/4',
        'x+1/4,-y+3/4,z+3/4',
        'x+1/2,y,z+1/2',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-x+3/4,-y+1/4,-z+3/4',
        'x+3/4,y+1/4,-z+3/4',
        '-x+3/4,y+1/4,z+3/4',
        'x+3/4,-y+1/4,z+3/4',
        'x+1/2,y+1/2,z',
        '-x+1/2,-y+1/2,z',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,y+1/2,-z',
        '-x+3/4,-y+3/4,-z+1/4',
        'x+3/4,y+3/4,-z+1/4',
        '-x+3/4,y+3/4,z+1/4',
        'x+3/4,-y+3/4,z+1/4',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        '-x+1/4,-y+1/4,-z+1/4',
        'x+1/4,y+1/4,-z+1/4',
        '-x+1/4,y+1/4,z+1/4',
        'x+1/4,-y+1/4,z+1/4',
    ]
},

{
    number          => 70,
    hall            => '-F 2uv 2vw',
    schoenflies     => 'D2h^24',
    hermann_mauguin => 'F d d d',
    universal_h_m   => 'F d d d :2',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/4,-y+1/4,z',
        'x,-y+1/4,-z+1/4',
        '-x+1/4,y,-z+1/4',
        '-x,-y,-z',
        'x+3/4,y+3/4,-z',
        '-x,y+3/4,z+3/4',
        'x+3/4,-y,z+3/4',
        'x,y+1/2,z+1/2',
        '-x+1/4,-y+3/4,z+1/2',
        'x,-y+3/4,-z+3/4',
        '-x+1/4,y+1/2,-z+3/4',
        '-x,-y+1/2,-z+1/2',
        'x+3/4,y+1/4,-z+1/2',
        '-x,y+1/4,z+1/4',
        'x+3/4,-y+1/2,z+1/4',
        'x+1/2,y,z+1/2',
        '-x+3/4,-y+1/4,z+1/2',
        'x+1/2,-y+1/4,-z+3/4',
        '-x+3/4,y,-z+3/4',
        '-x+1/2,-y,-z+1/2',
        'x+1/4,y+3/4,-z+1/2',
        '-x+1/2,y+3/4,z+1/4',
        'x+1/4,-y,z+1/4',
        'x+1/2,y+1/2,z',
        '-x+3/4,-y+3/4,z',
        'x+1/2,-y+3/4,-z+1/4',
        '-x+3/4,y+1/2,-z+1/4',
        '-x+1/2,-y+1/2,-z',
        'x+1/4,y+1/4,-z',
        '-x+1/2,y+1/4,z+3/4',
        'x+1/4,-y+1/2,z+3/4',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/4,-y+1/4,z',
        'x,-y+1/4,-z+1/4',
        '-x+1/4,y,-z+1/4',
        '-x,-y,-z',
        'x+3/4,y+3/4,-z',
        '-x,y+3/4,z+3/4',
        'x+3/4,-y,z+3/4',
    ]
},

{
    number          => 71,
    hall            => '-I 2 2',
    schoenflies     => 'D2h^25',
    hermann_mauguin => 'I m m m',
    universal_h_m   => 'I m m m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        '-x,-y,-z',
        'x,y,-z',
        '-x,y,z',
        'x,-y,z',
        'x+1/2,y+1/2,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        '-x,-y,-z',
        'x,y,-z',
        '-x,y,z',
        'x,-y,z',
    ]
},

{
    number          => 72,
    hall            => '-I 2 2c',
    schoenflies     => 'D2h^26',
    hermann_mauguin => 'I b a m',
    universal_h_m   => 'I b a m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z+1/2',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'x,y,-z',
        '-x,y,z+1/2',
        'x,-y,z+1/2',
        'x+1/2,y+1/2,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,y+1/2,-z',
        '-x+1/2,-y+1/2,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z+1/2',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'x,y,-z',
        '-x,y,z+1/2',
        'x,-y,z+1/2',
    ]
},

{
    number          => 72,
    hall            => '-I 2a 2',
    schoenflies     => 'D2h^26',
    hermann_mauguin => 'I m c b',
    universal_h_m   => 'I m c b',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x,-y,-z',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x,y,z',
        'x+1/2,-y,z',
        'x+1/2,y+1/2,z+1/2',
        '-x,-y+1/2,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        '-x,y+1/2,-z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        'x,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x,-y,-z',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x,y,z',
        'x+1/2,-y,z',
    ]
},

{
    number          => 72,
    hall            => '-I 2b 2b',
    schoenflies     => 'D2h^26',
    hermann_mauguin => 'I c m a',
    universal_h_m   => 'I c m a',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x,-y+1/2,-z',
        '-x,y,-z',
        '-x,-y,-z',
        'x,y+1/2,-z',
        '-x,y+1/2,z',
        'x,-y,z',
        'x+1/2,y+1/2,z+1/2',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        'x+1/2,y,-z+1/2',
        '-x+1/2,y,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x,-y+1/2,-z',
        '-x,y,-z',
        '-x,-y,-z',
        'x,y+1/2,-z',
        '-x,y+1/2,z',
        'x,-y,z',
    ]
},

{
    number          => 73,
    hall            => '-I 2b 2c',
    schoenflies     => 'D2h^27',
    hermann_mauguin => 'I b c a',
    universal_h_m   => 'I b c a',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x,-y,-z+1/2',
        '-x,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x,y+1/2,-z',
        '-x,y,z+1/2',
        'x,-y+1/2,z+1/2',
        'x+1/2,y+1/2,z+1/2',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,y,-z',
        '-x+1/2,-y+1/2,-z+1/2',
        'x+1/2,y,-z+1/2',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x,-y,-z+1/2',
        '-x,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x,y+1/2,-z',
        '-x,y,z+1/2',
        'x,-y+1/2,z+1/2',
    ]
},

{
    number          => 73,
    hall            => '-I 2a 2b',
    schoenflies     => 'D2h^27',
    hermann_mauguin => 'I c a b',
    universal_h_m   => 'I c a b',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x,-y+1/2,-z',
        '-x+1/2,y+1/2,-z',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x,y+1/2,z',
        'x+1/2,-y+1/2,z',
        'x+1/2,y+1/2,z+1/2',
        '-x,-y+1/2,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x,y,-z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        'x,y+1/2,-z+1/2',
        '-x+1/2,y,z+1/2',
        'x,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x,-y+1/2,-z',
        '-x+1/2,y+1/2,-z',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x,y+1/2,z',
        'x+1/2,-y+1/2,z',
    ]
},

{
    number          => 74,
    hall            => '-I 2b 2',
    schoenflies     => 'D2h^28',
    hermann_mauguin => 'I m m a',
    universal_h_m   => 'I m m a',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x,-y,-z',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'x,y+1/2,-z',
        '-x,y,z',
        'x,-y+1/2,z',
        'x+1/2,y+1/2,z+1/2',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        'x+1/2,y,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x,-y,-z',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'x,y+1/2,-z',
        '-x,y,z',
        'x,-y+1/2,z',
    ]
},

{
    number          => 74,
    hall            => '-I 2a 2a',
    schoenflies     => 'D2h^28',
    hermann_mauguin => 'I m m b',
    universal_h_m   => 'I m m b',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x+1/2,-y,-z',
        '-x,y,-z',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x+1/2,y,z',
        'x,-y,z',
        'x+1/2,y+1/2,z+1/2',
        '-x,-y+1/2,z+1/2',
        'x,-y+1/2,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        'x,y+1/2,-z+1/2',
        '-x,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x+1/2,-y,-z',
        '-x,y,-z',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x+1/2,y,z',
        'x,-y,z',
    ]
},

{
    number          => 74,
    hall            => '-I 2c 2c',
    schoenflies     => 'D2h^28',
    hermann_mauguin => 'I b m m',
    universal_h_m   => 'I b m m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z+1/2',
        'x,-y,-z+1/2',
        '-x,y,-z',
        '-x,-y,-z',
        'x,y,-z+1/2',
        '-x,y,z+1/2',
        'x,-y,z',
        'x+1/2,y+1/2,z+1/2',
        '-x+1/2,-y+1/2,z',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,y+1/2,-z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        'x+1/2,y+1/2,-z',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
        'x,-y,-z+1/2',
        '-x,y,-z',
        '-x,-y,-z',
        'x,y,-z+1/2',
        '-x,y,z+1/2',
        'x,-y,z',
    ]
},

{
    number          => 74,
    hall            => '-I 2 2b',
    schoenflies     => 'D2h^28',
    hermann_mauguin => 'I c m m',
    universal_h_m   => 'I c m m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x,-y+1/2,-z',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'x,y,-z',
        '-x,y+1/2,z',
        'x,-y+1/2,z',
        'x+1/2,y+1/2,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-x+1/2,y,z+1/2',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y+1/2,-z',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'x,y,-z',
        '-x,y+1/2,z',
        'x,-y+1/2,z',
    ]
},

{
    number          => 74,
    hall            => '-I 2 2a',
    schoenflies     => 'D2h^28',
    hermann_mauguin => 'I m c m',
    universal_h_m   => 'I m c m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x+1/2,-y,-z',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x,y,-z',
        '-x+1/2,y,z',
        'x+1/2,-y,z',
        'x+1/2,y+1/2,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        'x,-y+1/2,-z+1/2',
        '-x,y+1/2,-z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-x,y+1/2,z+1/2',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x+1/2,-y,-z',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x,y,-z',
        '-x+1/2,y,z',
        'x+1/2,-y,z',
    ]
},

{
    number          => 74,
    hall            => '-I 2c 2',
    schoenflies     => 'D2h^28',
    hermann_mauguin => 'I m a m',
    universal_h_m   => 'I m a m',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z+1/2',
        'x,-y,-z',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'x,y,-z+1/2',
        '-x,y,z',
        'x,-y,z+1/2',
        'x+1/2,y+1/2,z+1/2',
        '-x+1/2,-y+1/2,z',
        'x+1/2,-y+1/2,-z+1/2',
        '-x+1/2,y+1/2,-z',
        '-x+1/2,-y+1/2,-z+1/2',
        'x+1/2,y+1/2,-z',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
        'x,-y,-z',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'x,y,-z+1/2',
        '-x,y,z',
        'x,-y,z+1/2',
    ]
},

{
    number          => 75,
    hall            => 'P 4',
    schoenflies     => 'C4^1',
    hermann_mauguin => 'P 4',
    universal_h_m   => 'P 4',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
    ]
},

{
    number          => 76,
    hall            => 'P 4w',
    schoenflies     => 'C4^2',
    hermann_mauguin => 'P 41',
    universal_h_m   => 'P 41',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z+1/4',
        '-x,-y,z+1/2',
        'y,-x,z+3/4',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z+1/4',
        '-x,-y,z+1/2',
        'y,-x,z+3/4',
    ]
},

{
    number          => 77,
    hall            => 'P 4c',
    schoenflies     => 'C4^3',
    hermann_mauguin => 'P 42',
    universal_h_m   => 'P 42',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z+1/2',
        '-x,-y,z',
        'y,-x,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z+1/2',
        '-x,-y,z',
        'y,-x,z+1/2',
    ]
},

{
    number          => 78,
    hall            => 'P 4cw',
    schoenflies     => 'C4^4',
    hermann_mauguin => 'P 43',
    universal_h_m   => 'P 43',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z+3/4',
        '-x,-y,z+1/2',
        'y,-x,z+1/4',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z+3/4',
        '-x,-y,z+1/2',
        'y,-x,z+1/4',
    ]
},

{
    number          => 79,
    hall            => 'I 4',
    schoenflies     => 'C4^5',
    hermann_mauguin => 'I 4',
    universal_h_m   => 'I 4',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x+1/2,y+1/2,z+1/2',
        '-y+1/2,x+1/2,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        'y+1/2,-x+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
    ]
},

{
    number          => 80,
    hall            => 'I 4bw',
    schoenflies     => 'C4^6',
    hermann_mauguin => 'I 41',
    universal_h_m   => 'I 41',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x+1/2,z+1/4',
        '-x+1/2,-y+1/2,z+1/2',
        'y+1/2,-x,z+3/4',
        'x+1/2,y+1/2,z+1/2',
        '-y+1/2,x,z+3/4',
        '-x,-y,z',
        'y,-x+1/2,z+1/4',
    ],
    ncsym => [
        'x,y,z',
        '-y,x+1/2,z+1/4',
        '-x+1/2,-y+1/2,z+1/2',
        'y+1/2,-x,z+3/4',
    ]
},

{
    number          => 81,
    hall            => 'P -4',
    schoenflies     => 'S4^1',
    hermann_mauguin => 'P -4',
    universal_h_m   => 'P -4',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'y,-x,-z',
        '-x,-y,z',
        '-y,x,-z',
    ],
    ncsym => [
        'x,y,z',
        'y,-x,-z',
        '-x,-y,z',
        '-y,x,-z',
    ]
},

{
    number          => 82,
    hall            => 'I -4',
    schoenflies     => 'S4^2',
    hermann_mauguin => 'I -4',
    universal_h_m   => 'I -4',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'y,-x,-z',
        '-x,-y,z',
        '-y,x,-z',
        'x+1/2,y+1/2,z+1/2',
        'y+1/2,-x+1/2,-z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        '-y+1/2,x+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'y,-x,-z',
        '-x,-y,z',
        '-y,x,-z',
    ]
},

{
    number          => 83,
    hall            => '-P 4',
    schoenflies     => 'C4h^1',
    hermann_mauguin => 'P 4/m',
    universal_h_m   => 'P 4/m',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        '-x,-y,-z',
        'y,-x,-z',
        'x,y,-z',
        '-y,x,-z',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        '-x,-y,-z',
        'y,-x,-z',
        'x,y,-z',
        '-y,x,-z',
    ]
},

{
    number          => 84,
    hall            => '-P 4c',
    schoenflies     => 'C4h^2',
    hermann_mauguin => 'P 42/m',
    universal_h_m   => 'P 42/m',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z+1/2',
        '-x,-y,z',
        'y,-x,z+1/2',
        '-x,-y,-z',
        'y,-x,-z+1/2',
        'x,y,-z',
        '-y,x,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z+1/2',
        '-x,-y,z',
        'y,-x,z+1/2',
        '-x,-y,-z',
        'y,-x,-z+1/2',
        'x,y,-z',
        '-y,x,-z+1/2',
    ]
},

{
    number          => 85,
    hall            => 'P 4ab -1ab',
    schoenflies     => 'C4h^3',
    hermann_mauguin => 'P 4/n',
    universal_h_m   => 'P 4/n :1',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x+1/2,z',
        '-x,-y,z',
        'y+1/2,-x+1/2,z',
        '-x+1/2,-y+1/2,-z',
        'y,-x,-z',
        'x+1/2,y+1/2,-z',
        '-y,x,-z',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x+1/2,z',
        '-x,-y,z',
        'y+1/2,-x+1/2,z',
        '-x+1/2,-y+1/2,-z',
        'y,-x,-z',
        'x+1/2,y+1/2,-z',
        '-y,x,-z',
    ]
},

{
    number          => 85,
    hall            => '-P 4a',
    schoenflies     => 'C4h^3',
    hermann_mauguin => 'P 4/n',
    universal_h_m   => 'P 4/n :2',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x,z',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z',
        '-x,-y,-z',
        'y+1/2,-x,-z',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x,z',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z',
        '-x,-y,-z',
        'y+1/2,-x,-z',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z',
    ]
},

{
    number          => 86,
    hall            => 'P 4n -1n',
    schoenflies     => 'C4h^4',
    hermann_mauguin => 'P 42/n',
    universal_h_m   => 'P 42/n :1',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x+1/2,z+1/2',
        '-x,-y,z',
        'y+1/2,-x+1/2,z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        'y,-x,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-y,x,-z',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x+1/2,z+1/2',
        '-x,-y,z',
        'y+1/2,-x+1/2,z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        'y,-x,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-y,x,-z',
    ]
},

{
    number          => 86,
    hall            => '-P 4bc',
    schoenflies     => 'C4h^4',
    hermann_mauguin => 'P 42/n',
    universal_h_m   => 'P 42/n :2',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x+1/2,z+1/2',
        '-x+1/2,-y+1/2,z',
        'y+1/2,-x,z+1/2',
        '-x,-y,-z',
        'y,-x+1/2,-z+1/2',
        'x+1/2,y+1/2,-z',
        '-y+1/2,x,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y,x+1/2,z+1/2',
        '-x+1/2,-y+1/2,z',
        'y+1/2,-x,z+1/2',
        '-x,-y,-z',
        'y,-x+1/2,-z+1/2',
        'x+1/2,y+1/2,-z',
        '-y+1/2,x,-z+1/2',
    ]
},

{
    number          => 87,
    hall            => '-I 4',
    schoenflies     => 'C4h^5',
    hermann_mauguin => 'I 4/m',
    universal_h_m   => 'I 4/m',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        '-x,-y,-z',
        'y,-x,-z',
        'x,y,-z',
        '-y,x,-z',
        'x+1/2,y+1/2,z+1/2',
        '-y+1/2,x+1/2,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        'y+1/2,-x+1/2,z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        'y+1/2,-x+1/2,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-y+1/2,x+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        '-x,-y,-z',
        'y,-x,-z',
        'x,y,-z',
        '-y,x,-z',
    ]
},

{
    number          => 88,
    hall            => 'I 4bw -1bw',
    schoenflies     => 'C4h^6',
    hermann_mauguin => 'I 41/a',
    universal_h_m   => 'I 41/a :1',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x+1/2,z+1/4',
        '-x+1/2,-y+1/2,z+1/2',
        'y+1/2,-x,z+3/4',
        '-x,-y+1/2,-z+1/4',
        'y,-x,-z',
        'x+1/2,y,-z+3/4',
        '-y+1/2,x+1/2,-z+1/2',
        'x+1/2,y+1/2,z+1/2',
        '-y+1/2,x,z+3/4',
        '-x,-y,z',
        'y,-x+1/2,z+1/4',
        '-x+1/2,-y,-z+3/4',
        'y+1/2,-x+1/2,-z+1/2',
        'x,y+1/2,-z+1/4',
        '-y,x,-z',
    ],
    ncsym => [
        'x,y,z',
        '-y,x+1/2,z+1/4',
        '-x+1/2,-y+1/2,z+1/2',
        'y+1/2,-x,z+3/4',
        '-x,-y+1/2,-z+1/4',
        'y,-x,-z',
        'x+1/2,y,-z+3/4',
        '-y+1/2,x+1/2,-z+1/2',
    ]
},

{
    number          => 88,
    hall            => '-I 4ad',
    schoenflies     => 'C4h^6',
    hermann_mauguin => 'I 41/a',
    universal_h_m   => 'I 41/a :2',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+3/4,x+1/4,z+1/4',
        '-x+1/2,-y,z+1/2',
        'y+3/4,-x+3/4,z+3/4',
        '-x,-y,-z',
        'y+1/4,-x+3/4,-z+3/4',
        'x+1/2,y,-z+1/2',
        '-y+1/4,x+1/4,-z+1/4',
        'x+1/2,y+1/2,z+1/2',
        '-y+1/4,x+3/4,z+3/4',
        '-x,-y+1/2,z',
        'y+1/4,-x+1/4,z+1/4',
        '-x+1/2,-y+1/2,-z+1/2',
        'y+3/4,-x+1/4,-z+1/4',
        'x,y+1/2,-z',
        '-y+3/4,x+3/4,-z+3/4',
    ],
    ncsym => [
        'x,y,z',
        '-y+3/4,x+1/4,z+1/4',
        '-x+1/2,-y,z+1/2',
        'y+3/4,-x+3/4,z+3/4',
        '-x,-y,-z',
        'y+1/4,-x+3/4,-z+3/4',
        'x+1/2,y,-z+1/2',
        '-y+1/4,x+1/4,-z+1/4',
    ]
},

{
    number          => 89,
    hall            => 'P 4 2',
    schoenflies     => 'D4^1',
    hermann_mauguin => 'P 4 2 2',
    universal_h_m   => 'P 4 2 2',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x,-y,-z',
        'y,x,-z',
        '-x,y,-z',
        '-y,-x,-z',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x,-y,-z',
        'y,x,-z',
        '-x,y,-z',
        '-y,-x,-z',
    ]
},

{
    number          => 90,
    hall            => 'P 4ab 2ab',
    schoenflies     => 'D4^2',
    hermann_mauguin => 'P 4 21 2',
    universal_h_m   => 'P 4 21 2',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x+1/2,z',
        '-x,-y,z',
        'y+1/2,-x+1/2,z',
        'x+1/2,-y+1/2,-z',
        'y,x,-z',
        '-x+1/2,y+1/2,-z',
        '-y,-x,-z',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x+1/2,z',
        '-x,-y,z',
        'y+1/2,-x+1/2,z',
        'x+1/2,-y+1/2,-z',
        'y,x,-z',
        '-x+1/2,y+1/2,-z',
        '-y,-x,-z',
    ]
},

{
    number          => 91,
    hall            => 'P 4w 2c',
    schoenflies     => 'D4^3',
    hermann_mauguin => 'P 41 2 2',
    universal_h_m   => 'P 41 2 2',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z+1/4',
        '-x,-y,z+1/2',
        'y,-x,z+3/4',
        'x,-y,-z+1/2',
        'y,x,-z+3/4',
        '-x,y,-z',
        '-y,-x,-z+1/4',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z+1/4',
        '-x,-y,z+1/2',
        'y,-x,z+3/4',
        'x,-y,-z+1/2',
        'y,x,-z+3/4',
        '-x,y,-z',
        '-y,-x,-z+1/4',
    ]
},

{
    number          => 92,
    hall            => 'P 4abw 2nw',
    schoenflies     => 'D4^4',
    hermann_mauguin => 'P 41 21 2',
    universal_h_m   => 'P 41 21 2',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x+1/2,z+1/4',
        '-x,-y,z+1/2',
        'y+1/2,-x+1/2,z+3/4',
        'x+1/2,-y+1/2,-z+3/4',
        'y,x,-z',
        '-x+1/2,y+1/2,-z+1/4',
        '-y,-x,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x+1/2,z+1/4',
        '-x,-y,z+1/2',
        'y+1/2,-x+1/2,z+3/4',
        'x+1/2,-y+1/2,-z+3/4',
        'y,x,-z',
        '-x+1/2,y+1/2,-z+1/4',
        '-y,-x,-z+1/2',
    ]
},

{
    number          => 93,
    hall            => 'P 4c 2',
    schoenflies     => 'D4^5',
    hermann_mauguin => 'P 42 2 2',
    universal_h_m   => 'P 42 2 2',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z+1/2',
        '-x,-y,z',
        'y,-x,z+1/2',
        'x,-y,-z',
        'y,x,-z+1/2',
        '-x,y,-z',
        '-y,-x,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z+1/2',
        '-x,-y,z',
        'y,-x,z+1/2',
        'x,-y,-z',
        'y,x,-z+1/2',
        '-x,y,-z',
        '-y,-x,-z+1/2',
    ]
},

{
    number          => 94,
    hall            => 'P 4n 2n',
    schoenflies     => 'D4^6',
    hermann_mauguin => 'P 42 21 2',
    universal_h_m   => 'P 42 21 2',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x+1/2,z+1/2',
        '-x,-y,z',
        'y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        'y,x,-z',
        '-x+1/2,y+1/2,-z+1/2',
        '-y,-x,-z',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x+1/2,z+1/2',
        '-x,-y,z',
        'y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        'y,x,-z',
        '-x+1/2,y+1/2,-z+1/2',
        '-y,-x,-z',
    ]
},

{
    number          => 95,
    hall            => 'P 4cw 2c',
    schoenflies     => 'D4^7',
    hermann_mauguin => 'P 43 2 2',
    universal_h_m   => 'P 43 2 2',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z+3/4',
        '-x,-y,z+1/2',
        'y,-x,z+1/4',
        'x,-y,-z+1/2',
        'y,x,-z+1/4',
        '-x,y,-z',
        '-y,-x,-z+3/4',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z+3/4',
        '-x,-y,z+1/2',
        'y,-x,z+1/4',
        'x,-y,-z+1/2',
        'y,x,-z+1/4',
        '-x,y,-z',
        '-y,-x,-z+3/4',
    ]
},

{
    number          => 96,
    hall            => 'P 4nw 2abw',
    schoenflies     => 'D4^8',
    hermann_mauguin => 'P 43 21 2',
    universal_h_m   => 'P 43 21 2',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x+1/2,z+3/4',
        '-x,-y,z+1/2',
        'y+1/2,-x+1/2,z+1/4',
        'x+1/2,-y+1/2,-z+1/4',
        'y,x,-z',
        '-x+1/2,y+1/2,-z+3/4',
        '-y,-x,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x+1/2,z+3/4',
        '-x,-y,z+1/2',
        'y+1/2,-x+1/2,z+1/4',
        'x+1/2,-y+1/2,-z+1/4',
        'y,x,-z',
        '-x+1/2,y+1/2,-z+3/4',
        '-y,-x,-z+1/2',
    ]
},

{
    number          => 97,
    hall            => 'I 4 2',
    schoenflies     => 'D4^9',
    hermann_mauguin => 'I 4 2 2',
    universal_h_m   => 'I 4 2 2',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x,-y,-z',
        'y,x,-z',
        '-x,y,-z',
        '-y,-x,-z',
        'x+1/2,y+1/2,z+1/2',
        '-y+1/2,x+1/2,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        'y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        'y+1/2,x+1/2,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-y+1/2,-x+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x,-y,-z',
        'y,x,-z',
        '-x,y,-z',
        '-y,-x,-z',
    ]
},

{
    number          => 98,
    hall            => 'I 4bw 2bw',
    schoenflies     => 'D4^10',
    hermann_mauguin => 'I 41 2 2',
    universal_h_m   => 'I 41 2 2',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x+1/2,z+1/4',
        '-x+1/2,-y+1/2,z+1/2',
        'y+1/2,-x,z+3/4',
        'x,-y+1/2,-z+1/4',
        'y+1/2,x+1/2,-z+1/2',
        '-x+1/2,y,-z+3/4',
        '-y,-x,-z',
        'x+1/2,y+1/2,z+1/2',
        '-y+1/2,x,z+3/4',
        '-x,-y,z',
        'y,-x+1/2,z+1/4',
        'x+1/2,-y,-z+3/4',
        'y,x,-z',
        '-x,y+1/2,-z+1/4',
        '-y+1/2,-x+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y,x+1/2,z+1/4',
        '-x+1/2,-y+1/2,z+1/2',
        'y+1/2,-x,z+3/4',
        'x,-y+1/2,-z+1/4',
        'y+1/2,x+1/2,-z+1/2',
        '-x+1/2,y,-z+3/4',
        '-y,-x,-z',
    ]
},

{
    number          => 99,
    hall            => 'P 4 -2',
    schoenflies     => 'C4v^1',
    hermann_mauguin => 'P 4 m m',
    universal_h_m   => 'P 4 m m',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        '-x,y,z',
        '-y,-x,z',
        'x,-y,z',
        'y,x,z',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        '-x,y,z',
        '-y,-x,z',
        'x,-y,z',
        'y,x,z',
    ]
},

{
    number          => 100,
    hall            => 'P 4 -2ab',
    schoenflies     => 'C4v^2',
    hermann_mauguin => 'P 4 b m',
    universal_h_m   => 'P 4 b m',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        '-x+1/2,y+1/2,z',
        '-y+1/2,-x+1/2,z',
        'x+1/2,-y+1/2,z',
        'y+1/2,x+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        '-x+1/2,y+1/2,z',
        '-y+1/2,-x+1/2,z',
        'x+1/2,-y+1/2,z',
        'y+1/2,x+1/2,z',
    ]
},

{
    number          => 101,
    hall            => 'P 4c -2c',
    schoenflies     => 'C4v^3',
    hermann_mauguin => 'P 42 c m',
    universal_h_m   => 'P 42 c m',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z+1/2',
        '-x,-y,z',
        'y,-x,z+1/2',
        '-x,y,z+1/2',
        '-y,-x,z',
        'x,-y,z+1/2',
        'y,x,z',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z+1/2',
        '-x,-y,z',
        'y,-x,z+1/2',
        '-x,y,z+1/2',
        '-y,-x,z',
        'x,-y,z+1/2',
        'y,x,z',
    ]
},

{
    number          => 102,
    hall            => 'P 4n -2n',
    schoenflies     => 'C4v^4',
    hermann_mauguin => 'P 42 n m',
    universal_h_m   => 'P 42 n m',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x+1/2,z+1/2',
        '-x,-y,z',
        'y+1/2,-x+1/2,z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        '-y,-x,z',
        'x+1/2,-y+1/2,z+1/2',
        'y,x,z',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x+1/2,z+1/2',
        '-x,-y,z',
        'y+1/2,-x+1/2,z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        '-y,-x,z',
        'x+1/2,-y+1/2,z+1/2',
        'y,x,z',
    ]
},

{
    number          => 103,
    hall            => 'P 4 -2c',
    schoenflies     => 'C4v^5',
    hermann_mauguin => 'P 4 c c',
    universal_h_m   => 'P 4 c c',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        '-x,y,z+1/2',
        '-y,-x,z+1/2',
        'x,-y,z+1/2',
        'y,x,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        '-x,y,z+1/2',
        '-y,-x,z+1/2',
        'x,-y,z+1/2',
        'y,x,z+1/2',
    ]
},

{
    number          => 104,
    hall            => 'P 4 -2n',
    schoenflies     => 'C4v^6',
    hermann_mauguin => 'P 4 n c',
    universal_h_m   => 'P 4 n c',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        '-x+1/2,y+1/2,z+1/2',
        '-y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        'y+1/2,x+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        '-x+1/2,y+1/2,z+1/2',
        '-y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        'y+1/2,x+1/2,z+1/2',
    ]
},

{
    number          => 105,
    hall            => 'P 4c -2',
    schoenflies     => 'C4v^7',
    hermann_mauguin => 'P 42 m c',
    universal_h_m   => 'P 42 m c',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z+1/2',
        '-x,-y,z',
        'y,-x,z+1/2',
        '-x,y,z',
        '-y,-x,z+1/2',
        'x,-y,z',
        'y,x,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z+1/2',
        '-x,-y,z',
        'y,-x,z+1/2',
        '-x,y,z',
        '-y,-x,z+1/2',
        'x,-y,z',
        'y,x,z+1/2',
    ]
},

{
    number          => 106,
    hall            => 'P 4c -2ab',
    schoenflies     => 'C4v^8',
    hermann_mauguin => 'P 42 b c',
    universal_h_m   => 'P 42 b c',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z+1/2',
        '-x,-y,z',
        'y,-x,z+1/2',
        '-x+1/2,y+1/2,z',
        '-y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y+1/2,z',
        'y+1/2,x+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z+1/2',
        '-x,-y,z',
        'y,-x,z+1/2',
        '-x+1/2,y+1/2,z',
        '-y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y+1/2,z',
        'y+1/2,x+1/2,z+1/2',
    ]
},

{
    number          => 107,
    hall            => 'I 4 -2',
    schoenflies     => 'C4v^9',
    hermann_mauguin => 'I 4 m m',
    universal_h_m   => 'I 4 m m',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        '-x,y,z',
        '-y,-x,z',
        'x,-y,z',
        'y,x,z',
        'x+1/2,y+1/2,z+1/2',
        '-y+1/2,x+1/2,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        'y+1/2,-x+1/2,z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        '-y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        'y+1/2,x+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        '-x,y,z',
        '-y,-x,z',
        'x,-y,z',
        'y,x,z',
    ]
},

{
    number          => 108,
    hall            => 'I 4 -2c',
    schoenflies     => 'C4v^10',
    hermann_mauguin => 'I 4 c m',
    universal_h_m   => 'I 4 c m',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        '-x,y,z+1/2',
        '-y,-x,z+1/2',
        'x,-y,z+1/2',
        'y,x,z+1/2',
        'x+1/2,y+1/2,z+1/2',
        '-y+1/2,x+1/2,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        'y+1/2,-x+1/2,z+1/2',
        '-x+1/2,y+1/2,z',
        '-y+1/2,-x+1/2,z',
        'x+1/2,-y+1/2,z',
        'y+1/2,x+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        '-x,y,z+1/2',
        '-y,-x,z+1/2',
        'x,-y,z+1/2',
        'y,x,z+1/2',
    ]
},

{
    number          => 109,
    hall            => 'I 4bw -2',
    schoenflies     => 'C4v^11',
    hermann_mauguin => 'I 41 m d',
    universal_h_m   => 'I 41 m d',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x+1/2,z+1/4',
        '-x+1/2,-y+1/2,z+1/2',
        'y+1/2,-x,z+3/4',
        '-x,y,z',
        '-y,-x+1/2,z+1/4',
        'x+1/2,-y+1/2,z+1/2',
        'y+1/2,x,z+3/4',
        'x+1/2,y+1/2,z+1/2',
        '-y+1/2,x,z+3/4',
        '-x,-y,z',
        'y,-x+1/2,z+1/4',
        '-x+1/2,y+1/2,z+1/2',
        '-y+1/2,-x,z+3/4',
        'x,-y,z',
        'y,x+1/2,z+1/4',
    ],
    ncsym => [
        'x,y,z',
        '-y,x+1/2,z+1/4',
        '-x+1/2,-y+1/2,z+1/2',
        'y+1/2,-x,z+3/4',
        '-x,y,z',
        '-y,-x+1/2,z+1/4',
        'x+1/2,-y+1/2,z+1/2',
        'y+1/2,x,z+3/4',
    ]
},

{
    number          => 110,
    hall            => 'I 4bw -2c',
    schoenflies     => 'C4v^12',
    hermann_mauguin => 'I 41 c d',
    universal_h_m   => 'I 41 c d',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x+1/2,z+1/4',
        '-x+1/2,-y+1/2,z+1/2',
        'y+1/2,-x,z+3/4',
        '-x,y,z+1/2',
        '-y,-x+1/2,z+3/4',
        'x+1/2,-y+1/2,z',
        'y+1/2,x,z+1/4',
        'x+1/2,y+1/2,z+1/2',
        '-y+1/2,x,z+3/4',
        '-x,-y,z',
        'y,-x+1/2,z+1/4',
        '-x+1/2,y+1/2,z',
        '-y+1/2,-x,z+1/4',
        'x,-y,z+1/2',
        'y,x+1/2,z+3/4',
    ],
    ncsym => [
        'x,y,z',
        '-y,x+1/2,z+1/4',
        '-x+1/2,-y+1/2,z+1/2',
        'y+1/2,-x,z+3/4',
        '-x,y,z+1/2',
        '-y,-x+1/2,z+3/4',
        'x+1/2,-y+1/2,z',
        'y+1/2,x,z+1/4',
    ]
},

{
    number          => 111,
    hall            => 'P -4 2',
    schoenflies     => 'D2d^1',
    hermann_mauguin => 'P -4 2 m',
    universal_h_m   => 'P -4 2 m',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'y,-x,-z',
        '-x,-y,z',
        '-y,x,-z',
        'x,-y,-z',
        '-y,-x,z',
        '-x,y,-z',
        'y,x,z',
    ],
    ncsym => [
        'x,y,z',
        'y,-x,-z',
        '-x,-y,z',
        '-y,x,-z',
        'x,-y,-z',
        '-y,-x,z',
        '-x,y,-z',
        'y,x,z',
    ]
},

{
    number          => 112,
    hall            => 'P -4 2c',
    schoenflies     => 'D2d^2',
    hermann_mauguin => 'P -4 2 c',
    universal_h_m   => 'P -4 2 c',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'y,-x,-z',
        '-x,-y,z',
        '-y,x,-z',
        'x,-y,-z+1/2',
        '-y,-x,z+1/2',
        '-x,y,-z+1/2',
        'y,x,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'y,-x,-z',
        '-x,-y,z',
        '-y,x,-z',
        'x,-y,-z+1/2',
        '-y,-x,z+1/2',
        '-x,y,-z+1/2',
        'y,x,z+1/2',
    ]
},

{
    number          => 113,
    hall            => 'P -4 2ab',
    schoenflies     => 'D2d^3',
    hermann_mauguin => 'P -4 21 m',
    universal_h_m   => 'P -4 21 m',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'y,-x,-z',
        '-x,-y,z',
        '-y,x,-z',
        'x+1/2,-y+1/2,-z',
        '-y+1/2,-x+1/2,z',
        '-x+1/2,y+1/2,-z',
        'y+1/2,x+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        'y,-x,-z',
        '-x,-y,z',
        '-y,x,-z',
        'x+1/2,-y+1/2,-z',
        '-y+1/2,-x+1/2,z',
        '-x+1/2,y+1/2,-z',
        'y+1/2,x+1/2,z',
    ]
},

{
    number          => 114,
    hall            => 'P -4 2n',
    schoenflies     => 'D2d^4',
    hermann_mauguin => 'P -4 21 c',
    universal_h_m   => 'P -4 21 c',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'y,-x,-z',
        '-x,-y,z',
        '-y,x,-z',
        'x+1/2,-y+1/2,-z+1/2',
        '-y+1/2,-x+1/2,z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        'y+1/2,x+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'y,-x,-z',
        '-x,-y,z',
        '-y,x,-z',
        'x+1/2,-y+1/2,-z+1/2',
        '-y+1/2,-x+1/2,z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        'y+1/2,x+1/2,z+1/2',
    ]
},

{
    number          => 115,
    hall            => 'P -4 -2',
    schoenflies     => 'D2d^5',
    hermann_mauguin => 'P -4 m 2',
    universal_h_m   => 'P -4 m 2',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'y,-x,-z',
        '-x,-y,z',
        '-y,x,-z',
        '-x,y,z',
        'y,x,-z',
        'x,-y,z',
        '-y,-x,-z',
    ],
    ncsym => [
        'x,y,z',
        'y,-x,-z',
        '-x,-y,z',
        '-y,x,-z',
        '-x,y,z',
        'y,x,-z',
        'x,-y,z',
        '-y,-x,-z',
    ]
},

{
    number          => 116,
    hall            => 'P -4 -2c',
    schoenflies     => 'D2d^6',
    hermann_mauguin => 'P -4 c 2',
    universal_h_m   => 'P -4 c 2',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'y,-x,-z',
        '-x,-y,z',
        '-y,x,-z',
        '-x,y,z+1/2',
        'y,x,-z+1/2',
        'x,-y,z+1/2',
        '-y,-x,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'y,-x,-z',
        '-x,-y,z',
        '-y,x,-z',
        '-x,y,z+1/2',
        'y,x,-z+1/2',
        'x,-y,z+1/2',
        '-y,-x,-z+1/2',
    ]
},

{
    number          => 117,
    hall            => 'P -4 -2ab',
    schoenflies     => 'D2d^7',
    hermann_mauguin => 'P -4 b 2',
    universal_h_m   => 'P -4 b 2',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'y,-x,-z',
        '-x,-y,z',
        '-y,x,-z',
        '-x+1/2,y+1/2,z',
        'y+1/2,x+1/2,-z',
        'x+1/2,-y+1/2,z',
        '-y+1/2,-x+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        'y,-x,-z',
        '-x,-y,z',
        '-y,x,-z',
        '-x+1/2,y+1/2,z',
        'y+1/2,x+1/2,-z',
        'x+1/2,-y+1/2,z',
        '-y+1/2,-x+1/2,-z',
    ]
},

{
    number          => 118,
    hall            => 'P -4 -2n',
    schoenflies     => 'D2d^8',
    hermann_mauguin => 'P -4 n 2',
    universal_h_m   => 'P -4 n 2',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'y,-x,-z',
        '-x,-y,z',
        '-y,x,-z',
        '-x+1/2,y+1/2,z+1/2',
        'y+1/2,x+1/2,-z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        '-y+1/2,-x+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'y,-x,-z',
        '-x,-y,z',
        '-y,x,-z',
        '-x+1/2,y+1/2,z+1/2',
        'y+1/2,x+1/2,-z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        '-y+1/2,-x+1/2,-z+1/2',
    ]
},

{
    number          => 119,
    hall            => 'I -4 -2',
    schoenflies     => 'D2d^9',
    hermann_mauguin => 'I -4 m 2',
    universal_h_m   => 'I -4 m 2',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'y,-x,-z',
        '-x,-y,z',
        '-y,x,-z',
        '-x,y,z',
        'y,x,-z',
        'x,-y,z',
        '-y,-x,-z',
        'x+1/2,y+1/2,z+1/2',
        'y+1/2,-x+1/2,-z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        '-y+1/2,x+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'y+1/2,x+1/2,-z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        '-y+1/2,-x+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'y,-x,-z',
        '-x,-y,z',
        '-y,x,-z',
        '-x,y,z',
        'y,x,-z',
        'x,-y,z',
        '-y,-x,-z',
    ]
},

{
    number          => 120,
    hall            => 'I -4 -2c',
    schoenflies     => 'D2d^10',
    hermann_mauguin => 'I -4 c 2',
    universal_h_m   => 'I -4 c 2',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'y,-x,-z',
        '-x,-y,z',
        '-y,x,-z',
        '-x,y,z+1/2',
        'y,x,-z+1/2',
        'x,-y,z+1/2',
        '-y,-x,-z+1/2',
        'x+1/2,y+1/2,z+1/2',
        'y+1/2,-x+1/2,-z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        '-y+1/2,x+1/2,-z+1/2',
        '-x+1/2,y+1/2,z',
        'y+1/2,x+1/2,-z',
        'x+1/2,-y+1/2,z',
        '-y+1/2,-x+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        'y,-x,-z',
        '-x,-y,z',
        '-y,x,-z',
        '-x,y,z+1/2',
        'y,x,-z+1/2',
        'x,-y,z+1/2',
        '-y,-x,-z+1/2',
    ]
},

{
    number          => 121,
    hall            => 'I -4 2',
    schoenflies     => 'D2d^11',
    hermann_mauguin => 'I -4 2 m',
    universal_h_m   => 'I -4 2 m',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'y,-x,-z',
        '-x,-y,z',
        '-y,x,-z',
        'x,-y,-z',
        '-y,-x,z',
        '-x,y,-z',
        'y,x,z',
        'x+1/2,y+1/2,z+1/2',
        'y+1/2,-x+1/2,-z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        '-y+1/2,x+1/2,-z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        '-y+1/2,-x+1/2,z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        'y+1/2,x+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'y,-x,-z',
        '-x,-y,z',
        '-y,x,-z',
        'x,-y,-z',
        '-y,-x,z',
        '-x,y,-z',
        'y,x,z',
    ]
},

{
    number          => 122,
    hall            => 'I -4 2bw',
    schoenflies     => 'D2d^12',
    hermann_mauguin => 'I -4 2 d',
    universal_h_m   => 'I -4 2 d',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'y,-x,-z',
        '-x,-y,z',
        '-y,x,-z',
        'x,-y+1/2,-z+1/4',
        '-y+1/2,-x,z+3/4',
        '-x,y+1/2,-z+1/4',
        'y+1/2,x,z+3/4',
        'x+1/2,y+1/2,z+1/2',
        'y+1/2,-x+1/2,-z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        '-y+1/2,x+1/2,-z+1/2',
        'x+1/2,-y,-z+3/4',
        '-y,-x+1/2,z+1/4',
        '-x+1/2,y,-z+3/4',
        'y,x+1/2,z+1/4',
    ],
    ncsym => [
        'x,y,z',
        'y,-x,-z',
        '-x,-y,z',
        '-y,x,-z',
        'x,-y+1/2,-z+1/4',
        '-y+1/2,-x,z+3/4',
        '-x,y+1/2,-z+1/4',
        'y+1/2,x,z+3/4',
    ]
},

{
    number          => 123,
    hall            => '-P 4 2',
    schoenflies     => 'D4h^1',
    hermann_mauguin => 'P 4/m m m',
    universal_h_m   => 'P 4/m m m',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x,-y,-z',
        'y,x,-z',
        '-x,y,-z',
        '-y,-x,-z',
        '-x,-y,-z',
        'y,-x,-z',
        'x,y,-z',
        '-y,x,-z',
        '-x,y,z',
        '-y,-x,z',
        'x,-y,z',
        'y,x,z',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x,-y,-z',
        'y,x,-z',
        '-x,y,-z',
        '-y,-x,-z',
        '-x,-y,-z',
        'y,-x,-z',
        'x,y,-z',
        '-y,x,-z',
        '-x,y,z',
        '-y,-x,z',
        'x,-y,z',
        'y,x,z',
    ]
},

{
    number          => 124,
    hall            => '-P 4 2c',
    schoenflies     => 'D4h^2',
    hermann_mauguin => 'P 4/m c c',
    universal_h_m   => 'P 4/m c c',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x,-y,-z+1/2',
        'y,x,-z+1/2',
        '-x,y,-z+1/2',
        '-y,-x,-z+1/2',
        '-x,-y,-z',
        'y,-x,-z',
        'x,y,-z',
        '-y,x,-z',
        '-x,y,z+1/2',
        '-y,-x,z+1/2',
        'x,-y,z+1/2',
        'y,x,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x,-y,-z+1/2',
        'y,x,-z+1/2',
        '-x,y,-z+1/2',
        '-y,-x,-z+1/2',
        '-x,-y,-z',
        'y,-x,-z',
        'x,y,-z',
        '-y,x,-z',
        '-x,y,z+1/2',
        '-y,-x,z+1/2',
        'x,-y,z+1/2',
        'y,x,z+1/2',
    ]
},

{
    number          => 125,
    hall            => 'P 4 2 -1ab',
    schoenflies     => 'D4h^3',
    hermann_mauguin => 'P 4/n b m',
    universal_h_m   => 'P 4/n b m :1',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x,-y,-z',
        'y,x,-z',
        '-x,y,-z',
        '-y,-x,-z',
        '-x+1/2,-y+1/2,-z',
        'y+1/2,-x+1/2,-z',
        'x+1/2,y+1/2,-z',
        '-y+1/2,x+1/2,-z',
        '-x+1/2,y+1/2,z',
        '-y+1/2,-x+1/2,z',
        'x+1/2,-y+1/2,z',
        'y+1/2,x+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x,-y,-z',
        'y,x,-z',
        '-x,y,-z',
        '-y,-x,-z',
        '-x+1/2,-y+1/2,-z',
        'y+1/2,-x+1/2,-z',
        'x+1/2,y+1/2,-z',
        '-y+1/2,x+1/2,-z',
        '-x+1/2,y+1/2,z',
        '-y+1/2,-x+1/2,z',
        'x+1/2,-y+1/2,z',
        'y+1/2,x+1/2,z',
    ]
},

{
    number          => 125,
    hall            => '-P 4a 2b',
    schoenflies     => 'D4h^3',
    hermann_mauguin => 'P 4/n b m',
    universal_h_m   => 'P 4/n b m :2',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x,z',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z',
        'x,-y+1/2,-z',
        'y,x,-z',
        '-x+1/2,y,-z',
        '-y+1/2,-x+1/2,-z',
        '-x,-y,-z',
        'y+1/2,-x,-z',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z',
        '-x,y+1/2,z',
        '-y,-x,z',
        'x+1/2,-y,z',
        'y+1/2,x+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x,z',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z',
        'x,-y+1/2,-z',
        'y,x,-z',
        '-x+1/2,y,-z',
        '-y+1/2,-x+1/2,-z',
        '-x,-y,-z',
        'y+1/2,-x,-z',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z',
        '-x,y+1/2,z',
        '-y,-x,z',
        'x+1/2,-y,z',
        'y+1/2,x+1/2,z',
    ]
},

{
    number          => 126,
    hall            => 'P 4 2 -1n',
    schoenflies     => 'D4h^4',
    hermann_mauguin => 'P 4/n n c',
    universal_h_m   => 'P 4/n n c :1',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x,-y,-z',
        'y,x,-z',
        '-x,y,-z',
        '-y,-x,-z',
        '-x+1/2,-y+1/2,-z+1/2',
        'y+1/2,-x+1/2,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-y+1/2,x+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        '-y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        'y+1/2,x+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x,-y,-z',
        'y,x,-z',
        '-x,y,-z',
        '-y,-x,-z',
        '-x+1/2,-y+1/2,-z+1/2',
        'y+1/2,-x+1/2,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-y+1/2,x+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        '-y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        'y+1/2,x+1/2,z+1/2',
    ]
},

{
    number          => 126,
    hall            => '-P 4a 2bc',
    schoenflies     => 'D4h^4',
    hermann_mauguin => 'P 4/n n c',
    universal_h_m   => 'P 4/n n c :2',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x,z',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z',
        'x,-y+1/2,-z+1/2',
        'y,x,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-y+1/2,-x+1/2,-z+1/2',
        '-x,-y,-z',
        'y+1/2,-x,-z',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z',
        '-x,y+1/2,z+1/2',
        '-y,-x,z+1/2',
        'x+1/2,-y,z+1/2',
        'y+1/2,x+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x,z',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z',
        'x,-y+1/2,-z+1/2',
        'y,x,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-y+1/2,-x+1/2,-z+1/2',
        '-x,-y,-z',
        'y+1/2,-x,-z',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z',
        '-x,y+1/2,z+1/2',
        '-y,-x,z+1/2',
        'x+1/2,-y,z+1/2',
        'y+1/2,x+1/2,z+1/2',
    ]
},

{
    number          => 127,
    hall            => '-P 4 2ab',
    schoenflies     => 'D4h^5',
    hermann_mauguin => 'P 4/m b m',
    universal_h_m   => 'P 4/m b m',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x+1/2,-y+1/2,-z',
        'y+1/2,x+1/2,-z',
        '-x+1/2,y+1/2,-z',
        '-y+1/2,-x+1/2,-z',
        '-x,-y,-z',
        'y,-x,-z',
        'x,y,-z',
        '-y,x,-z',
        '-x+1/2,y+1/2,z',
        '-y+1/2,-x+1/2,z',
        'x+1/2,-y+1/2,z',
        'y+1/2,x+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x+1/2,-y+1/2,-z',
        'y+1/2,x+1/2,-z',
        '-x+1/2,y+1/2,-z',
        '-y+1/2,-x+1/2,-z',
        '-x,-y,-z',
        'y,-x,-z',
        'x,y,-z',
        '-y,x,-z',
        '-x+1/2,y+1/2,z',
        '-y+1/2,-x+1/2,z',
        'x+1/2,-y+1/2,z',
        'y+1/2,x+1/2,z',
    ]
},

{
    number          => 128,
    hall            => '-P 4 2n',
    schoenflies     => 'D4h^6',
    hermann_mauguin => 'P 4/m n c',
    universal_h_m   => 'P 4/m n c',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x+1/2,-y+1/2,-z+1/2',
        'y+1/2,x+1/2,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-y+1/2,-x+1/2,-z+1/2',
        '-x,-y,-z',
        'y,-x,-z',
        'x,y,-z',
        '-y,x,-z',
        '-x+1/2,y+1/2,z+1/2',
        '-y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        'y+1/2,x+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x+1/2,-y+1/2,-z+1/2',
        'y+1/2,x+1/2,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-y+1/2,-x+1/2,-z+1/2',
        '-x,-y,-z',
        'y,-x,-z',
        'x,y,-z',
        '-y,x,-z',
        '-x+1/2,y+1/2,z+1/2',
        '-y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        'y+1/2,x+1/2,z+1/2',
    ]
},

{
    number          => 129,
    hall            => 'P 4ab 2ab -1ab',
    schoenflies     => 'D4h^7',
    hermann_mauguin => 'P 4/n m m',
    universal_h_m   => 'P 4/n m m :1',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x+1/2,z',
        '-x,-y,z',
        'y+1/2,-x+1/2,z',
        'x+1/2,-y+1/2,-z',
        'y,x,-z',
        '-x+1/2,y+1/2,-z',
        '-y,-x,-z',
        '-x+1/2,-y+1/2,-z',
        'y,-x,-z',
        'x+1/2,y+1/2,-z',
        '-y,x,-z',
        '-x,y,z',
        '-y+1/2,-x+1/2,z',
        'x,-y,z',
        'y+1/2,x+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x+1/2,z',
        '-x,-y,z',
        'y+1/2,-x+1/2,z',
        'x+1/2,-y+1/2,-z',
        'y,x,-z',
        '-x+1/2,y+1/2,-z',
        '-y,-x,-z',
        '-x+1/2,-y+1/2,-z',
        'y,-x,-z',
        'x+1/2,y+1/2,-z',
        '-y,x,-z',
        '-x,y,z',
        '-y+1/2,-x+1/2,z',
        'x,-y,z',
        'y+1/2,x+1/2,z',
    ]
},

{
    number          => 129,
    hall            => '-P 4a 2a',
    schoenflies     => 'D4h^7',
    hermann_mauguin => 'P 4/n m m',
    universal_h_m   => 'P 4/n m m :2',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x,z',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z',
        'x+1/2,-y,-z',
        'y+1/2,x+1/2,-z',
        '-x,y+1/2,-z',
        '-y,-x,-z',
        '-x,-y,-z',
        'y+1/2,-x,-z',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z',
        '-x+1/2,y,z',
        '-y+1/2,-x+1/2,z',
        'x,-y+1/2,z',
        'y,x,z',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x,z',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z',
        'x+1/2,-y,-z',
        'y+1/2,x+1/2,-z',
        '-x,y+1/2,-z',
        '-y,-x,-z',
        '-x,-y,-z',
        'y+1/2,-x,-z',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z',
        '-x+1/2,y,z',
        '-y+1/2,-x+1/2,z',
        'x,-y+1/2,z',
        'y,x,z',
    ]
},

{
    number          => 130,
    hall            => 'P 4ab 2n -1ab',
    schoenflies     => 'D4h^8',
    hermann_mauguin => 'P 4/n c c',
    universal_h_m   => 'P 4/n c c :1',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x+1/2,z',
        '-x,-y,z',
        'y+1/2,-x+1/2,z',
        'x+1/2,-y+1/2,-z+1/2',
        'y,x,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-y,-x,-z+1/2',
        '-x+1/2,-y+1/2,-z',
        'y,-x,-z',
        'x+1/2,y+1/2,-z',
        '-y,x,-z',
        '-x,y,z+1/2',
        '-y+1/2,-x+1/2,z+1/2',
        'x,-y,z+1/2',
        'y+1/2,x+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x+1/2,z',
        '-x,-y,z',
        'y+1/2,-x+1/2,z',
        'x+1/2,-y+1/2,-z+1/2',
        'y,x,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-y,-x,-z+1/2',
        '-x+1/2,-y+1/2,-z',
        'y,-x,-z',
        'x+1/2,y+1/2,-z',
        '-y,x,-z',
        '-x,y,z+1/2',
        '-y+1/2,-x+1/2,z+1/2',
        'x,-y,z+1/2',
        'y+1/2,x+1/2,z+1/2',
    ]
},

{
    number          => 130,
    hall            => '-P 4a 2ac',
    schoenflies     => 'D4h^8',
    hermann_mauguin => 'P 4/n c c',
    universal_h_m   => 'P 4/n c c :2',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x,z',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z',
        'x+1/2,-y,-z+1/2',
        'y+1/2,x+1/2,-z+1/2',
        '-x,y+1/2,-z+1/2',
        '-y,-x,-z+1/2',
        '-x,-y,-z',
        'y+1/2,-x,-z',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z',
        '-x+1/2,y,z+1/2',
        '-y+1/2,-x+1/2,z+1/2',
        'x,-y+1/2,z+1/2',
        'y,x,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x,z',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z',
        'x+1/2,-y,-z+1/2',
        'y+1/2,x+1/2,-z+1/2',
        '-x,y+1/2,-z+1/2',
        '-y,-x,-z+1/2',
        '-x,-y,-z',
        'y+1/2,-x,-z',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z',
        '-x+1/2,y,z+1/2',
        '-y+1/2,-x+1/2,z+1/2',
        'x,-y+1/2,z+1/2',
        'y,x,z+1/2',
    ]
},

{
    number          => 131,
    hall            => '-P 4c 2',
    schoenflies     => 'D4h^9',
    hermann_mauguin => 'P 42/m m c',
    universal_h_m   => 'P 42/m m c',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z+1/2',
        '-x,-y,z',
        'y,-x,z+1/2',
        'x,-y,-z',
        'y,x,-z+1/2',
        '-x,y,-z',
        '-y,-x,-z+1/2',
        '-x,-y,-z',
        'y,-x,-z+1/2',
        'x,y,-z',
        '-y,x,-z+1/2',
        '-x,y,z',
        '-y,-x,z+1/2',
        'x,-y,z',
        'y,x,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z+1/2',
        '-x,-y,z',
        'y,-x,z+1/2',
        'x,-y,-z',
        'y,x,-z+1/2',
        '-x,y,-z',
        '-y,-x,-z+1/2',
        '-x,-y,-z',
        'y,-x,-z+1/2',
        'x,y,-z',
        '-y,x,-z+1/2',
        '-x,y,z',
        '-y,-x,z+1/2',
        'x,-y,z',
        'y,x,z+1/2',
    ]
},

{
    number          => 132,
    hall            => '-P 4c 2c',
    schoenflies     => 'D4h^10',
    hermann_mauguin => 'P 42/m c m',
    universal_h_m   => 'P 42/m c m',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z+1/2',
        '-x,-y,z',
        'y,-x,z+1/2',
        'x,-y,-z+1/2',
        'y,x,-z',
        '-x,y,-z+1/2',
        '-y,-x,-z',
        '-x,-y,-z',
        'y,-x,-z+1/2',
        'x,y,-z',
        '-y,x,-z+1/2',
        '-x,y,z+1/2',
        '-y,-x,z',
        'x,-y,z+1/2',
        'y,x,z',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z+1/2',
        '-x,-y,z',
        'y,-x,z+1/2',
        'x,-y,-z+1/2',
        'y,x,-z',
        '-x,y,-z+1/2',
        '-y,-x,-z',
        '-x,-y,-z',
        'y,-x,-z+1/2',
        'x,y,-z',
        '-y,x,-z+1/2',
        '-x,y,z+1/2',
        '-y,-x,z',
        'x,-y,z+1/2',
        'y,x,z',
    ]
},

{
    number          => 133,
    hall            => 'P 4n 2c -1n',
    schoenflies     => 'D4h^11',
    hermann_mauguin => 'P 42/n b c',
    universal_h_m   => 'P 42/n b c :1',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x+1/2,z+1/2',
        '-x,-y,z',
        'y+1/2,-x+1/2,z+1/2',
        'x,-y,-z+1/2',
        'y+1/2,x+1/2,-z',
        '-x,y,-z+1/2',
        '-y+1/2,-x+1/2,-z',
        '-x+1/2,-y+1/2,-z+1/2',
        'y,-x,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-y,x,-z',
        '-x+1/2,y+1/2,z',
        '-y,-x,z+1/2',
        'x+1/2,-y+1/2,z',
        'y,x,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x+1/2,z+1/2',
        '-x,-y,z',
        'y+1/2,-x+1/2,z+1/2',
        'x,-y,-z+1/2',
        'y+1/2,x+1/2,-z',
        '-x,y,-z+1/2',
        '-y+1/2,-x+1/2,-z',
        '-x+1/2,-y+1/2,-z+1/2',
        'y,-x,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-y,x,-z',
        '-x+1/2,y+1/2,z',
        '-y,-x,z+1/2',
        'x+1/2,-y+1/2,z',
        'y,x,z+1/2',
    ]
},

{
    number          => 133,
    hall            => '-P 4ac 2b',
    schoenflies     => 'D4h^11',
    hermann_mauguin => 'P 42/n b c',
    universal_h_m   => 'P 42/n b c :2',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x,z+1/2',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z+1/2',
        'x,-y+1/2,-z',
        'y,x,-z+1/2',
        '-x+1/2,y,-z',
        '-y+1/2,-x+1/2,-z+1/2',
        '-x,-y,-z',
        'y+1/2,-x,-z+1/2',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z+1/2',
        '-x,y+1/2,z',
        '-y,-x,z+1/2',
        'x+1/2,-y,z',
        'y+1/2,x+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x,z+1/2',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z+1/2',
        'x,-y+1/2,-z',
        'y,x,-z+1/2',
        '-x+1/2,y,-z',
        '-y+1/2,-x+1/2,-z+1/2',
        '-x,-y,-z',
        'y+1/2,-x,-z+1/2',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z+1/2',
        '-x,y+1/2,z',
        '-y,-x,z+1/2',
        'x+1/2,-y,z',
        'y+1/2,x+1/2,z+1/2',
    ]
},

{
    number          => 134,
    hall            => 'P 4n 2 -1n',
    schoenflies     => 'D4h^12',
    hermann_mauguin => 'P 42/n n m',
    universal_h_m   => 'P 42/n n m :1',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x+1/2,z+1/2',
        '-x,-y,z',
        'y+1/2,-x+1/2,z+1/2',
        'x,-y,-z',
        'y+1/2,x+1/2,-z+1/2',
        '-x,y,-z',
        '-y+1/2,-x+1/2,-z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        'y,-x,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-y,x,-z',
        '-x+1/2,y+1/2,z+1/2',
        '-y,-x,z',
        'x+1/2,-y+1/2,z+1/2',
        'y,x,z',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x+1/2,z+1/2',
        '-x,-y,z',
        'y+1/2,-x+1/2,z+1/2',
        'x,-y,-z',
        'y+1/2,x+1/2,-z+1/2',
        '-x,y,-z',
        '-y+1/2,-x+1/2,-z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        'y,-x,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-y,x,-z',
        '-x+1/2,y+1/2,z+1/2',
        '-y,-x,z',
        'x+1/2,-y+1/2,z+1/2',
        'y,x,z',
    ]
},

{
    number          => 134,
    hall            => '-P 4ac 2bc',
    schoenflies     => 'D4h^12',
    hermann_mauguin => 'P 42/n n m',
    universal_h_m   => 'P 42/n n m :2',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x,z+1/2',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z+1/2',
        'x,-y+1/2,-z+1/2',
        'y,x,-z',
        '-x+1/2,y,-z+1/2',
        '-y+1/2,-x+1/2,-z',
        '-x,-y,-z',
        'y+1/2,-x,-z+1/2',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z+1/2',
        '-x,y+1/2,z+1/2',
        '-y,-x,z',
        'x+1/2,-y,z+1/2',
        'y+1/2,x+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x,z+1/2',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z+1/2',
        'x,-y+1/2,-z+1/2',
        'y,x,-z',
        '-x+1/2,y,-z+1/2',
        '-y+1/2,-x+1/2,-z',
        '-x,-y,-z',
        'y+1/2,-x,-z+1/2',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z+1/2',
        '-x,y+1/2,z+1/2',
        '-y,-x,z',
        'x+1/2,-y,z+1/2',
        'y+1/2,x+1/2,z',
    ]
},

{
    number          => 135,
    hall            => '-P 4c 2ab',
    schoenflies     => 'D4h^13',
    hermann_mauguin => 'P 42/m b c',
    universal_h_m   => 'P 42/m b c',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z+1/2',
        '-x,-y,z',
        'y,-x,z+1/2',
        'x+1/2,-y+1/2,-z',
        'y+1/2,x+1/2,-z+1/2',
        '-x+1/2,y+1/2,-z',
        '-y+1/2,-x+1/2,-z+1/2',
        '-x,-y,-z',
        'y,-x,-z+1/2',
        'x,y,-z',
        '-y,x,-z+1/2',
        '-x+1/2,y+1/2,z',
        '-y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y+1/2,z',
        'y+1/2,x+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z+1/2',
        '-x,-y,z',
        'y,-x,z+1/2',
        'x+1/2,-y+1/2,-z',
        'y+1/2,x+1/2,-z+1/2',
        '-x+1/2,y+1/2,-z',
        '-y+1/2,-x+1/2,-z+1/2',
        '-x,-y,-z',
        'y,-x,-z+1/2',
        'x,y,-z',
        '-y,x,-z+1/2',
        '-x+1/2,y+1/2,z',
        '-y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y+1/2,z',
        'y+1/2,x+1/2,z+1/2',
    ]
},

{
    number          => 136,
    hall            => '-P 4n 2n',
    schoenflies     => 'D4h^14',
    hermann_mauguin => 'P 42/m n m',
    universal_h_m   => 'P 42/m n m',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x+1/2,z+1/2',
        '-x,-y,z',
        'y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        'y,x,-z',
        '-x+1/2,y+1/2,-z+1/2',
        '-y,-x,-z',
        '-x,-y,-z',
        'y+1/2,-x+1/2,-z+1/2',
        'x,y,-z',
        '-y+1/2,x+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        '-y,-x,z',
        'x+1/2,-y+1/2,z+1/2',
        'y,x,z',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x+1/2,z+1/2',
        '-x,-y,z',
        'y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        'y,x,-z',
        '-x+1/2,y+1/2,-z+1/2',
        '-y,-x,-z',
        '-x,-y,-z',
        'y+1/2,-x+1/2,-z+1/2',
        'x,y,-z',
        '-y+1/2,x+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        '-y,-x,z',
        'x+1/2,-y+1/2,z+1/2',
        'y,x,z',
    ]
},

{
    number          => 137,
    hall            => 'P 4n 2n -1n',
    schoenflies     => 'D4h^15',
    hermann_mauguin => 'P 42/n m c',
    universal_h_m   => 'P 42/n m c :1',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x+1/2,z+1/2',
        '-x,-y,z',
        'y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        'y,x,-z',
        '-x+1/2,y+1/2,-z+1/2',
        '-y,-x,-z',
        '-x+1/2,-y+1/2,-z+1/2',
        'y,-x,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-y,x,-z',
        '-x,y,z',
        '-y+1/2,-x+1/2,z+1/2',
        'x,-y,z',
        'y+1/2,x+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x+1/2,z+1/2',
        '-x,-y,z',
        'y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        'y,x,-z',
        '-x+1/2,y+1/2,-z+1/2',
        '-y,-x,-z',
        '-x+1/2,-y+1/2,-z+1/2',
        'y,-x,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-y,x,-z',
        '-x,y,z',
        '-y+1/2,-x+1/2,z+1/2',
        'x,-y,z',
        'y+1/2,x+1/2,z+1/2',
    ]
},

{
    number          => 137,
    hall            => '-P 4ac 2a',
    schoenflies     => 'D4h^15',
    hermann_mauguin => 'P 42/n m c',
    universal_h_m   => 'P 42/n m c :2',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x,z+1/2',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z+1/2',
        'x+1/2,-y,-z',
        'y+1/2,x+1/2,-z+1/2',
        '-x,y+1/2,-z',
        '-y,-x,-z+1/2',
        '-x,-y,-z',
        'y+1/2,-x,-z+1/2',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z+1/2',
        '-x+1/2,y,z',
        '-y+1/2,-x+1/2,z+1/2',
        'x,-y+1/2,z',
        'y,x,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x,z+1/2',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z+1/2',
        'x+1/2,-y,-z',
        'y+1/2,x+1/2,-z+1/2',
        '-x,y+1/2,-z',
        '-y,-x,-z+1/2',
        '-x,-y,-z',
        'y+1/2,-x,-z+1/2',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z+1/2',
        '-x+1/2,y,z',
        '-y+1/2,-x+1/2,z+1/2',
        'x,-y+1/2,z',
        'y,x,z+1/2',
    ]
},

{
    number          => 138,
    hall            => 'P 4n 2ab -1n',
    schoenflies     => 'D4h^16',
    hermann_mauguin => 'P 42/n c m',
    universal_h_m   => 'P 42/n c m :1',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x+1/2,z+1/2',
        '-x,-y,z',
        'y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y+1/2,-z',
        'y,x,-z+1/2',
        '-x+1/2,y+1/2,-z',
        '-y,-x,-z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        'y,-x,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-y,x,-z',
        '-x,y,z+1/2',
        '-y+1/2,-x+1/2,z',
        'x,-y,z+1/2',
        'y+1/2,x+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x+1/2,z+1/2',
        '-x,-y,z',
        'y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y+1/2,-z',
        'y,x,-z+1/2',
        '-x+1/2,y+1/2,-z',
        '-y,-x,-z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        'y,-x,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-y,x,-z',
        '-x,y,z+1/2',
        '-y+1/2,-x+1/2,z',
        'x,-y,z+1/2',
        'y+1/2,x+1/2,z',
    ]
},

{
    number          => 138,
    hall            => '-P 4ac 2ac',
    schoenflies     => 'D4h^16',
    hermann_mauguin => 'P 42/n c m',
    universal_h_m   => 'P 42/n c m :2',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x,z+1/2',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z+1/2',
        'x+1/2,-y,-z+1/2',
        'y+1/2,x+1/2,-z',
        '-x,y+1/2,-z+1/2',
        '-y,-x,-z',
        '-x,-y,-z',
        'y+1/2,-x,-z+1/2',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z+1/2',
        '-x+1/2,y,z+1/2',
        '-y+1/2,-x+1/2,z',
        'x,-y+1/2,z+1/2',
        'y,x,z',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x,z+1/2',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z+1/2',
        'x+1/2,-y,-z+1/2',
        'y+1/2,x+1/2,-z',
        '-x,y+1/2,-z+1/2',
        '-y,-x,-z',
        '-x,-y,-z',
        'y+1/2,-x,-z+1/2',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z+1/2',
        '-x+1/2,y,z+1/2',
        '-y+1/2,-x+1/2,z',
        'x,-y+1/2,z+1/2',
        'y,x,z',
    ]
},

{
    number          => 139,
    hall            => '-I 4 2',
    schoenflies     => 'D4h^17',
    hermann_mauguin => 'I 4/m m m',
    universal_h_m   => 'I 4/m m m',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x,-y,-z',
        'y,x,-z',
        '-x,y,-z',
        '-y,-x,-z',
        '-x,-y,-z',
        'y,-x,-z',
        'x,y,-z',
        '-y,x,-z',
        '-x,y,z',
        '-y,-x,z',
        'x,-y,z',
        'y,x,z',
        'x+1/2,y+1/2,z+1/2',
        '-y+1/2,x+1/2,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        'y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        'y+1/2,x+1/2,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-y+1/2,-x+1/2,-z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        'y+1/2,-x+1/2,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-y+1/2,x+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        '-y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        'y+1/2,x+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x,-y,-z',
        'y,x,-z',
        '-x,y,-z',
        '-y,-x,-z',
        '-x,-y,-z',
        'y,-x,-z',
        'x,y,-z',
        '-y,x,-z',
        '-x,y,z',
        '-y,-x,z',
        'x,-y,z',
        'y,x,z',
    ]
},

{
    number          => 140,
    hall            => '-I 4 2c',
    schoenflies     => 'D4h^18',
    hermann_mauguin => 'I 4/m c m',
    universal_h_m   => 'I 4/m c m',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x,-y,-z+1/2',
        'y,x,-z+1/2',
        '-x,y,-z+1/2',
        '-y,-x,-z+1/2',
        '-x,-y,-z',
        'y,-x,-z',
        'x,y,-z',
        '-y,x,-z',
        '-x,y,z+1/2',
        '-y,-x,z+1/2',
        'x,-y,z+1/2',
        'y,x,z+1/2',
        'x+1/2,y+1/2,z+1/2',
        '-y+1/2,x+1/2,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        'y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y+1/2,-z',
        'y+1/2,x+1/2,-z',
        '-x+1/2,y+1/2,-z',
        '-y+1/2,-x+1/2,-z',
        '-x+1/2,-y+1/2,-z+1/2',
        'y+1/2,-x+1/2,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-y+1/2,x+1/2,-z+1/2',
        '-x+1/2,y+1/2,z',
        '-y+1/2,-x+1/2,z',
        'x+1/2,-y+1/2,z',
        'y+1/2,x+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x,-y,-z+1/2',
        'y,x,-z+1/2',
        '-x,y,-z+1/2',
        '-y,-x,-z+1/2',
        '-x,-y,-z',
        'y,-x,-z',
        'x,y,-z',
        '-y,x,-z',
        '-x,y,z+1/2',
        '-y,-x,z+1/2',
        'x,-y,z+1/2',
        'y,x,z+1/2',
    ]
},

{
    number          => 141,
    hall            => 'I 4bw 2bw -1bw',
    schoenflies     => 'D4h^19',
    hermann_mauguin => 'I 41/a m d',
    universal_h_m   => 'I 41/a m d :1',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x+1/2,z+1/4',
        '-x+1/2,-y+1/2,z+1/2',
        'y+1/2,-x,z+3/4',
        'x,-y+1/2,-z+1/4',
        'y+1/2,x+1/2,-z+1/2',
        '-x+1/2,y,-z+3/4',
        '-y,-x,-z',
        '-x,-y+1/2,-z+1/4',
        'y,-x,-z',
        'x+1/2,y,-z+3/4',
        '-y+1/2,x+1/2,-z+1/2',
        '-x,y,z',
        '-y+1/2,-x,z+3/4',
        'x+1/2,-y+1/2,z+1/2',
        'y,x+1/2,z+1/4',
        'x+1/2,y+1/2,z+1/2',
        '-y+1/2,x,z+3/4',
        '-x,-y,z',
        'y,-x+1/2,z+1/4',
        'x+1/2,-y,-z+3/4',
        'y,x,-z',
        '-x,y+1/2,-z+1/4',
        '-y+1/2,-x+1/2,-z+1/2',
        '-x+1/2,-y,-z+3/4',
        'y+1/2,-x+1/2,-z+1/2',
        'x,y+1/2,-z+1/4',
        '-y,x,-z',
        '-x+1/2,y+1/2,z+1/2',
        '-y,-x+1/2,z+1/4',
        'x,-y,z',
        'y+1/2,x,z+3/4',
    ],
    ncsym => [
        'x,y,z',
        '-y,x+1/2,z+1/4',
        '-x+1/2,-y+1/2,z+1/2',
        'y+1/2,-x,z+3/4',
        'x,-y+1/2,-z+1/4',
        'y+1/2,x+1/2,-z+1/2',
        '-x+1/2,y,-z+3/4',
        '-y,-x,-z',
        '-x,-y+1/2,-z+1/4',
        'y,-x,-z',
        'x+1/2,y,-z+3/4',
        '-y+1/2,x+1/2,-z+1/2',
        '-x,y,z',
        '-y+1/2,-x,z+3/4',
        'x+1/2,-y+1/2,z+1/2',
        'y,x+1/2,z+1/4',
    ]
},

{
    number          => 141,
    hall            => '-I 4bd 2',
    schoenflies     => 'D4h^19',
    hermann_mauguin => 'I 41/a m d',
    universal_h_m   => 'I 41/a m d :2',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/4,x+3/4,z+1/4',
        '-x+1/2,-y,z+1/2',
        'y+1/4,-x+1/4,z+3/4',
        'x,-y,-z',
        'y+1/4,x+3/4,-z+1/4',
        '-x+1/2,y,-z+1/2',
        '-y+1/4,-x+1/4,-z+3/4',
        '-x,-y,-z',
        'y+3/4,-x+1/4,-z+3/4',
        'x+1/2,y,-z+1/2',
        '-y+3/4,x+3/4,-z+1/4',
        '-x,y,z',
        '-y+3/4,-x+1/4,z+3/4',
        'x+1/2,-y,z+1/2',
        'y+3/4,x+3/4,z+1/4',
        'x+1/2,y+1/2,z+1/2',
        '-y+3/4,x+1/4,z+3/4',
        '-x,-y+1/2,z',
        'y+3/4,-x+3/4,z+1/4',
        'x+1/2,-y+1/2,-z+1/2',
        'y+3/4,x+1/4,-z+3/4',
        '-x,y+1/2,-z',
        '-y+3/4,-x+3/4,-z+1/4',
        '-x+1/2,-y+1/2,-z+1/2',
        'y+1/4,-x+3/4,-z+1/4',
        'x,y+1/2,-z',
        '-y+1/4,x+1/4,-z+3/4',
        '-x+1/2,y+1/2,z+1/2',
        '-y+1/4,-x+3/4,z+1/4',
        'x,-y+1/2,z',
        'y+1/4,x+1/4,z+3/4',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/4,x+3/4,z+1/4',
        '-x+1/2,-y,z+1/2',
        'y+1/4,-x+1/4,z+3/4',
        'x,-y,-z',
        'y+1/4,x+3/4,-z+1/4',
        '-x+1/2,y,-z+1/2',
        '-y+1/4,-x+1/4,-z+3/4',
        '-x,-y,-z',
        'y+3/4,-x+1/4,-z+3/4',
        'x+1/2,y,-z+1/2',
        '-y+3/4,x+3/4,-z+1/4',
        '-x,y,z',
        '-y+3/4,-x+1/4,z+3/4',
        'x+1/2,-y,z+1/2',
        'y+3/4,x+3/4,z+1/4',
    ]
},

{
    number          => 142,
    hall            => 'I 4bw 2aw -1bw',
    schoenflies     => 'D4h^20',
    hermann_mauguin => 'I 41/a c d',
    universal_h_m   => 'I 41/a c d :1',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x+1/2,z+1/4',
        '-x+1/2,-y+1/2,z+1/2',
        'y+1/2,-x,z+3/4',
        'x+1/2,-y,-z+1/4',
        'y,x,-z+1/2',
        '-x,y+1/2,-z+3/4',
        '-y+1/2,-x+1/2,-z',
        '-x,-y+1/2,-z+1/4',
        'y,-x,-z',
        'x+1/2,y,-z+3/4',
        '-y+1/2,x+1/2,-z+1/2',
        '-x+1/2,y+1/2,z',
        '-y,-x+1/2,z+3/4',
        'x,-y,z+1/2',
        'y+1/2,x,z+1/4',
        'x+1/2,y+1/2,z+1/2',
        '-y+1/2,x,z+3/4',
        '-x,-y,z',
        'y,-x+1/2,z+1/4',
        'x,-y+1/2,-z+3/4',
        'y+1/2,x+1/2,-z',
        '-x+1/2,y,-z+1/4',
        '-y,-x,-z+1/2',
        '-x+1/2,-y,-z+3/4',
        'y+1/2,-x+1/2,-z+1/2',
        'x,y+1/2,-z+1/4',
        '-y,x,-z',
        '-x,y,z+1/2',
        '-y+1/2,-x,z+1/4',
        'x+1/2,-y+1/2,z',
        'y,x+1/2,z+3/4',
    ],
    ncsym => [
        'x,y,z',
        '-y,x+1/2,z+1/4',
        '-x+1/2,-y+1/2,z+1/2',
        'y+1/2,-x,z+3/4',
        'x+1/2,-y,-z+1/4',
        'y,x,-z+1/2',
        '-x,y+1/2,-z+3/4',
        '-y+1/2,-x+1/2,-z',
        '-x,-y+1/2,-z+1/4',
        'y,-x,-z',
        'x+1/2,y,-z+3/4',
        '-y+1/2,x+1/2,-z+1/2',
        '-x+1/2,y+1/2,z',
        '-y,-x+1/2,z+3/4',
        'x,-y,z+1/2',
        'y+1/2,x,z+1/4',
    ]
},

{
    number          => 142,
    hall            => '-I 4bd 2c',
    schoenflies     => 'D4h^20',
    hermann_mauguin => 'I 41/a c d',
    universal_h_m   => 'I 41/a c d :2',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/4,x+3/4,z+1/4',
        '-x+1/2,-y,z+1/2',
        'y+1/4,-x+1/4,z+3/4',
        'x,-y,-z+1/2',
        'y+1/4,x+3/4,-z+3/4',
        '-x+1/2,y,-z',
        '-y+1/4,-x+1/4,-z+1/4',
        '-x,-y,-z',
        'y+3/4,-x+1/4,-z+3/4',
        'x+1/2,y,-z+1/2',
        '-y+3/4,x+3/4,-z+1/4',
        '-x,y,z+1/2',
        '-y+3/4,-x+1/4,z+1/4',
        'x+1/2,-y,z',
        'y+3/4,x+3/4,z+3/4',
        'x+1/2,y+1/2,z+1/2',
        '-y+3/4,x+1/4,z+3/4',
        '-x,-y+1/2,z',
        'y+3/4,-x+3/4,z+1/4',
        'x+1/2,-y+1/2,-z',
        'y+3/4,x+1/4,-z+1/4',
        '-x,y+1/2,-z+1/2',
        '-y+3/4,-x+3/4,-z+3/4',
        '-x+1/2,-y+1/2,-z+1/2',
        'y+1/4,-x+3/4,-z+1/4',
        'x,y+1/2,-z',
        '-y+1/4,x+1/4,-z+3/4',
        '-x+1/2,y+1/2,z',
        '-y+1/4,-x+3/4,z+3/4',
        'x,-y+1/2,z+1/2',
        'y+1/4,x+1/4,z+1/4',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/4,x+3/4,z+1/4',
        '-x+1/2,-y,z+1/2',
        'y+1/4,-x+1/4,z+3/4',
        'x,-y,-z+1/2',
        'y+1/4,x+3/4,-z+3/4',
        '-x+1/2,y,-z',
        '-y+1/4,-x+1/4,-z+1/4',
        '-x,-y,-z',
        'y+3/4,-x+1/4,-z+3/4',
        'x+1/2,y,-z+1/2',
        '-y+3/4,x+3/4,-z+1/4',
        '-x,y,z+1/2',
        '-y+3/4,-x+1/4,z+1/4',
        'x+1/2,-y,z',
        'y+3/4,x+3/4,z+3/4',
    ]
},

{
    number          => 143,
    hall            => 'P 3',
    schoenflies     => 'C3^1',
    hermann_mauguin => 'P 3',
    universal_h_m   => 'P 3',
    crystal_class   => 'trigonal',
    constraints     => '$a == $b && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        '-y,x-y,z',
        '-x+y,-x,z',
    ],
    ncsym => [
        'x,y,z',
        '-y,x-y,z',
        '-x+y,-x,z',
    ]
},

{
    number          => 144,
    hall            => 'P 31',
    schoenflies     => 'C3^2',
    hermann_mauguin => 'P 31',
    universal_h_m   => 'P 31',
    crystal_class   => 'trigonal',
    constraints     => '$a == $b && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        '-y,x-y,z+1/3',
        '-x+y,-x,z+2/3',
    ],
    ncsym => [
        'x,y,z',
        '-y,x-y,z+1/3',
        '-x+y,-x,z+2/3',
    ]
},

{
    number          => 145,
    hall            => 'P 32',
    schoenflies     => 'C3^3',
    hermann_mauguin => 'P 32',
    universal_h_m   => 'P 32',
    crystal_class   => 'trigonal',
    constraints     => '$a == $b && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        '-y,x-y,z+2/3',
        '-x+y,-x,z+1/3',
    ],
    ncsym => [
        'x,y,z',
        '-y,x-y,z+2/3',
        '-x+y,-x,z+1/3',
    ]
},

{
    number          => 146,
    hall            => 'R 3',
    schoenflies     => 'C3^4',
    hermann_mauguin => 'R 3',
    universal_h_m   => 'R 3 :H',
    crystal_class   => 'rhombohedral',
    constraints     => '$a == $b && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        '-y,x-y,z',
        '-x+y,-x,z',
        'x+2/3,y+1/3,z+1/3',
        '-y+2/3,x-y+1/3,z+1/3',
        '-x+y+2/3,-x+1/3,z+1/3',
        'x+1/3,y+2/3,z+2/3',
        '-y+1/3,x-y+2/3,z+2/3',
        '-x+y+1/3,-x+2/3,z+2/3',
    ],
    ncsym => [
        'x,y,z',
        '-y,x-y,z',
        '-x+y,-x,z',
    ]
},

{
    number          => 146,
    hall            => 'P 3*',
    schoenflies     => 'C3^4',
    hermann_mauguin => 'R 3',
    universal_h_m   => 'R 3 :R',
    crystal_class   => 'rhombohedral',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == $beta && $beta == $gamma',
    symops => [
        'x,y,z',
        'z,x,y',
        'y,z,x',
    ],
    ncsym => [
        'x,y,z',
        'z,x,y',
        'y,z,x',
    ]
},

{
    number          => 147,
    hall            => '-P 3',
    schoenflies     => 'C3i^1',
    hermann_mauguin => 'P -3',
    universal_h_m   => 'P -3',
    crystal_class   => 'trigonal',
    constraints     => '$a == $b && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        '-y,x-y,z',
        '-x+y,-x,z',
        '-x,-y,-z',
        'y,-x+y,-z',
        'x-y,x,-z',
    ],
    ncsym => [
        'x,y,z',
        '-y,x-y,z',
        '-x+y,-x,z',
        '-x,-y,-z',
        'y,-x+y,-z',
        'x-y,x,-z',
    ]
},

{
    number          => 148,
    hall            => '-R 3',
    schoenflies     => 'C3i^2',
    hermann_mauguin => 'R -3',
    universal_h_m   => 'R -3 :H',
    crystal_class   => 'rhombohedral',
    constraints     => '$a == $b && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        '-y,x-y,z',
        '-x+y,-x,z',
        '-x,-y,-z',
        'y,-x+y,-z',
        'x-y,x,-z',
        'x+2/3,y+1/3,z+1/3',
        '-y+2/3,x-y+1/3,z+1/3',
        '-x+y+2/3,-x+1/3,z+1/3',
        '-x+2/3,-y+1/3,-z+1/3',
        'y+2/3,-x+y+1/3,-z+1/3',
        'x-y+2/3,x+1/3,-z+1/3',
        'x+1/3,y+2/3,z+2/3',
        '-y+1/3,x-y+2/3,z+2/3',
        '-x+y+1/3,-x+2/3,z+2/3',
        '-x+1/3,-y+2/3,-z+2/3',
        'y+1/3,-x+y+2/3,-z+2/3',
        'x-y+1/3,x+2/3,-z+2/3',
    ],
    ncsym => [
        'x,y,z',
        '-y,x-y,z',
        '-x+y,-x,z',
        '-x,-y,-z',
        'y,-x+y,-z',
        'x-y,x,-z',
    ]
},

{
    number          => 148,
    hall            => '-P 3*',
    schoenflies     => 'C3i^2',
    hermann_mauguin => 'R -3',
    universal_h_m   => 'R -3 :R',
    crystal_class   => 'rhombohedral',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == $beta && $beta == $gamma',
    symops => [
        'x,y,z',
        'z,x,y',
        'y,z,x',
        '-x,-y,-z',
        '-z,-x,-y',
        '-y,-z,-x',
    ],
    ncsym => [
        'x,y,z',
        'z,x,y',
        'y,z,x',
        '-x,-y,-z',
        '-z,-x,-y',
        '-y,-z,-x',
    ]
},

{
    number          => 149,
    hall            => 'P 3 2',
    schoenflies     => 'D3^1',
    hermann_mauguin => 'P 3 1 2',
    universal_h_m   => 'P 3 1 2',
    crystal_class   => 'trigonal',
    constraints     => '$a == $b && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        '-y,x-y,z',
        '-x+y,-x,z',
        '-y,-x,-z',
        'x,x-y,-z',
        '-x+y,y,-z',
    ],
    ncsym => [
        'x,y,z',
        '-y,x-y,z',
        '-x+y,-x,z',
        '-y,-x,-z',
        'x,x-y,-z',
        '-x+y,y,-z',
    ]
},

{
    number          => 150,
    hall            => 'P 3 2"',
    schoenflies     => 'D3^2',
    hermann_mauguin => 'P 3 2 1',
    universal_h_m   => 'P 3 2 1',
    crystal_class   => 'trigonal',
    constraints     => '$a == $b && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        '-y,x-y,z',
        '-x+y,-x,z',
        'y,x,-z',
        '-x,-x+y,-z',
        'x-y,-y,-z',
    ],
    ncsym => [
        'x,y,z',
        '-y,x-y,z',
        '-x+y,-x,z',
        'y,x,-z',
        '-x,-x+y,-z',
        'x-y,-y,-z',
    ]
},

{
    number          => 151,
    hall            => 'P 31 2 (0 0 4)',
    schoenflies     => 'D3^3',
    hermann_mauguin => 'P 31 1 2',
    universal_h_m   => 'P 31 1 2',
    crystal_class   => 'trigonal',
    constraints     => '$a == $b && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        '-y,x-y,z+1/3',
        '-x+y,-x,z+2/3',
        '-y,-x,-z+2/3',
        'x,x-y,-z',
        '-x+y,y,-z+1/3',
    ],
    ncsym => [
        'x,y,z',
        '-y,x-y,z+1/3',
        '-x+y,-x,z+2/3',
        '-y,-x,-z+2/3',
        'x,x-y,-z',
        '-x+y,y,-z+1/3',
    ]
},

{
    number          => 152,
    hall            => 'P 31 2"',
    schoenflies     => 'D3^4',
    hermann_mauguin => 'P 31 2 1',
    universal_h_m   => 'P 31 2 1',
    crystal_class   => 'trigonal',
    constraints     => '$a == $b && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        '-y,x-y,z+1/3',
        '-x+y,-x,z+2/3',
        'y,x,-z',
        '-x,-x+y,-z+1/3',
        'x-y,-y,-z+2/3',
    ],
    ncsym => [
        'x,y,z',
        '-y,x-y,z+1/3',
        '-x+y,-x,z+2/3',
        'y,x,-z',
        '-x,-x+y,-z+1/3',
        'x-y,-y,-z+2/3',
    ]
},

{
    number          => 153,
    hall            => 'P 32 2 (0 0 2)',
    schoenflies     => 'D3^5',
    hermann_mauguin => 'P 32 1 2',
    universal_h_m   => 'P 32 1 2',
    crystal_class   => 'trigonal',
    constraints     => '$a == $b && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        '-y,x-y,z+2/3',
        '-x+y,-x,z+1/3',
        '-y,-x,-z+1/3',
        'x,x-y,-z',
        '-x+y,y,-z+2/3',
    ],
    ncsym => [
        'x,y,z',
        '-y,x-y,z+2/3',
        '-x+y,-x,z+1/3',
        '-y,-x,-z+1/3',
        'x,x-y,-z',
        '-x+y,y,-z+2/3',
    ]
},

{
    number          => 154,
    hall            => 'P 32 2"',
    schoenflies     => 'D3^6',
    hermann_mauguin => 'P 32 2 1',
    universal_h_m   => 'P 32 2 1',
    crystal_class   => 'trigonal',
    constraints     => '$a == $b && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        '-y,x-y,z+2/3',
        '-x+y,-x,z+1/3',
        'y,x,-z',
        '-x,-x+y,-z+2/3',
        'x-y,-y,-z+1/3',
    ],
    ncsym => [
        'x,y,z',
        '-y,x-y,z+2/3',
        '-x+y,-x,z+1/3',
        'y,x,-z',
        '-x,-x+y,-z+2/3',
        'x-y,-y,-z+1/3',
    ]
},

{
    number          => 155,
    hall            => 'R 3 2"',
    schoenflies     => 'D3^7',
    hermann_mauguin => 'R 3 2',
    universal_h_m   => 'R 3 2 :H',
    crystal_class   => 'rhombohedral',
    constraints     => '$a == $b && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        '-y,x-y,z',
        '-x+y,-x,z',
        'y,x,-z',
        '-x,-x+y,-z',
        'x-y,-y,-z',
        'x+2/3,y+1/3,z+1/3',
        '-y+2/3,x-y+1/3,z+1/3',
        '-x+y+2/3,-x+1/3,z+1/3',
        'y+2/3,x+1/3,-z+1/3',
        '-x+2/3,-x+y+1/3,-z+1/3',
        'x-y+2/3,-y+1/3,-z+1/3',
        'x+1/3,y+2/3,z+2/3',
        '-y+1/3,x-y+2/3,z+2/3',
        '-x+y+1/3,-x+2/3,z+2/3',
        'y+1/3,x+2/3,-z+2/3',
        '-x+1/3,-x+y+2/3,-z+2/3',
        'x-y+1/3,-y+2/3,-z+2/3',
    ],
    ncsym => [
        'x,y,z',
        '-y,x-y,z',
        '-x+y,-x,z',
        'y,x,-z',
        '-x,-x+y,-z',
        'x-y,-y,-z',
    ]
},

{
    number          => 155,
    hall            => 'P 3* 2',
    schoenflies     => 'D3^7',
    hermann_mauguin => 'R 3 2',
    universal_h_m   => 'R 3 2 :R',
    crystal_class   => 'rhombohedral',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == $beta && $beta == $gamma',
    symops => [
        'x,y,z',
        'z,x,y',
        'y,z,x',
        '-y,-x,-z',
        '-z,-y,-x',
        '-x,-z,-y',
    ],
    ncsym => [
        'x,y,z',
        'z,x,y',
        'y,z,x',
        '-y,-x,-z',
        '-z,-y,-x',
        '-x,-z,-y',
    ]
},

{
    number          => 156,
    hall            => 'P 3 -2"',
    schoenflies     => 'C3v^1',
    hermann_mauguin => 'P 3 m 1',
    universal_h_m   => 'P 3 m 1',
    crystal_class   => 'trigonal',
    constraints     => '$a == $b && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        '-y,x-y,z',
        '-x+y,-x,z',
        '-y,-x,z',
        'x,x-y,z',
        '-x+y,y,z',
    ],
    ncsym => [
        'x,y,z',
        '-y,x-y,z',
        '-x+y,-x,z',
        '-y,-x,z',
        'x,x-y,z',
        '-x+y,y,z',
    ]
},

{
    number          => 157,
    hall            => 'P 3 -2',
    schoenflies     => 'C3v^2',
    hermann_mauguin => 'P 3 1 m',
    universal_h_m   => 'P 3 1 m',
    crystal_class   => 'trigonal',
    constraints     => '$a == $b && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        '-y,x-y,z',
        '-x+y,-x,z',
        'y,x,z',
        '-x,-x+y,z',
        'x-y,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-y,x-y,z',
        '-x+y,-x,z',
        'y,x,z',
        '-x,-x+y,z',
        'x-y,-y,z',
    ]
},

{
    number          => 158,
    hall            => 'P 3 -2"c',
    schoenflies     => 'C3v^3',
    hermann_mauguin => 'P 3 c 1',
    universal_h_m   => 'P 3 c 1',
    crystal_class   => 'trigonal',
    constraints     => '$a == $b && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        '-y,x-y,z',
        '-x+y,-x,z',
        '-y,-x,z+1/2',
        'x,x-y,z+1/2',
        '-x+y,y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y,x-y,z',
        '-x+y,-x,z',
        '-y,-x,z+1/2',
        'x,x-y,z+1/2',
        '-x+y,y,z+1/2',
    ]
},

{
    number          => 159,
    hall            => 'P 3 -2c',
    schoenflies     => 'C3v^4',
    hermann_mauguin => 'P 3 1 c',
    universal_h_m   => 'P 3 1 c',
    crystal_class   => 'trigonal',
    constraints     => '$a == $b && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        '-y,x-y,z',
        '-x+y,-x,z',
        'y,x,z+1/2',
        '-x,-x+y,z+1/2',
        'x-y,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y,x-y,z',
        '-x+y,-x,z',
        'y,x,z+1/2',
        '-x,-x+y,z+1/2',
        'x-y,-y,z+1/2',
    ]
},

{
    number          => 160,
    hall            => 'R 3 -2"',
    schoenflies     => 'C3v^5',
    hermann_mauguin => 'R 3 m',
    universal_h_m   => 'R 3 m :H',
    crystal_class   => 'rhombohedral',
    constraints     => '$a == $b && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        '-y,x-y,z',
        '-x+y,-x,z',
        '-y,-x,z',
        'x,x-y,z',
        '-x+y,y,z',
        'x+2/3,y+1/3,z+1/3',
        '-y+2/3,x-y+1/3,z+1/3',
        '-x+y+2/3,-x+1/3,z+1/3',
        '-y+2/3,-x+1/3,z+1/3',
        'x+2/3,x-y+1/3,z+1/3',
        '-x+y+2/3,y+1/3,z+1/3',
        'x+1/3,y+2/3,z+2/3',
        '-y+1/3,x-y+2/3,z+2/3',
        '-x+y+1/3,-x+2/3,z+2/3',
        '-y+1/3,-x+2/3,z+2/3',
        'x+1/3,x-y+2/3,z+2/3',
        '-x+y+1/3,y+2/3,z+2/3',
    ],
    ncsym => [
        'x,y,z',
        '-y,x-y,z',
        '-x+y,-x,z',
        '-y,-x,z',
        'x,x-y,z',
        '-x+y,y,z',
    ]
},

{
    number          => 160,
    hall            => 'P 3* -2',
    schoenflies     => 'C3v^5',
    hermann_mauguin => 'R 3 m',
    universal_h_m   => 'R 3 m :R',
    crystal_class   => 'rhombohedral',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == $beta && $beta == $gamma',
    symops => [
        'x,y,z',
        'z,x,y',
        'y,z,x',
        'y,x,z',
        'z,y,x',
        'x,z,y',
    ],
    ncsym => [
        'x,y,z',
        'z,x,y',
        'y,z,x',
        'y,x,z',
        'z,y,x',
        'x,z,y',
    ]
},

{
    number          => 161,
    hall            => 'R 3 -2"c',
    schoenflies     => 'C3v^6',
    hermann_mauguin => 'R 3 c',
    universal_h_m   => 'R 3 c :H',
    crystal_class   => 'rhombohedral',
    constraints     => '$a == $b && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        '-y,x-y,z',
        '-x+y,-x,z',
        '-y,-x,z+1/2',
        'x,x-y,z+1/2',
        '-x+y,y,z+1/2',
        'x+2/3,y+1/3,z+1/3',
        '-y+2/3,x-y+1/3,z+1/3',
        '-x+y+2/3,-x+1/3,z+1/3',
        '-y+2/3,-x+1/3,z+5/6',
        'x+2/3,x-y+1/3,z+5/6',
        '-x+y+2/3,y+1/3,z+5/6',
        'x+1/3,y+2/3,z+2/3',
        '-y+1/3,x-y+2/3,z+2/3',
        '-x+y+1/3,-x+2/3,z+2/3',
        '-y+1/3,-x+2/3,z+1/6',
        'x+1/3,x-y+2/3,z+1/6',
        '-x+y+1/3,y+2/3,z+1/6',
    ],
    ncsym => [
        'x,y,z',
        '-y,x-y,z',
        '-x+y,-x,z',
        '-y,-x,z+1/2',
        'x,x-y,z+1/2',
        '-x+y,y,z+1/2',
    ]
},

{
    number          => 161,
    hall            => 'P 3* -2n',
    schoenflies     => 'C3v^6',
    hermann_mauguin => 'R 3 c',
    universal_h_m   => 'R 3 c :R',
    crystal_class   => 'rhombohedral',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == $beta && $beta == $gamma',
    symops => [
        'x,y,z',
        'z,x,y',
        'y,z,x',
        'y+1/2,x+1/2,z+1/2',
        'z+1/2,y+1/2,x+1/2',
        'x+1/2,z+1/2,y+1/2',
    ],
    ncsym => [
        'x,y,z',
        'z,x,y',
        'y,z,x',
        'y+1/2,x+1/2,z+1/2',
        'z+1/2,y+1/2,x+1/2',
        'x+1/2,z+1/2,y+1/2',
    ]
},

{
    number          => 162,
    hall            => '-P 3 2',
    schoenflies     => 'D3d^1',
    hermann_mauguin => 'P -3 1 m',
    universal_h_m   => 'P -3 1 m',
    crystal_class   => 'trigonal',
    constraints     => '$a == $b && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        '-y,x-y,z',
        '-x+y,-x,z',
        '-y,-x,-z',
        'x,x-y,-z',
        '-x+y,y,-z',
        '-x,-y,-z',
        'y,-x+y,-z',
        'x-y,x,-z',
        'y,x,z',
        '-x,-x+y,z',
        'x-y,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-y,x-y,z',
        '-x+y,-x,z',
        '-y,-x,-z',
        'x,x-y,-z',
        '-x+y,y,-z',
        '-x,-y,-z',
        'y,-x+y,-z',
        'x-y,x,-z',
        'y,x,z',
        '-x,-x+y,z',
        'x-y,-y,z',
    ]
},

{
    number          => 163,
    hall            => '-P 3 2c',
    schoenflies     => 'D3d^2',
    hermann_mauguin => 'P -3 1 c',
    universal_h_m   => 'P -3 1 c',
    crystal_class   => 'trigonal',
    constraints     => '$a == $b && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        '-y,x-y,z',
        '-x+y,-x,z',
        '-y,-x,-z+1/2',
        'x,x-y,-z+1/2',
        '-x+y,y,-z+1/2',
        '-x,-y,-z',
        'y,-x+y,-z',
        'x-y,x,-z',
        'y,x,z+1/2',
        '-x,-x+y,z+1/2',
        'x-y,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y,x-y,z',
        '-x+y,-x,z',
        '-y,-x,-z+1/2',
        'x,x-y,-z+1/2',
        '-x+y,y,-z+1/2',
        '-x,-y,-z',
        'y,-x+y,-z',
        'x-y,x,-z',
        'y,x,z+1/2',
        '-x,-x+y,z+1/2',
        'x-y,-y,z+1/2',
    ]
},

{
    number          => 164,
    hall            => '-P 3 2"',
    schoenflies     => 'D3d^3',
    hermann_mauguin => 'P -3 m 1',
    universal_h_m   => 'P -3 m 1',
    crystal_class   => 'trigonal',
    constraints     => '$a == $b && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        '-y,x-y,z',
        '-x+y,-x,z',
        'y,x,-z',
        '-x,-x+y,-z',
        'x-y,-y,-z',
        '-x,-y,-z',
        'y,-x+y,-z',
        'x-y,x,-z',
        '-y,-x,z',
        'x,x-y,z',
        '-x+y,y,z',
    ],
    ncsym => [
        'x,y,z',
        '-y,x-y,z',
        '-x+y,-x,z',
        'y,x,-z',
        '-x,-x+y,-z',
        'x-y,-y,-z',
        '-x,-y,-z',
        'y,-x+y,-z',
        'x-y,x,-z',
        '-y,-x,z',
        'x,x-y,z',
        '-x+y,y,z',
    ]
},

{
    number          => 165,
    hall            => '-P 3 2"c',
    schoenflies     => 'D3d^4',
    hermann_mauguin => 'P -3 c 1',
    universal_h_m   => 'P -3 c 1',
    crystal_class   => 'trigonal',
    constraints     => '$a == $b && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        '-y,x-y,z',
        '-x+y,-x,z',
        'y,x,-z+1/2',
        '-x,-x+y,-z+1/2',
        'x-y,-y,-z+1/2',
        '-x,-y,-z',
        'y,-x+y,-z',
        'x-y,x,-z',
        '-y,-x,z+1/2',
        'x,x-y,z+1/2',
        '-x+y,y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y,x-y,z',
        '-x+y,-x,z',
        'y,x,-z+1/2',
        '-x,-x+y,-z+1/2',
        'x-y,-y,-z+1/2',
        '-x,-y,-z',
        'y,-x+y,-z',
        'x-y,x,-z',
        '-y,-x,z+1/2',
        'x,x-y,z+1/2',
        '-x+y,y,z+1/2',
    ]
},

{
    number          => 166,
    hall            => '-R 3 2"',
    schoenflies     => 'D3d^5',
    hermann_mauguin => 'R -3 m',
    universal_h_m   => 'R -3 m :H',
    crystal_class   => 'rhombohedral',
    constraints     => '$a == $b && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        '-y,x-y,z',
        '-x+y,-x,z',
        'y,x,-z',
        '-x,-x+y,-z',
        'x-y,-y,-z',
        '-x,-y,-z',
        'y,-x+y,-z',
        'x-y,x,-z',
        '-y,-x,z',
        'x,x-y,z',
        '-x+y,y,z',
        'x+2/3,y+1/3,z+1/3',
        '-y+2/3,x-y+1/3,z+1/3',
        '-x+y+2/3,-x+1/3,z+1/3',
        'y+2/3,x+1/3,-z+1/3',
        '-x+2/3,-x+y+1/3,-z+1/3',
        'x-y+2/3,-y+1/3,-z+1/3',
        '-x+2/3,-y+1/3,-z+1/3',
        'y+2/3,-x+y+1/3,-z+1/3',
        'x-y+2/3,x+1/3,-z+1/3',
        '-y+2/3,-x+1/3,z+1/3',
        'x+2/3,x-y+1/3,z+1/3',
        '-x+y+2/3,y+1/3,z+1/3',
        'x+1/3,y+2/3,z+2/3',
        '-y+1/3,x-y+2/3,z+2/3',
        '-x+y+1/3,-x+2/3,z+2/3',
        'y+1/3,x+2/3,-z+2/3',
        '-x+1/3,-x+y+2/3,-z+2/3',
        'x-y+1/3,-y+2/3,-z+2/3',
        '-x+1/3,-y+2/3,-z+2/3',
        'y+1/3,-x+y+2/3,-z+2/3',
        'x-y+1/3,x+2/3,-z+2/3',
        '-y+1/3,-x+2/3,z+2/3',
        'x+1/3,x-y+2/3,z+2/3',
        '-x+y+1/3,y+2/3,z+2/3',
    ],
    ncsym => [
        'x,y,z',
        '-y,x-y,z',
        '-x+y,-x,z',
        'y,x,-z',
        '-x,-x+y,-z',
        'x-y,-y,-z',
        '-x,-y,-z',
        'y,-x+y,-z',
        'x-y,x,-z',
        '-y,-x,z',
        'x,x-y,z',
        '-x+y,y,z',
    ]
},

{
    number          => 166,
    hall            => '-P 3* 2',
    schoenflies     => 'D3d^5',
    hermann_mauguin => 'R -3 m',
    universal_h_m   => 'R -3 m :R',
    crystal_class   => 'rhombohedral',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == $beta && $beta == $gamma',
    symops => [
        'x,y,z',
        'z,x,y',
        'y,z,x',
        '-y,-x,-z',
        '-z,-y,-x',
        '-x,-z,-y',
        '-x,-y,-z',
        '-z,-x,-y',
        '-y,-z,-x',
        'y,x,z',
        'z,y,x',
        'x,z,y',
    ],
    ncsym => [
        'x,y,z',
        'z,x,y',
        'y,z,x',
        '-y,-x,-z',
        '-z,-y,-x',
        '-x,-z,-y',
        '-x,-y,-z',
        '-z,-x,-y',
        '-y,-z,-x',
        'y,x,z',
        'z,y,x',
        'x,z,y',
    ]
},

{
    number          => 167,
    hall            => '-R 3 2"c',
    schoenflies     => 'D3d^6',
    hermann_mauguin => 'R -3 c',
    universal_h_m   => 'R -3 c :H',
    crystal_class   => 'rhombohedral',
    constraints     => '$a == $b && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        '-y,x-y,z',
        '-x+y,-x,z',
        'y,x,-z+1/2',
        '-x,-x+y,-z+1/2',
        'x-y,-y,-z+1/2',
        '-x,-y,-z',
        'y,-x+y,-z',
        'x-y,x,-z',
        '-y,-x,z+1/2',
        'x,x-y,z+1/2',
        '-x+y,y,z+1/2',
        'x+2/3,y+1/3,z+1/3',
        '-y+2/3,x-y+1/3,z+1/3',
        '-x+y+2/3,-x+1/3,z+1/3',
        'y+2/3,x+1/3,-z+5/6',
        '-x+2/3,-x+y+1/3,-z+5/6',
        'x-y+2/3,-y+1/3,-z+5/6',
        '-x+2/3,-y+1/3,-z+1/3',
        'y+2/3,-x+y+1/3,-z+1/3',
        'x-y+2/3,x+1/3,-z+1/3',
        '-y+2/3,-x+1/3,z+5/6',
        'x+2/3,x-y+1/3,z+5/6',
        '-x+y+2/3,y+1/3,z+5/6',
        'x+1/3,y+2/3,z+2/3',
        '-y+1/3,x-y+2/3,z+2/3',
        '-x+y+1/3,-x+2/3,z+2/3',
        'y+1/3,x+2/3,-z+1/6',
        '-x+1/3,-x+y+2/3,-z+1/6',
        'x-y+1/3,-y+2/3,-z+1/6',
        '-x+1/3,-y+2/3,-z+2/3',
        'y+1/3,-x+y+2/3,-z+2/3',
        'x-y+1/3,x+2/3,-z+2/3',
        '-y+1/3,-x+2/3,z+1/6',
        'x+1/3,x-y+2/3,z+1/6',
        '-x+y+1/3,y+2/3,z+1/6',
    ],
    ncsym => [
        'x,y,z',
        '-y,x-y,z',
        '-x+y,-x,z',
        'y,x,-z+1/2',
        '-x,-x+y,-z+1/2',
        'x-y,-y,-z+1/2',
        '-x,-y,-z',
        'y,-x+y,-z',
        'x-y,x,-z',
        '-y,-x,z+1/2',
        'x,x-y,z+1/2',
        '-x+y,y,z+1/2',
    ]
},

{
    number          => 167,
    hall            => '-P 3* 2n',
    schoenflies     => 'D3d^6',
    hermann_mauguin => 'R -3 c',
    universal_h_m   => 'R -3 c :R',
    crystal_class   => 'rhombohedral',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == $beta && $beta == $gamma',
    symops => [
        'x,y,z',
        'z,x,y',
        'y,z,x',
        '-y+1/2,-x+1/2,-z+1/2',
        '-z+1/2,-y+1/2,-x+1/2',
        '-x+1/2,-z+1/2,-y+1/2',
        '-x,-y,-z',
        '-z,-x,-y',
        '-y,-z,-x',
        'y+1/2,x+1/2,z+1/2',
        'z+1/2,y+1/2,x+1/2',
        'x+1/2,z+1/2,y+1/2',
    ],
    ncsym => [
        'x,y,z',
        'z,x,y',
        'y,z,x',
        '-y+1/2,-x+1/2,-z+1/2',
        '-z+1/2,-y+1/2,-x+1/2',
        '-x+1/2,-z+1/2,-y+1/2',
        '-x,-y,-z',
        '-z,-x,-y',
        '-y,-z,-x',
        'y+1/2,x+1/2,z+1/2',
        'z+1/2,y+1/2,x+1/2',
        'x+1/2,z+1/2,y+1/2',
    ]
},

{
    number          => 168,
    hall            => 'P 6',
    schoenflies     => 'C6^1',
    hermann_mauguin => 'P 6',
    universal_h_m   => 'P 6',
    crystal_class   => 'hexagonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        'x-y,x,z',
        '-y,x-y,z',
        '-x,-y,z',
        '-x+y,-x,z',
        'y,-x+y,z',
    ],
    ncsym => [
        'x,y,z',
        'x-y,x,z',
        '-y,x-y,z',
        '-x,-y,z',
        '-x+y,-x,z',
        'y,-x+y,z',
    ]
},

{
    number          => 169,
    hall            => 'P 61',
    schoenflies     => 'C6^2',
    hermann_mauguin => 'P 61',
    universal_h_m   => 'P 61',
    crystal_class   => 'hexagonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        'x-y,x,z+1/6',
        '-y,x-y,z+1/3',
        '-x,-y,z+1/2',
        '-x+y,-x,z+2/3',
        'y,-x+y,z+5/6',
    ],
    ncsym => [
        'x,y,z',
        'x-y,x,z+1/6',
        '-y,x-y,z+1/3',
        '-x,-y,z+1/2',
        '-x+y,-x,z+2/3',
        'y,-x+y,z+5/6',
    ]
},

{
    number          => 170,
    hall            => 'P 65',
    schoenflies     => 'C6^3',
    hermann_mauguin => 'P 65',
    universal_h_m   => 'P 65',
    crystal_class   => 'hexagonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        'x-y,x,z+5/6',
        '-y,x-y,z+2/3',
        '-x,-y,z+1/2',
        '-x+y,-x,z+1/3',
        'y,-x+y,z+1/6',
    ],
    ncsym => [
        'x,y,z',
        'x-y,x,z+5/6',
        '-y,x-y,z+2/3',
        '-x,-y,z+1/2',
        '-x+y,-x,z+1/3',
        'y,-x+y,z+1/6',
    ]
},

{
    number          => 171,
    hall            => 'P 62',
    schoenflies     => 'C6^4',
    hermann_mauguin => 'P 62',
    universal_h_m   => 'P 62',
    crystal_class   => 'hexagonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        'x-y,x,z+1/3',
        '-y,x-y,z+2/3',
        '-x,-y,z',
        '-x+y,-x,z+1/3',
        'y,-x+y,z+2/3',
    ],
    ncsym => [
        'x,y,z',
        'x-y,x,z+1/3',
        '-y,x-y,z+2/3',
        '-x,-y,z',
        '-x+y,-x,z+1/3',
        'y,-x+y,z+2/3',
    ]
},

{
    number          => 172,
    hall            => 'P 64',
    schoenflies     => 'C6^5',
    hermann_mauguin => 'P 64',
    universal_h_m   => 'P 64',
    crystal_class   => 'hexagonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        'x-y,x,z+2/3',
        '-y,x-y,z+1/3',
        '-x,-y,z',
        '-x+y,-x,z+2/3',
        'y,-x+y,z+1/3',
    ],
    ncsym => [
        'x,y,z',
        'x-y,x,z+2/3',
        '-y,x-y,z+1/3',
        '-x,-y,z',
        '-x+y,-x,z+2/3',
        'y,-x+y,z+1/3',
    ]
},

{
    number          => 173,
    hall            => 'P 6c',
    schoenflies     => 'C6^6',
    hermann_mauguin => 'P 63',
    universal_h_m   => 'P 63',
    crystal_class   => 'hexagonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        'x-y,x,z+1/2',
        '-y,x-y,z',
        '-x,-y,z+1/2',
        '-x+y,-x,z',
        'y,-x+y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x-y,x,z+1/2',
        '-y,x-y,z',
        '-x,-y,z+1/2',
        '-x+y,-x,z',
        'y,-x+y,z+1/2',
    ]
},

{
    number          => 174,
    hall            => 'P -6',
    schoenflies     => 'C3h^1',
    hermann_mauguin => 'P -6',
    universal_h_m   => 'P -6',
    crystal_class   => 'hexagonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        '-x+y,-x,-z',
        '-y,x-y,z',
        'x,y,-z',
        '-x+y,-x,z',
        '-y,x-y,-z',
    ],
    ncsym => [
        'x,y,z',
        '-x+y,-x,-z',
        '-y,x-y,z',
        'x,y,-z',
        '-x+y,-x,z',
        '-y,x-y,-z',
    ]
},

{
    number          => 175,
    hall            => '-P 6',
    schoenflies     => 'C6h^1',
    hermann_mauguin => 'P 6/m',
    universal_h_m   => 'P 6/m',
    crystal_class   => 'hexagonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        'x-y,x,z',
        '-y,x-y,z',
        '-x,-y,z',
        '-x+y,-x,z',
        'y,-x+y,z',
        '-x,-y,-z',
        '-x+y,-x,-z',
        'y,-x+y,-z',
        'x,y,-z',
        'x-y,x,-z',
        '-y,x-y,-z',
    ],
    ncsym => [
        'x,y,z',
        'x-y,x,z',
        '-y,x-y,z',
        '-x,-y,z',
        '-x+y,-x,z',
        'y,-x+y,z',
        '-x,-y,-z',
        '-x+y,-x,-z',
        'y,-x+y,-z',
        'x,y,-z',
        'x-y,x,-z',
        '-y,x-y,-z',
    ]
},

{
    number          => 176,
    hall            => '-P 6c',
    schoenflies     => 'C6h^2',
    hermann_mauguin => 'P 63/m',
    universal_h_m   => 'P 63/m',
    crystal_class   => 'hexagonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        'x-y,x,z+1/2',
        '-y,x-y,z',
        '-x,-y,z+1/2',
        '-x+y,-x,z',
        'y,-x+y,z+1/2',
        '-x,-y,-z',
        '-x+y,-x,-z+1/2',
        'y,-x+y,-z',
        'x,y,-z+1/2',
        'x-y,x,-z',
        '-y,x-y,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x-y,x,z+1/2',
        '-y,x-y,z',
        '-x,-y,z+1/2',
        '-x+y,-x,z',
        'y,-x+y,z+1/2',
        '-x,-y,-z',
        '-x+y,-x,-z+1/2',
        'y,-x+y,-z',
        'x,y,-z+1/2',
        'x-y,x,-z',
        '-y,x-y,-z+1/2',
    ]
},

{
    number          => 177,
    hall            => 'P 6 2',
    schoenflies     => 'D6^1',
    hermann_mauguin => 'P 6 2 2',
    universal_h_m   => 'P 6 2 2',
    crystal_class   => 'hexagonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        'x-y,x,z',
        '-y,x-y,z',
        '-x,-y,z',
        '-x+y,-x,z',
        'y,-x+y,z',
        '-y,-x,-z',
        'x-y,-y,-z',
        'x,x-y,-z',
        'y,x,-z',
        '-x+y,y,-z',
        '-x,-x+y,-z',
    ],
    ncsym => [
        'x,y,z',
        'x-y,x,z',
        '-y,x-y,z',
        '-x,-y,z',
        '-x+y,-x,z',
        'y,-x+y,z',
        '-y,-x,-z',
        'x-y,-y,-z',
        'x,x-y,-z',
        'y,x,-z',
        '-x+y,y,-z',
        '-x,-x+y,-z',
    ]
},

{
    number          => 178,
    hall            => 'P 61 2 (0 0 5)',
    schoenflies     => 'D6^2',
    hermann_mauguin => 'P 61 2 2',
    universal_h_m   => 'P 61 2 2',
    crystal_class   => 'hexagonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        'x-y,x,z+1/6',
        '-y,x-y,z+1/3',
        '-x,-y,z+1/2',
        '-x+y,-x,z+2/3',
        'y,-x+y,z+5/6',
        '-y,-x,-z+5/6',
        'x-y,-y,-z',
        'x,x-y,-z+1/6',
        'y,x,-z+1/3',
        '-x+y,y,-z+1/2',
        '-x,-x+y,-z+2/3',
    ],
    ncsym => [
        'x,y,z',
        'x-y,x,z+1/6',
        '-y,x-y,z+1/3',
        '-x,-y,z+1/2',
        '-x+y,-x,z+2/3',
        'y,-x+y,z+5/6',
        '-y,-x,-z+5/6',
        'x-y,-y,-z',
        'x,x-y,-z+1/6',
        'y,x,-z+1/3',
        '-x+y,y,-z+1/2',
        '-x,-x+y,-z+2/3',
    ]
},

{
    number          => 179,
    hall            => 'P 65 2 (0 0 1)',
    schoenflies     => 'D6^3',
    hermann_mauguin => 'P 65 2 2',
    universal_h_m   => 'P 65 2 2',
    crystal_class   => 'hexagonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        'x-y,x,z+5/6',
        '-y,x-y,z+2/3',
        '-x,-y,z+1/2',
        '-x+y,-x,z+1/3',
        'y,-x+y,z+1/6',
        '-y,-x,-z+1/6',
        'x-y,-y,-z',
        'x,x-y,-z+5/6',
        'y,x,-z+2/3',
        '-x+y,y,-z+1/2',
        '-x,-x+y,-z+1/3',
    ],
    ncsym => [
        'x,y,z',
        'x-y,x,z+5/6',
        '-y,x-y,z+2/3',
        '-x,-y,z+1/2',
        '-x+y,-x,z+1/3',
        'y,-x+y,z+1/6',
        '-y,-x,-z+1/6',
        'x-y,-y,-z',
        'x,x-y,-z+5/6',
        'y,x,-z+2/3',
        '-x+y,y,-z+1/2',
        '-x,-x+y,-z+1/3',
    ]
},

{
    number          => 180,
    hall            => 'P 62 2 (0 0 4)',
    schoenflies     => 'D6^4',
    hermann_mauguin => 'P 62 2 2',
    universal_h_m   => 'P 62 2 2',
    crystal_class   => 'hexagonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        'x-y,x,z+1/3',
        '-y,x-y,z+2/3',
        '-x,-y,z',
        '-x+y,-x,z+1/3',
        'y,-x+y,z+2/3',
        '-y,-x,-z+2/3',
        'x-y,-y,-z',
        'x,x-y,-z+1/3',
        'y,x,-z+2/3',
        '-x+y,y,-z',
        '-x,-x+y,-z+1/3',
    ],
    ncsym => [
        'x,y,z',
        'x-y,x,z+1/3',
        '-y,x-y,z+2/3',
        '-x,-y,z',
        '-x+y,-x,z+1/3',
        'y,-x+y,z+2/3',
        '-y,-x,-z+2/3',
        'x-y,-y,-z',
        'x,x-y,-z+1/3',
        'y,x,-z+2/3',
        '-x+y,y,-z',
        '-x,-x+y,-z+1/3',
    ]
},

{
    number          => 181,
    hall            => 'P 64 2 (0 0 2)',
    schoenflies     => 'D6^5',
    hermann_mauguin => 'P 64 2 2',
    universal_h_m   => 'P 64 2 2',
    crystal_class   => 'hexagonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        'x-y,x,z+2/3',
        '-y,x-y,z+1/3',
        '-x,-y,z',
        '-x+y,-x,z+2/3',
        'y,-x+y,z+1/3',
        '-y,-x,-z+1/3',
        'x-y,-y,-z',
        'x,x-y,-z+2/3',
        'y,x,-z+1/3',
        '-x+y,y,-z',
        '-x,-x+y,-z+2/3',
    ],
    ncsym => [
        'x,y,z',
        'x-y,x,z+2/3',
        '-y,x-y,z+1/3',
        '-x,-y,z',
        '-x+y,-x,z+2/3',
        'y,-x+y,z+1/3',
        '-y,-x,-z+1/3',
        'x-y,-y,-z',
        'x,x-y,-z+2/3',
        'y,x,-z+1/3',
        '-x+y,y,-z',
        '-x,-x+y,-z+2/3',
    ]
},

{
    number          => 182,
    hall            => 'P 6c 2c',
    schoenflies     => 'D6^6',
    hermann_mauguin => 'P 63 2 2',
    universal_h_m   => 'P 63 2 2',
    crystal_class   => 'hexagonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        'x-y,x,z+1/2',
        '-y,x-y,z',
        '-x,-y,z+1/2',
        '-x+y,-x,z',
        'y,-x+y,z+1/2',
        '-y,-x,-z+1/2',
        'x-y,-y,-z',
        'x,x-y,-z+1/2',
        'y,x,-z',
        '-x+y,y,-z+1/2',
        '-x,-x+y,-z',
    ],
    ncsym => [
        'x,y,z',
        'x-y,x,z+1/2',
        '-y,x-y,z',
        '-x,-y,z+1/2',
        '-x+y,-x,z',
        'y,-x+y,z+1/2',
        '-y,-x,-z+1/2',
        'x-y,-y,-z',
        'x,x-y,-z+1/2',
        'y,x,-z',
        '-x+y,y,-z+1/2',
        '-x,-x+y,-z',
    ]
},

{
    number          => 183,
    hall            => 'P 6 -2',
    schoenflies     => 'C6v^1',
    hermann_mauguin => 'P 6 m m',
    universal_h_m   => 'P 6 m m',
    crystal_class   => 'hexagonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        'x-y,x,z',
        '-y,x-y,z',
        '-x,-y,z',
        '-x+y,-x,z',
        'y,-x+y,z',
        'y,x,z',
        '-x+y,y,z',
        '-x,-x+y,z',
        '-y,-x,z',
        'x-y,-y,z',
        'x,x-y,z',
    ],
    ncsym => [
        'x,y,z',
        'x-y,x,z',
        '-y,x-y,z',
        '-x,-y,z',
        '-x+y,-x,z',
        'y,-x+y,z',
        'y,x,z',
        '-x+y,y,z',
        '-x,-x+y,z',
        '-y,-x,z',
        'x-y,-y,z',
        'x,x-y,z',
    ]
},

{
    number          => 184,
    hall            => 'P 6 -2c',
    schoenflies     => 'C6v^2',
    hermann_mauguin => 'P 6 c c',
    universal_h_m   => 'P 6 c c',
    crystal_class   => 'hexagonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        'x-y,x,z',
        '-y,x-y,z',
        '-x,-y,z',
        '-x+y,-x,z',
        'y,-x+y,z',
        'y,x,z+1/2',
        '-x+y,y,z+1/2',
        '-x,-x+y,z+1/2',
        '-y,-x,z+1/2',
        'x-y,-y,z+1/2',
        'x,x-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x-y,x,z',
        '-y,x-y,z',
        '-x,-y,z',
        '-x+y,-x,z',
        'y,-x+y,z',
        'y,x,z+1/2',
        '-x+y,y,z+1/2',
        '-x,-x+y,z+1/2',
        '-y,-x,z+1/2',
        'x-y,-y,z+1/2',
        'x,x-y,z+1/2',
    ]
},

{
    number          => 185,
    hall            => 'P 6c -2',
    schoenflies     => 'C6v^3',
    hermann_mauguin => 'P 63 c m',
    universal_h_m   => 'P 63 c m',
    crystal_class   => 'hexagonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        'x-y,x,z+1/2',
        '-y,x-y,z',
        '-x,-y,z+1/2',
        '-x+y,-x,z',
        'y,-x+y,z+1/2',
        'y,x,z',
        '-x+y,y,z+1/2',
        '-x,-x+y,z',
        '-y,-x,z+1/2',
        'x-y,-y,z',
        'x,x-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x-y,x,z+1/2',
        '-y,x-y,z',
        '-x,-y,z+1/2',
        '-x+y,-x,z',
        'y,-x+y,z+1/2',
        'y,x,z',
        '-x+y,y,z+1/2',
        '-x,-x+y,z',
        '-y,-x,z+1/2',
        'x-y,-y,z',
        'x,x-y,z+1/2',
    ]
},

{
    number          => 186,
    hall            => 'P 6c -2c',
    schoenflies     => 'C6v^4',
    hermann_mauguin => 'P 63 m c',
    universal_h_m   => 'P 63 m c',
    crystal_class   => 'hexagonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        'x-y,x,z+1/2',
        '-y,x-y,z',
        '-x,-y,z+1/2',
        '-x+y,-x,z',
        'y,-x+y,z+1/2',
        'y,x,z+1/2',
        '-x+y,y,z',
        '-x,-x+y,z+1/2',
        '-y,-x,z',
        'x-y,-y,z+1/2',
        'x,x-y,z',
    ],
    ncsym => [
        'x,y,z',
        'x-y,x,z+1/2',
        '-y,x-y,z',
        '-x,-y,z+1/2',
        '-x+y,-x,z',
        'y,-x+y,z+1/2',
        'y,x,z+1/2',
        '-x+y,y,z',
        '-x,-x+y,z+1/2',
        '-y,-x,z',
        'x-y,-y,z+1/2',
        'x,x-y,z',
    ]
},

{
    number          => 187,
    hall            => 'P -6 2',
    schoenflies     => 'D3h^1',
    hermann_mauguin => 'P -6 m 2',
    universal_h_m   => 'P -6 m 2',
    crystal_class   => 'hexagonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        '-x+y,-x,-z',
        '-y,x-y,z',
        'x,y,-z',
        '-x+y,-x,z',
        '-y,x-y,-z',
        '-y,-x,-z',
        '-x+y,y,z',
        'x,x-y,-z',
        '-y,-x,z',
        '-x+y,y,-z',
        'x,x-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-x+y,-x,-z',
        '-y,x-y,z',
        'x,y,-z',
        '-x+y,-x,z',
        '-y,x-y,-z',
        '-y,-x,-z',
        '-x+y,y,z',
        'x,x-y,-z',
        '-y,-x,z',
        '-x+y,y,-z',
        'x,x-y,z',
    ]
},

{
    number          => 188,
    hall            => 'P -6c 2',
    schoenflies     => 'D3h^2',
    hermann_mauguin => 'P -6 c 2',
    universal_h_m   => 'P -6 c 2',
    crystal_class   => 'hexagonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        '-x+y,-x,-z+1/2',
        '-y,x-y,z',
        'x,y,-z+1/2',
        '-x+y,-x,z',
        '-y,x-y,-z+1/2',
        '-y,-x,-z',
        '-x+y,y,z+1/2',
        'x,x-y,-z',
        '-y,-x,z+1/2',
        '-x+y,y,-z',
        'x,x-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+y,-x,-z+1/2',
        '-y,x-y,z',
        'x,y,-z+1/2',
        '-x+y,-x,z',
        '-y,x-y,-z+1/2',
        '-y,-x,-z',
        '-x+y,y,z+1/2',
        'x,x-y,-z',
        '-y,-x,z+1/2',
        '-x+y,y,-z',
        'x,x-y,z+1/2',
    ]
},

{
    number          => 189,
    hall            => 'P -6 -2',
    schoenflies     => 'D3h^3',
    hermann_mauguin => 'P -6 2 m',
    universal_h_m   => 'P -6 2 m',
    crystal_class   => 'hexagonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        '-x+y,-x,-z',
        '-y,x-y,z',
        'x,y,-z',
        '-x+y,-x,z',
        '-y,x-y,-z',
        'y,x,z',
        'x-y,-y,-z',
        '-x,-x+y,z',
        'y,x,-z',
        'x-y,-y,z',
        '-x,-x+y,-z',
    ],
    ncsym => [
        'x,y,z',
        '-x+y,-x,-z',
        '-y,x-y,z',
        'x,y,-z',
        '-x+y,-x,z',
        '-y,x-y,-z',
        'y,x,z',
        'x-y,-y,-z',
        '-x,-x+y,z',
        'y,x,-z',
        'x-y,-y,z',
        '-x,-x+y,-z',
    ]
},

{
    number          => 190,
    hall            => 'P -6c -2c',
    schoenflies     => 'D3h^4',
    hermann_mauguin => 'P -6 2 c',
    universal_h_m   => 'P -6 2 c',
    crystal_class   => 'hexagonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        '-x+y,-x,-z+1/2',
        '-y,x-y,z',
        'x,y,-z+1/2',
        '-x+y,-x,z',
        '-y,x-y,-z+1/2',
        'y,x,z+1/2',
        'x-y,-y,-z',
        '-x,-x+y,z+1/2',
        'y,x,-z',
        'x-y,-y,z+1/2',
        '-x,-x+y,-z',
    ],
    ncsym => [
        'x,y,z',
        '-x+y,-x,-z+1/2',
        '-y,x-y,z',
        'x,y,-z+1/2',
        '-x+y,-x,z',
        '-y,x-y,-z+1/2',
        'y,x,z+1/2',
        'x-y,-y,-z',
        '-x,-x+y,z+1/2',
        'y,x,-z',
        'x-y,-y,z+1/2',
        '-x,-x+y,-z',
    ]
},

{
    number          => 191,
    hall            => '-P 6 2',
    schoenflies     => 'D6h^1',
    hermann_mauguin => 'P 6/m m m',
    universal_h_m   => 'P 6/m m m',
    crystal_class   => 'hexagonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        'x-y,x,z',
        '-y,x-y,z',
        '-x,-y,z',
        '-x+y,-x,z',
        'y,-x+y,z',
        '-y,-x,-z',
        'x-y,-y,-z',
        'x,x-y,-z',
        'y,x,-z',
        '-x+y,y,-z',
        '-x,-x+y,-z',
        '-x,-y,-z',
        '-x+y,-x,-z',
        'y,-x+y,-z',
        'x,y,-z',
        'x-y,x,-z',
        '-y,x-y,-z',
        'y,x,z',
        '-x+y,y,z',
        '-x,-x+y,z',
        '-y,-x,z',
        'x-y,-y,z',
        'x,x-y,z',
    ],
    ncsym => [
        'x,y,z',
        'x-y,x,z',
        '-y,x-y,z',
        '-x,-y,z',
        '-x+y,-x,z',
        'y,-x+y,z',
        '-y,-x,-z',
        'x-y,-y,-z',
        'x,x-y,-z',
        'y,x,-z',
        '-x+y,y,-z',
        '-x,-x+y,-z',
        '-x,-y,-z',
        '-x+y,-x,-z',
        'y,-x+y,-z',
        'x,y,-z',
        'x-y,x,-z',
        '-y,x-y,-z',
        'y,x,z',
        '-x+y,y,z',
        '-x,-x+y,z',
        '-y,-x,z',
        'x-y,-y,z',
        'x,x-y,z',
    ]
},

{
    number          => 192,
    hall            => '-P 6 2c',
    schoenflies     => 'D6h^2',
    hermann_mauguin => 'P 6/m c c',
    universal_h_m   => 'P 6/m c c',
    crystal_class   => 'hexagonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        'x-y,x,z',
        '-y,x-y,z',
        '-x,-y,z',
        '-x+y,-x,z',
        'y,-x+y,z',
        '-y,-x,-z+1/2',
        'x-y,-y,-z+1/2',
        'x,x-y,-z+1/2',
        'y,x,-z+1/2',
        '-x+y,y,-z+1/2',
        '-x,-x+y,-z+1/2',
        '-x,-y,-z',
        '-x+y,-x,-z',
        'y,-x+y,-z',
        'x,y,-z',
        'x-y,x,-z',
        '-y,x-y,-z',
        'y,x,z+1/2',
        '-x+y,y,z+1/2',
        '-x,-x+y,z+1/2',
        '-y,-x,z+1/2',
        'x-y,-y,z+1/2',
        'x,x-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x-y,x,z',
        '-y,x-y,z',
        '-x,-y,z',
        '-x+y,-x,z',
        'y,-x+y,z',
        '-y,-x,-z+1/2',
        'x-y,-y,-z+1/2',
        'x,x-y,-z+1/2',
        'y,x,-z+1/2',
        '-x+y,y,-z+1/2',
        '-x,-x+y,-z+1/2',
        '-x,-y,-z',
        '-x+y,-x,-z',
        'y,-x+y,-z',
        'x,y,-z',
        'x-y,x,-z',
        '-y,x-y,-z',
        'y,x,z+1/2',
        '-x+y,y,z+1/2',
        '-x,-x+y,z+1/2',
        '-y,-x,z+1/2',
        'x-y,-y,z+1/2',
        'x,x-y,z+1/2',
    ]
},

{
    number          => 193,
    hall            => '-P 6c 2',
    schoenflies     => 'D6h^3',
    hermann_mauguin => 'P 63/m c m',
    universal_h_m   => 'P 63/m c m',
    crystal_class   => 'hexagonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        'x-y,x,z+1/2',
        '-y,x-y,z',
        '-x,-y,z+1/2',
        '-x+y,-x,z',
        'y,-x+y,z+1/2',
        '-y,-x,-z',
        'x-y,-y,-z+1/2',
        'x,x-y,-z',
        'y,x,-z+1/2',
        '-x+y,y,-z',
        '-x,-x+y,-z+1/2',
        '-x,-y,-z',
        '-x+y,-x,-z+1/2',
        'y,-x+y,-z',
        'x,y,-z+1/2',
        'x-y,x,-z',
        '-y,x-y,-z+1/2',
        'y,x,z',
        '-x+y,y,z+1/2',
        '-x,-x+y,z',
        '-y,-x,z+1/2',
        'x-y,-y,z',
        'x,x-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x-y,x,z+1/2',
        '-y,x-y,z',
        '-x,-y,z+1/2',
        '-x+y,-x,z',
        'y,-x+y,z+1/2',
        '-y,-x,-z',
        'x-y,-y,-z+1/2',
        'x,x-y,-z',
        'y,x,-z+1/2',
        '-x+y,y,-z',
        '-x,-x+y,-z+1/2',
        '-x,-y,-z',
        '-x+y,-x,-z+1/2',
        'y,-x+y,-z',
        'x,y,-z+1/2',
        'x-y,x,-z',
        '-y,x-y,-z+1/2',
        'y,x,z',
        '-x+y,y,z+1/2',
        '-x,-x+y,z',
        '-y,-x,z+1/2',
        'x-y,-y,z',
        'x,x-y,z+1/2',
    ]
},

{
    number          => 194,
    hall            => '-P 6c 2c',
    schoenflies     => 'D6h^4',
    hermann_mauguin => 'P 63/m m c',
    universal_h_m   => 'P 63/m m c',
    crystal_class   => 'hexagonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        'x-y,x,z+1/2',
        '-y,x-y,z',
        '-x,-y,z+1/2',
        '-x+y,-x,z',
        'y,-x+y,z+1/2',
        '-y,-x,-z+1/2',
        'x-y,-y,-z',
        'x,x-y,-z+1/2',
        'y,x,-z',
        '-x+y,y,-z+1/2',
        '-x,-x+y,-z',
        '-x,-y,-z',
        '-x+y,-x,-z+1/2',
        'y,-x+y,-z',
        'x,y,-z+1/2',
        'x-y,x,-z',
        '-y,x-y,-z+1/2',
        'y,x,z+1/2',
        '-x+y,y,z',
        '-x,-x+y,z+1/2',
        '-y,-x,z',
        'x-y,-y,z+1/2',
        'x,x-y,z',
    ],
    ncsym => [
        'x,y,z',
        'x-y,x,z+1/2',
        '-y,x-y,z',
        '-x,-y,z+1/2',
        '-x+y,-x,z',
        'y,-x+y,z+1/2',
        '-y,-x,-z+1/2',
        'x-y,-y,-z',
        'x,x-y,-z+1/2',
        'y,x,-z',
        '-x+y,y,-z+1/2',
        '-x,-x+y,-z',
        '-x,-y,-z',
        '-x+y,-x,-z+1/2',
        'y,-x+y,-z',
        'x,y,-z+1/2',
        'x-y,x,-z',
        '-y,x-y,-z+1/2',
        'y,x,z+1/2',
        '-x+y,y,z',
        '-x,-x+y,z+1/2',
        '-y,-x,z',
        'x-y,-y,z+1/2',
        'x,x-y,z',
    ]
},

{
    number          => 195,
    hall            => 'P 2 2 3',
    schoenflies     => 'T^1',
    hermann_mauguin => 'P 2 3',
    universal_h_m   => 'P 2 3',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        'z,x,y',
        '-z,-x,y',
        'z,-x,-y',
        '-z,x,-y',
        'y,z,x',
        'y,-z,-x',
        '-y,z,-x',
        '-y,-z,x',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        'z,x,y',
        '-z,-x,y',
        'z,-x,-y',
        '-z,x,-y',
        'y,z,x',
        'y,-z,-x',
        '-y,z,-x',
        '-y,-z,x',
    ]
},

{
    number          => 196,
    hall            => 'F 2 2 3',
    schoenflies     => 'T^2',
    hermann_mauguin => 'F 2 3',
    universal_h_m   => 'F 2 3',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        'z,x,y',
        '-z,-x,y',
        'z,-x,-y',
        '-z,x,-y',
        'y,z,x',
        'y,-z,-x',
        '-y,z,-x',
        '-y,-z,x',
        'x,y+1/2,z+1/2',
        '-x,-y+1/2,z+1/2',
        'x,-y+1/2,-z+1/2',
        '-x,y+1/2,-z+1/2',
        'z,x+1/2,y+1/2',
        '-z,-x+1/2,y+1/2',
        'z,-x+1/2,-y+1/2',
        '-z,x+1/2,-y+1/2',
        'y,z+1/2,x+1/2',
        'y,-z+1/2,-x+1/2',
        '-y,z+1/2,-x+1/2',
        '-y,-z+1/2,x+1/2',
        'x+1/2,y,z+1/2',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x+1/2,y,-z+1/2',
        'z+1/2,x,y+1/2',
        '-z+1/2,-x,y+1/2',
        'z+1/2,-x,-y+1/2',
        '-z+1/2,x,-y+1/2',
        'y+1/2,z,x+1/2',
        'y+1/2,-z,-x+1/2',
        '-y+1/2,z,-x+1/2',
        '-y+1/2,-z,x+1/2',
        'x+1/2,y+1/2,z',
        '-x+1/2,-y+1/2,z',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,y+1/2,-z',
        'z+1/2,x+1/2,y',
        '-z+1/2,-x+1/2,y',
        'z+1/2,-x+1/2,-y',
        '-z+1/2,x+1/2,-y',
        'y+1/2,z+1/2,x',
        'y+1/2,-z+1/2,-x',
        '-y+1/2,z+1/2,-x',
        '-y+1/2,-z+1/2,x',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        'z,x,y',
        '-z,-x,y',
        'z,-x,-y',
        '-z,x,-y',
        'y,z,x',
        'y,-z,-x',
        '-y,z,-x',
        '-y,-z,x',
    ]
},

{
    number          => 197,
    hall            => 'I 2 2 3',
    schoenflies     => 'T^3',
    hermann_mauguin => 'I 2 3',
    universal_h_m   => 'I 2 3',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        'z,x,y',
        '-z,-x,y',
        'z,-x,-y',
        '-z,x,-y',
        'y,z,x',
        'y,-z,-x',
        '-y,z,-x',
        '-y,-z,x',
        'x+1/2,y+1/2,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        'z+1/2,x+1/2,y+1/2',
        '-z+1/2,-x+1/2,y+1/2',
        'z+1/2,-x+1/2,-y+1/2',
        '-z+1/2,x+1/2,-y+1/2',
        'y+1/2,z+1/2,x+1/2',
        'y+1/2,-z+1/2,-x+1/2',
        '-y+1/2,z+1/2,-x+1/2',
        '-y+1/2,-z+1/2,x+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        'z,x,y',
        '-z,-x,y',
        'z,-x,-y',
        '-z,x,-y',
        'y,z,x',
        'y,-z,-x',
        '-y,z,-x',
        '-y,-z,x',
    ]
},

{
    number          => 198,
    hall            => 'P 2ac 2ab 3',
    schoenflies     => 'T^4',
    hermann_mauguin => 'P 21 3',
    universal_h_m   => 'P 21 3',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y+1/2,-z',
        '-x,y+1/2,-z+1/2',
        'z,x,y',
        '-z+1/2,-x,y+1/2',
        'z+1/2,-x+1/2,-y',
        '-z,x+1/2,-y+1/2',
        'y,z,x',
        'y+1/2,-z+1/2,-x',
        '-y,z+1/2,-x+1/2',
        '-y+1/2,-z,x+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y+1/2,-z',
        '-x,y+1/2,-z+1/2',
        'z,x,y',
        '-z+1/2,-x,y+1/2',
        'z+1/2,-x+1/2,-y',
        '-z,x+1/2,-y+1/2',
        'y,z,x',
        'y+1/2,-z+1/2,-x',
        '-y,z+1/2,-x+1/2',
        '-y+1/2,-z,x+1/2',
    ]
},

{
    number          => 199,
    hall            => 'I 2b 2c 3',
    schoenflies     => 'T^5',
    hermann_mauguin => 'I 21 3',
    universal_h_m   => 'I 21 3',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x,-y,-z+1/2',
        '-x,y+1/2,-z+1/2',
        'z,x,y',
        '-z,-x+1/2,y',
        'z,-x,-y+1/2',
        '-z,x+1/2,-y+1/2',
        'y,z,x',
        'y,-z,-x+1/2',
        '-y,z+1/2,-x+1/2',
        '-y+1/2,-z,x+1/2',
        'x+1/2,y+1/2,z+1/2',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,y,-z',
        'z+1/2,x+1/2,y+1/2',
        '-z+1/2,-x,y+1/2',
        'z+1/2,-x+1/2,-y',
        '-z+1/2,x,-y',
        'y+1/2,z+1/2,x+1/2',
        'y+1/2,-z+1/2,-x',
        '-y+1/2,z,-x',
        '-y,-z+1/2,x',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x,-y,-z+1/2',
        '-x,y+1/2,-z+1/2',
        'z,x,y',
        '-z,-x+1/2,y',
        'z,-x,-y+1/2',
        '-z,x+1/2,-y+1/2',
        'y,z,x',
        'y,-z,-x+1/2',
        '-y,z+1/2,-x+1/2',
        '-y+1/2,-z,x+1/2',
    ]
},

{
    number          => 200,
    hall            => '-P 2 2 3',
    schoenflies     => 'Th^1',
    hermann_mauguin => 'P m -3',
    universal_h_m   => 'P m -3',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        'z,x,y',
        '-z,-x,y',
        'z,-x,-y',
        '-z,x,-y',
        'y,z,x',
        'y,-z,-x',
        '-y,z,-x',
        '-y,-z,x',
        '-x,-y,-z',
        'x,y,-z',
        '-x,y,z',
        'x,-y,z',
        '-z,-x,-y',
        'z,x,-y',
        '-z,x,y',
        'z,-x,y',
        '-y,-z,-x',
        '-y,z,x',
        'y,-z,x',
        'y,z,-x',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        'z,x,y',
        '-z,-x,y',
        'z,-x,-y',
        '-z,x,-y',
        'y,z,x',
        'y,-z,-x',
        '-y,z,-x',
        '-y,-z,x',
        '-x,-y,-z',
        'x,y,-z',
        '-x,y,z',
        'x,-y,z',
        '-z,-x,-y',
        'z,x,-y',
        '-z,x,y',
        'z,-x,y',
        '-y,-z,-x',
        '-y,z,x',
        'y,-z,x',
        'y,z,-x',
    ]
},

{
    number          => 201,
    hall            => 'P 2 2 3 -1n',
    schoenflies     => 'Th^2',
    hermann_mauguin => 'P n -3',
    universal_h_m   => 'P n -3 :1',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        'z,x,y',
        '-z,-x,y',
        'z,-x,-y',
        '-z,x,-y',
        'y,z,x',
        'y,-z,-x',
        '-y,z,-x',
        '-y,-z,x',
        '-x+1/2,-y+1/2,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        '-z+1/2,-x+1/2,-y+1/2',
        'z+1/2,x+1/2,-y+1/2',
        '-z+1/2,x+1/2,y+1/2',
        'z+1/2,-x+1/2,y+1/2',
        '-y+1/2,-z+1/2,-x+1/2',
        '-y+1/2,z+1/2,x+1/2',
        'y+1/2,-z+1/2,x+1/2',
        'y+1/2,z+1/2,-x+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        'z,x,y',
        '-z,-x,y',
        'z,-x,-y',
        '-z,x,-y',
        'y,z,x',
        'y,-z,-x',
        '-y,z,-x',
        '-y,-z,x',
        '-x+1/2,-y+1/2,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        '-z+1/2,-x+1/2,-y+1/2',
        'z+1/2,x+1/2,-y+1/2',
        '-z+1/2,x+1/2,y+1/2',
        'z+1/2,-x+1/2,y+1/2',
        '-y+1/2,-z+1/2,-x+1/2',
        '-y+1/2,z+1/2,x+1/2',
        'y+1/2,-z+1/2,x+1/2',
        'y+1/2,z+1/2,-x+1/2',
    ]
},

{
    number          => 201,
    hall            => '-P 2ab 2bc 3',
    schoenflies     => 'Th^2',
    hermann_mauguin => 'P n -3',
    universal_h_m   => 'P n -3 :2',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x,-y+1/2,-z+1/2',
        '-x+1/2,y,-z+1/2',
        'z,x,y',
        '-z+1/2,-x+1/2,y',
        'z,-x+1/2,-y+1/2',
        '-z+1/2,x,-y+1/2',
        'y,z,x',
        'y,-z+1/2,-x+1/2',
        '-y+1/2,z,-x+1/2',
        '-y+1/2,-z+1/2,x',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
        '-x,y+1/2,z+1/2',
        'x+1/2,-y,z+1/2',
        '-z,-x,-y',
        'z+1/2,x+1/2,-y',
        '-z,x+1/2,y+1/2',
        'z+1/2,-x,y+1/2',
        '-y,-z,-x',
        '-y,z+1/2,x+1/2',
        'y+1/2,-z,x+1/2',
        'y+1/2,z+1/2,-x',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x,-y+1/2,-z+1/2',
        '-x+1/2,y,-z+1/2',
        'z,x,y',
        '-z+1/2,-x+1/2,y',
        'z,-x+1/2,-y+1/2',
        '-z+1/2,x,-y+1/2',
        'y,z,x',
        'y,-z+1/2,-x+1/2',
        '-y+1/2,z,-x+1/2',
        '-y+1/2,-z+1/2,x',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
        '-x,y+1/2,z+1/2',
        'x+1/2,-y,z+1/2',
        '-z,-x,-y',
        'z+1/2,x+1/2,-y',
        '-z,x+1/2,y+1/2',
        'z+1/2,-x,y+1/2',
        '-y,-z,-x',
        '-y,z+1/2,x+1/2',
        'y+1/2,-z,x+1/2',
        'y+1/2,z+1/2,-x',
    ]
},

{
    number          => 202,
    hall            => '-F 2 2 3',
    schoenflies     => 'Th^3',
    hermann_mauguin => 'F m -3',
    universal_h_m   => 'F m -3',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        'z,x,y',
        '-z,-x,y',
        'z,-x,-y',
        '-z,x,-y',
        'y,z,x',
        'y,-z,-x',
        '-y,z,-x',
        '-y,-z,x',
        '-x,-y,-z',
        'x,y,-z',
        '-x,y,z',
        'x,-y,z',
        '-z,-x,-y',
        'z,x,-y',
        '-z,x,y',
        'z,-x,y',
        '-y,-z,-x',
        '-y,z,x',
        'y,-z,x',
        'y,z,-x',
        'x,y+1/2,z+1/2',
        '-x,-y+1/2,z+1/2',
        'x,-y+1/2,-z+1/2',
        '-x,y+1/2,-z+1/2',
        'z,x+1/2,y+1/2',
        '-z,-x+1/2,y+1/2',
        'z,-x+1/2,-y+1/2',
        '-z,x+1/2,-y+1/2',
        'y,z+1/2,x+1/2',
        'y,-z+1/2,-x+1/2',
        '-y,z+1/2,-x+1/2',
        '-y,-z+1/2,x+1/2',
        '-x,-y+1/2,-z+1/2',
        'x,y+1/2,-z+1/2',
        '-x,y+1/2,z+1/2',
        'x,-y+1/2,z+1/2',
        '-z,-x+1/2,-y+1/2',
        'z,x+1/2,-y+1/2',
        '-z,x+1/2,y+1/2',
        'z,-x+1/2,y+1/2',
        '-y,-z+1/2,-x+1/2',
        '-y,z+1/2,x+1/2',
        'y,-z+1/2,x+1/2',
        'y,z+1/2,-x+1/2',
        'x+1/2,y,z+1/2',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x+1/2,y,-z+1/2',
        'z+1/2,x,y+1/2',
        '-z+1/2,-x,y+1/2',
        'z+1/2,-x,-y+1/2',
        '-z+1/2,x,-y+1/2',
        'y+1/2,z,x+1/2',
        'y+1/2,-z,-x+1/2',
        '-y+1/2,z,-x+1/2',
        '-y+1/2,-z,x+1/2',
        '-x+1/2,-y,-z+1/2',
        'x+1/2,y,-z+1/2',
        '-x+1/2,y,z+1/2',
        'x+1/2,-y,z+1/2',
        '-z+1/2,-x,-y+1/2',
        'z+1/2,x,-y+1/2',
        '-z+1/2,x,y+1/2',
        'z+1/2,-x,y+1/2',
        '-y+1/2,-z,-x+1/2',
        '-y+1/2,z,x+1/2',
        'y+1/2,-z,x+1/2',
        'y+1/2,z,-x+1/2',
        'x+1/2,y+1/2,z',
        '-x+1/2,-y+1/2,z',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,y+1/2,-z',
        'z+1/2,x+1/2,y',
        '-z+1/2,-x+1/2,y',
        'z+1/2,-x+1/2,-y',
        '-z+1/2,x+1/2,-y',
        'y+1/2,z+1/2,x',
        'y+1/2,-z+1/2,-x',
        '-y+1/2,z+1/2,-x',
        '-y+1/2,-z+1/2,x',
        '-x+1/2,-y+1/2,-z',
        'x+1/2,y+1/2,-z',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y+1/2,z',
        '-z+1/2,-x+1/2,-y',
        'z+1/2,x+1/2,-y',
        '-z+1/2,x+1/2,y',
        'z+1/2,-x+1/2,y',
        '-y+1/2,-z+1/2,-x',
        '-y+1/2,z+1/2,x',
        'y+1/2,-z+1/2,x',
        'y+1/2,z+1/2,-x',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        'z,x,y',
        '-z,-x,y',
        'z,-x,-y',
        '-z,x,-y',
        'y,z,x',
        'y,-z,-x',
        '-y,z,-x',
        '-y,-z,x',
        '-x,-y,-z',
        'x,y,-z',
        '-x,y,z',
        'x,-y,z',
        '-z,-x,-y',
        'z,x,-y',
        '-z,x,y',
        'z,-x,y',
        '-y,-z,-x',
        '-y,z,x',
        'y,-z,x',
        'y,z,-x',
    ]
},

{
    number          => 203,
    hall            => 'F 2 2 3 -1d',
    schoenflies     => 'Th^4',
    hermann_mauguin => 'F d -3',
    universal_h_m   => 'F d -3 :1',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        'z,x,y',
        '-z,-x,y',
        'z,-x,-y',
        '-z,x,-y',
        'y,z,x',
        'y,-z,-x',
        '-y,z,-x',
        '-y,-z,x',
        '-x+1/4,-y+1/4,-z+1/4',
        'x+1/4,y+1/4,-z+1/4',
        '-x+1/4,y+1/4,z+1/4',
        'x+1/4,-y+1/4,z+1/4',
        '-z+1/4,-x+1/4,-y+1/4',
        'z+1/4,x+1/4,-y+1/4',
        '-z+1/4,x+1/4,y+1/4',
        'z+1/4,-x+1/4,y+1/4',
        '-y+1/4,-z+1/4,-x+1/4',
        '-y+1/4,z+1/4,x+1/4',
        'y+1/4,-z+1/4,x+1/4',
        'y+1/4,z+1/4,-x+1/4',
        'x,y+1/2,z+1/2',
        '-x,-y+1/2,z+1/2',
        'x,-y+1/2,-z+1/2',
        '-x,y+1/2,-z+1/2',
        'z,x+1/2,y+1/2',
        '-z,-x+1/2,y+1/2',
        'z,-x+1/2,-y+1/2',
        '-z,x+1/2,-y+1/2',
        'y,z+1/2,x+1/2',
        'y,-z+1/2,-x+1/2',
        '-y,z+1/2,-x+1/2',
        '-y,-z+1/2,x+1/2',
        '-x+1/4,-y+3/4,-z+3/4',
        'x+1/4,y+3/4,-z+3/4',
        '-x+1/4,y+3/4,z+3/4',
        'x+1/4,-y+3/4,z+3/4',
        '-z+1/4,-x+3/4,-y+3/4',
        'z+1/4,x+3/4,-y+3/4',
        '-z+1/4,x+3/4,y+3/4',
        'z+1/4,-x+3/4,y+3/4',
        '-y+1/4,-z+3/4,-x+3/4',
        '-y+1/4,z+3/4,x+3/4',
        'y+1/4,-z+3/4,x+3/4',
        'y+1/4,z+3/4,-x+3/4',
        'x+1/2,y,z+1/2',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x+1/2,y,-z+1/2',
        'z+1/2,x,y+1/2',
        '-z+1/2,-x,y+1/2',
        'z+1/2,-x,-y+1/2',
        '-z+1/2,x,-y+1/2',
        'y+1/2,z,x+1/2',
        'y+1/2,-z,-x+1/2',
        '-y+1/2,z,-x+1/2',
        '-y+1/2,-z,x+1/2',
        '-x+3/4,-y+1/4,-z+3/4',
        'x+3/4,y+1/4,-z+3/4',
        '-x+3/4,y+1/4,z+3/4',
        'x+3/4,-y+1/4,z+3/4',
        '-z+3/4,-x+1/4,-y+3/4',
        'z+3/4,x+1/4,-y+3/4',
        '-z+3/4,x+1/4,y+3/4',
        'z+3/4,-x+1/4,y+3/4',
        '-y+3/4,-z+1/4,-x+3/4',
        '-y+3/4,z+1/4,x+3/4',
        'y+3/4,-z+1/4,x+3/4',
        'y+3/4,z+1/4,-x+3/4',
        'x+1/2,y+1/2,z',
        '-x+1/2,-y+1/2,z',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,y+1/2,-z',
        'z+1/2,x+1/2,y',
        '-z+1/2,-x+1/2,y',
        'z+1/2,-x+1/2,-y',
        '-z+1/2,x+1/2,-y',
        'y+1/2,z+1/2,x',
        'y+1/2,-z+1/2,-x',
        '-y+1/2,z+1/2,-x',
        '-y+1/2,-z+1/2,x',
        '-x+3/4,-y+3/4,-z+1/4',
        'x+3/4,y+3/4,-z+1/4',
        '-x+3/4,y+3/4,z+1/4',
        'x+3/4,-y+3/4,z+1/4',
        '-z+3/4,-x+3/4,-y+1/4',
        'z+3/4,x+3/4,-y+1/4',
        '-z+3/4,x+3/4,y+1/4',
        'z+3/4,-x+3/4,y+1/4',
        '-y+3/4,-z+3/4,-x+1/4',
        '-y+3/4,z+3/4,x+1/4',
        'y+3/4,-z+3/4,x+1/4',
        'y+3/4,z+3/4,-x+1/4',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        'z,x,y',
        '-z,-x,y',
        'z,-x,-y',
        '-z,x,-y',
        'y,z,x',
        'y,-z,-x',
        '-y,z,-x',
        '-y,-z,x',
        '-x+1/4,-y+1/4,-z+1/4',
        'x+1/4,y+1/4,-z+1/4',
        '-x+1/4,y+1/4,z+1/4',
        'x+1/4,-y+1/4,z+1/4',
        '-z+1/4,-x+1/4,-y+1/4',
        'z+1/4,x+1/4,-y+1/4',
        '-z+1/4,x+1/4,y+1/4',
        'z+1/4,-x+1/4,y+1/4',
        '-y+1/4,-z+1/4,-x+1/4',
        '-y+1/4,z+1/4,x+1/4',
        'y+1/4,-z+1/4,x+1/4',
        'y+1/4,z+1/4,-x+1/4',
    ]
},

{
    number          => 203,
    hall            => '-F 2uv 2vw 3',
    schoenflies     => 'Th^4',
    hermann_mauguin => 'F d -3',
    universal_h_m   => 'F d -3 :2',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/4,-y+1/4,z',
        'x,-y+1/4,-z+1/4',
        '-x+1/4,y,-z+1/4',
        'z,x,y',
        '-z+1/4,-x+1/4,y',
        'z,-x+1/4,-y+1/4',
        '-z+1/4,x,-y+1/4',
        'y,z,x',
        'y,-z+1/4,-x+1/4',
        '-y+1/4,z,-x+1/4',
        '-y+1/4,-z+1/4,x',
        '-x,-y,-z',
        'x+3/4,y+3/4,-z',
        '-x,y+3/4,z+3/4',
        'x+3/4,-y,z+3/4',
        '-z,-x,-y',
        'z+3/4,x+3/4,-y',
        '-z,x+3/4,y+3/4',
        'z+3/4,-x,y+3/4',
        '-y,-z,-x',
        '-y,z+3/4,x+3/4',
        'y+3/4,-z,x+3/4',
        'y+3/4,z+3/4,-x',
        'x,y+1/2,z+1/2',
        '-x+1/4,-y+3/4,z+1/2',
        'x,-y+3/4,-z+3/4',
        '-x+1/4,y+1/2,-z+3/4',
        'z,x+1/2,y+1/2',
        '-z+1/4,-x+3/4,y+1/2',
        'z,-x+3/4,-y+3/4',
        '-z+1/4,x+1/2,-y+3/4',
        'y,z+1/2,x+1/2',
        'y,-z+3/4,-x+3/4',
        '-y+1/4,z+1/2,-x+3/4',
        '-y+1/4,-z+3/4,x+1/2',
        '-x,-y+1/2,-z+1/2',
        'x+3/4,y+1/4,-z+1/2',
        '-x,y+1/4,z+1/4',
        'x+3/4,-y+1/2,z+1/4',
        '-z,-x+1/2,-y+1/2',
        'z+3/4,x+1/4,-y+1/2',
        '-z,x+1/4,y+1/4',
        'z+3/4,-x+1/2,y+1/4',
        '-y,-z+1/2,-x+1/2',
        '-y,z+1/4,x+1/4',
        'y+3/4,-z+1/2,x+1/4',
        'y+3/4,z+1/4,-x+1/2',
        'x+1/2,y,z+1/2',
        '-x+3/4,-y+1/4,z+1/2',
        'x+1/2,-y+1/4,-z+3/4',
        '-x+3/4,y,-z+3/4',
        'z+1/2,x,y+1/2',
        '-z+3/4,-x+1/4,y+1/2',
        'z+1/2,-x+1/4,-y+3/4',
        '-z+3/4,x,-y+3/4',
        'y+1/2,z,x+1/2',
        'y+1/2,-z+1/4,-x+3/4',
        '-y+3/4,z,-x+3/4',
        '-y+3/4,-z+1/4,x+1/2',
        '-x+1/2,-y,-z+1/2',
        'x+1/4,y+3/4,-z+1/2',
        '-x+1/2,y+3/4,z+1/4',
        'x+1/4,-y,z+1/4',
        '-z+1/2,-x,-y+1/2',
        'z+1/4,x+3/4,-y+1/2',
        '-z+1/2,x+3/4,y+1/4',
        'z+1/4,-x,y+1/4',
        '-y+1/2,-z,-x+1/2',
        '-y+1/2,z+3/4,x+1/4',
        'y+1/4,-z,x+1/4',
        'y+1/4,z+3/4,-x+1/2',
        'x+1/2,y+1/2,z',
        '-x+3/4,-y+3/4,z',
        'x+1/2,-y+3/4,-z+1/4',
        '-x+3/4,y+1/2,-z+1/4',
        'z+1/2,x+1/2,y',
        '-z+3/4,-x+3/4,y',
        'z+1/2,-x+3/4,-y+1/4',
        '-z+3/4,x+1/2,-y+1/4',
        'y+1/2,z+1/2,x',
        'y+1/2,-z+3/4,-x+1/4',
        '-y+3/4,z+1/2,-x+1/4',
        '-y+3/4,-z+3/4,x',
        '-x+1/2,-y+1/2,-z',
        'x+1/4,y+1/4,-z',
        '-x+1/2,y+1/4,z+3/4',
        'x+1/4,-y+1/2,z+3/4',
        '-z+1/2,-x+1/2,-y',
        'z+1/4,x+1/4,-y',
        '-z+1/2,x+1/4,y+3/4',
        'z+1/4,-x+1/2,y+3/4',
        '-y+1/2,-z+1/2,-x',
        '-y+1/2,z+1/4,x+3/4',
        'y+1/4,-z+1/2,x+3/4',
        'y+1/4,z+1/4,-x',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/4,-y+1/4,z',
        'x,-y+1/4,-z+1/4',
        '-x+1/4,y,-z+1/4',
        'z,x,y',
        '-z+1/4,-x+1/4,y',
        'z,-x+1/4,-y+1/4',
        '-z+1/4,x,-y+1/4',
        'y,z,x',
        'y,-z+1/4,-x+1/4',
        '-y+1/4,z,-x+1/4',
        '-y+1/4,-z+1/4,x',
        '-x,-y,-z',
        'x+3/4,y+3/4,-z',
        '-x,y+3/4,z+3/4',
        'x+3/4,-y,z+3/4',
        '-z,-x,-y',
        'z+3/4,x+3/4,-y',
        '-z,x+3/4,y+3/4',
        'z+3/4,-x,y+3/4',
        '-y,-z,-x',
        '-y,z+3/4,x+3/4',
        'y+3/4,-z,x+3/4',
        'y+3/4,z+3/4,-x',
    ]
},

{
    number          => 204,
    hall            => '-I 2 2 3',
    schoenflies     => 'Th^5',
    hermann_mauguin => 'I m -3',
    universal_h_m   => 'I m -3',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        'z,x,y',
        '-z,-x,y',
        'z,-x,-y',
        '-z,x,-y',
        'y,z,x',
        'y,-z,-x',
        '-y,z,-x',
        '-y,-z,x',
        '-x,-y,-z',
        'x,y,-z',
        '-x,y,z',
        'x,-y,z',
        '-z,-x,-y',
        'z,x,-y',
        '-z,x,y',
        'z,-x,y',
        '-y,-z,-x',
        '-y,z,x',
        'y,-z,x',
        'y,z,-x',
        'x+1/2,y+1/2,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        'z+1/2,x+1/2,y+1/2',
        '-z+1/2,-x+1/2,y+1/2',
        'z+1/2,-x+1/2,-y+1/2',
        '-z+1/2,x+1/2,-y+1/2',
        'y+1/2,z+1/2,x+1/2',
        'y+1/2,-z+1/2,-x+1/2',
        '-y+1/2,z+1/2,-x+1/2',
        '-y+1/2,-z+1/2,x+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        '-z+1/2,-x+1/2,-y+1/2',
        'z+1/2,x+1/2,-y+1/2',
        '-z+1/2,x+1/2,y+1/2',
        'z+1/2,-x+1/2,y+1/2',
        '-y+1/2,-z+1/2,-x+1/2',
        '-y+1/2,z+1/2,x+1/2',
        'y+1/2,-z+1/2,x+1/2',
        'y+1/2,z+1/2,-x+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        'z,x,y',
        '-z,-x,y',
        'z,-x,-y',
        '-z,x,-y',
        'y,z,x',
        'y,-z,-x',
        '-y,z,-x',
        '-y,-z,x',
        '-x,-y,-z',
        'x,y,-z',
        '-x,y,z',
        'x,-y,z',
        '-z,-x,-y',
        'z,x,-y',
        '-z,x,y',
        'z,-x,y',
        '-y,-z,-x',
        '-y,z,x',
        'y,-z,x',
        'y,z,-x',
    ]
},

{
    number          => 205,
    hall            => '-P 2ac 2ab 3',
    schoenflies     => 'Th^6',
    hermann_mauguin => 'P a -3',
    universal_h_m   => 'P a -3',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y+1/2,-z',
        '-x,y+1/2,-z+1/2',
        'z,x,y',
        '-z+1/2,-x,y+1/2',
        'z+1/2,-x+1/2,-y',
        '-z,x+1/2,-y+1/2',
        'y,z,x',
        'y+1/2,-z+1/2,-x',
        '-y,z+1/2,-x+1/2',
        '-y+1/2,-z,x+1/2',
        '-x,-y,-z',
        'x+1/2,y,-z+1/2',
        '-x+1/2,y+1/2,z',
        'x,-y+1/2,z+1/2',
        '-z,-x,-y',
        'z+1/2,x,-y+1/2',
        '-z+1/2,x+1/2,y',
        'z,-x+1/2,y+1/2',
        '-y,-z,-x',
        '-y+1/2,z+1/2,x',
        'y,-z+1/2,x+1/2',
        'y+1/2,z,-x+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y+1/2,-z',
        '-x,y+1/2,-z+1/2',
        'z,x,y',
        '-z+1/2,-x,y+1/2',
        'z+1/2,-x+1/2,-y',
        '-z,x+1/2,-y+1/2',
        'y,z,x',
        'y+1/2,-z+1/2,-x',
        '-y,z+1/2,-x+1/2',
        '-y+1/2,-z,x+1/2',
        '-x,-y,-z',
        'x+1/2,y,-z+1/2',
        '-x+1/2,y+1/2,z',
        'x,-y+1/2,z+1/2',
        '-z,-x,-y',
        'z+1/2,x,-y+1/2',
        '-z+1/2,x+1/2,y',
        'z,-x+1/2,y+1/2',
        '-y,-z,-x',
        '-y+1/2,z+1/2,x',
        'y,-z+1/2,x+1/2',
        'y+1/2,z,-x+1/2',
    ]
},

{
    number          => 206,
    hall            => '-I 2b 2c 3',
    schoenflies     => 'Th^7',
    hermann_mauguin => 'I a -3',
    universal_h_m   => 'I a -3',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x,-y,-z+1/2',
        '-x,y+1/2,-z+1/2',
        'z,x,y',
        '-z,-x+1/2,y',
        'z,-x,-y+1/2',
        '-z,x+1/2,-y+1/2',
        'y,z,x',
        'y,-z,-x+1/2',
        '-y,z+1/2,-x+1/2',
        '-y+1/2,-z,x+1/2',
        '-x,-y,-z',
        'x,y+1/2,-z',
        '-x,y,z+1/2',
        'x,-y+1/2,z+1/2',
        '-z,-x,-y',
        'z,x+1/2,-y',
        '-z,x,y+1/2',
        'z,-x+1/2,y+1/2',
        '-y,-z,-x',
        '-y,z,x+1/2',
        'y,-z+1/2,x+1/2',
        'y+1/2,z,-x+1/2',
        'x+1/2,y+1/2,z+1/2',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,y,-z',
        'z+1/2,x+1/2,y+1/2',
        '-z+1/2,-x,y+1/2',
        'z+1/2,-x+1/2,-y',
        '-z+1/2,x,-y',
        'y+1/2,z+1/2,x+1/2',
        'y+1/2,-z+1/2,-x',
        '-y+1/2,z,-x',
        '-y,-z+1/2,x',
        '-x+1/2,-y+1/2,-z+1/2',
        'x+1/2,y,-z+1/2',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y,z',
        '-z+1/2,-x+1/2,-y+1/2',
        'z+1/2,x,-y+1/2',
        '-z+1/2,x+1/2,y',
        'z+1/2,-x,y',
        '-y+1/2,-z+1/2,-x+1/2',
        '-y+1/2,z+1/2,x',
        'y+1/2,-z,x',
        'y,z+1/2,-x',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x,-y,-z+1/2',
        '-x,y+1/2,-z+1/2',
        'z,x,y',
        '-z,-x+1/2,y',
        'z,-x,-y+1/2',
        '-z,x+1/2,-y+1/2',
        'y,z,x',
        'y,-z,-x+1/2',
        '-y,z+1/2,-x+1/2',
        '-y+1/2,-z,x+1/2',
        '-x,-y,-z',
        'x,y+1/2,-z',
        '-x,y,z+1/2',
        'x,-y+1/2,z+1/2',
        '-z,-x,-y',
        'z,x+1/2,-y',
        '-z,x,y+1/2',
        'z,-x+1/2,y+1/2',
        '-y,-z,-x',
        '-y,z,x+1/2',
        'y,-z+1/2,x+1/2',
        'y+1/2,z,-x+1/2',
    ]
},

{
    number          => 207,
    hall            => 'P 4 2 3',
    schoenflies     => 'O^1',
    hermann_mauguin => 'P 4 3 2',
    universal_h_m   => 'P 4 3 2',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x,-y,-z',
        'y,x,-z',
        '-x,y,-z',
        '-y,-x,-z',
        'z,x,y',
        '-x,z,y',
        '-z,-x,y',
        'x,-z,y',
        'z,-x,-y',
        'x,z,-y',
        '-z,x,-y',
        '-x,-z,-y',
        'y,z,x',
        'y,-z,-x',
        'z,y,-x',
        '-y,z,-x',
        '-z,-y,-x',
        '-y,-z,x',
        'z,-y,x',
        '-z,y,x',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x,-y,-z',
        'y,x,-z',
        '-x,y,-z',
        '-y,-x,-z',
        'z,x,y',
        '-x,z,y',
        '-z,-x,y',
        'x,-z,y',
        'z,-x,-y',
        'x,z,-y',
        '-z,x,-y',
        '-x,-z,-y',
        'y,z,x',
        'y,-z,-x',
        'z,y,-x',
        '-y,z,-x',
        '-z,-y,-x',
        '-y,-z,x',
        'z,-y,x',
        '-z,y,x',
    ]
},

{
    number          => 208,
    hall            => 'P 4n 2 3',
    schoenflies     => 'O^2',
    hermann_mauguin => 'P 42 3 2',
    universal_h_m   => 'P 42 3 2',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x+1/2,z+1/2',
        '-x,-y,z',
        'y+1/2,-x+1/2,z+1/2',
        'x,-y,-z',
        'y+1/2,x+1/2,-z+1/2',
        '-x,y,-z',
        '-y+1/2,-x+1/2,-z+1/2',
        'z,x,y',
        '-x+1/2,z+1/2,y+1/2',
        '-z,-x,y',
        'x+1/2,-z+1/2,y+1/2',
        'z,-x,-y',
        'x+1/2,z+1/2,-y+1/2',
        '-z,x,-y',
        '-x+1/2,-z+1/2,-y+1/2',
        'y,z,x',
        'y,-z,-x',
        'z+1/2,y+1/2,-x+1/2',
        '-y,z,-x',
        '-z+1/2,-y+1/2,-x+1/2',
        '-y,-z,x',
        'z+1/2,-y+1/2,x+1/2',
        '-z+1/2,y+1/2,x+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x+1/2,z+1/2',
        '-x,-y,z',
        'y+1/2,-x+1/2,z+1/2',
        'x,-y,-z',
        'y+1/2,x+1/2,-z+1/2',
        '-x,y,-z',
        '-y+1/2,-x+1/2,-z+1/2',
        'z,x,y',
        '-x+1/2,z+1/2,y+1/2',
        '-z,-x,y',
        'x+1/2,-z+1/2,y+1/2',
        'z,-x,-y',
        'x+1/2,z+1/2,-y+1/2',
        '-z,x,-y',
        '-x+1/2,-z+1/2,-y+1/2',
        'y,z,x',
        'y,-z,-x',
        'z+1/2,y+1/2,-x+1/2',
        '-y,z,-x',
        '-z+1/2,-y+1/2,-x+1/2',
        '-y,-z,x',
        'z+1/2,-y+1/2,x+1/2',
        '-z+1/2,y+1/2,x+1/2',
    ]
},

{
    number          => 209,
    hall            => 'F 4 2 3',
    schoenflies     => 'O^3',
    hermann_mauguin => 'F 4 3 2',
    universal_h_m   => 'F 4 3 2',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x,-y,-z',
        'y,x,-z',
        '-x,y,-z',
        '-y,-x,-z',
        'z,x,y',
        '-x,z,y',
        '-z,-x,y',
        'x,-z,y',
        'z,-x,-y',
        'x,z,-y',
        '-z,x,-y',
        '-x,-z,-y',
        'y,z,x',
        'y,-z,-x',
        'z,y,-x',
        '-y,z,-x',
        '-z,-y,-x',
        '-y,-z,x',
        'z,-y,x',
        '-z,y,x',
        'x,y+1/2,z+1/2',
        '-y,x+1/2,z+1/2',
        '-x,-y+1/2,z+1/2',
        'y,-x+1/2,z+1/2',
        'x,-y+1/2,-z+1/2',
        'y,x+1/2,-z+1/2',
        '-x,y+1/2,-z+1/2',
        '-y,-x+1/2,-z+1/2',
        'z,x+1/2,y+1/2',
        '-x,z+1/2,y+1/2',
        '-z,-x+1/2,y+1/2',
        'x,-z+1/2,y+1/2',
        'z,-x+1/2,-y+1/2',
        'x,z+1/2,-y+1/2',
        '-z,x+1/2,-y+1/2',
        '-x,-z+1/2,-y+1/2',
        'y,z+1/2,x+1/2',
        'y,-z+1/2,-x+1/2',
        'z,y+1/2,-x+1/2',
        '-y,z+1/2,-x+1/2',
        '-z,-y+1/2,-x+1/2',
        '-y,-z+1/2,x+1/2',
        'z,-y+1/2,x+1/2',
        '-z,y+1/2,x+1/2',
        'x+1/2,y,z+1/2',
        '-y+1/2,x,z+1/2',
        '-x+1/2,-y,z+1/2',
        'y+1/2,-x,z+1/2',
        'x+1/2,-y,-z+1/2',
        'y+1/2,x,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-y+1/2,-x,-z+1/2',
        'z+1/2,x,y+1/2',
        '-x+1/2,z,y+1/2',
        '-z+1/2,-x,y+1/2',
        'x+1/2,-z,y+1/2',
        'z+1/2,-x,-y+1/2',
        'x+1/2,z,-y+1/2',
        '-z+1/2,x,-y+1/2',
        '-x+1/2,-z,-y+1/2',
        'y+1/2,z,x+1/2',
        'y+1/2,-z,-x+1/2',
        'z+1/2,y,-x+1/2',
        '-y+1/2,z,-x+1/2',
        '-z+1/2,-y,-x+1/2',
        '-y+1/2,-z,x+1/2',
        'z+1/2,-y,x+1/2',
        '-z+1/2,y,x+1/2',
        'x+1/2,y+1/2,z',
        '-y+1/2,x+1/2,z',
        '-x+1/2,-y+1/2,z',
        'y+1/2,-x+1/2,z',
        'x+1/2,-y+1/2,-z',
        'y+1/2,x+1/2,-z',
        '-x+1/2,y+1/2,-z',
        '-y+1/2,-x+1/2,-z',
        'z+1/2,x+1/2,y',
        '-x+1/2,z+1/2,y',
        '-z+1/2,-x+1/2,y',
        'x+1/2,-z+1/2,y',
        'z+1/2,-x+1/2,-y',
        'x+1/2,z+1/2,-y',
        '-z+1/2,x+1/2,-y',
        '-x+1/2,-z+1/2,-y',
        'y+1/2,z+1/2,x',
        'y+1/2,-z+1/2,-x',
        'z+1/2,y+1/2,-x',
        '-y+1/2,z+1/2,-x',
        '-z+1/2,-y+1/2,-x',
        '-y+1/2,-z+1/2,x',
        'z+1/2,-y+1/2,x',
        '-z+1/2,y+1/2,x',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x,-y,-z',
        'y,x,-z',
        '-x,y,-z',
        '-y,-x,-z',
        'z,x,y',
        '-x,z,y',
        '-z,-x,y',
        'x,-z,y',
        'z,-x,-y',
        'x,z,-y',
        '-z,x,-y',
        '-x,-z,-y',
        'y,z,x',
        'y,-z,-x',
        'z,y,-x',
        '-y,z,-x',
        '-z,-y,-x',
        '-y,-z,x',
        'z,-y,x',
        '-z,y,x',
    ]
},

{
    number          => 210,
    hall            => 'F 4d 2 3',
    schoenflies     => 'O^4',
    hermann_mauguin => 'F 41 3 2',
    universal_h_m   => 'F 41 3 2',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/4,x+1/4,z+1/4',
        '-x,-y+1/2,z+1/2',
        'y+3/4,-x+1/4,z+3/4',
        'x,-y,-z',
        'y+1/4,x+1/4,-z+1/4',
        '-x,y+1/2,-z+1/2',
        '-y+3/4,-x+1/4,-z+3/4',
        'z,x,y',
        '-x+1/4,z+1/4,y+1/4',
        '-z,-x+1/2,y+1/2',
        'x+3/4,-z+1/4,y+3/4',
        'z,-x,-y',
        'x+1/4,z+1/4,-y+1/4',
        '-z,x+1/2,-y+1/2',
        '-x+3/4,-z+1/4,-y+3/4',
        'y,z,x',
        'y+1/2,-z,-x+1/2',
        'z+1/4,y+3/4,-x+3/4',
        '-y+1/2,z+1/2,-x',
        '-z+1/4,-y+1/4,-x+1/4',
        '-y,-z,x',
        'z+1/4,-y+3/4,x+3/4',
        '-z+3/4,y+3/4,x+1/4',
        'x,y+1/2,z+1/2',
        '-y+1/4,x+3/4,z+3/4',
        '-x,-y,z',
        'y+3/4,-x+3/4,z+1/4',
        'x,-y+1/2,-z+1/2',
        'y+1/4,x+3/4,-z+3/4',
        '-x,y,-z',
        '-y+3/4,-x+3/4,-z+1/4',
        'z,x+1/2,y+1/2',
        '-x+1/4,z+3/4,y+3/4',
        '-z,-x,y',
        'x+3/4,-z+3/4,y+1/4',
        'z,-x+1/2,-y+1/2',
        'x+1/4,z+3/4,-y+3/4',
        '-z,x,-y',
        '-x+3/4,-z+3/4,-y+1/4',
        'y,z+1/2,x+1/2',
        'y+1/2,-z+1/2,-x',
        'z+1/4,y+1/4,-x+1/4',
        '-y+1/2,z,-x+1/2',
        '-z+1/4,-y+3/4,-x+3/4',
        '-y,-z+1/2,x+1/2',
        'z+1/4,-y+1/4,x+1/4',
        '-z+3/4,y+1/4,x+3/4',
        'x+1/2,y,z+1/2',
        '-y+3/4,x+1/4,z+3/4',
        '-x+1/2,-y+1/2,z',
        'y+1/4,-x+1/4,z+1/4',
        'x+1/2,-y,-z+1/2',
        'y+3/4,x+1/4,-z+3/4',
        '-x+1/2,y+1/2,-z',
        '-y+1/4,-x+1/4,-z+1/4',
        'z+1/2,x,y+1/2',
        '-x+3/4,z+1/4,y+3/4',
        '-z+1/2,-x+1/2,y',
        'x+1/4,-z+1/4,y+1/4',
        'z+1/2,-x,-y+1/2',
        'x+3/4,z+1/4,-y+3/4',
        '-z+1/2,x+1/2,-y',
        '-x+1/4,-z+1/4,-y+1/4',
        'y+1/2,z,x+1/2',
        'y,-z,-x',
        'z+3/4,y+3/4,-x+1/4',
        '-y,z+1/2,-x+1/2',
        '-z+3/4,-y+1/4,-x+3/4',
        '-y+1/2,-z,x+1/2',
        'z+3/4,-y+3/4,x+1/4',
        '-z+1/4,y+3/4,x+3/4',
        'x+1/2,y+1/2,z',
        '-y+3/4,x+3/4,z+1/4',
        '-x+1/2,-y,z+1/2',
        'y+1/4,-x+3/4,z+3/4',
        'x+1/2,-y+1/2,-z',
        'y+3/4,x+3/4,-z+1/4',
        '-x+1/2,y,-z+1/2',
        '-y+1/4,-x+3/4,-z+3/4',
        'z+1/2,x+1/2,y',
        '-x+3/4,z+3/4,y+1/4',
        '-z+1/2,-x,y+1/2',
        'x+1/4,-z+3/4,y+3/4',
        'z+1/2,-x+1/2,-y',
        'x+3/4,z+3/4,-y+1/4',
        '-z+1/2,x,-y+1/2',
        '-x+1/4,-z+3/4,-y+3/4',
        'y+1/2,z+1/2,x',
        'y,-z+1/2,-x+1/2',
        'z+3/4,y+1/4,-x+3/4',
        '-y,z,-x',
        '-z+3/4,-y+3/4,-x+1/4',
        '-y+1/2,-z+1/2,x',
        'z+3/4,-y+1/4,x+3/4',
        '-z+1/4,y+1/4,x+1/4',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/4,x+1/4,z+1/4',
        '-x,-y+1/2,z+1/2',
        'y+3/4,-x+1/4,z+3/4',
        'x,-y,-z',
        'y+1/4,x+1/4,-z+1/4',
        '-x,y+1/2,-z+1/2',
        '-y+3/4,-x+1/4,-z+3/4',
        'z,x,y',
        '-x+1/4,z+1/4,y+1/4',
        '-z,-x+1/2,y+1/2',
        'x+3/4,-z+1/4,y+3/4',
        'z,-x,-y',
        'x+1/4,z+1/4,-y+1/4',
        '-z,x+1/2,-y+1/2',
        '-x+3/4,-z+1/4,-y+3/4',
        'y,z,x',
        'y+1/2,-z,-x+1/2',
        'z+1/4,y+3/4,-x+3/4',
        '-y+1/2,z+1/2,-x',
        '-z+1/4,-y+1/4,-x+1/4',
        '-y,-z,x',
        'z+1/4,-y+3/4,x+3/4',
        '-z+3/4,y+3/4,x+1/4',
    ]
},

{
    number          => 211,
    hall            => 'I 4 2 3',
    schoenflies     => 'O^5',
    hermann_mauguin => 'I 4 3 2',
    universal_h_m   => 'I 4 3 2',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x,-y,-z',
        'y,x,-z',
        '-x,y,-z',
        '-y,-x,-z',
        'z,x,y',
        '-x,z,y',
        '-z,-x,y',
        'x,-z,y',
        'z,-x,-y',
        'x,z,-y',
        '-z,x,-y',
        '-x,-z,-y',
        'y,z,x',
        'y,-z,-x',
        'z,y,-x',
        '-y,z,-x',
        '-z,-y,-x',
        '-y,-z,x',
        'z,-y,x',
        '-z,y,x',
        'x+1/2,y+1/2,z+1/2',
        '-y+1/2,x+1/2,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        'y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        'y+1/2,x+1/2,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-y+1/2,-x+1/2,-z+1/2',
        'z+1/2,x+1/2,y+1/2',
        '-x+1/2,z+1/2,y+1/2',
        '-z+1/2,-x+1/2,y+1/2',
        'x+1/2,-z+1/2,y+1/2',
        'z+1/2,-x+1/2,-y+1/2',
        'x+1/2,z+1/2,-y+1/2',
        '-z+1/2,x+1/2,-y+1/2',
        '-x+1/2,-z+1/2,-y+1/2',
        'y+1/2,z+1/2,x+1/2',
        'y+1/2,-z+1/2,-x+1/2',
        'z+1/2,y+1/2,-x+1/2',
        '-y+1/2,z+1/2,-x+1/2',
        '-z+1/2,-y+1/2,-x+1/2',
        '-y+1/2,-z+1/2,x+1/2',
        'z+1/2,-y+1/2,x+1/2',
        '-z+1/2,y+1/2,x+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x,-y,-z',
        'y,x,-z',
        '-x,y,-z',
        '-y,-x,-z',
        'z,x,y',
        '-x,z,y',
        '-z,-x,y',
        'x,-z,y',
        'z,-x,-y',
        'x,z,-y',
        '-z,x,-y',
        '-x,-z,-y',
        'y,z,x',
        'y,-z,-x',
        'z,y,-x',
        '-y,z,-x',
        '-z,-y,-x',
        '-y,-z,x',
        'z,-y,x',
        '-z,y,x',
    ]
},

{
    number          => 212,
    hall            => 'P 4acd 2ab 3',
    schoenflies     => 'O^6',
    hermann_mauguin => 'P 43 3 2',
    universal_h_m   => 'P 43 3 2',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+3/4,x+1/4,z+3/4',
        '-x+1/2,-y,z+1/2',
        'y+3/4,-x+3/4,z+1/4',
        'x+1/2,-y+1/2,-z',
        'y+1/4,x+3/4,-z+3/4',
        '-x,y+1/2,-z+1/2',
        '-y+1/4,-x+1/4,-z+1/4',
        'z,x,y',
        '-x+3/4,z+1/4,y+3/4',
        '-z+1/2,-x,y+1/2',
        'x+3/4,-z+3/4,y+1/4',
        'z+1/2,-x+1/2,-y',
        'x+1/4,z+3/4,-y+3/4',
        '-z,x+1/2,-y+1/2',
        '-x+1/4,-z+1/4,-y+1/4',
        'y,z,x',
        'y+1/2,-z+1/2,-x',
        'z+1/4,y+3/4,-x+3/4',
        '-y,z+1/2,-x+1/2',
        '-z+1/4,-y+1/4,-x+1/4',
        '-y+1/2,-z,x+1/2',
        'z+3/4,-y+3/4,x+1/4',
        '-z+3/4,y+1/4,x+3/4',
    ],
    ncsym => [
        'x,y,z',
        '-y+3/4,x+1/4,z+3/4',
        '-x+1/2,-y,z+1/2',
        'y+3/4,-x+3/4,z+1/4',
        'x+1/2,-y+1/2,-z',
        'y+1/4,x+3/4,-z+3/4',
        '-x,y+1/2,-z+1/2',
        '-y+1/4,-x+1/4,-z+1/4',
        'z,x,y',
        '-x+3/4,z+1/4,y+3/4',
        '-z+1/2,-x,y+1/2',
        'x+3/4,-z+3/4,y+1/4',
        'z+1/2,-x+1/2,-y',
        'x+1/4,z+3/4,-y+3/4',
        '-z,x+1/2,-y+1/2',
        '-x+1/4,-z+1/4,-y+1/4',
        'y,z,x',
        'y+1/2,-z+1/2,-x',
        'z+1/4,y+3/4,-x+3/4',
        '-y,z+1/2,-x+1/2',
        '-z+1/4,-y+1/4,-x+1/4',
        '-y+1/2,-z,x+1/2',
        'z+3/4,-y+3/4,x+1/4',
        '-z+3/4,y+1/4,x+3/4',
    ]
},

{
    number          => 213,
    hall            => 'P 4bd 2ab 3',
    schoenflies     => 'O^7',
    hermann_mauguin => 'P 41 3 2',
    universal_h_m   => 'P 41 3 2',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/4,x+3/4,z+1/4',
        '-x+1/2,-y,z+1/2',
        'y+1/4,-x+1/4,z+3/4',
        'x+1/2,-y+1/2,-z',
        'y+3/4,x+1/4,-z+1/4',
        '-x,y+1/2,-z+1/2',
        '-y+3/4,-x+3/4,-z+3/4',
        'z,x,y',
        '-x+1/4,z+3/4,y+1/4',
        '-z+1/2,-x,y+1/2',
        'x+1/4,-z+1/4,y+3/4',
        'z+1/2,-x+1/2,-y',
        'x+3/4,z+1/4,-y+1/4',
        '-z,x+1/2,-y+1/2',
        '-x+3/4,-z+3/4,-y+3/4',
        'y,z,x',
        'y+1/2,-z+1/2,-x',
        'z+3/4,y+1/4,-x+1/4',
        '-y,z+1/2,-x+1/2',
        '-z+3/4,-y+3/4,-x+3/4',
        '-y+1/2,-z,x+1/2',
        'z+1/4,-y+1/4,x+3/4',
        '-z+1/4,y+3/4,x+1/4',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/4,x+3/4,z+1/4',
        '-x+1/2,-y,z+1/2',
        'y+1/4,-x+1/4,z+3/4',
        'x+1/2,-y+1/2,-z',
        'y+3/4,x+1/4,-z+1/4',
        '-x,y+1/2,-z+1/2',
        '-y+3/4,-x+3/4,-z+3/4',
        'z,x,y',
        '-x+1/4,z+3/4,y+1/4',
        '-z+1/2,-x,y+1/2',
        'x+1/4,-z+1/4,y+3/4',
        'z+1/2,-x+1/2,-y',
        'x+3/4,z+1/4,-y+1/4',
        '-z,x+1/2,-y+1/2',
        '-x+3/4,-z+3/4,-y+3/4',
        'y,z,x',
        'y+1/2,-z+1/2,-x',
        'z+3/4,y+1/4,-x+1/4',
        '-y,z+1/2,-x+1/2',
        '-z+3/4,-y+3/4,-x+3/4',
        '-y+1/2,-z,x+1/2',
        'z+1/4,-y+1/4,x+3/4',
        '-z+1/4,y+3/4,x+1/4',
    ]
},

{
    number          => 214,
    hall            => 'I 4bd 2c 3',
    schoenflies     => 'O^8',
    hermann_mauguin => 'I 41 3 2',
    universal_h_m   => 'I 41 3 2',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/4,x+3/4,z+1/4',
        '-x+1/2,-y,z+1/2',
        'y+1/4,-x+1/4,z+3/4',
        'x,-y,-z+1/2',
        'y+1/4,x+3/4,-z+3/4',
        '-x+1/2,y,-z',
        '-y+1/4,-x+1/4,-z+1/4',
        'z,x,y',
        '-x+1/4,z+3/4,y+1/4',
        '-z+1/2,-x,y+1/2',
        'x+1/4,-z+1/4,y+3/4',
        'z,-x,-y+1/2',
        'x+1/4,z+3/4,-y+3/4',
        '-z+1/2,x,-y',
        '-x+1/4,-z+1/4,-y+1/4',
        'y,z,x',
        'y+1/2,-z+1/2,-x',
        'z+3/4,y+1/4,-x+1/4',
        '-y,z+1/2,-x+1/2',
        '-z+1/4,-y+1/4,-x+1/4',
        '-y+1/2,-z,x+1/2',
        'z+3/4,-y+3/4,x+1/4',
        '-z+3/4,y+1/4,x+3/4',
        'x+1/2,y+1/2,z+1/2',
        '-y+3/4,x+1/4,z+3/4',
        '-x,-y+1/2,z',
        'y+3/4,-x+3/4,z+1/4',
        'x+1/2,-y+1/2,-z',
        'y+3/4,x+1/4,-z+1/4',
        '-x,y+1/2,-z+1/2',
        '-y+3/4,-x+3/4,-z+3/4',
        'z+1/2,x+1/2,y+1/2',
        '-x+3/4,z+1/4,y+3/4',
        '-z,-x+1/2,y',
        'x+3/4,-z+3/4,y+1/4',
        'z+1/2,-x+1/2,-y',
        'x+3/4,z+1/4,-y+1/4',
        '-z,x+1/2,-y+1/2',
        '-x+3/4,-z+3/4,-y+3/4',
        'y+1/2,z+1/2,x+1/2',
        'y,-z,-x+1/2',
        'z+1/4,y+3/4,-x+3/4',
        '-y+1/2,z,-x',
        '-z+3/4,-y+3/4,-x+3/4',
        '-y,-z+1/2,x',
        'z+1/4,-y+1/4,x+3/4',
        '-z+1/4,y+3/4,x+1/4',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/4,x+3/4,z+1/4',
        '-x+1/2,-y,z+1/2',
        'y+1/4,-x+1/4,z+3/4',
        'x,-y,-z+1/2',
        'y+1/4,x+3/4,-z+3/4',
        '-x+1/2,y,-z',
        '-y+1/4,-x+1/4,-z+1/4',
        'z,x,y',
        '-x+1/4,z+3/4,y+1/4',
        '-z+1/2,-x,y+1/2',
        'x+1/4,-z+1/4,y+3/4',
        'z,-x,-y+1/2',
        'x+1/4,z+3/4,-y+3/4',
        '-z+1/2,x,-y',
        '-x+1/4,-z+1/4,-y+1/4',
        'y,z,x',
        'y+1/2,-z+1/2,-x',
        'z+3/4,y+1/4,-x+1/4',
        '-y,z+1/2,-x+1/2',
        '-z+1/4,-y+1/4,-x+1/4',
        '-y+1/2,-z,x+1/2',
        'z+3/4,-y+3/4,x+1/4',
        '-z+3/4,y+1/4,x+3/4',
    ]
},

{
    number          => 215,
    hall            => 'P -4 2 3',
    schoenflies     => 'Td^1',
    hermann_mauguin => 'P -4 3 m',
    universal_h_m   => 'P -4 3 m',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'y,-x,-z',
        '-x,-y,z',
        '-y,x,-z',
        'x,-y,-z',
        '-y,-x,z',
        '-x,y,-z',
        'y,x,z',
        'z,x,y',
        'x,-z,-y',
        '-z,-x,y',
        '-x,z,-y',
        'z,-x,-y',
        '-x,-z,y',
        '-z,x,-y',
        'x,z,y',
        'y,z,x',
        'y,-z,-x',
        '-z,-y,x',
        '-y,z,-x',
        'z,y,x',
        '-y,-z,x',
        '-z,y,-x',
        'z,-y,-x',
    ],
    ncsym => [
        'x,y,z',
        'y,-x,-z',
        '-x,-y,z',
        '-y,x,-z',
        'x,-y,-z',
        '-y,-x,z',
        '-x,y,-z',
        'y,x,z',
        'z,x,y',
        'x,-z,-y',
        '-z,-x,y',
        '-x,z,-y',
        'z,-x,-y',
        '-x,-z,y',
        '-z,x,-y',
        'x,z,y',
        'y,z,x',
        'y,-z,-x',
        '-z,-y,x',
        '-y,z,-x',
        'z,y,x',
        '-y,-z,x',
        '-z,y,-x',
        'z,-y,-x',
    ]
},

{
    number          => 216,
    hall            => 'F -4 2 3',
    schoenflies     => 'Td^2',
    hermann_mauguin => 'F -4 3 m',
    universal_h_m   => 'F -4 3 m',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'y,-x,-z',
        '-x,-y,z',
        '-y,x,-z',
        'x,-y,-z',
        '-y,-x,z',
        '-x,y,-z',
        'y,x,z',
        'z,x,y',
        'x,-z,-y',
        '-z,-x,y',
        '-x,z,-y',
        'z,-x,-y',
        '-x,-z,y',
        '-z,x,-y',
        'x,z,y',
        'y,z,x',
        'y,-z,-x',
        '-z,-y,x',
        '-y,z,-x',
        'z,y,x',
        '-y,-z,x',
        '-z,y,-x',
        'z,-y,-x',
        'x,y+1/2,z+1/2',
        'y,-x+1/2,-z+1/2',
        '-x,-y+1/2,z+1/2',
        '-y,x+1/2,-z+1/2',
        'x,-y+1/2,-z+1/2',
        '-y,-x+1/2,z+1/2',
        '-x,y+1/2,-z+1/2',
        'y,x+1/2,z+1/2',
        'z,x+1/2,y+1/2',
        'x,-z+1/2,-y+1/2',
        '-z,-x+1/2,y+1/2',
        '-x,z+1/2,-y+1/2',
        'z,-x+1/2,-y+1/2',
        '-x,-z+1/2,y+1/2',
        '-z,x+1/2,-y+1/2',
        'x,z+1/2,y+1/2',
        'y,z+1/2,x+1/2',
        'y,-z+1/2,-x+1/2',
        '-z,-y+1/2,x+1/2',
        '-y,z+1/2,-x+1/2',
        'z,y+1/2,x+1/2',
        '-y,-z+1/2,x+1/2',
        '-z,y+1/2,-x+1/2',
        'z,-y+1/2,-x+1/2',
        'x+1/2,y,z+1/2',
        'y+1/2,-x,-z+1/2',
        '-x+1/2,-y,z+1/2',
        '-y+1/2,x,-z+1/2',
        'x+1/2,-y,-z+1/2',
        '-y+1/2,-x,z+1/2',
        '-x+1/2,y,-z+1/2',
        'y+1/2,x,z+1/2',
        'z+1/2,x,y+1/2',
        'x+1/2,-z,-y+1/2',
        '-z+1/2,-x,y+1/2',
        '-x+1/2,z,-y+1/2',
        'z+1/2,-x,-y+1/2',
        '-x+1/2,-z,y+1/2',
        '-z+1/2,x,-y+1/2',
        'x+1/2,z,y+1/2',
        'y+1/2,z,x+1/2',
        'y+1/2,-z,-x+1/2',
        '-z+1/2,-y,x+1/2',
        '-y+1/2,z,-x+1/2',
        'z+1/2,y,x+1/2',
        '-y+1/2,-z,x+1/2',
        '-z+1/2,y,-x+1/2',
        'z+1/2,-y,-x+1/2',
        'x+1/2,y+1/2,z',
        'y+1/2,-x+1/2,-z',
        '-x+1/2,-y+1/2,z',
        '-y+1/2,x+1/2,-z',
        'x+1/2,-y+1/2,-z',
        '-y+1/2,-x+1/2,z',
        '-x+1/2,y+1/2,-z',
        'y+1/2,x+1/2,z',
        'z+1/2,x+1/2,y',
        'x+1/2,-z+1/2,-y',
        '-z+1/2,-x+1/2,y',
        '-x+1/2,z+1/2,-y',
        'z+1/2,-x+1/2,-y',
        '-x+1/2,-z+1/2,y',
        '-z+1/2,x+1/2,-y',
        'x+1/2,z+1/2,y',
        'y+1/2,z+1/2,x',
        'y+1/2,-z+1/2,-x',
        '-z+1/2,-y+1/2,x',
        '-y+1/2,z+1/2,-x',
        'z+1/2,y+1/2,x',
        '-y+1/2,-z+1/2,x',
        '-z+1/2,y+1/2,-x',
        'z+1/2,-y+1/2,-x',
    ],
    ncsym => [
        'x,y,z',
        'y,-x,-z',
        '-x,-y,z',
        '-y,x,-z',
        'x,-y,-z',
        '-y,-x,z',
        '-x,y,-z',
        'y,x,z',
        'z,x,y',
        'x,-z,-y',
        '-z,-x,y',
        '-x,z,-y',
        'z,-x,-y',
        '-x,-z,y',
        '-z,x,-y',
        'x,z,y',
        'y,z,x',
        'y,-z,-x',
        '-z,-y,x',
        '-y,z,-x',
        'z,y,x',
        '-y,-z,x',
        '-z,y,-x',
        'z,-y,-x',
    ]
},

{
    number          => 217,
    hall            => 'I -4 2 3',
    schoenflies     => 'Td^3',
    hermann_mauguin => 'I -4 3 m',
    universal_h_m   => 'I -4 3 m',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'y,-x,-z',
        '-x,-y,z',
        '-y,x,-z',
        'x,-y,-z',
        '-y,-x,z',
        '-x,y,-z',
        'y,x,z',
        'z,x,y',
        'x,-z,-y',
        '-z,-x,y',
        '-x,z,-y',
        'z,-x,-y',
        '-x,-z,y',
        '-z,x,-y',
        'x,z,y',
        'y,z,x',
        'y,-z,-x',
        '-z,-y,x',
        '-y,z,-x',
        'z,y,x',
        '-y,-z,x',
        '-z,y,-x',
        'z,-y,-x',
        'x+1/2,y+1/2,z+1/2',
        'y+1/2,-x+1/2,-z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        '-y+1/2,x+1/2,-z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        '-y+1/2,-x+1/2,z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        'y+1/2,x+1/2,z+1/2',
        'z+1/2,x+1/2,y+1/2',
        'x+1/2,-z+1/2,-y+1/2',
        '-z+1/2,-x+1/2,y+1/2',
        '-x+1/2,z+1/2,-y+1/2',
        'z+1/2,-x+1/2,-y+1/2',
        '-x+1/2,-z+1/2,y+1/2',
        '-z+1/2,x+1/2,-y+1/2',
        'x+1/2,z+1/2,y+1/2',
        'y+1/2,z+1/2,x+1/2',
        'y+1/2,-z+1/2,-x+1/2',
        '-z+1/2,-y+1/2,x+1/2',
        '-y+1/2,z+1/2,-x+1/2',
        'z+1/2,y+1/2,x+1/2',
        '-y+1/2,-z+1/2,x+1/2',
        '-z+1/2,y+1/2,-x+1/2',
        'z+1/2,-y+1/2,-x+1/2',
    ],
    ncsym => [
        'x,y,z',
        'y,-x,-z',
        '-x,-y,z',
        '-y,x,-z',
        'x,-y,-z',
        '-y,-x,z',
        '-x,y,-z',
        'y,x,z',
        'z,x,y',
        'x,-z,-y',
        '-z,-x,y',
        '-x,z,-y',
        'z,-x,-y',
        '-x,-z,y',
        '-z,x,-y',
        'x,z,y',
        'y,z,x',
        'y,-z,-x',
        '-z,-y,x',
        '-y,z,-x',
        'z,y,x',
        '-y,-z,x',
        '-z,y,-x',
        'z,-y,-x',
    ]
},

{
    number          => 218,
    hall            => 'P -4n 2 3',
    schoenflies     => 'Td^4',
    hermann_mauguin => 'P -4 3 n',
    universal_h_m   => 'P -4 3 n',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'y+1/2,-x+1/2,-z+1/2',
        '-x,-y,z',
        '-y+1/2,x+1/2,-z+1/2',
        'x,-y,-z',
        '-y+1/2,-x+1/2,z+1/2',
        '-x,y,-z',
        'y+1/2,x+1/2,z+1/2',
        'z,x,y',
        'x+1/2,-z+1/2,-y+1/2',
        '-z,-x,y',
        '-x+1/2,z+1/2,-y+1/2',
        'z,-x,-y',
        '-x+1/2,-z+1/2,y+1/2',
        '-z,x,-y',
        'x+1/2,z+1/2,y+1/2',
        'y,z,x',
        'y,-z,-x',
        '-z+1/2,-y+1/2,x+1/2',
        '-y,z,-x',
        'z+1/2,y+1/2,x+1/2',
        '-y,-z,x',
        '-z+1/2,y+1/2,-x+1/2',
        'z+1/2,-y+1/2,-x+1/2',
    ],
    ncsym => [
        'x,y,z',
        'y+1/2,-x+1/2,-z+1/2',
        '-x,-y,z',
        '-y+1/2,x+1/2,-z+1/2',
        'x,-y,-z',
        '-y+1/2,-x+1/2,z+1/2',
        '-x,y,-z',
        'y+1/2,x+1/2,z+1/2',
        'z,x,y',
        'x+1/2,-z+1/2,-y+1/2',
        '-z,-x,y',
        '-x+1/2,z+1/2,-y+1/2',
        'z,-x,-y',
        '-x+1/2,-z+1/2,y+1/2',
        '-z,x,-y',
        'x+1/2,z+1/2,y+1/2',
        'y,z,x',
        'y,-z,-x',
        '-z+1/2,-y+1/2,x+1/2',
        '-y,z,-x',
        'z+1/2,y+1/2,x+1/2',
        '-y,-z,x',
        '-z+1/2,y+1/2,-x+1/2',
        'z+1/2,-y+1/2,-x+1/2',
    ]
},

{
    number          => 219,
    hall            => 'F -4a 2 3',
    schoenflies     => 'Td^5',
    hermann_mauguin => 'F -4 3 c',
    universal_h_m   => 'F -4 3 c',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'y+1/2,-x,-z',
        '-x+1/2,-y+1/2,z',
        '-y,x+1/2,-z',
        'x,-y,-z',
        '-y+1/2,-x,z',
        '-x+1/2,y+1/2,-z',
        'y,x+1/2,z',
        'z,x,y',
        'x+1/2,-z,-y',
        '-z+1/2,-x+1/2,y',
        '-x,z+1/2,-y',
        'z,-x,-y',
        '-x+1/2,-z,y',
        '-z+1/2,x+1/2,-y',
        'x,z+1/2,y',
        'y,z,x',
        'y,-z+1/2,-x+1/2',
        '-z,-y,x+1/2',
        '-y+1/2,z,-x+1/2',
        'z+1/2,y,x',
        '-y,-z,x',
        '-z,y,-x+1/2',
        'z+1/2,-y+1/2,-x+1/2',
        'x,y+1/2,z+1/2',
        'y+1/2,-x+1/2,-z+1/2',
        '-x+1/2,-y,z+1/2',
        '-y,x,-z+1/2',
        'x,-y+1/2,-z+1/2',
        '-y+1/2,-x+1/2,z+1/2',
        '-x+1/2,y,-z+1/2',
        'y,x,z+1/2',
        'z,x+1/2,y+1/2',
        'x+1/2,-z+1/2,-y+1/2',
        '-z+1/2,-x,y+1/2',
        '-x,z,-y+1/2',
        'z,-x+1/2,-y+1/2',
        '-x+1/2,-z+1/2,y+1/2',
        '-z+1/2,x,-y+1/2',
        'x,z,y+1/2',
        'y,z+1/2,x+1/2',
        'y,-z,-x',
        '-z,-y+1/2,x',
        '-y+1/2,z+1/2,-x',
        'z+1/2,y+1/2,x+1/2',
        '-y,-z+1/2,x+1/2',
        '-z,y+1/2,-x',
        'z+1/2,-y,-x',
        'x+1/2,y,z+1/2',
        'y,-x,-z+1/2',
        '-x,-y+1/2,z+1/2',
        '-y+1/2,x+1/2,-z+1/2',
        'x+1/2,-y,-z+1/2',
        '-y,-x,z+1/2',
        '-x,y+1/2,-z+1/2',
        'y+1/2,x+1/2,z+1/2',
        'z+1/2,x,y+1/2',
        'x,-z,-y+1/2',
        '-z,-x+1/2,y+1/2',
        '-x+1/2,z+1/2,-y+1/2',
        'z+1/2,-x,-y+1/2',
        '-x,-z,y+1/2',
        '-z,x+1/2,-y+1/2',
        'x+1/2,z+1/2,y+1/2',
        'y+1/2,z,x+1/2',
        'y+1/2,-z+1/2,-x',
        '-z+1/2,-y,x',
        '-y,z,-x',
        'z,y,x+1/2',
        '-y+1/2,-z,x+1/2',
        '-z+1/2,y,-x',
        'z,-y+1/2,-x',
        'x+1/2,y+1/2,z',
        'y,-x+1/2,-z',
        '-x,-y,z',
        '-y+1/2,x,-z',
        'x+1/2,-y+1/2,-z',
        '-y,-x+1/2,z',
        '-x,y,-z',
        'y+1/2,x,z',
        'z+1/2,x+1/2,y',
        'x,-z+1/2,-y',
        '-z,-x,y',
        '-x+1/2,z,-y',
        'z+1/2,-x+1/2,-y',
        '-x,-z+1/2,y',
        '-z,x,-y',
        'x+1/2,z,y',
        'y+1/2,z+1/2,x',
        'y+1/2,-z,-x+1/2',
        '-z+1/2,-y+1/2,x+1/2',
        '-y,z+1/2,-x+1/2',
        'z,y+1/2,x',
        '-y+1/2,-z+1/2,x',
        '-z+1/2,y+1/2,-x+1/2',
        'z,-y,-x+1/2',
    ],
    ncsym => [
        'x,y,z',
        'y+1/2,-x,-z',
        '-x+1/2,-y+1/2,z',
        '-y,x+1/2,-z',
        'x,-y,-z',
        '-y+1/2,-x,z',
        '-x+1/2,y+1/2,-z',
        'y,x+1/2,z',
        'z,x,y',
        'x+1/2,-z,-y',
        '-z+1/2,-x+1/2,y',
        '-x,z+1/2,-y',
        'z,-x,-y',
        '-x+1/2,-z,y',
        '-z+1/2,x+1/2,-y',
        'x,z+1/2,y',
        'y,z,x',
        'y,-z+1/2,-x+1/2',
        '-z,-y,x+1/2',
        '-y+1/2,z,-x+1/2',
        'z+1/2,y,x',
        '-y,-z,x',
        '-z,y,-x+1/2',
        'z+1/2,-y+1/2,-x+1/2',
    ]
},

{
    number          => 220,
    hall            => 'I -4bd 2c 3',
    schoenflies     => 'Td^6',
    hermann_mauguin => 'I -4 3 d',
    universal_h_m   => 'I -4 3 d',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'y+1/4,-x+3/4,-z+1/4',
        '-x,-y+1/2,z',
        '-y+3/4,x+3/4,-z+1/4',
        'x,-y,-z+1/2',
        '-y+1/4,-x+3/4,z+3/4',
        '-x,y+1/2,-z+1/2',
        'y+3/4,x+3/4,z+3/4',
        'z,x,y',
        'x+1/4,-z+3/4,-y+1/4',
        '-z,-x+1/2,y',
        '-x+3/4,z+3/4,-y+1/4',
        'z,-x,-y+1/2',
        '-x+1/4,-z+3/4,y+3/4',
        '-z,x+1/2,-y+1/2',
        'x+3/4,z+3/4,y+3/4',
        'y,z,x',
        'y,-z,-x+1/2',
        '-z+1/4,-y+3/4,x+3/4',
        '-y,z+1/2,-x+1/2',
        'z+1/4,y+1/4,x+1/4',
        '-y+1/2,-z,x+1/2',
        '-z+1/4,y+1/4,-x+3/4',
        'z+3/4,-y+1/4,-x+3/4',
        'x+1/2,y+1/2,z+1/2',
        'y+3/4,-x+1/4,-z+3/4',
        '-x+1/2,-y,z+1/2',
        '-y+1/4,x+1/4,-z+3/4',
        'x+1/2,-y+1/2,-z',
        '-y+3/4,-x+1/4,z+1/4',
        '-x+1/2,y,-z',
        'y+1/4,x+1/4,z+1/4',
        'z+1/2,x+1/2,y+1/2',
        'x+3/4,-z+1/4,-y+3/4',
        '-z+1/2,-x,y+1/2',
        '-x+1/4,z+1/4,-y+3/4',
        'z+1/2,-x+1/2,-y',
        '-x+3/4,-z+1/4,y+1/4',
        '-z+1/2,x,-y',
        'x+1/4,z+1/4,y+1/4',
        'y+1/2,z+1/2,x+1/2',
        'y+1/2,-z+1/2,-x',
        '-z+3/4,-y+1/4,x+1/4',
        '-y+1/2,z,-x',
        'z+3/4,y+3/4,x+3/4',
        '-y,-z+1/2,x',
        '-z+3/4,y+3/4,-x+1/4',
        'z+1/4,-y+3/4,-x+1/4',
    ],
    ncsym => [
        'x,y,z',
        'y+1/4,-x+3/4,-z+1/4',
        '-x,-y+1/2,z',
        '-y+3/4,x+3/4,-z+1/4',
        'x,-y,-z+1/2',
        '-y+1/4,-x+3/4,z+3/4',
        '-x,y+1/2,-z+1/2',
        'y+3/4,x+3/4,z+3/4',
        'z,x,y',
        'x+1/4,-z+3/4,-y+1/4',
        '-z,-x+1/2,y',
        '-x+3/4,z+3/4,-y+1/4',
        'z,-x,-y+1/2',
        '-x+1/4,-z+3/4,y+3/4',
        '-z,x+1/2,-y+1/2',
        'x+3/4,z+3/4,y+3/4',
        'y,z,x',
        'y,-z,-x+1/2',
        '-z+1/4,-y+3/4,x+3/4',
        '-y,z+1/2,-x+1/2',
        'z+1/4,y+1/4,x+1/4',
        '-y+1/2,-z,x+1/2',
        '-z+1/4,y+1/4,-x+3/4',
        'z+3/4,-y+1/4,-x+3/4',
    ]
},

{
    number          => 221,
    hall            => '-P 4 2 3',
    schoenflies     => 'Oh^1',
    hermann_mauguin => 'P m -3 m',
    universal_h_m   => 'P m -3 m',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x,-y,-z',
        'y,x,-z',
        '-x,y,-z',
        '-y,-x,-z',
        'z,x,y',
        '-x,z,y',
        '-z,-x,y',
        'x,-z,y',
        'z,-x,-y',
        'x,z,-y',
        '-z,x,-y',
        '-x,-z,-y',
        'y,z,x',
        'y,-z,-x',
        'z,y,-x',
        '-y,z,-x',
        '-z,-y,-x',
        '-y,-z,x',
        'z,-y,x',
        '-z,y,x',
        '-x,-y,-z',
        'y,-x,-z',
        'x,y,-z',
        '-y,x,-z',
        '-x,y,z',
        '-y,-x,z',
        'x,-y,z',
        'y,x,z',
        '-z,-x,-y',
        'x,-z,-y',
        'z,x,-y',
        '-x,z,-y',
        '-z,x,y',
        '-x,-z,y',
        'z,-x,y',
        'x,z,y',
        '-y,-z,-x',
        '-y,z,x',
        '-z,-y,x',
        'y,-z,x',
        'z,y,x',
        'y,z,-x',
        '-z,y,-x',
        'z,-y,-x',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x,-y,-z',
        'y,x,-z',
        '-x,y,-z',
        '-y,-x,-z',
        'z,x,y',
        '-x,z,y',
        '-z,-x,y',
        'x,-z,y',
        'z,-x,-y',
        'x,z,-y',
        '-z,x,-y',
        '-x,-z,-y',
        'y,z,x',
        'y,-z,-x',
        'z,y,-x',
        '-y,z,-x',
        '-z,-y,-x',
        '-y,-z,x',
        'z,-y,x',
        '-z,y,x',
        '-x,-y,-z',
        'y,-x,-z',
        'x,y,-z',
        '-y,x,-z',
        '-x,y,z',
        '-y,-x,z',
        'x,-y,z',
        'y,x,z',
        '-z,-x,-y',
        'x,-z,-y',
        'z,x,-y',
        '-x,z,-y',
        '-z,x,y',
        '-x,-z,y',
        'z,-x,y',
        'x,z,y',
        '-y,-z,-x',
        '-y,z,x',
        '-z,-y,x',
        'y,-z,x',
        'z,y,x',
        'y,z,-x',
        '-z,y,-x',
        'z,-y,-x',
    ]
},

{
    number          => 222,
    hall            => 'P 4 2 3 -1n',
    schoenflies     => 'Oh^2',
    hermann_mauguin => 'P n -3 n',
    universal_h_m   => 'P n -3 n :1',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x,-y,-z',
        'y,x,-z',
        '-x,y,-z',
        '-y,-x,-z',
        'z,x,y',
        '-x,z,y',
        '-z,-x,y',
        'x,-z,y',
        'z,-x,-y',
        'x,z,-y',
        '-z,x,-y',
        '-x,-z,-y',
        'y,z,x',
        'y,-z,-x',
        'z,y,-x',
        '-y,z,-x',
        '-z,-y,-x',
        '-y,-z,x',
        'z,-y,x',
        '-z,y,x',
        '-x+1/2,-y+1/2,-z+1/2',
        'y+1/2,-x+1/2,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-y+1/2,x+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        '-y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        'y+1/2,x+1/2,z+1/2',
        '-z+1/2,-x+1/2,-y+1/2',
        'x+1/2,-z+1/2,-y+1/2',
        'z+1/2,x+1/2,-y+1/2',
        '-x+1/2,z+1/2,-y+1/2',
        '-z+1/2,x+1/2,y+1/2',
        '-x+1/2,-z+1/2,y+1/2',
        'z+1/2,-x+1/2,y+1/2',
        'x+1/2,z+1/2,y+1/2',
        '-y+1/2,-z+1/2,-x+1/2',
        '-y+1/2,z+1/2,x+1/2',
        '-z+1/2,-y+1/2,x+1/2',
        'y+1/2,-z+1/2,x+1/2',
        'z+1/2,y+1/2,x+1/2',
        'y+1/2,z+1/2,-x+1/2',
        '-z+1/2,y+1/2,-x+1/2',
        'z+1/2,-y+1/2,-x+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x,-y,-z',
        'y,x,-z',
        '-x,y,-z',
        '-y,-x,-z',
        'z,x,y',
        '-x,z,y',
        '-z,-x,y',
        'x,-z,y',
        'z,-x,-y',
        'x,z,-y',
        '-z,x,-y',
        '-x,-z,-y',
        'y,z,x',
        'y,-z,-x',
        'z,y,-x',
        '-y,z,-x',
        '-z,-y,-x',
        '-y,-z,x',
        'z,-y,x',
        '-z,y,x',
        '-x+1/2,-y+1/2,-z+1/2',
        'y+1/2,-x+1/2,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-y+1/2,x+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        '-y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        'y+1/2,x+1/2,z+1/2',
        '-z+1/2,-x+1/2,-y+1/2',
        'x+1/2,-z+1/2,-y+1/2',
        'z+1/2,x+1/2,-y+1/2',
        '-x+1/2,z+1/2,-y+1/2',
        '-z+1/2,x+1/2,y+1/2',
        '-x+1/2,-z+1/2,y+1/2',
        'z+1/2,-x+1/2,y+1/2',
        'x+1/2,z+1/2,y+1/2',
        '-y+1/2,-z+1/2,-x+1/2',
        '-y+1/2,z+1/2,x+1/2',
        '-z+1/2,-y+1/2,x+1/2',
        'y+1/2,-z+1/2,x+1/2',
        'z+1/2,y+1/2,x+1/2',
        'y+1/2,z+1/2,-x+1/2',
        '-z+1/2,y+1/2,-x+1/2',
        'z+1/2,-y+1/2,-x+1/2',
    ]
},

{
    number          => 222,
    hall            => '-P 4a 2bc 3',
    schoenflies     => 'Oh^2',
    hermann_mauguin => 'P n -3 n',
    universal_h_m   => 'P n -3 n :2',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x,z',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z',
        'x,-y+1/2,-z+1/2',
        'y,x,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-y+1/2,-x+1/2,-z+1/2',
        'z,x,y',
        '-x+1/2,z,y',
        '-z+1/2,-x+1/2,y',
        'x,-z+1/2,y',
        'z,-x+1/2,-y+1/2',
        'x,z,-y+1/2',
        '-z+1/2,x,-y+1/2',
        '-x+1/2,-z+1/2,-y+1/2',
        'y,z,x',
        'y,-z+1/2,-x+1/2',
        'z,y,-x+1/2',
        '-y+1/2,z,-x+1/2',
        '-z+1/2,-y+1/2,-x+1/2',
        '-y+1/2,-z+1/2,x',
        'z,-y+1/2,x',
        '-z+1/2,y,x',
        '-x,-y,-z',
        'y+1/2,-x,-z',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z',
        '-x,y+1/2,z+1/2',
        '-y,-x,z+1/2',
        'x+1/2,-y,z+1/2',
        'y+1/2,x+1/2,z+1/2',
        '-z,-x,-y',
        'x+1/2,-z,-y',
        'z+1/2,x+1/2,-y',
        '-x,z+1/2,-y',
        '-z,x+1/2,y+1/2',
        '-x,-z,y+1/2',
        'z+1/2,-x,y+1/2',
        'x+1/2,z+1/2,y+1/2',
        '-y,-z,-x',
        '-y,z+1/2,x+1/2',
        '-z,-y,x+1/2',
        'y+1/2,-z,x+1/2',
        'z+1/2,y+1/2,x+1/2',
        'y+1/2,z+1/2,-x',
        '-z,y+1/2,-x',
        'z+1/2,-y,-x',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x,z',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z',
        'x,-y+1/2,-z+1/2',
        'y,x,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-y+1/2,-x+1/2,-z+1/2',
        'z,x,y',
        '-x+1/2,z,y',
        '-z+1/2,-x+1/2,y',
        'x,-z+1/2,y',
        'z,-x+1/2,-y+1/2',
        'x,z,-y+1/2',
        '-z+1/2,x,-y+1/2',
        '-x+1/2,-z+1/2,-y+1/2',
        'y,z,x',
        'y,-z+1/2,-x+1/2',
        'z,y,-x+1/2',
        '-y+1/2,z,-x+1/2',
        '-z+1/2,-y+1/2,-x+1/2',
        '-y+1/2,-z+1/2,x',
        'z,-y+1/2,x',
        '-z+1/2,y,x',
        '-x,-y,-z',
        'y+1/2,-x,-z',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z',
        '-x,y+1/2,z+1/2',
        '-y,-x,z+1/2',
        'x+1/2,-y,z+1/2',
        'y+1/2,x+1/2,z+1/2',
        '-z,-x,-y',
        'x+1/2,-z,-y',
        'z+1/2,x+1/2,-y',
        '-x,z+1/2,-y',
        '-z,x+1/2,y+1/2',
        '-x,-z,y+1/2',
        'z+1/2,-x,y+1/2',
        'x+1/2,z+1/2,y+1/2',
        '-y,-z,-x',
        '-y,z+1/2,x+1/2',
        '-z,-y,x+1/2',
        'y+1/2,-z,x+1/2',
        'z+1/2,y+1/2,x+1/2',
        'y+1/2,z+1/2,-x',
        '-z,y+1/2,-x',
        'z+1/2,-y,-x',
    ]
},

{
    number          => 223,
    hall            => '-P 4n 2 3',
    schoenflies     => 'Oh^3',
    hermann_mauguin => 'P m -3 n',
    universal_h_m   => 'P m -3 n',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x+1/2,z+1/2',
        '-x,-y,z',
        'y+1/2,-x+1/2,z+1/2',
        'x,-y,-z',
        'y+1/2,x+1/2,-z+1/2',
        '-x,y,-z',
        '-y+1/2,-x+1/2,-z+1/2',
        'z,x,y',
        '-x+1/2,z+1/2,y+1/2',
        '-z,-x,y',
        'x+1/2,-z+1/2,y+1/2',
        'z,-x,-y',
        'x+1/2,z+1/2,-y+1/2',
        '-z,x,-y',
        '-x+1/2,-z+1/2,-y+1/2',
        'y,z,x',
        'y,-z,-x',
        'z+1/2,y+1/2,-x+1/2',
        '-y,z,-x',
        '-z+1/2,-y+1/2,-x+1/2',
        '-y,-z,x',
        'z+1/2,-y+1/2,x+1/2',
        '-z+1/2,y+1/2,x+1/2',
        '-x,-y,-z',
        'y+1/2,-x+1/2,-z+1/2',
        'x,y,-z',
        '-y+1/2,x+1/2,-z+1/2',
        '-x,y,z',
        '-y+1/2,-x+1/2,z+1/2',
        'x,-y,z',
        'y+1/2,x+1/2,z+1/2',
        '-z,-x,-y',
        'x+1/2,-z+1/2,-y+1/2',
        'z,x,-y',
        '-x+1/2,z+1/2,-y+1/2',
        '-z,x,y',
        '-x+1/2,-z+1/2,y+1/2',
        'z,-x,y',
        'x+1/2,z+1/2,y+1/2',
        '-y,-z,-x',
        '-y,z,x',
        '-z+1/2,-y+1/2,x+1/2',
        'y,-z,x',
        'z+1/2,y+1/2,x+1/2',
        'y,z,-x',
        '-z+1/2,y+1/2,-x+1/2',
        'z+1/2,-y+1/2,-x+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x+1/2,z+1/2',
        '-x,-y,z',
        'y+1/2,-x+1/2,z+1/2',
        'x,-y,-z',
        'y+1/2,x+1/2,-z+1/2',
        '-x,y,-z',
        '-y+1/2,-x+1/2,-z+1/2',
        'z,x,y',
        '-x+1/2,z+1/2,y+1/2',
        '-z,-x,y',
        'x+1/2,-z+1/2,y+1/2',
        'z,-x,-y',
        'x+1/2,z+1/2,-y+1/2',
        '-z,x,-y',
        '-x+1/2,-z+1/2,-y+1/2',
        'y,z,x',
        'y,-z,-x',
        'z+1/2,y+1/2,-x+1/2',
        '-y,z,-x',
        '-z+1/2,-y+1/2,-x+1/2',
        '-y,-z,x',
        'z+1/2,-y+1/2,x+1/2',
        '-z+1/2,y+1/2,x+1/2',
        '-x,-y,-z',
        'y+1/2,-x+1/2,-z+1/2',
        'x,y,-z',
        '-y+1/2,x+1/2,-z+1/2',
        '-x,y,z',
        '-y+1/2,-x+1/2,z+1/2',
        'x,-y,z',
        'y+1/2,x+1/2,z+1/2',
        '-z,-x,-y',
        'x+1/2,-z+1/2,-y+1/2',
        'z,x,-y',
        '-x+1/2,z+1/2,-y+1/2',
        '-z,x,y',
        '-x+1/2,-z+1/2,y+1/2',
        'z,-x,y',
        'x+1/2,z+1/2,y+1/2',
        '-y,-z,-x',
        '-y,z,x',
        '-z+1/2,-y+1/2,x+1/2',
        'y,-z,x',
        'z+1/2,y+1/2,x+1/2',
        'y,z,-x',
        '-z+1/2,y+1/2,-x+1/2',
        'z+1/2,-y+1/2,-x+1/2',
    ]
},

{
    number          => 224,
    hall            => 'P 4n 2 3 -1n',
    schoenflies     => 'Oh^4',
    hermann_mauguin => 'P n -3 m',
    universal_h_m   => 'P n -3 m :1',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x+1/2,z+1/2',
        '-x,-y,z',
        'y+1/2,-x+1/2,z+1/2',
        'x,-y,-z',
        'y+1/2,x+1/2,-z+1/2',
        '-x,y,-z',
        '-y+1/2,-x+1/2,-z+1/2',
        'z,x,y',
        '-x+1/2,z+1/2,y+1/2',
        '-z,-x,y',
        'x+1/2,-z+1/2,y+1/2',
        'z,-x,-y',
        'x+1/2,z+1/2,-y+1/2',
        '-z,x,-y',
        '-x+1/2,-z+1/2,-y+1/2',
        'y,z,x',
        'y,-z,-x',
        'z+1/2,y+1/2,-x+1/2',
        '-y,z,-x',
        '-z+1/2,-y+1/2,-x+1/2',
        '-y,-z,x',
        'z+1/2,-y+1/2,x+1/2',
        '-z+1/2,y+1/2,x+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        'y,-x,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-y,x,-z',
        '-x+1/2,y+1/2,z+1/2',
        '-y,-x,z',
        'x+1/2,-y+1/2,z+1/2',
        'y,x,z',
        '-z+1/2,-x+1/2,-y+1/2',
        'x,-z,-y',
        'z+1/2,x+1/2,-y+1/2',
        '-x,z,-y',
        '-z+1/2,x+1/2,y+1/2',
        '-x,-z,y',
        'z+1/2,-x+1/2,y+1/2',
        'x,z,y',
        '-y+1/2,-z+1/2,-x+1/2',
        '-y+1/2,z+1/2,x+1/2',
        '-z,-y,x',
        'y+1/2,-z+1/2,x+1/2',
        'z,y,x',
        'y+1/2,z+1/2,-x+1/2',
        '-z,y,-x',
        'z,-y,-x',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x+1/2,z+1/2',
        '-x,-y,z',
        'y+1/2,-x+1/2,z+1/2',
        'x,-y,-z',
        'y+1/2,x+1/2,-z+1/2',
        '-x,y,-z',
        '-y+1/2,-x+1/2,-z+1/2',
        'z,x,y',
        '-x+1/2,z+1/2,y+1/2',
        '-z,-x,y',
        'x+1/2,-z+1/2,y+1/2',
        'z,-x,-y',
        'x+1/2,z+1/2,-y+1/2',
        '-z,x,-y',
        '-x+1/2,-z+1/2,-y+1/2',
        'y,z,x',
        'y,-z,-x',
        'z+1/2,y+1/2,-x+1/2',
        '-y,z,-x',
        '-z+1/2,-y+1/2,-x+1/2',
        '-y,-z,x',
        'z+1/2,-y+1/2,x+1/2',
        '-z+1/2,y+1/2,x+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        'y,-x,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-y,x,-z',
        '-x+1/2,y+1/2,z+1/2',
        '-y,-x,z',
        'x+1/2,-y+1/2,z+1/2',
        'y,x,z',
        '-z+1/2,-x+1/2,-y+1/2',
        'x,-z,-y',
        'z+1/2,x+1/2,-y+1/2',
        '-x,z,-y',
        '-z+1/2,x+1/2,y+1/2',
        '-x,-z,y',
        'z+1/2,-x+1/2,y+1/2',
        'x,z,y',
        '-y+1/2,-z+1/2,-x+1/2',
        '-y+1/2,z+1/2,x+1/2',
        '-z,-y,x',
        'y+1/2,-z+1/2,x+1/2',
        'z,y,x',
        'y+1/2,z+1/2,-x+1/2',
        '-z,y,-x',
        'z,-y,-x',
    ]
},

{
    number          => 224,
    hall            => '-P 4bc 2bc 3',
    schoenflies     => 'Oh^4',
    hermann_mauguin => 'P n -3 m',
    universal_h_m   => 'P n -3 m :2',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x+1/2,z+1/2',
        '-x+1/2,-y+1/2,z',
        'y+1/2,-x,z+1/2',
        'x,-y+1/2,-z+1/2',
        'y+1/2,x+1/2,-z',
        '-x+1/2,y,-z+1/2',
        '-y,-x,-z',
        'z,x,y',
        '-x,z+1/2,y+1/2',
        '-z+1/2,-x+1/2,y',
        'x+1/2,-z,y+1/2',
        'z,-x+1/2,-y+1/2',
        'x+1/2,z+1/2,-y',
        '-z+1/2,x,-y+1/2',
        '-x,-z,-y',
        'y,z,x',
        'y,-z+1/2,-x+1/2',
        'z+1/2,y+1/2,-x',
        '-y+1/2,z,-x+1/2',
        '-z,-y,-x',
        '-y+1/2,-z+1/2,x',
        'z+1/2,-y,x+1/2',
        '-z,y+1/2,x+1/2',
        '-x,-y,-z',
        'y,-x+1/2,-z+1/2',
        'x+1/2,y+1/2,-z',
        '-y+1/2,x,-z+1/2',
        '-x,y+1/2,z+1/2',
        '-y+1/2,-x+1/2,z',
        'x+1/2,-y,z+1/2',
        'y,x,z',
        '-z,-x,-y',
        'x,-z+1/2,-y+1/2',
        'z+1/2,x+1/2,-y',
        '-x+1/2,z,-y+1/2',
        '-z,x+1/2,y+1/2',
        '-x+1/2,-z+1/2,y',
        'z+1/2,-x,y+1/2',
        'x,z,y',
        '-y,-z,-x',
        '-y,z+1/2,x+1/2',
        '-z+1/2,-y+1/2,x',
        'y+1/2,-z,x+1/2',
        'z,y,x',
        'y+1/2,z+1/2,-x',
        '-z+1/2,y,-x+1/2',
        'z,-y+1/2,-x+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y,x+1/2,z+1/2',
        '-x+1/2,-y+1/2,z',
        'y+1/2,-x,z+1/2',
        'x,-y+1/2,-z+1/2',
        'y+1/2,x+1/2,-z',
        '-x+1/2,y,-z+1/2',
        '-y,-x,-z',
        'z,x,y',
        '-x,z+1/2,y+1/2',
        '-z+1/2,-x+1/2,y',
        'x+1/2,-z,y+1/2',
        'z,-x+1/2,-y+1/2',
        'x+1/2,z+1/2,-y',
        '-z+1/2,x,-y+1/2',
        '-x,-z,-y',
        'y,z,x',
        'y,-z+1/2,-x+1/2',
        'z+1/2,y+1/2,-x',
        '-y+1/2,z,-x+1/2',
        '-z,-y,-x',
        '-y+1/2,-z+1/2,x',
        'z+1/2,-y,x+1/2',
        '-z,y+1/2,x+1/2',
        '-x,-y,-z',
        'y,-x+1/2,-z+1/2',
        'x+1/2,y+1/2,-z',
        '-y+1/2,x,-z+1/2',
        '-x,y+1/2,z+1/2',
        '-y+1/2,-x+1/2,z',
        'x+1/2,-y,z+1/2',
        'y,x,z',
        '-z,-x,-y',
        'x,-z+1/2,-y+1/2',
        'z+1/2,x+1/2,-y',
        '-x+1/2,z,-y+1/2',
        '-z,x+1/2,y+1/2',
        '-x+1/2,-z+1/2,y',
        'z+1/2,-x,y+1/2',
        'x,z,y',
        '-y,-z,-x',
        '-y,z+1/2,x+1/2',
        '-z+1/2,-y+1/2,x',
        'y+1/2,-z,x+1/2',
        'z,y,x',
        'y+1/2,z+1/2,-x',
        '-z+1/2,y,-x+1/2',
        'z,-y+1/2,-x+1/2',
    ]
},

{
    number          => 225,
    hall            => '-F 4 2 3',
    schoenflies     => 'Oh^5',
    hermann_mauguin => 'F m -3 m',
    universal_h_m   => 'F m -3 m',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x,-y,-z',
        'y,x,-z',
        '-x,y,-z',
        '-y,-x,-z',
        'z,x,y',
        '-x,z,y',
        '-z,-x,y',
        'x,-z,y',
        'z,-x,-y',
        'x,z,-y',
        '-z,x,-y',
        '-x,-z,-y',
        'y,z,x',
        'y,-z,-x',
        'z,y,-x',
        '-y,z,-x',
        '-z,-y,-x',
        '-y,-z,x',
        'z,-y,x',
        '-z,y,x',
        '-x,-y,-z',
        'y,-x,-z',
        'x,y,-z',
        '-y,x,-z',
        '-x,y,z',
        '-y,-x,z',
        'x,-y,z',
        'y,x,z',
        '-z,-x,-y',
        'x,-z,-y',
        'z,x,-y',
        '-x,z,-y',
        '-z,x,y',
        '-x,-z,y',
        'z,-x,y',
        'x,z,y',
        '-y,-z,-x',
        '-y,z,x',
        '-z,-y,x',
        'y,-z,x',
        'z,y,x',
        'y,z,-x',
        '-z,y,-x',
        'z,-y,-x',
        'x,y+1/2,z+1/2',
        '-y,x+1/2,z+1/2',
        '-x,-y+1/2,z+1/2',
        'y,-x+1/2,z+1/2',
        'x,-y+1/2,-z+1/2',
        'y,x+1/2,-z+1/2',
        '-x,y+1/2,-z+1/2',
        '-y,-x+1/2,-z+1/2',
        'z,x+1/2,y+1/2',
        '-x,z+1/2,y+1/2',
        '-z,-x+1/2,y+1/2',
        'x,-z+1/2,y+1/2',
        'z,-x+1/2,-y+1/2',
        'x,z+1/2,-y+1/2',
        '-z,x+1/2,-y+1/2',
        '-x,-z+1/2,-y+1/2',
        'y,z+1/2,x+1/2',
        'y,-z+1/2,-x+1/2',
        'z,y+1/2,-x+1/2',
        '-y,z+1/2,-x+1/2',
        '-z,-y+1/2,-x+1/2',
        '-y,-z+1/2,x+1/2',
        'z,-y+1/2,x+1/2',
        '-z,y+1/2,x+1/2',
        '-x,-y+1/2,-z+1/2',
        'y,-x+1/2,-z+1/2',
        'x,y+1/2,-z+1/2',
        '-y,x+1/2,-z+1/2',
        '-x,y+1/2,z+1/2',
        '-y,-x+1/2,z+1/2',
        'x,-y+1/2,z+1/2',
        'y,x+1/2,z+1/2',
        '-z,-x+1/2,-y+1/2',
        'x,-z+1/2,-y+1/2',
        'z,x+1/2,-y+1/2',
        '-x,z+1/2,-y+1/2',
        '-z,x+1/2,y+1/2',
        '-x,-z+1/2,y+1/2',
        'z,-x+1/2,y+1/2',
        'x,z+1/2,y+1/2',
        '-y,-z+1/2,-x+1/2',
        '-y,z+1/2,x+1/2',
        '-z,-y+1/2,x+1/2',
        'y,-z+1/2,x+1/2',
        'z,y+1/2,x+1/2',
        'y,z+1/2,-x+1/2',
        '-z,y+1/2,-x+1/2',
        'z,-y+1/2,-x+1/2',
        'x+1/2,y,z+1/2',
        '-y+1/2,x,z+1/2',
        '-x+1/2,-y,z+1/2',
        'y+1/2,-x,z+1/2',
        'x+1/2,-y,-z+1/2',
        'y+1/2,x,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-y+1/2,-x,-z+1/2',
        'z+1/2,x,y+1/2',
        '-x+1/2,z,y+1/2',
        '-z+1/2,-x,y+1/2',
        'x+1/2,-z,y+1/2',
        'z+1/2,-x,-y+1/2',
        'x+1/2,z,-y+1/2',
        '-z+1/2,x,-y+1/2',
        '-x+1/2,-z,-y+1/2',
        'y+1/2,z,x+1/2',
        'y+1/2,-z,-x+1/2',
        'z+1/2,y,-x+1/2',
        '-y+1/2,z,-x+1/2',
        '-z+1/2,-y,-x+1/2',
        '-y+1/2,-z,x+1/2',
        'z+1/2,-y,x+1/2',
        '-z+1/2,y,x+1/2',
        '-x+1/2,-y,-z+1/2',
        'y+1/2,-x,-z+1/2',
        'x+1/2,y,-z+1/2',
        '-y+1/2,x,-z+1/2',
        '-x+1/2,y,z+1/2',
        '-y+1/2,-x,z+1/2',
        'x+1/2,-y,z+1/2',
        'y+1/2,x,z+1/2',
        '-z+1/2,-x,-y+1/2',
        'x+1/2,-z,-y+1/2',
        'z+1/2,x,-y+1/2',
        '-x+1/2,z,-y+1/2',
        '-z+1/2,x,y+1/2',
        '-x+1/2,-z,y+1/2',
        'z+1/2,-x,y+1/2',
        'x+1/2,z,y+1/2',
        '-y+1/2,-z,-x+1/2',
        '-y+1/2,z,x+1/2',
        '-z+1/2,-y,x+1/2',
        'y+1/2,-z,x+1/2',
        'z+1/2,y,x+1/2',
        'y+1/2,z,-x+1/2',
        '-z+1/2,y,-x+1/2',
        'z+1/2,-y,-x+1/2',
        'x+1/2,y+1/2,z',
        '-y+1/2,x+1/2,z',
        '-x+1/2,-y+1/2,z',
        'y+1/2,-x+1/2,z',
        'x+1/2,-y+1/2,-z',
        'y+1/2,x+1/2,-z',
        '-x+1/2,y+1/2,-z',
        '-y+1/2,-x+1/2,-z',
        'z+1/2,x+1/2,y',
        '-x+1/2,z+1/2,y',
        '-z+1/2,-x+1/2,y',
        'x+1/2,-z+1/2,y',
        'z+1/2,-x+1/2,-y',
        'x+1/2,z+1/2,-y',
        '-z+1/2,x+1/2,-y',
        '-x+1/2,-z+1/2,-y',
        'y+1/2,z+1/2,x',
        'y+1/2,-z+1/2,-x',
        'z+1/2,y+1/2,-x',
        '-y+1/2,z+1/2,-x',
        '-z+1/2,-y+1/2,-x',
        '-y+1/2,-z+1/2,x',
        'z+1/2,-y+1/2,x',
        '-z+1/2,y+1/2,x',
        '-x+1/2,-y+1/2,-z',
        'y+1/2,-x+1/2,-z',
        'x+1/2,y+1/2,-z',
        '-y+1/2,x+1/2,-z',
        '-x+1/2,y+1/2,z',
        '-y+1/2,-x+1/2,z',
        'x+1/2,-y+1/2,z',
        'y+1/2,x+1/2,z',
        '-z+1/2,-x+1/2,-y',
        'x+1/2,-z+1/2,-y',
        'z+1/2,x+1/2,-y',
        '-x+1/2,z+1/2,-y',
        '-z+1/2,x+1/2,y',
        '-x+1/2,-z+1/2,y',
        'z+1/2,-x+1/2,y',
        'x+1/2,z+1/2,y',
        '-y+1/2,-z+1/2,-x',
        '-y+1/2,z+1/2,x',
        '-z+1/2,-y+1/2,x',
        'y+1/2,-z+1/2,x',
        'z+1/2,y+1/2,x',
        'y+1/2,z+1/2,-x',
        '-z+1/2,y+1/2,-x',
        'z+1/2,-y+1/2,-x',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x,-y,-z',
        'y,x,-z',
        '-x,y,-z',
        '-y,-x,-z',
        'z,x,y',
        '-x,z,y',
        '-z,-x,y',
        'x,-z,y',
        'z,-x,-y',
        'x,z,-y',
        '-z,x,-y',
        '-x,-z,-y',
        'y,z,x',
        'y,-z,-x',
        'z,y,-x',
        '-y,z,-x',
        '-z,-y,-x',
        '-y,-z,x',
        'z,-y,x',
        '-z,y,x',
        '-x,-y,-z',
        'y,-x,-z',
        'x,y,-z',
        '-y,x,-z',
        '-x,y,z',
        '-y,-x,z',
        'x,-y,z',
        'y,x,z',
        '-z,-x,-y',
        'x,-z,-y',
        'z,x,-y',
        '-x,z,-y',
        '-z,x,y',
        '-x,-z,y',
        'z,-x,y',
        'x,z,y',
        '-y,-z,-x',
        '-y,z,x',
        '-z,-y,x',
        'y,-z,x',
        'z,y,x',
        'y,z,-x',
        '-z,y,-x',
        'z,-y,-x',
    ]
},

{
    number          => 226,
    hall            => '-F 4a 2 3',
    schoenflies     => 'Oh^6',
    hermann_mauguin => 'F m -3 c',
    universal_h_m   => 'F m -3 c',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x,z',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z',
        'x,-y,-z',
        'y+1/2,x,-z',
        '-x+1/2,y+1/2,-z',
        '-y,-x+1/2,-z',
        'z,x,y',
        '-x+1/2,z,y',
        '-z+1/2,-x+1/2,y',
        'x,-z+1/2,y',
        'z,-x,-y',
        'x+1/2,z,-y',
        '-z+1/2,x+1/2,-y',
        '-x,-z+1/2,-y',
        'y,z,x',
        'y,-z+1/2,-x+1/2',
        'z,y,-x+1/2',
        '-y+1/2,z,-x+1/2',
        '-z+1/2,-y,-x',
        '-y,-z,x',
        'z,-y,x+1/2',
        '-z+1/2,y+1/2,x+1/2',
        '-x,-y,-z',
        'y+1/2,-x,-z',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z',
        '-x,y,z',
        '-y+1/2,-x,z',
        'x+1/2,-y+1/2,z',
        'y,x+1/2,z',
        '-z,-x,-y',
        'x+1/2,-z,-y',
        'z+1/2,x+1/2,-y',
        '-x,z+1/2,-y',
        '-z,x,y',
        '-x+1/2,-z,y',
        'z+1/2,-x+1/2,y',
        'x,z+1/2,y',
        '-y,-z,-x',
        '-y,z+1/2,x+1/2',
        '-z,-y,x+1/2',
        'y+1/2,-z,x+1/2',
        'z+1/2,y,x',
        'y,z,-x',
        '-z,y,-x+1/2',
        'z+1/2,-y+1/2,-x+1/2',
        'x,y+1/2,z+1/2',
        '-y+1/2,x+1/2,z+1/2',
        '-x+1/2,-y,z+1/2',
        'y,-x,z+1/2',
        'x,-y+1/2,-z+1/2',
        'y+1/2,x+1/2,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-y,-x,-z+1/2',
        'z,x+1/2,y+1/2',
        '-x+1/2,z+1/2,y+1/2',
        '-z+1/2,-x,y+1/2',
        'x,-z,y+1/2',
        'z,-x+1/2,-y+1/2',
        'x+1/2,z+1/2,-y+1/2',
        '-z+1/2,x,-y+1/2',
        '-x,-z,-y+1/2',
        'y,z+1/2,x+1/2',
        'y,-z,-x',
        'z,y+1/2,-x',
        '-y+1/2,z+1/2,-x',
        '-z+1/2,-y+1/2,-x+1/2',
        '-y,-z+1/2,x+1/2',
        'z,-y+1/2,x',
        '-z+1/2,y,x',
        '-x,-y+1/2,-z+1/2',
        'y+1/2,-x+1/2,-z+1/2',
        'x+1/2,y,-z+1/2',
        '-y,x,-z+1/2',
        '-x,y+1/2,z+1/2',
        '-y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y,z+1/2',
        'y,x,z+1/2',
        '-z,-x+1/2,-y+1/2',
        'x+1/2,-z+1/2,-y+1/2',
        'z+1/2,x,-y+1/2',
        '-x,z,-y+1/2',
        '-z,x+1/2,y+1/2',
        '-x+1/2,-z+1/2,y+1/2',
        'z+1/2,-x,y+1/2',
        'x,z,y+1/2',
        '-y,-z+1/2,-x+1/2',
        '-y,z,x',
        '-z,-y+1/2,x',
        'y+1/2,-z+1/2,x',
        'z+1/2,y+1/2,x+1/2',
        'y,z+1/2,-x+1/2',
        '-z,y+1/2,-x',
        'z+1/2,-y,-x',
        'x+1/2,y,z+1/2',
        '-y,x,z+1/2',
        '-x,-y+1/2,z+1/2',
        'y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y,-z+1/2',
        'y,x,-z+1/2',
        '-x,y+1/2,-z+1/2',
        '-y+1/2,-x+1/2,-z+1/2',
        'z+1/2,x,y+1/2',
        '-x,z,y+1/2',
        '-z,-x+1/2,y+1/2',
        'x+1/2,-z+1/2,y+1/2',
        'z+1/2,-x,-y+1/2',
        'x,z,-y+1/2',
        '-z,x+1/2,-y+1/2',
        '-x+1/2,-z+1/2,-y+1/2',
        'y+1/2,z,x+1/2',
        'y+1/2,-z+1/2,-x',
        'z+1/2,y,-x',
        '-y,z,-x',
        '-z,-y,-x+1/2',
        '-y+1/2,-z,x+1/2',
        'z+1/2,-y,x',
        '-z,y+1/2,x',
        '-x+1/2,-y,-z+1/2',
        'y,-x,-z+1/2',
        'x,y+1/2,-z+1/2',
        '-y+1/2,x+1/2,-z+1/2',
        '-x+1/2,y,z+1/2',
        '-y,-x,z+1/2',
        'x,-y+1/2,z+1/2',
        'y+1/2,x+1/2,z+1/2',
        '-z+1/2,-x,-y+1/2',
        'x,-z,-y+1/2',
        'z,x+1/2,-y+1/2',
        '-x+1/2,z+1/2,-y+1/2',
        '-z+1/2,x,y+1/2',
        '-x,-z,y+1/2',
        'z,-x+1/2,y+1/2',
        'x+1/2,z+1/2,y+1/2',
        '-y+1/2,-z,-x+1/2',
        '-y+1/2,z+1/2,x',
        '-z+1/2,-y,x',
        'y,-z,x',
        'z,y,x+1/2',
        'y+1/2,z,-x+1/2',
        '-z+1/2,y,-x',
        'z,-y+1/2,-x',
        'x+1/2,y+1/2,z',
        '-y,x+1/2,z',
        '-x,-y,z',
        'y+1/2,-x,z',
        'x+1/2,-y+1/2,-z',
        'y,x+1/2,-z',
        '-x,y,-z',
        '-y+1/2,-x,-z',
        'z+1/2,x+1/2,y',
        '-x,z+1/2,y',
        '-z,-x,y',
        'x+1/2,-z,y',
        'z+1/2,-x+1/2,-y',
        'x,z+1/2,-y',
        '-z,x,-y',
        '-x+1/2,-z,-y',
        'y+1/2,z+1/2,x',
        'y+1/2,-z,-x+1/2',
        'z+1/2,y+1/2,-x+1/2',
        '-y,z+1/2,-x+1/2',
        '-z,-y+1/2,-x',
        '-y+1/2,-z+1/2,x',
        'z+1/2,-y+1/2,x+1/2',
        '-z,y,x+1/2',
        '-x+1/2,-y+1/2,-z',
        'y,-x+1/2,-z',
        'x,y,-z',
        '-y+1/2,x,-z',
        '-x+1/2,y+1/2,z',
        '-y,-x+1/2,z',
        'x,-y,z',
        'y+1/2,x,z',
        '-z+1/2,-x+1/2,-y',
        'x,-z+1/2,-y',
        'z,x,-y',
        '-x+1/2,z,-y',
        '-z+1/2,x+1/2,y',
        '-x,-z+1/2,y',
        'z,-x,y',
        'x+1/2,z,y',
        '-y+1/2,-z+1/2,-x',
        '-y+1/2,z,x+1/2',
        '-z+1/2,-y+1/2,x+1/2',
        'y,-z+1/2,x+1/2',
        'z,y+1/2,x',
        'y+1/2,z+1/2,-x',
        '-z+1/2,y+1/2,-x+1/2',
        'z,-y,-x+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x,z',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z',
        'x,-y,-z',
        'y+1/2,x,-z',
        '-x+1/2,y+1/2,-z',
        '-y,-x+1/2,-z',
        'z,x,y',
        '-x+1/2,z,y',
        '-z+1/2,-x+1/2,y',
        'x,-z+1/2,y',
        'z,-x,-y',
        'x+1/2,z,-y',
        '-z+1/2,x+1/2,-y',
        '-x,-z+1/2,-y',
        'y,z,x',
        'y,-z+1/2,-x+1/2',
        'z,y,-x+1/2',
        '-y+1/2,z,-x+1/2',
        '-z+1/2,-y,-x',
        '-y,-z,x',
        'z,-y,x+1/2',
        '-z+1/2,y+1/2,x+1/2',
        '-x,-y,-z',
        'y+1/2,-x,-z',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z',
        '-x,y,z',
        '-y+1/2,-x,z',
        'x+1/2,-y+1/2,z',
        'y,x+1/2,z',
        '-z,-x,-y',
        'x+1/2,-z,-y',
        'z+1/2,x+1/2,-y',
        '-x,z+1/2,-y',
        '-z,x,y',
        '-x+1/2,-z,y',
        'z+1/2,-x+1/2,y',
        'x,z+1/2,y',
        '-y,-z,-x',
        '-y,z+1/2,x+1/2',
        '-z,-y,x+1/2',
        'y+1/2,-z,x+1/2',
        'z+1/2,y,x',
        'y,z,-x',
        '-z,y,-x+1/2',
        'z+1/2,-y+1/2,-x+1/2',
    ]
},

{
    number          => 227,
    hall            => 'F 4d 2 3 -1d',
    schoenflies     => 'Oh^7',
    hermann_mauguin => 'F d -3 m',
    universal_h_m   => 'F d -3 m :1',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/4,x+1/4,z+1/4',
        '-x,-y+1/2,z+1/2',
        'y+3/4,-x+1/4,z+3/4',
        'x,-y,-z',
        'y+1/4,x+1/4,-z+1/4',
        '-x,y+1/2,-z+1/2',
        '-y+3/4,-x+1/4,-z+3/4',
        'z,x,y',
        '-x+1/4,z+1/4,y+1/4',
        '-z,-x+1/2,y+1/2',
        'x+3/4,-z+1/4,y+3/4',
        'z,-x,-y',
        'x+1/4,z+1/4,-y+1/4',
        '-z,x+1/2,-y+1/2',
        '-x+3/4,-z+1/4,-y+3/4',
        'y,z,x',
        'y+1/2,-z,-x+1/2',
        'z+1/4,y+3/4,-x+3/4',
        '-y+1/2,z+1/2,-x',
        '-z+1/4,-y+1/4,-x+1/4',
        '-y,-z,x',
        'z+1/4,-y+3/4,x+3/4',
        '-z+3/4,y+3/4,x+1/4',
        '-x+1/4,-y+1/4,-z+1/4',
        'y,-x,-z',
        'x+1/4,y+3/4,-z+3/4',
        '-y+1/2,x,-z+1/2',
        '-x+1/4,y+1/4,z+1/4',
        '-y,-x,z',
        'x+1/4,-y+3/4,z+3/4',
        'y+1/2,x,z+1/2',
        '-z+1/4,-x+1/4,-y+1/4',
        'x,-z,-y',
        'z+1/4,x+3/4,-y+3/4',
        '-x+1/2,z,-y+1/2',
        '-z+1/4,x+1/4,y+1/4',
        '-x,-z,y',
        'z+1/4,-x+3/4,y+3/4',
        'x+1/2,z,y+1/2',
        '-y+1/4,-z+1/4,-x+1/4',
        '-y+3/4,z+1/4,x+3/4',
        '-z,-y+1/2,x+1/2',
        'y+3/4,-z+3/4,x+1/4',
        'z,y,x',
        'y+1/4,z+1/4,-x+1/4',
        '-z,y+1/2,-x+1/2',
        'z+1/2,-y+1/2,-x',
        'x,y+1/2,z+1/2',
        '-y+1/4,x+3/4,z+3/4',
        '-x,-y,z',
        'y+3/4,-x+3/4,z+1/4',
        'x,-y+1/2,-z+1/2',
        'y+1/4,x+3/4,-z+3/4',
        '-x,y,-z',
        '-y+3/4,-x+3/4,-z+1/4',
        'z,x+1/2,y+1/2',
        '-x+1/4,z+3/4,y+3/4',
        '-z,-x,y',
        'x+3/4,-z+3/4,y+1/4',
        'z,-x+1/2,-y+1/2',
        'x+1/4,z+3/4,-y+3/4',
        '-z,x,-y',
        '-x+3/4,-z+3/4,-y+1/4',
        'y,z+1/2,x+1/2',
        'y+1/2,-z+1/2,-x',
        'z+1/4,y+1/4,-x+1/4',
        '-y+1/2,z,-x+1/2',
        '-z+1/4,-y+3/4,-x+3/4',
        '-y,-z+1/2,x+1/2',
        'z+1/4,-y+1/4,x+1/4',
        '-z+3/4,y+1/4,x+3/4',
        '-x+1/4,-y+3/4,-z+3/4',
        'y,-x+1/2,-z+1/2',
        'x+1/4,y+1/4,-z+1/4',
        '-y+1/2,x+1/2,-z',
        '-x+1/4,y+3/4,z+3/4',
        '-y,-x+1/2,z+1/2',
        'x+1/4,-y+1/4,z+1/4',
        'y+1/2,x+1/2,z',
        '-z+1/4,-x+3/4,-y+3/4',
        'x,-z+1/2,-y+1/2',
        'z+1/4,x+1/4,-y+1/4',
        '-x+1/2,z+1/2,-y',
        '-z+1/4,x+3/4,y+3/4',
        '-x,-z+1/2,y+1/2',
        'z+1/4,-x+1/4,y+1/4',
        'x+1/2,z+1/2,y',
        '-y+1/4,-z+3/4,-x+3/4',
        '-y+3/4,z+3/4,x+1/4',
        '-z,-y,x',
        'y+3/4,-z+1/4,x+3/4',
        'z,y+1/2,x+1/2',
        'y+1/4,z+3/4,-x+3/4',
        '-z,y,-x',
        'z+1/2,-y,-x+1/2',
        'x+1/2,y,z+1/2',
        '-y+3/4,x+1/4,z+3/4',
        '-x+1/2,-y+1/2,z',
        'y+1/4,-x+1/4,z+1/4',
        'x+1/2,-y,-z+1/2',
        'y+3/4,x+1/4,-z+3/4',
        '-x+1/2,y+1/2,-z',
        '-y+1/4,-x+1/4,-z+1/4',
        'z+1/2,x,y+1/2',
        '-x+3/4,z+1/4,y+3/4',
        '-z+1/2,-x+1/2,y',
        'x+1/4,-z+1/4,y+1/4',
        'z+1/2,-x,-y+1/2',
        'x+3/4,z+1/4,-y+3/4',
        '-z+1/2,x+1/2,-y',
        '-x+1/4,-z+1/4,-y+1/4',
        'y+1/2,z,x+1/2',
        'y,-z,-x',
        'z+3/4,y+3/4,-x+1/4',
        '-y,z+1/2,-x+1/2',
        '-z+3/4,-y+1/4,-x+3/4',
        '-y+1/2,-z,x+1/2',
        'z+3/4,-y+3/4,x+1/4',
        '-z+1/4,y+3/4,x+3/4',
        '-x+3/4,-y+1/4,-z+3/4',
        'y+1/2,-x,-z+1/2',
        'x+3/4,y+3/4,-z+1/4',
        '-y,x,-z',
        '-x+3/4,y+1/4,z+3/4',
        '-y+1/2,-x,z+1/2',
        'x+3/4,-y+3/4,z+1/4',
        'y,x,z',
        '-z+3/4,-x+1/4,-y+3/4',
        'x+1/2,-z,-y+1/2',
        'z+3/4,x+3/4,-y+1/4',
        '-x,z,-y',
        '-z+3/4,x+1/4,y+3/4',
        '-x+1/2,-z,y+1/2',
        'z+3/4,-x+3/4,y+1/4',
        'x,z,y',
        '-y+3/4,-z+1/4,-x+3/4',
        '-y+1/4,z+1/4,x+1/4',
        '-z+1/2,-y+1/2,x',
        'y+1/4,-z+3/4,x+3/4',
        'z+1/2,y,x+1/2',
        'y+3/4,z+1/4,-x+3/4',
        '-z+1/2,y+1/2,-x',
        'z,-y+1/2,-x+1/2',
        'x+1/2,y+1/2,z',
        '-y+3/4,x+3/4,z+1/4',
        '-x+1/2,-y,z+1/2',
        'y+1/4,-x+3/4,z+3/4',
        'x+1/2,-y+1/2,-z',
        'y+3/4,x+3/4,-z+1/4',
        '-x+1/2,y,-z+1/2',
        '-y+1/4,-x+3/4,-z+3/4',
        'z+1/2,x+1/2,y',
        '-x+3/4,z+3/4,y+1/4',
        '-z+1/2,-x,y+1/2',
        'x+1/4,-z+3/4,y+3/4',
        'z+1/2,-x+1/2,-y',
        'x+3/4,z+3/4,-y+1/4',
        '-z+1/2,x,-y+1/2',
        '-x+1/4,-z+3/4,-y+3/4',
        'y+1/2,z+1/2,x',
        'y,-z+1/2,-x+1/2',
        'z+3/4,y+1/4,-x+3/4',
        '-y,z,-x',
        '-z+3/4,-y+3/4,-x+1/4',
        '-y+1/2,-z+1/2,x',
        'z+3/4,-y+1/4,x+3/4',
        '-z+1/4,y+1/4,x+1/4',
        '-x+3/4,-y+3/4,-z+1/4',
        'y+1/2,-x+1/2,-z',
        'x+3/4,y+1/4,-z+3/4',
        '-y,x+1/2,-z+1/2',
        '-x+3/4,y+3/4,z+1/4',
        '-y+1/2,-x+1/2,z',
        'x+3/4,-y+1/4,z+3/4',
        'y,x+1/2,z+1/2',
        '-z+3/4,-x+3/4,-y+1/4',
        'x+1/2,-z+1/2,-y',
        'z+3/4,x+1/4,-y+3/4',
        '-x,z+1/2,-y+1/2',
        '-z+3/4,x+3/4,y+1/4',
        '-x+1/2,-z+1/2,y',
        'z+3/4,-x+1/4,y+3/4',
        'x,z+1/2,y+1/2',
        '-y+3/4,-z+3/4,-x+1/4',
        '-y+1/4,z+3/4,x+3/4',
        '-z+1/2,-y,x+1/2',
        'y+1/4,-z+1/4,x+1/4',
        'z+1/2,y+1/2,x',
        'y+3/4,z+3/4,-x+1/4',
        '-z+1/2,y,-x+1/2',
        'z,-y,-x',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/4,x+1/4,z+1/4',
        '-x,-y+1/2,z+1/2',
        'y+3/4,-x+1/4,z+3/4',
        'x,-y,-z',
        'y+1/4,x+1/4,-z+1/4',
        '-x,y+1/2,-z+1/2',
        '-y+3/4,-x+1/4,-z+3/4',
        'z,x,y',
        '-x+1/4,z+1/4,y+1/4',
        '-z,-x+1/2,y+1/2',
        'x+3/4,-z+1/4,y+3/4',
        'z,-x,-y',
        'x+1/4,z+1/4,-y+1/4',
        '-z,x+1/2,-y+1/2',
        '-x+3/4,-z+1/4,-y+3/4',
        'y,z,x',
        'y+1/2,-z,-x+1/2',
        'z+1/4,y+3/4,-x+3/4',
        '-y+1/2,z+1/2,-x',
        '-z+1/4,-y+1/4,-x+1/4',
        '-y,-z,x',
        'z+1/4,-y+3/4,x+3/4',
        '-z+3/4,y+3/4,x+1/4',
        '-x+1/4,-y+1/4,-z+1/4',
        'y,-x,-z',
        'x+1/4,y+3/4,-z+3/4',
        '-y+1/2,x,-z+1/2',
        '-x+1/4,y+1/4,z+1/4',
        '-y,-x,z',
        'x+1/4,-y+3/4,z+3/4',
        'y+1/2,x,z+1/2',
        '-z+1/4,-x+1/4,-y+1/4',
        'x,-z,-y',
        'z+1/4,x+3/4,-y+3/4',
        '-x+1/2,z,-y+1/2',
        '-z+1/4,x+1/4,y+1/4',
        '-x,-z,y',
        'z+1/4,-x+3/4,y+3/4',
        'x+1/2,z,y+1/2',
        '-y+1/4,-z+1/4,-x+1/4',
        '-y+3/4,z+1/4,x+3/4',
        '-z,-y+1/2,x+1/2',
        'y+3/4,-z+3/4,x+1/4',
        'z,y,x',
        'y+1/4,z+1/4,-x+1/4',
        '-z,y+1/2,-x+1/2',
        'z+1/2,-y+1/2,-x',
    ]
},

{
    number          => 227,
    hall            => '-F 4vw 2vw 3',
    schoenflies     => 'Oh^7',
    hermann_mauguin => 'F d -3 m',
    universal_h_m   => 'F d -3 m :2',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x+1/4,z+1/4',
        '-x+3/4,-y+1/4,z+1/2',
        'y+3/4,-x,z+3/4',
        'x,-y+1/4,-z+1/4',
        'y+3/4,x+1/4,-z+1/2',
        '-x+3/4,y,-z+3/4',
        '-y,-x,-z',
        'z,x,y',
        '-x,z+1/4,y+1/4',
        '-z+3/4,-x+1/4,y+1/2',
        'x+3/4,-z,y+3/4',
        'z,-x+1/4,-y+1/4',
        'x+3/4,z+1/4,-y+1/2',
        '-z+3/4,x,-y+3/4',
        '-x,-z,-y',
        'y,z,x',
        'y+1/2,-z+3/4,-x+1/4',
        'z+1/4,y+3/4,-x+1/2',
        '-y+1/4,z+1/2,-x+3/4',
        '-z,-y+1/2,-x+1/2',
        '-y+1/4,-z+1/4,x',
        'z+1/4,-y,x+1/4',
        '-z+1/2,y+1/4,x+3/4',
        '-x,-y,-z',
        'y,-x+3/4,-z+3/4',
        'x+1/4,y+3/4,-z+1/2',
        '-y+1/4,x,-z+1/4',
        '-x,y+3/4,z+3/4',
        '-y+1/4,-x+3/4,z+1/2',
        'x+1/4,-y,z+1/4',
        'y,x,z',
        '-z,-x,-y',
        'x,-z+3/4,-y+3/4',
        'z+1/4,x+3/4,-y+1/2',
        '-x+1/4,z,-y+1/4',
        '-z,x+3/4,y+3/4',
        '-x+1/4,-z+3/4,y+1/2',
        'z+1/4,-x,y+1/4',
        'x,z,y',
        '-y,-z,-x',
        '-y+1/2,z+1/4,x+3/4',
        '-z+3/4,-y+1/4,x+1/2',
        'y+3/4,-z+1/2,x+1/4',
        'z,y+1/2,x+1/2',
        'y+3/4,z+3/4,-x',
        '-z+3/4,y,-x+3/4',
        'z+1/2,-y+3/4,-x+1/4',
        'x,y+1/2,z+1/2',
        '-y,x+3/4,z+3/4',
        '-x+3/4,-y+3/4,z',
        'y+3/4,-x+1/2,z+1/4',
        'x,-y+3/4,-z+3/4',
        'y+3/4,x+3/4,-z',
        '-x+3/4,y+1/2,-z+1/4',
        '-y,-x+1/2,-z+1/2',
        'z,x+1/2,y+1/2',
        '-x,z+3/4,y+3/4',
        '-z+3/4,-x+3/4,y',
        'x+3/4,-z+1/2,y+1/4',
        'z,-x+3/4,-y+3/4',
        'x+3/4,z+3/4,-y',
        '-z+3/4,x+1/2,-y+1/4',
        '-x,-z+1/2,-y+1/2',
        'y,z+1/2,x+1/2',
        'y+1/2,-z+1/4,-x+3/4',
        'z+1/4,y+1/4,-x',
        '-y+1/4,z,-x+1/4',
        '-z,-y,-x',
        '-y+1/4,-z+3/4,x+1/2',
        'z+1/4,-y+1/2,x+3/4',
        '-z+1/2,y+3/4,x+1/4',
        '-x,-y+1/2,-z+1/2',
        'y,-x+1/4,-z+1/4',
        'x+1/4,y+1/4,-z',
        '-y+1/4,x+1/2,-z+3/4',
        '-x,y+1/4,z+1/4',
        '-y+1/4,-x+1/4,z',
        'x+1/4,-y+1/2,z+3/4',
        'y,x+1/2,z+1/2',
        '-z,-x+1/2,-y+1/2',
        'x,-z+1/4,-y+1/4',
        'z+1/4,x+1/4,-y',
        '-x+1/4,z+1/2,-y+3/4',
        '-z,x+1/4,y+1/4',
        '-x+1/4,-z+1/4,y',
        'z+1/4,-x+1/2,y+3/4',
        'x,z+1/2,y+1/2',
        '-y,-z+1/2,-x+1/2',
        '-y+1/2,z+3/4,x+1/4',
        '-z+3/4,-y+3/4,x',
        'y+3/4,-z,x+3/4',
        'z,y,x',
        'y+3/4,z+1/4,-x+1/2',
        '-z+3/4,y+1/2,-x+1/4',
        'z+1/2,-y+1/4,-x+3/4',
        'x+1/2,y,z+1/2',
        '-y+1/2,x+1/4,z+3/4',
        '-x+1/4,-y+1/4,z',
        'y+1/4,-x,z+1/4',
        'x+1/2,-y+1/4,-z+3/4',
        'y+1/4,x+1/4,-z',
        '-x+1/4,y,-z+1/4',
        '-y+1/2,-x,-z+1/2',
        'z+1/2,x,y+1/2',
        '-x+1/2,z+1/4,y+3/4',
        '-z+1/4,-x+1/4,y',
        'x+1/4,-z,y+1/4',
        'z+1/2,-x+1/4,-y+3/4',
        'x+1/4,z+1/4,-y',
        '-z+1/4,x,-y+1/4',
        '-x+1/2,-z,-y+1/2',
        'y+1/2,z,x+1/2',
        'y,-z+3/4,-x+3/4',
        'z+3/4,y+3/4,-x',
        '-y+3/4,z+1/2,-x+1/4',
        '-z+1/2,-y+1/2,-x',
        '-y+3/4,-z+1/4,x+1/2',
        'z+3/4,-y,x+3/4',
        '-z,y+1/4,x+1/4',
        '-x+1/2,-y,-z+1/2',
        'y+1/2,-x+3/4,-z+1/4',
        'x+3/4,y+3/4,-z',
        '-y+3/4,x,-z+3/4',
        '-x+1/2,y+3/4,z+1/4',
        '-y+3/4,-x+3/4,z',
        'x+3/4,-y,z+3/4',
        'y+1/2,x,z+1/2',
        '-z+1/2,-x,-y+1/2',
        'x+1/2,-z+3/4,-y+1/4',
        'z+3/4,x+3/4,-y',
        '-x+3/4,z,-y+3/4',
        '-z+1/2,x+3/4,y+1/4',
        '-x+3/4,-z+3/4,y',
        'z+3/4,-x,y+3/4',
        'x+1/2,z,y+1/2',
        '-y+1/2,-z,-x+1/2',
        '-y,z+1/4,x+1/4',
        '-z+1/4,-y+1/4,x',
        'y+1/4,-z+1/2,x+3/4',
        'z+1/2,y+1/2,x',
        'y+1/4,z+3/4,-x+1/2',
        '-z+1/4,y,-x+1/4',
        'z,-y+3/4,-x+3/4',
        'x+1/2,y+1/2,z',
        '-y+1/2,x+3/4,z+1/4',
        '-x+1/4,-y+3/4,z+1/2',
        'y+1/4,-x+1/2,z+3/4',
        'x+1/2,-y+3/4,-z+1/4',
        'y+1/4,x+3/4,-z+1/2',
        '-x+1/4,y+1/2,-z+3/4',
        '-y+1/2,-x+1/2,-z',
        'z+1/2,x+1/2,y',
        '-x+1/2,z+3/4,y+1/4',
        '-z+1/4,-x+3/4,y+1/2',
        'x+1/4,-z+1/2,y+3/4',
        'z+1/2,-x+3/4,-y+1/4',
        'x+1/4,z+3/4,-y+1/2',
        '-z+1/4,x+1/2,-y+3/4',
        '-x+1/2,-z+1/2,-y',
        'y+1/2,z+1/2,x',
        'y,-z+1/4,-x+1/4',
        'z+3/4,y+1/4,-x+1/2',
        '-y+3/4,z,-x+3/4',
        '-z+1/2,-y,-x+1/2',
        '-y+3/4,-z+3/4,x',
        'z+3/4,-y+1/2,x+1/4',
        '-z,y+3/4,x+3/4',
        '-x+1/2,-y+1/2,-z',
        'y+1/2,-x+1/4,-z+3/4',
        'x+3/4,y+1/4,-z+1/2',
        '-y+3/4,x+1/2,-z+1/4',
        '-x+1/2,y+1/4,z+3/4',
        '-y+3/4,-x+1/4,z+1/2',
        'x+3/4,-y+1/2,z+1/4',
        'y+1/2,x+1/2,z',
        '-z+1/2,-x+1/2,-y',
        'x+1/2,-z+1/4,-y+3/4',
        'z+3/4,x+1/4,-y+1/2',
        '-x+3/4,z+1/2,-y+1/4',
        '-z+1/2,x+1/4,y+3/4',
        '-x+3/4,-z+1/4,y+1/2',
        'z+3/4,-x+1/2,y+1/4',
        'x+1/2,z+1/2,y',
        '-y+1/2,-z+1/2,-x',
        '-y,z+3/4,x+3/4',
        '-z+1/4,-y+3/4,x+1/2',
        'y+1/4,-z,x+1/4',
        'z+1/2,y,x+1/2',
        'y+1/4,z+1/4,-x',
        '-z+1/4,y+1/2,-x+3/4',
        'z,-y+1/4,-x+1/4',
    ],
    ncsym => [
        'x,y,z',
        '-y,x+1/4,z+1/4',
        '-x+3/4,-y+1/4,z+1/2',
        'y+3/4,-x,z+3/4',
        'x,-y+1/4,-z+1/4',
        'y+3/4,x+1/4,-z+1/2',
        '-x+3/4,y,-z+3/4',
        '-y,-x,-z',
        'z,x,y',
        '-x,z+1/4,y+1/4',
        '-z+3/4,-x+1/4,y+1/2',
        'x+3/4,-z,y+3/4',
        'z,-x+1/4,-y+1/4',
        'x+3/4,z+1/4,-y+1/2',
        '-z+3/4,x,-y+3/4',
        '-x,-z,-y',
        'y,z,x',
        'y+1/2,-z+3/4,-x+1/4',
        'z+1/4,y+3/4,-x+1/2',
        '-y+1/4,z+1/2,-x+3/4',
        '-z,-y+1/2,-x+1/2',
        '-y+1/4,-z+1/4,x',
        'z+1/4,-y,x+1/4',
        '-z+1/2,y+1/4,x+3/4',
        '-x,-y,-z',
        'y,-x+3/4,-z+3/4',
        'x+1/4,y+3/4,-z+1/2',
        '-y+1/4,x,-z+1/4',
        '-x,y+3/4,z+3/4',
        '-y+1/4,-x+3/4,z+1/2',
        'x+1/4,-y,z+1/4',
        'y,x,z',
        '-z,-x,-y',
        'x,-z+3/4,-y+3/4',
        'z+1/4,x+3/4,-y+1/2',
        '-x+1/4,z,-y+1/4',
        '-z,x+3/4,y+3/4',
        '-x+1/4,-z+3/4,y+1/2',
        'z+1/4,-x,y+1/4',
        'x,z,y',
        '-y,-z,-x',
        '-y+1/2,z+1/4,x+3/4',
        '-z+3/4,-y+1/4,x+1/2',
        'y+3/4,-z+1/2,x+1/4',
        'z,y+1/2,x+1/2',
        'y+3/4,z+3/4,-x',
        '-z+3/4,y,-x+3/4',
        'z+1/2,-y+3/4,-x+1/4',
    ]
},

{
    number          => 228,
    hall            => 'F 4d 2 3 -1ad',
    schoenflies     => 'Oh^8',
    hermann_mauguin => 'F d -3 c',
    universal_h_m   => 'F d -3 c :1',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/4,x+1/4,z+1/4',
        '-x,-y+1/2,z+1/2',
        'y+3/4,-x+1/4,z+3/4',
        'x,-y,-z',
        'y+1/4,x+1/4,-z+1/4',
        '-x,y+1/2,-z+1/2',
        '-y+3/4,-x+1/4,-z+3/4',
        'z,x,y',
        '-x+1/4,z+1/4,y+1/4',
        '-z,-x+1/2,y+1/2',
        'x+3/4,-z+1/4,y+3/4',
        'z,-x,-y',
        'x+1/4,z+1/4,-y+1/4',
        '-z,x+1/2,-y+1/2',
        '-x+3/4,-z+1/4,-y+3/4',
        'y,z,x',
        'y+1/2,-z,-x+1/2',
        'z+1/4,y+3/4,-x+3/4',
        '-y+1/2,z+1/2,-x',
        '-z+1/4,-y+1/4,-x+1/4',
        '-y,-z,x',
        'z+1/4,-y+3/4,x+3/4',
        '-z+3/4,y+3/4,x+1/4',
        '-x+3/4,-y+1/4,-z+1/4',
        'y+1/2,-x,-z',
        'x+3/4,y+3/4,-z+3/4',
        '-y,x,-z+1/2',
        '-x+3/4,y+1/4,z+1/4',
        '-y+1/2,-x,z',
        'x+3/4,-y+3/4,z+3/4',
        'y,x,z+1/2',
        '-z+3/4,-x+1/4,-y+1/4',
        'x+1/2,-z,-y',
        'z+3/4,x+3/4,-y+3/4',
        '-x,z,-y+1/2',
        '-z+3/4,x+1/4,y+1/4',
        '-x+1/2,-z,y',
        'z+3/4,-x+3/4,y+3/4',
        'x,z,y+1/2',
        '-y+3/4,-z+1/4,-x+1/4',
        '-y+1/4,z+1/4,x+3/4',
        '-z+1/2,-y+1/2,x+1/2',
        'y+1/4,-z+3/4,x+1/4',
        'z+1/2,y,x',
        'y+3/4,z+1/4,-x+1/4',
        '-z+1/2,y+1/2,-x+1/2',
        'z,-y+1/2,-x',
        'x,y+1/2,z+1/2',
        '-y+1/4,x+3/4,z+3/4',
        '-x,-y,z',
        'y+3/4,-x+3/4,z+1/4',
        'x,-y+1/2,-z+1/2',
        'y+1/4,x+3/4,-z+3/4',
        '-x,y,-z',
        '-y+3/4,-x+3/4,-z+1/4',
        'z,x+1/2,y+1/2',
        '-x+1/4,z+3/4,y+3/4',
        '-z,-x,y',
        'x+3/4,-z+3/4,y+1/4',
        'z,-x+1/2,-y+1/2',
        'x+1/4,z+3/4,-y+3/4',
        '-z,x,-y',
        '-x+3/4,-z+3/4,-y+1/4',
        'y,z+1/2,x+1/2',
        'y+1/2,-z+1/2,-x',
        'z+1/4,y+1/4,-x+1/4',
        '-y+1/2,z,-x+1/2',
        '-z+1/4,-y+3/4,-x+3/4',
        '-y,-z+1/2,x+1/2',
        'z+1/4,-y+1/4,x+1/4',
        '-z+3/4,y+1/4,x+3/4',
        '-x+3/4,-y+3/4,-z+3/4',
        'y+1/2,-x+1/2,-z+1/2',
        'x+3/4,y+1/4,-z+1/4',
        '-y,x+1/2,-z',
        '-x+3/4,y+3/4,z+3/4',
        '-y+1/2,-x+1/2,z+1/2',
        'x+3/4,-y+1/4,z+1/4',
        'y,x+1/2,z',
        '-z+3/4,-x+3/4,-y+3/4',
        'x+1/2,-z+1/2,-y+1/2',
        'z+3/4,x+1/4,-y+1/4',
        '-x,z+1/2,-y',
        '-z+3/4,x+3/4,y+3/4',
        '-x+1/2,-z+1/2,y+1/2',
        'z+3/4,-x+1/4,y+1/4',
        'x,z+1/2,y',
        '-y+3/4,-z+3/4,-x+3/4',
        '-y+1/4,z+3/4,x+1/4',
        '-z+1/2,-y,x',
        'y+1/4,-z+1/4,x+3/4',
        'z+1/2,y+1/2,x+1/2',
        'y+3/4,z+3/4,-x+3/4',
        '-z+1/2,y,-x',
        'z,-y,-x+1/2',
        'x+1/2,y,z+1/2',
        '-y+3/4,x+1/4,z+3/4',
        '-x+1/2,-y+1/2,z',
        'y+1/4,-x+1/4,z+1/4',
        'x+1/2,-y,-z+1/2',
        'y+3/4,x+1/4,-z+3/4',
        '-x+1/2,y+1/2,-z',
        '-y+1/4,-x+1/4,-z+1/4',
        'z+1/2,x,y+1/2',
        '-x+3/4,z+1/4,y+3/4',
        '-z+1/2,-x+1/2,y',
        'x+1/4,-z+1/4,y+1/4',
        'z+1/2,-x,-y+1/2',
        'x+3/4,z+1/4,-y+3/4',
        '-z+1/2,x+1/2,-y',
        '-x+1/4,-z+1/4,-y+1/4',
        'y+1/2,z,x+1/2',
        'y,-z,-x',
        'z+3/4,y+3/4,-x+1/4',
        '-y,z+1/2,-x+1/2',
        '-z+3/4,-y+1/4,-x+3/4',
        '-y+1/2,-z,x+1/2',
        'z+3/4,-y+3/4,x+1/4',
        '-z+1/4,y+3/4,x+3/4',
        '-x+1/4,-y+1/4,-z+3/4',
        'y,-x,-z+1/2',
        'x+1/4,y+3/4,-z+1/4',
        '-y+1/2,x,-z',
        '-x+1/4,y+1/4,z+3/4',
        '-y,-x,z+1/2',
        'x+1/4,-y+3/4,z+1/4',
        'y+1/2,x,z',
        '-z+1/4,-x+1/4,-y+3/4',
        'x,-z,-y+1/2',
        'z+1/4,x+3/4,-y+1/4',
        '-x+1/2,z,-y',
        '-z+1/4,x+1/4,y+3/4',
        '-x,-z,y+1/2',
        'z+1/4,-x+3/4,y+1/4',
        'x+1/2,z,y',
        '-y+1/4,-z+1/4,-x+3/4',
        '-y+3/4,z+1/4,x+1/4',
        '-z,-y+1/2,x',
        'y+3/4,-z+3/4,x+3/4',
        'z,y,x+1/2',
        'y+1/4,z+1/4,-x+3/4',
        '-z,y+1/2,-x',
        'z+1/2,-y+1/2,-x+1/2',
        'x+1/2,y+1/2,z',
        '-y+3/4,x+3/4,z+1/4',
        '-x+1/2,-y,z+1/2',
        'y+1/4,-x+3/4,z+3/4',
        'x+1/2,-y+1/2,-z',
        'y+3/4,x+3/4,-z+1/4',
        '-x+1/2,y,-z+1/2',
        '-y+1/4,-x+3/4,-z+3/4',
        'z+1/2,x+1/2,y',
        '-x+3/4,z+3/4,y+1/4',
        '-z+1/2,-x,y+1/2',
        'x+1/4,-z+3/4,y+3/4',
        'z+1/2,-x+1/2,-y',
        'x+3/4,z+3/4,-y+1/4',
        '-z+1/2,x,-y+1/2',
        '-x+1/4,-z+3/4,-y+3/4',
        'y+1/2,z+1/2,x',
        'y,-z+1/2,-x+1/2',
        'z+3/4,y+1/4,-x+3/4',
        '-y,z,-x',
        '-z+3/4,-y+3/4,-x+1/4',
        '-y+1/2,-z+1/2,x',
        'z+3/4,-y+1/4,x+3/4',
        '-z+1/4,y+1/4,x+1/4',
        '-x+1/4,-y+3/4,-z+1/4',
        'y,-x+1/2,-z',
        'x+1/4,y+1/4,-z+3/4',
        '-y+1/2,x+1/2,-z+1/2',
        '-x+1/4,y+3/4,z+1/4',
        '-y,-x+1/2,z',
        'x+1/4,-y+1/4,z+3/4',
        'y+1/2,x+1/2,z+1/2',
        '-z+1/4,-x+3/4,-y+1/4',
        'x,-z+1/2,-y',
        'z+1/4,x+1/4,-y+3/4',
        '-x+1/2,z+1/2,-y+1/2',
        '-z+1/4,x+3/4,y+1/4',
        '-x,-z+1/2,y',
        'z+1/4,-x+1/4,y+3/4',
        'x+1/2,z+1/2,y+1/2',
        '-y+1/4,-z+3/4,-x+1/4',
        '-y+3/4,z+3/4,x+3/4',
        '-z,-y,x+1/2',
        'y+3/4,-z+1/4,x+1/4',
        'z,y+1/2,x',
        'y+1/4,z+3/4,-x+1/4',
        '-z,y,-x+1/2',
        'z+1/2,-y,-x',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/4,x+1/4,z+1/4',
        '-x,-y+1/2,z+1/2',
        'y+3/4,-x+1/4,z+3/4',
        'x,-y,-z',
        'y+1/4,x+1/4,-z+1/4',
        '-x,y+1/2,-z+1/2',
        '-y+3/4,-x+1/4,-z+3/4',
        'z,x,y',
        '-x+1/4,z+1/4,y+1/4',
        '-z,-x+1/2,y+1/2',
        'x+3/4,-z+1/4,y+3/4',
        'z,-x,-y',
        'x+1/4,z+1/4,-y+1/4',
        '-z,x+1/2,-y+1/2',
        '-x+3/4,-z+1/4,-y+3/4',
        'y,z,x',
        'y+1/2,-z,-x+1/2',
        'z+1/4,y+3/4,-x+3/4',
        '-y+1/2,z+1/2,-x',
        '-z+1/4,-y+1/4,-x+1/4',
        '-y,-z,x',
        'z+1/4,-y+3/4,x+3/4',
        '-z+3/4,y+3/4,x+1/4',
        '-x+3/4,-y+1/4,-z+1/4',
        'y+1/2,-x,-z',
        'x+3/4,y+3/4,-z+3/4',
        '-y,x,-z+1/2',
        '-x+3/4,y+1/4,z+1/4',
        '-y+1/2,-x,z',
        'x+3/4,-y+3/4,z+3/4',
        'y,x,z+1/2',
        '-z+3/4,-x+1/4,-y+1/4',
        'x+1/2,-z,-y',
        'z+3/4,x+3/4,-y+3/4',
        '-x,z,-y+1/2',
        '-z+3/4,x+1/4,y+1/4',
        '-x+1/2,-z,y',
        'z+3/4,-x+3/4,y+3/4',
        'x,z,y+1/2',
        '-y+3/4,-z+1/4,-x+1/4',
        '-y+1/4,z+1/4,x+3/4',
        '-z+1/2,-y+1/2,x+1/2',
        'y+1/4,-z+3/4,x+1/4',
        'z+1/2,y,x',
        'y+3/4,z+1/4,-x+1/4',
        '-z+1/2,y+1/2,-x+1/2',
        'z,-y+1/2,-x',
    ]
},

{
    number          => 228,
    hall            => '-F 4ud 2vw 3',
    schoenflies     => 'Oh^8',
    hermann_mauguin => 'F d -3 c',
    universal_h_m   => 'F d -3 c :2',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x+1/4,z+1/4',
        '-x+1/4,-y+3/4,z+1/2',
        'y+3/4,-x+1/2,z+3/4',
        'x,-y+1/4,-z+1/4',
        'y+1/4,x+1/4,-z+1/2',
        '-x+1/4,y+1/2,-z+3/4',
        '-y,-x+1/2,-z',
        'z,x,y',
        '-x+1/2,z+1/4,y+1/4',
        '-z+1/4,-x+3/4,y+1/2',
        'x+3/4,-z+1/2,y+3/4',
        'z,-x+1/4,-y+1/4',
        'x+1/4,z+1/4,-y+1/2',
        '-z+1/4,x+1/2,-y+3/4',
        '-x,-z+1/2,-y',
        'y,z,x',
        'y+1/2,-z+1/4,-x+3/4',
        'z+1/4,y+3/4,-x',
        '-y+3/4,z+1/2,-x+1/4',
        '-z+1/2,-y+1/2,-x+1/2',
        '-y+1/4,-z+1/4,x',
        'z+1/4,-y,x+3/4',
        '-z,y+3/4,x+1/4',
        '-x,-y,-z',
        'y+1/2,-x+3/4,-z+3/4',
        'x+3/4,y+1/4,-z+1/2',
        '-y+1/4,x+1/2,-z+1/4',
        '-x,y+3/4,z+3/4',
        '-y+3/4,-x+3/4,z+1/2',
        'x+3/4,-y+1/2,z+1/4',
        'y,x+1/2,z',
        '-z,-x,-y',
        'x+1/2,-z+3/4,-y+3/4',
        'z+3/4,x+1/4,-y+1/2',
        '-x+1/4,z+1/2,-y+1/4',
        '-z,x+3/4,y+3/4',
        '-x+3/4,-z+3/4,y+1/2',
        'z+3/4,-x+1/2,y+1/4',
        'x,z+1/2,y',
        '-y,-z,-x',
        '-y+1/2,z+3/4,x+1/4',
        '-z+3/4,-y+1/4,x',
        'y+1/4,-z+1/2,x+3/4',
        'z+1/2,y+1/2,x+1/2',
        'y+3/4,z+3/4,-x',
        '-z+3/4,y,-x+1/4',
        'z,-y+1/4,-x+3/4',
        'x,y+1/2,z+1/2',
        '-y+1/2,x+3/4,z+3/4',
        '-x+1/4,-y+1/4,z',
        'y+3/4,-x,z+1/4',
        'x,-y+3/4,-z+3/4',
        'y+1/4,x+3/4,-z',
        '-x+1/4,y,-z+1/4',
        '-y,-x,-z+1/2',
        'z,x+1/2,y+1/2',
        '-x+1/2,z+3/4,y+3/4',
        '-z+1/4,-x+1/4,y',
        'x+3/4,-z,y+1/4',
        'z,-x+3/4,-y+3/4',
        'x+1/4,z+3/4,-y',
        '-z+1/4,x,-y+1/4',
        '-x,-z,-y+1/2',
        'y,z+1/2,x+1/2',
        'y+1/2,-z+3/4,-x+1/4',
        'z+1/4,y+1/4,-x+1/2',
        '-y+3/4,z,-x+3/4',
        '-z+1/2,-y,-x',
        '-y+1/4,-z+3/4,x+1/2',
        'z+1/4,-y+1/2,x+1/4',
        '-z,y+1/4,x+3/4',
        '-x,-y+1/2,-z+1/2',
        'y+1/2,-x+1/4,-z+1/4',
        'x+3/4,y+3/4,-z',
        '-y+1/4,x,-z+3/4',
        '-x,y+1/4,z+1/4',
        '-y+3/4,-x+1/4,z',
        'x+3/4,-y,z+3/4',
        'y,x,z+1/2',
        '-z,-x+1/2,-y+1/2',
        'x+1/2,-z+1/4,-y+1/4',
        'z+3/4,x+3/4,-y',
        '-x+1/4,z,-y+3/4',
        '-z,x+1/4,y+1/4',
        '-x+3/4,-z+1/4,y',
        'z+3/4,-x,y+3/4',
        'x,z,y+1/2',
        '-y,-z+1/2,-x+1/2',
        '-y+1/2,z+1/4,x+3/4',
        '-z+3/4,-y+3/4,x+1/2',
        'y+1/4,-z,x+1/4',
        'z+1/2,y,x',
        'y+3/4,z+1/4,-x+1/2',
        '-z+3/4,y+1/2,-x+3/4',
        'z,-y+3/4,-x+1/4',
        'x+1/2,y,z+1/2',
        '-y,x+1/4,z+3/4',
        '-x+3/4,-y+3/4,z',
        'y+1/4,-x+1/2,z+1/4',
        'x+1/2,-y+1/4,-z+3/4',
        'y+3/4,x+1/4,-z',
        '-x+3/4,y+1/2,-z+1/4',
        '-y+1/2,-x+1/2,-z+1/2',
        'z+1/2,x,y+1/2',
        '-x,z+1/4,y+3/4',
        '-z+3/4,-x+3/4,y',
        'x+1/4,-z+1/2,y+1/4',
        'z+1/2,-x+1/4,-y+3/4',
        'x+3/4,z+1/4,-y',
        '-z+3/4,x+1/2,-y+1/4',
        '-x+1/2,-z+1/2,-y+1/2',
        'y+1/2,z,x+1/2',
        'y,-z+1/4,-x+1/4',
        'z+3/4,y+3/4,-x+1/2',
        '-y+1/4,z+1/2,-x+3/4',
        '-z,-y+1/2,-x',
        '-y+3/4,-z+1/4,x+1/2',
        'z+3/4,-y,x+1/4',
        '-z+1/2,y+3/4,x+3/4',
        '-x+1/2,-y,-z+1/2',
        'y,-x+3/4,-z+1/4',
        'x+1/4,y+1/4,-z',
        '-y+3/4,x+1/2,-z+3/4',
        '-x+1/2,y+3/4,z+1/4',
        '-y+1/4,-x+3/4,z',
        'x+1/4,-y+1/2,z+3/4',
        'y+1/2,x+1/2,z+1/2',
        '-z+1/2,-x,-y+1/2',
        'x,-z+3/4,-y+1/4',
        'z+1/4,x+1/4,-y',
        '-x+3/4,z+1/2,-y+3/4',
        '-z+1/2,x+3/4,y+1/4',
        '-x+1/4,-z+3/4,y',
        'z+1/4,-x+1/2,y+3/4',
        'x+1/2,z+1/2,y+1/2',
        '-y+1/2,-z,-x+1/2',
        '-y,z+3/4,x+3/4',
        '-z+1/4,-y+1/4,x+1/2',
        'y+3/4,-z+1/2,x+1/4',
        'z,y+1/2,x',
        'y+1/4,z+3/4,-x+1/2',
        '-z+1/4,y,-x+3/4',
        'z+1/2,-y+1/4,-x+1/4',
        'x+1/2,y+1/2,z',
        '-y,x+3/4,z+1/4',
        '-x+3/4,-y+1/4,z+1/2',
        'y+1/4,-x,z+3/4',
        'x+1/2,-y+3/4,-z+1/4',
        'y+3/4,x+3/4,-z+1/2',
        '-x+3/4,y,-z+3/4',
        '-y+1/2,-x,-z',
        'z+1/2,x+1/2,y',
        '-x,z+3/4,y+1/4',
        '-z+3/4,-x+1/4,y+1/2',
        'x+1/4,-z,y+3/4',
        'z+1/2,-x+3/4,-y+1/4',
        'x+3/4,z+3/4,-y+1/2',
        '-z+3/4,x,-y+3/4',
        '-x+1/2,-z,-y',
        'y+1/2,z+1/2,x',
        'y,-z+3/4,-x+3/4',
        'z+3/4,y+1/4,-x',
        '-y+1/4,z,-x+1/4',
        '-z,-y,-x+1/2',
        '-y+3/4,-z+3/4,x',
        'z+3/4,-y+1/2,x+3/4',
        '-z+1/2,y+1/4,x+1/4',
        '-x+1/2,-y+1/2,-z',
        'y,-x+1/4,-z+3/4',
        'x+1/4,y+3/4,-z+1/2',
        '-y+3/4,x,-z+1/4',
        '-x+1/2,y+1/4,z+3/4',
        '-y+1/4,-x+1/4,z+1/2',
        'x+1/4,-y,z+1/4',
        'y+1/2,x,z',
        '-z+1/2,-x+1/2,-y',
        'x,-z+1/4,-y+3/4',
        'z+1/4,x+3/4,-y+1/2',
        '-x+3/4,z,-y+1/4',
        '-z+1/2,x+1/4,y+3/4',
        '-x+1/4,-z+1/4,y+1/2',
        'z+1/4,-x,y+1/4',
        'x+1/2,z,y',
        '-y+1/2,-z+1/2,-x',
        '-y,z+1/4,x+1/4',
        '-z+1/4,-y+3/4,x',
        'y+3/4,-z,x+3/4',
        'z,y,x+1/2',
        'y+1/4,z+1/4,-x',
        '-z+1/4,y+1/2,-x+1/4',
        'z+1/2,-y+3/4,-x+3/4',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x+1/4,z+1/4',
        '-x+1/4,-y+3/4,z+1/2',
        'y+3/4,-x+1/2,z+3/4',
        'x,-y+1/4,-z+1/4',
        'y+1/4,x+1/4,-z+1/2',
        '-x+1/4,y+1/2,-z+3/4',
        '-y,-x+1/2,-z',
        'z,x,y',
        '-x+1/2,z+1/4,y+1/4',
        '-z+1/4,-x+3/4,y+1/2',
        'x+3/4,-z+1/2,y+3/4',
        'z,-x+1/4,-y+1/4',
        'x+1/4,z+1/4,-y+1/2',
        '-z+1/4,x+1/2,-y+3/4',
        '-x,-z+1/2,-y',
        'y,z,x',
        'y+1/2,-z+1/4,-x+3/4',
        'z+1/4,y+3/4,-x',
        '-y+3/4,z+1/2,-x+1/4',
        '-z+1/2,-y+1/2,-x+1/2',
        '-y+1/4,-z+1/4,x',
        'z+1/4,-y,x+3/4',
        '-z,y+3/4,x+1/4',
        '-x,-y,-z',
        'y+1/2,-x+3/4,-z+3/4',
        'x+3/4,y+1/4,-z+1/2',
        '-y+1/4,x+1/2,-z+1/4',
        '-x,y+3/4,z+3/4',
        '-y+3/4,-x+3/4,z+1/2',
        'x+3/4,-y+1/2,z+1/4',
        'y,x+1/2,z',
        '-z,-x,-y',
        'x+1/2,-z+3/4,-y+3/4',
        'z+3/4,x+1/4,-y+1/2',
        '-x+1/4,z+1/2,-y+1/4',
        '-z,x+3/4,y+3/4',
        '-x+3/4,-z+3/4,y+1/2',
        'z+3/4,-x+1/2,y+1/4',
        'x,z+1/2,y',
        '-y,-z,-x',
        '-y+1/2,z+3/4,x+1/4',
        '-z+3/4,-y+1/4,x',
        'y+1/4,-z+1/2,x+3/4',
        'z+1/2,y+1/2,x+1/2',
        'y+3/4,z+3/4,-x',
        '-z+3/4,y,-x+1/4',
        'z,-y+1/4,-x+3/4',
    ]
},

{
    number          => 229,
    hall            => '-I 4 2 3',
    schoenflies     => 'Oh^9',
    hermann_mauguin => 'I m -3 m',
    universal_h_m   => 'I m -3 m',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x,-y,-z',
        'y,x,-z',
        '-x,y,-z',
        '-y,-x,-z',
        'z,x,y',
        '-x,z,y',
        '-z,-x,y',
        'x,-z,y',
        'z,-x,-y',
        'x,z,-y',
        '-z,x,-y',
        '-x,-z,-y',
        'y,z,x',
        'y,-z,-x',
        'z,y,-x',
        '-y,z,-x',
        '-z,-y,-x',
        '-y,-z,x',
        'z,-y,x',
        '-z,y,x',
        '-x,-y,-z',
        'y,-x,-z',
        'x,y,-z',
        '-y,x,-z',
        '-x,y,z',
        '-y,-x,z',
        'x,-y,z',
        'y,x,z',
        '-z,-x,-y',
        'x,-z,-y',
        'z,x,-y',
        '-x,z,-y',
        '-z,x,y',
        '-x,-z,y',
        'z,-x,y',
        'x,z,y',
        '-y,-z,-x',
        '-y,z,x',
        '-z,-y,x',
        'y,-z,x',
        'z,y,x',
        'y,z,-x',
        '-z,y,-x',
        'z,-y,-x',
        'x+1/2,y+1/2,z+1/2',
        '-y+1/2,x+1/2,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        'y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        'y+1/2,x+1/2,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-y+1/2,-x+1/2,-z+1/2',
        'z+1/2,x+1/2,y+1/2',
        '-x+1/2,z+1/2,y+1/2',
        '-z+1/2,-x+1/2,y+1/2',
        'x+1/2,-z+1/2,y+1/2',
        'z+1/2,-x+1/2,-y+1/2',
        'x+1/2,z+1/2,-y+1/2',
        '-z+1/2,x+1/2,-y+1/2',
        '-x+1/2,-z+1/2,-y+1/2',
        'y+1/2,z+1/2,x+1/2',
        'y+1/2,-z+1/2,-x+1/2',
        'z+1/2,y+1/2,-x+1/2',
        '-y+1/2,z+1/2,-x+1/2',
        '-z+1/2,-y+1/2,-x+1/2',
        '-y+1/2,-z+1/2,x+1/2',
        'z+1/2,-y+1/2,x+1/2',
        '-z+1/2,y+1/2,x+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        'y+1/2,-x+1/2,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-y+1/2,x+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        '-y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        'y+1/2,x+1/2,z+1/2',
        '-z+1/2,-x+1/2,-y+1/2',
        'x+1/2,-z+1/2,-y+1/2',
        'z+1/2,x+1/2,-y+1/2',
        '-x+1/2,z+1/2,-y+1/2',
        '-z+1/2,x+1/2,y+1/2',
        '-x+1/2,-z+1/2,y+1/2',
        'z+1/2,-x+1/2,y+1/2',
        'x+1/2,z+1/2,y+1/2',
        '-y+1/2,-z+1/2,-x+1/2',
        '-y+1/2,z+1/2,x+1/2',
        '-z+1/2,-y+1/2,x+1/2',
        'y+1/2,-z+1/2,x+1/2',
        'z+1/2,y+1/2,x+1/2',
        'y+1/2,z+1/2,-x+1/2',
        '-z+1/2,y+1/2,-x+1/2',
        'z+1/2,-y+1/2,-x+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x,-y,-z',
        'y,x,-z',
        '-x,y,-z',
        '-y,-x,-z',
        'z,x,y',
        '-x,z,y',
        '-z,-x,y',
        'x,-z,y',
        'z,-x,-y',
        'x,z,-y',
        '-z,x,-y',
        '-x,-z,-y',
        'y,z,x',
        'y,-z,-x',
        'z,y,-x',
        '-y,z,-x',
        '-z,-y,-x',
        '-y,-z,x',
        'z,-y,x',
        '-z,y,x',
        '-x,-y,-z',
        'y,-x,-z',
        'x,y,-z',
        '-y,x,-z',
        '-x,y,z',
        '-y,-x,z',
        'x,-y,z',
        'y,x,z',
        '-z,-x,-y',
        'x,-z,-y',
        'z,x,-y',
        '-x,z,-y',
        '-z,x,y',
        '-x,-z,y',
        'z,-x,y',
        'x,z,y',
        '-y,-z,-x',
        '-y,z,x',
        '-z,-y,x',
        'y,-z,x',
        'z,y,x',
        'y,z,-x',
        '-z,y,-x',
        'z,-y,-x',
    ]
},

{
    number          => 230,
    hall            => '-I 4bd 2c 3',
    schoenflies     => 'Oh^10',
    hermann_mauguin => 'I a -3 d',
    universal_h_m   => 'I a -3 d',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/4,x+3/4,z+1/4',
        '-x+1/2,-y,z+1/2',
        'y+1/4,-x+1/4,z+3/4',
        'x,-y,-z+1/2',
        'y+1/4,x+3/4,-z+3/4',
        '-x+1/2,y,-z',
        '-y+1/4,-x+1/4,-z+1/4',
        'z,x,y',
        '-x+1/4,z+3/4,y+1/4',
        '-z+1/2,-x,y+1/2',
        'x+1/4,-z+1/4,y+3/4',
        'z,-x,-y+1/2',
        'x+1/4,z+3/4,-y+3/4',
        '-z+1/2,x,-y',
        '-x+1/4,-z+1/4,-y+1/4',
        'y,z,x',
        'y+1/2,-z+1/2,-x',
        'z+3/4,y+1/4,-x+1/4',
        '-y,z+1/2,-x+1/2',
        '-z+1/4,-y+1/4,-x+1/4',
        '-y+1/2,-z,x+1/2',
        'z+3/4,-y+3/4,x+1/4',
        '-z+3/4,y+1/4,x+3/4',
        '-x,-y,-z',
        'y+3/4,-x+1/4,-z+3/4',
        'x+1/2,y,-z+1/2',
        '-y+3/4,x+3/4,-z+1/4',
        '-x,y,z+1/2',
        '-y+3/4,-x+1/4,z+1/4',
        'x+1/2,-y,z',
        'y+3/4,x+3/4,z+3/4',
        '-z,-x,-y',
        'x+3/4,-z+1/4,-y+3/4',
        'z+1/2,x,-y+1/2',
        '-x+3/4,z+3/4,-y+1/4',
        '-z,x,y+1/2',
        '-x+3/4,-z+1/4,y+1/4',
        'z+1/2,-x,y',
        'x+3/4,z+3/4,y+3/4',
        '-y,-z,-x',
        '-y+1/2,z+1/2,x',
        '-z+1/4,-y+3/4,x+3/4',
        'y,-z+1/2,x+1/2',
        'z+3/4,y+3/4,x+3/4',
        'y+1/2,z,-x+1/2',
        '-z+1/4,y+1/4,-x+3/4',
        'z+1/4,-y+3/4,-x+1/4',
        'x+1/2,y+1/2,z+1/2',
        '-y+3/4,x+1/4,z+3/4',
        '-x,-y+1/2,z',
        'y+3/4,-x+3/4,z+1/4',
        'x+1/2,-y+1/2,-z',
        'y+3/4,x+1/4,-z+1/4',
        '-x,y+1/2,-z+1/2',
        '-y+3/4,-x+3/4,-z+3/4',
        'z+1/2,x+1/2,y+1/2',
        '-x+3/4,z+1/4,y+3/4',
        '-z,-x+1/2,y',
        'x+3/4,-z+3/4,y+1/4',
        'z+1/2,-x+1/2,-y',
        'x+3/4,z+1/4,-y+1/4',
        '-z,x+1/2,-y+1/2',
        '-x+3/4,-z+3/4,-y+3/4',
        'y+1/2,z+1/2,x+1/2',
        'y,-z,-x+1/2',
        'z+1/4,y+3/4,-x+3/4',
        '-y+1/2,z,-x',
        '-z+3/4,-y+3/4,-x+3/4',
        '-y,-z+1/2,x',
        'z+1/4,-y+1/4,x+3/4',
        '-z+1/4,y+3/4,x+1/4',
        '-x+1/2,-y+1/2,-z+1/2',
        'y+1/4,-x+3/4,-z+1/4',
        'x,y+1/2,-z',
        '-y+1/4,x+1/4,-z+3/4',
        '-x+1/2,y+1/2,z',
        '-y+1/4,-x+3/4,z+3/4',
        'x,-y+1/2,z+1/2',
        'y+1/4,x+1/4,z+1/4',
        '-z+1/2,-x+1/2,-y+1/2',
        'x+1/4,-z+3/4,-y+1/4',
        'z,x+1/2,-y',
        '-x+1/4,z+1/4,-y+3/4',
        '-z+1/2,x+1/2,y',
        '-x+1/4,-z+3/4,y+3/4',
        'z,-x+1/2,y+1/2',
        'x+1/4,z+1/4,y+1/4',
        '-y+1/2,-z+1/2,-x+1/2',
        '-y,z,x+1/2',
        '-z+3/4,-y+1/4,x+1/4',
        'y+1/2,-z,x',
        'z+1/4,y+1/4,x+1/4',
        'y,z+1/2,-x',
        '-z+3/4,y+3/4,-x+1/4',
        'z+3/4,-y+1/4,-x+3/4',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/4,x+3/4,z+1/4',
        '-x+1/2,-y,z+1/2',
        'y+1/4,-x+1/4,z+3/4',
        'x,-y,-z+1/2',
        'y+1/4,x+3/4,-z+3/4',
        '-x+1/2,y,-z',
        '-y+1/4,-x+1/4,-z+1/4',
        'z,x,y',
        '-x+1/4,z+3/4,y+1/4',
        '-z+1/2,-x,y+1/2',
        'x+1/4,-z+1/4,y+3/4',
        'z,-x,-y+1/2',
        'x+1/4,z+3/4,-y+3/4',
        '-z+1/2,x,-y',
        '-x+1/4,-z+1/4,-y+1/4',
        'y,z,x',
        'y+1/2,-z+1/2,-x',
        'z+3/4,y+1/4,-x+1/4',
        '-y,z+1/2,-x+1/2',
        '-z+1/4,-y+1/4,-x+1/4',
        '-y+1/2,-z,x+1/2',
        'z+3/4,-y+3/4,x+1/4',
        '-z+3/4,y+1/4,x+3/4',
        '-x,-y,-z',
        'y+3/4,-x+1/4,-z+3/4',
        'x+1/2,y,-z+1/2',
        '-y+3/4,x+3/4,-z+1/4',
        '-x,y,z+1/2',
        '-y+3/4,-x+1/4,z+1/4',
        'x+1/2,-y,z',
        'y+3/4,x+3/4,z+3/4',
        '-z,-x,-y',
        'x+3/4,-z+1/4,-y+3/4',
        'z+1/2,x,-y+1/2',
        '-x+3/4,z+3/4,-y+1/4',
        '-z,x,y+1/2',
        '-x+3/4,-z+1/4,y+1/4',
        'z+1/2,-x,y',
        'x+3/4,z+3/4,y+3/4',
        '-y,-z,-x',
        '-y+1/2,z+1/2,x',
        '-z+1/4,-y+3/4,x+3/4',
        'y,-z+1/2,x+1/2',
        'z+3/4,y+3/4,x+3/4',
        'y+1/2,z,-x+1/2',
        '-z+1/4,y+1/4,-x+3/4',
        'z+1/4,-y+3/4,-x+1/4',
    ]
}
);

@COD::Spacegroups::Lookup::COD::extra_settings = (
{
    number          => 1,
    hall            => 'A 1',
    schoenflies     => 'C1^1',
    hermann_mauguin => 'A 1',
    universal_h_m   => 'A 1',
    crystal_class   => 'triclinic',
    constraints     => '1',
    symops => [
        'x,y,z',
        'x,y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
    ]
},

{
    number          => 1,
    hall            => 'B 1',
    schoenflies     => 'C1^1',
    hermann_mauguin => 'B 1',
    universal_h_m   => 'B 1',
    crystal_class   => 'triclinic',
    constraints     => '1',
    symops => [
        'x,y,z',
        'x+1/2,y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
    ]
},

{
    number          => 1,
    hall            => 'C 1',
    schoenflies     => 'C1^1',
    hermann_mauguin => 'C 1',
    universal_h_m   => 'C 1',
    crystal_class   => 'triclinic',
    constraints     => '1',
    symops => [
        'x,y,z',
        'x+1/2,y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
    ]
},

{
    number          => 1,
    hall            => 'F 1',
    schoenflies     => 'C1^1',
    hermann_mauguin => 'F 1',
    universal_h_m   => 'F 1',
    crystal_class   => 'triclinic',
    constraints     => '1',
    symops => [
        'x,y,z',
        'x,y+1/2,z+1/2',
        'x+1/2,y,z+1/2',
        'x+1/2,y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
    ]
},

{
    number          => 1,
    hall            => 'I 1',
    schoenflies     => 'C1^1',
    hermann_mauguin => 'I 1',
    universal_h_m   => 'I 1',
    crystal_class   => 'triclinic',
    constraints     => '1',
    symops => [
        'x,y,z',
        'x+1/2,y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
    ]
},

{
    number          => 2,
    hall            => '-A 1',
    schoenflies     => 'Ci^1',
    hermann_mauguin => 'A -1',
    universal_h_m   => 'A -1',
    crystal_class   => 'triclinic',
    constraints     => '1',
    symops => [
        'x,y,z',
        '-x,-y,-z',
        'x,y+1/2,z+1/2',
        '-x,-y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,-z',
    ]
},

{
    number          => 2,
    hall            => '-B 1',
    schoenflies     => 'Ci^1',
    hermann_mauguin => 'B -1',
    universal_h_m   => 'B -1',
    crystal_class   => 'triclinic',
    constraints     => '1',
    symops => [
        'x,y,z',
        '-x,-y,-z',
        'x+1/2,y,z+1/2',
        '-x+1/2,-y,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,-z',
    ]
},

# A non-standard 'C -1' setting used in the M. A. Siegler et al. paper
# in the Acta Cryst. B vol. 64 issue 6, 2008, p.738 (bs5069).
#
# Hall symbol taken as determined by the CCTBX Web service
# (http://cci.lbl.gov/cctbx/cctbx_web.cgi) on 2009.03.28
#
# Schoenflies symbol taken from the space group 2 entry in this file.
#
# Hermann-Mauguin symbol taken from the M. A. Siegler's bs5069 paper's
# CIFs.
#
{
    number          => 2,
    hall            => '-C 1',
    schoenflies     => 'Ci^1',
    hermann_mauguin => 'C -1',
    universal_h_m   => 'C -1',
    crystal_class   => 'triclinic',
    constraints     => '1',
    symops => [
        'x,y,z',
        '-x,-y,-z',
        'x+1/2,y+1/2,z',
        '-x+1/2,-y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,-z',
    ]
},

{
    number          => 2,
    hall            => '-F 1',
    schoenflies     => 'Ci^1',
    hermann_mauguin => 'F -1',
    universal_h_m   => 'F -1',
    crystal_class   => 'triclinic',
    constraints     => '1',
    symops => [
        'x,y,z',
        '-x,-y,-z',
        'x,y+1/2,z+1/2',
        '-x,-y+1/2,-z+1/2',
        'x+1/2,y,z+1/2',
        '-x+1/2,-y,-z+1/2',
        'x+1/2,y+1/2,z',
        '-x+1/2,-y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,-z',
    ]
},

{
    number          => 2,
    hall            => '-I 1',
    schoenflies     => 'D2^4',
    hermann_mauguin => 'I -1',
    universal_h_m   => 'I -1',
    crystal_class   => 'triclinic',
    constraints     => '1',
    symops => [
        'x,y,z',
        '-x,-y,-z',
        'x+1/2,y+1/2,z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,-z',
    ]
},

{
    number          => 9,
    hall            => 'C -2yc (y,-x+1/2*z,1/2*z)',
    schoenflies     => 'C2h^6',
    hermann_mauguin => 'F d 1 1',
    universal_h_m   => 'F d 1 1',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,y+1/2,z+1/2',
        'x+1/2,y,z+1/2',
        'x+1/2,y+1/2,z',
        '-x,y+1/4,z+1/4',
        '-x,y+3/4,z+3/4',
        '-x+1/2,y+1/4,z+3/4',
        '-x+1/2,y+3/4,z+1/4',
    ],
    ncsym => [
        'x,y,z',
        '-x,y+1/4,z+1/4',
    ]
},

# Used commonly to compare 'C 1 c 1' structures with 'F d d d' structures.
{
    number          => 9,
    hall            => 'C -2yc (x+1/2*z,y,1/2*z)',
    schoenflies     => 'C2h^6',
    hermann_mauguin => 'F 1 d 1',
    universal_h_m   => 'F 1 d 1',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/4,-y,z+1/4',
        'x,y+1/2,z+1/2',
        'x+1/4,-y+1/2,z+3/4',
        'x+1/2,y,z+1/2',
        'x+3/4,-y,z+3/4',
        'x+1/2,y+1/2,z',
        'x+3/4,-y+1/2,z+1/4',
    ],
    ncsym => [
        'x,y,z',
        'x+1/4,-y,z+1/4',
    ]
},

{
    number          => 9,
    hall            => 'C -2yc (-x+1/2*z,1/2*z,y)',
    schoenflies     => 'C2h^6',
    hermann_mauguin => 'F 1 1 d',
    universal_h_m   => 'F 1 1 d',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        'x,y+1/2,z+1/2',
        'x+1/2,y,z+1/2',
        'x+1/2,y+1/2,z',
        'x+1/4,y+1/4,-z',
        'x+1/4,y+3/4,-z+1/2',
        'x+3/4,y+1/4,-z+1/2',
        'x+3/4,y+3/4,-z',
    ],
    ncsym => [
        'x,y,z',
        'x+1/4,y+1/4,-z',
    ]
},

# Used commonly to compare 'C 1 c 1' structures with 'F d d 2' structures.
{
    number          => 9,
    hall            => 'C -2yc (x-1/2*z+3/8,y+3/8,1/2*z)',
    schoenflies     => 'C2h^6',
    hermann_mauguin => 'C 1 c 1 (a-3/8,b-3/8,a+2*c)',
    universal_h_m   => 'C 1 c 1 (a-3/8,b-3/8,a+2*c)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/4,-y+1/4,z+1/4',
        'x,y+1/2,z+1/2',
        'x+1/4,-y+3/4,z+3/4',
        'x+1/2,y,z+1/2',
        'x+3/4,-y+1/4,z+3/4',
        'x+1/2,y+1/2,z',
        'x+3/4,-y+3/4,z+1/4',
    ],
    ncsym => [
        'x,y,z',
        'x+1/4,-y+1/4,z+1/4',
    ]
},

{
    number          => 15,
    hall            => '-C 2yc (x+1/2*z,y,1/2*z)',
    schoenflies     => 'C2h^6',
    hermann_mauguin => 'F 1 2/d 1',
    universal_h_m   => 'F 1 2/d 1',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/4,y,-z+1/4',
        '-x,-y,-z',
        'x+1/4,-y,z+1/4',
        'x,y+1/2,z+1/2',
        '-x+1/4,y+1/2,-z+3/4',
        '-x,-y+1/2,-z+1/2',
        'x+1/4,-y+1/2,z+3/4',
        'x+1/2,y,z+1/2',
        '-x+3/4,y,-z+3/4',
        '-x+1/2,-y,-z+1/2',
        'x+3/4,-y,z+3/4',
        'x+1/2,y+1/2,z',
        '-x+3/4,y+1/2,-z+1/4',
        '-x+1/2,-y+1/2,-z',
        'x+3/4,-y+1/2,z+1/4',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/4,y,-z+1/4',
        '-x,-y,-z',
        'x+1/4,-y,z+1/4',
    ]
},

{
    number          => 15,
    hall            => '-C 2yc (x+y-16/3*z,-x+y+16/3*z,1/3*z)',
    schoenflies     => 'C2h^6',
    hermann_mauguin => 'R 1 2/c 1',
    universal_h_m   => 'R 1 2/c 1',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        'y,x,-z+1/2',
        'x+2/3,y+1/3,z+1/3',
        'y+2/3,x+1/3,-z+5/6',
        'x+1/3,y+2/3,z+2/3',
        'y+1/3,x+2/3,-z+1/6',
        '-x,-y,-z',
        '-y,-x,z+1/2',
        '-x+2/3,-y+1/3,-z+1/3',
        '-y+2/3,-x+1/3,z+5/6',
        '-x+1/3,-y+2/3,-z+2/3',
        '-y+1/3,-x+2/3,z+1/6',
    ],
    ncsym => [
        'x,y,z',
        'y,x,-z+1/2',
        ## 'x+2/3,y+1/3,z+1/3',
        ## 'y+2/3,x+1/3,-z+5/6',
        ## 'x+1/3,y+2/3,z+2/3',
        ## 'y+1/3,x+2/3,-z+1/6',
        '-x,-y,-z',
        '-y,-x,z+1/2',
        ## '-x+2/3,-y+1/3,-z+1/3',
        ## '-y+2/3,-x+1/3,z+5/6',
        ## '-x+1/3,-y+2/3,-z+2/3',
        ## '-y+1/3,-x+2/3,z+1/6',
    ]
},

{
    number          => 19,
    hall            => 'P 2ac 2ab (x,y,z+1/4)',
    schoenflies     => 'D2^4',
    hermann_mauguin => 'P 21 21 21 (origin shift x,y,z+1/4)',
    universal_h_m   => 'P 21 21 21 (origin shift x,y,z+1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,-y+1/2,-z+1/2',
        '-x,y+1/2,-z',
        '-x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,-y+1/2,-z+1/2',
        '-x,y+1/2,-z',
        '-x+1/2,-y,z+1/2',
    ]
},

#
# A non-standard 'B 21' setting used in the M. A. Siegler et
# al. papers in the Acta Cryst. B vol. 64 issue 6, 2008, p.725
# (bs5068) and p.738 (bs5069).
#
# Hall symbol taken as determined by the CCTBX Web service
# (http://cci.lbl.gov/cctbx/cctbx_web.cgi) on 2009.03.28
#
# Schoenflies symbol taken from the space group 4 entries in this file.
#
# Hermann-Mauguin symbol taken from the M. A. Siegler's bs5068 and
# bs5069 papers' CIFs.
#
# The space group symbol used in M. A. Siegler et al. was 'B 21', but
# we use explicit axis symbol 'B 1 21 1', derived from symmetry
# operators (S.G.). The short form 'B 21' along with the corresponding
# long form 'B 1 21 1' will be documented in the SpacegroupNames.pm
# tables.
#

{
    number          => 4,
    hall            => 'P 2yb (1/2*x,y,-1/2*x+z)',
    schoenflies     => 'C2^2',
    hermann_mauguin => 'B 1 21 1',
    universal_h_m   => 'B 1 21 1',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',                # unity operator
        '-x,y+1/2,-z',          # 21 axis along b
        'x+1/2,y,z+1/2',        # face centering in B
        '-x+1/2,y+1/2,-z+1/2'   # 21 axis with the B-centering
    ],
    ncsym => [
        'x,y,z',                # unity operator
        '-x,y+1/2,-z',          # 21 axis along b
    ]
},

{
    number          => 11,
    hall            => '-P 2yb (1/2*x,y,-1/2*x+z)',
    schoenflies     => 'C2h^2',
    hermann_mauguin => 'B 1 21/m 1',
    universal_h_m   => 'B 1 21/m 1',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'x,-y+1/2,z',
        'x+1/2,y,z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-x+1/2,-y,-z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'x,-y+1/2,z',
    ]
},

{
    number          => 14,
    hall            => '-P 2ybc (x+1/2*z,y,1/2*z)',
    schoenflies     => 'C2h^5',
    hermann_mauguin => 'B 1 21/d 1',
    universal_h_m   => 'B 1 21/d 1',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/4,-y+1/2,z+1/4',
        '-x,-y,-z',
        '-x+1/4,y+1/2,-z+1/4',
        'x+1/2,y,z+1/2',
        '-x+3/4,y+1/2,-z+3/4',
        '-x+1/2,-y,-z+1/2',
        'x+3/4,-y+1/2,z+3/4',
    ],
    ncsym => [
        'x,y,z',
        'x+1/4,-y+1/2,z+1/4',
        '-x,-y,-z',
        '-x+1/4,y+1/2,-z+1/4',
    ]
},

# Extra settings collected by Luca:
{
    number          => 3,
    hall            => 'P 2y (1/2*x,y,-1/2*x+z)',
    schoenflies     => 'C2^1',
    hermann_mauguin => 'P 1 2 1 (2*a+c,b,c)',
    universal_h_m   => 'P 1 2 1 (2*a+c,b,c)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y,-z',
        'x+1/2,y,z+1/2',
        '-x+1/2,y,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,y,-z',
    ]
},

{
    number          => 5,
    hall            => 'C 2y (x-1/2*z,y,1/2*z)',
    schoenflies     => 'C2^3',
    hermann_mauguin => 'C 1 2 1 (a,b,a+2*c)',
    universal_h_m   => 'C 1 2 1 (a,b,a+2*c)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y,-z',
        'x+1/2,y,z+1/2',
        '-x+1/2,y,-z+1/2',
        'x+1/2,y+1/2,z',
        '-x+1/2,y+1/2,-z',
        'x,y+1/2,z+1/2',
        '-x,y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,y,-z',
    ]
},

{
    number          => 3,
    hall            => 'P 2y (-1/2*x+z,1/2*x,y)',
    schoenflies     => 'C2^1',
    hermann_mauguin => 'P 1 2 1 (c,2*a+c,b)',
    universal_h_m   => 'P 1 2 1 (c,2*a+c,b)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x+1/2,y+1/2,z',
        '-x+1/2,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
    ]
},

{
    number          => 5,
    hall            => 'C 2y (1/2*z,x-1/2*z,y)',
    schoenflies     => 'C2^3',
    hermann_mauguin => 'C 1 2 1 (a+2*c,a,b)',
    universal_h_m   => 'C 1 2 1 (a+2*c,a,b)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x+1/2,y+1/2,z',
        '-x+1/2,-y+1/2,z',
        'x,y+1/2,z+1/2',
        '-x,-y+1/2,z+1/2',
        'x+1/2,y,z+1/2',
        '-x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
    ]
},

{
    number          => 5,
    hall            => 'C 2y (z,y+1/4,-x-1/4)',
    schoenflies     => 'C2^3',
    hermann_mauguin => 'C 1 2 1 (c-1/4,b-1/4,-a)',
    universal_h_m   => 'C 1 2 1 (c-1/4,b-1/4,-a)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y,-z+1/2',
        'x,y+1/2,z+1/2',
        '-x,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        '-x,y+1/2,-z',
    ]
},

{
    number          => 5,
    hall            => 'C 2y (x+1/4,y+1/4,z)',
    schoenflies     => 'C2^3',
    hermann_mauguin => 'C 1 2 1 (a-1/4,b-1/4,c)',
    universal_h_m   => 'C 1 2 1 (a-1/4,b-1/4,c)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y,-z',
        'x+1/2,y+1/2,z',
        '-x,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        '-x,y+1/2,-z',
    ]
},

{
    number          => 5,
    hall            => 'C 2y (x+1/4,y+1/4,-x+z-1/4)',
    schoenflies     => 'C2^3',
    hermann_mauguin => 'C 1 2 1 (a+c-1/4,b-1/4,c)',
    universal_h_m   => 'C 1 2 1 (a+c-1/4,b-1/4,c)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y,-z+1/2',
        'x+1/2,y+1/2,z+1/2',
        '-x,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        '-x,y+1/2,-z',
    ]
},

{
    number          => 5,
    hall            => 'C 2y (x-1/2*z+1/4,y+1/4,1/2*z)',
    schoenflies     => 'C2^3',
    hermann_mauguin => 'C 1 2 1 (a-1/4,b-1/4,a+2*c)',
    universal_h_m   => 'C 1 2 1 (a-1/4,b-1/4,a+2*c)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y,-z',
        'x+1/2,y,z+1/2',
        '-x,y,-z+1/2',
        'x+1/2,y+1/2,z',
        '-x,y+1/2,-z',
        'x,y+1/2,z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,y+1/2,-z',
    ]
},

{
    number          => 5,
    hall            => 'C 2y (z,x+1/4,y+1/4)',
    schoenflies     => 'C2^3',
    hermann_mauguin => 'C 1 2 1 (c-1/4,a-1/4,b)',
    universal_h_m   => 'C 1 2 1 (c-1/4,a-1/4,b)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x,y+1/2,z+1/2',
        '-x,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
    ]
},

{
    number          => 5,
    hall            => 'C 2y (-x-1/4,z,y+1/4)',
    schoenflies     => 'C2^3',
    hermann_mauguin => 'C 1 2 1 (-a-1/4,c-1/4,b)',
    universal_h_m   => 'C 1 2 1 (-a-1/4,c-1/4,b)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x+1/2,y,z+1/2',
        '-x,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
    ]
},

{
    number          => 4,
    hall            => 'P 2yb (-1/2*x+z,1/2*x,y)',
    schoenflies     => 'C2^2',
    hermann_mauguin => 'P 1 21 1 (c,2*a+c,b)',
    universal_h_m   => 'P 1 21 1 (c,2*a+c,b)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        '-x,-y,z+1/2',
        'x+1/2,y+1/2,z',
        '-x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
    ]
},

{
    number          => 5,
    hall            => 'C 2y (-x+z-1/4,x+1/4,y+1/4)',
    schoenflies     => 'C2^3',
    hermann_mauguin => 'C 1 2 1 (c-1/4,a+c-1/4,b)',
    universal_h_m   => 'C 1 2 1 (c-1/4,a+c-1/4,b)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x+1/2,y+1/2,z+1/2',
        '-x,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
    ]
},

{
    number          => 5,
    hall            => 'C 2y (1/2*z,x-1/2*z+1/4,y+1/4)',
    schoenflies     => 'C2^3',
    hermann_mauguin => 'C 1 2 1 (a+2*c-1/4,a-1/4,b)',
    universal_h_m   => 'C 1 2 1 (a+2*c-1/4,a-1/4,b)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x+1/2,y+1/2,z',
        '-x+1/2,-y,z',
        'x,y+1/2,z+1/2',
        '-x,-y,z+1/2',
        'x+1/2,y,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
    ]
},

{
    number          => 6,
    hall            => 'P -2y (1/2*x,y,-1/2*x+z)',
    schoenflies     => 'Cs^1',
    hermann_mauguin => 'P 1 m 1 (2*a+c,b,c)',
    universal_h_m   => 'P 1 m 1 (2*a+c,b,c)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,-y,z',
        'x+1/2,y,z+1/2',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,-y,z',
    ]
},

{
    number          => 8,
    hall            => 'C -2y (x-1/2*z,y,1/2*z)',
    schoenflies     => 'Cs^3',
    hermann_mauguin => 'C 1 m 1 (a,b,a+2*c)',
    universal_h_m   => 'C 1 m 1 (a,b,a+2*c)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,-y,z',
        'x+1/2,y,z+1/2',
        'x+1/2,-y,z+1/2',
        'x+1/2,y+1/2,z',
        'x+1/2,-y+1/2,z',
        'x,y+1/2,z+1/2',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,-y,z',
    ]
},

{
    number          => 6,
    hall            => 'P -2y (-1/2*x+z,1/2*x,y)',
    schoenflies     => 'Cs^1',
    hermann_mauguin => 'P 1 m 1 (c,2*a+c,b)',
    universal_h_m   => 'P 1 m 1 (c,2*a+c,b)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        'x,y,-z',
        'x+1/2,y+1/2,z',
        'x+1/2,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        'x,y,-z',
    ]
},

{
    number          => 8,
    hall            => 'C -2y (1/2*z,x-1/2*z,y)',
    schoenflies     => 'Cs^3',
    hermann_mauguin => 'C 1 m 1 (a+2*c,a,b)',
    universal_h_m   => 'C 1 m 1 (a+2*c,a,b)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        'x,y,-z',
        'x+1/2,y+1/2,z',
        'x+1/2,y+1/2,-z',
        'x,y+1/2,z+1/2',
        'x,y+1/2,-z+1/2',
        'x+1/2,y,z+1/2',
        'x+1/2,y,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,y,-z',
    ]
},

{
    number          => 6,
    hall            => 'P -2y (y,-1/2*x+z,1/2*x)',
    schoenflies     => 'Cs^1',
    hermann_mauguin => 'P 1 m 1 (b,c,2*a+c)',
    universal_h_m   => 'P 1 m 1 (b,c,2*a+c)',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y,z',
        'x,y+1/2,z+1/2',
        '-x,y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,y,z',
    ]
},

{
    number          => 8,
    hall            => 'C -2y (y,1/2*z,x-1/2*z)',
    schoenflies     => 'Cs^3',
    hermann_mauguin => 'C 1 m 1 (b,a+2*c,a)',
    universal_h_m   => 'C 1 m 1 (b,a+2*c,a)',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y,z',
        'x,y+1/2,z+1/2',
        '-x,y+1/2,z+1/2',
        'x+1/2,y,z+1/2',
        '-x+1/2,y,z+1/2',
        'x+1/2,y+1/2,z',
        '-x+1/2,y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,y,z',
    ]
},

{
    number          => 8,
    hall            => 'C -2y (z,y+1/4,-x-1/4)',
    schoenflies     => 'Cs^3',
    hermann_mauguin => 'C 1 m 1 (c-1/4,b-1/4,-a)',
    universal_h_m   => 'C 1 m 1 (c-1/4,b-1/4,-a)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,-y+1/2,z',
        'x,y+1/2,z+1/2',
        'x,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,-y,z+1/2',
    ]
},

{
    number          => 7,
    hall            => 'P -2yc (1/2*x,y,-1/2*x+z)',
    schoenflies     => 'Cs^2',
    hermann_mauguin => 'P 1 c 1 (2*a+c,b,c)',
    universal_h_m   => 'P 1 c 1 (2*a+c,b,c)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,-y,z+1/2',
        'x+1/2,y,z+1/2',
        'x+1/2,-y,z',
    ],
    ncsym => [
        'x,y,z',
        'x,-y,z+1/2',
    ]
},

{
    number          => 8,
    hall            => 'C -2y (x-1/2*z+1/4,y+1/4,1/2*z)',
    schoenflies     => 'Cs^3',
    hermann_mauguin => 'C 1 m 1 (a-1/4,b-1/4,a+2*c)',
    universal_h_m   => 'C 1 m 1 (a-1/4,b-1/4,a+2*c)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,-y+1/2,z',
        'x+1/2,y,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        'x+1/2,y+1/2,z',
        'x+1/2,-y,z',
        'x,y+1/2,z+1/2',
        'x,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,-y,z+1/2',
    ]
},

{
    number          => 8,
    hall            => 'C -2y (x+1/4,y+1/4,-x+z-1/4)',
    schoenflies     => 'Cs^3',
    hermann_mauguin => 'C 1 m 1 (a+c-1/4,b-1/4,c)',
    universal_h_m   => 'C 1 m 1 (a+c-1/4,b-1/4,c)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,-y+1/2,z',
        'x+1/2,y+1/2,z+1/2',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,-y,z+1/2',
    ]
},

{
    number          => 8,
    hall            => 'C -2y (x+1/4,y+1/4,z)',
    schoenflies     => 'Cs^3',
    hermann_mauguin => 'C 1 m 1 (a-1/4,b-1/4,c)',
    universal_h_m   => 'C 1 m 1 (a-1/4,b-1/4,c)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,-y+1/2,z',
        'x+1/2,y+1/2,z',
        'x+1/2,-y,z',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,-y,z',
    ]
},

{
    number          => 8,
    hall            => 'C -2y (-x-1/4,z,y+1/4)',
    schoenflies     => 'Cs^3',
    hermann_mauguin => 'C 1 m 1 (-a-1/4,c-1/4,b)',
    universal_h_m   => 'C 1 m 1 (-a-1/4,c-1/4,b)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        'x,y,-z+1/2',
        'x+1/2,y,z+1/2',
        'x+1/2,y,-z',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y,-z',
    ]
},

{
    number          => 7,
    hall            => 'P -2yc (-1/2*x+z,1/2*x,y)',
    schoenflies     => 'Cs^2',
    hermann_mauguin => 'P 1 c 1 (c,2*a+c,b)',
    universal_h_m   => 'P 1 c 1 (c,2*a+c,b)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        'x+1/2,y,-z',
        'x+1/2,y+1/2,z',
        'x,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y,-z',
    ]
},

{
    number          => 8,
    hall            => 'C -2y (1/2*z,x-1/2*z+1/4,y+1/4)',
    schoenflies     => 'Cs^3',
    hermann_mauguin => 'C 1 m 1 (a+2*c-1/4,a-1/4,b)',
    universal_h_m   => 'C 1 m 1 (a+2*c-1/4,a-1/4,b)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        'x,y,-z+1/2',
        'x+1/2,y+1/2,z',
        'x+1/2,y+1/2,-z+1/2',
        'x,y+1/2,z+1/2',
        'x,y+1/2,-z',
        'x+1/2,y,z+1/2',
        'x+1/2,y,-z',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y,-z',
    ]
},

{
    number          => 8,
    hall            => 'C -2y (-x+z-1/4,x+1/4,y+1/4)',
    schoenflies     => 'Cs^3',
    hermann_mauguin => 'C 1 m 1 (c-1/4,a+c-1/4,b)',
    universal_h_m   => 'C 1 m 1 (c-1/4,a+c-1/4,b)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        'x,y,-z+1/2',
        'x+1/2,y+1/2,z+1/2',
        'x+1/2,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y+1/2,-z',
    ]
},

{
    number          => 8,
    hall            => 'C -2y (z,x+1/4,y+1/4)',
    schoenflies     => 'Cs^3',
    hermann_mauguin => 'C 1 m 1 (c-1/4,a-1/4,b)',
    universal_h_m   => 'C 1 m 1 (c-1/4,a-1/4,b)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        'x,y,-z+1/2',
        'x,y+1/2,z+1/2',
        'x,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        'x,y+1/2,-z',
    ]
},

{
    number          => 7,
    hall            => 'P -2yc (y,-1/2*x+z,1/2*x)',
    schoenflies     => 'Cs^2',
    hermann_mauguin => 'P 1 c 1 (b,c,2*a+c)',
    universal_h_m   => 'P 1 c 1 (b,c,2*a+c)',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y+1/2,z',
        'x,y+1/2,z+1/2',
        '-x,y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,y+1/2,z',
    ]
},

{
    number          => 8,
    hall            => 'C -2y (y+1/4,-x-1/4,z)',
    schoenflies     => 'Cs^3',
    hermann_mauguin => 'C 1 m 1 (b-1/4,-a-1/4,c)',
    universal_h_m   => 'C 1 m 1 (b-1/4,-a-1/4,c)',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y,z',
        'x+1/2,y+1/2,z',
        '-x,y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,y+1/2,z',
    ]
},

{
    number          => 8,
    hall            => 'C -2y (y+1/4,1/2*z,x-1/2*z+1/4)',
    schoenflies     => 'Cs^3',
    hermann_mauguin => 'C 1 m 1 (b-1/4,a+2*c-1/4,a)',
    universal_h_m   => 'C 1 m 1 (b-1/4,a+2*c-1/4,a)',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y,z',
        'x,y+1/2,z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,y,z+1/2',
        '-x,y,z+1/2',
        'x+1/2,y+1/2,z',
        '-x,y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,y+1/2,z',
    ]
},

{
    number          => 8,
    hall            => 'C -2y (y+1/4,-x+z-1/4,x+1/4)',
    schoenflies     => 'Cs^3',
    hermann_mauguin => 'C 1 m 1 (b-1/4,c-1/4,a+c)',
    universal_h_m   => 'C 1 m 1 (b-1/4,c-1/4,a+c)',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y,z',
        'x+1/2,y+1/2,z+1/2',
        '-x,y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,y+1/2,z+1/2',
    ]
},

{
    number          => 8,
    hall            => 'C -2y (y+1/4,z,x+1/4)',
    schoenflies     => 'Cs^3',
    hermann_mauguin => 'C 1 m 1 (b-1/4,c-1/4,a)',
    universal_h_m   => 'C 1 m 1 (b-1/4,c-1/4,a)',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y,z',
        'x+1/2,y,z+1/2',
        '-x,y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,y,z+1/2',
    ]
},

{
    number          => 10,
    hall            => '-P 2y (1/2*x,y,-1/2*x+z)',
    schoenflies     => 'C2h^1',
    hermann_mauguin => 'P 1 2/m 1 (2*a+c,b,c)',
    universal_h_m   => 'P 1 2/m 1 (2*a+c,b,c)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y,-z',
        '-x,-y,-z',
        'x,-y,z',
        'x+1/2,y,z+1/2',
        '-x+1/2,y,-z+1/2',
        '-x+1/2,-y,-z+1/2',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,y,-z',
        '-x,-y,-z',
        'x,-y,z',
    ]
},

{
    number          => 12,
    hall            => '-C 2y (x-1/2*z,y,1/2*z)',
    schoenflies     => 'C2h^3',
    hermann_mauguin => 'C 1 2/m 1 (a,b,a+2*c)',
    universal_h_m   => 'C 1 2/m 1 (a,b,a+2*c)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y,-z',
        '-x,-y,-z',
        'x,-y,z',
        'x+1/2,y,z+1/2',
        '-x+1/2,y,-z+1/2',
        '-x+1/2,-y,-z+1/2',
        'x+1/2,-y,z+1/2',
        'x+1/2,y+1/2,z',
        '-x+1/2,y+1/2,-z',
        '-x+1/2,-y+1/2,-z',
        'x+1/2,-y+1/2,z',
        'x,y+1/2,z+1/2',
        '-x,y+1/2,-z+1/2',
        '-x,-y+1/2,-z+1/2',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,y,-z',
        '-x,-y,-z',
        'x,-y,z',
    ]
},

{
    number          => 10,
    hall            => '-P 2y (-1/2*x+z,1/2*x,y)',
    schoenflies     => 'C2h^1',
    hermann_mauguin => 'P 1 2/m 1 (c,2*a+c,b)',
    universal_h_m   => 'P 1 2/m 1 (c,2*a+c,b)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        '-x,-y,-z',
        'x,y,-z',
        'x+1/2,y+1/2,z',
        '-x+1/2,-y+1/2,z',
        '-x+1/2,-y+1/2,-z',
        'x+1/2,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        '-x,-y,-z',
        'x,y,-z',
    ]
},

{
    number          => 12,
    hall            => '-C 2y (1/2*z,x-1/2*z,y)',
    schoenflies     => 'C2h^3',
    hermann_mauguin => 'C 1 2/m 1 (a+2*c,a,b)',
    universal_h_m   => 'C 1 2/m 1 (a+2*c,a,b)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        '-x,-y,-z',
        'x,y,-z',
        'x+1/2,y+1/2,z',
        '-x+1/2,-y+1/2,z',
        '-x+1/2,-y+1/2,-z',
        'x+1/2,y+1/2,-z',
        'x,y+1/2,z+1/2',
        '-x,-y+1/2,z+1/2',
        '-x,-y+1/2,-z+1/2',
        'x,y+1/2,-z+1/2',
        'x+1/2,y,z+1/2',
        '-x+1/2,-y,z+1/2',
        '-x+1/2,-y,-z+1/2',
        'x+1/2,y,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        '-x,-y,-z',
        'x,y,-z',
    ]
},

{
    number          => 10,
    hall            => '-P 2y (y,-1/2*x+z,1/2*x)',
    schoenflies     => 'C2h^1',
    hermann_mauguin => 'P 1 2/m 1 (b,c,2*a+c)',
    universal_h_m   => 'P 1 2/m 1 (b,c,2*a+c)',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,-y,-z',
        '-x,-y,-z',
        '-x,y,z',
        'x,y+1/2,z+1/2',
        'x,-y+1/2,-z+1/2',
        '-x,-y+1/2,-z+1/2',
        '-x,y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,-y,-z',
        '-x,-y,-z',
        '-x,y,z',
    ]
},

{
    number          => 12,
    hall            => '-C 2y (y,1/2*z,x-1/2*z)',
    schoenflies     => 'C2h^3',
    hermann_mauguin => 'C 1 2/m 1 (b,a+2*c,a)',
    universal_h_m   => 'C 1 2/m 1 (b,a+2*c,a)',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,-y,-z',
        '-x,-y,-z',
        '-x,y,z',
        'x,y+1/2,z+1/2',
        'x,-y+1/2,-z+1/2',
        '-x,-y+1/2,-z+1/2',
        '-x,y+1/2,z+1/2',
        'x+1/2,y,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x+1/2,-y,-z+1/2',
        '-x+1/2,y,z+1/2',
        'x+1/2,y+1/2,z',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,-y+1/2,-z',
        '-x+1/2,y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        'x,-y,-z',
        '-x,-y,-z',
        '-x,y,z',
    ]
},

{
    number          => 12,
    hall            => '-C 2y (z,y-1/4,-x-1/4)',
    schoenflies     => 'C2h^3',
    hermann_mauguin => 'C 1 2/m 1 (c-1/4,b+1/4,-a)',
    universal_h_m   => 'C 1 2/m 1 (c-1/4,b+1/4,-a)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y,-z+1/2',
        '-x,-y+1/2,-z+1/2',
        'x,-y+1/2,z',
        'x,y+1/2,z+1/2',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'x,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'x,-y+1/2,z',
    ]
},

{
    number          => 12,
    hall            => '-C 2y (x+1/4,y-1/4,z)',
    schoenflies     => 'C2h^3',
    hermann_mauguin => 'C 1 2/m 1 (a-1/4,b+1/4,c)',
    universal_h_m   => 'C 1 2/m 1 (a-1/4,b+1/4,c)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y,-z',
        '-x+1/2,-y+1/2,-z',
        'x,-y+1/2,z',
        'x+1/2,y+1/2,z',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'x+1/2,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'x,-y+1/2,z',
    ]
},

{
    number          => 12,
    hall            => '-C 2y (x+1/4,y-1/4,-x+z-1/4)',
    schoenflies     => 'C2h^3',
    hermann_mauguin => 'C 1 2/m 1 (a+c-1/4,b+1/4,c)',
    universal_h_m   => 'C 1 2/m 1 (a+c-1/4,b+1/4,c)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y,-z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        'x,-y+1/2,z',
        'x+1/2,y+1/2,z+1/2',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'x,-y+1/2,z',
    ]
},

{
    number          => 12,
    hall            => '-C 2y (x-1/2*z+1/4,y-1/4,1/2*z)',
    schoenflies     => 'C2h^3',
    hermann_mauguin => 'C 1 2/m 1 (a-1/4,b+1/4,a+2*c)',
    universal_h_m   => 'C 1 2/m 1 (a-1/4,b+1/4,a+2*c)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y,-z',
        '-x+1/2,-y+1/2,-z',
        'x,-y+1/2,z',
        'x+1/2,y,z+1/2',
        '-x,y,-z+1/2',
        '-x,-y+1/2,-z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        'x+1/2,y+1/2,z',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'x+1/2,-y,z',
        'x,y+1/2,z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-x+1/2,-y,-z+1/2',
        'x,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'x,-y+1/2,z',
    ]
},

{
    number          => 12,
    hall            => '-C 2y (z,x+1/4,y-1/4)',
    schoenflies     => 'C2h^3',
    hermann_mauguin => 'C 1 2/m 1 (c-1/4,a+1/4,b)',
    universal_h_m   => 'C 1 2/m 1 (c-1/4,a+1/4,b)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z',
        '-x,-y+1/2,-z+1/2',
        'x,y,-z+1/2',
        'x,y+1/2,z+1/2',
        '-x,-y,z+1/2',
        '-x,-y,-z',
        'x,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
        '-x,-y,-z',
        'x,y,-z+1/2',
    ]
},

{
    number          => 12,
    hall            => '-C 2y (-x-1/4,z,y-1/4)',
    schoenflies     => 'C2h^3',
    hermann_mauguin => 'C 1 2/m 1 (-a-1/4,c+1/4,b)',
    universal_h_m   => 'C 1 2/m 1 (-a-1/4,c+1/4,b)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z',
        '-x+1/2,-y,-z+1/2',
        'x,y,-z+1/2',
        'x+1/2,y,z+1/2',
        '-x,-y,z+1/2',
        '-x,-y,-z',
        'x+1/2,y,-z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
        '-x,-y,-z',
        'x,y,-z+1/2',
    ]
},

{
    number          => 11,
    hall            => '-P 2yb (-1/2*x+z,1/2*x,y)',
    schoenflies     => 'C2h^2',
    hermann_mauguin => 'P 1 21/m 1 (c,2*a+c,b)',
    universal_h_m   => 'P 1 21/m 1 (c,2*a+c,b)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        '-x,-y,z+1/2',
        '-x,-y,-z',
        'x,y,-z+1/2',
        'x+1/2,y+1/2,z',
        '-x+1/2,-y+1/2,z+1/2',
        '-x+1/2,-y+1/2,-z',
        'x+1/2,y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
        '-x,-y,-z',
        'x,y,-z+1/2',
    ]
},

{
    number          => 12,
    hall            => '-C 2y (-x+z-1/4,x+1/4,y-1/4)',
    schoenflies     => 'C2h^3',
    hermann_mauguin => 'C 1 2/m 1 (c-1/4,a+c+1/4,b)',
    universal_h_m   => 'C 1 2/m 1 (c-1/4,a+c+1/4,b)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        '-x+1/2,-y+1/2,-z+1/2',
        'x,y,-z+1/2',
        'x+1/2,y+1/2,z+1/2',
        '-x,-y,z+1/2',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
        '-x,-y,-z',
        'x,y,-z+1/2',
    ]
},

{
    number          => 12,
    hall            => '-C 2y (1/2*z,x-1/2*z+1/4,y-1/4)',
    schoenflies     => 'C2h^3',
    hermann_mauguin => 'C 1 2/m 1 (a+2*c-1/4,a+1/4,b)',
    universal_h_m   => 'C 1 2/m 1 (a+2*c-1/4,a+1/4,b)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z',
        '-x,-y+1/2,-z+1/2',
        'x,y,-z+1/2',
        'x+1/2,y+1/2,z',
        '-x+1/2,-y,z',
        '-x+1/2,-y,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        'x,y+1/2,z+1/2',
        '-x,-y,z+1/2',
        '-x,-y,-z',
        'x,y+1/2,-z',
        'x+1/2,y,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        '-x+1/2,-y+1/2,-z',
        'x+1/2,y,-z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
        '-x,-y,-z',
        'x,y,-z+1/2',
    ]
},

{
    number          => 11,
    hall            => '-P 2yb (y,-1/2*x+z,1/2*x)',
    schoenflies     => 'C2h^2',
    hermann_mauguin => 'P 1 21/m 1 (b,c,2*a+c)',
    universal_h_m   => 'P 1 21/m 1 (b,c,2*a+c)',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,-y,-z',
        '-x,-y,-z',
        '-x+1/2,y,z',
        'x,y+1/2,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        '-x,-y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,-y,-z',
        '-x,-y,-z',
        '-x+1/2,y,z',
    ]
},

{
    number          => 12,
    hall            => '-C 2y (y-1/4,z,x+1/4)',
    schoenflies     => 'C2h^3',
    hermann_mauguin => 'C 1 2/m 1 (b-1/4,c+1/4,a)',
    universal_h_m   => 'C 1 2/m 1 (b-1/4,c+1/4,a)',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,-y,-z+1/2',
        '-x+1/2,-y,-z+1/2',
        '-x+1/2,y,z',
        'x+1/2,y,z+1/2',
        'x+1/2,-y,-z',
        '-x,-y,-z',
        '-x,y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,-y,-z',
        '-x,-y,-z',
        '-x+1/2,y,z',
    ]
},

{
    number          => 12,
    hall            => '-C 2y (y-1/4,-x-1/4,z)',
    schoenflies     => 'C2h^3',
    hermann_mauguin => 'C 1 2/m 1 (b-1/4,-a+1/4,c)',
    universal_h_m   => 'C 1 2/m 1 (b-1/4,-a+1/4,c)',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,-y+1/2,-z',
        '-x+1/2,-y+1/2,-z',
        '-x+1/2,y,z',
        'x+1/2,y+1/2,z',
        'x+1/2,-y,-z',
        '-x,-y,-z',
        '-x,y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,-y,-z',
        '-x,-y,-z',
        '-x+1/2,y,z',
    ]
},

{
    number          => 12,
    hall            => '-C 2y (y-1/4,-x+z-1/4,x+1/4)',
    schoenflies     => 'C2h^3',
    hermann_mauguin => 'C 1 2/m 1 (b-1/4,c+1/4,a+c)',
    universal_h_m   => 'C 1 2/m 1 (b-1/4,c+1/4,a+c)',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,-y+1/2,-z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        '-x+1/2,y,z',
        'x+1/2,y+1/2,z+1/2',
        'x+1/2,-y,-z',
        '-x,-y,-z',
        '-x,y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,-y,-z',
        '-x,-y,-z',
        '-x+1/2,y,z',
    ]
},

{
    number          => 12,
    hall            => '-C 2y (y-1/4,1/2*z,x-1/2*z+1/4)',
    schoenflies     => 'C2h^3',
    hermann_mauguin => 'C 1 2/m 1 (b-1/4,a+2*c+1/4,a)',
    universal_h_m   => 'C 1 2/m 1 (b-1/4,a+2*c+1/4,a)',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,-y,-z+1/2',
        '-x+1/2,-y,-z+1/2',
        '-x+1/2,y,z',
        'x,y+1/2,z+1/2',
        'x,-y+1/2,-z',
        '-x+1/2,-y+1/2,-z',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,y,z+1/2',
        'x+1/2,-y,-z',
        '-x,-y,-z',
        '-x,y,z+1/2',
        'x+1/2,y+1/2,z',
        'x+1/2,-y+1/2,-z+1/2',
        '-x,-y+1/2,-z+1/2',
        '-x,y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,-y,-z',
        '-x,-y,-z',
        '-x+1/2,y,z',
    ]
},

{
    number          => 13,
    hall            => '-P 2yc (1/2*x,y,-1/2*x+z)',
    schoenflies     => 'C2h^4',
    hermann_mauguin => 'P 1 2/c 1 (2*a+c,b,c)',
    universal_h_m   => 'P 1 2/c 1 (2*a+c,b,c)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'x,-y,z+1/2',
        'x+1/2,y,z+1/2',
        '-x+1/2,y,-z',
        '-x+1/2,-y,-z+1/2',
        'x+1/2,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'x,-y,z+1/2',
    ]
},

{
    number          => 13,
    hall            => '-P 2yc (-1/2*x+z,1/2*x,y)',
    schoenflies     => 'C2h^4',
    hermann_mauguin => 'P 1 2/c 1 (c,2*a+c,b)',
    universal_h_m   => 'P 1 2/c 1 (c,2*a+c,b)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z',
        '-x,-y,-z',
        'x+1/2,y,-z',
        'x+1/2,y+1/2,z',
        '-x,-y+1/2,z',
        '-x+1/2,-y+1/2,-z',
        'x,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z',
        '-x,-y,-z',
        'x+1/2,y,-z',
    ]
},

{
    number          => 13,
    hall            => '-P 2yc (y,-1/2*x+z,1/2*x)',
    schoenflies     => 'C2h^4',
    hermann_mauguin => 'P 1 2/c 1 (b,c,2*a+c)',
    universal_h_m   => 'P 1 2/c 1 (b,c,2*a+c)',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,-y+1/2,-z',
        '-x,-y,-z',
        '-x,y+1/2,z',
        'x,y+1/2,z+1/2',
        'x,-y,-z+1/2',
        '-x,-y+1/2,-z+1/2',
        '-x,y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,-y+1/2,-z',
        '-x,-y,-z',
        '-x,y+1/2,z',
    ]
},

{
    number          => 14,
    hall            => '-P 2ybc (1/2*x,y,-1/2*x+z)',
    schoenflies     => 'C2h^5',
    hermann_mauguin => 'P 1 21/c 1 (2*a+c,b,c)',
    universal_h_m   => 'P 1 21/c 1 (2*a+c,b,c)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x,-y+1/2,z+1/2',
        'x+1/2,y,z+1/2',
        '-x+1/2,y+1/2,-z',
        '-x+1/2,-y,-z+1/2',
        'x+1/2,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x,-y+1/2,z+1/2',
    ]
},

{
    number          => 14,
    hall            => '-P 2ybc (-1/2*x+z,1/2*x,y)',
    schoenflies     => 'C2h^5',
    hermann_mauguin => 'P 1 21/c 1 (c,2*a+c,b)',
    universal_h_m   => 'P 1 21/c 1 (c,2*a+c,b)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $beta == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        '-x,-y,-z',
        'x+1/2,y,-z+1/2',
        'x+1/2,y+1/2,z',
        '-x,-y+1/2,z+1/2',
        '-x+1/2,-y+1/2,-z',
        'x,y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        '-x,-y,-z',
        'x+1/2,y,-z+1/2',
    ]
},

{
    number          => 14,
    hall            => '-P 2ybc (y,-1/2*x+z,1/2*x)',
    schoenflies     => 'C2h^5',
    hermann_mauguin => 'P 1 21/c 1 (b,c,2*a+c)',
    universal_h_m   => 'P 1 21/c 1 (b,c,2*a+c)',
    crystal_class   => 'monoclinic',
    constraints     => '$beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,-y+1/2,-z',
        '-x,-y,-z',
        '-x+1/2,y+1/2,z',
        'x,y+1/2,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x,-y+1/2,-z+1/2',
        '-x+1/2,y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,-y+1/2,-z',
        '-x,-y,-z',
        '-x+1/2,y+1/2,z',
    ]
},

{
    number          => 38,
    hall            => 'A 2 -2 (x,y-1/4,z+1/4)',
    schoenflies     => 'C2v^14',
    hermann_mauguin => 'A m m 2 (a,b+1/4,c-1/4)',
    universal_h_m   => 'A m m 2 (a,b+1/4,c-1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z',
        '-x,y,z',
        'x,-y+1/2,z',
        'x,y+1/2,z+1/2',
        '-x,-y,z+1/2',
        '-x,y+1/2,z+1/2',
        'x,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
        '-x,y,z',
        'x,-y,z+1/2',
    ]
},

{
    number          => 39,
    hall            => 'A 2 -2b (y-1/4,-x,z+1/4)',
    schoenflies     => 'C2v^15',
    hermann_mauguin => 'A e m 2 (b,-a+1/4,c-1/4)',
    universal_h_m   => 'A e m 2 (b,-a+1/4,c-1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x+1/2,-y,z',
        '-x,y,z',
        'x+1/2,y,z+1/2',
        '-x,-y,z+1/2',
        'x,-y,z+1/2',
        '-x+1/2,y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
        '-x,y,z',
        'x,-y,z+1/2',
    ]
},

{
    number          => 46,
    hall            => 'I 2 -2a (x+1/4,y+1/4,z-1/4)',
    schoenflies     => 'C2v^22',
    hermann_mauguin => 'I m a 2 (a-1/4,b-1/4,c+1/4)',
    universal_h_m   => 'I m a 2 (a-1/4,b-1/4,c+1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        '-x,y,z',
        'x+1/2,-y+1/2,z',
        'x+1/2,y+1/2,z+1/2',
        '-x,-y,z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
        '-x,y,z',
        'x,-y,z+1/2',
    ]
},

{
    number          => 42,
    hall            => 'F 2 -2 (x,y+1/4,z+1/4)',
    schoenflies     => 'C2v^18',
    hermann_mauguin => 'F m m 2 (a,b-1/4,c-1/4)',
    universal_h_m   => 'F m m 2 (a,b-1/4,c-1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z',
        '-x,y,z',
        'x,-y+1/2,z',
        'x,y+1/2,z+1/2',
        '-x,-y,z+1/2',
        '-x,y+1/2,z+1/2',
        'x,-y,z+1/2',
        'x+1/2,y,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        '-x+1/2,y,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        'x+1/2,y+1/2,z',
        '-x+1/2,-y,z',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
        '-x,y,z',
        'x,-y,z+1/2',
    ]
},

{
    number          => 39,
    hall            => 'A 2 -2b (x,y-1/4,z+1/4)',
    schoenflies     => 'C2v^15',
    hermann_mauguin => 'A e m 2 (a,b+1/4,c-1/4)',
    universal_h_m   => 'A e m 2 (a,b+1/4,c-1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z',
        '-x,y+1/2,z',
        'x,-y,z',
        'x,y+1/2,z+1/2',
        '-x,-y,z+1/2',
        '-x,y,z+1/2',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
        '-x,y,z+1/2',
        'x,-y,z',
    ]
},

{
    number          => 38,
    hall            => 'A 2 -2 (y-1/4,-x,z+1/4)',
    schoenflies     => 'C2v^14',
    hermann_mauguin => 'A m m 2 (b,-a+1/4,c-1/4)',
    universal_h_m   => 'A m m 2 (b,-a+1/4,c-1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x,-y,z',
        '-x+1/2,y,z',
        'x+1/2,y,z+1/2',
        '-x,-y,z+1/2',
        'x+1/2,-y,z+1/2',
        '-x,y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
        '-x,y,z+1/2',
        'x,-y,z',
    ]
},

{
    number          => 46,
    hall            => 'I 2 -2a (y+1/4,-x-1/4,z-1/4)',
    schoenflies     => 'C2v^22',
    hermann_mauguin => 'I m a 2 (b-1/4,-a-1/4,c+1/4)',
    universal_h_m   => 'I m a 2 (b-1/4,-a-1/4,c+1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x,-y,z',
        '-x+1/2,y+1/2,z',
        'x+1/2,y+1/2,z+1/2',
        '-x,-y,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        '-x,y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
        '-x,y,z+1/2',
        'x,-y,z',
    ]
},

{
    number          => 42,
    hall            => 'F 2 -2 (x-1/4,y,z-1/4)',
    schoenflies     => 'C2v^18',
    hermann_mauguin => 'F m m 2 (a+1/4,b,c+1/4)',
    universal_h_m   => 'F m m 2 (a+1/4,b,c+1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z',
        '-x+1/2,y,z',
        'x,-y,z',
        'x,y+1/2,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x,-y+1/2,z+1/2',
        'x+1/2,y,z+1/2',
        '-x,-y,z+1/2',
        '-x,y,z+1/2',
        'x+1/2,-y,z+1/2',
        'x+1/2,y+1/2,z',
        '-x,-y+1/2,z',
        '-x,y+1/2,z',
        'x+1/2,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
        '-x,y,z+1/2',
        'x,-y,z',
    ]
},

{
    number          => 39,
    hall            => 'A 2 -2b (-x,z+1/4,y-1/4)',
    schoenflies     => 'C2v^15',
    hermann_mauguin => 'A e m 2 (-a,c+1/4,b-1/4)',
    universal_h_m   => 'A e m 2 (-a,c+1/4,b-1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y,-z+1/2',
        '-x,y,z+1/2',
        'x,y,-z',
        'x,y+1/2,z+1/2',
        '-x,y+1/2,-z',
        '-x,y+1/2,z',
        'x,y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,y,-z',
        '-x,y+1/2,z',
        '-x,y+1/2,-z',
    ]
},

{
    number          => 38,
    hall            => 'A 2 -2 (y-1/4,z+1/4,x)',
    schoenflies     => 'C2v^14',
    hermann_mauguin => 'A m m 2 (b,c+1/4,a-1/4)',
    universal_h_m   => 'A m m 2 (b,c+1/4,a-1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y,-z',
        'x,y,-z',
        '-x+1/2,y,z',
        'x+1/2,y+1/2,z',
        '-x,y+1/2,-z',
        'x+1/2,y+1/2,-z',
        '-x,y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        'x,y,-z',
        '-x,y+1/2,z',
        '-x,y+1/2,-z',
    ]
},

{
    number          => 46,
    hall            => 'I 2 -2a (y+1/4,z-1/4,x+1/4)',
    schoenflies     => 'C2v^22',
    hermann_mauguin => 'I m a 2 (b-1/4,c-1/4,a+1/4)',
    universal_h_m   => 'I m a 2 (b-1/4,c-1/4,a+1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y,-z+1/2',
        'x,y,-z',
        '-x+1/2,y,z+1/2',
        'x+1/2,y+1/2,z+1/2',
        '-x,y+1/2,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-x,y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        'x,y,-z',
        '-x,y+1/2,z',
        '-x,y+1/2,-z',
    ]
},

{
    number          => 42,
    hall            => 'F 2 -2 (y+1/4,z+1/4,x)',
    schoenflies     => 'C2v^18',
    hermann_mauguin => 'F m m 2 (b,c-1/4,a-1/4)',
    universal_h_m   => 'F m m 2 (b,c-1/4,a-1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y,-z',
        'x,y,-z',
        '-x+1/2,y,z',
        'x+1/2,y+1/2,z',
        '-x,y+1/2,-z',
        'x+1/2,y+1/2,-z',
        '-x,y+1/2,z',
        'x,y+1/2,z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        'x,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,y,z+1/2',
        '-x,y,-z+1/2',
        'x+1/2,y,-z+1/2',
        '-x,y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,y,-z',
        '-x,y+1/2,z',
        '-x,y+1/2,-z',
    ]
},

{
    number          => 38,
    hall            => 'A 2 -2 (-x,z+1/4,y-1/4)',
    schoenflies     => 'C2v^14',
    hermann_mauguin => 'A m m 2 (-a,c+1/4,b-1/4)',
    universal_h_m   => 'A m m 2 (-a,c+1/4,b-1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y,-z+1/2',
        '-x,y,z',
        'x,y,-z+1/2',
        'x,y+1/2,z+1/2',
        '-x,y+1/2,-z',
        '-x,y+1/2,z+1/2',
        'x,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        'x,y+1/2,-z',
        '-x,y,z',
        '-x,y+1/2,-z',
    ]
},

{
    number          => 39,
    hall            => 'A 2 -2b (y-1/4,z+1/4,x)',
    schoenflies     => 'C2v^15',
    hermann_mauguin => 'A e m 2 (b,c+1/4,a-1/4)',
    universal_h_m   => 'A e m 2 (b,c+1/4,a-1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y,-z',
        'x+1/2,y,-z',
        '-x,y,z',
        'x+1/2,y+1/2,z',
        '-x,y+1/2,-z',
        'x,y+1/2,-z',
        '-x+1/2,y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        'x,y+1/2,-z',
        '-x,y,z',
        '-x,y+1/2,-z',
    ]
},

{
    number          => 46,
    hall            => 'I 2 -2a (-x-1/4,z-1/4,y+1/4)',
    schoenflies     => 'C2v^22',
    hermann_mauguin => 'I m a 2 (-a-1/4,c-1/4,b+1/4)',
    universal_h_m   => 'I m a 2 (-a-1/4,c-1/4,b+1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y,-z+1/2',
        '-x,y,z',
        'x+1/2,y,-z+1/2',
        'x+1/2,y+1/2,z+1/2',
        '-x,y+1/2,-z',
        '-x+1/2,y+1/2,z+1/2',
        'x,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        'x,y+1/2,-z',
        '-x,y,z',
        '-x,y+1/2,-z',
    ]
},

{
    number          => 42,
    hall            => 'F 2 -2 (y,z-1/4,x-1/4)',
    schoenflies     => 'C2v^18',
    hermann_mauguin => 'F m m 2 (b+1/4,c,a+1/4)',
    universal_h_m   => 'F m m 2 (b+1/4,c,a+1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y,-z+1/2',
        'x,y,-z+1/2',
        '-x,y,z',
        'x+1/2,y+1/2,z',
        '-x+1/2,y+1/2,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z',
        'x,y+1/2,z+1/2',
        '-x,y+1/2,-z',
        'x,y+1/2,-z',
        '-x,y+1/2,z+1/2',
        'x+1/2,y,z+1/2',
        '-x+1/2,y,-z',
        'x+1/2,y,-z',
        '-x+1/2,y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,y+1/2,-z',
        '-x,y,z',
        '-x,y+1/2,-z',
    ]
},

{
    number          => 42,
    hall            => 'F 2 -2 (x-1/4,y-1/4,z+1/2)',
    schoenflies     => 'C2v^18',
    hermann_mauguin => 'F m m 2 (a+1/4,b+1/4,c+1/2)',
    universal_h_m   => 'F m m 2 (a+1/4,b+1/4,c+1/2)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        '-x+1/2,y,z',
        'x,-y+1/2,z',
        'x,y+1/2,z+1/2',
        '-x+1/2,-y,z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x,-y,z+1/2',
        'x+1/2,y,z+1/2',
        '-x,-y+1/2,z+1/2',
        '-x,y,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        'x+1/2,y+1/2,z',
        '-x,-y,z',
        '-x,y+1/2,z',
        'x+1/2,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        '-x,y,z+1/2',
        'x,-y,z+1/2',
    ]
},

{
    number          => 42,
    hall            => 'F 2 -2 (y-1/4,z+1/2,x-1/4)',
    schoenflies     => 'C2v^18',
    hermann_mauguin => 'F m m 2 (b+1/4,c+1/4,a+1/2)',
    universal_h_m   => 'F m m 2 (b+1/4,c+1/4,a+1/2)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y,-z+1/2',
        'x,y,-z+1/2',
        '-x+1/2,y,z',
        'x+1/2,y+1/2,z',
        '-x,y+1/2,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-x,y+1/2,z',
        'x,y+1/2,z+1/2',
        '-x+1/2,y+1/2,-z',
        'x,y+1/2,-z',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,y,z+1/2',
        '-x,y,-z',
        'x+1/2,y,-z',
        '-x,y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,y+1/2,-z',
        '-x,y+1/2,z',
        '-x,y,-z',
    ]
},

{
    number          => 35,
    hall            => 'C 2 -2 (x+1/4,y+1/4,z)',
    schoenflies     => 'C2v^11',
    hermann_mauguin => 'C m m 2 (a-1/4,b-1/4,c)',
    universal_h_m   => 'C m m 2 (a-1/4,b-1/4,c)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        '-x+1/2,y,z',
        'x,-y+1/2,z',
        'x+1/2,y+1/2,z',
        '-x,-y,z',
        '-x,y+1/2,z',
        'x+1/2,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        '-x+1/2,y,z',
        'x+1/2,-y,z',
    ]
},

{
    number          => 35,
    hall            => 'C 2 -2 (y+1/4,z,x+1/4)',
    schoenflies     => 'C2v^11',
    hermann_mauguin => 'C m m 2 (b-1/4,c-1/4,a)',
    universal_h_m   => 'C m m 2 (b-1/4,c-1/4,a)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y,-z+1/2',
        'x,y,-z+1/2',
        '-x+1/2,y,z',
        'x+1/2,y,z+1/2',
        '-x,y,-z',
        'x+1/2,y,-z',
        '-x,y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,y,-z+1/2',
        '-x,y,z+1/2',
        '-x,y,-z',
    ]
},

{
    number          => 41,
    hall            => 'A 2 -2ab (x,y-1/4,z+1/4)',
    schoenflies     => 'C2v^17',
    hermann_mauguin => 'A e a 2 (a,b+1/4,c-1/4)',
    universal_h_m   => 'A e a 2 (a,b+1/4,c-1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y,z',
        'x,y+1/2,z+1/2',
        '-x,-y,z+1/2',
        '-x+1/2,y,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
        '-x+1/2,y,z+1/2',
        'x+1/2,-y,z',
    ]
},

{
    number          => 36,
    hall            => 'C 2c -2 (y+1/4,-x-1/4,z)',
    schoenflies     => 'C2v^12',
    hermann_mauguin => 'C m c 21 (b-1/4,-a-1/4,c)',
    universal_h_m   => 'C m c 21 (b-1/4,-a-1/4,c)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z+1/2',
        'x,-y+1/2,z',
        '-x+1/2,y,z+1/2',
        'x+1/2,y+1/2,z',
        '-x,-y,z+1/2',
        'x+1/2,-y,z',
        '-x,y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
        '-x+1/2,y,z+1/2',
        'x+1/2,-y,z',
    ]
},

{
    number          => 45,
    hall            => 'I 2 -2c (x+1/4,y+1/4,z-1/4)',
    schoenflies     => 'C2v^21',
    hermann_mauguin => 'I b a 2 (a-1/4,b-1/4,c+1/4)',
    universal_h_m   => 'I b a 2 (a-1/4,b-1/4,c+1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        '-x+1/2,y,z+1/2',
        'x,-y+1/2,z+1/2',
        'x+1/2,y+1/2,z+1/2',
        '-x,-y,z+1/2',
        '-x,y+1/2,z',
        'x+1/2,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
        '-x+1/2,y,z+1/2',
        'x+1/2,-y,z',
    ]
},

{
    number          => 41,
    hall            => 'A 2 -2ab (y-1/4,-x,z+1/4)',
    schoenflies     => 'C2v^17',
    hermann_mauguin => 'A e a 2 (b,-a+1/4,c-1/4)',
    universal_h_m   => 'A e a 2 (b,-a+1/4,c-1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x+1/2,-y+1/2,z',
        '-x,y+1/2,z',
        'x+1/2,y,z+1/2',
        '-x,-y,z+1/2',
        'x,-y+1/2,z+1/2',
        '-x+1/2,y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
        '-x,y+1/2,z',
        'x,-y+1/2,z+1/2',
    ]
},

{
    number          => 36,
    hall            => 'C 2c -2 (x+1/4,y+1/4,z)',
    schoenflies     => 'C2v^12',
    hermann_mauguin => 'C m c 21 (a-1/4,b-1/4,c)',
    universal_h_m   => 'C m c 21 (a-1/4,b-1/4,c)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z+1/2',
        '-x+1/2,y,z',
        'x,-y+1/2,z+1/2',
        'x+1/2,y+1/2,z',
        '-x,-y,z+1/2',
        '-x,y+1/2,z',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
        '-x,y+1/2,z',
        'x,-y+1/2,z+1/2',
    ]
},

{
    number          => 36,
    hall            => 'C 2c -2 (-x-1/4,z,y+1/4)',
    schoenflies     => 'C2v^12',
    hermann_mauguin => 'C m c 21 (-a-1/4,c-1/4,b)',
    universal_h_m   => 'C m c 21 (-a-1/4,c-1/4,b)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y+1/2,-z+1/2',
        '-x+1/2,y,z',
        'x,y+1/2,-z+1/2',
        'x+1/2,y,z+1/2',
        '-x,y+1/2,-z',
        '-x,y,z+1/2',
        'x+1/2,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        'x,y+1/2,-z+1/2',
        '-x,y,z+1/2',
        '-x,y+1/2,-z',
    ]
},

{
    number          => 41,
    hall            => 'A 2 -2ab (y-1/4,z+1/4,x)',
    schoenflies     => 'C2v^17',
    hermann_mauguin => 'A e a 2 (b,c+1/4,a-1/4)',
    universal_h_m   => 'A e a 2 (b,c+1/4,a-1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y,-z',
        'x+1/2,y,-z+1/2',
        '-x,y,z+1/2',
        'x+1/2,y+1/2,z',
        '-x,y+1/2,-z',
        'x,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,y+1/2,-z+1/2',
        '-x,y,z+1/2',
        '-x,y+1/2,-z',
    ]
},

{
    number          => 45,
    hall            => 'I 2 -2c (y+1/4,z-1/4,x+1/4)',
    schoenflies     => 'C2v^21',
    hermann_mauguin => 'I b a 2 (b-1/4,c-1/4,a+1/4)',
    universal_h_m   => 'I b a 2 (b-1/4,c-1/4,a+1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y,-z+1/2',
        'x,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z',
        'x+1/2,y+1/2,z+1/2',
        '-x,y+1/2,-z',
        'x+1/2,y,-z',
        '-x,y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,y+1/2,-z+1/2',
        '-x,y,z+1/2',
        '-x,y+1/2,-z',
    ]
},

{
    number          => 41,
    hall            => 'A 2 -2ab (-x,z+1/4,y-1/4)',
    schoenflies     => 'C2v^17',
    hermann_mauguin => 'A e a 2 (-a,c+1/4,b-1/4)',
    universal_h_m   => 'A e a 2 (-a,c+1/4,b-1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y,-z+1/2',
        '-x+1/2,y,z+1/2',
        'x+1/2,y,-z',
        'x,y+1/2,z+1/2',
        '-x,y+1/2,-z',
        '-x+1/2,y+1/2,z',
        'x+1/2,y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y,-z',
        '-x+1/2,y+1/2,z',
        '-x,y+1/2,-z',
    ]
},

{
    number          => 36,
    hall            => 'C 2c -2 (y+1/4,z,x+1/4)',
    schoenflies     => 'C2v^12',
    hermann_mauguin => 'C m c 21 (b-1/4,c-1/4,a)',
    universal_h_m   => 'C m c 21 (b-1/4,c-1/4,a)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y+1/2,-z+1/2',
        'x,y,-z+1/2',
        '-x+1/2,y+1/2,z',
        'x+1/2,y,z+1/2',
        '-x,y+1/2,-z',
        'x+1/2,y,-z',
        '-x,y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y,-z',
        '-x+1/2,y+1/2,z',
        '-x,y+1/2,-z',
    ]
},

{
    number          => 37,
    hall            => 'C 2 -2c (x+1/4,y+1/4,z)',
    schoenflies     => 'C2v^13',
    hermann_mauguin => 'C c c 2 (a-1/4,b-1/4,c)',
    universal_h_m   => 'C c c 2 (a-1/4,b-1/4,c)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        '-x+1/2,y,z+1/2',
        'x,-y+1/2,z+1/2',
        'x+1/2,y+1/2,z',
        '-x,-y,z',
        '-x,y+1/2,z+1/2',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        '-x,y+1/2,z+1/2',
        'x,-y+1/2,z+1/2',
    ]
},

{
    number          => 37,
    hall            => 'C 2 -2c (y+1/4,z,x+1/4)',
    schoenflies     => 'C2v^13',
    hermann_mauguin => 'C c c 2 (b-1/4,c-1/4,a)',
    universal_h_m   => 'C c c 2 (b-1/4,c-1/4,a)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y,-z+1/2',
        'x,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z',
        'x+1/2,y,z+1/2',
        '-x,y,-z',
        'x+1/2,y+1/2,-z',
        '-x,y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y+1/2,-z',
        '-x+1/2,y+1/2,z',
        '-x,y,-z',
    ]
},

{
    number          => 40,
    hall            => 'A 2 -2a (x-1/4,y-1/4,z+1/4)',
    schoenflies     => 'C2v^16',
    hermann_mauguin => 'A m a 2 (a+1/4,b+1/4,c-1/4)',
    universal_h_m   => 'A m a 2 (a+1/4,b+1/4,c-1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        '-x,y,z',
        'x+1/2,-y+1/2,z',
        'x,y+1/2,z+1/2',
        '-x+1/2,-y,z+1/2',
        '-x,y+1/2,z+1/2',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        '-x,y,z',
        'x+1/2,-y,z+1/2',
    ]
},

{
    number          => 36,
    hall            => 'C 2c -2 (x,y-1/4,z)',
    schoenflies     => 'C2v^12',
    hermann_mauguin => 'C m c 21 (a,b+1/4,c)',
    universal_h_m   => 'C m c 21 (a,b+1/4,c)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z+1/2',
        '-x,y,z',
        'x,-y+1/2,z+1/2',
        'x+1/2,y+1/2,z',
        '-x+1/2,-y,z+1/2',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        '-x,y,z',
        'x+1/2,-y,z+1/2',
    ]
},

{
    number          => 44,
    hall            => 'I 2 -2 (x,y+1/4,z)',
    schoenflies     => 'C2v^20',
    hermann_mauguin => 'I m m 2 (a,b-1/4,c)',
    universal_h_m   => 'I m m 2 (a,b-1/4,c)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z',
        '-x,y,z',
        'x,-y+1/2,z',
        'x+1/2,y+1/2,z+1/2',
        '-x+1/2,-y,z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        '-x,y,z',
        'x+1/2,-y,z+1/2',
    ]
},

{
    number          => 40,
    hall            => 'A 2 -2a (y-1/4,-x+1/4,z+1/4)',
    schoenflies     => 'C2v^16',
    hermann_mauguin => 'A m a 2 (b+1/4,-a+1/4,c-1/4)',
    universal_h_m   => 'A m a 2 (b+1/4,-a+1/4,c-1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x,-y,z',
        '-x+1/2,y+1/2,z',
        'x+1/2,y,z+1/2',
        '-x,-y+1/2,z+1/2',
        'x+1/2,-y,z+1/2',
        '-x,y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z+1/2',
        '-x,y+1/2,z+1/2',
        'x,-y,z',
    ]
},

{
    number          => 36,
    hall            => 'C 2c -2 (y-1/4,-x,z)',
    schoenflies     => 'C2v^12',
    hermann_mauguin => 'C m c 21 (b,-a+1/4,c)',
    universal_h_m   => 'C m c 21 (b,-a+1/4,c)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        'x,-y,z',
        '-x+1/2,y,z+1/2',
        'x+1/2,y+1/2,z',
        '-x,-y+1/2,z+1/2',
        'x+1/2,-y+1/2,z',
        '-x,y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z+1/2',
        '-x,y+1/2,z+1/2',
        'x,-y,z',
    ]
},

{
    number          => 44,
    hall            => 'I 2 -2 (x+1/4,y,z-1/4)',
    schoenflies     => 'C2v^20',
    hermann_mauguin => 'I m m 2 (a-1/4,b,c+1/4)',
    universal_h_m   => 'I m m 2 (a-1/4,b,c+1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z',
        '-x+1/2,y,z',
        'x,-y,z',
        'x+1/2,y+1/2,z+1/2',
        '-x,-y+1/2,z+1/2',
        '-x,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z+1/2',
        '-x,y+1/2,z+1/2',
        'x,-y,z',
    ]
},

{
    number          => 36,
    hall            => 'C 2c -2 (y-1/4,z,x)',
    schoenflies     => 'C2v^12',
    hermann_mauguin => 'C m c 21 (b,c+1/4,a)',
    universal_h_m   => 'C m c 21 (b,c+1/4,a)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y+1/2,-z',
        'x,y,-z',
        '-x+1/2,y+1/2,z',
        'x+1/2,y,z+1/2',
        '-x,y+1/2,-z+1/2',
        'x+1/2,y,-z+1/2',
        '-x,y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,y,-z',
        '-x,y+1/2,z+1/2',
        '-x,y+1/2,-z+1/2',
    ]
},

{
    number          => 40,
    hall            => 'A 2 -2a (y-1/4,z+1/4,x-1/4)',
    schoenflies     => 'C2v^16',
    hermann_mauguin => 'A m a 2 (b+1/4,c+1/4,a-1/4)',
    universal_h_m   => 'A m a 2 (b+1/4,c+1/4,a-1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y,-z+1/2',
        'x,y,-z',
        '-x+1/2,y,z+1/2',
        'x+1/2,y+1/2,z',
        '-x,y+1/2,-z+1/2',
        'x+1/2,y+1/2,-z',
        '-x,y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,y,-z',
        '-x,y+1/2,z+1/2',
        '-x,y+1/2,-z+1/2',
    ]
},

{
    number          => 44,
    hall            => 'I 2 -2 (y+1/4,z,x)',
    schoenflies     => 'C2v^20',
    hermann_mauguin => 'I m m 2 (b,c-1/4,a)',
    universal_h_m   => 'I m m 2 (b,c-1/4,a)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y,-z',
        'x,y,-z',
        '-x+1/2,y,z',
        'x+1/2,y+1/2,z+1/2',
        '-x,y+1/2,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-x,y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,y,-z',
        '-x,y+1/2,z+1/2',
        '-x,y+1/2,-z+1/2',
    ]
},

{
    number          => 40,
    hall            => 'A 2 -2a (-x+1/4,z+1/4,y-1/4)',
    schoenflies     => 'C2v^16',
    hermann_mauguin => 'A m a 2 (-a+1/4,c+1/4,b-1/4)',
    universal_h_m   => 'A m a 2 (-a+1/4,c+1/4,b-1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y,-z+1/2',
        '-x,y,z',
        'x+1/2,y,-z+1/2',
        'x,y+1/2,z+1/2',
        '-x+1/2,y+1/2,-z',
        '-x,y+1/2,z+1/2',
        'x+1/2,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y+1/2,-z',
        '-x,y,z',
        '-x+1/2,y+1/2,-z',
    ]
},

{
    number          => 36,
    hall            => 'C 2c -2 (-x,z,y-1/4)',
    schoenflies     => 'C2v^12',
    hermann_mauguin => 'C m c 21 (-a,c+1/4,b)',
    universal_h_m   => 'C m c 21 (-a,c+1/4,b)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y+1/2,-z+1/2',
        '-x,y,z',
        'x,y+1/2,-z+1/2',
        'x+1/2,y,z+1/2',
        '-x+1/2,y+1/2,-z',
        '-x+1/2,y,z+1/2',
        'x+1/2,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y+1/2,-z',
        '-x,y,z',
        '-x+1/2,y+1/2,-z',
    ]
},

{
    number          => 44,
    hall            => 'I 2 -2 (y,z-1/4,x+1/4)',
    schoenflies     => 'C2v^20',
    hermann_mauguin => 'I m m 2 (b-1/4,c,a+1/4)',
    universal_h_m   => 'I m m 2 (b-1/4,c,a+1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y,-z+1/2',
        'x,y,-z+1/2',
        '-x,y,z',
        'x+1/2,y+1/2,z+1/2',
        '-x+1/2,y+1/2,-z',
        'x+1/2,y+1/2,-z',
        '-x+1/2,y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y+1/2,-z',
        '-x,y,z',
        '-x+1/2,y+1/2,-z',
    ]
},

{
    number          => 40,
    hall            => 'A 2 -2a (x,y-1/4,z+1/4)',
    schoenflies     => 'C2v^16',
    hermann_mauguin => 'A m a 2 (a,b+1/4,c-1/4)',
    universal_h_m   => 'A m a 2 (a,b+1/4,c-1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z',
        '-x+1/2,y,z',
        'x+1/2,-y+1/2,z',
        'x,y+1/2,z+1/2',
        '-x,-y,z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z',
    ]
},

{
    number          => 40,
    hall            => 'A 2 -2a (y-1/4,-x,z+1/4)',
    schoenflies     => 'C2v^16',
    hermann_mauguin => 'A m a 2 (b,-a+1/4,c-1/4)',
    universal_h_m   => 'A m a 2 (b,-a+1/4,c-1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x,-y+1/2,z',
        '-x+1/2,y+1/2,z',
        'x+1/2,y,z+1/2',
        '-x,-y,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        '-x,y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z+1/2',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y+1/2,z+1/2',
    ]
},

{
    number          => 40,
    hall            => 'A 2 -2a (y-1/4,z+1/4,x)',
    schoenflies     => 'C2v^16',
    hermann_mauguin => 'A m a 2 (b,c+1/4,a-1/4)',
    universal_h_m   => 'A m a 2 (b,c+1/4,a-1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y,-z',
        'x,y,-z+1/2',
        '-x+1/2,y,z+1/2',
        'x+1/2,y+1/2,z',
        '-x,y+1/2,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-x,y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y+1/2,-z+1/2',
        '-x+1/2,y,z+1/2',
        '-x,y+1/2,-z',
    ]
},

{
    number          => 40,
    hall            => 'A 2 -2a (-x,z+1/4,y-1/4)',
    schoenflies     => 'C2v^16',
    hermann_mauguin => 'A m a 2 (-a,c+1/4,b-1/4)',
    universal_h_m   => 'A m a 2 (-a,c+1/4,b-1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y,-z+1/2',
        '-x+1/2,y,z',
        'x+1/2,y,-z+1/2',
        'x,y+1/2,z+1/2',
        '-x,y+1/2,-z',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,y,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        '-x,y+1/2,-z',
    ]
},

{
    number          => 66,
    hall            => '-C 2 2c (z+1/4,x,y)',
    schoenflies     => 'D2h^20',
    hermann_mauguin => 'C c c m (c,a,b-1/4)',
    universal_h_m   => 'C c c m (c,a,b-1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,-y,-z',
        '-x,y,-z',
        '-x,-y,z',
        '-x+1/2,-y,-z',
        '-x+1/2,y,z',
        'x+1/2,-y,z',
        'x+1/2,y,-z',
        'x,y+1/2,z+1/2',
        'x,-y+1/2,-z+1/2',
        '-x,y+1/2,-z+1/2',
        '-x,-y+1/2,z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        'x+1/2,y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        '-x+1/2,-y+1/2,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ]
},

{
    number          => 66,
    hall            => '-C 2 2c (y,z+1/4,x)',
    schoenflies     => 'D2h^20',
    hermann_mauguin => 'C c c m (b,c,a-1/4)',
    universal_h_m   => 'C c c m (b,c,a-1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y,-z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,-y+1/2,-z',
        'x,-y+1/2,z',
        'x,y+1/2,-z',
        '-x,y+1/2,z',
        'x+1/2,y,z+1/2',
        '-x+1/2,y,-z+1/2',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        '-x+1/2,-y+1/2,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ]
},

{
    number          => 66,
    hall            => '-C 2 2c (x,y,z+1/4)',
    schoenflies     => 'D2h^20',
    hermann_mauguin => 'C c c m (a,b,c-1/4)',
    universal_h_m   => 'C c c m (a,b,c-1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        '-x,-y,-z+1/2',
        'x,y,-z+1/2',
        '-x,y,z+1/2',
        'x,-y,z+1/2',
        'x+1/2,y+1/2,z',
        '-x+1/2,-y+1/2,z',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,y+1/2,-z',
        '-x+1/2,-y+1/2,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        '-x+1/2,-y+1/2,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ]
},

{
    number          => 69,
    hall            => '-F 2 2 (x+1/4,y+1/4,z+1/4)',
    schoenflies     => 'D2h^23',
    hermann_mauguin => 'F m m m (a-1/4,b-1/4,c-1/4)',
    universal_h_m   => 'F m m m (a-1/4,b-1/4,c-1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x,-y+1/2,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        'x,y,-z+1/2',
        '-x+1/2,y,z',
        'x,-y+1/2,z',
        'x,y+1/2,z+1/2',
        '-x+1/2,-y,z+1/2',
        'x,-y,-z',
        '-x+1/2,y+1/2,-z',
        '-x+1/2,-y,-z',
        'x,y+1/2,-z',
        '-x+1/2,y+1/2,z+1/2',
        'x,-y,z+1/2',
        'x+1/2,y,z+1/2',
        '-x,-y+1/2,z+1/2',
        'x+1/2,-y+1/2,-z',
        '-x,y,-z',
        '-x,-y+1/2,-z',
        'x+1/2,y,-z',
        '-x,y,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        'x+1/2,y+1/2,z',
        '-x,-y,z',
        'x+1/2,-y,-z+1/2',
        '-x,y+1/2,-z+1/2',
        '-x,-y,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-x,y+1/2,z',
        'x+1/2,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        '-x+1/2,-y+1/2,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ]
},

{
    number          => 66,
    hall            => '-C 2 2c (z,x+1/4,y+1/4)',
    schoenflies     => 'D2h^20',
    hermann_mauguin => 'C c c m (c-1/4,a-1/4,b)',
    universal_h_m   => 'C c c m (c-1/4,a-1/4,b)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,-y+1/2,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-x+1/2,-y+1/2,z',
        '-x,-y+1/2,-z+1/2',
        '-x,y,z',
        'x+1/2,-y+1/2,z',
        'x+1/2,y,-z+1/2',
        'x,y+1/2,z+1/2',
        'x,-y,-z',
        '-x+1/2,y+1/2,-z',
        '-x+1/2,-y,z+1/2',
        '-x,-y,-z',
        '-x,y+1/2,z+1/2',
        'x+1/2,-y,z+1/2',
        'x+1/2,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x,-y+1/2,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
        '-x,y+1/2,z+1/2',
        'x+1/2,-y,z+1/2',
    ]
},

{
    number          => 66,
    hall            => '-C 2 2c (y+1/4,z,x+1/4)',
    schoenflies     => 'D2h^20',
    hermann_mauguin => 'C c c m (b-1/4,c-1/4,a)',
    universal_h_m   => 'C c c m (b-1/4,c-1/4,a)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y,-z+1/2',
        '-x+1/2,-y+1/2,z',
        'x,-y+1/2,-z+1/2',
        '-x+1/2,-y,-z+1/2',
        'x,-y,z',
        'x,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z',
        'x+1/2,y,z+1/2',
        '-x,y,-z',
        '-x,-y+1/2,z+1/2',
        'x+1/2,-y+1/2,-z',
        '-x,-y,-z',
        'x+1/2,-y,z+1/2',
        'x+1/2,y+1/2,-z',
        '-x,y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x,-y+1/2,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
        '-x,y+1/2,z+1/2',
        'x+1/2,-y,z+1/2',
    ]
},

{
    number          => 66,
    hall            => '-C 2 2c (x+1/4,y+1/4,z)',
    schoenflies     => 'D2h^20',
    hermann_mauguin => 'C c c m (a-1/4,b-1/4,c)',
    universal_h_m   => 'C c c m (a-1/4,b-1/4,c)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x,-y+1/2,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-x+1/2,-y+1/2,-z',
        'x,y,-z',
        '-x+1/2,y,z+1/2',
        'x,-y+1/2,z+1/2',
        'x+1/2,y+1/2,z',
        '-x,-y,z',
        'x+1/2,-y,-z+1/2',
        '-x,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
        '-x,y+1/2,z+1/2',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x,-y+1/2,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
        '-x,y+1/2,z+1/2',
        'x+1/2,-y,z+1/2',
    ]
},

{
    number          => 71,
    hall            => '-I 2 2 (x-1/4,y+1/4,z-1/4)',
    schoenflies     => 'D2h^25',
    hermann_mauguin => 'I m m m (a+1/4,b-1/4,c+1/4)',
    universal_h_m   => 'I m m m (a+1/4,b-1/4,c+1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x,-y+1/2,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        'x,y,-z+1/2',
        '-x+1/2,y,z',
        'x,-y+1/2,z',
        'x+1/2,y+1/2,z+1/2',
        '-x,-y,z+1/2',
        'x+1/2,-y,-z',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
        '-x,y+1/2,z+1/2',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x,-y+1/2,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
        '-x,y+1/2,z+1/2',
        'x+1/2,-y,z+1/2',
    ]
},

{
    number          => 69,
    hall            => '-F 2 2 (x-1/4,y-1/4,z)',
    schoenflies     => 'D2h^23',
    hermann_mauguin => 'F m m m (a+1/4,b+1/4,c)',
    universal_h_m   => 'F m m m (a+1/4,b+1/4,c)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x,-y+1/2,-z',
        '-x+1/2,y,-z',
        '-x+1/2,-y+1/2,-z',
        'x,y,-z',
        '-x+1/2,y,z',
        'x,-y+1/2,z',
        'x,y+1/2,z+1/2',
        '-x+1/2,-y,z+1/2',
        'x,-y,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-x+1/2,-y,-z+1/2',
        'x,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x,-y,z+1/2',
        'x+1/2,y,z+1/2',
        '-x,-y+1/2,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        '-x,y,-z+1/2',
        '-x,-y+1/2,-z+1/2',
        'x+1/2,y,-z+1/2',
        '-x,y,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        'x+1/2,y+1/2,z',
        '-x,-y,z',
        'x+1/2,-y,-z',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
        '-x,y+1/2,z',
        'x+1/2,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z+1/2',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'x,y,-z',
        '-x,y,z+1/2',
        'x,-y,z+1/2',
    ]
},

{
    number          => 69,
    hall            => '-F 2 2 (x+1/2,y-1/4,z-1/4)',
    schoenflies     => 'D2h^23',
    hermann_mauguin => 'F m m m (a+1/2,b+1/4,c+1/4)',
    universal_h_m   => 'F m m m (a+1/2,b+1/4,c+1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x,-y+1/2,-z+1/2',
        '-x,y,-z+1/2',
        '-x,-y+1/2,-z+1/2',
        'x,y,-z+1/2',
        '-x,y,z',
        'x,-y+1/2,z',
        'x,y+1/2,z+1/2',
        '-x,-y,z+1/2',
        'x,-y,-z',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'x,y+1/2,-z',
        '-x,y+1/2,z+1/2',
        'x,-y,z+1/2',
        'x+1/2,y,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,y,-z',
        '-x+1/2,-y+1/2,-z',
        'x+1/2,y,-z',
        '-x+1/2,y,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        'x+1/2,y+1/2,z',
        '-x+1/2,-y,z',
        'x+1/2,-y,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-x+1/2,-y,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x,-y,-z',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x,y,z',
        'x+1/2,-y,z',
    ]
},

{
    number          => 69,
    hall            => '-F 2 2 (x+1/4,y+1/2,z-1/4)',
    schoenflies     => 'D2h^23',
    hermann_mauguin => 'F m m m (a-1/4,b+1/2,c+1/4)',
    universal_h_m   => 'F m m m (a-1/4,b+1/2,c+1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x,-y,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-x+1/2,-y,-z+1/2',
        'x,y,-z+1/2',
        '-x+1/2,y,z',
        'x,-y,z',
        'x,y+1/2,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        'x,-y+1/2,-z',
        '-x+1/2,y+1/2,-z',
        '-x+1/2,-y+1/2,-z',
        'x,y+1/2,-z',
        '-x+1/2,y+1/2,z+1/2',
        'x,-y+1/2,z+1/2',
        'x+1/2,y,z+1/2',
        '-x,-y,z+1/2',
        'x+1/2,-y,-z',
        '-x,y,-z',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x,y,z+1/2',
        'x+1/2,-y,z+1/2',
        'x+1/2,y+1/2,z',
        '-x,-y+1/2,z',
        'x+1/2,-y+1/2,-z+1/2',
        '-x,y+1/2,-z+1/2',
        '-x,-y+1/2,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-x,y+1/2,z',
        'x+1/2,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x,-y+1/2,-z',
        '-x,y,-z',
        '-x,-y,-z',
        'x,y+1/2,-z',
        '-x,y+1/2,z',
        'x,-y,z',
    ]
},

{
    number          => 72,
    hall            => '-I 2 2c (x,y,z-1/4)',
    schoenflies     => 'D2h^26',
    hermann_mauguin => 'I b a m (a,b,c+1/4)',
    universal_h_m   => 'I b a m (a,b,c+1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        '-x,-y,-z+1/2',
        'x,y,-z+1/2',
        '-x,y,z+1/2',
        'x,-y,z+1/2',
        'x+1/2,y+1/2,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-x+1/2,-y+1/2,-z',
        'x+1/2,y+1/2,-z',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        '-x+1/2,-y+1/2,-z',
        'x+1/2,y+1/2,-z',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y+1/2,z',
    ]
},

{
    number          => 65,
    hall            => '-C 2 2 (x+1/4,y+1/4,z)',
    schoenflies     => 'D2h^19',
    hermann_mauguin => 'C m m m (a-1/4,b-1/4,c)',
    universal_h_m   => 'C m m m (a-1/4,b-1/4,c)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x,-y+1/2,-z',
        '-x+1/2,y,-z',
        '-x+1/2,-y+1/2,-z',
        'x,y,-z',
        '-x+1/2,y,z',
        'x,-y+1/2,z',
        'x+1/2,y+1/2,z',
        '-x,-y,z',
        'x+1/2,-y,-z',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
        '-x,y+1/2,z',
        'x+1/2,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x,-y+1/2,-z',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
        '-x,y+1/2,z',
        'x+1/2,-y,z',
    ]
},

{
    number          => 72,
    hall            => '-I 2 2c (x-1/4,y+1/4,z-1/4)',
    schoenflies     => 'D2h^26',
    hermann_mauguin => 'I b a m (a+1/4,b-1/4,c+1/4)',
    universal_h_m   => 'I b a m (a+1/4,b-1/4,c+1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x,-y+1/2,-z',
        '-x+1/2,y,-z',
        '-x+1/2,-y+1/2,-z+1/2',
        'x,y,-z+1/2',
        '-x+1/2,y,z+1/2',
        'x,-y+1/2,z+1/2',
        'x+1/2,y+1/2,z+1/2',
        '-x,-y,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
        '-x,y+1/2,z',
        'x+1/2,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x,-y+1/2,-z',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
        '-x,y+1/2,z',
        'x+1/2,-y,z',
    ]
},

{
    number          => 72,
    hall            => '-I 2 2c (z-1/4,x,y)',
    schoenflies     => 'D2h^26',
    hermann_mauguin => 'I b a m (c,a,b+1/4)',
    universal_h_m   => 'I b a m (c,a,b+1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,-y,-z',
        '-x,y,-z',
        '-x,-y,z',
        '-x+1/2,-y,-z',
        '-x+1/2,y,z',
        'x+1/2,-y,z',
        'x+1/2,y,-z',
        'x+1/2,y+1/2,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        '-x,-y+1/2,-z+1/2',
        '-x,y+1/2,z+1/2',
        'x,-y+1/2,z+1/2',
        'x,y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        '-x,-y+1/2,-z+1/2',
        'x,y+1/2,-z+1/2',
        '-x,y+1/2,z+1/2',
        'x,-y+1/2,z+1/2',
    ]
},

{
    number          => 65,
    hall            => '-C 2 2 (z,x+1/4,y+1/4)',
    schoenflies     => 'D2h^19',
    hermann_mauguin => 'C m m m (c-1/4,a-1/4,b)',
    universal_h_m   => 'C m m m (c-1/4,a-1/4,b)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,-y+1/2,-z+1/2',
        '-x,y,-z+1/2',
        '-x,-y+1/2,z',
        '-x,-y+1/2,-z+1/2',
        '-x,y,z',
        'x,-y+1/2,z',
        'x,y,-z+1/2',
        'x,y+1/2,z+1/2',
        'x,-y,-z',
        '-x,y+1/2,-z',
        '-x,-y,z+1/2',
        '-x,-y,-z',
        '-x,y+1/2,z+1/2',
        'x,-y,z+1/2',
        'x,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x,-y+1/2,-z+1/2',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'x,y+1/2,-z',
        '-x,y+1/2,z+1/2',
        'x,-y,z+1/2',
    ]
},

{
    number          => 72,
    hall            => '-I 2 2c (z-1/4,x-1/4,y+1/4)',
    schoenflies     => 'D2h^26',
    hermann_mauguin => 'I b a m (c+1/4,a-1/4,b+1/4)',
    universal_h_m   => 'I b a m (c+1/4,a-1/4,b+1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,-y+1/2,-z+1/2',
        '-x,y,-z+1/2',
        '-x,-y+1/2,z',
        '-x+1/2,-y+1/2,-z+1/2',
        '-x+1/2,y,z',
        'x+1/2,-y+1/2,z',
        'x+1/2,y,-z+1/2',
        'x+1/2,y+1/2,z+1/2',
        'x+1/2,-y,-z',
        '-x+1/2,y+1/2,-z',
        '-x+1/2,-y,z+1/2',
        '-x,-y,-z',
        '-x,y+1/2,z+1/2',
        'x,-y,z+1/2',
        'x,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x,-y+1/2,-z+1/2',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'x,y+1/2,-z',
        '-x,y+1/2,z+1/2',
        'x,-y,z+1/2',
    ]
},

{
    number          => 72,
    hall            => '-I 2 2c (y,z-1/4,x)',
    schoenflies     => 'D2h^26',
    hermann_mauguin => 'I b a m (b,c,a+1/4)',
    universal_h_m   => 'I b a m (b,c,a+1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y,-z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,-y+1/2,-z',
        'x,-y+1/2,z',
        'x,y+1/2,-z',
        '-x,y+1/2,z',
        'x+1/2,y+1/2,z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        '-x+1/2,-y,-z+1/2',
        'x+1/2,-y,z+1/2',
        'x+1/2,y,-z+1/2',
        '-x+1/2,y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        '-x+1/2,-y,-z+1/2',
        'x+1/2,y,-z+1/2',
        '-x+1/2,y,z+1/2',
        'x+1/2,-y,z+1/2',
    ]
},

{
    number          => 65,
    hall            => '-C 2 2 (y+1/4,z,x+1/4)',
    schoenflies     => 'D2h^19',
    hermann_mauguin => 'C m m m (b-1/4,c-1/4,a)',
    universal_h_m   => 'C m m m (b-1/4,c-1/4,a)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y,-z+1/2',
        '-x+1/2,-y,z',
        'x,-y,-z+1/2',
        '-x+1/2,-y,-z+1/2',
        'x,-y,z',
        'x,y,-z+1/2',
        '-x+1/2,y,z',
        'x+1/2,y,z+1/2',
        '-x,y,-z',
        '-x,-y,z+1/2',
        'x+1/2,-y,-z',
        '-x,-y,-z',
        'x+1/2,-y,z+1/2',
        'x+1/2,y,-z',
        '-x,y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x,-y,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x,y,z+1/2',
        'x+1/2,-y,z+1/2',
    ]
},

{
    number          => 72,
    hall            => '-I 2 2c (y+1/4,z-1/4,x-1/4)',
    schoenflies     => 'D2h^26',
    hermann_mauguin => 'I b a m (b+1/4,c-1/4,a+1/4)',
    universal_h_m   => 'I b a m (b+1/4,c-1/4,a+1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y,-z+1/2',
        '-x+1/2,-y,z',
        'x,-y,-z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        'x,-y+1/2,z',
        'x,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z',
        'x+1/2,y+1/2,z+1/2',
        '-x,y+1/2,-z',
        '-x,-y+1/2,z+1/2',
        'x+1/2,-y+1/2,-z',
        '-x,-y,-z',
        'x+1/2,-y,z+1/2',
        'x+1/2,y,-z',
        '-x,y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x,-y,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x,y,z+1/2',
        'x+1/2,-y,z+1/2',
    ]
},

{
    number          => 63,
    hall            => '-C 2c 2 (y+1/4,z,x+1/4)',
    schoenflies     => 'D2h^17',
    hermann_mauguin => 'C m c m (b-1/4,c-1/4,a)',
    universal_h_m   => 'C m c m (b-1/4,c-1/4,a)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y+1/2,-z+1/2',
        '-x+1/2,-y,z',
        'x,-y+1/2,-z+1/2',
        '-x+1/2,-y,-z+1/2',
        'x,-y+1/2,z',
        'x,y,-z+1/2',
        '-x+1/2,y+1/2,z',
        'x+1/2,y,z+1/2',
        '-x,y+1/2,-z',
        '-x,-y,z+1/2',
        'x+1/2,-y+1/2,-z',
        '-x,-y,-z',
        'x+1/2,-y+1/2,z+1/2',
        'x+1/2,y,-z',
        '-x,y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x,-y+1/2,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ]
},

{
    number          => 63,
    hall            => '-C 2c 2 (z,y+1/4,-x-1/4)',
    schoenflies     => 'D2h^17',
    hermann_mauguin => 'C m c m (c-1/4,b-1/4,-a)',
    universal_h_m   => 'C m c m (c-1/4,b-1/4,-a)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,-y+1/2,-z+1/2',
        '-x,-y+1/2,z',
        '-x+1/2,y,-z+1/2',
        '-x,-y+1/2,-z+1/2',
        '-x+1/2,y,z',
        'x,y,-z+1/2',
        'x+1/2,-y+1/2,z',
        'x,y+1/2,z+1/2',
        'x+1/2,-y,-z',
        '-x,-y,z+1/2',
        '-x+1/2,y+1/2,-z',
        '-x,-y,-z',
        '-x+1/2,y+1/2,z+1/2',
        'x,y+1/2,-z',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x+1/2,-y+1/2,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-x,-y,-z',
        'x,y+1/2,-z',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,-y,z+1/2',
    ]
},

{
    number          => 63,
    hall            => '-C 2c 2 (x+1/4,y+1/4,z)',
    schoenflies     => 'D2h^17',
    hermann_mauguin => 'C m c m (a-1/4,b-1/4,c)',
    universal_h_m   => 'C m c m (a-1/4,b-1/4,c)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z+1/2',
        'x,-y+1/2,-z',
        '-x+1/2,y,-z+1/2',
        '-x+1/2,-y+1/2,-z',
        'x,y,-z+1/2',
        '-x+1/2,y,z',
        'x,-y+1/2,z+1/2',
        'x+1/2,y+1/2,z',
        '-x,-y,z+1/2',
        'x+1/2,-y,-z',
        '-x,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-x,y+1/2,z',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y+1/2,z+1/2',
        'x,-y+1/2,-z',
        '-x+1/2,y,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-x,y+1/2,z',
        'x+1/2,-y,z+1/2',
    ]
},

{
    number          => 63,
    hall            => '-C 2c 2 (-x-1/4,z,y+1/4)',
    schoenflies     => 'D2h^17',
    hermann_mauguin => 'C m c m (-a-1/4,c-1/4,b)',
    universal_h_m   => 'C m c m (-a-1/4,c-1/4,b)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y+1/2,-z+1/2',
        'x,-y,-z+1/2',
        '-x+1/2,-y+1/2,z',
        '-x+1/2,-y,-z+1/2',
        'x,-y+1/2,z',
        '-x+1/2,y,z',
        'x,y+1/2,-z+1/2',
        'x+1/2,y,z+1/2',
        '-x,y+1/2,-z',
        'x+1/2,-y,-z',
        '-x,-y+1/2,z+1/2',
        '-x,-y,-z',
        'x+1/2,-y+1/2,z+1/2',
        '-x,y,z+1/2',
        'x+1/2,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x,-y,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
        '-x,y,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ]
},

{
    number          => 63,
    hall            => '-C 2c 2 (z,x+1/4,y+1/4)',
    schoenflies     => 'D2h^17',
    hermann_mauguin => 'C m c m (c-1/4,a-1/4,b)',
    universal_h_m   => 'C m c m (c-1/4,a-1/4,b)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,-y+1/2,-z+1/2',
        '-x,y,-z+1/2',
        '-x+1/2,-y+1/2,z',
        '-x,-y+1/2,-z+1/2',
        '-x+1/2,y,z',
        'x,-y+1/2,z',
        'x+1/2,y,-z+1/2',
        'x,y+1/2,z+1/2',
        'x+1/2,-y,-z',
        '-x,y+1/2,-z',
        '-x+1/2,-y,z+1/2',
        '-x,-y,-z',
        '-x+1/2,y+1/2,z+1/2',
        'x,-y,z+1/2',
        'x+1/2,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x+1/2,-y+1/2,-z+1/2',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
        '-x+1/2,y+1/2,z+1/2',
        'x,-y,z+1/2',
    ]
},

{
    number          => 63,
    hall            => '-C 2c 2 (y+1/4,-x-1/4,z)',
    schoenflies     => 'D2h^17',
    hermann_mauguin => 'C m c m (b-1/4,-a-1/4,c)',
    universal_h_m   => 'C m c m (b-1/4,-a-1/4,c)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z+1/2',
        '-x+1/2,y,-z',
        'x,-y+1/2,-z+1/2',
        '-x+1/2,-y+1/2,-z',
        'x,y,-z+1/2',
        'x,-y+1/2,z',
        '-x+1/2,y,z+1/2',
        'x+1/2,y+1/2,z',
        '-x,-y,z+1/2',
        '-x,y+1/2,-z',
        'x+1/2,-y,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z+1/2',
        'x+1/2,-y,z',
        '-x,y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y+1/2,z+1/2',
        'x,-y+1/2,-z+1/2',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-x,y+1/2,z+1/2',
        'x+1/2,-y,z',
    ]
},

{
    number          => 64,
    hall            => '-C 2ac 2 (z,x+1/4,y+1/4)',
    schoenflies     => 'D2h^18',
    hermann_mauguin => 'C m c e (c-1/4,a-1/4,b)',
    universal_h_m   => 'C m c e (c-1/4,a-1/4,b)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,-y,-z+1/2',
        '-x,y,-z+1/2',
        '-x+1/2,-y,z',
        '-x,-y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z',
        'x,-y+1/2,z',
        'x+1/2,y+1/2,-z+1/2',
        'x,y+1/2,z+1/2',
        'x+1/2,-y+1/2,-z',
        '-x,y+1/2,-z',
        '-x+1/2,-y+1/2,z+1/2',
        '-x,-y,-z',
        '-x+1/2,y,z+1/2',
        'x,-y,z+1/2',
        'x+1/2,y,-z',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x+1/2,-y,-z+1/2',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x+1/2,y,z+1/2',
        'x,-y,z+1/2',
    ]
},

{
    number          => 64,
    hall            => '-C 2ac 2 (-x-1/4,z,y+1/4)',
    schoenflies     => 'D2h^18',
    hermann_mauguin => 'C m c e (-a-1/4,c-1/4,b)',
    universal_h_m   => 'C m c e (-a-1/4,c-1/4,b)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y+1/2,-z+1/2',
        'x,-y,-z+1/2',
        '-x,-y+1/2,z',
        '-x+1/2,-y,-z+1/2',
        'x+1/2,-y+1/2,z',
        '-x+1/2,y,z',
        'x+1/2,y+1/2,-z+1/2',
        'x+1/2,y,z+1/2',
        '-x+1/2,y+1/2,-z',
        'x+1/2,-y,-z',
        '-x+1/2,-y+1/2,z+1/2',
        '-x,-y,-z',
        'x,-y+1/2,z+1/2',
        '-x,y,z+1/2',
        'x,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x,-y,-z+1/2',
        '-x,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x,y+1/2,-z',
        '-x,y,z+1/2',
        'x,-y+1/2,z+1/2',
    ]
},

{
    number          => 64,
    hall            => '-C 2ac 2 (y+1/4,z,x+1/4)',
    schoenflies     => 'D2h^18',
    hermann_mauguin => 'C m c e (b-1/4,c-1/4,a)',
    universal_h_m   => 'C m c e (b-1/4,c-1/4,a)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y+1/2,-z',
        '-x+1/2,-y,z',
        'x,-y+1/2,-z',
        '-x+1/2,-y,-z+1/2',
        'x,-y+1/2,z+1/2',
        'x,y,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,y,z+1/2',
        '-x,y+1/2,-z+1/2',
        '-x,-y,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        '-x,-y,-z',
        'x+1/2,-y+1/2,z',
        'x+1/2,y,-z',
        '-x,y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x,-y+1/2,-z',
        '-x+1/2,y+1/2,-z',
        '-x,-y,-z',
        'x+1/2,y,-z',
        '-x,y+1/2,z',
        'x+1/2,-y+1/2,z',
    ]
},

{
    number          => 64,
    hall            => '-C 2ac 2 (y+1/4,-x-1/4,z)',
    schoenflies     => 'D2h^18',
    hermann_mauguin => 'C m c e (b-1/4,-a-1/4,c)',
    universal_h_m   => 'C m c e (b-1/4,-a-1/4,c)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        '-x+1/2,y,-z',
        'x,-y,-z+1/2',
        '-x+1/2,-y+1/2,-z',
        'x,y+1/2,-z+1/2',
        'x,-y+1/2,z',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,y+1/2,z',
        '-x,-y+1/2,z+1/2',
        '-x,y+1/2,-z',
        'x+1/2,-y+1/2,-z+1/2',
        '-x,-y,-z',
        'x+1/2,y,-z+1/2',
        'x+1/2,-y,z',
        '-x,y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        'x,-y,-z+1/2',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x+1/2,y,-z+1/2',
        '-x,y,z+1/2',
        'x+1/2,-y,z',
    ]
},

{
    number          => 64,
    hall            => '-C 2ac 2 (x+1/4,y+1/4,z)',
    schoenflies     => 'D2h^18',
    hermann_mauguin => 'C m c e (a-1/4,b-1/4,c)',
    universal_h_m   => 'C m c e (a-1/4,b-1/4,c)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z+1/2',
        'x,-y+1/2,-z',
        '-x,y,-z+1/2',
        '-x+1/2,-y+1/2,-z',
        'x+1/2,y,-z+1/2',
        '-x+1/2,y,z',
        'x+1/2,-y+1/2,z+1/2',
        'x+1/2,y+1/2,z',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y,-z',
        '-x+1/2,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x,y+1/2,-z+1/2',
        '-x,y+1/2,z',
        'x,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z+1/2',
        'x,-y+1/2,-z',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'x,y+1/2,-z+1/2',
        '-x,y+1/2,z',
        'x,-y,z+1/2',
    ]
},

{
    number          => 64,
    hall            => '-C 2ac 2 (z,y+1/4,-x-1/4)',
    schoenflies     => 'D2h^18',
    hermann_mauguin => 'C m c e (c-1/4,b-1/4,-a)',
    universal_h_m   => 'C m c e (c-1/4,b-1/4,-a)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,-y+1/2,-z',
        '-x,-y+1/2,z',
        '-x+1/2,y,-z',
        '-x,-y+1/2,-z+1/2',
        '-x+1/2,y,z+1/2',
        'x,y,-z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        'x,y+1/2,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x,-y,z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-x,-y,-z',
        '-x+1/2,y+1/2,z',
        'x,y+1/2,-z',
        'x+1/2,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,y,-z',
        '-x,-y,-z',
        'x,y+1/2,-z',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y,z',
    ]
},

{
    number          => 63,
    hall            => '-C 2c 2 (z-1/4,x+1/2,y+1/4)',
    schoenflies     => 'D2h^17',
    hermann_mauguin => 'C m c m (c+1/2,a-1/4,b+1/4)',
    universal_h_m   => 'C m c m (c+1/2,a-1/4,b+1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,-y,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-x,-y,z',
        '-x+1/2,-y,-z+1/2',
        '-x,y,z',
        'x,-y,z',
        'x+1/2,y,-z+1/2',
        'x,y+1/2,z+1/2',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,y+1/2,-z',
        '-x,-y+1/2,z+1/2',
        '-x+1/2,-y+1/2,-z',
        '-x,y+1/2,z+1/2',
        'x,-y+1/2,z+1/2',
        'x+1/2,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,y+1/2,-z',
        '-x+1/2,-y+1/2,-z',
        'x+1/2,y+1/2,-z',
        '-x,y,z',
        'x,-y,z',
    ]
},

{
    number          => 63,
    hall            => '-C 2c 2 (-x+1/2,z-1/4,y+1/4)',
    schoenflies     => 'D2h^17',
    hermann_mauguin => 'C m c m (-a+1/2,c-1/4,b+1/4)',
    universal_h_m   => 'C m c m (-a+1/2,c-1/4,b+1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y+1/2,-z+1/2',
        'x,-y+1/2,-z+1/2',
        '-x,-y,z',
        '-x,-y+1/2,-z+1/2',
        'x,-y,z',
        '-x,y,z',
        'x,y+1/2,-z+1/2',
        'x+1/2,y,z+1/2',
        '-x+1/2,y+1/2,-z',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,-y,z+1/2',
        '-x+1/2,-y+1/2,-z',
        'x+1/2,-y,z+1/2',
        '-x+1/2,y,z+1/2',
        'x+1/2,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,y+1/2,-z',
        '-x+1/2,-y+1/2,-z',
        'x+1/2,y+1/2,-z',
        '-x,y,z',
        'x,-y,z',
    ]
},

{
    number          => 71,
    hall            => '-I 2 2 (x,y,z+1/4)',
    schoenflies     => 'D2h^25',
    hermann_mauguin => 'I m m m (a,b,c-1/4)',
    universal_h_m   => 'I m m m (a,b,c-1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z+1/2',
        '-x,y,-z+1/2',
        '-x,-y,-z+1/2',
        'x,y,-z+1/2',
        '-x,y,z',
        'x,-y,z',
        'x+1/2,y+1/2,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,y+1/2,-z',
        '-x+1/2,-y+1/2,-z',
        'x+1/2,y+1/2,-z',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,y+1/2,-z',
        '-x+1/2,-y+1/2,-z',
        'x+1/2,y+1/2,-z',
        '-x,y,z',
        'x,-y,z',
    ]
},

{
    number          => 63,
    hall            => '-C 2c 2 (y+1/4,z-1/4,x+1/2)',
    schoenflies     => 'D2h^17',
    hermann_mauguin => 'C m c m (b+1/2,c-1/4,a+1/4)',
    universal_h_m   => 'C m c m (b+1/2,c-1/4,a+1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y+1/2,-z',
        '-x+1/2,-y+1/2,z',
        'x,-y,-z',
        '-x+1/2,-y+1/2,-z',
        'x,-y,z',
        'x,y,-z',
        '-x+1/2,y+1/2,z',
        'x+1/2,y,z+1/2',
        '-x,y+1/2,-z+1/2',
        '-x,-y+1/2,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x,-y+1/2,-z+1/2',
        'x+1/2,-y,z+1/2',
        'x+1/2,y,-z+1/2',
        '-x,y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z+1/2',
        'x,-y,-z',
        '-x,y+1/2,-z+1/2',
        '-x,-y+1/2,-z+1/2',
        'x,y,-z',
        '-x,y+1/2,z+1/2',
        'x,-y,z',
    ]
},

{
    number          => 63,
    hall            => '-C 2c 2 (y+1/4,-x+1/2,z-1/4)',
    schoenflies     => 'D2h^17',
    hermann_mauguin => 'C m c m (b+1/2,-a-1/4,c+1/4)',
    universal_h_m   => 'C m c m (b+1/2,-a-1/4,c+1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        '-x+1/2,y,-z+1/2',
        'x,-y,-z',
        '-x+1/2,-y,-z+1/2',
        'x,y,-z',
        'x,-y,z',
        '-x+1/2,y,z+1/2',
        'x+1/2,y+1/2,z',
        '-x,-y+1/2,z+1/2',
        '-x,y+1/2,-z+1/2',
        'x+1/2,-y+1/2,-z',
        '-x,-y+1/2,-z+1/2',
        'x+1/2,y+1/2,-z',
        'x+1/2,-y+1/2,z',
        '-x,y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z+1/2',
        'x,-y,-z',
        '-x,y+1/2,-z+1/2',
        '-x,-y+1/2,-z+1/2',
        'x,y,-z',
        '-x,y+1/2,z+1/2',
        'x,-y,z',
    ]
},

{
    number          => 71,
    hall            => '-I 2 2 (x+1/4,y,z)',
    schoenflies     => 'D2h^25',
    hermann_mauguin => 'I m m m (a-1/4,b,c)',
    universal_h_m   => 'I m m m (a-1/4,b,c)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y,z',
        'x,-y,-z',
        '-x+1/2,y,-z',
        '-x+1/2,-y,-z',
        'x,y,-z',
        '-x+1/2,y,z',
        'x,-y,z',
        'x+1/2,y+1/2,z+1/2',
        '-x,-y+1/2,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        '-x,y+1/2,-z+1/2',
        '-x,-y+1/2,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-x,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y+1/2,z+1/2',
        'x,-y,-z',
        '-x,y+1/2,-z+1/2',
        '-x,-y+1/2,-z+1/2',
        'x,y,-z',
        '-x,y+1/2,z+1/2',
        'x,-y,z',
    ]
},

{
    number          => 63,
    hall            => '-C 2c 2 (z-1/4,y+1/4,-x+1/2)',
    schoenflies     => 'D2h^17',
    hermann_mauguin => 'C m c m (c+1/2,b-1/4,-a+1/4)',
    universal_h_m   => 'C m c m (c+1/2,b-1/4,-a+1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,-y+1/2,z',
        '-x,y,-z',
        '-x+1/2,-y+1/2,-z',
        '-x,y,z',
        'x,y,-z',
        'x+1/2,-y+1/2,z',
        'x,y+1/2,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x+1/2,-y,z+1/2',
        '-x,y+1/2,-z+1/2',
        '-x+1/2,-y,-z+1/2',
        '-x,y+1/2,z+1/2',
        'x,y+1/2,-z+1/2',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x,y,-z',
        '-x+1/2,-y,-z+1/2',
        'x,y,-z',
        '-x,y,z',
        'x+1/2,-y,z+1/2',
    ]
},

{
    number          => 63,
    hall            => '-C 2c 2 (x+1/2,y+1/4,z-1/4)',
    schoenflies     => 'D2h^17',
    hermann_mauguin => 'C m c m (a+1/2,b-1/4,c+1/4)',
    universal_h_m   => 'C m c m (a+1/2,b-1/4,c+1/4)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z+1/2',
        'x,-y+1/2,-z+1/2',
        '-x,y,-z',
        '-x,-y+1/2,-z+1/2',
        'x,y,-z',
        '-x,y,z',
        'x,-y+1/2,z+1/2',
        'x+1/2,y+1/2,z',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x+1/2,y+1/2,-z',
        '-x+1/2,-y,-z+1/2',
        'x+1/2,y+1/2,-z',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x,y,-z',
        '-x+1/2,-y,-z+1/2',
        'x,y,-z',
        '-x,y,z',
        'x+1/2,-y,z+1/2',
    ]
},

{
    number          => 71,
    hall            => '-I 2 2 (x,y+1/4,z)',
    schoenflies     => 'D2h^25',
    hermann_mauguin => 'I m m m (a,b-1/4,c)',
    universal_h_m   => 'I m m m (a,b-1/4,c)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y+1/2,z',
        'x,-y+1/2,-z',
        '-x,y,-z',
        '-x,-y+1/2,-z',
        'x,y,-z',
        '-x,y,z',
        'x,-y+1/2,z',
        'x+1/2,y+1/2,z+1/2',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-x+1/2,-y,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y,-z+1/2',
        '-x,y,-z',
        '-x+1/2,-y,-z+1/2',
        'x,y,-z',
        '-x,y,z',
        'x+1/2,-y,z+1/2',
    ]
},

{
    number          => 87,
    hall            => '-I 4 (1/2*x+1/2*y,-1/2*x+1/2*y,z)',
    schoenflies     => 'C4h^5',
    hermann_mauguin => 'I 4/m (a+b,-a+b,c)',
    universal_h_m   => 'I 4/m (a+b,-a+b,c)',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        '-x,-y,-z',
        'y,-x,-z',
        'x,y,-z',
        '-y,x,-z',
        'x+1/2,y+1/2,z',
        '-y+1/2,x+1/2,z',
        '-x+1/2,-y+1/2,z',
        'y+1/2,-x+1/2,z',
        '-x+1/2,-y+1/2,-z',
        'y+1/2,-x+1/2,-z',
        'x+1/2,y+1/2,-z',
        '-y+1/2,x+1/2,-z',
        'x+1/2,y,z+1/2',
        '-y+1/2,x,z+1/2',
        '-x+1/2,-y,z+1/2',
        'y+1/2,-x,z+1/2',
        '-x+1/2,-y,-z+1/2',
        'y+1/2,-x,-z+1/2',
        'x+1/2,y,-z+1/2',
        '-y+1/2,x,-z+1/2',
        'x,y+1/2,z+1/2',
        '-y,x+1/2,z+1/2',
        '-x,-y+1/2,z+1/2',
        'y,-x+1/2,z+1/2',
        '-x,-y+1/2,-z+1/2',
        'y,-x+1/2,-z+1/2',
        'x,y+1/2,-z+1/2',
        '-y,x+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        '-x,-y,-z',
        'y,-x,-z',
        'x,y,-z',
        '-y,x,-z',
    ]
},

{
    number          => 83,
    hall            => '-P 4 (1/2*x+1/2*y,-1/2*x+1/2*y,z)',
    schoenflies     => 'C4h^1',
    hermann_mauguin => 'P 4/m (a+b,-a+b,c)',
    universal_h_m   => 'P 4/m (a+b,-a+b,c)',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        '-x,-y,-z',
        'y,-x,-z',
        'x,y,-z',
        '-y,x,-z',
        'x+1/2,y+1/2,z',
        '-y+1/2,x+1/2,z',
        '-x+1/2,-y+1/2,z',
        'y+1/2,-x+1/2,z',
        '-x+1/2,-y+1/2,-z',
        'y+1/2,-x+1/2,-z',
        'x+1/2,y+1/2,-z',
        '-y+1/2,x+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        '-x,-y,-z',
        'y,-x,-z',
        'x,y,-z',
        '-y,x,-z',
    ]
},

{
    number          => 87,
    hall            => '-I 4 (1/2*x+1/2*y-1/4,-1/2*x+1/2*y+1/4,z)',
    schoenflies     => 'C4h^5',
    hermann_mauguin => 'I 4/m (a+b+1/2,-a+b,c)',
    universal_h_m   => 'I 4/m (a+b+1/2,-a+b,c)',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x+1/2,z',
        '-x+1/2,-y+1/2,z',
        'y+1/2,-x,z',
        '-x+1/2,-y+1/2,-z',
        'y+1/2,-x,-z',
        'x,y,-z',
        '-y,x+1/2,-z',
        'x+1/2,y+1/2,z',
        '-y+1/2,x,z',
        '-x,-y,z',
        'y,-x+1/2,z',
        '-x,-y,-z',
        'y,-x+1/2,-z',
        'x+1/2,y+1/2,-z',
        '-y+1/2,x,-z',
        'x+1/2,y,z+1/2',
        '-y+1/2,x+1/2,z+1/2',
        '-x,-y+1/2,z+1/2',
        'y,-x,z+1/2',
        '-x,-y+1/2,-z+1/2',
        'y,-x,-z+1/2',
        'x+1/2,y,-z+1/2',
        '-y+1/2,x+1/2,-z+1/2',
        'x,y+1/2,z+1/2',
        '-y,x,z+1/2',
        '-x+1/2,-y,z+1/2',
        'y+1/2,-x+1/2,z+1/2',
        '-x+1/2,-y,-z+1/2',
        'y+1/2,-x+1/2,-z+1/2',
        'x,y+1/2,-z+1/2',
        '-y,x,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z+1/2',
        '-x,-y,z',
        'y,-x,z+1/2',
        '-x,-y,-z',
        'y,-x,-z+1/2',
        'x,y,-z',
        '-y,x,-z+1/2',
    ]
},

{
    number          => 84,
    hall            => '-P 4c (1/2*x+1/2*y,-1/2*x+1/2*y,z)',
    schoenflies     => 'C4h^2',
    hermann_mauguin => 'P 42/m (a+b,-a+b,c)',
    universal_h_m   => 'P 42/m (a+b,-a+b,c)',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z+1/2',
        '-x,-y,z',
        'y,-x,z+1/2',
        '-x,-y,-z',
        'y,-x,-z+1/2',
        'x,y,-z',
        '-y,x,-z+1/2',
        'x+1/2,y+1/2,z',
        '-y+1/2,x+1/2,z+1/2',
        '-x+1/2,-y+1/2,z',
        'y+1/2,-x+1/2,z+1/2',
        '-x+1/2,-y+1/2,-z',
        'y+1/2,-x+1/2,-z+1/2',
        'x+1/2,y+1/2,-z',
        '-y+1/2,x+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z+1/2',
        '-x,-y,z',
        'y,-x,z+1/2',
        '-x,-y,-z',
        'y,-x,-z+1/2',
        'x,y,-z',
        '-y,x,-z+1/2',
    ]
},

{
    number          => 87,
    hall            => '-I 4 (x+1/2,y,z)',
    schoenflies     => 'C4h^5',
    hermann_mauguin => 'I 4/m (a+1/2,b,c)',
    universal_h_m   => 'I 4/m (a+1/2,b,c)',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x+1/2,z',
        '-x,-y,z',
        'y+1/2,-x+1/2,z',
        '-x,-y,-z',
        'y+1/2,-x+1/2,-z',
        'x,y,-z',
        '-y+1/2,x+1/2,-z',
        'x+1/2,y+1/2,z+1/2',
        '-y,x,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        'y,-x,z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        'y,-x,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-y,x,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z+1/2',
        '-x,-y,z',
        'y,-x,z+1/2',
        '-x,-y,-z',
        'y,-x,-z+1/2',
        'x,y,-z',
        '-y,x,-z+1/2',
    ]
},

{
    number          => 87,
    hall            => '-I 4 (x+1/2,y,z+1/4)',
    schoenflies     => 'C4h^5',
    hermann_mauguin => 'I 4/m (a+1/2,b,c-1/4)',
    universal_h_m   => 'I 4/m (a+1/2,b,c-1/4)',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x+1/2,z',
        '-x,-y,z',
        'y+1/2,-x+1/2,z',
        '-x,-y,-z+1/2',
        'y+1/2,-x+1/2,-z+1/2',
        'x,y,-z+1/2',
        '-y+1/2,x+1/2,-z+1/2',
        'x+1/2,y+1/2,z+1/2',
        '-y,x,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        'y,-x,z+1/2',
        '-x+1/2,-y+1/2,-z',
        'y,-x,-z',
        'x+1/2,y+1/2,-z',
        '-y,x,-z',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x+1/2,z',
        '-x,-y,z',
        'y+1/2,-x+1/2,z',
        '-x+1/2,-y+1/2,-z',
        'y,-x,-z',
        'x+1/2,y+1/2,-z',
        '-y,x,-z',
    ]
},

{
    number          => 83,
    hall            => '-P 4 (1/2*x+1/2*y-1/4,-1/2*x+1/2*y-1/4,z)',
    schoenflies     => 'C4h^1',
    hermann_mauguin => 'P 4/m (a+b,-a+b+1/2,c)',
    universal_h_m   => 'P 4/m (a+b,-a+b+1/2,c)',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x,z',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z',
        '-x+1/2,-y+1/2,-z',
        'y,-x+1/2,-z',
        'x,y,-z',
        '-y+1/2,x,-z',
        'x+1/2,y+1/2,z',
        '-y,x+1/2,z',
        '-x,-y,z',
        'y+1/2,-x,z',
        '-x,-y,-z',
        'y+1/2,-x,-z',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x,z',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z',
        '-x,-y,-z',
        'y+1/2,-x,-z',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z',
    ]
},

{
    number          => 87,
    hall            => '-I 4 (x+1/4,y+1/4,z-1/4)',
    schoenflies     => 'C4h^5',
    hermann_mauguin => 'I 4/m (a-1/4,b-1/4,c+1/4)',
    universal_h_m   => 'I 4/m (a-1/4,b-1/4,c+1/4)',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x,z',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z',
        '-x+1/2,-y+1/2,-z+1/2',
        'y,-x+1/2,-z+1/2',
        'x,y,-z+1/2',
        '-y+1/2,x,-z+1/2',
        'x+1/2,y+1/2,z+1/2',
        '-y,x+1/2,z+1/2',
        '-x,-y,z+1/2',
        'y+1/2,-x,z+1/2',
        '-x,-y,-z',
        'y+1/2,-x,-z',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x,z',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z',
        '-x,-y,-z',
        'y+1/2,-x,-z',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z',
    ]
},

{
    number          => 87,
    hall            => '-I 4 (1/2*x+1/2*y-1/4,-1/2*x+1/2*y+1/4,z+1/4)',
    schoenflies     => 'C4h^5',
    hermann_mauguin => 'I 4/m (a+b+1/2,-a+b,c-1/4)',
    universal_h_m   => 'I 4/m (a+b+1/2,-a+b,c-1/4)',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x+1/2,z',
        '-x+1/2,-y+1/2,z',
        'y+1/2,-x,z',
        '-x+1/2,-y+1/2,-z+1/2',
        'y+1/2,-x,-z+1/2',
        'x,y,-z+1/2',
        '-y,x+1/2,-z+1/2',
        'x+1/2,y+1/2,z',
        '-y+1/2,x,z',
        '-x,-y,z',
        'y,-x+1/2,z',
        '-x,-y,-z+1/2',
        'y,-x+1/2,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-y+1/2,x,-z+1/2',
        'x+1/2,y,z+1/2',
        '-y+1/2,x+1/2,z+1/2',
        '-x,-y+1/2,z+1/2',
        'y,-x,z+1/2',
        '-x,-y+1/2,-z',
        'y,-x,-z',
        'x+1/2,y,-z',
        '-y+1/2,x+1/2,-z',
        'x,y+1/2,z+1/2',
        '-y,x,z+1/2',
        '-x+1/2,-y,z+1/2',
        'y+1/2,-x+1/2,z+1/2',
        '-x+1/2,-y,-z',
        'y+1/2,-x+1/2,-z',
        'x,y+1/2,-z',
        '-y,x,-z',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x+1/2,z+1/2',
        '-x,-y,z',
        'y+1/2,-x+1/2,z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        'y,-x,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-y,x,-z',
    ]
},

{
    number          => 84,
    hall            => '-P 4c (1/2*x+1/2*y,-1/2*x+1/2*y,z+1/4)',
    schoenflies     => 'C4h^2',
    hermann_mauguin => 'P 42/m (a+b,-a+b,c-1/4)',
    universal_h_m   => 'P 42/m (a+b,-a+b,c-1/4)',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z+1/2',
        '-x,-y,z',
        'y,-x,z+1/2',
        '-x,-y,-z+1/2',
        'y,-x,-z',
        'x,y,-z+1/2',
        '-y,x,-z',
        'x+1/2,y+1/2,z',
        '-y+1/2,x+1/2,z+1/2',
        '-x+1/2,-y+1/2,z',
        'y+1/2,-x+1/2,z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        'y+1/2,-x+1/2,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-y+1/2,x+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x+1/2,z+1/2',
        '-x,-y,z',
        'y+1/2,-x+1/2,z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        'y,-x,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-y,x,-z',
    ]
},

{
    number          => 84,
    hall            => '-P 4c (1/2*x+1/2*y-1/4,-1/2*x+1/2*y-1/4,z)',
    schoenflies     => 'C4h^2',
    hermann_mauguin => 'P 42/m (a+b,-a+b+1/2,c)',
    universal_h_m   => 'P 42/m (a+b,-a+b+1/2,c)',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x,z+1/2',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z+1/2',
        '-x+1/2,-y+1/2,-z',
        'y,-x+1/2,-z+1/2',
        'x,y,-z',
        '-y+1/2,x,-z+1/2',
        'x+1/2,y+1/2,z',
        '-y,x+1/2,z+1/2',
        '-x,-y,z',
        'y+1/2,-x,z+1/2',
        '-x,-y,-z',
        'y+1/2,-x,-z+1/2',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y,x+1/2,z+1/2',
        '-x+1/2,-y+1/2,z',
        'y+1/2,-x,z+1/2',
        '-x,-y,-z',
        'y,-x+1/2,-z+1/2',
        'x+1/2,y+1/2,-z',
        '-y+1/2,x,-z+1/2',
    ]
},

{
    number          => 139,
    hall            => '-I 4 2 (1/2*x+1/2*y,-1/2*x+1/2*y,z)',
    schoenflies     => 'D4h^17',
    hermann_mauguin => 'I 4/m m m (a+b,-a+b,c)',
    universal_h_m   => 'I 4/m m m (a+b,-a+b,c)',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        '-y,-x,-z',
        'x,-y,-z',
        'y,x,-z',
        '-x,y,-z',
        '-x,-y,-z',
        'y,-x,-z',
        'x,y,-z',
        '-y,x,-z',
        'y,x,z',
        '-x,y,z',
        '-y,-x,z',
        'x,-y,z',
        'x+1/2,y+1/2,z',
        '-y+1/2,x+1/2,z',
        '-x+1/2,-y+1/2,z',
        'y+1/2,-x+1/2,z',
        '-y+1/2,-x+1/2,-z',
        'x+1/2,-y+1/2,-z',
        'y+1/2,x+1/2,-z',
        '-x+1/2,y+1/2,-z',
        '-x+1/2,-y+1/2,-z',
        'y+1/2,-x+1/2,-z',
        'x+1/2,y+1/2,-z',
        '-y+1/2,x+1/2,-z',
        'y+1/2,x+1/2,z',
        '-x+1/2,y+1/2,z',
        '-y+1/2,-x+1/2,z',
        'x+1/2,-y+1/2,z',
        'x+1/2,y,z+1/2',
        '-y+1/2,x,z+1/2',
        '-x+1/2,-y,z+1/2',
        'y+1/2,-x,z+1/2',
        '-y+1/2,-x,-z+1/2',
        'x+1/2,-y,-z+1/2',
        'y+1/2,x,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-x+1/2,-y,-z+1/2',
        'y+1/2,-x,-z+1/2',
        'x+1/2,y,-z+1/2',
        '-y+1/2,x,-z+1/2',
        'y+1/2,x,z+1/2',
        '-x+1/2,y,z+1/2',
        '-y+1/2,-x,z+1/2',
        'x+1/2,-y,z+1/2',
        'x,y+1/2,z+1/2',
        '-y,x+1/2,z+1/2',
        '-x,-y+1/2,z+1/2',
        'y,-x+1/2,z+1/2',
        '-y,-x+1/2,-z+1/2',
        'x,-y+1/2,-z+1/2',
        'y,x+1/2,-z+1/2',
        '-x,y+1/2,-z+1/2',
        '-x,-y+1/2,-z+1/2',
        'y,-x+1/2,-z+1/2',
        'x,y+1/2,-z+1/2',
        '-y,x+1/2,-z+1/2',
        'y,x+1/2,z+1/2',
        '-x,y+1/2,z+1/2',
        '-y,-x+1/2,z+1/2',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x,-y,-z',
        'y,x,-z',
        '-x,y,-z',
        '-y,-x,-z',
        '-x,-y,-z',
        'y,-x,-z',
        'x,y,-z',
        '-y,x,-z',
        '-x,y,z',
        '-y,-x,z',
        'x,-y,z',
        'y,x,z',
    ]
},

{
    number          => 123,
    hall            => '-P 4 2 (1/2*x+1/2*y,-1/2*x+1/2*y,z)',
    schoenflies     => 'D4h^1',
    hermann_mauguin => 'P 4/m m m (a+b,-a+b,c)',
    universal_h_m   => 'P 4/m m m (a+b,-a+b,c)',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        '-y,-x,-z',
        'x,-y,-z',
        'y,x,-z',
        '-x,y,-z',
        '-x,-y,-z',
        'y,-x,-z',
        'x,y,-z',
        '-y,x,-z',
        'y,x,z',
        '-x,y,z',
        '-y,-x,z',
        'x,-y,z',
        'x+1/2,y+1/2,z',
        '-y+1/2,x+1/2,z',
        '-x+1/2,-y+1/2,z',
        'y+1/2,-x+1/2,z',
        '-y+1/2,-x+1/2,-z',
        'x+1/2,-y+1/2,-z',
        'y+1/2,x+1/2,-z',
        '-x+1/2,y+1/2,-z',
        '-x+1/2,-y+1/2,-z',
        'y+1/2,-x+1/2,-z',
        'x+1/2,y+1/2,-z',
        '-y+1/2,x+1/2,-z',
        'y+1/2,x+1/2,z',
        '-x+1/2,y+1/2,z',
        '-y+1/2,-x+1/2,z',
        'x+1/2,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x,-y,-z',
        'y,x,-z',
        '-x,y,-z',
        '-y,-x,-z',
        '-x,-y,-z',
        'y,-x,-z',
        'x,y,-z',
        '-y,x,-z',
        '-x,y,z',
        '-y,-x,z',
        'x,-y,z',
        'y,x,z',
    ]
},

{
    number          => 140,
    hall            => '-I 4 2c (1/2*x+1/2*y,-1/2*x+1/2*y,z)',
    schoenflies     => 'D4h^18',
    hermann_mauguin => 'I 4/m c m (a+b,-a+b,c)',
    universal_h_m   => 'I 4/m c m (a+b,-a+b,c)',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        '-y,-x,-z+1/2',
        'x,-y,-z+1/2',
        'y,x,-z+1/2',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'y,-x,-z',
        'x,y,-z',
        '-y,x,-z',
        'y,x,z+1/2',
        '-x,y,z+1/2',
        '-y,-x,z+1/2',
        'x,-y,z+1/2',
        'x+1/2,y+1/2,z',
        '-y+1/2,x+1/2,z',
        '-x+1/2,-y+1/2,z',
        'y+1/2,-x+1/2,z',
        '-y+1/2,-x+1/2,-z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        'y+1/2,x+1/2,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-x+1/2,-y+1/2,-z',
        'y+1/2,-x+1/2,-z',
        'x+1/2,y+1/2,-z',
        '-y+1/2,x+1/2,-z',
        'y+1/2,x+1/2,z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        '-y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        'x+1/2,y,z+1/2',
        '-y+1/2,x,z+1/2',
        '-x+1/2,-y,z+1/2',
        'y+1/2,-x,z+1/2',
        '-y+1/2,-x,-z',
        'x+1/2,-y,-z',
        'y+1/2,x,-z',
        '-x+1/2,y,-z',
        '-x+1/2,-y,-z+1/2',
        'y+1/2,-x,-z+1/2',
        'x+1/2,y,-z+1/2',
        '-y+1/2,x,-z+1/2',
        'y+1/2,x,z',
        '-x+1/2,y,z',
        '-y+1/2,-x,z',
        'x+1/2,-y,z',
        'x,y+1/2,z+1/2',
        '-y,x+1/2,z+1/2',
        '-x,-y+1/2,z+1/2',
        'y,-x+1/2,z+1/2',
        '-y,-x+1/2,-z',
        'x,-y+1/2,-z',
        'y,x+1/2,-z',
        '-x,y+1/2,-z',
        '-x,-y+1/2,-z+1/2',
        'y,-x+1/2,-z+1/2',
        'x,y+1/2,-z+1/2',
        '-y,x+1/2,-z+1/2',
        'y,x+1/2,z',
        '-x,y+1/2,z',
        '-y,-x+1/2,z',
        'x,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x,-y,-z+1/2',
        'y,x,-z+1/2',
        '-x,y,-z+1/2',
        '-y,-x,-z+1/2',
        '-x,-y,-z',
        'y,-x,-z',
        'x,y,-z',
        '-y,x,-z',
        '-x,y,z+1/2',
        '-y,-x,z+1/2',
        'x,-y,z+1/2',
        'y,x,z+1/2',
    ]
},

{
    number          => 124,
    hall            => '-P 4 2c (1/2*x+1/2*y,-1/2*x+1/2*y,z)',
    schoenflies     => 'D4h^2',
    hermann_mauguin => 'P 4/m c c (a+b,-a+b,c)',
    universal_h_m   => 'P 4/m c c (a+b,-a+b,c)',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        '-y,-x,-z+1/2',
        'x,-y,-z+1/2',
        'y,x,-z+1/2',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'y,-x,-z',
        'x,y,-z',
        '-y,x,-z',
        'y,x,z+1/2',
        '-x,y,z+1/2',
        '-y,-x,z+1/2',
        'x,-y,z+1/2',
        'x+1/2,y+1/2,z',
        '-y+1/2,x+1/2,z',
        '-x+1/2,-y+1/2,z',
        'y+1/2,-x+1/2,z',
        '-y+1/2,-x+1/2,-z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        'y+1/2,x+1/2,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-x+1/2,-y+1/2,-z',
        'y+1/2,-x+1/2,-z',
        'x+1/2,y+1/2,-z',
        '-y+1/2,x+1/2,-z',
        'y+1/2,x+1/2,z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        '-y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x,-y,-z+1/2',
        'y,x,-z+1/2',
        '-x,y,-z+1/2',
        '-y,-x,-z+1/2',
        '-x,-y,-z',
        'y,-x,-z',
        'x,y,-z',
        '-y,x,-z',
        '-x,y,z+1/2',
        '-y,-x,z+1/2',
        'x,-y,z+1/2',
        'y,x,z+1/2',
    ]
},

{
    number          => 140,
    hall            => '-I 4 2c (x,y,z-1/4)',
    schoenflies     => 'D4h^18',
    hermann_mauguin => 'I 4/m c m (a,b,c+1/4)',
    universal_h_m   => 'I 4/m c m (a,b,c+1/4)',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x,-y,-z',
        'y,x,-z',
        '-x,y,-z',
        '-y,-x,-z',
        '-x,-y,-z+1/2',
        'y,-x,-z+1/2',
        'x,y,-z+1/2',
        '-y,x,-z+1/2',
        '-x,y,z+1/2',
        '-y,-x,z+1/2',
        'x,-y,z+1/2',
        'y,x,z+1/2',
        'x+1/2,y+1/2,z+1/2',
        '-y+1/2,x+1/2,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        'y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        'y+1/2,x+1/2,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-y+1/2,-x+1/2,-z+1/2',
        '-x+1/2,-y+1/2,-z',
        'y+1/2,-x+1/2,-z',
        'x+1/2,y+1/2,-z',
        '-y+1/2,x+1/2,-z',
        '-x+1/2,y+1/2,z',
        '-y+1/2,-x+1/2,z',
        'x+1/2,-y+1/2,z',
        'y+1/2,x+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x,-y,-z',
        'y,x,-z',
        '-x,y,-z',
        '-y,-x,-z',
        '-x+1/2,-y+1/2,-z',
        'y+1/2,-x+1/2,-z',
        'x+1/2,y+1/2,-z',
        '-y+1/2,x+1/2,-z',
        '-x+1/2,y+1/2,z',
        '-y+1/2,-x+1/2,z',
        'x+1/2,-y+1/2,z',
        'y+1/2,x+1/2,z',
    ]
},

{
    number          => 139,
    hall            => '-I 4 2 (1/2*x+1/2*y-1/4,-1/2*x+1/2*y+1/4,z)',
    schoenflies     => 'D4h^17',
    hermann_mauguin => 'I 4/m m m (a+b+1/2,-a+b,c)',
    universal_h_m   => 'I 4/m m m (a+b+1/2,-a+b,c)',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x+1/2,z',
        '-x+1/2,-y+1/2,z',
        'y+1/2,-x,z',
        '-y,-x,-z',
        'x,-y+1/2,-z',
        'y+1/2,x+1/2,-z',
        '-x+1/2,y,-z',
        '-x+1/2,-y+1/2,-z',
        'y+1/2,-x,-z',
        'x,y,-z',
        '-y,x+1/2,-z',
        'y+1/2,x+1/2,z',
        '-x+1/2,y,z',
        '-y,-x,z',
        'x,-y+1/2,z',
        'x+1/2,y+1/2,z',
        '-y+1/2,x,z',
        '-x,-y,z',
        'y,-x+1/2,z',
        '-y+1/2,-x+1/2,-z',
        'x+1/2,-y,-z',
        'y,x,-z',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'y,-x+1/2,-z',
        'x+1/2,y+1/2,-z',
        '-y+1/2,x,-z',
        'y,x,z',
        '-x,y+1/2,z',
        '-y+1/2,-x+1/2,z',
        'x+1/2,-y,z',
        'x+1/2,y,z+1/2',
        '-y+1/2,x+1/2,z+1/2',
        '-x,-y+1/2,z+1/2',
        'y,-x,z+1/2',
        '-y+1/2,-x,-z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        'y,x+1/2,-z+1/2',
        '-x,y,-z+1/2',
        '-x,-y+1/2,-z+1/2',
        'y,-x,-z+1/2',
        'x+1/2,y,-z+1/2',
        '-y+1/2,x+1/2,-z+1/2',
        'y,x+1/2,z+1/2',
        '-x,y,z+1/2',
        '-y+1/2,-x,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        'x,y+1/2,z+1/2',
        '-y,x,z+1/2',
        '-x+1/2,-y,z+1/2',
        'y+1/2,-x+1/2,z+1/2',
        '-y,-x+1/2,-z+1/2',
        'x,-y,-z+1/2',
        'y+1/2,x,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-x+1/2,-y,-z+1/2',
        'y+1/2,-x+1/2,-z+1/2',
        'x,y+1/2,-z+1/2',
        '-y,x,-z+1/2',
        'y+1/2,x,z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        '-y,-x+1/2,z+1/2',
        'x,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x,z',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z',
        'x,-y+1/2,-z',
        'y,x,-z',
        '-x+1/2,y,-z',
        '-y+1/2,-x+1/2,-z',
        '-x,-y,-z',
        'y+1/2,-x,-z',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z',
        '-x,y+1/2,z',
        '-y,-x,z',
        'x+1/2,-y,z',
        'y+1/2,x+1/2,z',
    ]
},

{
    number          => 123,
    hall            => '-P 4 2 (1/2*x+1/2*y-1/4,-1/2*x+1/2*y-1/4,z)',
    schoenflies     => 'D4h^1',
    hermann_mauguin => 'P 4/m m m (a+b,-a+b+1/2,c)',
    universal_h_m   => 'P 4/m m m (a+b,-a+b+1/2,c)',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x,z',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z',
        '-y+1/2,-x+1/2,-z',
        'x,-y+1/2,-z',
        'y,x,-z',
        '-x+1/2,y,-z',
        '-x+1/2,-y+1/2,-z',
        'y,-x+1/2,-z',
        'x,y,-z',
        '-y+1/2,x,-z',
        'y,x,z',
        '-x+1/2,y,z',
        '-y+1/2,-x+1/2,z',
        'x,-y+1/2,z',
        'x+1/2,y+1/2,z',
        '-y,x+1/2,z',
        '-x,-y,z',
        'y+1/2,-x,z',
        '-y,-x,-z',
        'x+1/2,-y,-z',
        'y+1/2,x+1/2,-z',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'y+1/2,-x,-z',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z',
        'y+1/2,x+1/2,z',
        '-x,y+1/2,z',
        '-y,-x,z',
        'x+1/2,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x,z',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z',
        'x,-y+1/2,-z',
        'y,x,-z',
        '-x+1/2,y,-z',
        '-y+1/2,-x+1/2,-z',
        '-x,-y,-z',
        'y+1/2,-x,-z',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z',
        '-x,y+1/2,z',
        '-y,-x,z',
        'x+1/2,-y,z',
        'y+1/2,x+1/2,z',
    ]
},

{
    number          => 140,
    hall            => '-I 4 2c (x+1/4,y+1/4,z-1/4)',
    schoenflies     => 'D4h^18',
    hermann_mauguin => 'I 4/m c m (a-1/4,b-1/4,c+1/4)',
    universal_h_m   => 'I 4/m c m (a-1/4,b-1/4,c+1/4)',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x,z',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z',
        'x,-y+1/2,-z',
        'y,x,-z',
        '-x+1/2,y,-z',
        '-y+1/2,-x+1/2,-z',
        '-x+1/2,-y+1/2,-z+1/2',
        'y,-x+1/2,-z+1/2',
        'x,y,-z+1/2',
        '-y+1/2,x,-z+1/2',
        '-x+1/2,y,z+1/2',
        '-y+1/2,-x+1/2,z+1/2',
        'x,-y+1/2,z+1/2',
        'y,x,z+1/2',
        'x+1/2,y+1/2,z+1/2',
        '-y,x+1/2,z+1/2',
        '-x,-y,z+1/2',
        'y+1/2,-x,z+1/2',
        'x+1/2,-y,-z+1/2',
        'y+1/2,x+1/2,-z+1/2',
        '-x,y+1/2,-z+1/2',
        '-y,-x,-z+1/2',
        '-x,-y,-z',
        'y+1/2,-x,-z',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z',
        '-x,y+1/2,z',
        '-y,-x,z',
        'x+1/2,-y,z',
        'y+1/2,x+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x,z',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z',
        'x,-y+1/2,-z',
        'y,x,-z',
        '-x+1/2,y,-z',
        '-y+1/2,-x+1/2,-z',
        '-x,-y,-z',
        'y+1/2,-x,-z',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z',
        '-x,y+1/2,z',
        '-y,-x,z',
        'x+1/2,-y,z',
        'y+1/2,x+1/2,z',
    ]
},

{
    number          => 140,
    hall            => '-I 4 2c (1/2*x+1/2*y,-1/2*x+1/2*y,z-1/4)',
    schoenflies     => 'D4h^18',
    hermann_mauguin => 'I 4/m c m (a+b,-a+b,c+1/4)',
    universal_h_m   => 'I 4/m c m (a+b,-a+b,c+1/4)',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        '-y,-x,-z',
        'x,-y,-z',
        'y,x,-z',
        '-x,y,-z',
        '-x,-y,-z+1/2',
        'y,-x,-z+1/2',
        'x,y,-z+1/2',
        '-y,x,-z+1/2',
        'y,x,z+1/2',
        '-x,y,z+1/2',
        '-y,-x,z+1/2',
        'x,-y,z+1/2',
        'x+1/2,y+1/2,z',
        '-y+1/2,x+1/2,z',
        '-x+1/2,-y+1/2,z',
        'y+1/2,-x+1/2,z',
        '-y+1/2,-x+1/2,-z',
        'x+1/2,-y+1/2,-z',
        'y+1/2,x+1/2,-z',
        '-x+1/2,y+1/2,-z',
        '-x+1/2,-y+1/2,-z+1/2',
        'y+1/2,-x+1/2,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-y+1/2,x+1/2,-z+1/2',
        'y+1/2,x+1/2,z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        '-y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        'x+1/2,y,z+1/2',
        '-y+1/2,x,z+1/2',
        '-x+1/2,-y,z+1/2',
        'y+1/2,-x,z+1/2',
        '-y+1/2,-x,-z+1/2',
        'x+1/2,-y,-z+1/2',
        'y+1/2,x,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-x+1/2,-y,-z',
        'y+1/2,-x,-z',
        'x+1/2,y,-z',
        '-y+1/2,x,-z',
        'y+1/2,x,z',
        '-x+1/2,y,z',
        '-y+1/2,-x,z',
        'x+1/2,-y,z',
        'x,y+1/2,z+1/2',
        '-y,x+1/2,z+1/2',
        '-x,-y+1/2,z+1/2',
        'y,-x+1/2,z+1/2',
        '-y,-x+1/2,-z+1/2',
        'x,-y+1/2,-z+1/2',
        'y,x+1/2,-z+1/2',
        '-x,y+1/2,-z+1/2',
        '-x,-y+1/2,-z',
        'y,-x+1/2,-z',
        'x,y+1/2,-z',
        '-y,x+1/2,-z',
        'y,x+1/2,z',
        '-x,y+1/2,z',
        '-y,-x+1/2,z',
        'x,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x,-y,-z',
        'y,x,-z',
        '-x,y,-z',
        '-y,-x,-z',
        '-x+1/2,-y+1/2,-z+1/2',
        'y+1/2,-x+1/2,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-y+1/2,x+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        '-y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        'y+1/2,x+1/2,z+1/2',
    ]
},

{
    number          => 124,
    hall            => '-P 4 2c (1/2*x+1/2*y,-1/2*x+1/2*y,z-1/4)',
    schoenflies     => 'D4h^2',
    hermann_mauguin => 'P 4/m c c (a+b,-a+b,c+1/4)',
    universal_h_m   => 'P 4/m c c (a+b,-a+b,c+1/4)',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        '-y,-x,-z',
        'x,-y,-z',
        'y,x,-z',
        '-x,y,-z',
        '-x,-y,-z+1/2',
        'y,-x,-z+1/2',
        'x,y,-z+1/2',
        '-y,x,-z+1/2',
        'y,x,z+1/2',
        '-x,y,z+1/2',
        '-y,-x,z+1/2',
        'x,-y,z+1/2',
        'x+1/2,y+1/2,z',
        '-y+1/2,x+1/2,z',
        '-x+1/2,-y+1/2,z',
        'y+1/2,-x+1/2,z',
        '-y+1/2,-x+1/2,-z',
        'x+1/2,-y+1/2,-z',
        'y+1/2,x+1/2,-z',
        '-x+1/2,y+1/2,-z',
        '-x+1/2,-y+1/2,-z+1/2',
        'y+1/2,-x+1/2,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-y+1/2,x+1/2,-z+1/2',
        'y+1/2,x+1/2,z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        '-y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x,-y,-z',
        'y,x,-z',
        '-x,y,-z',
        '-y,-x,-z',
        '-x+1/2,-y+1/2,-z+1/2',
        'y+1/2,-x+1/2,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-y+1/2,x+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        '-y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        'y+1/2,x+1/2,z+1/2',
    ]
},

{
    number          => 140,
    hall            => '-I 4 2c (1/2*x+1/2*y-1/4,-1/2*x+1/2*y+1/4,z)',
    schoenflies     => 'D4h^18',
    hermann_mauguin => 'I 4/m c m (a+b+1/2,-a+b,c)',
    universal_h_m   => 'I 4/m c m (a+b+1/2,-a+b,c)',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x+1/2,z',
        '-x+1/2,-y+1/2,z',
        'y+1/2,-x,z',
        '-y,-x,-z+1/2',
        'x,-y+1/2,-z+1/2',
        'y+1/2,x+1/2,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-x+1/2,-y+1/2,-z',
        'y+1/2,-x,-z',
        'x,y,-z',
        '-y,x+1/2,-z',
        'y+1/2,x+1/2,z+1/2',
        '-x+1/2,y,z+1/2',
        '-y,-x,z+1/2',
        'x,-y+1/2,z+1/2',
        'x+1/2,y+1/2,z',
        '-y+1/2,x,z',
        '-x,-y,z',
        'y,-x+1/2,z',
        '-y+1/2,-x+1/2,-z+1/2',
        'x+1/2,-y,-z+1/2',
        'y,x,-z+1/2',
        '-x,y+1/2,-z+1/2',
        '-x,-y,-z',
        'y,-x+1/2,-z',
        'x+1/2,y+1/2,-z',
        '-y+1/2,x,-z',
        'y,x,z+1/2',
        '-x,y+1/2,z+1/2',
        '-y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y,z+1/2',
        'x+1/2,y,z+1/2',
        '-y+1/2,x+1/2,z+1/2',
        '-x,-y+1/2,z+1/2',
        'y,-x,z+1/2',
        '-y+1/2,-x,-z',
        'x+1/2,-y+1/2,-z',
        'y,x+1/2,-z',
        '-x,y,-z',
        '-x,-y+1/2,-z+1/2',
        'y,-x,-z+1/2',
        'x+1/2,y,-z+1/2',
        '-y+1/2,x+1/2,-z+1/2',
        'y,x+1/2,z',
        '-x,y,z',
        '-y+1/2,-x,z',
        'x+1/2,-y+1/2,z',
        'x,y+1/2,z+1/2',
        '-y,x,z+1/2',
        '-x+1/2,-y,z+1/2',
        'y+1/2,-x+1/2,z+1/2',
        '-y,-x+1/2,-z',
        'x,-y,-z',
        'y+1/2,x,-z',
        '-x+1/2,y+1/2,-z',
        '-x+1/2,-y,-z+1/2',
        'y+1/2,-x+1/2,-z+1/2',
        'x,y+1/2,-z+1/2',
        '-y,x,-z+1/2',
        'y+1/2,x,z',
        '-x+1/2,y+1/2,z',
        '-y,-x+1/2,z',
        'x,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x,z',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z',
        'x,-y+1/2,-z+1/2',
        'y,x,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-y+1/2,-x+1/2,-z+1/2',
        '-x,-y,-z',
        'y+1/2,-x,-z',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z',
        '-x,y+1/2,z+1/2',
        '-y,-x,z+1/2',
        'x+1/2,-y,z+1/2',
        'y+1/2,x+1/2,z+1/2',
    ]
},

{
    number          => 124,
    hall            => '-P 4 2c (1/2*x+1/2*y-1/4,-1/2*x+1/2*y-1/4,z)',
    schoenflies     => 'D4h^2',
    hermann_mauguin => 'P 4/m c c (a+b,-a+b+1/2,c)',
    universal_h_m   => 'P 4/m c c (a+b,-a+b+1/2,c)',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x,z',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z',
        '-y+1/2,-x+1/2,-z+1/2',
        'x,-y+1/2,-z+1/2',
        'y,x,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-x+1/2,-y+1/2,-z',
        'y,-x+1/2,-z',
        'x,y,-z',
        '-y+1/2,x,-z',
        'y,x,z+1/2',
        '-x+1/2,y,z+1/2',
        '-y+1/2,-x+1/2,z+1/2',
        'x,-y+1/2,z+1/2',
        'x+1/2,y+1/2,z',
        '-y,x+1/2,z',
        '-x,-y,z',
        'y+1/2,-x,z',
        '-y,-x,-z+1/2',
        'x+1/2,-y,-z+1/2',
        'y+1/2,x+1/2,-z+1/2',
        '-x,y+1/2,-z+1/2',
        '-x,-y,-z',
        'y+1/2,-x,-z',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z',
        'y+1/2,x+1/2,z+1/2',
        '-x,y+1/2,z+1/2',
        '-y,-x,z+1/2',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x,z',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z',
        'x,-y+1/2,-z+1/2',
        'y,x,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-y+1/2,-x+1/2,-z+1/2',
        '-x,-y,-z',
        'y+1/2,-x,-z',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z',
        '-x,y+1/2,z+1/2',
        '-y,-x,z+1/2',
        'x+1/2,-y,z+1/2',
        'y+1/2,x+1/2,z+1/2',
    ]
},

{
    number          => 139,
    hall            => '-I 4 2 (x+1/4,y+1/4,z-1/4)',
    schoenflies     => 'D4h^17',
    hermann_mauguin => 'I 4/m m m (a-1/4,b-1/4,c+1/4)',
    universal_h_m   => 'I 4/m m m (a-1/4,b-1/4,c+1/4)',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x,z',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z',
        'x,-y+1/2,-z+1/2',
        'y,x,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-y+1/2,-x+1/2,-z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        'y,-x+1/2,-z+1/2',
        'x,y,-z+1/2',
        '-y+1/2,x,-z+1/2',
        '-x+1/2,y,z',
        '-y+1/2,-x+1/2,z',
        'x,-y+1/2,z',
        'y,x,z',
        'x+1/2,y+1/2,z+1/2',
        '-y,x+1/2,z+1/2',
        '-x,-y,z+1/2',
        'y+1/2,-x,z+1/2',
        'x+1/2,-y,-z',
        'y+1/2,x+1/2,-z',
        '-x,y+1/2,-z',
        '-y,-x,-z',
        '-x,-y,-z',
        'y+1/2,-x,-z',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z',
        '-x,y+1/2,z+1/2',
        '-y,-x,z+1/2',
        'x+1/2,-y,z+1/2',
        'y+1/2,x+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x,z',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z',
        'x,-y+1/2,-z+1/2',
        'y,x,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-y+1/2,-x+1/2,-z+1/2',
        '-x,-y,-z',
        'y+1/2,-x,-z',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z',
        '-x,y+1/2,z+1/2',
        '-y,-x,z+1/2',
        'x+1/2,-y,z+1/2',
        'y+1/2,x+1/2,z+1/2',
    ]
},

{
    number          => 139,
    hall            => '-I 4 2 (x+1/2,y,z+1/4)',
    schoenflies     => 'D4h^17',
    hermann_mauguin => 'I 4/m m m (a+1/2,b,c-1/4)',
    universal_h_m   => 'I 4/m m m (a+1/2,b,c-1/4)',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x+1/2,z',
        '-x,-y,z',
        'y+1/2,-x+1/2,z',
        'x,-y,-z+1/2',
        'y+1/2,x+1/2,-z+1/2',
        '-x,y,-z+1/2',
        '-y+1/2,-x+1/2,-z+1/2',
        '-x,-y,-z+1/2',
        'y+1/2,-x+1/2,-z+1/2',
        'x,y,-z+1/2',
        '-y+1/2,x+1/2,-z+1/2',
        '-x,y,z',
        '-y+1/2,-x+1/2,z',
        'x,-y,z',
        'y+1/2,x+1/2,z',
        'x+1/2,y+1/2,z+1/2',
        '-y,x,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        'y,-x,z+1/2',
        'x+1/2,-y+1/2,-z',
        'y,x,-z',
        '-x+1/2,y+1/2,-z',
        '-y,-x,-z',
        '-x+1/2,-y+1/2,-z',
        'y,-x,-z',
        'x+1/2,y+1/2,-z',
        '-y,x,-z',
        '-x+1/2,y+1/2,z+1/2',
        '-y,-x,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        'y,x,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x+1/2,z',
        '-x,-y,z',
        'y+1/2,-x+1/2,z',
        'x+1/2,-y+1/2,-z',
        'y,x,-z',
        '-x+1/2,y+1/2,-z',
        '-y,-x,-z',
        '-x+1/2,-y+1/2,-z',
        'y,-x,-z',
        'x+1/2,y+1/2,-z',
        '-y,x,-z',
        '-x,y,z',
        '-y+1/2,-x+1/2,z',
        'x,-y,z',
        'y+1/2,x+1/2,z',
    ]
},

{
    number          => 140,
    hall            => '-I 4 2c (x+1/2,y,z-1/4)',
    schoenflies     => 'D4h^18',
    hermann_mauguin => 'I 4/m c m (a+1/2,b,c+1/4)',
    universal_h_m   => 'I 4/m c m (a+1/2,b,c+1/4)',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x+1/2,z',
        '-x,-y,z',
        'y+1/2,-x+1/2,z',
        'x,-y,-z',
        'y+1/2,x+1/2,-z',
        '-x,y,-z',
        '-y+1/2,-x+1/2,-z',
        '-x,-y,-z+1/2',
        'y+1/2,-x+1/2,-z+1/2',
        'x,y,-z+1/2',
        '-y+1/2,x+1/2,-z+1/2',
        '-x,y,z+1/2',
        '-y+1/2,-x+1/2,z+1/2',
        'x,-y,z+1/2',
        'y+1/2,x+1/2,z+1/2',
        'x+1/2,y+1/2,z+1/2',
        '-y,x,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        'y,-x,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        'y,x,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-y,-x,-z+1/2',
        '-x+1/2,-y+1/2,-z',
        'y,-x,-z',
        'x+1/2,y+1/2,-z',
        '-y,x,-z',
        '-x+1/2,y+1/2,z',
        '-y,-x,z',
        'x+1/2,-y+1/2,z',
        'y,x,z',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x+1/2,z',
        '-x,-y,z',
        'y+1/2,-x+1/2,z',
        'x+1/2,-y+1/2,-z+1/2',
        'y,x,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-y,-x,-z+1/2',
        '-x+1/2,-y+1/2,-z',
        'y,-x,-z',
        'x+1/2,y+1/2,-z',
        '-y,x,-z',
        '-x,y,z+1/2',
        '-y+1/2,-x+1/2,z+1/2',
        'x,-y,z+1/2',
        'y+1/2,x+1/2,z+1/2',
    ]
},

{
    number          => 132,
    hall            => '-P 4c 2c (1/2*x+1/2*y,-1/2*x+1/2*y,z)',
    schoenflies     => 'D4h^10',
    hermann_mauguin => 'P 42/m c m (a+b,-a+b,c)',
    universal_h_m   => 'P 42/m c m (a+b,-a+b,c)',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z+1/2',
        '-x,-y,z',
        'y,-x,z+1/2',
        '-y,-x,-z+1/2',
        'x,-y,-z',
        'y,x,-z+1/2',
        '-x,y,-z',
        '-x,-y,-z',
        'y,-x,-z+1/2',
        'x,y,-z',
        '-y,x,-z+1/2',
        'y,x,z+1/2',
        '-x,y,z',
        '-y,-x,z+1/2',
        'x,-y,z',
        'x+1/2,y+1/2,z',
        '-y+1/2,x+1/2,z+1/2',
        '-x+1/2,-y+1/2,z',
        'y+1/2,-x+1/2,z+1/2',
        '-y+1/2,-x+1/2,-z+1/2',
        'x+1/2,-y+1/2,-z',
        'y+1/2,x+1/2,-z+1/2',
        '-x+1/2,y+1/2,-z',
        '-x+1/2,-y+1/2,-z',
        'y+1/2,-x+1/2,-z+1/2',
        'x+1/2,y+1/2,-z',
        '-y+1/2,x+1/2,-z+1/2',
        'y+1/2,x+1/2,z+1/2',
        '-x+1/2,y+1/2,z',
        '-y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z+1/2',
        '-x,-y,z',
        'y,-x,z+1/2',
        'x,-y,-z',
        'y,x,-z+1/2',
        '-x,y,-z',
        '-y,-x,-z+1/2',
        '-x,-y,-z',
        'y,-x,-z+1/2',
        'x,y,-z',
        '-y,x,-z+1/2',
        '-x,y,z',
        '-y,-x,z+1/2',
        'x,-y,z',
        'y,x,z+1/2',
    ]
},

{
    number          => 139,
    hall            => '-I 4 2 (x+1/2,y,z)',
    schoenflies     => 'D4h^17',
    hermann_mauguin => 'I 4/m m m (a+1/2,b,c)',
    universal_h_m   => 'I 4/m m m (a+1/2,b,c)',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x+1/2,z',
        '-x,-y,z',
        'y+1/2,-x+1/2,z',
        'x,-y,-z',
        'y+1/2,x+1/2,-z',
        '-x,y,-z',
        '-y+1/2,-x+1/2,-z',
        '-x,-y,-z',
        'y+1/2,-x+1/2,-z',
        'x,y,-z',
        '-y+1/2,x+1/2,-z',
        '-x,y,z',
        '-y+1/2,-x+1/2,z',
        'x,-y,z',
        'y+1/2,x+1/2,z',
        'x+1/2,y+1/2,z+1/2',
        '-y,x,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        'y,-x,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        'y,x,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-y,-x,-z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        'y,-x,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-y,x,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        '-y,-x,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        'y,x,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z+1/2',
        '-x,-y,z',
        'y,-x,z+1/2',
        'x,-y,-z',
        'y,x,-z+1/2',
        '-x,y,-z',
        '-y,-x,-z+1/2',
        '-x,-y,-z',
        'y,-x,-z+1/2',
        'x,y,-z',
        '-y,x,-z+1/2',
        '-x,y,z',
        '-y,-x,z+1/2',
        'x,-y,z',
        'y,x,z+1/2',
    ]
},

{
    number          => 131,
    hall            => '-P 4c 2 (1/2*x+1/2*y,-1/2*x+1/2*y,z)',
    schoenflies     => 'D4h^9',
    hermann_mauguin => 'P 42/m m c (a+b,-a+b,c)',
    universal_h_m   => 'P 42/m m c (a+b,-a+b,c)',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z+1/2',
        '-x,-y,z',
        'y,-x,z+1/2',
        '-y,-x,-z',
        'x,-y,-z+1/2',
        'y,x,-z',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'y,-x,-z+1/2',
        'x,y,-z',
        '-y,x,-z+1/2',
        'y,x,z',
        '-x,y,z+1/2',
        '-y,-x,z',
        'x,-y,z+1/2',
        'x+1/2,y+1/2,z',
        '-y+1/2,x+1/2,z+1/2',
        '-x+1/2,-y+1/2,z',
        'y+1/2,-x+1/2,z+1/2',
        '-y+1/2,-x+1/2,-z',
        'x+1/2,-y+1/2,-z+1/2',
        'y+1/2,x+1/2,-z',
        '-x+1/2,y+1/2,-z+1/2',
        '-x+1/2,-y+1/2,-z',
        'y+1/2,-x+1/2,-z+1/2',
        'x+1/2,y+1/2,-z',
        '-y+1/2,x+1/2,-z+1/2',
        'y+1/2,x+1/2,z',
        '-x+1/2,y+1/2,z+1/2',
        '-y+1/2,-x+1/2,z',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z+1/2',
        '-x,-y,z',
        'y,-x,z+1/2',
        'x,-y,-z+1/2',
        'y,x,-z',
        '-x,y,-z+1/2',
        '-y,-x,-z',
        '-x,-y,-z',
        'y,-x,-z+1/2',
        'x,y,-z',
        '-y,x,-z+1/2',
        '-x,y,z+1/2',
        '-y,-x,z',
        'x,-y,z+1/2',
        'y,x,z',
    ]
},

{
    number          => 140,
    hall            => '-I 4 2c (x+1/2,y,z)',
    schoenflies     => 'D4h^18',
    hermann_mauguin => 'I 4/m c m (a+1/2,b,c)',
    universal_h_m   => 'I 4/m c m (a+1/2,b,c)',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x+1/2,z',
        '-x,-y,z',
        'y+1/2,-x+1/2,z',
        'x,-y,-z+1/2',
        'y+1/2,x+1/2,-z+1/2',
        '-x,y,-z+1/2',
        '-y+1/2,-x+1/2,-z+1/2',
        '-x,-y,-z',
        'y+1/2,-x+1/2,-z',
        'x,y,-z',
        '-y+1/2,x+1/2,-z',
        '-x,y,z+1/2',
        '-y+1/2,-x+1/2,z+1/2',
        'x,-y,z+1/2',
        'y+1/2,x+1/2,z+1/2',
        'x+1/2,y+1/2,z+1/2',
        '-y,x,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        'y,-x,z+1/2',
        'x+1/2,-y+1/2,-z',
        'y,x,-z',
        '-x+1/2,y+1/2,-z',
        '-y,-x,-z',
        '-x+1/2,-y+1/2,-z+1/2',
        'y,-x,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-y,x,-z+1/2',
        '-x+1/2,y+1/2,z',
        '-y,-x,z',
        'x+1/2,-y+1/2,z',
        'y,x,z',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z+1/2',
        '-x,-y,z',
        'y,-x,z+1/2',
        'x,-y,-z+1/2',
        'y,x,-z',
        '-x,y,-z+1/2',
        '-y,-x,-z',
        '-x,-y,-z',
        'y,-x,-z+1/2',
        'x,y,-z',
        '-y,x,-z+1/2',
        '-x,y,z+1/2',
        '-y,-x,z',
        'x,-y,z+1/2',
        'y,x,z',
    ]
},

{
    number          => 140,
    hall            => '-I 4 2c (1/2*x+1/2*y-1/4,-1/2*x+1/2*y+1/4,z-1/4)',
    schoenflies     => 'D4h^18',
    hermann_mauguin => 'I 4/m c m (a+b+1/2,-a+b,c+1/4)',
    universal_h_m   => 'I 4/m c m (a+b+1/2,-a+b,c+1/4)',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x+1/2,z',
        '-x+1/2,-y+1/2,z',
        'y+1/2,-x,z',
        '-y,-x,-z',
        'x,-y+1/2,-z',
        'y+1/2,x+1/2,-z',
        '-x+1/2,y,-z',
        '-x+1/2,-y+1/2,-z+1/2',
        'y+1/2,-x,-z+1/2',
        'x,y,-z+1/2',
        '-y,x+1/2,-z+1/2',
        'y+1/2,x+1/2,z+1/2',
        '-x+1/2,y,z+1/2',
        '-y,-x,z+1/2',
        'x,-y+1/2,z+1/2',
        'x+1/2,y+1/2,z',
        '-y+1/2,x,z',
        '-x,-y,z',
        'y,-x+1/2,z',
        '-y+1/2,-x+1/2,-z',
        'x+1/2,-y,-z',
        'y,x,-z',
        '-x,y+1/2,-z',
        '-x,-y,-z+1/2',
        'y,-x+1/2,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-y+1/2,x,-z+1/2',
        'y,x,z+1/2',
        '-x,y+1/2,z+1/2',
        '-y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y,z+1/2',
        'x+1/2,y,z+1/2',
        '-y+1/2,x+1/2,z+1/2',
        '-x,-y+1/2,z+1/2',
        'y,-x,z+1/2',
        '-y+1/2,-x,-z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        'y,x+1/2,-z+1/2',
        '-x,y,-z+1/2',
        '-x,-y+1/2,-z',
        'y,-x,-z',
        'x+1/2,y,-z',
        '-y+1/2,x+1/2,-z',
        'y,x+1/2,z',
        '-x,y,z',
        '-y+1/2,-x,z',
        'x+1/2,-y+1/2,z',
        'x,y+1/2,z+1/2',
        '-y,x,z+1/2',
        '-x+1/2,-y,z+1/2',
        'y+1/2,-x+1/2,z+1/2',
        '-y,-x+1/2,-z+1/2',
        'x,-y,-z+1/2',
        'y+1/2,x,-z+1/2',
        '-x+1/2,y+1/2,-z+1/2',
        '-x+1/2,-y,-z',
        'y+1/2,-x+1/2,-z',
        'x,y+1/2,-z',
        '-y,x,-z',
        'y+1/2,x,z',
        '-x+1/2,y+1/2,z',
        '-y,-x+1/2,z',
        'x,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x+1/2,z+1/2',
        '-x,-y,z',
        'y+1/2,-x+1/2,z+1/2',
        'x,-y,-z+1/2',
        'y+1/2,x+1/2,-z',
        '-x,y,-z+1/2',
        '-y+1/2,-x+1/2,-z',
        '-x+1/2,-y+1/2,-z+1/2',
        'y,-x,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-y,x,-z',
        '-x+1/2,y+1/2,z',
        '-y,-x,z+1/2',
        'x+1/2,-y+1/2,z',
        'y,x,z+1/2',
    ]
},

{
    number          => 132,
    hall            => '-P 4c 2c (1/2*x+1/2*y,-1/2*x+1/2*y,z-1/4)',
    schoenflies     => 'D4h^10',
    hermann_mauguin => 'P 42/m c m (a+b,-a+b,c+1/4)',
    universal_h_m   => 'P 42/m c m (a+b,-a+b,c+1/4)',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z+1/2',
        '-x,-y,z',
        'y,-x,z+1/2',
        '-y,-x,-z',
        'x,-y,-z+1/2',
        'y,x,-z',
        '-x,y,-z+1/2',
        '-x,-y,-z+1/2',
        'y,-x,-z',
        'x,y,-z+1/2',
        '-y,x,-z',
        'y,x,z+1/2',
        '-x,y,z',
        '-y,-x,z+1/2',
        'x,-y,z',
        'x+1/2,y+1/2,z',
        '-y+1/2,x+1/2,z+1/2',
        '-x+1/2,-y+1/2,z',
        'y+1/2,-x+1/2,z+1/2',
        '-y+1/2,-x+1/2,-z',
        'x+1/2,-y+1/2,-z+1/2',
        'y+1/2,x+1/2,-z',
        '-x+1/2,y+1/2,-z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        'y+1/2,-x+1/2,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-y+1/2,x+1/2,-z',
        'y+1/2,x+1/2,z+1/2',
        '-x+1/2,y+1/2,z',
        '-y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x+1/2,z+1/2',
        '-x,-y,z',
        'y+1/2,-x+1/2,z+1/2',
        'x,-y,-z+1/2',
        'y+1/2,x+1/2,-z',
        '-x,y,-z+1/2',
        '-y+1/2,-x+1/2,-z',
        '-x+1/2,-y+1/2,-z+1/2',
        'y,-x,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-y,x,-z',
        '-x+1/2,y+1/2,z',
        '-y,-x,z+1/2',
        'x+1/2,-y+1/2,z',
        'y,x,z+1/2',
    ]
},

{
    number          => 132,
    hall            => '-P 4c 2c (1/2*x+1/2*y-1/4,-1/2*x+1/2*y-1/4,z)',
    schoenflies     => 'D4h^10',
    hermann_mauguin => 'P 42/m c m (a+b,-a+b+1/2,c)',
    universal_h_m   => 'P 42/m c m (a+b,-a+b+1/2,c)',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x,z+1/2',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z+1/2',
        '-y+1/2,-x+1/2,-z+1/2',
        'x,-y+1/2,-z',
        'y,x,-z+1/2',
        '-x+1/2,y,-z',
        '-x+1/2,-y+1/2,-z',
        'y,-x+1/2,-z+1/2',
        'x,y,-z',
        '-y+1/2,x,-z+1/2',
        'y,x,z+1/2',
        '-x+1/2,y,z',
        '-y+1/2,-x+1/2,z+1/2',
        'x,-y+1/2,z',
        'x+1/2,y+1/2,z',
        '-y,x+1/2,z+1/2',
        '-x,-y,z',
        'y+1/2,-x,z+1/2',
        '-y,-x,-z+1/2',
        'x+1/2,-y,-z',
        'y+1/2,x+1/2,-z+1/2',
        '-x,y+1/2,-z',
        '-x,-y,-z',
        'y+1/2,-x,-z+1/2',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z+1/2',
        'y+1/2,x+1/2,z+1/2',
        '-x,y+1/2,z',
        '-y,-x,z+1/2',
        'x+1/2,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x,z+1/2',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z+1/2',
        'x,-y+1/2,-z',
        'y,x,-z+1/2',
        '-x+1/2,y,-z',
        '-y+1/2,-x+1/2,-z+1/2',
        '-x,-y,-z',
        'y+1/2,-x,-z+1/2',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z+1/2',
        '-x,y+1/2,z',
        '-y,-x,z+1/2',
        'x+1/2,-y,z',
        'y+1/2,x+1/2,z+1/2',
    ]
},

{
    number          => 140,
    hall            => '-I 4 2c (x-1/4,y+1/4,z-1/4)',
    schoenflies     => 'D4h^18',
    hermann_mauguin => 'I 4/m c m (a+1/4,b-1/4,c+1/4)',
    universal_h_m   => 'I 4/m c m (a+1/4,b-1/4,c+1/4)',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x+1/2,z',
        '-x+1/2,-y+1/2,z',
        'y+1/2,-x,z',
        'x,-y+1/2,-z',
        'y+1/2,x+1/2,-z',
        '-x+1/2,y,-z',
        '-y,-x,-z',
        '-x+1/2,-y+1/2,-z+1/2',
        'y+1/2,-x,-z+1/2',
        'x,y,-z+1/2',
        '-y,x+1/2,-z+1/2',
        '-x+1/2,y,z+1/2',
        '-y,-x,z+1/2',
        'x,-y+1/2,z+1/2',
        'y+1/2,x+1/2,z+1/2',
        'x+1/2,y+1/2,z+1/2',
        '-y+1/2,x,z+1/2',
        '-x,-y,z+1/2',
        'y,-x+1/2,z+1/2',
        'x+1/2,-y,-z+1/2',
        'y,x,-z+1/2',
        '-x,y+1/2,-z+1/2',
        '-y+1/2,-x+1/2,-z+1/2',
        '-x,-y,-z',
        'y,-x+1/2,-z',
        'x+1/2,y+1/2,-z',
        '-y+1/2,x,-z',
        '-x,y+1/2,z',
        '-y+1/2,-x+1/2,z',
        'x+1/2,-y,z',
        'y,x,z',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x,z+1/2',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z+1/2',
        'x,-y+1/2,-z',
        'y,x,-z+1/2',
        '-x+1/2,y,-z',
        '-y+1/2,-x+1/2,-z+1/2',
        '-x,-y,-z',
        'y+1/2,-x,-z+1/2',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z+1/2',
        '-x,y+1/2,z',
        '-y,-x,z+1/2',
        'x+1/2,-y,z',
        'y+1/2,x+1/2,z+1/2',
    ]
},

{
    number          => 139,
    hall            => '-I 4 2 (1/2*x+1/2*y-1/4,-1/2*x+1/2*y+1/4,z+1/4)',
    schoenflies     => 'D4h^17',
    hermann_mauguin => 'I 4/m m m (a+b+1/2,-a+b,c-1/4)',
    universal_h_m   => 'I 4/m m m (a+b+1/2,-a+b,c-1/4)',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x+1/2,z',
        '-x+1/2,-y+1/2,z',
        'y+1/2,-x,z',
        '-y,-x,-z+1/2',
        'x,-y+1/2,-z+1/2',
        'y+1/2,x+1/2,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        'y+1/2,-x,-z+1/2',
        'x,y,-z+1/2',
        '-y,x+1/2,-z+1/2',
        'y+1/2,x+1/2,z',
        '-x+1/2,y,z',
        '-y,-x,z',
        'x,-y+1/2,z',
        'x+1/2,y+1/2,z',
        '-y+1/2,x,z',
        '-x,-y,z',
        'y,-x+1/2,z',
        '-y+1/2,-x+1/2,-z+1/2',
        'x+1/2,-y,-z+1/2',
        'y,x,-z+1/2',
        '-x,y+1/2,-z+1/2',
        '-x,-y,-z+1/2',
        'y,-x+1/2,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-y+1/2,x,-z+1/2',
        'y,x,z',
        '-x,y+1/2,z',
        '-y+1/2,-x+1/2,z',
        'x+1/2,-y,z',
        'x+1/2,y,z+1/2',
        '-y+1/2,x+1/2,z+1/2',
        '-x,-y+1/2,z+1/2',
        'y,-x,z+1/2',
        '-y+1/2,-x,-z',
        'x+1/2,-y+1/2,-z',
        'y,x+1/2,-z',
        '-x,y,-z',
        '-x,-y+1/2,-z',
        'y,-x,-z',
        'x+1/2,y,-z',
        '-y+1/2,x+1/2,-z',
        'y,x+1/2,z+1/2',
        '-x,y,z+1/2',
        '-y+1/2,-x,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        'x,y+1/2,z+1/2',
        '-y,x,z+1/2',
        '-x+1/2,-y,z+1/2',
        'y+1/2,-x+1/2,z+1/2',
        '-y,-x+1/2,-z',
        'x,-y,-z',
        'y+1/2,x,-z',
        '-x+1/2,y+1/2,-z',
        '-x+1/2,-y,-z',
        'y+1/2,-x+1/2,-z',
        'x,y+1/2,-z',
        '-y,x,-z',
        'y+1/2,x,z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        '-y,-x+1/2,z+1/2',
        'x,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x+1/2,z+1/2',
        '-x,-y,z',
        'y+1/2,-x+1/2,z+1/2',
        'x,-y,-z',
        'y+1/2,x+1/2,-z+1/2',
        '-x,y,-z',
        '-y+1/2,-x+1/2,-z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        'y,-x,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-y,x,-z',
        '-x+1/2,y+1/2,z+1/2',
        '-y,-x,z',
        'x+1/2,-y+1/2,z+1/2',
        'y,x,z',
    ]
},

{
    number          => 131,
    hall            => '-P 4c 2 (1/2*x+1/2*y,-1/2*x+1/2*y,z+1/4)',
    schoenflies     => 'D4h^9',
    hermann_mauguin => 'P 42/m m c (a+b,-a+b,c-1/4)',
    universal_h_m   => 'P 42/m m c (a+b,-a+b,c-1/4)',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z+1/2',
        '-x,-y,z',
        'y,-x,z+1/2',
        '-y,-x,-z+1/2',
        'x,-y,-z',
        'y,x,-z+1/2',
        '-x,y,-z',
        '-x,-y,-z+1/2',
        'y,-x,-z',
        'x,y,-z+1/2',
        '-y,x,-z',
        'y,x,z',
        '-x,y,z+1/2',
        '-y,-x,z',
        'x,-y,z+1/2',
        'x+1/2,y+1/2,z',
        '-y+1/2,x+1/2,z+1/2',
        '-x+1/2,-y+1/2,z',
        'y+1/2,-x+1/2,z+1/2',
        '-y+1/2,-x+1/2,-z+1/2',
        'x+1/2,-y+1/2,-z',
        'y+1/2,x+1/2,-z+1/2',
        '-x+1/2,y+1/2,-z',
        '-x+1/2,-y+1/2,-z+1/2',
        'y+1/2,-x+1/2,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-y+1/2,x+1/2,-z',
        'y+1/2,x+1/2,z',
        '-x+1/2,y+1/2,z+1/2',
        '-y+1/2,-x+1/2,z',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x+1/2,z+1/2',
        '-x,-y,z',
        'y+1/2,-x+1/2,z+1/2',
        'x,-y,-z',
        'y+1/2,x+1/2,-z+1/2',
        '-x,y,-z',
        '-y+1/2,-x+1/2,-z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        'y,-x,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-y,x,-z',
        '-x+1/2,y+1/2,z+1/2',
        '-y,-x,z',
        'x+1/2,-y+1/2,z+1/2',
        'y,x,z',
    ]
},

{
    number          => 131,
    hall            => '-P 4c 2 (1/2*x+1/2*y-1/4,-1/2*x+1/2*y-1/4,z)',
    schoenflies     => 'D4h^9',
    hermann_mauguin => 'P 42/m m c (a+b,-a+b+1/2,c)',
    universal_h_m   => 'P 42/m m c (a+b,-a+b+1/2,c)',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x,z+1/2',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z+1/2',
        '-y+1/2,-x+1/2,-z',
        'x,-y+1/2,-z+1/2',
        'y,x,-z',
        '-x+1/2,y,-z+1/2',
        '-x+1/2,-y+1/2,-z',
        'y,-x+1/2,-z+1/2',
        'x,y,-z',
        '-y+1/2,x,-z+1/2',
        'y,x,z',
        '-x+1/2,y,z+1/2',
        '-y+1/2,-x+1/2,z',
        'x,-y+1/2,z+1/2',
        'x+1/2,y+1/2,z',
        '-y,x+1/2,z+1/2',
        '-x,-y,z',
        'y+1/2,-x,z+1/2',
        '-y,-x,-z',
        'x+1/2,-y,-z+1/2',
        'y+1/2,x+1/2,-z',
        '-x,y+1/2,-z+1/2',
        '-x,-y,-z',
        'y+1/2,-x,-z+1/2',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z+1/2',
        'y+1/2,x+1/2,z',
        '-x,y+1/2,z+1/2',
        '-y,-x,z',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x,z+1/2',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z+1/2',
        'x,-y+1/2,-z+1/2',
        'y,x,-z',
        '-x+1/2,y,-z+1/2',
        '-y+1/2,-x+1/2,-z',
        '-x,-y,-z',
        'y+1/2,-x,-z+1/2',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z+1/2',
        '-x,y+1/2,z+1/2',
        '-y,-x,z',
        'x+1/2,-y,z+1/2',
        'y+1/2,x+1/2,z',
    ]
},

{
    number          => 139,
    hall            => '-I 4 2 (x-1/4,y+1/4,z-1/4)',
    schoenflies     => 'D4h^17',
    hermann_mauguin => 'I 4/m m m (a+1/4,b-1/4,c+1/4)',
    universal_h_m   => 'I 4/m m m (a+1/4,b-1/4,c+1/4)',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x+1/2,z',
        '-x+1/2,-y+1/2,z',
        'y+1/2,-x,z',
        'x,-y+1/2,-z+1/2',
        'y+1/2,x+1/2,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-y,-x,-z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        'y+1/2,-x,-z+1/2',
        'x,y,-z+1/2',
        '-y,x+1/2,-z+1/2',
        '-x+1/2,y,z',
        '-y,-x,z',
        'x,-y+1/2,z',
        'y+1/2,x+1/2,z',
        'x+1/2,y+1/2,z+1/2',
        '-y+1/2,x,z+1/2',
        '-x,-y,z+1/2',
        'y,-x+1/2,z+1/2',
        'x+1/2,-y,-z',
        'y,x,-z',
        '-x,y+1/2,-z',
        '-y+1/2,-x+1/2,-z',
        '-x,-y,-z',
        'y,-x+1/2,-z',
        'x+1/2,y+1/2,-z',
        '-y+1/2,x,-z',
        '-x,y+1/2,z+1/2',
        '-y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y,z+1/2',
        'y,x,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x,z+1/2',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z+1/2',
        'x,-y+1/2,-z+1/2',
        'y,x,-z',
        '-x+1/2,y,-z+1/2',
        '-y+1/2,-x+1/2,-z',
        '-x,-y,-z',
        'y+1/2,-x,-z+1/2',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z+1/2',
        '-x,y+1/2,z+1/2',
        '-y,-x,z',
        'x+1/2,-y,z+1/2',
        'y+1/2,x+1/2,z',
    ]
},

{
    number          => 175,
    hall            => '-P 6 (1/2*x,1/2*y,1/2*z)',
    schoenflies     => 'C6h^1',
    hermann_mauguin => 'P 6/m (2*a,2*b,2*c)',
    universal_h_m   => 'P 6/m (2*a,2*b,2*c)',
    crystal_class   => 'hexagonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        'x-y,x,z',
        '-y,x-y,z',
        '-x,-y,z',
        '-x+y,-x,z',
        'y,-x+y,z',
        '-x,-y,-z',
        '-x+y,-x,-z',
        'y,-x+y,-z',
        'x,y,-z',
        'x-y,x,-z',
        '-y,x-y,-z',
        'x+1/2,y,z',
        'x-y+1/2,x,z',
        '-y+1/2,x-y,z',
        '-x+1/2,-y,z',
        '-x+y+1/2,-x,z',
        'y+1/2,-x+y,z',
        '-x+1/2,-y,-z',
        '-x+y+1/2,-x,-z',
        'y+1/2,-x+y,-z',
        'x+1/2,y,-z',
        'x-y+1/2,x,-z',
        '-y+1/2,x-y,-z',
        'x,y+1/2,z',
        'x-y,x+1/2,z',
        '-y,x-y+1/2,z',
        '-x,-y+1/2,z',
        '-x+y,-x+1/2,z',
        'y,-x+y+1/2,z',
        '-x,-y+1/2,-z',
        '-x+y,-x+1/2,-z',
        'y,-x+y+1/2,-z',
        'x,y+1/2,-z',
        'x-y,x+1/2,-z',
        '-y,x-y+1/2,-z',
        'x+1/2,y+1/2,z',
        'x-y+1/2,x+1/2,z',
        '-y+1/2,x-y+1/2,z',
        '-x+1/2,-y+1/2,z',
        '-x+y+1/2,-x+1/2,z',
        'y+1/2,-x+y+1/2,z',
        '-x+1/2,-y+1/2,-z',
        '-x+y+1/2,-x+1/2,-z',
        'y+1/2,-x+y+1/2,-z',
        'x+1/2,y+1/2,-z',
        'x-y+1/2,x+1/2,-z',
        '-y+1/2,x-y+1/2,-z',
        'x,y,z+1/2',
        'x-y,x,z+1/2',
        '-y,x-y,z+1/2',
        '-x,-y,z+1/2',
        '-x+y,-x,z+1/2',
        'y,-x+y,z+1/2',
        '-x,-y,-z+1/2',
        '-x+y,-x,-z+1/2',
        'y,-x+y,-z+1/2',
        'x,y,-z+1/2',
        'x-y,x,-z+1/2',
        '-y,x-y,-z+1/2',
        'x+1/2,y,z+1/2',
        'x-y+1/2,x,z+1/2',
        '-y+1/2,x-y,z+1/2',
        '-x+1/2,-y,z+1/2',
        '-x+y+1/2,-x,z+1/2',
        'y+1/2,-x+y,z+1/2',
        '-x+1/2,-y,-z+1/2',
        '-x+y+1/2,-x,-z+1/2',
        'y+1/2,-x+y,-z+1/2',
        'x+1/2,y,-z+1/2',
        'x-y+1/2,x,-z+1/2',
        '-y+1/2,x-y,-z+1/2',
        'x,y+1/2,z+1/2',
        'x-y,x+1/2,z+1/2',
        '-y,x-y+1/2,z+1/2',
        '-x,-y+1/2,z+1/2',
        '-x+y,-x+1/2,z+1/2',
        'y,-x+y+1/2,z+1/2',
        '-x,-y+1/2,-z+1/2',
        '-x+y,-x+1/2,-z+1/2',
        'y,-x+y+1/2,-z+1/2',
        'x,y+1/2,-z+1/2',
        'x-y,x+1/2,-z+1/2',
        '-y,x-y+1/2,-z+1/2',
        'x+1/2,y+1/2,z+1/2',
        'x-y+1/2,x+1/2,z+1/2',
        '-y+1/2,x-y+1/2,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        '-x+y+1/2,-x+1/2,z+1/2',
        'y+1/2,-x+y+1/2,z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        '-x+y+1/2,-x+1/2,-z+1/2',
        'y+1/2,-x+y+1/2,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        'x-y+1/2,x+1/2,-z+1/2',
        '-y+1/2,x-y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x-y,x,z',
        '-y,x-y,z',
        '-x,-y,z',
        '-x+y,-x,z',
        'y,-x+y,z',
        '-x,-y,-z',
        '-x+y,-x,-z',
        'y,-x+y,-z',
        'x,y,-z',
        'x-y,x,-z',
        '-y,x-y,-z',
    ]
},

{
    number          => 175,
    hall            => '-P 6 (1/2*x,1/2*y,z)',
    schoenflies     => 'C6h^1',
    hermann_mauguin => 'P 6/m (2*a,2*b,c)',
    universal_h_m   => 'P 6/m (2*a,2*b,c)',
    crystal_class   => 'hexagonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        'x-y,x,z',
        '-y,x-y,z',
        '-x,-y,z',
        '-x+y,-x,z',
        'y,-x+y,z',
        '-x,-y,-z',
        '-x+y,-x,-z',
        'y,-x+y,-z',
        'x,y,-z',
        'x-y,x,-z',
        '-y,x-y,-z',
        'x+1/2,y,z',
        'x-y+1/2,x,z',
        '-y+1/2,x-y,z',
        '-x+1/2,-y,z',
        '-x+y+1/2,-x,z',
        'y+1/2,-x+y,z',
        '-x+1/2,-y,-z',
        '-x+y+1/2,-x,-z',
        'y+1/2,-x+y,-z',
        'x+1/2,y,-z',
        'x-y+1/2,x,-z',
        '-y+1/2,x-y,-z',
        'x,y+1/2,z',
        'x-y,x+1/2,z',
        '-y,x-y+1/2,z',
        '-x,-y+1/2,z',
        '-x+y,-x+1/2,z',
        'y,-x+y+1/2,z',
        '-x,-y+1/2,-z',
        '-x+y,-x+1/2,-z',
        'y,-x+y+1/2,-z',
        'x,y+1/2,-z',
        'x-y,x+1/2,-z',
        '-y,x-y+1/2,-z',
        'x+1/2,y+1/2,z',
        'x-y+1/2,x+1/2,z',
        '-y+1/2,x-y+1/2,z',
        '-x+1/2,-y+1/2,z',
        '-x+y+1/2,-x+1/2,z',
        'y+1/2,-x+y+1/2,z',
        '-x+1/2,-y+1/2,-z',
        '-x+y+1/2,-x+1/2,-z',
        'y+1/2,-x+y+1/2,-z',
        'x+1/2,y+1/2,-z',
        'x-y+1/2,x+1/2,-z',
        '-y+1/2,x-y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        'x-y,x,z',
        '-y,x-y,z',
        '-x,-y,z',
        '-x+y,-x,z',
        'y,-x+y,z',
        '-x,-y,-z',
        '-x+y,-x,-z',
        'y,-x+y,-z',
        'x,y,-z',
        'x-y,x,-z',
        '-y,x-y,-z',
    ]
},

{
    number          => 176,
    hall            => '-P 6c (1/2*x,1/2*y,z)',
    schoenflies     => 'C6h^2',
    hermann_mauguin => 'P 63/m (2*a,2*b,c)',
    universal_h_m   => 'P 63/m (2*a,2*b,c)',
    crystal_class   => 'hexagonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        'x-y,x,z+1/2',
        '-y,x-y,z',
        '-x,-y,z+1/2',
        '-x+y,-x,z',
        'y,-x+y,z+1/2',
        '-x,-y,-z',
        '-x+y,-x,-z+1/2',
        'y,-x+y,-z',
        'x,y,-z+1/2',
        'x-y,x,-z',
        '-y,x-y,-z+1/2',
        'x+1/2,y,z',
        'x-y+1/2,x,z+1/2',
        '-y+1/2,x-y,z',
        '-x+1/2,-y,z+1/2',
        '-x+y+1/2,-x,z',
        'y+1/2,-x+y,z+1/2',
        '-x+1/2,-y,-z',
        '-x+y+1/2,-x,-z+1/2',
        'y+1/2,-x+y,-z',
        'x+1/2,y,-z+1/2',
        'x-y+1/2,x,-z',
        '-y+1/2,x-y,-z+1/2',
        'x,y+1/2,z',
        'x-y,x+1/2,z+1/2',
        '-y,x-y+1/2,z',
        '-x,-y+1/2,z+1/2',
        '-x+y,-x+1/2,z',
        'y,-x+y+1/2,z+1/2',
        '-x,-y+1/2,-z',
        '-x+y,-x+1/2,-z+1/2',
        'y,-x+y+1/2,-z',
        'x,y+1/2,-z+1/2',
        'x-y,x+1/2,-z',
        '-y,x-y+1/2,-z+1/2',
        'x+1/2,y+1/2,z',
        'x-y+1/2,x+1/2,z+1/2',
        '-y+1/2,x-y+1/2,z',
        '-x+1/2,-y+1/2,z+1/2',
        '-x+y+1/2,-x+1/2,z',
        'y+1/2,-x+y+1/2,z+1/2',
        '-x+1/2,-y+1/2,-z',
        '-x+y+1/2,-x+1/2,-z+1/2',
        'y+1/2,-x+y+1/2,-z',
        'x+1/2,y+1/2,-z+1/2',
        'x-y+1/2,x+1/2,-z',
        '-y+1/2,x-y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x-y,x,z+1/2',
        '-y,x-y,z',
        '-x,-y,z+1/2',
        '-x+y,-x,z',
        'y,-x+y,z+1/2',
        '-x,-y,-z',
        '-x+y,-x,-z+1/2',
        'y,-x+y,-z',
        'x,y,-z+1/2',
        'x-y,x,-z',
        '-y,x-y,-z+1/2',
    ]
},

{
    number          => 191,
    hall            => '-P 6 2 (1/2*x,1/2*y,1/2*z)',
    schoenflies     => 'D6h^1',
    hermann_mauguin => 'P 6/m m m (2*a,2*b,2*c)',
    universal_h_m   => 'P 6/m m m (2*a,2*b,2*c)',
    crystal_class   => 'hexagonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        'x-y,x,z',
        '-y,x-y,z',
        '-x,-y,z',
        '-x+y,-x,z',
        'y,-x+y,z',
        '-y,-x,-z',
        'x-y,-y,-z',
        'x,x-y,-z',
        'y,x,-z',
        '-x+y,y,-z',
        '-x,-x+y,-z',
        '-x,-y,-z',
        '-x+y,-x,-z',
        'y,-x+y,-z',
        'x,y,-z',
        'x-y,x,-z',
        '-y,x-y,-z',
        'y,x,z',
        '-x+y,y,z',
        '-x,-x+y,z',
        '-y,-x,z',
        'x-y,-y,z',
        'x,x-y,z',
        'x+1/2,y,z',
        'x-y+1/2,x,z',
        '-y+1/2,x-y,z',
        '-x+1/2,-y,z',
        '-x+y+1/2,-x,z',
        'y+1/2,-x+y,z',
        '-y+1/2,-x,-z',
        'x-y+1/2,-y,-z',
        'x+1/2,x-y,-z',
        'y+1/2,x,-z',
        '-x+y+1/2,y,-z',
        '-x+1/2,-x+y,-z',
        '-x+1/2,-y,-z',
        '-x+y+1/2,-x,-z',
        'y+1/2,-x+y,-z',
        'x+1/2,y,-z',
        'x-y+1/2,x,-z',
        '-y+1/2,x-y,-z',
        'y+1/2,x,z',
        '-x+y+1/2,y,z',
        '-x+1/2,-x+y,z',
        '-y+1/2,-x,z',
        'x-y+1/2,-y,z',
        'x+1/2,x-y,z',
        'x,y+1/2,z',
        'x-y,x+1/2,z',
        '-y,x-y+1/2,z',
        '-x,-y+1/2,z',
        '-x+y,-x+1/2,z',
        'y,-x+y+1/2,z',
        '-y,-x+1/2,-z',
        'x-y,-y+1/2,-z',
        'x,x-y+1/2,-z',
        'y,x+1/2,-z',
        '-x+y,y+1/2,-z',
        '-x,-x+y+1/2,-z',
        '-x,-y+1/2,-z',
        '-x+y,-x+1/2,-z',
        'y,-x+y+1/2,-z',
        'x,y+1/2,-z',
        'x-y,x+1/2,-z',
        '-y,x-y+1/2,-z',
        'y,x+1/2,z',
        '-x+y,y+1/2,z',
        '-x,-x+y+1/2,z',
        '-y,-x+1/2,z',
        'x-y,-y+1/2,z',
        'x,x-y+1/2,z',
        'x+1/2,y+1/2,z',
        'x-y+1/2,x+1/2,z',
        '-y+1/2,x-y+1/2,z',
        '-x+1/2,-y+1/2,z',
        '-x+y+1/2,-x+1/2,z',
        'y+1/2,-x+y+1/2,z',
        '-y+1/2,-x+1/2,-z',
        'x-y+1/2,-y+1/2,-z',
        'x+1/2,x-y+1/2,-z',
        'y+1/2,x+1/2,-z',
        '-x+y+1/2,y+1/2,-z',
        '-x+1/2,-x+y+1/2,-z',
        '-x+1/2,-y+1/2,-z',
        '-x+y+1/2,-x+1/2,-z',
        'y+1/2,-x+y+1/2,-z',
        'x+1/2,y+1/2,-z',
        'x-y+1/2,x+1/2,-z',
        '-y+1/2,x-y+1/2,-z',
        'y+1/2,x+1/2,z',
        '-x+y+1/2,y+1/2,z',
        '-x+1/2,-x+y+1/2,z',
        '-y+1/2,-x+1/2,z',
        'x-y+1/2,-y+1/2,z',
        'x+1/2,x-y+1/2,z',
        'x,y,z+1/2',
        'x-y,x,z+1/2',
        '-y,x-y,z+1/2',
        '-x,-y,z+1/2',
        '-x+y,-x,z+1/2',
        'y,-x+y,z+1/2',
        '-y,-x,-z+1/2',
        'x-y,-y,-z+1/2',
        'x,x-y,-z+1/2',
        'y,x,-z+1/2',
        '-x+y,y,-z+1/2',
        '-x,-x+y,-z+1/2',
        '-x,-y,-z+1/2',
        '-x+y,-x,-z+1/2',
        'y,-x+y,-z+1/2',
        'x,y,-z+1/2',
        'x-y,x,-z+1/2',
        '-y,x-y,-z+1/2',
        'y,x,z+1/2',
        '-x+y,y,z+1/2',
        '-x,-x+y,z+1/2',
        '-y,-x,z+1/2',
        'x-y,-y,z+1/2',
        'x,x-y,z+1/2',
        'x+1/2,y,z+1/2',
        'x-y+1/2,x,z+1/2',
        '-y+1/2,x-y,z+1/2',
        '-x+1/2,-y,z+1/2',
        '-x+y+1/2,-x,z+1/2',
        'y+1/2,-x+y,z+1/2',
        '-y+1/2,-x,-z+1/2',
        'x-y+1/2,-y,-z+1/2',
        'x+1/2,x-y,-z+1/2',
        'y+1/2,x,-z+1/2',
        '-x+y+1/2,y,-z+1/2',
        '-x+1/2,-x+y,-z+1/2',
        '-x+1/2,-y,-z+1/2',
        '-x+y+1/2,-x,-z+1/2',
        'y+1/2,-x+y,-z+1/2',
        'x+1/2,y,-z+1/2',
        'x-y+1/2,x,-z+1/2',
        '-y+1/2,x-y,-z+1/2',
        'y+1/2,x,z+1/2',
        '-x+y+1/2,y,z+1/2',
        '-x+1/2,-x+y,z+1/2',
        '-y+1/2,-x,z+1/2',
        'x-y+1/2,-y,z+1/2',
        'x+1/2,x-y,z+1/2',
        'x,y+1/2,z+1/2',
        'x-y,x+1/2,z+1/2',
        '-y,x-y+1/2,z+1/2',
        '-x,-y+1/2,z+1/2',
        '-x+y,-x+1/2,z+1/2',
        'y,-x+y+1/2,z+1/2',
        '-y,-x+1/2,-z+1/2',
        'x-y,-y+1/2,-z+1/2',
        'x,x-y+1/2,-z+1/2',
        'y,x+1/2,-z+1/2',
        '-x+y,y+1/2,-z+1/2',
        '-x,-x+y+1/2,-z+1/2',
        '-x,-y+1/2,-z+1/2',
        '-x+y,-x+1/2,-z+1/2',
        'y,-x+y+1/2,-z+1/2',
        'x,y+1/2,-z+1/2',
        'x-y,x+1/2,-z+1/2',
        '-y,x-y+1/2,-z+1/2',
        'y,x+1/2,z+1/2',
        '-x+y,y+1/2,z+1/2',
        '-x,-x+y+1/2,z+1/2',
        '-y,-x+1/2,z+1/2',
        'x-y,-y+1/2,z+1/2',
        'x,x-y+1/2,z+1/2',
        'x+1/2,y+1/2,z+1/2',
        'x-y+1/2,x+1/2,z+1/2',
        '-y+1/2,x-y+1/2,z+1/2',
        '-x+1/2,-y+1/2,z+1/2',
        '-x+y+1/2,-x+1/2,z+1/2',
        'y+1/2,-x+y+1/2,z+1/2',
        '-y+1/2,-x+1/2,-z+1/2',
        'x-y+1/2,-y+1/2,-z+1/2',
        'x+1/2,x-y+1/2,-z+1/2',
        'y+1/2,x+1/2,-z+1/2',
        '-x+y+1/2,y+1/2,-z+1/2',
        '-x+1/2,-x+y+1/2,-z+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        '-x+y+1/2,-x+1/2,-z+1/2',
        'y+1/2,-x+y+1/2,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        'x-y+1/2,x+1/2,-z+1/2',
        '-y+1/2,x-y+1/2,-z+1/2',
        'y+1/2,x+1/2,z+1/2',
        '-x+y+1/2,y+1/2,z+1/2',
        '-x+1/2,-x+y+1/2,z+1/2',
        '-y+1/2,-x+1/2,z+1/2',
        'x-y+1/2,-y+1/2,z+1/2',
        'x+1/2,x-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x-y,x,z',
        '-y,x-y,z',
        '-x,-y,z',
        '-x+y,-x,z',
        'y,-x+y,z',
        '-y,-x,-z',
        'x-y,-y,-z',
        'x,x-y,-z',
        'y,x,-z',
        '-x+y,y,-z',
        '-x,-x+y,-z',
        '-x,-y,-z',
        '-x+y,-x,-z',
        'y,-x+y,-z',
        'x,y,-z',
        'x-y,x,-z',
        '-y,x-y,-z',
        'y,x,z',
        '-x+y,y,z',
        '-x,-x+y,z',
        '-y,-x,z',
        'x-y,-y,z',
        'x,x-y,z',
    ]
},

{
    number          => 191,
    hall            => '-P 6 2 (1/2*x,1/2*y,z)',
    schoenflies     => 'D6h^1',
    hermann_mauguin => 'P 6/m m m (2*a,2*b,c)',
    universal_h_m   => 'P 6/m m m (2*a,2*b,c)',
    crystal_class   => 'hexagonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        'x-y,x,z',
        '-y,x-y,z',
        '-x,-y,z',
        '-x+y,-x,z',
        'y,-x+y,z',
        '-y,-x,-z',
        'x-y,-y,-z',
        'x,x-y,-z',
        'y,x,-z',
        '-x+y,y,-z',
        '-x,-x+y,-z',
        '-x,-y,-z',
        '-x+y,-x,-z',
        'y,-x+y,-z',
        'x,y,-z',
        'x-y,x,-z',
        '-y,x-y,-z',
        'y,x,z',
        '-x+y,y,z',
        '-x,-x+y,z',
        '-y,-x,z',
        'x-y,-y,z',
        'x,x-y,z',
        'x+1/2,y,z',
        'x-y+1/2,x,z',
        '-y+1/2,x-y,z',
        '-x+1/2,-y,z',
        '-x+y+1/2,-x,z',
        'y+1/2,-x+y,z',
        '-y+1/2,-x,-z',
        'x-y+1/2,-y,-z',
        'x+1/2,x-y,-z',
        'y+1/2,x,-z',
        '-x+y+1/2,y,-z',
        '-x+1/2,-x+y,-z',
        '-x+1/2,-y,-z',
        '-x+y+1/2,-x,-z',
        'y+1/2,-x+y,-z',
        'x+1/2,y,-z',
        'x-y+1/2,x,-z',
        '-y+1/2,x-y,-z',
        'y+1/2,x,z',
        '-x+y+1/2,y,z',
        '-x+1/2,-x+y,z',
        '-y+1/2,-x,z',
        'x-y+1/2,-y,z',
        'x+1/2,x-y,z',
        'x,y+1/2,z',
        'x-y,x+1/2,z',
        '-y,x-y+1/2,z',
        '-x,-y+1/2,z',
        '-x+y,-x+1/2,z',
        'y,-x+y+1/2,z',
        '-y,-x+1/2,-z',
        'x-y,-y+1/2,-z',
        'x,x-y+1/2,-z',
        'y,x+1/2,-z',
        '-x+y,y+1/2,-z',
        '-x,-x+y+1/2,-z',
        '-x,-y+1/2,-z',
        '-x+y,-x+1/2,-z',
        'y,-x+y+1/2,-z',
        'x,y+1/2,-z',
        'x-y,x+1/2,-z',
        '-y,x-y+1/2,-z',
        'y,x+1/2,z',
        '-x+y,y+1/2,z',
        '-x,-x+y+1/2,z',
        '-y,-x+1/2,z',
        'x-y,-y+1/2,z',
        'x,x-y+1/2,z',
        'x+1/2,y+1/2,z',
        'x-y+1/2,x+1/2,z',
        '-y+1/2,x-y+1/2,z',
        '-x+1/2,-y+1/2,z',
        '-x+y+1/2,-x+1/2,z',
        'y+1/2,-x+y+1/2,z',
        '-y+1/2,-x+1/2,-z',
        'x-y+1/2,-y+1/2,-z',
        'x+1/2,x-y+1/2,-z',
        'y+1/2,x+1/2,-z',
        '-x+y+1/2,y+1/2,-z',
        '-x+1/2,-x+y+1/2,-z',
        '-x+1/2,-y+1/2,-z',
        '-x+y+1/2,-x+1/2,-z',
        'y+1/2,-x+y+1/2,-z',
        'x+1/2,y+1/2,-z',
        'x-y+1/2,x+1/2,-z',
        '-y+1/2,x-y+1/2,-z',
        'y+1/2,x+1/2,z',
        '-x+y+1/2,y+1/2,z',
        '-x+1/2,-x+y+1/2,z',
        '-y+1/2,-x+1/2,z',
        'x-y+1/2,-y+1/2,z',
        'x+1/2,x-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        'x-y,x,z',
        '-y,x-y,z',
        '-x,-y,z',
        '-x+y,-x,z',
        'y,-x+y,z',
        '-y,-x,-z',
        'x-y,-y,-z',
        'x,x-y,-z',
        'y,x,-z',
        '-x+y,y,-z',
        '-x,-x+y,-z',
        '-x,-y,-z',
        '-x+y,-x,-z',
        'y,-x+y,-z',
        'x,y,-z',
        'x-y,x,-z',
        '-y,x-y,-z',
        'y,x,z',
        '-x+y,y,z',
        '-x,-x+y,z',
        '-y,-x,z',
        'x-y,-y,z',
        'x,x-y,z',
    ]
},

{
    number          => 192,
    hall            => '-P 6 2c (1/2*x,1/2*y,z)',
    schoenflies     => 'D6h^2',
    hermann_mauguin => 'P 6/m c c (2*a,2*b,c)',
    universal_h_m   => 'P 6/m c c (2*a,2*b,c)',
    crystal_class   => 'hexagonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        'x-y,x,z',
        '-y,x-y,z',
        '-x,-y,z',
        '-x+y,-x,z',
        'y,-x+y,z',
        '-y,-x,-z+1/2',
        'x-y,-y,-z+1/2',
        'x,x-y,-z+1/2',
        'y,x,-z+1/2',
        '-x+y,y,-z+1/2',
        '-x,-x+y,-z+1/2',
        '-x,-y,-z',
        '-x+y,-x,-z',
        'y,-x+y,-z',
        'x,y,-z',
        'x-y,x,-z',
        '-y,x-y,-z',
        'y,x,z+1/2',
        '-x+y,y,z+1/2',
        '-x,-x+y,z+1/2',
        '-y,-x,z+1/2',
        'x-y,-y,z+1/2',
        'x,x-y,z+1/2',
        'x+1/2,y,z',
        'x-y+1/2,x,z',
        '-y+1/2,x-y,z',
        '-x+1/2,-y,z',
        '-x+y+1/2,-x,z',
        'y+1/2,-x+y,z',
        '-y+1/2,-x,-z+1/2',
        'x-y+1/2,-y,-z+1/2',
        'x+1/2,x-y,-z+1/2',
        'y+1/2,x,-z+1/2',
        '-x+y+1/2,y,-z+1/2',
        '-x+1/2,-x+y,-z+1/2',
        '-x+1/2,-y,-z',
        '-x+y+1/2,-x,-z',
        'y+1/2,-x+y,-z',
        'x+1/2,y,-z',
        'x-y+1/2,x,-z',
        '-y+1/2,x-y,-z',
        'y+1/2,x,z+1/2',
        '-x+y+1/2,y,z+1/2',
        '-x+1/2,-x+y,z+1/2',
        '-y+1/2,-x,z+1/2',
        'x-y+1/2,-y,z+1/2',
        'x+1/2,x-y,z+1/2',
        'x,y+1/2,z',
        'x-y,x+1/2,z',
        '-y,x-y+1/2,z',
        '-x,-y+1/2,z',
        '-x+y,-x+1/2,z',
        'y,-x+y+1/2,z',
        '-y,-x+1/2,-z+1/2',
        'x-y,-y+1/2,-z+1/2',
        'x,x-y+1/2,-z+1/2',
        'y,x+1/2,-z+1/2',
        '-x+y,y+1/2,-z+1/2',
        '-x,-x+y+1/2,-z+1/2',
        '-x,-y+1/2,-z',
        '-x+y,-x+1/2,-z',
        'y,-x+y+1/2,-z',
        'x,y+1/2,-z',
        'x-y,x+1/2,-z',
        '-y,x-y+1/2,-z',
        'y,x+1/2,z+1/2',
        '-x+y,y+1/2,z+1/2',
        '-x,-x+y+1/2,z+1/2',
        '-y,-x+1/2,z+1/2',
        'x-y,-y+1/2,z+1/2',
        'x,x-y+1/2,z+1/2',
        'x+1/2,y+1/2,z',
        'x-y+1/2,x+1/2,z',
        '-y+1/2,x-y+1/2,z',
        '-x+1/2,-y+1/2,z',
        '-x+y+1/2,-x+1/2,z',
        'y+1/2,-x+y+1/2,z',
        '-y+1/2,-x+1/2,-z+1/2',
        'x-y+1/2,-y+1/2,-z+1/2',
        'x+1/2,x-y+1/2,-z+1/2',
        'y+1/2,x+1/2,-z+1/2',
        '-x+y+1/2,y+1/2,-z+1/2',
        '-x+1/2,-x+y+1/2,-z+1/2',
        '-x+1/2,-y+1/2,-z',
        '-x+y+1/2,-x+1/2,-z',
        'y+1/2,-x+y+1/2,-z',
        'x+1/2,y+1/2,-z',
        'x-y+1/2,x+1/2,-z',
        '-y+1/2,x-y+1/2,-z',
        'y+1/2,x+1/2,z+1/2',
        '-x+y+1/2,y+1/2,z+1/2',
        '-x+1/2,-x+y+1/2,z+1/2',
        '-y+1/2,-x+1/2,z+1/2',
        'x-y+1/2,-y+1/2,z+1/2',
        'x+1/2,x-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x-y,x,z',
        '-y,x-y,z',
        '-x,-y,z',
        '-x+y,-x,z',
        'y,-x+y,z',
        '-y,-x,-z+1/2',
        'x-y,-y,-z+1/2',
        'x,x-y,-z+1/2',
        'y,x,-z+1/2',
        '-x+y,y,-z+1/2',
        '-x,-x+y,-z+1/2',
        '-x,-y,-z',
        '-x+y,-x,-z',
        'y,-x+y,-z',
        'x,y,-z',
        'x-y,x,-z',
        '-y,x-y,-z',
        'y,x,z+1/2',
        '-x+y,y,z+1/2',
        '-x,-x+y,z+1/2',
        '-y,-x,z+1/2',
        'x-y,-y,z+1/2',
        'x,x-y,z+1/2',
    ]
},

{
    number          => 193,
    hall            => '-P 6c 2 (1/2*x,1/2*y,z)',
    schoenflies     => 'D6h^3',
    hermann_mauguin => 'P 63/m c m (2*a,2*b,c)',
    universal_h_m   => 'P 63/m c m (2*a,2*b,c)',
    crystal_class   => 'hexagonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        'x-y,x,z+1/2',
        '-y,x-y,z',
        '-x,-y,z+1/2',
        '-x+y,-x,z',
        'y,-x+y,z+1/2',
        '-y,-x,-z',
        'x-y,-y,-z+1/2',
        'x,x-y,-z',
        'y,x,-z+1/2',
        '-x+y,y,-z',
        '-x,-x+y,-z+1/2',
        '-x,-y,-z',
        '-x+y,-x,-z+1/2',
        'y,-x+y,-z',
        'x,y,-z+1/2',
        'x-y,x,-z',
        '-y,x-y,-z+1/2',
        'y,x,z',
        '-x+y,y,z+1/2',
        '-x,-x+y,z',
        '-y,-x,z+1/2',
        'x-y,-y,z',
        'x,x-y,z+1/2',
        'x+1/2,y,z',
        'x-y+1/2,x,z+1/2',
        '-y+1/2,x-y,z',
        '-x+1/2,-y,z+1/2',
        '-x+y+1/2,-x,z',
        'y+1/2,-x+y,z+1/2',
        '-y+1/2,-x,-z',
        'x-y+1/2,-y,-z+1/2',
        'x+1/2,x-y,-z',
        'y+1/2,x,-z+1/2',
        '-x+y+1/2,y,-z',
        '-x+1/2,-x+y,-z+1/2',
        '-x+1/2,-y,-z',
        '-x+y+1/2,-x,-z+1/2',
        'y+1/2,-x+y,-z',
        'x+1/2,y,-z+1/2',
        'x-y+1/2,x,-z',
        '-y+1/2,x-y,-z+1/2',
        'y+1/2,x,z',
        '-x+y+1/2,y,z+1/2',
        '-x+1/2,-x+y,z',
        '-y+1/2,-x,z+1/2',
        'x-y+1/2,-y,z',
        'x+1/2,x-y,z+1/2',
        'x,y+1/2,z',
        'x-y,x+1/2,z+1/2',
        '-y,x-y+1/2,z',
        '-x,-y+1/2,z+1/2',
        '-x+y,-x+1/2,z',
        'y,-x+y+1/2,z+1/2',
        '-y,-x+1/2,-z',
        'x-y,-y+1/2,-z+1/2',
        'x,x-y+1/2,-z',
        'y,x+1/2,-z+1/2',
        '-x+y,y+1/2,-z',
        '-x,-x+y+1/2,-z+1/2',
        '-x,-y+1/2,-z',
        '-x+y,-x+1/2,-z+1/2',
        'y,-x+y+1/2,-z',
        'x,y+1/2,-z+1/2',
        'x-y,x+1/2,-z',
        '-y,x-y+1/2,-z+1/2',
        'y,x+1/2,z',
        '-x+y,y+1/2,z+1/2',
        '-x,-x+y+1/2,z',
        '-y,-x+1/2,z+1/2',
        'x-y,-y+1/2,z',
        'x,x-y+1/2,z+1/2',
        'x+1/2,y+1/2,z',
        'x-y+1/2,x+1/2,z+1/2',
        '-y+1/2,x-y+1/2,z',
        '-x+1/2,-y+1/2,z+1/2',
        '-x+y+1/2,-x+1/2,z',
        'y+1/2,-x+y+1/2,z+1/2',
        '-y+1/2,-x+1/2,-z',
        'x-y+1/2,-y+1/2,-z+1/2',
        'x+1/2,x-y+1/2,-z',
        'y+1/2,x+1/2,-z+1/2',
        '-x+y+1/2,y+1/2,-z',
        '-x+1/2,-x+y+1/2,-z+1/2',
        '-x+1/2,-y+1/2,-z',
        '-x+y+1/2,-x+1/2,-z+1/2',
        'y+1/2,-x+y+1/2,-z',
        'x+1/2,y+1/2,-z+1/2',
        'x-y+1/2,x+1/2,-z',
        '-y+1/2,x-y+1/2,-z+1/2',
        'y+1/2,x+1/2,z',
        '-x+y+1/2,y+1/2,z+1/2',
        '-x+1/2,-x+y+1/2,z',
        '-y+1/2,-x+1/2,z+1/2',
        'x-y+1/2,-y+1/2,z',
        'x+1/2,x-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x-y,x,z+1/2',
        '-y,x-y,z',
        '-x,-y,z+1/2',
        '-x+y,-x,z',
        'y,-x+y,z+1/2',
        '-y,-x,-z',
        'x-y,-y,-z+1/2',
        'x,x-y,-z',
        'y,x,-z+1/2',
        '-x+y,y,-z',
        '-x,-x+y,-z+1/2',
        '-x,-y,-z',
        '-x+y,-x,-z+1/2',
        'y,-x+y,-z',
        'x,y,-z+1/2',
        'x-y,x,-z',
        '-y,x-y,-z+1/2',
        'y,x,z',
        '-x+y,y,z+1/2',
        '-x,-x+y,z',
        '-y,-x,z+1/2',
        'x-y,-y,z',
        'x,x-y,z+1/2',
    ]
},

{
    number          => 194,
    hall            => '-P 6c 2c (1/2*x,1/2*y,z)',
    schoenflies     => 'D6h^4',
    hermann_mauguin => 'P 63/m m c (2*a,2*b,c)',
    universal_h_m   => 'P 63/m m c (2*a,2*b,c)',
    crystal_class   => 'hexagonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 120',
    symops => [
        'x,y,z',
        'x-y,x,z+1/2',
        '-y,x-y,z',
        '-x,-y,z+1/2',
        '-x+y,-x,z',
        'y,-x+y,z+1/2',
        '-y,-x,-z+1/2',
        'x-y,-y,-z',
        'x,x-y,-z+1/2',
        'y,x,-z',
        '-x+y,y,-z+1/2',
        '-x,-x+y,-z',
        '-x,-y,-z',
        '-x+y,-x,-z+1/2',
        'y,-x+y,-z',
        'x,y,-z+1/2',
        'x-y,x,-z',
        '-y,x-y,-z+1/2',
        'y,x,z+1/2',
        '-x+y,y,z',
        '-x,-x+y,z+1/2',
        '-y,-x,z',
        'x-y,-y,z+1/2',
        'x,x-y,z',
        'x+1/2,y,z',
        'x-y+1/2,x,z+1/2',
        '-y+1/2,x-y,z',
        '-x+1/2,-y,z+1/2',
        '-x+y+1/2,-x,z',
        'y+1/2,-x+y,z+1/2',
        '-y+1/2,-x,-z+1/2',
        'x-y+1/2,-y,-z',
        'x+1/2,x-y,-z+1/2',
        'y+1/2,x,-z',
        '-x+y+1/2,y,-z+1/2',
        '-x+1/2,-x+y,-z',
        '-x+1/2,-y,-z',
        '-x+y+1/2,-x,-z+1/2',
        'y+1/2,-x+y,-z',
        'x+1/2,y,-z+1/2',
        'x-y+1/2,x,-z',
        '-y+1/2,x-y,-z+1/2',
        'y+1/2,x,z+1/2',
        '-x+y+1/2,y,z',
        '-x+1/2,-x+y,z+1/2',
        '-y+1/2,-x,z',
        'x-y+1/2,-y,z+1/2',
        'x+1/2,x-y,z',
        'x,y+1/2,z',
        'x-y,x+1/2,z+1/2',
        '-y,x-y+1/2,z',
        '-x,-y+1/2,z+1/2',
        '-x+y,-x+1/2,z',
        'y,-x+y+1/2,z+1/2',
        '-y,-x+1/2,-z+1/2',
        'x-y,-y+1/2,-z',
        'x,x-y+1/2,-z+1/2',
        'y,x+1/2,-z',
        '-x+y,y+1/2,-z+1/2',
        '-x,-x+y+1/2,-z',
        '-x,-y+1/2,-z',
        '-x+y,-x+1/2,-z+1/2',
        'y,-x+y+1/2,-z',
        'x,y+1/2,-z+1/2',
        'x-y,x+1/2,-z',
        '-y,x-y+1/2,-z+1/2',
        'y,x+1/2,z+1/2',
        '-x+y,y+1/2,z',
        '-x,-x+y+1/2,z+1/2',
        '-y,-x+1/2,z',
        'x-y,-y+1/2,z+1/2',
        'x,x-y+1/2,z',
        'x+1/2,y+1/2,z',
        'x-y+1/2,x+1/2,z+1/2',
        '-y+1/2,x-y+1/2,z',
        '-x+1/2,-y+1/2,z+1/2',
        '-x+y+1/2,-x+1/2,z',
        'y+1/2,-x+y+1/2,z+1/2',
        '-y+1/2,-x+1/2,-z+1/2',
        'x-y+1/2,-y+1/2,-z',
        'x+1/2,x-y+1/2,-z+1/2',
        'y+1/2,x+1/2,-z',
        '-x+y+1/2,y+1/2,-z+1/2',
        '-x+1/2,-x+y+1/2,-z',
        '-x+1/2,-y+1/2,-z',
        '-x+y+1/2,-x+1/2,-z+1/2',
        'y+1/2,-x+y+1/2,-z',
        'x+1/2,y+1/2,-z+1/2',
        'x-y+1/2,x+1/2,-z',
        '-y+1/2,x-y+1/2,-z+1/2',
        'y+1/2,x+1/2,z+1/2',
        '-x+y+1/2,y+1/2,z',
        '-x+1/2,-x+y+1/2,z+1/2',
        '-y+1/2,-x+1/2,z',
        'x-y+1/2,-y+1/2,z+1/2',
        'x+1/2,x-y+1/2,z',
    ],
    ncsym => [
        'x,y,z',
        'x-y,x,z+1/2',
        '-y,x-y,z',
        '-x,-y,z+1/2',
        '-x+y,-x,z',
        'y,-x+y,z+1/2',
        '-y,-x,-z+1/2',
        'x-y,-y,-z',
        'x,x-y,-z+1/2',
        'y,x,-z',
        '-x+y,y,-z+1/2',
        '-x,-x+y,-z',
        '-x,-y,-z',
        '-x+y,-x,-z+1/2',
        'y,-x+y,-z',
        'x,y,-z+1/2',
        'x-y,x,-z',
        '-y,x-y,-z+1/2',
        'y,x,z+1/2',
        '-x+y,y,z',
        '-x,-x+y,z+1/2',
        '-y,-x,z',
        'x-y,-y,z+1/2',
        'x,x-y,z',
    ]
},

{
    number          => 202,
    hall            => '-F 2 2 3 (x+1/4,y+1/4,z+1/4)',
    schoenflies     => 'Th^3',
    hermann_mauguin => 'F m -3 (a-1/4,b-1/4,c-1/4)',
    universal_h_m   => 'F m -3 (a-1/4,b-1/4,c-1/4)',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x,-y+1/2,-z+1/2',
        '-x+1/2,y,-z+1/2',
        'z,x,y',
        '-z+1/2,-x+1/2,y',
        'z,-x+1/2,-y+1/2',
        '-z+1/2,x,-y+1/2',
        'y,z,x',
        'y,-z+1/2,-x+1/2',
        '-y+1/2,z,-x+1/2',
        '-y+1/2,-z+1/2,x',
        '-x+1/2,-y+1/2,-z+1/2',
        'x,y,-z+1/2',
        '-x+1/2,y,z',
        'x,-y+1/2,z',
        '-z+1/2,-x+1/2,-y+1/2',
        'z,x,-y+1/2',
        '-z+1/2,x,y',
        'z,-x+1/2,y',
        '-y+1/2,-z+1/2,-x+1/2',
        '-y+1/2,z,x',
        'y,-z+1/2,x',
        'y,z,-x+1/2',
        'x,y+1/2,z+1/2',
        '-x+1/2,-y,z+1/2',
        'x,-y,-z',
        '-x+1/2,y+1/2,-z',
        'z,x+1/2,y+1/2',
        '-z+1/2,-x,y+1/2',
        'z,-x,-y',
        '-z+1/2,x+1/2,-y',
        'y,z+1/2,x+1/2',
        'y,-z,-x',
        '-y+1/2,z+1/2,-x',
        '-y+1/2,-z,x+1/2',
        '-x+1/2,-y,-z',
        'x,y+1/2,-z',
        '-x+1/2,y+1/2,z+1/2',
        'x,-y,z+1/2',
        '-z+1/2,-x,-y',
        'z,x+1/2,-y',
        '-z+1/2,x+1/2,y+1/2',
        'z,-x,y+1/2',
        '-y+1/2,-z,-x',
        '-y+1/2,z+1/2,x+1/2',
        'y,-z,x+1/2',
        'y,z+1/2,-x',
        'x+1/2,y,z+1/2',
        '-x,-y+1/2,z+1/2',
        'x+1/2,-y+1/2,-z',
        '-x,y,-z',
        'z+1/2,x,y+1/2',
        '-z,-x+1/2,y+1/2',
        'z+1/2,-x+1/2,-y',
        '-z,x,-y',
        'y+1/2,z,x+1/2',
        'y+1/2,-z+1/2,-x',
        '-y,z,-x',
        '-y,-z+1/2,x+1/2',
        '-x,-y+1/2,-z',
        'x+1/2,y,-z',
        '-x,y,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        '-z,-x+1/2,-y',
        'z+1/2,x,-y',
        '-z,x,y+1/2',
        'z+1/2,-x+1/2,y+1/2',
        '-y,-z+1/2,-x',
        '-y,z,x+1/2',
        'y+1/2,-z+1/2,x+1/2',
        'y+1/2,z,-x',
        'x+1/2,y+1/2,z',
        '-x,-y,z',
        'x+1/2,-y,-z+1/2',
        '-x,y+1/2,-z+1/2',
        'z+1/2,x+1/2,y',
        '-z,-x,y',
        'z+1/2,-x,-y+1/2',
        '-z,x+1/2,-y+1/2',
        'y+1/2,z+1/2,x',
        'y+1/2,-z,-x+1/2',
        '-y,z+1/2,-x+1/2',
        '-y,-z,x',
        '-x,-y,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-x,y+1/2,z',
        'x+1/2,-y,z',
        '-z,-x,-y+1/2',
        'z+1/2,x+1/2,-y+1/2',
        '-z,x+1/2,y',
        'z+1/2,-x,y',
        '-y,-z,-x+1/2',
        '-y,z+1/2,x',
        'y+1/2,-z,x',
        'y+1/2,z+1/2,-x+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'x,-y,-z',
        '-x,y,-z',
        'z,x,y',
        '-z,-x,y',
        'z,-x,-y',
        '-z,x,-y',
        'y,z,x',
        'y,-z,-x',
        '-y,z,-x',
        '-y,-z,x',
        '-x+1/2,-y+1/2,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        '-z+1/2,-x+1/2,-y+1/2',
        'z+1/2,x+1/2,-y+1/2',
        '-z+1/2,x+1/2,y+1/2',
        'z+1/2,-x+1/2,y+1/2',
        '-y+1/2,-z+1/2,-x+1/2',
        '-y+1/2,z+1/2,x+1/2',
        'y+1/2,-z+1/2,x+1/2',
        'y+1/2,z+1/2,-x+1/2',
    ]
},

{
    number          => 204,
    hall            => '-I 2 2 3 (x+1/4,y+1/4,z+1/4)',
    schoenflies     => 'Th^5',
    hermann_mauguin => 'I m -3 (a-1/4,b-1/4,c-1/4)',
    universal_h_m   => 'I m -3 (a-1/4,b-1/4,c-1/4)',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x,-y+1/2,-z+1/2',
        '-x+1/2,y,-z+1/2',
        'z,x,y',
        '-z+1/2,-x+1/2,y',
        'z,-x+1/2,-y+1/2',
        '-z+1/2,x,-y+1/2',
        'y,z,x',
        'y,-z+1/2,-x+1/2',
        '-y+1/2,z,-x+1/2',
        '-y+1/2,-z+1/2,x',
        '-x+1/2,-y+1/2,-z+1/2',
        'x,y,-z+1/2',
        '-x+1/2,y,z',
        'x,-y+1/2,z',
        '-z+1/2,-x+1/2,-y+1/2',
        'z,x,-y+1/2',
        '-z+1/2,x,y',
        'z,-x+1/2,y',
        '-y+1/2,-z+1/2,-x+1/2',
        '-y+1/2,z,x',
        'y,-z+1/2,x',
        'y,z,-x+1/2',
        'x+1/2,y+1/2,z+1/2',
        '-x,-y,z+1/2',
        'x+1/2,-y,-z',
        '-x,y+1/2,-z',
        'z+1/2,x+1/2,y+1/2',
        '-z,-x,y+1/2',
        'z+1/2,-x,-y',
        '-z,x+1/2,-y',
        'y+1/2,z+1/2,x+1/2',
        'y+1/2,-z,-x',
        '-y,z+1/2,-x',
        '-y,-z,x+1/2',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
        '-x,y+1/2,z+1/2',
        'x+1/2,-y,z+1/2',
        '-z,-x,-y',
        'z+1/2,x+1/2,-y',
        '-z,x+1/2,y+1/2',
        'z+1/2,-x,y+1/2',
        '-y,-z,-x',
        '-y,z+1/2,x+1/2',
        'y+1/2,-z,x+1/2',
        'y+1/2,z+1/2,-x',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,-y+1/2,z',
        'x,-y+1/2,-z+1/2',
        '-x+1/2,y,-z+1/2',
        'z,x,y',
        '-z+1/2,-x+1/2,y',
        'z,-x+1/2,-y+1/2',
        '-z+1/2,x,-y+1/2',
        'y,z,x',
        'y,-z+1/2,-x+1/2',
        '-y+1/2,z,-x+1/2',
        '-y+1/2,-z+1/2,x',
        '-x,-y,-z',
        'x+1/2,y+1/2,-z',
        '-x,y+1/2,z+1/2',
        'x+1/2,-y,z+1/2',
        '-z,-x,-y',
        'z+1/2,x+1/2,-y',
        '-z,x+1/2,y+1/2',
        'z+1/2,-x,y+1/2',
        '-y,-z,-x',
        '-y,z+1/2,x+1/2',
        'y+1/2,-z,x+1/2',
        'y+1/2,z+1/2,-x',
    ]
},

{
    number          => 226,
    hall            => '-F 4a 2 3 (x-1/4,y-1/4,z-1/4)',
    schoenflies     => 'Oh^6',
    hermann_mauguin => 'F m -3 c (a+1/4,b+1/4,c+1/4)',
    universal_h_m   => 'F m -3 c (a+1/4,b+1/4,c+1/4)',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x,-y+1/2,-z+1/2',
        'y+1/2,x,-z+1/2',
        '-x,y+1/2,-z+1/2',
        '-y+1/2,-x,-z+1/2',
        'z,x,y',
        '-x,z,y',
        '-z,-x,y',
        'x,-z,y',
        'z,-x+1/2,-y+1/2',
        'x+1/2,z,-y+1/2',
        '-z,x+1/2,-y+1/2',
        '-x+1/2,-z,-y+1/2',
        'y,z,x',
        'y,-z,-x',
        'z,y,-x',
        '-y,z,-x',
        '-z,-y+1/2,-x+1/2',
        '-y+1/2,-z+1/2,x',
        'z,-y+1/2,x+1/2',
        '-z,y+1/2,x+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        'y+1/2,-x+1/2,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-y+1/2,x+1/2,-z+1/2',
        '-x+1/2,y,z',
        '-y,-x+1/2,z',
        'x+1/2,-y,z',
        'y,x+1/2,z',
        '-z+1/2,-x+1/2,-y+1/2',
        'x+1/2,-z+1/2,-y+1/2',
        'z+1/2,x+1/2,-y+1/2',
        '-x+1/2,z+1/2,-y+1/2',
        '-z+1/2,x,y',
        '-x,-z+1/2,y',
        'z+1/2,-x,y',
        'x,z+1/2,y',
        '-y+1/2,-z+1/2,-x+1/2',
        '-y+1/2,z+1/2,x+1/2',
        '-z+1/2,-y+1/2,x+1/2',
        'y+1/2,-z+1/2,x+1/2',
        'z+1/2,y,x',
        'y,z,-x+1/2',
        '-z+1/2,y,-x',
        'z+1/2,-y,-x',
        'x,y+1/2,z+1/2',
        '-y,x+1/2,z+1/2',
        '-x,-y+1/2,z+1/2',
        'y,-x+1/2,z+1/2',
        'x,-y,-z',
        'y+1/2,x+1/2,-z',
        '-x,y,-z',
        '-y+1/2,-x+1/2,-z',
        'z,x+1/2,y+1/2',
        '-x,z+1/2,y+1/2',
        '-z,-x+1/2,y+1/2',
        'x,-z+1/2,y+1/2',
        'z,-x,-y',
        'x+1/2,z+1/2,-y',
        '-z,x,-y',
        '-x+1/2,-z+1/2,-y',
        'y,z+1/2,x+1/2',
        'y,-z+1/2,-x+1/2',
        'z,y+1/2,-x+1/2',
        '-y,z+1/2,-x+1/2',
        '-z,-y,-x',
        '-y+1/2,-z,x+1/2',
        'z,-y,x',
        '-z,y,x',
        '-x+1/2,-y,-z',
        'y+1/2,-x,-z',
        'x+1/2,y,-z',
        '-y+1/2,x,-z',
        '-x+1/2,y+1/2,z+1/2',
        '-y,-x,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        'y,x,z+1/2',
        '-z+1/2,-x,-y',
        'x+1/2,-z,-y',
        'z+1/2,x,-y',
        '-x+1/2,z,-y',
        '-z+1/2,x+1/2,y+1/2',
        '-x,-z,y+1/2',
        'z+1/2,-x+1/2,y+1/2',
        'x,z,y+1/2',
        '-y+1/2,-z,-x',
        '-y+1/2,z,x',
        '-z+1/2,-y,x',
        'y+1/2,-z,x',
        'z+1/2,y+1/2,x+1/2',
        'y,z+1/2,-x',
        '-z+1/2,y+1/2,-x+1/2',
        'z+1/2,-y+1/2,-x+1/2',
        'x+1/2,y,z+1/2',
        '-y+1/2,x,z+1/2',
        '-x+1/2,-y,z+1/2',
        'y+1/2,-x,z+1/2',
        'x+1/2,-y+1/2,-z',
        'y,x,-z',
        '-x+1/2,y+1/2,-z',
        '-y,-x,-z',
        'z+1/2,x,y+1/2',
        '-x+1/2,z,y+1/2',
        '-z+1/2,-x,y+1/2',
        'x+1/2,-z,y+1/2',
        'z+1/2,-x+1/2,-y',
        'x,z,-y',
        '-z+1/2,x+1/2,-y',
        '-x,-z,-y',
        'y+1/2,z,x+1/2',
        'y+1/2,-z,-x+1/2',
        'z+1/2,y,-x+1/2',
        '-y+1/2,z,-x+1/2',
        '-z+1/2,-y+1/2,-x',
        '-y,-z+1/2,x+1/2',
        'z+1/2,-y+1/2,x',
        '-z+1/2,y+1/2,x',
        '-x,-y+1/2,-z',
        'y,-x+1/2,-z',
        'x,y+1/2,-z',
        '-y,x+1/2,-z',
        '-x,y,z+1/2',
        '-y+1/2,-x+1/2,z+1/2',
        'x,-y,z+1/2',
        'y+1/2,x+1/2,z+1/2',
        '-z,-x+1/2,-y',
        'x,-z+1/2,-y',
        'z,x+1/2,-y',
        '-x,z+1/2,-y',
        '-z,x,y+1/2',
        '-x+1/2,-z+1/2,y+1/2',
        'z,-x,y+1/2',
        'x+1/2,z+1/2,y+1/2',
        '-y,-z+1/2,-x',
        '-y,z+1/2,x',
        '-z,-y+1/2,x',
        'y,-z+1/2,x',
        'z,y,x+1/2',
        'y+1/2,z,-x',
        '-z,y,-x+1/2',
        'z,-y,-x+1/2',
        'x+1/2,y+1/2,z',
        '-y+1/2,x+1/2,z',
        '-x+1/2,-y+1/2,z',
        'y+1/2,-x+1/2,z',
        'x+1/2,-y,-z+1/2',
        'y,x+1/2,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-y,-x+1/2,-z+1/2',
        'z+1/2,x+1/2,y',
        '-x+1/2,z+1/2,y',
        '-z+1/2,-x+1/2,y',
        'x+1/2,-z+1/2,y',
        'z+1/2,-x,-y+1/2',
        'x,z+1/2,-y+1/2',
        '-z+1/2,x,-y+1/2',
        '-x,-z+1/2,-y+1/2',
        'y+1/2,z+1/2,x',
        'y+1/2,-z+1/2,-x',
        'z+1/2,y+1/2,-x',
        '-y+1/2,z+1/2,-x',
        '-z+1/2,-y,-x+1/2',
        '-y,-z,x',
        'z+1/2,-y,x+1/2',
        '-z+1/2,y,x+1/2',
        '-x,-y,-z+1/2',
        'y,-x,-z+1/2',
        'x,y,-z+1/2',
        '-y,x,-z+1/2',
        '-x,y+1/2,z',
        '-y+1/2,-x,z',
        'x,-y+1/2,z',
        'y+1/2,x,z',
        '-z,-x,-y+1/2',
        'x,-z,-y+1/2',
        'z,x,-y+1/2',
        '-x,z,-y+1/2',
        '-z,x+1/2,y',
        '-x+1/2,-z,y',
        'z,-x+1/2,y',
        'x+1/2,z,y',
        '-y,-z,-x+1/2',
        '-y,z,x+1/2',
        '-z,-y,x+1/2',
        'y,-z,x+1/2',
        'z,y+1/2,x',
        'y+1/2,z+1/2,-x+1/2',
        '-z,y+1/2,-x',
        'z,-y+1/2,-x',
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        'x,-y,-z',
        'y,x,-z',
        '-x,y,-z',
        '-y,-x,-z',
        'z,x,y',
        '-x,z,y',
        '-z,-x,y',
        'x,-z,y',
        'z,-x,-y',
        'x,z,-y',
        '-z,x,-y',
        '-x,-z,-y',
        'y,z,x',
        'y,-z,-x',
        'z,y,-x',
        '-y,z,-x',
        '-z,-y,-x',
        '-y,-z,x',
        'z,-y,x',
        '-z,y,x',
        '-x+1/2,-y+1/2,-z+1/2',
        'y+1/2,-x+1/2,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-y+1/2,x+1/2,-z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        '-y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        'y+1/2,x+1/2,z+1/2',
        '-z+1/2,-x+1/2,-y+1/2',
        'x+1/2,-z+1/2,-y+1/2',
        'z+1/2,x+1/2,-y+1/2',
        '-x+1/2,z+1/2,-y+1/2',
        '-z+1/2,x+1/2,y+1/2',
        '-x+1/2,-z+1/2,y+1/2',
        'z+1/2,-x+1/2,y+1/2',
        'x+1/2,z+1/2,y+1/2',
        '-y+1/2,-z+1/2,-x+1/2',
        '-y+1/2,z+1/2,x+1/2',
        '-z+1/2,-y+1/2,x+1/2',
        'y+1/2,-z+1/2,x+1/2',
        'z+1/2,y+1/2,x+1/2',
        'y+1/2,z+1/2,-x+1/2',
        '-z+1/2,y+1/2,-x+1/2',
        'z+1/2,-y+1/2,-x+1/2',
    ]
},

{
    number          => 229,
    hall            => '-I 4 2 3 (x+1/4,y+1/4,z+1/4)',
    schoenflies     => 'Oh^9',
    hermann_mauguin => 'I m -3 m (a-1/4,b-1/4,c-1/4)',
    universal_h_m   => 'I m -3 m (a-1/4,b-1/4,c-1/4)',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x,z',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z',
        'x,-y+1/2,-z+1/2',
        'y,x,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-y+1/2,-x+1/2,-z+1/2',
        'z,x,y',
        '-x+1/2,z,y',
        '-z+1/2,-x+1/2,y',
        'x,-z+1/2,y',
        'z,-x+1/2,-y+1/2',
        'x,z,-y+1/2',
        '-z+1/2,x,-y+1/2',
        '-x+1/2,-z+1/2,-y+1/2',
        'y,z,x',
        'y,-z+1/2,-x+1/2',
        'z,y,-x+1/2',
        '-y+1/2,z,-x+1/2',
        '-z+1/2,-y+1/2,-x+1/2',
        '-y+1/2,-z+1/2,x',
        'z,-y+1/2,x',
        '-z+1/2,y,x',
        '-x+1/2,-y+1/2,-z+1/2',
        'y,-x+1/2,-z+1/2',
        'x,y,-z+1/2',
        '-y+1/2,x,-z+1/2',
        '-x+1/2,y,z',
        '-y+1/2,-x+1/2,z',
        'x,-y+1/2,z',
        'y,x,z',
        '-z+1/2,-x+1/2,-y+1/2',
        'x,-z+1/2,-y+1/2',
        'z,x,-y+1/2',
        '-x+1/2,z,-y+1/2',
        '-z+1/2,x,y',
        '-x+1/2,-z+1/2,y',
        'z,-x+1/2,y',
        'x,z,y',
        '-y+1/2,-z+1/2,-x+1/2',
        '-y+1/2,z,x',
        '-z+1/2,-y+1/2,x',
        'y,-z+1/2,x',
        'z,y,x',
        'y,z,-x+1/2',
        '-z+1/2,y,-x+1/2',
        'z,-y+1/2,-x+1/2',
        'x+1/2,y+1/2,z+1/2',
        '-y,x+1/2,z+1/2',
        '-x,-y,z+1/2',
        'y+1/2,-x,z+1/2',
        'x+1/2,-y,-z',
        'y+1/2,x+1/2,-z',
        '-x,y+1/2,-z',
        '-y,-x,-z',
        'z+1/2,x+1/2,y+1/2',
        '-x,z+1/2,y+1/2',
        '-z,-x,y+1/2',
        'x+1/2,-z,y+1/2',
        'z+1/2,-x,-y',
        'x+1/2,z+1/2,-y',
        '-z,x+1/2,-y',
        '-x,-z,-y',
        'y+1/2,z+1/2,x+1/2',
        'y+1/2,-z,-x',
        'z+1/2,y+1/2,-x',
        '-y,z+1/2,-x',
        '-z,-y,-x',
        '-y,-z,x+1/2',
        'z+1/2,-y,x+1/2',
        '-z,y+1/2,x+1/2',
        '-x,-y,-z',
        'y+1/2,-x,-z',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z',
        '-x,y+1/2,z+1/2',
        '-y,-x,z+1/2',
        'x+1/2,-y,z+1/2',
        'y+1/2,x+1/2,z+1/2',
        '-z,-x,-y',
        'x+1/2,-z,-y',
        'z+1/2,x+1/2,-y',
        '-x,z+1/2,-y',
        '-z,x+1/2,y+1/2',
        '-x,-z,y+1/2',
        'z+1/2,-x,y+1/2',
        'x+1/2,z+1/2,y+1/2',
        '-y,-z,-x',
        '-y,z+1/2,x+1/2',
        '-z,-y,x+1/2',
        'y+1/2,-z,x+1/2',
        'z+1/2,y+1/2,x+1/2',
        'y+1/2,z+1/2,-x',
        '-z,y+1/2,-x',
        'z+1/2,-y,-x',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x,z',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z',
        'x,-y+1/2,-z+1/2',
        'y,x,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-y+1/2,-x+1/2,-z+1/2',
        'z,x,y',
        '-x+1/2,z,y',
        '-z+1/2,-x+1/2,y',
        'x,-z+1/2,y',
        'z,-x+1/2,-y+1/2',
        'x,z,-y+1/2',
        '-z+1/2,x,-y+1/2',
        '-x+1/2,-z+1/2,-y+1/2',
        'y,z,x',
        'y,-z+1/2,-x+1/2',
        'z,y,-x+1/2',
        '-y+1/2,z,-x+1/2',
        '-z+1/2,-y+1/2,-x+1/2',
        '-y+1/2,-z+1/2,x',
        'z,-y+1/2,x',
        '-z+1/2,y,x',
        '-x,-y,-z',
        'y+1/2,-x,-z',
        'x+1/2,y+1/2,-z',
        '-y,x+1/2,-z',
        '-x,y+1/2,z+1/2',
        '-y,-x,z+1/2',
        'x+1/2,-y,z+1/2',
        'y+1/2,x+1/2,z+1/2',
        '-z,-x,-y',
        'x+1/2,-z,-y',
        'z+1/2,x+1/2,-y',
        '-x,z+1/2,-y',
        '-z,x+1/2,y+1/2',
        '-x,-z,y+1/2',
        'z+1/2,-x,y+1/2',
        'x+1/2,z+1/2,y+1/2',
        '-y,-z,-x',
        '-y,z+1/2,x+1/2',
        '-z,-y,x+1/2',
        'y+1/2,-z,x+1/2',
        'z+1/2,y+1/2,x+1/2',
        'y+1/2,z+1/2,-x',
        '-z,y+1/2,-x',
        'z+1/2,-y,-x',
    ]
},

{
    number          => 225,
    hall            => '-F 4 2 3 (x+1/4,y+1/4,z+1/4)',
    schoenflies     => 'Oh^5',
    hermann_mauguin => 'F m -3 m (a-1/4,b-1/4,c-1/4)',
    universal_h_m   => 'F m -3 m (a-1/4,b-1/4,c-1/4)',
    crystal_class   => 'cubic',
    constraints     => '$a == $b && $b == $c && ' .
                       '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x,z',
        '-x+1/2,-y+1/2,z',
        'y,-x+1/2,z',
        'x,-y+1/2,-z+1/2',
        'y,x,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-y+1/2,-x+1/2,-z+1/2',
        'z,x,y',
        '-x+1/2,z,y',
        '-z+1/2,-x+1/2,y',
        'x,-z+1/2,y',
        'z,-x+1/2,-y+1/2',
        'x,z,-y+1/2',
        '-z+1/2,x,-y+1/2',
        '-x+1/2,-z+1/2,-y+1/2',
        'y,z,x',
        'y,-z+1/2,-x+1/2',
        'z,y,-x+1/2',
        '-y+1/2,z,-x+1/2',
        '-z+1/2,-y+1/2,-x+1/2',
        '-y+1/2,-z+1/2,x',
        'z,-y+1/2,x',
        '-z+1/2,y,x',
        '-x+1/2,-y+1/2,-z+1/2',
        'y,-x+1/2,-z+1/2',
        'x,y,-z+1/2',
        '-y+1/2,x,-z+1/2',
        '-x+1/2,y,z',
        '-y+1/2,-x+1/2,z',
        'x,-y+1/2,z',
        'y,x,z',
        '-z+1/2,-x+1/2,-y+1/2',
        'x,-z+1/2,-y+1/2',
        'z,x,-y+1/2',
        '-x+1/2,z,-y+1/2',
        '-z+1/2,x,y',
        '-x+1/2,-z+1/2,y',
        'z,-x+1/2,y',
        'x,z,y',
        '-y+1/2,-z+1/2,-x+1/2',
        '-y+1/2,z,x',
        '-z+1/2,-y+1/2,x',
        'y,-z+1/2,x',
        'z,y,x',
        'y,z,-x+1/2',
        '-z+1/2,y,-x+1/2',
        'z,-y+1/2,-x+1/2',
        'x,y+1/2,z+1/2',
        '-y+1/2,x+1/2,z+1/2',
        '-x+1/2,-y,z+1/2',
        'y,-x,z+1/2',
        'x,-y,-z',
        'y,x+1/2,-z',
        '-x+1/2,y+1/2,-z',
        '-y+1/2,-x,-z',
        'z,x+1/2,y+1/2',
        '-x+1/2,z+1/2,y+1/2',
        '-z+1/2,-x,y+1/2',
        'x,-z,y+1/2',
        'z,-x,-y',
        'x,z+1/2,-y',
        '-z+1/2,x+1/2,-y',
        '-x+1/2,-z,-y',
        'y,z+1/2,x+1/2',
        'y,-z,-x',
        'z,y+1/2,-x',
        '-y+1/2,z+1/2,-x',
        '-z+1/2,-y,-x',
        '-y+1/2,-z,x+1/2',
        'z,-y,x+1/2',
        '-z+1/2,y+1/2,x+1/2',
        '-x+1/2,-y,-z',
        'y,-x,-z',
        'x,y+1/2,-z',
        '-y+1/2,x+1/2,-z',
        '-x+1/2,y+1/2,z+1/2',
        '-y+1/2,-x,z+1/2',
        'x,-y,z+1/2',
        'y,x+1/2,z+1/2',
        '-z+1/2,-x,-y',
        'x,-z,-y',
        'z,x+1/2,-y',
        '-x+1/2,z+1/2,-y',
        '-z+1/2,x+1/2,y+1/2',
        '-x+1/2,-z,y+1/2',
        'z,-x,y+1/2',
        'x,z+1/2,y+1/2',
        '-y+1/2,-z,-x',
        '-y+1/2,z+1/2,x+1/2',
        '-z+1/2,-y,x+1/2',
        'y,-z,x+1/2',
        'z,y+1/2,x+1/2',
        'y,z+1/2,-x',
        '-z+1/2,y+1/2,-x',
        'z,-y,-x',
        'x+1/2,y,z+1/2',
        '-y,x,z+1/2',
        '-x,-y+1/2,z+1/2',
        'y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y+1/2,-z',
        'y+1/2,x,-z',
        '-x,y,-z',
        '-y,-x+1/2,-z',
        'z+1/2,x,y+1/2',
        '-x,z,y+1/2',
        '-z,-x+1/2,y+1/2',
        'x+1/2,-z+1/2,y+1/2',
        'z+1/2,-x+1/2,-y',
        'x+1/2,z,-y',
        '-z,x,-y',
        '-x,-z+1/2,-y',
        'y+1/2,z,x+1/2',
        'y+1/2,-z+1/2,-x',
        'z+1/2,y,-x',
        '-y,z,-x',
        '-z,-y+1/2,-x',
        '-y,-z+1/2,x+1/2',
        'z+1/2,-y+1/2,x+1/2',
        '-z,y,x+1/2',
        '-x,-y+1/2,-z',
        'y+1/2,-x+1/2,-z',
        'x+1/2,y,-z',
        '-y,x,-z',
        '-x,y,z+1/2',
        '-y,-x+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        'y+1/2,x,z+1/2',
        '-z,-x+1/2,-y',
        'x+1/2,-z+1/2,-y',
        'z+1/2,x,-y',
        '-x,z,-y',
        '-z,x,y+1/2',
        '-x,-z+1/2,y+1/2',
        'z+1/2,-x+1/2,y+1/2',
        'x+1/2,z,y+1/2',
        '-y,-z+1/2,-x',
        '-y,z,x+1/2',
        '-z,-y+1/2,x+1/2',
        'y+1/2,-z+1/2,x+1/2',
        'z+1/2,y,x+1/2',
        'y+1/2,z,-x',
        '-z,y,-x',
        'z+1/2,-y+1/2,-x',
        'x+1/2,y+1/2,z',
        '-y,x+1/2,z',
        '-x,-y,z',
        'y+1/2,-x,z',
        'x+1/2,-y,-z+1/2',
        'y+1/2,x+1/2,-z+1/2',
        '-x,y+1/2,-z+1/2',
        '-y,-x,-z+1/2',
        'z+1/2,x+1/2,y',
        '-x,z+1/2,y',
        '-z,-x,y',
        'x+1/2,-z,y',
        'z+1/2,-x,-y+1/2',
        'x+1/2,z+1/2,-y+1/2',
        '-z,x+1/2,-y+1/2',
        '-x,-z,-y+1/2',
        'y+1/2,z+1/2,x',
        'y+1/2,-z,-x+1/2',
        'z+1/2,y+1/2,-x+1/2',
        '-y,z+1/2,-x+1/2',
        '-z,-y,-x+1/2',
        '-y,-z,x',
        'z+1/2,-y,x',
        '-z,y+1/2,x',
        '-x,-y,-z+1/2',
        'y+1/2,-x,-z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        '-y,x+1/2,-z+1/2',
        '-x,y+1/2,z',
        '-y,-x,z',
        'x+1/2,-y,z',
        'y+1/2,x+1/2,z',
        '-z,-x,-y+1/2',
        'x+1/2,-z,-y+1/2',
        'z+1/2,x+1/2,-y+1/2',
        '-x,z+1/2,-y+1/2',
        '-z,x+1/2,y',
        '-x,-z,y',
        'z+1/2,-x,y',
        'x+1/2,z+1/2,y',
        '-y,-z,-x+1/2',
        '-y,z+1/2,x',
        '-z,-y,x',
        'y+1/2,-z,x',
        'z+1/2,y+1/2,x',
        'y+1/2,z+1/2,-x+1/2',
        '-z,y+1/2,-x+1/2',
        'z+1/2,-y,-x+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x+1/2,z+1/2',
        '-x,-y,z',
        'y+1/2,-x+1/2,z+1/2',
        'x,-y,-z',
        'y+1/2,x+1/2,-z+1/2',
        '-x,y,-z',
        '-y+1/2,-x+1/2,-z+1/2',
        'z,x,y',
        '-x+1/2,z+1/2,y+1/2',
        '-z,-x,y',
        'x+1/2,-z+1/2,y+1/2',
        'z,-x,-y',
        'x+1/2,z+1/2,-y+1/2',
        '-z,x,-y',
        '-x+1/2,-z+1/2,-y+1/2',
        'y,z,x',
        'y,-z,-x',
        'z+1/2,y+1/2,-x+1/2',
        '-y,z,-x',
        '-z+1/2,-y+1/2,-x+1/2',
        '-y,-z,x',
        'z+1/2,-y+1/2,x+1/2',
        '-z+1/2,y+1/2,x+1/2',
        '-x+1/2,-y+1/2,-z+1/2',
        'y,-x,-z',
        'x+1/2,y+1/2,-z+1/2',
        '-y,x,-z',
        '-x+1/2,y+1/2,z+1/2',
        '-y,-x,z',
        'x+1/2,-y+1/2,z+1/2',
        'y,x,z',
        '-z+1/2,-x+1/2,-y+1/2',
        'x,-z,-y',
        'z+1/2,x+1/2,-y+1/2',
        '-x,z,-y',
        '-z+1/2,x+1/2,y+1/2',
        '-x,-z,y',
        'z+1/2,-x+1/2,y+1/2',
        'x,z,y',
        '-y+1/2,-z+1/2,-x+1/2',
        '-y+1/2,z+1/2,x+1/2',
        '-z,-y,x',
        'y+1/2,-z+1/2,x+1/2',
        'z,y,x',
        'y+1/2,z+1/2,-x+1/2',
        '-z,y,-x',
        'z,-y,-x',
    ]
},

# Extra settings determined for those structures that are in COD, have
# X-centered superspace groups and for which the 3D average space groups
# could not be derived from their symmetry operators:

{
    number          => 100,
    hall            => 'P 4 -2ab (x,y,1/2*z)',
    schoenflies     => 'C4v^2',
    hermann_mauguin => 'P 4 b m',
    universal_h_m   => 'P 4 b m (a,b,2*c)',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        '-x+1/2,y+1/2,z',
        '-y+1/2,-x+1/2,z',
        'x+1/2,-y+1/2,z',
        'y+1/2,x+1/2,z',
        'x,y,z+1/2',
        '-y,x,z+1/2',
        '-x,-y,z+1/2',
        'y,-x,z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        '-y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        'y+1/2,x+1/2,z+1/2'
    ],
    ncsym => [
        'x,y,z',
        '-y,x,z',
        '-x,-y,z',
        'y,-x,z',
        '-x+1/2,y+1/2,z',
        '-y+1/2,-x+1/2,z',
        'x+1/2,-y+1/2,z',
        'y+1/2,x+1/2,z',
        'x,y,z+1/2',
        '-y,x,z+1/2',
        '-x,-y,z+1/2',
        'y,-x,z+1/2',
        '-x+1/2,y+1/2,z+1/2',
        '-y+1/2,-x+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        'y+1/2,x+1/2,z+1/2'
    ],
},

{
    number          => 9,
    hall            => 'C -2yc (1/2*x,y,-1/2*x+z)',
    schoenflies     => 'Cs^4',
    hermann_mauguin => 'C 1 c 1',
    universal_h_m   => 'C 1 c 1 (2*a+c,b,c)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,-y,z+1/2',
        'x+1/2,y,z+1/2',
        'x+1/2,-y,z',
        'x+1/4,y+1/2,z+3/4',
        'x+1/4,-y+1/2,z+1/4',
        'x+3/4,y+1/2,z+1/4',
        'x+3/4,-y+1/2,z+3/4'
    ],
    ncsym => [
        'x,y,z',
        'x,-y,z+1/2',
        'x+1/2,y,z+1/2',
        'x+1/2,-y,z',
    ],
},

{
    number          => 26,
    hall            => 'P 2c -2 (1/2*x,y,z)',
    schoenflies     => 'C2v^2',
    hermann_mauguin => 'P m c 21',
    universal_h_m   => 'P m c 21 (2*a,b,c)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y,z',
        'x,-y,z+1/2',
        '-x,-y,z+1/2',
        'x+1/2,y,z',
        '-x+1/2,y,z',
        'x+1/2,-y,z+1/2',
        '-x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,y,z',
        'x,-y,z+1/2',
        '-x,-y,z+1/2',
    ],
},

{
    number          => 35,
    hall            => 'C 2 -2 (1/2*z,x,y)',
    schoenflies     => 'C2v^11',
    hermann_mauguin => 'C m m 2',
    universal_h_m   => 'C m m 2 (2*c,a,b)',
    crystal_class   => 'orthorombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x,-y,z',
        'x,y,-z',
        'x,-y,-z',
        'x,y+1/2,z+1/2',
        'x,-y+1/2,z+1/2',
        'x,y+1/2,-z+1/2',
        'x,-y+1/2,-z+1/2',
        'x+1/2,y,z',
        'x+1/2,-y,z',
        'x+1/2,y,-z',
        'x+1/2,-y,-z',
        'x+1/2,y+1/2,z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        'x+1/2,y+1/2,-z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x,-y,z',
        'x,y,-z',
        'x,-y,-z',
    ],
},

{
    number          => 14,
    hall            => '-P 2ybc (-1/4*x+1/2*z,1/2*x,y)',
    schoenflies     => 'C2h^5',
    hermann_mauguin => 'P 1 21/c 1',
    universal_h_m   => 'P 1 21/c 1 (2*c,2*a+c,b)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/4,-y,z+1/2',
        '-x,-y,-z',
        'x+3/4,y,-z+1/2',
        'x+3/4,y+1/2,z',
        '-x,-y+1/2,z+1/2',
        '-x+3/4,-y+1/2,-z',
        'x+1/2,y+1/2,-z+1/2',
        'x+1/4,y+1/2,z',
        '-x+1/2,-y+1/2,z+1/2',
        '-x+1/4,-y+1/2,-z',
        'x,y+1/2,-z+1/2',
        'x+1/2,y,z',
        '-x+3/4,-y,z+1/2',
        '-x+1/2,-y,-z',
        'x+1/4,y,-z+1/2'
    ],
    ncsym => [
        'x,y,z',
        '-x+1/4,-y,z+1/2',
        '-x,-y,-z',
        'x+3/4,y,-z+1/2',
    ],
},

{
    number          => 51,
    hall            => '-P 2a 2a (1/2*y,z,x)',
    schoenflies     => 'D2h^5',
    hermann_mauguin => 'P m m a',
    universal_h_m   => 'P m m a (2*b,c,a)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y,z',
        'x,y,-z+1/2',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'x,-y,-z',
        '-x,-y,z+1/2',
        'x,-y,z+1/2',
        'x+1/2,y,z',
        '-x+1/2,y,z',
        'x+1/2,y,-z+1/2',
        '-x+1/2,y,-z+1/2',
        '-x+1/2,-y,-z',
        'x+1/2,-y,-z',
        '-x+1/2,-y,z+1/2',
        'x+1/2,-y,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,y,z',
        'x,y,-z+1/2',
        '-x,y,-z+1/2',
        '-x,-y,-z',
        'x,-y,-z',
        '-x,-y,z+1/2',
        'x,-y,z+1/2',
    ],
},

{
    number          => 51,
    hall            => '-P 2a 2a (1/2*y,z+1/3,x-1/4)',
    schoenflies     => 'D2h^5',
    hermann_mauguin => 'P m m a',
    universal_h_m   => 'P m m a (2*b+1/4,c,a-1/3)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y,z',
        'x,y,-z',
        '-x,y,-z',
        'x+1/2,y,z',
        '-x+1/2,y,z',
        'x+1/2,y,-z',
        '-x+1/2,y,-z',
        '-x,-y+2/3,-z+1/2',
        'x,-y+2/3,-z+1/2',
        '-x,-y+2/3,z+1/2',
        'x,-y+2/3,z+1/2',
        '-x+1/2,-y+2/3,-z+1/2',
        'x+1/2,-y+2/3,-z+1/2',
        '-x+1/2,-y+2/3,z+1/2',
        'x+1/2,-y+2/3,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,y,z',
        'x,y,-z',
        '-x,y,-z',
        'x+1/2,y,z',
        '-x+1/2,y,z',
        'x+1/2,y,-z',
        '-x+1/2,y,-z',
    ],
},

{
    number          => 13,
    hall            => '-P 2yc (x,1/2*y,z)',
    schoenflies     => 'C2h^4',
    hermann_mauguin => 'P 1 2/c 1',
    universal_h_m   => 'P 1 2/c 1 (a,2*b,c)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y,-z+1/2',
        'x,y+1/2,z',
        '-x,y+1/2,-z+1/2',
        '-x,-y,-z',
        'x,-y,z+1/2',
        '-x,-y+1/2,-z',
        'x,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,y,-z+1/2',
        'x,y+1/2,z',
        '-x,y+1/2,-z+1/2',
    ],
},

{
    number          => 47,
    hall            => '-P 2 2 (1/2*x,1/2*y,z)',
    schoenflies     => 'D2h^1',
    hermann_mauguin => 'P m m m',
    universal_h_m   => 'P m m m (2*a,2*b,c)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y,z',
        'x,-y,z',
        '-x,-y,z',
        'x+1/2,y,z',
        '-x+1/2,y,z',
        'x+1/2,-y,z',
        '-x+1/2,-y,z',
        'x,y+1/2,z',
        '-x,y+1/2,z',
        'x,-y+1/2,z',
        '-x,-y+1/2,z',
        'x+1/2,y+1/2,z',
        '-x+1/2,y+1/2,z',
        'x+1/2,-y+1/2,z',
        '-x+1/2,-y+1/2,z',
        '-x,-y,-z',
        'x,-y,-z',
        '-x,y,-z',
        'x,y,-z',
        '-x+1/2,-y,-z',
        'x+1/2,-y,-z',
        '-x+1/2,y,-z',
        'x+1/2,y,-z',
        '-x,-y+1/2,-z',
        'x,-y+1/2,-z',
        '-x,y+1/2,-z',
        'x,y+1/2,-z',
        '-x+1/2,-y+1/2,-z',
        'x+1/2,-y+1/2,-z',
        '-x+1/2,y+1/2,-z',
        'x+1/2,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        '-x,y,z',
        'x,-y,z',
        '-x,-y,z',
        'x+1/2,y,z',
        '-x+1/2,y,z',
        'x+1/2,-y,z',
        '-x+1/2,-y,z',
    ],
},

{
    number          => 4,
    hall            => 'P 2yb (x+1/4,y,z)',
    schoenflies     => 'C2^2',
    hermann_mauguin => 'P 1 21 1',
    universal_h_m   => 'P 1 21 1 (a-1/4,b,c)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y+1/2,-z',
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,y+1/2,-z',
    ],
},

{
    number          => 62,
    hall            => '-P 2ac 2n (z,x,y+1/4)',
    schoenflies     => 'D2h^16',
    hermann_mauguin => 'P n m a',
    universal_h_m   => 'P n m a (c,a-1/4,b)',
    crystal_class   => 'orthorhombic',
    constraints     => '$alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x+1/2,y+1/2,-z',
        '-x,-y,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        '-x,-y,-z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        'x,y,-z',
        '-x+1/2,y+1/2,z'
    ],
    ncsym => [
        'x,y,z',
        '-x+1/2,y+1/2,-z',
        '-x,-y,z+1/2',
        'x+1/2,-y+1/2,-z+1/2',
        '-x,-y,-z+1/2',
        'x+1/2,-y+1/2,z+1/2',
        'x,y,-z',
        '-x+1/2,y+1/2,z'
    ]
},

# Extra settings for structures that were found in the COD:

{
    number          => 4,
    hall            => 'P 2ybc',
    schoenflies     => 'C2^2',
    hermann_mauguin => 'P 1 21 1',
    universal_h_m   => 'P 1 21 1 (a,b,c-1/4)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y+1/2,-z+1/2',
    ],
    ncsym => [
        'x,y,z',
        '-x,y+1/2,-z+1/2',
    ]
},

{
    number          => 7,
    hall            => 'P -2yabc',
    schoenflies     => 'Cs^2',
    hermann_mauguin => 'P 1 n 1 (a,b+1/4,c)',
    universal_h_m   => 'P 1 n 1 (a,b+1/4,c)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        'x+1/2,-y+1/2,z+1/2',
    ],
    ncsym => [
        'x,y,z',
        'x+1/2,-y+1/2,z+1/2',
    ]
},

{
    number          => 11,
    hall            => '-P 2yb (x,y+1/4,z)',
    schoenflies     => 'C2h^2',
    hermann_mauguin => 'P 1 21/m 1',
    universal_h_m   => 'P 1 21/m 1 (a,b-1/4,c)',
    crystal_class   => 'monoclinic',
    constraints     => '$alpha == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,y+1/2,-z',
        '-x,-y+1/2,-z',
        'x,-y,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,y+1/2,-z',
        '-x,-y+1/2,-z',
        'x,-y,z',
    ],
},

{
    number          => 117,
    hall            => 'P -4 -2ab (1/2*x+1/2*y,-1/2*x+1/2*y,z)',
    schoenflies     => 'D2d^7',
    hermann_mauguin => 'C -4 2 b',
    universal_h_m   => 'C -4 2 b',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-x,-y,z',
        'y,-x,-z',
        '-y,x,-z',
        'x,-y+1/2,-z',
        '-x,y+1/2,-z',
        'y,x+1/2,z',
        '-y,-x+1/2,z',
        'x+1/2,y+1/2,z',
        '-x+1/2,-y+1/2,z',
        'y+1/2,-x+1/2,-z',
        '-y+1/2,x+1/2,-z',
        'x+1/2,-y,-z',
        '-x+1/2,y,-z',
        'y+1/2,x,z',
        '-y+1/2,-x,z',
    ],
    ncsym => [
        'x,y,z',
        '-x,-y,z',
        'y,-x,-z',
        '-y,x,-z',
        'x,-y+1/2,-z',
        '-x,y+1/2,-z',
        'y,x+1/2,z',
        '-y,-x+1/2,z',
    ]
},

# The 'F 41/a d c' space group is the (a+b,-a+b,c) setting of "I 41/a c d :2"
# space group as stated in the following publication:
# Ohba, S.; Fujita, T.; Bernal, I.; "Acta Crystallographica Section C",
# 1995, 51(8), 1481-1483, 10.1107/S0108270195001521.
{
    number          => 142,
    hall            => '-I 4bd 2c (1/2*x+1/2*y,-1/2*x+1/2*y,z)',
    schoenflies     => 'D4h^20',
    hermann_mauguin => 'F 41/a d c',
    universal_h_m   => 'F 41/a d c',
    crystal_class   => 'tetragonal',
    constraints     => '$a == $b && $alpha == 90 && $beta == 90 && $gamma == 90',
    symops => [
        'x,y,z',
        '-y+1/2,x+1/4,z+1/4',
        '-x+1/4,-y+3/4,z+1/2',
        'y+3/4,-x+1/2,z+3/4',
        '-y,-x,-z+1/2',
        'x+1/2,-y+1/4,-z+3/4',
        'y+1/4,x+3/4,-z',
        '-x+3/4,y+1/2,-z+1/4',
        '-x,-y,-z',
        'y+1/2,-x+3/4,-z+3/4',
        'x+3/4,y+1/4,-z+1/2',
        '-y+1/4,x+1/2,-z+1/4',
        'y,x,z+1/2',
        '-x+1/2,y+3/4,z+1/4',
        '-y+3/4,-x+1/4,z',
        'x+1/4,-y+1/2,z+3/4',
        'x+1/2,y+1/2,z',
        '-y,x+3/4,z+1/4',
        '-x+3/4,-y+1/4,z+1/2',
        'y+1/4,-x,z+3/4',
        '-y+1/2,-x+1/2,-z+1/2',
        'x,-y+3/4,-z+3/4',
        'y+3/4,x+1/4,-z',
        '-x+1/4,y,-z+1/4',
        '-x+1/2,-y+1/2,-z',
        'y,-x+1/4,-z+3/4',
        'x+1/4,y+3/4,-z+1/2',
        '-y+3/4,x,-z+1/4',
        'y+1/2,x+1/2,z+1/2',
        '-x,y+1/4,z+1/4',
        '-y+1/4,-x+3/4,z',
        'x+3/4,-y,z+3/4',
        'x+1/2,y,z+1/2',
        '-y,x+1/4,z+3/4',
        '-x+3/4,-y+3/4,z',
        'y+1/4,-x+1/2,z+1/4',
        '-y+1/2,-x,-z',
        'x,-y+1/4,-z+1/4',
        'y+3/4,x+3/4,-z+1/2',
        '-x+1/4,y+1/2,-z+3/4',
        '-x+1/2,-y,-z+1/2',
        'y,-x+3/4,-z+1/4',
        'x+1/4,y+1/4,-z',
        '-y+3/4,x+1/2,-z+3/4',
        'y+1/2,x,z',
        '-x,y+3/4,z+3/4',
        '-y+1/4,-x+1/4,z+1/2',
        'x+3/4,-y+1/2,z+1/4',
        'x,y+1/2,z+1/2',
        '-y+1/2,x+3/4,z+3/4',
        '-x+1/4,-y+1/4,z',
        'y+3/4,-x,z+1/4',
        '-y,-x+1/2,-z',
        'x+1/2,-y+3/4,-z+1/4',
        'y+1/4,x+1/4,-z+1/2',
        '-x+3/4,y,-z+3/4',
        '-x,-y+1/2,-z+1/2',
        'y+1/2,-x+1/4,-z+1/4',
        'x+3/4,y+3/4,-z',
        '-y+1/4,x,-z+3/4',
        'y,x+1/2,z',
        '-x+1/2,y+1/4,z+3/4',
        '-y+3/4,-x+3/4,z+1/2',
        'x+1/4,-y,z+1/4',
    ],
    ncsym => [
        'x,y,z',
        '-y+1/2,x+1/4,z+1/4',
        '-x+1/4,-y+3/4,z+1/2',
        'y+3/4,-x+1/2,z+3/4',
        '-y,-x,-z+1/2',
        'x+1/2,-y+1/4,-z+3/4',
        'y+1/4,x+3/4,-z',
        '-x+3/4,y+1/2,-z+1/4',
        '-x,-y,-z',
        'y+1/2,-x+3/4,-z+3/4',
        'x+3/4,y+1/4,-z+1/2',
        '-y+1/4,x+1/2,-z+1/4',
        'y,x,z+1/2',
        '-x+1/2,y+3/4,z+1/4',
        '-y+3/4,-x+1/4,z',
        'x+1/4,-y+1/2,z+3/4',
    ],
},

);

1;
