## Max Howell, 2005

BOLD   ="\033[1m"
RED    ="\033[91m"
GREEN  ="\033[92m"
YELLOW ="\033[93m"
CYAN   ="\033[96m"
NORMAL ="\033[0m"

import os

def exists( env ):
   return true

def generate( env ):

   if 'configure' in env['TARGS']:
      xine_lib_test_source_file = """
            #include <qstring.h>
            #include <xine.h>

            int main( int argc, char **argv )
            {
               if( XINE_MAJOR_VERSION < 1 )
                  return 1;

               const QString version( XINE_VERSION );

               // eg. VERSION 1.0
               if( version[1] == '.' )
                  return 0;

               if( version == "1-cvs" )
                  return 0;

               if( version.startsWith( "1-rc" ) && QString(version[4]).toInt() > 3 )
                  return 0;

               return 2; //too old
            }"""

      def CheckKdeLibs( context ):
         # ideally should be able to tell bksys what version we need
         context.Message( 'Checking for KDElibs 3.3...' )
         kde_version = os.popen("kde-config --version|grep KDE").read().strip().split()[1]
         result = int( kde_version[0] ) == 3 and int( kde_version[2] ) >= 3
         context.Result( result )
         return result

      def CheckXineLib( context ):
         context.Message('Checking for xine-lib 1.0...')
         result = context.TryLink(xine_lib_test_source_file, '.cpp')
         context.Result(result)
         return result


      # prolly best to use a fresh env
      # this seems to import the user's CXXFLAGS, etc., which may break
      confenv = env.Copy()
      configure = confenv.Configure(custom_tests = {'CheckXineLib' : CheckXineLib, 'CheckKdeLibs' : CheckKdeLibs}, log_file='configure.log')
      confenv.AppendUnique(LIBS = 'qt-mt')
      confenv.AppendUnique(LINKFLAGS = '-L/usr/X11R6/lib')

      if not configure.CheckKdeLibs():
         print #         1         2         3         4         5         6         7         8'
         print 'Configure could not detect KDElibs 3.3, which is required for Codeine to '
         print 'compile.'
         print
         confenv.Exit( 1 )

      if not configure.CheckLibWithHeader( 'xine', 'xine.h', 'c++' ):
         print #         1         2         3         4         5         6         7         8'
         print 'Configure could not find either the xine library or header on your system. You '
         print 'should ammend the relevant paths. If you know which ones please email me so I '
         print 'can update this message!'
         print
         confenv.Exit( 2 )

      if not configure.CheckXineLib():
         print #         1         2         3         4         5         6         7         8'
         print 'Your xine-lib is either too old, or can not be linked against. Sorry for not '
         print 'being more specific..'
         print
         confenv.Exit( 3 )

      if not configure.CheckLibWithHeader( 'Xtst', 'X11/extensions/XTest.h', 'c' ):
         print #         1         2         3         4         5         6         7         8'
         print 'Configure could not find either the XTest library or header on your system. You '
         print 'should ammend the relevant paths. If you know which ones please email me so I '
         print 'can update this message!'
         print
         confenv.Exit( 4 )

      env = configure.Finish()
