// (c) 2004 Max Howell (max.howell@methylblue.com)
// See COPYING file for licensing information

#ifndef CODEINEMAINWINDOW_H
#define CODEINEMAINWINDOW_H

#include "codeine.h"
#include <kmainwindow.h>

class KURL;
class QLabel;
class QPopupMenu;
class QSlider;


namespace Codeine
{
   class MainWindow : public KMainWindow
   {
   Q_OBJECT

      MainWindow();
     ~MainWindow();

      friend int ::main( int, char** );

      enum { SubtitleChannelsMenuItemId = 2000, AudioChannelsMenuItemId, AspectRatioMenuItemId };

   public slots:
      void play();
      void playMedia( bool show_welcome_dialog = false );

      void configure();
      void streamInformation();
      void captureFrame();

   private slots:
      void engineMessage( const QString& );
      void engineStateChanged( Engine::State );
      void init();
      void showTime( int = -1 );
      void setChannels( const QStringList& );
      void fullScreenToggled( bool );
      void aboutToShowMenu();

   private:
      void setupActions();

      bool load( const KURL& );
      bool open( const KURL& );

      QPopupMenu *menu( const char *name );

      virtual void timerEvent( QTimerEvent* );
      virtual void dragEnterEvent( QDragEnterEvent* );
      virtual void dropEvent( QDropEvent* );
      virtual void keyPressEvent( QKeyEvent* );
      virtual void mouseMoveEvent( QMouseEvent* );

      virtual void saveProperties( KConfig* );
      virtual void readProperties( KConfig* );

      virtual bool queryExit();

      QSlider *m_positionSlider;
      QLabel  *m_timeLabel;
      QLabel  *m_titleLabel;
      QWidget *m_analyzer;

      //undefined
      MainWindow( const MainWindow& );
      MainWindow &operator=( const MainWindow& );
   };
}

#endif
