//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
// copyright            : (C) 2014 The CodeLite Team
// file name            : pp_lexer.cpp
//
// -------------------------------------------------------------------------
// A
//              _____           _      _     _ _
//             /  __ \         | |    | |   (_) |
//             | /  \/ ___   __| | ___| |    _| |_ ___
//             | |    / _ \ / _  |/ _ \ |   | | __/ _ )
//             | \__/\ (_) | (_| |  __/ |___| | ||  __/
//              \____/\___/ \__,_|\___\_____/_|\__\___|
//
//                                                  F i l e
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


#line 3 "lex.pp_.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define yy_create_buffer pp__create_buffer
#define yy_delete_buffer pp__delete_buffer
#define yy_flex_debug pp__flex_debug
#define yy_init_buffer pp__init_buffer
#define yy_flush_buffer pp__flush_buffer
#define yy_load_buffer_state pp__load_buffer_state
#define yy_switch_to_buffer pp__switch_to_buffer
#define yyin pp_in
#define yyleng pp_leng
#define yylex pp_lex
#define yylineno pp_lineno
#define yyout pp_out
#define yyrestart pp_restart
#define yytext pp_text
#define yywrap pp_wrap
#define yyalloc pp_alloc
#define yyrealloc pp_realloc
#define yyfree pp_free

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 35
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

/* C99 requires __STDC__ to be defined as 1. */
#if defined (__STDC__)

#define YY_USE_CONST

#endif	/* defined (__STDC__) */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE pp_restart(pp_in  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

extern int pp_leng;

extern FILE *pp_in, *pp_out;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    /* Note: We specifically omit the test for yy_rule_can_match_eol because it requires
     *       access to the local variable yy_act. Since yyless() is a macro, it would break
     *       existing scanners that call yyless() from OUTSIDE pp_lex. 
     *       One obvious solution it to make yy_act a global. I tried that, and saw
     *       a 5% performance hit in a non-pp_lineno scanner, because yy_act is
     *       normally declared as a register variable-- so it is not worth it.
     */
    #define  YY_LESS_LINENO(n) \
            do { \
                int yyl;\
                for ( yyl = n; yyl < pp_leng; ++yyl )\
                    if ( pp_text[yyl] == '\n' )\
                        --pp_lineno;\
            }while(0)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up pp_text. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up pp_text again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via pp_restart()), so that the user can continue scanning by
	 * just pointing pp_in at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = 0; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when pp_text is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int pp_leng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow pp_wrap()'s to do buffer switches
 * instead of setting up a fresh pp_in.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void pp_restart (FILE *input_file  );
void pp__switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE pp__create_buffer (FILE *file,int size  );
void pp__delete_buffer (YY_BUFFER_STATE b  );
void pp__flush_buffer (YY_BUFFER_STATE b  );
void pp_push_buffer_state (YY_BUFFER_STATE new_buffer  );
void pp_pop_buffer_state (void );

static void pp_ensure_buffer_stack (void );
static void pp__load_buffer_state (void );
static void pp__init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER pp__flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE pp__scan_buffer (char *base,yy_size_t size  );
YY_BUFFER_STATE pp__scan_string (yyconst char *yy_str  );
YY_BUFFER_STATE pp__scan_bytes (yyconst char *bytes,int len  );

void *pp_alloc (yy_size_t  );
void *pp_realloc (void *,yy_size_t  );
void pp_free (void *  );

#define yy_new_buffer pp__create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        pp_ensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            pp__create_buffer(pp_in,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        pp_ensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            pp__create_buffer(pp_in,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

typedef unsigned char YY_CHAR;

FILE *pp_in = (FILE *) 0, *pp_out = (FILE *) 0;

typedef int yy_state_type;

extern int pp_lineno;

int pp_lineno = 1;

extern char *pp_text;
#define yytext_ptr pp_text

static yy_state_type yy_get_previous_state (void );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  );
static int yy_get_next_buffer (void );
static void yy_fatal_error (yyconst char msg[]  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up pp_text.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	pp_leng = (size_t) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;

#define YY_NUM_RULES 73
#define YY_END_OF_BUFFER 74
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[210] =
    {   0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,   74,   62,
       73,   62,    5,   62,   62,   62,   64,   63,   72,   72,
       70,   69,   19,   18,    8,   19,   19,   19,   19,   19,
       44,   43,   41,   44,   50,   45,   49,   48,   50,   54,
       53,   52,   51,   61,   59,   58,   60,   61,   61,   66,
       66,   68,   67,   25,   24,   22,   23,   21,   21,   40,
       39,   40,   40,   30,   31,   38,   37,   34,   36,   29,
       29,   29,   40,    0,    4,    0,    0,    0,    2,    1,

        0,    0,   71,    0,    0,    0,    0,    7,    0,    0,
       41,   42,   46,   47,   51,   55,   56,   57,   65,   21,
       21,   35,    0,   32,   38,   29,   29,   29,   33,    0,
        0,    3,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,   42,   21,    0,   29,   29,    0,    0,
        0,    0,    0,    0,   15,   14,    0,    0,    0,    0,
        0,   21,    0,   29,   29,    0,    0,    0,    0,    0,
        0,   16,   10,    0,    0,   13,   21,    0,   29,   29,
        0,    6,   12,    0,   21,    0,   29,   29,    0,   11,
       17,   21,    0,   29,   28,    0,   21,   27,   29,    0,

       21,   29,    0,   21,   29,    9,   20,   26,    0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    5,    6,    7,    8,    1,    1,    9,   10,   11,
       12,   13,    1,   14,    1,    1,   15,   16,   17,   17,
       17,   17,   17,   17,   17,   18,   18,    1,    1,   19,
       20,   21,   22,    1,   23,   23,   23,   23,   23,   23,
       24,   24,   24,   24,   24,   25,   24,   24,   24,   24,
       24,   24,   24,   24,   24,   24,   24,   24,   24,   24,
        1,   26,    1,    1,   27,    1,   28,   28,   29,   30,

       31,   32,   24,   24,   33,   24,   24,   34,   24,   35,
       24,   36,   24,   37,   38,   37,   39,   37,   24,   40,
       24,   24,    1,   41,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst flex_int32_t yy_meta[42] =
    {   0,
        1,    1,    2,    1,    1,    1,    3,    1,    1,    4,
        1,    1,    1,    1,    1,    5,    5,    6,    1,    1,
        1,    3,    6,    7,    7,    3,    7,    5,    6,    6,
        6,    5,    7,    7,    8,    7,    8,    7,    7,    8,
        1
    } ;

static yyconst flex_int16_t yy_base[230] =
    {   0,
        0,    6,  505,  504,    9,   14,  503,  502,    0,    0,
       29,   66,  105,    0,   31,   36,  146,    0,   46,   50,
       15,   16,  501,  500,  187,    0,  228,    0,  502,  509,
      509,    4,  509,  475,   11,   13,  509,  509,  509,  485,
      509,  509,  509,  509,  509,  472,  467,    9,    5,  462,
      509,  509,    0,    1,  509,  509,  509,  509,   42,  509,
      509,  509,    0,  509,  509,  509,  509,   51,  493,  509,
      480,  509,  509,  509,  509,  509,  509,    0,  467,  509,
      509,   43,  484,  509,  509,   61,  509,  509,  509,    0,
      465,  460,  449,   60,  509,   54,   48,   64,  509,  509,

       76,  463,  509,  459,  455,   51,  456,   55,  456,  454,
        0,   84,  509,  509,    0,  509,  509,  509,  509,    0,
      454,  509,  451,  509,  254,    0,  452,  448,  509,  266,
        0,  509,  264,    0,  443,  445,  445,  445,  442,  443,
      443,  438,  435,  509,  429,  428,  423,  402,  268,  288,
      281,  311,  399,  390,  509,  509,  306,  304,  304,  294,
      300,  297,  297,  292,  290,  270,    0,   65,    0,  285,
      292,  509,  509,  290,  285,  509,  274,  277,  271,  278,
      270,  273,  509,  271,  263,  269,  261,  263,  253,  509,
      509,  252,  257,  250,    0,  245,  244,  509,  242,   64,

       62,   61,   60,   57,   54,  509,    0,    0,  509,  343,
      351,  359,  367,  375,  383,  391,  399,  407,  415,  423,
      431,  435,  439,  443,  447,  453,  459,  463,  465
    } ;

static yyconst flex_int16_t yy_def[230] =
    {   0,
      210,  210,  211,  211,  212,  212,  213,  213,  214,  214,
      215,  215,  209,   13,  216,  216,  209,   17,  217,  217,
      218,  218,  219,  219,  209,   25,  209,   27,  209,  209,
      209,  220,  209,  221,  209,  209,  209,  209,  209,  209,
      209,  209,  209,  209,  209,  209,  209,  209,  209,  209,
      209,  209,  222,  209,  209,  209,  209,  209,  209,  209,
      209,  209,  223,  209,  209,  209,  209,  209,  209,  209,
      209,  209,  209,  209,  209,  209,  209,  224,  224,  209,
      209,  209,  209,  209,  209,  209,  209,  209,  209,  225,
      225,  225,  209,  220,  209,  226,  221,  227,  209,  209,

      220,  221,  209,  209,  209,  209,  209,  209,  209,  209,
      222,  209,  209,  209,  223,  209,  209,  209,  209,  224,
      224,  209,  209,  209,  209,  225,  225,  225,  209,  220,
      228,  209,  221,  229,  209,  209,  209,  209,  209,  209,
      209,  209,  209,  209,  224,  209,  225,  225,  220,  220,
      221,  221,  209,  209,  209,  209,  209,  209,  209,  209,
      209,  224,  209,  225,  225,  220,  150,  221,  152,  209,
      209,  209,  209,  209,  209,  209,  224,  209,  225,  225,
      209,  209,  209,  209,  224,  209,  225,  225,  209,  209,
      209,  224,  209,  225,  225,  209,  224,  209,  225,  209,

      224,  225,  209,  224,  225,  209,  224,  225,    0,  209,
      209,  209,  209,  209,  209,  209,  209,  209,  209,  209,
      209,  209,  209,  209,  209,  209,  209,  209,  209
    } ;

static yyconst flex_int16_t yy_nxt[551] =
    {   0,
      209,  209,   31,  112,  112,  209,   32,   33,   31,   34,
       95,   31,   32,   33,   35,   34,   31,   31,   31,  101,
       35,   40,  102,   99,   36,  100,   40,   71,   71,   96,
       36,   44,   56,   57,  209,   56,  108,   56,   57,  109,
       56,   58,  106,  107,   45,   59,   58,   65,   66,   67,
       59,   65,   66,   67,  113,   46,  114,  132,   47,   48,
       68,   49,  122,  116,   68,  117,   95,   50,   44,  130,
      130,   69,  123,   98,  132,   69,  125,  125,  125,  133,
      133,   45,   95,  137,  140,   96,  144,  144,  138,  141,
       98,  208,   46,  131,  207,   47,   48,  206,   49,  205,

      204,   96,  203,  134,   50,   51,   51,   52,   51,   51,
       51,   51,   51,   51,   51,   51,   51,   51,   51,   51,
       51,   51,   51,   51,   51,   51,   51,   53,   53,   53,
       54,   53,   53,   53,   53,   53,   53,   53,   53,   53,
       53,   53,   53,   53,   53,   51,   60,   60,   31,   60,
       60,   60,   60,   60,   60,   60,   60,   61,   60,   62,
       60,   60,   60,   60,   60,   60,   60,   60,   63,   63,
       63,   60,   63,   63,   63,   63,   63,   63,   63,   63,
       63,   63,   63,   63,   63,   63,   60,   74,   74,   75,
       74,   74,   74,   74,   74,   74,   74,   76,   77,   74,

       74,   74,   74,   74,   74,   74,   74,   74,   74,   78,
       78,   78,   74,   79,   78,   78,   78,   78,   78,   78,
       78,   78,   78,   78,   78,   78,   78,   74,   80,   80,
       81,   80,   80,   82,   80,   80,   83,   80,   84,   85,
       80,   80,   80,   86,   86,   86,   87,   88,   89,   80,
       90,   90,   90,   80,   91,   90,   90,   92,   90,   90,
       90,   90,   90,   90,   90,   90,   90,   90,   93,  125,
      125,  125,   95,  132,   95,  202,   95,  201,  200,  151,
      151,  149,  149,  166,  166,  199,  198,  197,  196,   98,
      132,   96,  195,   96,   95,   96,  168,  168,  194,  193,

      192,  191,  190,  167,  167,  167,   98,  189,  188,  187,
      167,  186,  185,   96,  184,  167,  167,  167,  167,  167,
      132,  183,  182,  181,  180,  179,  169,  169,  169,  178,
      177,  176,  175,  169,  174,  173,   98,  172,  169,  169,
      169,  169,  169,   30,   30,   30,   30,   30,   30,   30,
       30,   37,   37,   37,   37,   37,   37,   37,   37,   39,
       39,   39,   39,   39,   39,   39,   39,   41,   41,   41,
       41,   41,   41,   41,   41,   31,   31,   31,   31,   31,
       31,   31,   31,   43,   43,   43,   43,   43,   43,   43,
       43,   55,   55,   55,   55,   55,   55,   55,   55,   64,

       64,   64,   64,   64,   64,   64,   64,   70,   70,   70,
       70,   70,   70,   70,   70,   72,   72,   72,   72,   72,
       72,   72,   72,   94,  171,   94,   94,   94,   94,   94,
       94,   97,  170,   97,  165,   97,   97,   97,   97,  111,
      111,  111,  111,  115,  115,  115,  115,  120,  120,  120,
      120,  126,  126,  126,  126,   94,   94,   94,  164,  163,
       94,   97,   97,   97,  162,  161,   97,  150,  150,  152,
      152,  160,  159,  158,  157,  156,  155,  154,  153,  148,
      147,  146,  145,  143,  142,  139,  136,  135,   98,  129,
      128,  127,  124,  121,  119,  118,  110,  105,  104,  103,

       98,  209,   73,   73,   42,   42,   38,   38,   29,  209,
      209,  209,  209,  209,  209,  209,  209,  209,  209,  209,
      209,  209,  209,  209,  209,  209,  209,  209,  209,  209,
      209,  209,  209,  209,  209,  209,  209,  209,  209,  209,
      209,  209,  209,  209,  209,  209,  209,  209,  209,  209
    } ;

static yyconst flex_int16_t yy_chk[551] =
    {   0,
        0,    0,    1,   54,   54,    0,    1,    1,    2,    1,
       32,    5,    2,    2,    1,    2,    6,   21,   22,   36,
        2,    5,   36,   35,    1,   35,    6,   21,   22,   32,
        2,   11,   15,   15,    0,   15,   49,   16,   16,   49,
       16,   15,   48,   48,   11,   15,   16,   19,   19,   19,
       16,   20,   20,   20,   59,   11,   59,   97,   11,   11,
       19,   11,   82,   68,   20,   68,   94,   11,   12,   96,
       96,   19,   82,   97,  168,   20,   86,   86,   86,   98,
       98,   12,  101,  106,  108,   94,  112,  112,  106,  108,
      168,  205,   12,   96,  204,   12,   12,  203,   12,  202,

      201,  101,  200,   98,   12,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   17,   17,   17,   17,
       17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
       17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
       17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
       17,   17,   17,   17,   17,   17,   17,   25,   25,   25,
       25,   25,   25,   25,   25,   25,   25,   25,   25,   25,

       25,   25,   25,   25,   25,   25,   25,   25,   25,   25,
       25,   25,   25,   25,   25,   25,   25,   25,   25,   25,
       25,   25,   25,   25,   25,   25,   25,   25,   27,   27,
       27,   27,   27,   27,   27,   27,   27,   27,   27,   27,
       27,   27,   27,   27,   27,   27,   27,   27,   27,   27,
       27,   27,   27,   27,   27,   27,   27,   27,   27,   27,
       27,   27,   27,   27,   27,   27,   27,   27,   27,  125,
      125,  125,  130,  133,  149,  199,  166,  197,  196,  133,
      133,  130,  130,  149,  149,  194,  193,  192,  189,  133,
      151,  130,  188,  149,  150,  166,  151,  151,  187,  186,

      185,  184,  182,  150,  150,  150,  151,  181,  180,  179,
      150,  178,  177,  150,  175,  150,  150,  150,  150,  150,
      152,  174,  171,  170,  165,  164,  152,  152,  152,  163,
      162,  161,  160,  152,  159,  158,  152,  157,  152,  152,
      152,  152,  152,  210,  210,  210,  210,  210,  210,  210,
      210,  211,  211,  211,  211,  211,  211,  211,  211,  212,
      212,  212,  212,  212,  212,  212,  212,  213,  213,  213,
      213,  213,  213,  213,  213,  214,  214,  214,  214,  214,
      214,  214,  214,  215,  215,  215,  215,  215,  215,  215,
      215,  216,  216,  216,  216,  216,  216,  216,  216,  217,

      217,  217,  217,  217,  217,  217,  217,  218,  218,  218,
      218,  218,  218,  218,  218,  219,  219,  219,  219,  219,
      219,  219,  219,  220,  154,  220,  220,  220,  220,  220,
      220,  221,  153,  221,  148,  221,  221,  221,  221,  222,
      222,  222,  222,  223,  223,  223,  223,  224,  224,  224,
      224,  225,  225,  225,  225,  226,  226,  226,  147,  146,
      226,  227,  227,  227,  145,  143,  227,  228,  228,  229,
      229,  142,  141,  140,  139,  138,  137,  136,  135,  128,
      127,  123,  121,  110,  109,  107,  105,  104,  102,   93,
       92,   91,   83,   79,   71,   69,   50,   47,   46,   40,

       34,   29,   24,   23,    8,    7,    4,    3,  209,  209,
      209,  209,  209,  209,  209,  209,  209,  209,  209,  209,
      209,  209,  209,  209,  209,  209,  209,  209,  209,  209,
      209,  209,  209,  209,  209,  209,  209,  209,  209,  209,
      209,  209,  209,  209,  209,  209,  209,  209,  209,  209
    } ;

/* Table of booleans, true if rule could match eol. */
static yyconst flex_int32_t yy_rule_can_match_eol[74] =
    {   0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 
    0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 
    0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 
    0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0,     };

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int pp__flex_debug;
int pp__flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *pp_text;
/**
 * the "incl" state is used for picking up the name
 * of an include file
 */

/** #define related states **/

// Avoid spam output
#ifdef  ECHO
#undef  ECHO
#endif
#define ECHO

// Never exit
#ifdef  YY_FATAL_ERROR
#undef  YY_FATAL_ERROR
#endif
#define YY_FATAL_ERROR(msg)

#include <list>
#include <wx/string.h>
#include <string>
#include "pp_include.h"
#include "pp_lexer.h"
#include "pptable.h"

#define YYSTYPE wxString
extern wxString pp_lval;

int return_to_state = 0;
int in_if_1         = 0;

#define RET_VAL(x) {\
    pp_lval = wxString::From8BitData(pp_text);\
    return x;\
}

std::string                _definition;
wxString                   g_definition;
bool                       g_forCC = false;
wxString                   g_filename;

extern int pp_parse();

#define INITIAL 0
#define incl 1
#define c_comment 2
#define cpp_comment 3
#define using_namespace 4
#define PP 5
#define define_state 6
#define define_state_2 7
#define define_state_signature 8
#define define_state_definition 9
#define define_generic_c_comment 10
#define define_generic_cpp_comment 11
#define ifdef_state 12
#define if_state 13

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals (void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int pp_lex_destroy (void );

int pp_get_debug (void );

void pp_set_debug (int debug_flag  );

YY_EXTRA_TYPE pp_get_extra (void );

void pp_set_extra (YY_EXTRA_TYPE user_defined  );

FILE *pp_get_in (void );

void pp_set_in  (FILE * in_str  );

FILE *pp_get_out (void );

void pp_set_out  (FILE * out_str  );

int pp_get_leng (void );

char *pp_get_text (void );

int pp_get_lineno (void );

void pp_set_lineno (int line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int pp_wrap (void );
#else
extern int pp_wrap (void );
#endif
#endif

    static void yyunput (int c,char *buf_ptr  );
    
#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * );
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (void );
#else
static int input (void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( pp_text, pp_leng, 1, pp_out )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( pp_in )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( pp_in ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, pp_in))==0 && ferror(pp_in)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(pp_in); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int pp_lex (void);

#define YY_DECL int pp_lex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after pp_text and pp_leng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;
    
	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! pp_in )
			pp_in = stdin;

		if ( ! pp_out )
			pp_out = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			pp_ensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				pp__create_buffer(pp_in,YY_BUF_SIZE );
		}

		pp__load_buffer_state( );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of pp_text. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 210 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 509 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

		if ( yy_act != YY_END_OF_BUFFER && yy_rule_can_match_eol[yy_act] )
			{
			int yyl;
			for ( yyl = 0; yyl < pp_leng; ++yyl )
				if ( pp_text[yyl] == '\n' )
					   
    pp_lineno++;
;
			}

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
YY_RULE_SETUP
{
	BEGIN(cpp_comment);
}
	YY_BREAK
case 2:
YY_RULE_SETUP
{
	BEGIN(c_comment);
}
	YY_BREAK
case 3:
YY_RULE_SETUP
{/* eat a string */}
	YY_BREAK
case 4:
YY_RULE_SETUP
{/* eat a string */}
	YY_BREAK
case 5:
YY_RULE_SETUP
{ BEGIN(PP);                                          }
	YY_BREAK
case 6:
YY_RULE_SETUP
{ BEGIN(define_state); RET_VAL(PP_DEFINE);            }
	YY_BREAK
case 7:
YY_RULE_SETUP
{ if(in_if_1) in_if_1++; BEGIN(if_state); RET_VAL(PP_IF);        }
	YY_BREAK
case 8:
YY_RULE_SETUP
{ RET_VAL(PP_ZERO);                                   }
	YY_BREAK
case 9:
YY_RULE_SETUP
{ RET_VAL(PP_CPLUSPLUS);                              }
	YY_BREAK
case 10:
YY_RULE_SETUP
{ if(in_if_1) in_if_1++;BEGIN(ifdef_state); RET_VAL(PP_IFDEF);              }
	YY_BREAK
case 11:
YY_RULE_SETUP
{ RET_VAL(PP_DEFINED);                                }
	YY_BREAK
case 12:
YY_RULE_SETUP
{ if(in_if_1) in_if_1++; BEGIN(ifdef_state); RET_VAL(PP_IFDEF);  }
	YY_BREAK
case 13:
YY_RULE_SETUP
{ RET_VAL(PP_UNDEF);                                  }
	YY_BREAK
case 14:
YY_RULE_SETUP
{ if(in_if_1 == 1) in_if_1 = 0;RET_VAL(PP_ELSE);      }
	YY_BREAK
case 15:
YY_RULE_SETUP
{ if(in_if_1 == 1) in_if_1--; BEGIN(if_state); RET_VAL(PP_ELIF);       }
	YY_BREAK
case 16:
YY_RULE_SETUP
{ if(in_if_1) in_if_1--; RET_VAL(PP_ENDIF);           }
	YY_BREAK
case 17:
YY_RULE_SETUP
{ BEGIN(incl); RET_VAL(PP_INCLUDE);                   }
	YY_BREAK
case 18:
/* rule 18 can match eol */
YY_RULE_SETUP
{ BEGIN(INITIAL);                                     }
	YY_BREAK
case 19:
YY_RULE_SETUP
{}
	YY_BREAK
case 20:
YY_RULE_SETUP
{ RET_VAL(PP_CPLUSPLUS);                              }
	YY_BREAK
case 21:
YY_RULE_SETUP
{ RET_VAL(PP_IDENTIFIER);                             }
	YY_BREAK
case 22:
YY_RULE_SETUP
{ RET_VAL(((int)'('));                                }
	YY_BREAK
case 23:
YY_RULE_SETUP
{ RET_VAL(((int)')'));                                }
	YY_BREAK
case 24:
/* rule 24 can match eol */
YY_RULE_SETUP
{ BEGIN(INITIAL);                                     }
	YY_BREAK
case 25:
YY_RULE_SETUP
{}
	YY_BREAK
case 26:
YY_RULE_SETUP
{ RET_VAL(PP_CPLUSPLUS);                              }
	YY_BREAK
case 27:
YY_RULE_SETUP
{ RET_VAL(PP_DEFINED);                                }
	YY_BREAK
case 28:
YY_RULE_SETUP
{ RET_VAL(PP_DEFINED);                                }
	YY_BREAK
case 29:
YY_RULE_SETUP
{ RET_VAL(PP_IDENTIFIER);                             }
	YY_BREAK
case 30:
YY_RULE_SETUP
{ RET_VAL(((int)'('));                                }
	YY_BREAK
case 31:
YY_RULE_SETUP
{ RET_VAL(((int)')'));                                }
	YY_BREAK
case 32:
YY_RULE_SETUP
{ RET_VAL(PP_AND);                                    }
	YY_BREAK
case 33:
YY_RULE_SETUP
{ RET_VAL(PP_OR);                                     }
	YY_BREAK
case 34:
YY_RULE_SETUP
{ RET_VAL(PP_EQUAL);                                  }
	YY_BREAK
case 35:
YY_RULE_SETUP
{ RET_VAL(PP_NEQUAL);                                 }
	YY_BREAK
case 36:
YY_RULE_SETUP
{ RET_VAL(PP_GREATERTHAN);                            }
	YY_BREAK
case 37:
YY_RULE_SETUP
{ RET_VAL(PP_LOWERTHAN);                              }
	YY_BREAK
case 38:
YY_RULE_SETUP
{ RET_VAL(PP_INT);                                    }
	YY_BREAK
case 39:
/* rule 39 can match eol */
YY_RULE_SETUP
{ BEGIN(INITIAL);                                     }
	YY_BREAK
case 40:
YY_RULE_SETUP
{}
	YY_BREAK
case 41:
YY_RULE_SETUP
{ BEGIN(define_state_2); RET_VAL(PP_IDENTIFIER); }
	YY_BREAK
case 42:
/* rule 42 can match eol */
YY_RULE_SETUP
{ /* continue define_state */}
	YY_BREAK
case 43:
/* rule 43 can match eol */
YY_RULE_SETUP
{ BEGIN(INITIAL);}
	YY_BREAK
case 44:
YY_RULE_SETUP
{}
	YY_BREAK
case 45:
YY_RULE_SETUP
{
/* whitespaces are NOT allowed between the signature and the macro's name, 
 * if we found a whitespace, handle this macro as a simple macro */
 BEGIN(define_state_definition);   
 _definition.clear();
}
	YY_BREAK
case 46:
YY_RULE_SETUP
{ return_to_state = define_state_2; BEGIN(define_generic_c_comment);}
	YY_BREAK
case 47:
YY_RULE_SETUP
{ 
	BEGIN(define_generic_cpp_comment);
	_definition.clear(); 
	g_definition.Clear(); 
	RET_VAL(PP_COMPLEX_REPLACEMENT);
}
	YY_BREAK
case 48:
YY_RULE_SETUP
{ BEGIN(define_state_signature); RET_VAL(((int)'(')); }
	YY_BREAK
case 49:
/* rule 49 can match eol */
YY_RULE_SETUP
{ BEGIN(INITIAL); _definition.clear(); g_definition.Clear(); RET_VAL(PP_COMPLEX_REPLACEMENT);}
	YY_BREAK
case 50:
YY_RULE_SETUP
{ BEGIN(define_state_definition);   _definition = pp_text;}
	YY_BREAK
case 51:
YY_RULE_SETUP
{ RET_VAL(PP_IDENTIFIER);                             }
	YY_BREAK
case 52:
YY_RULE_SETUP
{ RET_VAL(((int)*pp_text));                            }
	YY_BREAK
case 53:
YY_RULE_SETUP
{ BEGIN(define_state_definition); _definition.clear(); g_definition.Clear(); RET_VAL(((int)*pp_text));}
	YY_BREAK
case 54:
YY_RULE_SETUP
{}
	YY_BREAK
case 55:
YY_RULE_SETUP
{ return_to_state = define_state_definition; BEGIN(define_generic_c_comment);}
	YY_BREAK
case 56:
YY_RULE_SETUP
{ 
	BEGIN(define_generic_cpp_comment);
	g_definition = wxString::From8BitData(_definition.c_str()); 
	RET_VAL(PP_COMPLEX_REPLACEMENT);
}
	YY_BREAK
case 57:
/* rule 57 can match eol */
YY_RULE_SETUP
{}
	YY_BREAK
case 58:
/* rule 58 can match eol */
YY_RULE_SETUP
{ BEGIN(INITIAL); g_definition = wxString::From8BitData(_definition.c_str()); RET_VAL(PP_COMPLEX_REPLACEMENT);}
	YY_BREAK
case 59:
YY_RULE_SETUP
{ _definition += " ";}
	YY_BREAK
case 60:
YY_RULE_SETUP
{}
	YY_BREAK
case 61:
YY_RULE_SETUP
{ _definition += pp_text;}
	YY_BREAK
case 62:
YY_RULE_SETUP
{}
	YY_BREAK
case 63:
/* rule 63 can match eol */
YY_RULE_SETUP
{BEGIN(INITIAL);}
	YY_BREAK
case 64:
YY_RULE_SETUP
{}
	YY_BREAK
case 65:
YY_RULE_SETUP
{
	BEGIN(return_to_state);
}
	YY_BREAK
case 66:
YY_RULE_SETUP
{}
	YY_BREAK
case 67:
/* rule 67 can match eol */
YY_RULE_SETUP
{
	BEGIN(INITIAL);
}
	YY_BREAK
case 68:
YY_RULE_SETUP
{}
	YY_BREAK
case 69:
/* rule 69 can match eol */
YY_RULE_SETUP
{
	BEGIN(INITIAL);
}
	YY_BREAK
case 70:
YY_RULE_SETUP
{} /* do nothing */
	YY_BREAK
case 71:
YY_RULE_SETUP
{
	BEGIN(INITIAL);
}
	YY_BREAK
case 72:
YY_RULE_SETUP
{}
	YY_BREAK
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(incl):
case YY_STATE_EOF(c_comment):
case YY_STATE_EOF(cpp_comment):
case YY_STATE_EOF(using_namespace):
case YY_STATE_EOF(PP):
case YY_STATE_EOF(define_state):
case YY_STATE_EOF(define_state_2):
case YY_STATE_EOF(define_state_signature):
case YY_STATE_EOF(define_state_definition):
case YY_STATE_EOF(define_generic_c_comment):
case YY_STATE_EOF(define_generic_cpp_comment):
case YY_STATE_EOF(ifdef_state):
case YY_STATE_EOF(if_state):
{
    yyterminate();
}
	YY_BREAK
case 73:
YY_RULE_SETUP
ECHO;
	YY_BREAK

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed pp_in at a new source and called
			 * pp_lex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = pp_in;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_c_buf_p);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( pp_wrap( ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * pp_text, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of pp_lex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	register char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	register char *source = (yytext_ptr);
	register int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					pp_realloc((void *) b->yy_ch_buf,b->yy_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), (size_t) num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			pp_restart(pp_in  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yy_size_t) ((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		yy_size_t new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) pp_realloc((void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf,new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	register yy_state_type yy_current_state;
	register char *yy_cp;
    
	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 210 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	register int yy_is_jam;
    	register char *yy_cp = (yy_c_buf_p);

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 210 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 209);

	return yy_is_jam ? 0 : yy_current_state;
}

    static void yyunput (int c, register char * yy_bp )
{
	register char *yy_cp;
    
    yy_cp = (yy_c_buf_p);

	/* undo effects of setting up pp_text */
	*yy_cp = (yy_hold_char);

	if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register int number_to_move = (yy_n_chars) + 2;
		register char *dest = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->yy_buf_size + 2];
		register char *source =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars =
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_buf_size;

		if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;

    if ( c == '\n' ){
        --pp_lineno;
    }

	(yytext_ptr) = yy_bp;
	(yy_hold_char) = *yy_cp;
	(yy_c_buf_p) = yy_cp;
}

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (yy_c_buf_p) - (yytext_ptr);
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					pp_restart(pp_in );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( pp_wrap( ) )
						return EOF;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve pp_text */
	(yy_hold_char) = *++(yy_c_buf_p);

	if ( c == '\n' )
		   
    pp_lineno++;
;

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void pp_restart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        pp_ensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            pp__create_buffer(pp_in,YY_BUF_SIZE );
	}

	pp__init_buffer(YY_CURRENT_BUFFER,input_file );
	pp__load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void pp__switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		pp_pop_buffer_state();
	 *		pp_push_buffer_state(new_buffer);
     */
	pp_ensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	pp__load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (pp_wrap()) processing, but the only time this flag
	 * is looked at is after pp_wrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void pp__load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	pp_in = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE pp__create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) pp_alloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in pp__create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) pp_alloc(b->yy_buf_size + 2  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in pp__create_buffer()" );

	b->yy_is_our_buffer = 1;

	pp__init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with pp__create_buffer()
 * 
 */
    void pp__delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		pp_free((void *) b->yy_ch_buf  );

	pp_free((void *) b  );
}

#ifndef __cplusplus
extern int isatty (int );
#endif /* __cplusplus */
    
/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a pp_restart() or at EOF.
 */
    static void pp__init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	pp__flush_buffer(b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then pp__init_buffer was _probably_
     * called from pp_restart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void pp__flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		pp__load_buffer_state( );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void pp_push_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	pp_ensure_buffer_stack();

	/* This block is copied from pp__switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from pp__switch_to_buffer. */
	pp__load_buffer_state( );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void pp_pop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	pp__delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		pp__load_buffer_state( );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void pp_ensure_buffer_stack (void)
{
	int num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		(yy_buffer_stack) = (struct yy_buffer_state**)pp_alloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in pp_ensure_buffer_stack()" );
								  
		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)pp_realloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in pp_ensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE pp__scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) pp_alloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in pp__scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	pp__switch_to_buffer(b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to pp_lex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       pp__scan_bytes() instead.
 */
YY_BUFFER_STATE pp__scan_string (yyconst char * yystr )
{
    
	return pp__scan_bytes(yystr,strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to pp_lex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE pp__scan_bytes  (yyconst char * yybytes, int  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _yybytes_len + 2;
	buf = (char *) pp_alloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in pp__scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = pp__scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in pp__scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yy_fatal_error (yyconst char* msg )
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up pp_text. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		pp_text[pp_leng] = (yy_hold_char); \
		(yy_c_buf_p) = pp_text + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		pp_leng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int pp_get_lineno  (void)
{
        
    return pp_lineno;
}

/** Get the input stream.
 * 
 */
FILE *pp_get_in  (void)
{
        return pp_in;
}

/** Get the output stream.
 * 
 */
FILE *pp_get_out  (void)
{
        return pp_out;
}

/** Get the length of the current token.
 * 
 */
int pp_get_leng  (void)
{
        return pp_leng;
}

/** Get the current token.
 * 
 */

char *pp_get_text  (void)
{
        return pp_text;
}

/** Set the current line number.
 * @param line_number
 * 
 */
void pp_set_lineno (int  line_number )
{
    
    pp_lineno = line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * 
 * @see pp__switch_to_buffer
 */
void pp_set_in (FILE *  in_str )
{
        pp_in = in_str ;
}

void pp_set_out (FILE *  out_str )
{
        pp_out = out_str ;
}

int pp_get_debug  (void)
{
        return pp__flex_debug;
}

void pp_set_debug (int  bdebug )
{
        pp__flex_debug = bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from pp_lex_destroy(), so don't allocate here.
     */

    /* We do not touch pp_lineno unless the option is enabled. */
    pp_lineno =  1;
    
    (yy_buffer_stack) = 0;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = (char *) 0;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    pp_in = stdin;
    pp_out = stdout;
#else
    pp_in = (FILE *) 0;
    pp_out = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * pp_lex_init()
     */
    return 0;
}

/* pp_lex_destroy is for both reentrant and non-reentrant scanners. */
int pp_lex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		pp__delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		pp_pop_buffer_state();
	}

	/* Destroy the stack itself. */
	pp_free((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * pp_lex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n )
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s )
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *pp_alloc (yy_size_t  size )
{
	return (void *) malloc( size );
}

void *pp_realloc  (void * ptr, yy_size_t  size )
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void pp_free (void * ptr )
{
	free( (char *) ptr );	/* see pp_realloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

int pp_wrap() {
	return 1;
}

int PPScan( const wxString &filePath, bool forCC )
{
	g_filename = filePath;
	
	BEGIN INITIAL;
	pp_lineno = 1;
	FILE* fp = fopen(filePath.To8BitData(), "r");
	if ( fp == NULL ) {
		//printf("%s\n", strerror(errno));
		// failed to open input file...
		return -1;
	}

	pp__switch_to_buffer(pp__create_buffer(fp,YY_BUF_SIZE) );
	pp_in = fp;
	g_forCC = forCC;
	int rc = pp_parse();
    g_forCC = false;
	
    if ( YY_CURRENT_BUFFER->yy_input_file ) {
        fclose( YY_CURRENT_BUFFER->yy_input_file );
        YY_CURRENT_BUFFER->yy_input_file = NULL;

    }

    pp__delete_buffer    ( YY_CURRENT_BUFFER    );
    yyterminate();
	return rc;
}

int PPLex( const wxString &filePath)
{
	g_filename = filePath;
	
	BEGIN INITIAL;
	pp_lineno = 1;
	FILE* fp = fopen(filePath.To8BitData(), "r");
	if ( fp == NULL ) {
		return -1;
	}

	pp__switch_to_buffer(pp__create_buffer(fp,YY_BUF_SIZE) );
	pp_in = fp;
	g_forCC = false;
	int type = 0;
	while( true ) {
		type = pp_lex();
		if(type == 0) break;
		//printf("%s, %d\n", pp_lval.c_str(), type);
	}
	
    if ( YY_CURRENT_BUFFER->yy_input_file ) {
        fclose( YY_CURRENT_BUFFER->yy_input_file );
        YY_CURRENT_BUFFER->yy_input_file = NULL;

    }

    pp__delete_buffer    ( YY_CURRENT_BUFFER    );
	return type;
}

int PPScanString( const wxString &inputString )
{
	BEGIN INITIAL;
	pp__scan_string(inputString.To8BitData() );
	pp_lineno = 1;
	
	int rc = pp_parse();
    
    yyterminate();
	return rc;
}

void pp_error(char* st)
{
}

