import gobject, cohoba, cPickle
from cohoba.common.Utils import singleton
from os.path import join

class Store:
	def __init__(self, name):
		self.filename = join(cohoba.USER_COHOBA_DIR, "%s.pickle" % name)
	
	def load(self, default=None):
		print 'Reading file:', self.filename
		try:
			data = cPickle.load(file(self.filename))
			#print 'File read:', self.filename, data
			return data
		except IOError, e:
			print 'Could not load:', self.filename, ':', e
			return default
			
	def save(self, data):
		gobject.idle_add(self.real_save, data)
	
	def real_save(self, data):
		print 'Saving:', self.filename#, data
		cPickle.dump(data, file(self.filename, 'w'), cPickle.HIGHEST_PROTOCOL)

class ContactStore(Store):
	def __init__(self):
		Store.__init__(self, "contacts")
		self.store = self.load({})
			
	def unserialize(self, conn_path, name, contact):
		conn_path = str(conn_path)
		if conn_path in self.store and name in self.store[conn_path]:
			contact.unserialize(self.store[conn_path][name])
	
	def serialize(self, conn_path, name, contact):
		if name == None:
			return
		
		conn_path = str(conn_path)
		if conn_path not in self.store:
			self.store[conn_path] = {}
		
		self.store[conn_path][name] = contact.serialize()
		self.save(self.store)
			
ContactStore = singleton(ContactStore)

class GroupStore(Store):
	def __init__(self):
		Store.__init__(self, "groups")

GroupStore = singleton(GroupStore)
