# Cohoba - a GNOME client for Telepathy
# Derived from telepathy-python
#
# Copyright (C) 2005, 2006 Collabora Limited
# Copyright (C) 2005, 2006 Nokia Corporation
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

MISSION_CONTROL_INTERFACE = "org.freedesktop.Telepathy.Houston.MissionControl"
MISSION_CONTROL_BUS_NAME = MISSION_CONTROL_INTERFACE
MISSION_CONTROL_OBJECT_PATH = "/org/freedesktop/Telepathy/Houston/MissionControl"
MISSION_CONTROL_UI_INTERFACE = MISSION_CONTROL_INTERFACE + 'UI'

# perhaps these should move to telepathy-python, but leave them here for now
STREAM_ENGINE_BUS_NAME = "org.freedesktop.Telepathy.VoipEngine"
STREAM_ENGINE_OBJECT_PATH = "/org/freedesktop/Telepathy/VoipEngine"

CONNECTION_PRESENCE_AVAILABLE = "available"
CONNECTION_PRESENCE_AWAY = "away"
CONNECTION_PRESENCE_BRB = "brb"
CONNECTION_PRESENCE_BUSY = "busy"
CONNECTION_PRESENCE_DND = "dnd"
CONNECTION_PRESENCE_XA = "xa"
CONNECTION_PRESENCE_HIDDEN = "hidden"
CONNECTION_PRESENCE_OFFLINE = "offline"
CONNECTION_PRESENCE_UNSET = ""

VCARD_KEY_FULLNAME = "fn"
VCARD_KEY_NICKNAME = "nickname"
VCARD_KEY_URL = "url"
VCARD_KEY_DESC = "desc"
VCARD_KEY_BDAY = "bday"
VCARD_KEY_TEL_HOME = ("tel", "home")
VCARD_KEY_TEL_NUMBER = ("tel", "number")
VCARD_KEY_EMAIL_HOME = ("email", "home")
VCARD_KEY_EMAIL_USERID = ("email", "userid")
VCARD_KEY_ADR_HOME = ("adr", "home")
VCARD_KEY_ADR_LOCALITY = ("adr", "locality")
