# Cohoba - a GNOME client for Telepathy
#
# Copyright (C) 2006 Collabora Limited
#
# This package is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This package is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with this package; if not, write to the Free Software
# Foundation, 51 Franklin Street, Fifth Floor, Boston, MA, 02110-1301 USA.

import gtk

from cohoba.common.AccountList import AccountList
from cohoba.common.ui.ProfileIcons import ProfileIcons

class AccountComboBox(gtk.ComboBox):
	def __init__(self):
		gtk.ComboBox.__init__(self, AccountList())
		
		cell = gtk.CellRendererPixbuf()
		self.pack_start(cell, False)
		self.set_cell_data_func(cell, self.get_profile_icon)
		
		cell = gtk.CellRendererText()
		self.pack_start(cell, True)
		self.set_cell_data_func(cell, self.get_account_description)
		
		self.get_model().connect('accounts-received', self.on_accounts_received)
	
	def on_accounts_received(self, model):
		if len(model) > 0:
			self.set_active(0)

	def get_profile_icon(self, layout, cell, model, iter):
		account = model[iter]
		if account != None:
			cell.set_property('pixbuf', ProfileIcons().get_icon(account.profile))
		
	def get_account_description(self, layout, cell, model, iter):
		account = model[iter]
		if account != None:
			cell.set_property('markup', "<b>%s</b> <span size='small'>(%s)</span>" % (account.username, account.description))
			
	def get_active_account(self):
		iter = self.get_active_iter()
		if iter != None:
			return self.get_model()[iter]
