from cohoba.common.Utils import load_icon, singleton

class ProfileIcons:
	def __init__(self):
		self.icons = {}
		
	def get_icon(self, profile, connected=True):
		if profile == None:
			return None
						
		if profile not in self.icons:
			self.icons[profile] = (load_icon(profile+".png", 24), load_icon(profile+"-off.png", 24))
		
		if connected:
			return self.icons[profile][0]
		else:
			return self.icons[profile][1]

ProfileIcons = singleton(ProfileIcons)
