/**************************************************************************\
 *
 *  This file is part of the Coin 3D visualization library.
 *  Copyright (C) 1998-2003 by Systems in Motion. All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  version 2.1 as published by the Free Software Foundation. See the
 *  file LICENSE.LGPL at the root directory of the distribution for
 *  more details.
 *
 *  If you want to use Coin for applications not compatible with the
 *  LGPL, please contact SIM to acquire a Professional Edition license.
 *
 *  Systems in Motion, Teknobyen, Abels Gate 5, 7030 Trondheim, NORWAY
 *  http://www.sim.no support@sim.no Voice: +47 22114160 Fax: +47 22207097
 *
\**************************************************************************/

#ifndef COIN_SOANNOTEXT3RENDERPRINTELEMENT_H
#define COIN_SOANNOTEXT3RENDERPRINTELEMENT_H

#include <Inventor/elements/SoInt32Element.h>


class COIN_DLL_API SoAnnoText3RenderPrintElement : public SoInt32Element {
  typedef SoInt32Element inherited;

  SO_ELEMENT_HEADER(SoAnnoText3RenderPrintElement);
public:
  static void initClass(void);
protected:
  virtual ~SoAnnoText3RenderPrintElement();

public:
  enum RenderPrintType {
    RENDER3D_PRINT_VECTOR, RENDER3D_PRINT_RASTER, RENDER2D_PRINT_RASTER
  };

  virtual void init(SoState * state);
  static void set(SoState * const state, const RenderPrintType hint);
  static RenderPrintType get(SoState * const state);
  static RenderPrintType getDefault(void);

  static void set(SoState * const state, SoNode * const node,
                  const RenderPrintType type);
};

#endif // !COIN_SOANNOTEXT3RENDERPRINTELEMENT_H
