#!/usr/bin/python
# -*- coding: Latin-1 -*-
entete = """
###############################################################################
#
#    This file is part of COLLATINVS.
#
#    COLLATINVS is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    COLLATINVS is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with COLLATINVS; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###############################################################################
"""
doc = """ Outil de maintenance des dsinences.
class tdes:   
   def __init__(self, gr, c=0, gn=0, n=0, d=0, p=0, t=0, mde=0, v=0, mdl=0, r=0):
      self.graphie = gr
      self.cas = int(c)
      self.genre = int(gn)
      self.nombre = int(n)
      self.degre = int(d)
      self.personne = int(p)
      self.temps = int(t)
      self.mode = int(mde)
      self.voix = int(v)
      self.modele = int(mdl)
      self.radnum = int(r) 
      """
      

from collat import *

Ltemps = ['', 'prsent', 'futur', 'imparfait', 'parfait', 'futur antrieur', 'plus-que-parfait'] 
Lmodes = ['', 'indicatif', 'subjonctif', 'impratif', 'infinitif', 'participe', 'grondif',  'adjectif verbal']
Lgenres = ['', 'masculin', 'fminin', 'neutre']
Lvoix = ['', 'actif', 'passif']

def declineN(m):
    # affiche la dclinaison du modle de noms m
    liste = {} 
    # trouver le n du modle
    modele = Lmodeles.index(m)
    if modele < 0:
        return -1
    for cle in desinences.keys():
        for d in desinences[cle].keys():
            if desinences[cle][d].modele == modele :
                des = desinences[cle][d]
                if not liste.has_key(des.nombre):
                    liste[des.nombre] = {}
                liste[des.nombre][des.cas] = des
    print
    print "modle %s" % m
    for n in liste.keys():
       for c in liste[n].keys():
           print "%s %s\t%s" % (string.ljust(Cas(c), 10), 
                                string.ljust(Nombre(n), 10), 
                                liste[n][c].graphie) 
             
    print


def declineA(m):
    # affiche la dclinaison du modle d'adjectifs m
    liste = {} 
    # trouver le n du modle
    modele = Lmodeles.index(m)
    if modele < 0:
        return -1
    for cle in desinences.keys():
        for d in desinences[cle].keys():
            if desinences[cle][d].modele == modele :
                des = desinences[cle][d]
                if not liste.has_key(des.degre):
                    liste[des.degre] = {}
                if not liste[des.degre].has_key(des.genre):
                    liste[des.degre][des.genre] = {}
                if not liste[des.degre][des.genre].has_key(des.nombre):
                    liste[des.degre][des.genre][des.nombre] = {}
                liste[des.degre][des.genre][des.nombre][des.cas] = des
    print
    print "modle %s" % m
    for deg in liste.keys():
        for g in liste[deg].keys():
            for n in liste[deg][g].keys():
                for c in liste[deg][g][n].keys():
                    print "%s %s %s %s\t%s" % (string.ljust(Degre(deg), 10),
                           string.ljust(Genre(g), 10),
                           string.ljust(Cas(c), 10), 
                           string.ljust(Nombre(n), 10), 
                           liste[deg][g][n][c].graphie) 
    print

def conjugue(modele, tempus='prsent', modus='indicatif', uox='actif'):
    # trouver le n du modle
    modele = Lmodeles.index(modele)
    if modele < 0:
        return -1
    temps = Ltemps.index(tempus) 
    if temps < 0: return 
    mode = Lmodes.index(modus) 
    if mode < 0: return
    Lvoix = ['', 'actif', 'passif']
    voix = Lvoix.index(uox)
    if voix < 0: return

    # affiche la dclinaison du modle de noms m
    liste = {} 
    for cle in desinences.keys():
        for d in desinences[cle].keys():
            des = desinences[cle][d]
            if des.modele == modele\
                  and des.temps == temps\
                  and des.mode == mode\
                  and des.voix == voix:
                if des.personne > 0:
                    # formes conjugues
                    if not liste.has_key(des.nombre):
                        liste[Nombre(des.nombre)] = {}
                    liste[Nombre(des.nombre)][Personne(des.personne)] = des
                    sorte = 'c'
                elif des.cas > 0:
                    # formes dclines
                    liste[Cas(des.cas)] = des
                    sorte = 'd'
                else:
                    # forme invariable
                    liste[Mode(des.mode)] = des
                    sorte = 'i'
                print des.graphie, des.morpho()

def dialogueAff():
    saisie = ''
    while saisie != 'q':
        saisie = raw_input('modle temps mode voix : ')
        if saisie == 'q': continue
        eclats = saisie.split()
        conjugue(eclats[0], eclats[1], eclats[2], eclats[3])
        print "="*50

        
#   def __init__(self, gr, c=0, gn=0, n=0, d=0, p=0, t=0, mde=0, v=0, mdl=0, r=0):
def insereDesConj(modele, personne, nombre, temps, mode, voix, radnum, graphie):
    """Insre dans la liste la dsinence indique."""
    # Crer la dsinence
    des = tdes(graphie, 0, 0, nombre, 0, personne, temps, mode, voix, modele, radnum)   
    # Si la cl existe, chercher le doublon
    doublon = False
    if desinences.has_key(graphie):
        for cle in desinences[graphie].keys():
            if desinences[graphie][cle].egale(des):
                print "doublon", des.doc()
                doublon = True
    else: 
        desinences[graphie] = {}
    if not doublon:
        desinences[graphie][len(desinences[des.graphie].keys())] = des
        print "ajout", des.doc()


def InsereDes(modele, genre, temps, mode, voix, radnum, liste):
    """ Insre dans l'xml des dsinences les dsinences indiques
        le paramtre *liste* donne les dsinences dans l'ordre des cas, 
        au singulier puis au pluriel si une dsinence est '-', 
        elle n'est pas ajoute. """
    eclats = liste.split()
    Nmodele = Lmodeles.index(modele)
    Ngenre = Lgenres.index(genre)
    Ntemps = Ltemps.index(temps)
    Nmode = Lmodes.index(mode)
    Nvoix = Lvoix.index(voix)
    if mode == 'participe' : 
        Npersonne = 0
        if temps == 'prsent':
            radnum = 0
        elif temps == 'parfait':
            radnum = 3
    elif mode == 'indicatif' or mode == 'subjonctif' :
        for graphie in eclats:
            i = eclats.index(graphie)+1
            if i > 3: 
                Nnombre = 2
                Npersonne = i -3
            else: 
                Nnombre = 1
                Npersonne = i
            # print "nombre :", Nnombre,"personne :",Npersonne, "graphie", graphie
            insereDesConj(Nmodele, Npersonne, Nnombre, Ntemps, Nmode, Nvoix, radnum, graphie)
        # enregistrer les ajouts
        f = open('../share/desinences.xml', 'w')
        ecrisDes(f)
        f.close()
        print('Dsinences ajoutes et enregistres')
        return
    else:
        print 'non implment'
        return
    # vrification de saisie
    #def __init__(self, gr, c=0, gn=0, n=0, d=0, p=0, t=0, mde=0, v=0, mdl=0, r=0):
    for i in range(1, len(eclats)+1): 
        if eclats[i-1] != '-': 
            Nnombre = 1+i/7
            Ncas = i-6*(Nnombre-1) 
            des = tdes(eclats[i-1], Ncas, Ngenre, Nnombre, 0, 0, Ntemps, Nmode, Nvoix, Nmodele, radnum)   
            print des.doc()
            # ajouter la dsinence au dictionnaire
            accepte = True
            # doublon ?
            for idbl in desinences[des.graphie].keys():
               dbl = desinences[des.graphie][idbl]
               if dbl.egale(des):
                  print 'doublon : ', dbl.doc()
                  accepte = False 
            if accepte:
                if not desinences.has_key(des.graphie):
                    desinences[des.graphie] = {}
                desinences[des.graphie][len(desinences[des.graphie].keys())] = des
    # enregistrer les ajouts
    f = open('../share/desinences.xml', 'w')
    ecrisDes(f)
    f.close()
    print('Dsinences ajoutes et enregistres')

def dedoublonne():
    for k in desinences.keys():
        cles = desinences[k].keys()
        for d in cles: 
            try:
                des = desinences[k][d]
                for l in range(cles.index(d)+1, len(cles)): 
                    doublon = desinences[k][cles[l]]
                    if des.egale(doublon):
                        print doublon.doc() 
                        del(desinences[k][l])
            except: pass
    f = open('../share/desinences.xml', 'w')
    ecrisDes(f)
    f.close()
    print 'dsinences ddoublonnes et enregistres'

if __name__ == '__main__':
    #def InsereDes(modele, genre, temps, voix, mode, radnum, liste):

    # exemple : insrer les dsinences de prs. subj. passif, en utilisant le radical 1 :
    #InsereDes('lego', '', 'prsent', 'subjonctif', 'passif', 1, 
    #      'ar aris atur amur amini antur')        
    precompile()
