unit UMorpho;
{Collatinus - Extraction du lexique d'un texte latin.

Copyright (C) 1998-2002 Y. Ouvrard.

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le
modifier conformment aux dispositions de la Licence Publique Gnrale GNU,
telle que publie par la Free Software Foundation ; version 2 de la licence,
ou encore ( votre choix) toute version ultrieure.
Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE
GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION
A UN OBJET PARTICULIER.
Pour plus de dtail, voir la Licence Publique Gnrale GNU .
Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme
temps que ce programme ; si ce n'est pas le cas, crivez  la
Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
Pour tout contact avec les auteurs : yves.ouvrard@collatinus.org }

{$MODE DELPHI}

interface

uses
  SysUtils, Classes, UDes, ULex, UIrreg, Utiles;

type

  TListeNumeros = Class(TList)
    Procedure Ajoute(M, Fl : integer);
    Function Graphie(N : integer) : String;
    end;

  TAnalyse = Class(TObject)
    forme : string;
    canon : string;
    Numeros : TListeNumeros;
    Constructor Create(F, C : String);
    Procedure Free;
    Procedure Ajoute(C : string ; M, Fl : integer);
    Function Numero(i : integer) : TDef ;
    Function Graphie : TStringList;
    Function K : String;
    end;

  TListeAnalyses = Class(TStringList)
    public
    Constructor Create(F : String);
    Procedure Ajoute( C : String ;
                      D : string ;
                      M, RN, Fl : integer ;
                      DL : TDonneesLexicales);
    Public
    inuentum : Boolean;
    Forme : String;
    Function Analyse(i : integer) : TAnalyse;
    Function Graphie(FormeA : integer) : TStringList;
    end;

const
   maFormesVoc = 0 ;
   maVocSeul  = 1 ;
   maAnalyses = 2 ;

Function AnalysesDe(
  F : String ; var inventum : Boolean ; ModeA : integer) : TStringList;

Function ListeAnalysesDe(
  F : String ; var Inventum : Boolean) : TListeAnalyses;

Function AnalyseTexte (t : string) : TStringList;

implementation

uses UListes;

Function ListeAnalysesDe(
  F : String ; var Inventum : Boolean) : TListeAnalyses;
var
    ListeAnalyses : TListeAnalyses ;
    Capitale : Boolean;
begin
Result := nil;
if F = '' then exit;

// essayer la forme en telle quelle 
ListeAnalyses := TListeAnalyses.Create(VJversUI(F));
Inventum := ListeAnalyses.inuentum ;
if Inventum then
  begin
    Result := ListeAnalyses;
    Capitale := (Result <> nil)
      and (ListeAnalyses.Analyse(0).Canon[1] in majuscules);
  end;

//essayer avec minuscules
if not Inventum then
  begin
    ListeAnalyses := TListeAnalyses.Create(VJversUI(LowerCase(F)));
    Result := ListeAnalyses;
    inventum := ListeAnalyses.inuentum;
  end;

// en cas de Capitale par position
if capitale then
  Begin
    Try
      ListeAnalyses := TListeAnalyses.Create(VJversUI(LowerCase(F)));
      if ListeAnalyses.inuentum then
        begin
          if not Inventum then Result := ListeAnalyses
            else Result.AddStrings(ListeAnalyses);
          inventum := true;
        end;
      finally
      ListeAnalyses.Free;
      end;
  end;
end;


Function AnalysesDe(
  F : String ; var Inventum : Boolean ; ModeA : integer) : TStringList;
 var
    ListeAnalyses : TListeAnalyses ;
begin
  ListeAnalyses := ListeAnalysesDe(F, inventum);
  if inventum then result := ListeAnalyses.Graphie(ModeA)
    else
      begin
        Result := TStringList.Create;
        Result.Add(F + ' : ?');
      end;
end;

Function AnalyseTexte (t : string) : TStringList;
var
   i : integer;
   mot : string;
   AnalyseMot : TStringList;
   inventum : boolean;
begin
result := TStringList.Create;
result.sorted := true;
result.duplicates := dupIgnore;
for i := 1 to length (t) do
   if t[i] in lettres
      then mot := mot + t[i]
      else
         begin
            if mot > '' then
               begin
                  analyseMot := AnalysesDe (mot, inventum, maVocSeul);
                  Result.AddStrings(analyseMot);
                  analyseMot.free;
               end;
            mot := '';
         end;
end;

{ TListeNumeros }

Procedure TListeNumeros.Ajoute(M, Fl : integer);
Begin
Add(TDef.Create(M, 0, Fl));
end;

Function TListeNumeros.Graphie(N : integer) : String;
Begin
result := TDef(items[N]).Graphie(false);
end;

{ TANALYSE }

Constructor TAnalyse.Create(F, C : String);
Begin
Forme := F;
Canon := C;
Numeros := TListeNumeros.Create;
end;

Procedure TAnalyse.Free;
Begin
Numeros.Free;
inherited Free;
end;

Procedure TAnalyse.Ajoute(C : string ; M, Fl : integer);
Begin
Canon := C;
// viter pour les invariables l'affichage d'un flag -1 
if M < 30 then Numeros.Ajoute(M, Fl);
end;

Function TAnalyse.Numero(i : integer) : TDef;
Begin
if i > Numeros.count - 1 then result := nil
 else
 result := TDef(Numeros[i]);
end;

Function TAnalyse.Graphie : TStringList;
var iDef : integer;
Begin
Result := TStringList.Create;
Result.Add(marge1+Canon);
For iDef := 0 to Numeros.count - 1 do
  Result.Add(marge2+Numero(iDef).graphie(false));
end;

{ TListeAnalyses }

Constructor TListeAnalyses.Create(F : String);
var iDes, iDef, pDes, PLex, pIrregs : integer;
    K : string;
    DTemp, RTemp : String;
    KTemp : TList;
    Def : TDef;
    SineSuffixo : string ;
    ListeSine : TListeAnalyses ;
    iList : integer;

Begin
if F = '' then exit;
inherited Create;
Forme := F;
sorted := true;
inuentum := false;

// Voici le gros morceau.
With Lexique do
  Begin
  // Chercher les formes correspondant  la canonique;
  if find(F, PLex) then
    While Strings[PLex] = F do
      begin
      K := strings[PLex] + ', ' + Donnees(Plex, false).Texte;
      Def := TDef.Create(Donnees(PLex, false).Modele, 0, 0);
      // Genre
      if def.categorie = cnom then
        Def.Flags := Def.Flags or Donnees(Plex, false).genre;
      Case Def.Modele of
        0..10 : // noms
          begin
          Def.Flags := $41;
          if Donnees(Plex, false).genre = 2 then
            Begin
            // accusatif sing des noms neutres
            // Def.Flags := Def.Flags or $44 ;
            Ajoute(K, '', Def.Modele, 0, $44, Donnees(PLex, false));
            end;
          end;
        11..13, 16 : Def.Flags := $141 ;
        14, 15, 29 :
          begin
          Def.Flags := $141 or $200 ;
          if Def.Modele = 15 then
             // cas du neutre semblable :
             Def.Flags := Def.Flags or $400;
          end;
        17..28 :
          Def.Flags := Def.Flags or $800 or $40 or $4000 or
                       $100000 or $8000000 ;
        end;
      Ajoute(K, '', Def.Modele, 0, Def.Flags, Donnees(PLex, false));
      inc(PLex);
      end;
      
  // chercher d abord dans les formes irrgulires/pronoms.
  if Irregs.find(F, pIrregs) 
    then For iDef := 0 to Irregs.Definitions(pIrregs).count-1 do
       if Trouve (Irregs.Definition(pIrregs, iDef).Canon, PLex,
               Irregs.Definition(pIrregs, iDef).Modele) 
	       then Ajoute (Strings[PLex] + ', ' + Donnees(PLex, false).texte,
                  irregs[pIrregs],
                  Donnees(PLex, false).modele, 0,
              	  Irregs.Definition(Pirregs, iDef).Flags,
                  Donnees(PLex, false));
                  
  // pour chaque dsinence possible;
  iDes := length(F);
  DTemp := '';
  While iDes > 0 do begin
        // mise  jour de la dsinence  chercher
        DTemp := DTemp+F[iDes];
        if Desinences.Find(DTemp, pDes) then
        // pour chaque dsinence trouve :
           begin
           // Calculer Radical 
           RTemp := Copy(F, 1, pred(iDes)) ; // pour chaque dfinition possible
           For iDef := 0 to Desinences.Definitions(pDes).count-1 do
              begin
                 // Calculer le K hypothtique;
                 Case Desinences.Definition(pDes, iDef).RadicalNumero of
                    1 : KTemp := CanonDe(RTemp, Desinences.Definition(pDes, iDef).modele);
                    2 : case Desinences.Definition (pDes, iDef).modele of
		       5..8, 14, 15 : KTemp := Radices.CanonDe (RTemp);
		       else KTemp := Parfaits.CanonDe(RTemp);
		       end;
                    3 : KTemp := Supins.CanonDe(RTemp);
                 end;
                 // Chercher ce K dans le lexique;
          for iList := 0 to KTemp.count - 1 do
            if (TK(KTemp[iList]).Kanon <> '')
              then
                 case Desinences.Definition(pDes, iDef).modele of
                    5..8, 14, 15 :
                      if Trouve(TK(KTemp[iList]).Kanon, pLex,
                      Desinences.Definition(pDes, iDef).modele, RTemp)
                      then Ajoute(CanonNumero(pLex) + ', '
                                 + Donnees(pLex, false).texte,
                              DTemp,
                              Desinences.Definition(PDes, iDef).Modele,
                              Desinences.Definition(PDes, iDef).RadicalNumero,
                              Desinences.Definition(PDes, iDef).Flags,
                              Donnees(Plex, false));
                 else if
                    (Trouve(TK(KTemp[iList]).Kanon, pLex,
                     Desinences.Definition(pDes, iDef).modele))
                    then Ajoute(CanonNumero(pLex) + ', '
                                 + Donnees(pLex, false).texte,
                              DTemp,
                              Desinences.Definition(PDes, iDef).Modele,
                              Desinences.Definition(PDes, iDef).RadicalNumero,
                              Desinences.Definition(PDes, iDef).Flags,
                              Donnees(Plex, false));
                 end;
          KTemp.Free;
              end;
     end ;
    dec(iDes);
    end;
  end;

  // des suffixes ?
  SineSuffixo := Suffixee(F);
    if F <> '' then
      Begin
        ListeSine := TListeAnalyses.Create(SineSuffixo);
        if ListeSine.count > 0 then
          begin
            for iDef := 0 to ListeSine.Count-1 do
              AddObject(ListeSine[iDef], ListeSine.Analyse(iDef));
            inuentum := true;
          end;
        ListeSine.Free;
      end;
end;


Procedure TListeAnalyses.Ajoute(C : String ;
           D : string ; M, RN, Fl : integer ;
           DL : TDonneesLexicales);
var pointeur : integer;
Begin
if DL.genre > -1 then Fl := Fl or Genres[DL.genre];
// tester si le Canon est dj prsent
if Find(C, pointeur)
// oui : ajouter le numro  la bonne Analyse.
  then Analyse(pointeur).Ajoute(C, M, Fl)
// non : crer une TAnalyse
  else
  Begin
  AddObject(C, TAnalyse.Create(Forme, C));
  Ajoute(C, D, M, RN, Fl, DL);
  end;
  inuentum := true;
end;

Function TListeAnalyses.Analyse(i : integer) : TAnalyse;
Begin
Result := TAnalyse(Objects[i]);
end;

Function TListeAnalyses.Graphie(FormeA : integer) : TStringList;
var liste : TStringList;
    i : integer;
Begin
Result := TStringList.Create;
Case FormeA of
  maFormesVoc, maAnalyses : Result.add(forme);
  end;
if not inuentum then
  Begin
  // chec de la recherche : afficher '?'
  Result.Add(Forme + ' ?');
  exit;
  end;
For i := 0 to count - 1 do
  Begin
  Liste := Analyse(i).Graphie;
  Case FormeA of
    maFormesVoc, maVocSeul : Result.add(' '+Analyse(i).Canon);
    maAnalyses :
       begin
       Result.AddStrings(Liste);
       end;
    end;
  Liste.Free;
  end;
end;


function TAnalyse.K: string;
  var i : integer;
begin
  Result := '';
  for i := 1 to length (Canon) do
    if Canon[i] in lettres
      then Result := Result + Canon[i]
      else Break ;
end;

end.
