/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.commons.math.stat.inference;
import junit.framework.Test;
import junit.framework.TestSuite;

/**
 * Test cases for the ChiSquareTestFactory.
 *
 * @version $Revision: 574049 $ $Date: 2007-09-09 11:46:38 -0700 (Sun, 09 Sep 2007) $
 */

public class ChiSquareFactoryTest extends ChiSquareTestTest {

    public ChiSquareFactoryTest(String name) {
        super(name);
    }
    
    public void setUp() {
    	super.setUp();
        testStatistic = TestUtils.getUnknownDistributionChiSquareTest();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ChiSquareFactoryTest.class);
        suite.setName("ChiSquareTestFactory Tests");
        return suite;
    }
}
