/*
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is Mozilla Communicator client code, released
# March 31, 1998.
#
# The Initial Developer of the Original Code is
# Netscape Communications Corporation.
# Portions created by the Initial Developer are Copyright (C) 1998-1999
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
# Joachim Herb <Joachim.Herb@gmx.de>
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****
*/

if(!org) var org={};
if(!org.mozdev) org.mozdev={};
if(!org.mozdev.customizeHeaderToolbar) org.mozdev.customizeHeaderToolbar = {};

org.mozdev.customizeHeaderToolbar.dialog = function(){
  var pub = {};
  pub.overlayRestoreDefaultSet = function() {
    let toolbox = null;
    if ("arguments" in window && window.arguments[0])
      toolbox = window.arguments[0];
    else if (window.frameElement && "toolbox" in window.frameElement)
      toolbox = window.frameElement.toolbox;
    
    let mode = toolbox.getAttribute("defaultmode");
    let align = toolbox.getAttribute("defaultlabelalign");
    let menulist = document.getElementById("modelist");
    
    if (mode == "full" && align == "end") {
      toolbox.setAttribute("mode", "textbesideicon");
      toolbox.setAttribute("labelalign", align);
      overlayUpdateToolbarMode("textbesideicon");
    }
    else if (mode == "full" && align == ""){
      toolbox.setAttribute("mode", "full");
      toolbox.removeAttribute("labelalign");
      overlayUpdateToolbarMode(mode);
    }
    
    restoreDefaultSet();
  
    if (mode == "full" && align == "end") {
      menulist.value = "textbesideicon";
    }
  }

  pub.CHToverlayOnLoad = function () {
    let restoreButton = document.getElementById("main-box").querySelector("[oncommand*='restore']");
    restoreButton.setAttribute("oncommand", "org.mozdev.customizeHeaderToolbar.dialog.overlayRestoreDefaultSet();");
  
    // If they have a mode of full and a labelalign of true,
    // then pretend the mode is textbesideicon when populating the popup.
    let toolbox = null;
    if ("arguments" in window && window.arguments[0])
      toolbox = window.arguments[0];
    else if (window.frameElement && "toolbox" in window.frameElement)
      toolbox = window.frameElement.toolbox;
  
    document.getElementById("CustomizeToolbarWindow").setAttribute("toolboxId", toolbox.id);
    toolbox.setAttribute("doCustomization", "true");
    
    overlayOnLoad();
    CHToverlayRepositionDialog();

  }
  
  function CHToverlayRepositionDialog()
  {
    // Position the dialog so it is fully visible on the screen  
    // (if possible)
    
    // Seems to be necessary to get the correct dialog height/width
    window.sizeToContent();
    var wH  = window.outerHeight;
    var wW  = window.outerWidth;
    var sH  = window.screen.height;
    var sW  = window.screen.width;
    var sX  = window.screenX;
    var sY  = window.screenY;
    var sAL = window.screen.availLeft;
    var sAT = window.screen.availTop;
    
    var nX = Math.max(Math.min(sX, sW - wW), sAL);
    var nY = Math.max(Math.min(sY, sH - wH), sAT);
    window.moveTo(nX, nY);
  }
  
  return pub;
}();