
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <math.h>
#include <X11/Xatom.h>
#include <X11/extensions/Xrender.h>
#include <compiz.h>
//SETTINGS
//UNTESTED PROBABLY DOESENT WORK YET
//#define USE_CONVOLUTION
#define FILTERING GL_LINEAR
#define IMAGE_DOWNSAMPLE_W (int)floor((float)Current->width/bd->opt[BLUR_DISPLAY_OPTION_BLUR_FACTOR].value.f)
#define IMAGE_DOWNSAMPLE_H (int)floor((float)Current->height/bd->opt[BLUR_DISPLAY_OPTION_BLUR_FACTOR].value.f)
static Bool FakeFBOPath=TRUE;
static int displayPrivateIndex=0;
//FROM PAINT.C
#define GENBOX(w,x,y,xw,yh) w.x1=x;w.y1=y;w.x2=xw;w.y2=yh;
#define WIN_XO(w) ((w)->attrib.x - (w)->input.left)
#define WIN_YO(w) ((w)->attrib.y - (w)->input.top)
#define WIN_WO(w) ((w)->width + (w)->input.left + (w)->input.right)
#define WIN_HO(w) ((w)->height + (w)->input.top + (w)->input.bottom)
#define WIN_X(w) ((w)->attrib.x - (w)->output.left)
#define WIN_Y(w) ((w)->attrib.y - (w)->output.top)
#define WIN_W(w) ((w)->width + (w)->output.left + (w)->output.right)
#define WIN_H(w) ((w)->height + (w)->output.top + (w)->output.bottom)
static Region ScreenUpdate=NULL;
#define BOX_TO_RECT(b,r) r.x=b.x1;r.y=b.y1;r.width=b.x2-b.x1;r.height=b.y2-b.y1;
#define BLUR_DISPLAY_OPTION_OFF_ON_MOVE 0
//Option only is for non-fragment
#define BLUR_DISPLAY_OPTION_BLUR_FACTOR 1
#define BLUR_DISPLAY_OPTION_OFF_ON_OPACITY 2
//Mode option
#define BLUR_DISPLAY_OPTION_MODE 3
//Option to disable transparency blurring
#define BLUR_DISPLAY_OPTION_TRANSLUCENT 4
//Disable transparency blurring on move
#define BLUR_DISPLAY_TRANSLUCENT_OFF_ON_MOVE 5

//Option
//Type for the mode option (non-fragment is auto forced when supported)
#define FAST  N_("fast")
#define BEST  N_("best")
#define NON_FRAGMENT  N_("non_fragment")

#define NUMBER_OF_OPTIONS 6
/*
End of settings
*/
static void
frustum (GLfloat left,
	 GLfloat right,
	 GLfloat bottom,
	 GLfloat top,
	 GLfloat nearval,
	 GLfloat farval)
{
   GLfloat x, y, a, b, c, d;
   GLfloat m[16];

   x = (2.0 * nearval) / (right - left);
   y = (2.0 * nearval) / (top - bottom);
   a = (right + left) / (right - left);
   b = (top + bottom) / (top - bottom);
   c = -(farval + nearval) / ( farval - nearval);
   d = -(2.0 * farval * nearval) / (farval - nearval);

#define M(row,col)  m[col*4+row]
   M(0,0) = x;     M(0,1) = 0.0F;  M(0,2) = a;      M(0,3) = 0.0F;
   M(1,0) = 0.0F;  M(1,1) = y;     M(1,2) = b;      M(1,3) = 0.0F;
   M(2,0) = 0.0F;  M(2,1) = 0.0F;  M(2,2) = c;      M(2,3) = d;
   M(3,0) = 0.0F;  M(3,1) = 0.0F;  M(3,2) = -1.0F;  M(3,3) = 0.0F;
#undef M

   glMultMatrixf (m);
}

static void
perspective (GLfloat fovy,
	     GLfloat aspect,
	     GLfloat zNear,
	     GLfloat zFar)
{
   GLfloat xmin, xmax, ymin, ymax;

   ymax = zNear * tan (fovy * M_PI / 360.0);
   ymin = -ymax;
   xmin = ymin * aspect;
   xmax = ymax * aspect;

   frustum (xmin, xmax, ymin, ymax, zNear, zFar);
}
typedef struct _RectTexture
{
	int Width;
	int Height;
	unsigned int Handle;

}RectTexture;

typedef struct _BlurDisplay
{
	int PrivateIndex;
	 CompOption opt[NUMBER_OF_OPTIONS];

}BlurDisplay;
static Bool
BlurPaintWindow (CompWindow		  *w,
		  const WindowPaintAttrib *attrib,
		  Region		  region,
		  unsigned int		  mask);
void ReInitMode(CompDisplay     *display);

typedef struct _BlurScreen
{
	//Pointers to GL extensions
	GLGenFramebuffersProc        genFramebuffers; 
	GLBindFramebufferProc	     bindFrameBuffer;
	GLFramebufferTexture2DProc   FramebufferTexture2D;
	int HasInit;	//Set to one once initiliazed
	int DList;
	RectTexture ScreenSegment; //Texture which copies the screen segment and blurs it
	RectTexture Resample; //Stretched version of textemp for that blur effect
	RectTexture TexTemp;	//Temporary textures are stored here
	RectTexture SwapTexture; //Used for FBO emulation
	unsigned int FBO;	//Contains a near duplicate of the screen always -1 window
	unsigned int BFBO;	//Contains the blur image
	unsigned int BlurList; //Display list used to blur
	unsigned int BlurShaderH; //Fragment program handle
	unsigned int BlurShaderV; //Fragment program handle
	Region ExtraDamage; //Combined with screenupdate to update properly
	Bool UseShader; //Wether it should use shaders or not
	char *ShaderH; //Chosen shader
	char *ShaderV; //Chosen shader
	Bool Toggle; //Activate and deactivates blurring
	#ifdef USE_CONVOLUTION
		//5x5 guassian filter
		float Filter[5][5];
	#endif
	DrawWindowTextureProc  drawWindowTexture; //Function that we will intercept
	AddWindowGeometryProc addWindowGeometry;
	PaintScreenProc	       paintScreen;
	DamageWindowRectProc	damageWindowRect;
	PaintBackgroundProc paintBackground;
}BlurScreen;

//TAKEN FROM PAINT.C		
#define ADD_RECT(data, m, n, x1, y1, x2, y2)	   \
    for (it = 0; it < n; it++)			   \
    {						   \
	*(data)++ = COMP_TEX_COORD_X (&m[it], x1); \
	*(data)++ = COMP_TEX_COORD_Y (&m[it], y2); \
    }						   \
    *(data)++ = (x1);				   \
    *(data)++ = (y2);				   \
    for (it = 0; it < n; it++)			   \
    {						   \
	*(data)++ = COMP_TEX_COORD_X (&m[it], x2); \
	*(data)++ = COMP_TEX_COORD_Y (&m[it], y2); \
    }						   \
    *(data)++ = (x2);				   \
    *(data)++ = (y2);				   \
    for (it = 0; it < n; it++)			   \
    {						   \
	*(data)++ = COMP_TEX_COORD_X (&m[it], x2); \
	*(data)++ = COMP_TEX_COORD_Y (&m[it], y1); \
    }						   \
    *(data)++ = (x2);				   \
    *(data)++ = (y1);				   \
    for (it = 0; it < n; it++)			   \
    {						   \
	*(data)++ = COMP_TEX_COORD_X (&m[it], x1); \
	*(data)++ = COMP_TEX_COORD_Y (&m[it], y1); \
    }						   \
    *(data)++ = (x1);				   \
    *(data)++ = (y1)
typedef struct _Point2f
{
	float x;
	float y;
}Point2f;
#include <glib.h>
Region tmpRegion=NULL;
static Bool Init=FALSE;
static const CompWindow*
DrawGeometry(float U,float V,RectTexture Texture,CompWindow *window,Bool IncludeDecor,Region Current);
void BlurPaintBackground (CompScreen   *screen,
				     Region	  region,
				     unsigned int mask);
static void GenBlurMap(CompScreen *Screen,BlurScreen* bs, CompWindow *w);
static Bool 
BlurDamageWindowRect (CompWindow *window, Bool initial, BoxPtr box);
static Bool
BlurPaintScreen (CompScreen		 *s,
		 const ScreenPaintAttrib *sAttrib,
		 Region			 region,
		 unsigned int		 mask);
//Taken for frag.c
#ifdef USE_BEST_SHADER
#define blurFPH blurFP_BESTH
#define blurFPV blurFP_BESTV
#else
#define blurFPH blurFP_FASTH
#define blurFPV blurFP_FASTV
#endif
//14x14 guassian
static const char* blurFP_BESTH=
"!!ARBfp1.0\n"
"OPTION ARB_precision_hint_fastest;"
"PARAM c[6] = { { 7, 0, 14, 0.016186001 },"
"{ 12.389602, 0, 0.070625998, 10.429052 },"
"{ 0.145078, 8.4694271, 0, 0.21640199 },"
"{ 6.5102038, 0, 0.234418, 4.5508442 },"
"{ 0.18441699, 0.629628, 0, 0.043701999 },"
"{ 2.590816, 0, 0.105356 } };"
"TEMP R0;"
"TEMP R1;"
"TEMP R2;"
"ADD R2.xy, fragment.texcoord[0], -c[0];"
"ADD R0.zw, R2.xyxy, c[5].xyxy;"
"TEX R1, R0.zwzw, texture[0], RECT;"
"ADD R0.xy, R2, c[4].yzzw;"
"ADD R2.zw, R2.xyxy, c[3].xywy;"
"TEX R0, R0, texture[0], RECT;"
"MUL R1, R1, c[5].z;"
"MAD R1, R0, c[4].w, R1;"
"TEX R0, R2.zwzw, texture[0], RECT;"
"ADD R2.zw, R2.xyxy, c[3].xyxy;"
"MAD R1, R0, c[4].x, R1;"
"TEX R0, R2.zwzw, texture[0], RECT;"
"ADD R2.zw, R2.xyxy, c[2].xyyz;"
"MAD R1, R0, c[3].z, R1;"
"TEX R0, R2.zwzw, texture[0], RECT;"
"ADD R2.zw, R2.xyxy, c[1].xywy;"
"MAD R1, R0, c[2].w, R1;"
"TEX R0, R2.zwzw, texture[0], RECT;"
"ADD R2.zw, R2.xyxy, c[1].xyxy;"
"MAD R0, R0, c[2].x, R1;"
"TEX R1, R2.zwzw, texture[0], RECT;"
"MAD R0, R1, c[1].z, R0;"
"ADD R2.xy, R2, c[0].zyzw;"
"TEX R1, R2, texture[0], RECT;"
"MAD result.color, R1, c[0].w, R0;"
"END";
static const char* blurFP_BESTV=
"!!ARBfp1.0\n"
"OPTION ARB_precision_hint_fastest;"
"PARAM c[6] = { { 0, 7, 14, 0.016186001 },"
"{ 0, 12.389602, 0.070625998, 10.429052 },"
"{ 0.145078, 0, 8.4694271, 0.21640199 },"
"{ 0, 6.5102038, 0.234418, 4.5508442 },"
"{ 0.18441699, 0, 0.629628, 0.043701999 },"
"{ 0, 2.590816, 0.105356 } };"
"TEMP R0;"
"TEMP R1;"
"TEMP R2;"
"ADD R2.xy, fragment.texcoord[0], -c[0];"
"ADD R0.zw, R2.xyxy, c[5].xyxy;"
"TEX R1, R0.zwzw, texture[0], RECT;"
"ADD R0.xy, R2, c[4].yzzw;"
"ADD R2.zw, R2.xyxy, c[3].xyxw;"
"TEX R0, R0, texture[0], RECT;"
"MUL R1, R1, c[5].z;"
"MAD R1, R0, c[4].w, R1;"
"TEX R0, R2.zwzw, texture[0], RECT;"
"ADD R2.zw, R2.xyxy, c[3].xyxy;"
"MAD R1, R0, c[4].x, R1;"
"TEX R0, R2.zwzw, texture[0], RECT;"
"ADD R2.zw, R2.xyxy, c[2].xyyz;"
"MAD R1, R0, c[3].z, R1;"
"TEX R0, R2.zwzw, texture[0], RECT;"
"ADD R2.zw, R2.xyxy, c[1].xyxw;"
"MAD R1, R0, c[2].w, R1;"
"TEX R0, R2.zwzw, texture[0], RECT;"
"ADD R2.zw, R2.xyxy, c[1].xyxy;"
"MAD R0, R0, c[2].x, R1;"
"TEX R1, R2.zwzw, texture[0], RECT;"
"MAD R0, R1, c[1].z, R0;"
"ADD R2.xy, R2, c[0].xzzw;"
"TEX R1, R2, texture[0], RECT;"
"MAD result.color, R1, c[0].w, R0;"
"END";

//11x11 gaussian
static const char* blurFP_FASTH =
"!!ARBfp1.0\n"
"OPTION ARB_precision_hint_fastest;"
"PARAM c[5] = { { 5, 0, 10, 0.00097699999 },"
"{ 8.181818, 0, 0.053711001, 6.363636 },"
"{ 0.32226601, 4.545455, 0, 0.45117199 },"
"{ 0.909091, 0, 0.010742, 2.727273 },"
"{ 0.16113301 } };"
"TEMP R0;"
"TEMP R1;"
"TEMP R2;"
"ADD R2.xy, fragment.texcoord[0], -c[0];"
"ADD R0.zw, R2.xyxy, c[3].xywy;"
"TEX R1, R0.zwzw, texture[0], RECT;"
"ADD R0.xy, R2, c[3];"
"ADD R2.zw, R2.xyxy, c[2].xyyz;"
"TEX R0, R0, texture[0], RECT;"
"MUL R1, R1, c[4].x;"
"MAD R1, R0, c[3].z, R1;"
"TEX R0, R2.zwzw, texture[0], RECT;"
"ADD R2.zw, R2.xyxy, c[1].xywy;"
"MAD R1, R0, c[2].w, R1;"
"TEX R0, R2.zwzw, texture[0], RECT;"
"ADD R2.zw, R2.xyxy, c[1].xyxy;"
"MAD R0, R0, c[2].x, R1;"
"TEX R1, R2.zwzw, texture[0], RECT;"
"MAD R0, R1, c[1].z, R0;"
"ADD R2.xy, R2, c[0].zyzw;"
"TEX R1, R2, texture[0], RECT;"
"MAD result.color, R1, c[0].w, R0;"
"END";

static const char* blurFP_FASTV =
"!!ARBfp1.0\n"
"OPTION ARB_precision_hint_fastest;"
"PARAM c[5] = { { 0, 5, 10, 0.00097699999 },"
"{ 0, 8.181818, 0.053711001, 6.363636 },"
"{ 0.32226601, 0, 4.545455, 0.45117199 },"
"{ 0, 0.909091, 0.010742, 2.727273 },"
"{ 0.16113301 } };"
"TEMP R0;"
"TEMP R1;"
"TEMP R2;"
"ADD R2.xy, fragment.texcoord[0], -c[0];"
"ADD R0.zw, R2.xyxy, c[3].xyxw;"
"TEX R1, R0.zwzw, texture[0], RECT;"
"ADD R0.xy, R2, c[3];"
"ADD R2.zw, R2.xyxy, c[2].xyyz;"
"TEX R0, R0, texture[0], RECT;"
"MUL R1, R1, c[4].x;"
"MAD R1, R0, c[3].z, R1;"
"TEX R0, R2.zwzw, texture[0], RECT;"
"ADD R2.zw, R2.xyxy, c[1].xyxw;"
"MAD R1, R0, c[2].w, R1;"
"TEX R0, R2.zwzw, texture[0], RECT;"
"ADD R2.zw, R2.xyxy, c[1].xyxy;"
"MAD R0, R0, c[2].x, R1;"
"TEX R1, R2.zwzw, texture[0], RECT;"
"MAD R0, R1, c[1].z, R0;"
"ADD R2.xy, R2, c[0].xzzw;"
"TEX R1, R2, texture[0], RECT;"
"MAD result.color, R1, c[0].w, R0;"
"END";
//Copies a rectangle
void CopyRegion(BoxPtr Box,CompWindow *w,BlurScreen *bs)
{
				int ww=Box->x2-Box->x1;
				int wh=Box->y2-Box->y1;
				int x=Box->x1;
				int y= w->screen->height-Box->y1-wh;
				if (x<0){x=0;}
				if (y<0){y=0;}
				if (x+ww>bs->ScreenSegment.Width){ww=bs->ScreenSegment.Width-x;}
				if (y+wh>bs->ScreenSegment.Height){wh=bs->ScreenSegment.Height-y;}
				glCopyTexSubImage2D(GL_TEXTURE_RECTANGLE_ARB,0,x,y,x,y,ww,wh);
				
}
void CopyRegionS(BoxPtr Box,CompScreen *s,BlurScreen *bs)
{
			
				int ww=Box->x2-Box->x1;
				int wh=Box->y2-Box->y1;
				int x=Box->x1;
				int y= bs->ScreenSegment.Height-Box->y1-wh;
				if (x<0){x=0;}
				if (y<0){y=0;}
				if (x+ww>bs->ScreenSegment.Width){ww=bs->ScreenSegment.Width-x;}
				if (y+wh>bs->ScreenSegment.Height){wh=bs->ScreenSegment.Height-y;}
				glCopyTexSubImage2D(GL_TEXTURE_RECTANGLE_ARB,0,x,y,x,y,ww,wh);
				
}	
static Bool 
BlurDamageWindowRect (CompWindow *window, Bool initial, BoxPtr box)
{
	//Get the display
	BlurDisplay*bd=(BlurDisplay*)window->screen->display->privates[displayPrivateIndex].ptr;
	//Get the blur screen
	BlurScreen* bs=(BlurScreen*)window->screen->privates[bd->PrivateIndex].ptr;
	if (bs->Toggle)
	{
		//Merge with the current damage set
		XRectangle NewArea;
		box->x1-=5;
		box->y1-=5;
		box->x2+=5;
		box->y2+=5;
		BOX Box=*box;
		BOX_TO_RECT(Box,NewArea);
		XUnionRectWithRegion(&NewArea,bs->ExtraDamage,bs->ExtraDamage);
	}
	UNWRAP (bs, window->screen, damageWindowRect);
	Bool status = (*window->screen->damageWindowRect) (window, initial, box);
	WRAP (bs, window->screen, damageWindowRect, BlurDamageWindowRect);
	return status;

}
void BlurPaintBackground (CompScreen   *s,
				     Region	  region,
				     unsigned int mask)
{
	//Get the display
	BlurDisplay*bd=(BlurDisplay*)s->display->privates[displayPrivateIndex].ptr;
	//Get the blur screen
	BlurScreen* bs=(BlurScreen*)s->privates[bd->PrivateIndex].ptr;
	UNWRAP (bs, s, paintBackground);
	(*s->paintBackground) (s,region,mask);
	WRAP (bs, s, paintBackground, BlurPaintBackground );
	if (bs->Toggle)
	{
		//Get the bounding box of the region
		XRectangle UpdatedRect;
		XClipBox (region,&UpdatedRect);
		BOX CopyArea;
		CopyArea.x1=UpdatedRect.x;
		CopyArea.y1=UpdatedRect.y;
		CopyArea.x2=UpdatedRect.x+UpdatedRect.width;
		CopyArea.y2=UpdatedRect.y+UpdatedRect.height;
		//Copy the box
		glEnable(GL_TEXTURE_RECTANGLE_ARB);
		glBindTexture(GL_TEXTURE_RECTANGLE_ARB,bs->ScreenSegment.Handle);
		CopyRegionS(&CopyArea,&s,bs);
		glDisable(GL_TEXTURE_RECTANGLE_ARB);
	}
}
void InitBlurScreen(BlurScreen* bs,int ScreenWidth,int ScreenHeight,CompScreen* Current,BlurDisplay *bd);
#define GLERROR GLenum Error;
#define CHECK_ERROR(x)	//Error=glGetError(); if (Error!=  GL_NO_ERROR) {printf ("The GL error has occured at line:%d error #%d\n",x,Error);}


//Get the region of the actual window (used only by texture copy on wobbly for correction)
Region
GetWindowRegion(CompWindow *w)
{
	//Shouldnt happen even but if it does return NULL
	if (w->vCount!=NULL)
		return NULL;
	//Get the vertices
	int     texUnit = w->texUnits;
   	int     currentTexUnit = 0;
   	int     stride = (1 + texUnit);
   	Point2f *vertices = (Point2f*)w->vertices + (stride - 2);
	//Get the minimum and the maximum position
	Point2f min=vertices[0];
	Point2f max=vertices[0];
	//Go through each vertex
	int vertex=0;
	int position=0;
	while (vertex!=w->vCount)
	{
		//Get the min and max
		min.x=MIN(min.x,vertices[position].x);
		min.x=MIN(min.y,vertices[position].y);
		max.x=MAX(min.x,vertices[position].x);
		max.x=MAX(min.y,vertices[position].y);
		//Go to the next vertex
		position+=stride;
		vertex++;
	}
	//Generate a region
	Region WindowRegion=XCreateRegion();
	//Fill the region
	WindowRegion->numRects=1;
	WindowRegion->rects=calloc(1,sizeof(BOX));
	WindowRegion->rects->x1=min.x;
	WindowRegion->rects->y1=min.y;
	WindowRegion->rects->x2=max.x;
	WindowRegion->rects->y2=max.y;
	WindowRegion->extents=*WindowRegion->rects;
}
//Just steals the region of the screen thats updated
BluraddWindowGeometry (CompWindow *window,
				       CompMatrix *matrix,
				       int	  nMatrix,
				       Region	  region,
				       Region	  clip)
{
	//Get the display
   	BlurDisplay*bd=(BlurDisplay*)window->screen->display->privates[displayPrivateIndex].ptr;
	//Get the blur screen
	BlurScreen* bs=(BlurScreen*)window->screen->privates[bd->PrivateIndex].ptr;
	ScreenUpdate=clip;
	UNWRAP (bs, window->screen, addWindowGeometry);
	(*window->screen->addWindowGeometry) (window,matrix,nMatrix,region,clip);
	WRAP (bs, window->screen, addWindowGeometry, BluraddWindowGeometry);
			

}
//Function to draw the window 
static const CompWindow*
DrawGeometry(float U,float V,RectTexture Texture,CompWindow *window,Bool IncludeDecor,Region Current)
{
   //Get the display
   BlurDisplay*bd=(BlurDisplay*)window->screen->display->privates[displayPrivateIndex].ptr;
	//Get the blur screen
	BlurScreen* bs=(BlurScreen*)window->screen->privates[bd->PrivateIndex].ptr;
    CompWindow copy;
   //Copy the current window
    memcpy(&copy,window,sizeof(CompWindow));
    
    CompScreen*s=window->screen;
	if (!tmpRegion)
	{
		tmpRegion=XCreateRegion();
	}
	else
	{
		XDestroyRegion(tmpRegion);
		tmpRegion=NULL;
		tmpRegion=XCreateRegion();
	}		
  //Generate our vertex buffer
   if (!IncludeDecor)
  {
	
	Current=tmpRegion;
	Region tmp=XCreateRegion();
	XUnionRegion (ScreenUpdate, bs->ExtraDamage, tmp);
	XIntersectRegion(tmp,window->region,Current);
	if (Current->numRects==0)
		return NULL;			
      
	  
  }
  else
 {
					
					//Generate the border around the window
					
					
	
					  XRectangle Outer;
						getOuterRectOfWindow(window,&Outer);
					  BOX border;
					XRectangle converted;
					 GENBOX(border,Outer.x
,window->attrib.y,window->attrib.x,Outer.y+Outer.height)
					BOX_TO_RECT(border,converted)
					XUnionRectWithRegion(&converted,tmpRegion,tmpRegion);
					GENBOX(border,Outer.x,Outer.y,Outer.x+Outer.width,window->attrib.y )
						BOX_TO_RECT(border,converted)
					XUnionRectWithRegion(&converted,tmpRegion,tmpRegion);
				
					 GENBOX(border,window->attrib.x+window->attrib.width,window->attrib.y,Outer.x+Outer.width,window->attrib.y+window->attrib.height)
						BOX_TO_RECT(border,converted)
					XUnionRectWithRegion(&converted,tmpRegion,tmpRegion);
				
					 GENBOX(border,Outer.x,window->height+window->attrib.y,Outer.x+Outer.width,Outer.y+Outer.height)
						BOX_TO_RECT(border,converted)
					XUnionRectWithRegion(&converted,tmpRegion,tmpRegion);
				
					tmpRegion->extents=window->region->extents;
					Current=tmpRegion;
				
					//Calculate the visible region of the window borders only by subtracting everything else
					Region tmp=XCreateRegion();
					XUnionRegion(ScreenUpdate,bs->ExtraDamage,tmp);
					XIntersectRegion(tmp,Current,Current);
					XDestroyRegion(tmp);
			
}			
//Speed improvements for non fragment since we are not generating a blur map for non-visible windows
	
	if (!bs->UseShader)
	{
	#ifndef USE_CONVOLUTION
	GenBlurMap(window->screen,bs,window);
	#else
		
	 glEnable(GL_CONVOLUTION_2D);
       	 glConvolutionFilter2D(GL_CONVOLUTION_2D, GL_RGBA, 5,5, GL_LUMINANCE, GL_FLOAT, &bs->Filter[0][0]);
	glConvolutionParameterf(GL_CONVOLUTION_2D, GL_CONVOLUTION_BORDER_MODE, GL_REPLICATE_BORDER);
        glConvolutionParameteri(GL_CONVOLUTION_2D, GL_CONVOLUTION_BORDER_MODE, GL_REPLICATE_BORDER);
	
	#endif
	}
 
    CompMatrix Tex;
   if (!bs->UseShader)
	{
     if (!FakeFBOPath)
    {
    Tex.x0=0;
    Tex.y0=window->screen->height;
    Tex.xx=1;
    Tex.yy=-1;
    }
    else
    {
	Tex.x0=0;
	Tex.y0=0;
   	Tex.xx=(float)bs->TexTemp.Width/(float)window->screen->width;
    	Tex.yy=(float)bs->TexTemp.Height/(float)window->screen->height;
	
     }
	}
	else
	{
	 Tex.x0=0;
    Tex.y0=window->screen->height;
    Tex.xx=1;
    Tex.yy=-1;
	}
    CompMatrix *TexPtr=&Tex;
 copy.vertices   = 0;
    copy.vertexSize = 0;
    copy.indices    = 0;
    copy.indexSize  = 0;
    copy.vCount     = 0;
    copy.texUnits=1;
	//Examine the region to see if its good or else we will be killing older cards with huge number of vertices
	//Avoid this on cards with pixel shaders
	
	if (!bs->UseShader)
	{
		if (Current->numRects>15)
		{
			XRectangle UpdatedRect;
			XClipBox (Current,&UpdatedRect);
			Current=XCreateRegion();
			XUnionRectWithRegion(&UpdatedRect,Current,Current);
			 (*window->screen->addWindowGeometry) (&copy,TexPtr,1,Current,ScreenUpdate);
			XDestroyRegion(Current);
			
		}
		else
		{
			 (*window->screen->addWindowGeometry) (&copy,TexPtr,1,Current,ScreenUpdate);
		}
	}		
	else
	{
		 (*window->screen->addWindowGeometry) (&copy,TexPtr,1,Current,ScreenUpdate);
	}
				
	//Correct the texture coordinates so they are 1 to 1 mappings
	int     texUnit = copy.texUnits;
	int     currentTexUnit = 0;
	int     stride = (1 + texUnit) * 2;
	GLfloat *vert= copy.vertices + (stride - 2);
	GLfloat *texc= vert -2;
	int v=0;	
	int vertex=0;
	while (vertex!=copy.vCount)
	{
		if (v+3<copy.vertexSize)
		{
			texc[v]=COMP_TEX_COORD_X(TexPtr,texc[v+2]);
			texc[v+1]=COMP_TEX_COORD_Y(TexPtr,texc[v+3]);
		}
		v+=stride;
		vertex++;
	}
	if (copy.vCount)
{
(*window->screen->clientActiveTexture) (GL_TEXTURE0_ARB);
    glBindTexture(GL_TEXTURE_RECTANGLE_ARB,Texture.Handle);
    (*window->screen->drawWindowGeometry)(&copy);
if (!bs->UseShader)
    {
   	free(copy.indices);
    	free(copy.vertices);
    	#ifdef USE_CONVOLUTION
		glDisable(GL_CONVOLUTION_2D);
	#endif
	return NULL;
    }
	
}
	//Make a copy of the cop
	CompWindow *retval=malloc(sizeof(CompWindow));
	*retval=copy;
	return retval;
		
} 

void DrawQuad(int x,int y,int w,int h,CompMatrix *TexPtr)
{

  GLfloat *vertices=(GLfloat*)malloc(sizeof(GLfloat)*4*4);
  GLfloat *data=vertices;
    vertices+=2;
    GLfloat *texcoord=vertices;
    texcoord-=2; 
       int it;
   ADD_RECT(data,TexPtr,1,x,y,x+w,y+h);
    //Draw the quad
    glVertexPointer (2, GL_FLOAT, sizeof(GLfloat)*4, vertices);
    glTexCoordPointer (2, GL_FLOAT,  sizeof(GLfloat)*4, texcoord);
 glDrawArrays (GL_QUADS, 0, 4);
	
    free(texcoord);
	
}
static void GenBlurMap(CompScreen *Screen,BlurScreen* bs,CompWindow *w)
{
	if(!FakeFBOPath)
	{
		glEnable(GL_TEXTURE_RECTANGLE_ARB);
		glBindTexture(GL_TEXTURE_RECTANGLE_ARB,0);
		//Bind the FBO
		(*bs->bindFrameBuffer)(GL_FRAMEBUFFER_EXT,bs->FBO);
		(*bs->FramebufferTexture2D)(GL_FRAMEBUFFER_EXT,GL_COLOR_ATTACHMENT0_EXT,GL_TEXTURE_RECTANGLE_ARB,bs->Resample.Handle,0);
		glDrawBuffer(GL_COLOR_ATTACHMENT0_EXT);
		glReadBuffer(GL_COLOR_ATTACHMENT0_EXT);
		
		if ((*Screen->checkFramebufferStatus)( GL_FRAMEBUFFER_EXT)!=GL_FRAMEBUFFER_COMPLETE_EXT)
		{
			printf("Framebuffer attach failed\n");
			printf("Line 700\n");
		}
	}
	else
	{
		glEnable(GL_TEXTURE_RECTANGLE_ARB);
	
	}
	if (bs->DList==0)
	{
		bs->DList=glGenLists(1);
		glNewList(bs->DList,GL_COMPILE);
		
		//Draw a quad
		CompMatrix Texture;
		Texture.x0=0;
		Texture.y0=0;
		Texture.xx=(float)Screen->width/(float)bs->TexTemp.Width;
		Texture.yy=(float)Screen->height/(float)bs->TexTemp.Height;
		(*Screen->clientActiveTexture) (GL_TEXTURE0_ARB);
		glBindTexture(GL_TEXTURE_RECTANGLE_ARB,bs->ScreenSegment.Handle);
		//Downsample the image
		DrawQuad(0,0,bs->TexTemp.Width,bs->TexTemp.Height,&Texture);
		glBindTexture(GL_TEXTURE_RECTANGLE_ARB,bs->TexTemp.Handle);
		if (FakeFBOPath)
		{
			glCopyTexSubImage2D(GL_TEXTURE_RECTANGLE_ARB,0,0,0,0,Screen->height-bs->TexTemp.Height,bs->TexTemp.Width,bs->TexTemp.Height);
		}
		else
		{
			glCopyTexSubImage2D(GL_TEXTURE_RECTANGLE_ARB,0,0,0,0,0,bs->TexTemp.Width,bs->TexTemp.Height);
		}
		if (!FakeFBOPath)
		{
			//Draw a quad
			Texture.x0=0;
			Texture.y0=0;
			Texture.xx=(float)bs->TexTemp.Width/(float)Screen->width;
		    	Texture.yy=(float)bs->TexTemp.Height/(float)Screen->height;
			DrawQuad(0,0,Screen->width,Screen->height,&Texture);
		}
		glEndList();
		glCallList(bs->DList);
	}
	else
	{
		glCallList(bs->DList);
	}
	//Finish with the FBO	
	if (!FakeFBOPath)
	{
		(*bs->bindFrameBuffer)(GL_FRAMEBUFFER_EXT,0);
		glDrawBuffer(GL_BACK);
		glReadBuffer(GL_BACK);
	}
	else
	{
		
		if ((FakeFBOPath)&&(bs->BlurList==0))
		{
				//Generate the display list
			bs->BlurList=glGenLists(1);
			//Compile the list
			glNewList(bs->BlurList,GL_COMPILE);
				glBindTexture(GL_TEXTURE_RECTANGLE_ARB,bs->ScreenSegment.Handle);
				CompMatrix Texture;
				Texture.x0=0;
				Texture.y0=Screen->height;
				Texture.xx=1;
				Texture.yy=-1;
				DrawQuad(0,0,bs->TexTemp.Width,bs->TexTemp.Height,&Texture);
			//End the list
			glEndList();
		}	
		glCallList(bs->BlurList);
	}
	
	
}
//Draw the texture
static void
BlurDrawWindowTexture(CompWindow		*w,CompTexture	       *texture,
				       const WindowPaintAttrib *attrib,
				       unsigned int	       mask)
{
	//Get the display
	BlurDisplay*bd=(BlurDisplay*)w->screen->display->privates[displayPrivateIndex].ptr;
	//Get the blur screen
	BlurScreen* bs=(BlurScreen*)w->screen->privates[bd->PrivateIndex].ptr;
	//Activate disable on move patch if the option is set
	if (((bd->opt[BLUR_DISPLAY_OPTION_OFF_ON_MOVE].value.b==TRUE)&&(otherScreenGrabExist(w->screen,0)))||(w->id==w->screen->root))
 	{
	        UNWRAP (bs, w->screen, drawWindowTexture);
	        (*w->screen->drawWindowTexture) (w,texture,attrib,mask);
	        WRAP (bs, w->screen, drawWindowTexture, BlurDrawWindowTexture);
	        return;
    	}
	if (((bd->opt[BLUR_DISPLAY_OPTION_OFF_ON_OPACITY].value.b==TRUE)&&(w->opacity<OPAQUE))||((attrib->xScale!=1.0f)||(attrib->yScale!=1.0f))||(mask&PAINT_WINDOW_SOLID_MASK)||(WINDOW_INVISIBLE(w)))
	{
		 UNWRAP (bs, w->screen, drawWindowTexture);
	        (*w->screen->drawWindowTexture) (w,texture,attrib,mask);
	        WRAP (bs, w->screen, drawWindowTexture, BlurDrawWindowTexture);
		//Copy the modified region
		if ((!WINDOW_INVISIBLE(w))&&(w->next!=NULL)&&(!w->minimized))	
	{
		if (&w->texture==texture)
		
		{
			//Speed up by copying only modified areas
			Region tmp=XCreateRegion();
			XIntersectRegion(ScreenUpdate,w->region,tmp);
			//Copy the segment of the screen which changed
			glEnable(GL_TEXTURE_RECTANGLE_ARB);
			glBindTexture(GL_TEXTURE_RECTANGLE_ARB,bs->ScreenSegment.Handle);
			int ww=tmp->extents.x2-tmp->extents.x1;
			int wh=tmp->extents.y2-tmp->extents.y1;
			int x=tmp->extents.x1;
			int y= w->screen->height-tmp->extents.y1-wh;
			if (x<0){x=0;}
			if (y<0){y=0;}
			if (x+ww>bs->ScreenSegment.Width){ww=bs->ScreenSegment.Width-x;}
			if (y+wh>bs->ScreenSegment.Height){wh=bs->ScreenSegment.Height-y;}
			glCopyTexSubImage2D(GL_TEXTURE_RECTANGLE_ARB,0,x,y,x,y,ww,wh);
			glDisable(GL_TEXTURE_RECTANGLE_ARB);
			XDestroyRegion(tmp);
			
		}
		else 
		{
			glEnable(GL_TEXTURE_RECTANGLE_ARB);
			
			CompWindow *window=w;
			XRectangle Outer;
			BOX border;
			getOuterRectOfWindow(window,&Outer);
		 GENBOX(border,Outer.x
	,window->attrib.y,window->attrib.x,Outer.y+Outer.height)
			glBindTexture(GL_TEXTURE_RECTANGLE_ARB,bs->ScreenSegment.Handle);
			CopyRegion(&border,w,bs);
			GENBOX(border,Outer.x,Outer.y,Outer.x+Outer.width,window->attrib.y )
			CopyRegion(&border,w,bs);
			 GENBOX(border,window->attrib.x+window->attrib.width,window->attrib.y,Outer.x+Outer.width,window->attrib.y+window->attrib.height)
			CopyRegion(&border,w,bs);
			 GENBOX(border,Outer.x,window->height+window->attrib.y,Outer.x+Outer.width,Outer.y+Outer.height)
			CopyRegion(&border,w,bs);
			glDisable(GL_TEXTURE_RECTANGLE_ARB);
			
		}
	}
	        return;
	}
	//Disable blurring if the window is being animated
	if (w->mapNum==0)
	{
		UNWRAP (bs, w->screen, drawWindowTexture);
	        (*w->screen->drawWindowTexture) (w,texture,attrib,mask);
	        WRAP (bs, w->screen, drawWindowTexture, BlurDrawWindowTexture);
	        return;
	}
	//Check if it is toggled on
	if (bs->Toggle==FALSE)
	{
		UNWRAP (bs, w->screen, drawWindowTexture);
	        (*w->screen->drawWindowTexture) (w,texture,attrib,mask);
	        WRAP (bs, w->screen, drawWindowTexture, BlurDrawWindowTexture);
	        return;
	}
	//Initiliaze the screen if it has not beens
	if (bs->HasInit!=1)
	{
		bs->genFramebuffers=w->screen->genFramebuffers;
		bs-> bindFrameBuffer=w->screen->bindFramebuffer;
		bs->FramebufferTexture2D=w->screen->framebufferTexture2D;
		InitBlurScreen(bs,w->screen->width,w->screen->height,w->screen,bd);
		
		
	}
		
	//CHECK_ERROR(1)
	if ((!w->minimized)&&(!w->shaded)&&(w->frame!=None))
	{
		if (mask&PAINT_WINDOW_DECORATION_MASK)
		{
		
				if (bs->UseShader)
				{
 				glEnable(GL_FRAGMENT_PROGRAM_ARB);
       				 //Bind the program
       				 (*w->screen->bindProgram) (GL_FRAGMENT_PROGRAM_ARB, bs->BlurShaderH);
				}
				glEnable(GL_TEXTURE_RECTANGLE_ARB);
				
				if (!bs->UseShader)
				{
				//Draw the geometry
				#ifndef USE_CONVOLUTION
				if (FakeFBOPath)
				{
						DrawGeometry(WIN_X(w),WIN_Y(w),bs->TexTemp,w,TRUE,ScreenUpdate);
					
				}
				else
				{
				
						DrawGeometry(WIN_X(w),WIN_Y(w),bs->Resample,w,TRUE,ScreenUpdate);
				
				}
				#else
				DrawGeometry(WIN_X(w),WIN_Y(w),bs->ScreenSegment,w,TRUE,ScreenUpdate);
				
				#endif
				glDisable(GL_TEXTURE_RECTANGLE_ARB);
				
				}
				else
				{
				int count;
				//Draw the geometry
				CompWindow *data=NULL;
				
					data=DrawGeometry(WIN_X(w),WIN_Y(w),bs->ScreenSegment,w,TRUE,ScreenUpdate);
				
				if (data!=NULL)
				{
						//Copy the border only
						CompWindow *window=w;
						XRectangle Outer;
						BOX border;
						getOuterRectOfWindow(window,&Outer);
					 	GENBOX(border,Outer.x
,window->attrib.y,window->attrib.x,Outer.y+Outer.height)
						glBindTexture(GL_TEXTURE_RECTANGLE_ARB,bs->ScreenSegment.Handle);
						CopyRegion(&border,w,bs);
						GENBOX(border,Outer.x,Outer.y,Outer.x+Outer.width,window->attrib.y )
						CopyRegion(&border,w,bs);
						 GENBOX(border,window->attrib.x+window->attrib.width,window->attrib.y,Outer.x+Outer.width,window->attrib.y+window->attrib.height)
						CopyRegion(&border,w,bs);
						 GENBOX(border,Outer.x,window->height+window->attrib.y,Outer.x+Outer.width,Outer.y+Outer.height)
						CopyRegion(&border,w,bs);
						
					 (*w->screen->bindProgram) (GL_FRAGMENT_PROGRAM_ARB, bs->BlurShaderV);
					
					(*w->screen->drawWindowGeometry)(data);
	   				free(data->indices);
    					free(data->vertices);
					free(data);
					glDisable(GL_TEXTURE_RECTANGLE_ARB);
					glDisable(GL_FRAGMENT_PROGRAM_ARB);
		 			 (*w->screen->bindProgram) (GL_FRAGMENT_PROGRAM_ARB, 0);
				}
				}
				glDisable(GL_FRAGMENT_PROGRAM_ARB);
				
			
		}
		else if (((w->alpha)||(attrib->opacity!=OPAQUE))&&(!(mask&PAINT_WINDOW_DECORATION_MASK))&&(bd->opt[BLUR_DISPLAY_OPTION_TRANSLUCENT].value.b))
		{
			if ((!bd->opt[BLUR_DISPLAY_TRANSLUCENT_OFF_ON_MOVE].value.b)||(!otherScreenGrabExist(w->screen,0))&&(bd->opt[BLUR_DISPLAY_TRANSLUCENT_OFF_ON_MOVE].value.b))
			if (bs->UseShader)
				{
 				glEnable(GL_FRAGMENT_PROGRAM_ARB);
       				 //Bind the program
       				 (*w->screen->bindProgram) (GL_FRAGMENT_PROGRAM_ARB, bs->BlurShaderH);
				}
				glEnable(GL_TEXTURE_RECTANGLE_ARB);
				
				if (!bs->UseShader)
				{
				//Draw the geometry
				#ifndef USE_CONVOLUTION
				if (FakeFBOPath)
				{
					if ((w->opacity==OPAQUE)&&(!w->alpha))
					{
						DrawGeometry(WIN_X(w),WIN_Y(w),bs->TexTemp,w,TRUE,ScreenUpdate);
					}
					else
					{
						DrawGeometry(WIN_X(w),WIN_Y(w),bs->TexTemp,w,FALSE,ScreenUpdate);
				
					}
				}
				else
				{
					if ((w->opacity==OPAQUE)&&(!w->alpha))
					{
						DrawGeometry(WIN_X(w),WIN_Y(w),bs->Resample,w,TRUE,ScreenUpdate);
					}
					else
					{
						DrawGeometry(WIN_X(w),WIN_Y(w),bs->Resample,w,FALSE,ScreenUpdate);
				
					}
				}
				#else
				DrawGeometry(WIN_X(w),WIN_Y(w),bs->ScreenSegment,w,TRUE,ScreenUpdate);
				
				#endif
				glDisable(GL_TEXTURE_RECTANGLE_ARB);
				
				}
				else
				{
				//Draw the geometry
				CompWindow *data=NULL;
				if ((w->opacity==OPAQUE)&&(!w->alpha))
				{
					data=DrawGeometry(WIN_X(w),WIN_Y(w),bs->ScreenSegment,w,TRUE,ScreenUpdate);
				}
				else
				{
					data=DrawGeometry(WIN_X(w),WIN_Y(w),bs->ScreenSegment,w,FALSE,ScreenUpdate);
				}
				if (data!=NULL)
				{
						if ((w->opacity==OPAQUE)&&(!w->alpha))
						{
						//Copy the border only
						CompWindow *window=w;
						XRectangle Outer;
						BOX border;
						getOuterRectOfWindow(window,&Outer);
					 	GENBOX(border,Outer.x
,window->attrib.y,window->attrib.x,Outer.y+Outer.height)
						glBindTexture(GL_TEXTURE_RECTANGLE_ARB,bs->ScreenSegment.Handle);
						CopyRegion(&border,w,bs);
						GENBOX(border,Outer.x,Outer.y,Outer.x+Outer.width,window->attrib.y )
						CopyRegion(&border,w,bs);
						 GENBOX(border,window->attrib.x+window->attrib.width,window->attrib.y,Outer.x+Outer.width,window->attrib.y+window->attrib.height)
						CopyRegion(&border,w,bs);
						 GENBOX(border,Outer.x,window->height+window->attrib.y,Outer.x+Outer.width,Outer.y+Outer.height)
						CopyRegion(&border,w,bs);
						}
						else
						{

							BOX Changed=ScreenUpdate->extents;
							if (Changed.x1<w->region->extents.x1)
								 Changed.x1=w->region->extents.x1;
							if (Changed.x2>w->region->extents.x2)
	 							Changed.x2=w->region->extents.x2;
							if (Changed.y1<w->region->extents.y1)
								 Changed.y1=w->region->extents.y1;
							if (Changed.y2>w->region->extents.y2)
								 Changed.y2=w->region->extents.y2;
							glBindTexture(GL_TEXTURE_RECTANGLE_ARB,bs->ScreenSegment.Handle);
							CopyRegion(&Changed,w,bs);
						
						}
					 (*w->screen->bindProgram) (GL_FRAGMENT_PROGRAM_ARB, bs->BlurShaderV);
					
					(*w->screen->drawWindowGeometry)(data);
	   				free(data->indices);
    					free(data->vertices);
	   				free(data);
					glDisable(GL_TEXTURE_RECTANGLE_ARB);
					glDisable(GL_FRAGMENT_PROGRAM_ARB);
		 			 (*w->screen->bindProgram) (GL_FRAGMENT_PROGRAM_ARB, 0);
				}
				}
				glDisable(GL_FRAGMENT_PROGRAM_ARB);

		}
		
	}

	//Draw the contents
	UNWRAP (bs, w->screen, drawWindowTexture);
	(*w->screen->drawWindowTexture) (w,texture,attrib,mask);
	WRAP (bs, w->screen, drawWindowTexture, BlurDrawWindowTexture);
	if ((!WINDOW_INVISIBLE(w))&&(w->next!=NULL)&&(!w->minimized))
	{
		if (&w->texture==texture)
		
		{
			//Speed up by copying only modified areas
			Region tmp=XCreateRegion();
			XIntersectRegion(ScreenUpdate,w->region,tmp);
			//Copy the segment of the screen which changed
			glEnable(GL_TEXTURE_RECTANGLE_ARB);
			glBindTexture(GL_TEXTURE_RECTANGLE_ARB,bs->ScreenSegment.Handle);
			int ww=tmp->extents.x2-tmp->extents.x1;
			int wh=tmp->extents.y2-tmp->extents.y1;
			int x=tmp->extents.x1;
			int y= w->screen->height-tmp->extents.y1-wh;
			if (x<0){x=0;}
			if (y<0){y=0;}
			if (x+ww>bs->ScreenSegment.Width){ww=bs->ScreenSegment.Width-x;}
			if (y+wh>bs->ScreenSegment.Height){wh=bs->ScreenSegment.Height-y;}
			glCopyTexSubImage2D(GL_TEXTURE_RECTANGLE_ARB,0,x,y,x,y,ww,wh);
			glDisable(GL_TEXTURE_RECTANGLE_ARB);
			XDestroyRegion(tmp);
			
		}
		else 
		{
			glEnable(GL_TEXTURE_RECTANGLE_ARB);
			
			CompWindow *window=w;
			XRectangle Outer;
			BOX border;
			getOuterRectOfWindow(window,&Outer);
		 GENBOX(border,Outer.x
	,window->attrib.y,window->attrib.x,Outer.y+Outer.height)
			glBindTexture(GL_TEXTURE_RECTANGLE_ARB,bs->ScreenSegment.Handle);
			CopyRegion(&border,w,bs);
			GENBOX(border,Outer.x,Outer.y,Outer.x+Outer.width,window->attrib.y )
			CopyRegion(&border,w,bs);
			 GENBOX(border,window->attrib.x+window->attrib.width,window->attrib.y,Outer.x+Outer.width,window->attrib.y+window->attrib.height)
			CopyRegion(&border,w,bs);
			 GENBOX(border,Outer.x,window->height+window->attrib.y,Outer.x+Outer.width,Outer.y+Outer.height)
			CopyRegion(&border,w,bs);
			glDisable(GL_TEXTURE_RECTANGLE_ARB);
			
		}
		
	}
	
}


//Free all OpenGL resources
void DeinitBlurScreen(BlurScreen* bs)
{
	//TODO CLEAN UP BETTER!
	if (bs->HasInit)
	{
		//Delete the textures
		glDeleteTextures(1,&bs->TexTemp);
		glDeleteTextures(1,&bs->ScreenSegment);
		//Delete the display list
		glDeleteLists(1,bs->BlurList);
	}
}
//Does opengl level iniliazation of the screen
void InitBlurScreen(BlurScreen* bs,int ScreenWidth,int ScreenHeight,CompScreen* Current,BlurDisplay *bd)
{
	GLERROR
	if (bs->UseShader)
	{
		//Clear all errors before
		glGetError ();
		//Load the fragment program 
		(*Current->genPrograms) (1, &bs->BlurShaderH);
		//CHECK_ERROR(1)
		(*Current->bindProgram) (GL_FRAGMENT_PROGRAM_ARB, bs->BlurShaderH);
		//CHECK_ERROR(2)
		//Switch a bunch of strings
		float div = 16.0;
		const char *textureTarget = "RECT";
		(*Current->programString) (GL_FRAGMENT_PROGRAM_ARB, GL_PROGRAM_FORMAT_ASCII_ARB, strlen (bs->ShaderH),bs->ShaderH);
		int errorPos;
		
		glGetIntegerv (GL_PROGRAM_ERROR_POSITION_ARB, &errorPos);
		if (glGetError () != GL_NO_ERROR || errorPos != -1)
		{
			fprintf (stderr, "%s: error loading fragment program at line: %d\n", programName, errorPos);
			fprintf (stderr, glGetString(GL_PROGRAM_ERROR_STRING_ARB));
			glGetIntegerv(GL_MAX_PROGRAM_INSTRUCTIONS_ARB,&errorPos);
			(*Current->deletePrograms) (1,&bs->BlurShaderH);
			bs->BlurShaderH = 0;
			//return 0;
		}
		//Load the fragment program 
		(*Current->genPrograms) (1, &bs->BlurShaderV);
		//CHECK_ERROR(1)
		(*Current->bindProgram) (GL_FRAGMENT_PROGRAM_ARB, bs->BlurShaderV);
		(*Current->programString) (GL_FRAGMENT_PROGRAM_ARB, GL_PROGRAM_FORMAT_ASCII_ARB, strlen (bs->ShaderV),bs->ShaderV);
		glGetIntegerv (GL_PROGRAM_ERROR_POSITION_ARB, &errorPos);
			if (glGetError () != GL_NO_ERROR || errorPos != -1)
		{
			fprintf (stderr, "%s: error loading fragment program at line: %d\n", programName, errorPos);
			fprintf (stderr, glGetString(GL_PROGRAM_ERROR_STRING_ARB));
			glGetIntegerv(GL_MAX_PROGRAM_INSTRUCTIONS_ARB,&errorPos);
			(*Current->deletePrograms) (1,&bs->BlurShaderV);
			bs->BlurShaderV = 0;
			//return 0;
		}
	}
	else
	{
		bs->BlurShaderH=0;
		bs->BlurShaderV=0;
	}
	//CHECK_ERROR(3)
	
	//Enable texturing
	glEnable(GL_TEXTURE_RECTANGLE_ARB);
	//Generate the OpenGL textures
	glGenTextures (1,&bs->ScreenSegment.Handle);
	//Write important info into the structure
	bs->ScreenSegment.Width=ScreenWidth;
	bs->ScreenSegment.Height=ScreenHeight;
	//Bind the texture
	glBindTexture(GL_TEXTURE_RECTANGLE_ARB,bs->ScreenSegment.Handle);
	//Load the parameters
	glTexParameteri (GL_TEXTURE_RECTANGLE_ARB, GL_TEXTURE_MIN_FILTER, FILTERING);
    	glTexParameteri (GL_TEXTURE_RECTANGLE_ARB, GL_TEXTURE_MAG_FILTER, FILTERING);
   	glTexParameteri (GL_TEXTURE_RECTANGLE_ARB, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
    	glTexParameteri (GL_TEXTURE_RECTANGLE_ARB, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
	//Generate a large image
	glTexImage2D(GL_TEXTURE_RECTANGLE_ARB, 0, GL_RGBA, ScreenWidth,ScreenHeight, 0, GL_RGBA, GL_UNSIGNED_BYTE, NULL);
	//Generate the OpenGL textures
	glGenTextures (1,&bs->Resample.Handle);
	//Write important info into the structure
	bs->Resample.Width=ScreenWidth;
	bs->Resample.Height=ScreenHeight;
	//Bind the texture
	glBindTexture(GL_TEXTURE_RECTANGLE_ARB,bs->Resample.Handle);
	//Load the parameters
	glTexParameteri (GL_TEXTURE_RECTANGLE_ARB, GL_TEXTURE_MIN_FILTER, FILTERING);
    	glTexParameteri (GL_TEXTURE_RECTANGLE_ARB, GL_TEXTURE_MAG_FILTER, FILTERING);
   	glTexParameteri (GL_TEXTURE_RECTANGLE_ARB, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
    	glTexParameteri (GL_TEXTURE_RECTANGLE_ARB, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
	//Generate a large image
	glTexImage2D(GL_TEXTURE_RECTANGLE_ARB, 0, GL_RGBA, ScreenWidth,ScreenHeight, 0, GL_RGBA, GL_UNSIGNED_BYTE, NULL);
	//Generate the OpenGL textures
	glGenTextures (1,&bs->TexTemp.Handle);
	//Record with and height
	bs->TexTemp.Width=IMAGE_DOWNSAMPLE_W;
	bs->TexTemp.Height=IMAGE_DOWNSAMPLE_H;
	//Bind the texture
	glBindTexture(GL_TEXTURE_RECTANGLE_ARB,bs->TexTemp.Handle);
	//Load the parameters
	glTexParameteri (GL_TEXTURE_RECTANGLE_ARB, GL_TEXTURE_MIN_FILTER, FILTERING);
    	glTexParameteri (GL_TEXTURE_RECTANGLE_ARB, GL_TEXTURE_MAG_FILTER,FILTERING);
   	glTexParameteri (GL_TEXTURE_RECTANGLE_ARB, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
    	glTexParameteri (GL_TEXTURE_RECTANGLE_ARB, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
	glTexImage2D(GL_TEXTURE_RECTANGLE_ARB, 0, GL_RGBA, IMAGE_DOWNSAMPLE_W,IMAGE_DOWNSAMPLE_H, 0, GL_RGBA, GL_UNSIGNED_BYTE, NULL);
	
	if (!FakeFBOPath)
	{
	//Generate a fbo
	(*bs->genFramebuffers)(1,&bs->FBO);
	  //Bind the FBO
	(*bs->bindFrameBuffer)(GL_FRAMEBUFFER_EXT,bs->FBO);
	//Load the texture
	(*bs->FramebufferTexture2D)(GL_FRAMEBUFFER_EXT,GL_COLOR_ATTACHMENT0_EXT,GL_TEXTURE_RECTANGLE_ARB,bs->ScreenSegment.Handle,0);
	//Generate a fbo
	(*bs->genFramebuffers)(1,&bs->BFBO);
	//Bind the FBO
	(*bs->bindFrameBuffer)(GL_FRAMEBUFFER_EXT,bs->BFBO);
	//Load the texture
	(*bs->FramebufferTexture2D)(GL_FRAMEBUFFER_EXT,GL_COLOR_ATTACHMENT0_EXT,GL_TEXTURE_RECTANGLE_ARB,bs->Resample.Handle,0);
	//Bind the framebuffer
	(*bs->bindFrameBuffer)(GL_FRAMEBUFFER_EXT,0);
	
	
	}
	
	#ifdef USE_CONVOLUTION
	//Setup the convolution matrix
		bs->Filter[0][0]=1;
		bs->Filter[1][0]=4;
		bs->Filter[2][0]=7;
		bs->Filter[3][0]=4;
		bs->Filter[4][0]=1;
		bs->Filter[0][1]=4;
		bs->Filter[1][1]=16;
		bs->Filter[2][1]=26;
		bs->Filter[3][1]=16;
		bs->Filter[4][1]=4;
		bs->Filter[0][2]=7;
		bs->Filter[1][2]=26;
		bs->Filter[2][2]=41;
		bs->Filter[3][2]=26;
		bs->Filter[4][2]=7;
		bs->Filter[0][3]=4;
		bs->Filter[1][3]=16;
		bs->Filter[2][3]=26;
		bs->Filter[3][3]=16;
		bs->Filter[4][3]=4;
		bs->Filter[0][4]=1;
		bs->Filter[1][4]=4;
		bs->Filter[2][4]=7;
		bs->Filter[3][4]=4;
		bs->Filter[4][4]=1;
		int i,j;
		for (i=0;i<5;i++)
		{
			for(j=0;j<5;j++)
			{	bs->Filter[i][j]=bs->Filter[i][j]/273.0f;
				g_printf("%f\n",bs->Filter[i][j]);
			}

		}
	#endif
	//Mark it as intiliaze
	bs->HasInit=1;
	bs->DList=0;
	bs->BlurList=0;
}
static Bool
BlurPaintScreen (CompScreen		 *s,
		 const ScreenPaintAttrib *sAttrib,
		 Region			 region,
		 unsigned int		 mask)
{
	//Get the display handle
	BlurDisplay* bd=(BlurDisplay*)s->display->privates[displayPrivateIndex].ptr;
	//Get the blur screen
	BlurScreen* bs=(BlurScreen*)s->privates[bd->PrivateIndex].ptr;
	//Activate by default
	bs->Toggle=TRUE;
	//Deactivate on zooms
	if (sAttrib->zCamera!=defaultScreenPaintAttrib.zCamera)
	{
		bs->Toggle=FALSE; 
	}
	if (sAttrib->xRotate!=0)
	{
		bs->Toggle=FALSE; 
	}
	if (bs->Toggle)
	{
		Region Duplicate=XCreateRegion();
		XSubtractRegion(region,&emptyRegion,Duplicate);
		region=Duplicate;
		XRectangle NewRect;
		int i=0;
		// Increase the region sizes
		for (i = 0; i < region->numRects; i++) {

			NewRect.x = region->rects[i].x1 - 5;
			NewRect.y = region->rects[i].y1 - 5;
			NewRect.width = region->rects[i].x2 - region->rects[i].x1 + 10;
			NewRect.height = region->rects[i].y2 - region->rects[i].y1  + 10;

			XUnionRectWithRegion(&NewRect,region,region);
		}
	}
	UNWRAP (bs, s, paintScreen);
	Bool status=(*bs->paintScreen)(s,sAttrib,region,mask);
	WRAP (bs, s, paintScreen, BlurPaintScreen);
	if (bs->Toggle)
	{
		XDestroyRegion(region);
		
	}
	XDestroyRegion(bs->ExtraDamage);
	bs->ExtraDamage=XCreateRegion();
	return status;
	
}
static Bool
BlurInitScreen (CompPlugin *p,
		 CompScreen *s)
{
	//Check for extensions or else return false
	if (!s->fbo)
	{
		//printf("Cannot initiliaze lack of FBO support!\n");
		//return FALSE;
		printf("Switching to using non-fbo path\n");
		FakeFBOPath=TRUE;
	}
	
	if (!s->textureRectangle)
	{
		printf("Cannot initilaize due to lack of texture rectangle support\n");
		return FALSE;
	}
	//Get the display handle
	BlurDisplay* bd=(BlurDisplay*)s->display->privates[displayPrivateIndex].ptr;
	//Create a blur screen
	BlurScreen* bs=(BlurScreen*)calloc(1,sizeof(BlurScreen));
	//Setup the toggle
	bs->Toggle=TRUE;
	bs->ExtraDamage=XCreateRegion();
	s->privates[bd->PrivateIndex].ptr=bs;
	//Take over the window draw function
	WRAP (bs, s, drawWindowTexture, BlurDrawWindowTexture);
	WRAP (bs, s, addWindowGeometry, BluraddWindowGeometry);
	WRAP (bs, s, paintScreen, BlurPaintScreen);
	WRAP (bs, s, damageWindowRect, BlurDamageWindowRect);
	WRAP (bs, s, paintBackground, BlurPaintBackground );
	
	return TRUE;
}


static void
BlurFiniScreen (CompPlugin *p,
		 CompScreen *s)
{
	//Get the display handle
	BlurDisplay* bd=(BlurDisplay*)s->display->privates[displayPrivateIndex].ptr;
	//Get the blur screen
	BlurScreen* bs=(BlurScreen*)s->privates[bd->PrivateIndex].ptr;
	//Deinitiliaze the screen and free the pointer
	DeinitBlurScreen(bs);
	//Restore the original function
	UNWRAP (bs, s, drawWindowTexture);
   	UNWRAP (bs, s, addWindowGeometry);
	UNWRAP (bs, s, paintScreen);
	UNWRAP (bs,s, damageWindowRect);
	UNWRAP (bs, s, paintBackground);
	//Free the pointer
	free(bs);
	
}
//Initiliaze the options
static void
BlurDisplayInitOptions (BlurDisplay *bd, CompDisplay *display)
{
	CompOption *o;
	//Deactivate on move option
	o = &bd->opt[BLUR_DISPLAY_OPTION_OFF_ON_MOVE];
   	o->name                       = "off_onmove";
    	o->shortDesc                  = N_("Disables the plugin when a window is moving");
    	o->longDesc                   = N_("Disables the plugin when a window is moving");
    	o->type                       = CompOptionTypeBool;
	o->value.b=TRUE;
	//Controls blur factor for non-fragment
	o = &bd->opt[BLUR_DISPLAY_OPTION_BLUR_FACTOR];
	o->name                       = "blur_factor";
    	o->shortDesc                  = N_("Changes the amount the image is resized to blur in non-fragment");
    	o->longDesc                   = N_("Changes the amount the image is resized to blur in non-fragment (Value has to be greater then 1 )");
    	o->type                       = CompOptionTypeFloat;
	o->value.f=2.0f;
	o->rest.f.min	= 1;
    	o->rest.f.max	= 100;
    	o->rest.f.precision = 0.01f;
	//Deactivate on transparent windows
	o = &bd->opt[BLUR_DISPLAY_OPTION_OFF_ON_OPACITY ];
   	o->name                       = "off_onopacity";
    	o->shortDesc                  = N_("Disables the plugin on transparent window");
    	o->longDesc                   = N_("Disables the plugin on transparent window [useless for now, useful when generic transparency blurring is added]");
    	o->type                       = CompOptionTypeBool;
	o->value.b=TRUE;
	//Mode of the plugin
	o = &bd->opt[BLUR_DISPLAY_OPTION_MODE ];
   	o->name                       = "mode";
    	o->shortDesc                  = N_("Sets the mode of the plugin to use");
    	o->longDesc                   = N_("Sets the mode of the plugin to use [Allowed values fast,best,non_fragment]");
    	o->type                       = CompOptionTypeString;
	o->value.s=g_strdup(FAST);
    o->rest.s.string = NULL;
    o->rest.s.nString = 0;
	//Deactivate on translucent blur option
	o = &bd->opt[BLUR_DISPLAY_OPTION_TRANSLUCENT];
   	o->name                       = "transparency_blur";
    	o->shortDesc                  = N_("Enables transparency blurring");
    	o->longDesc                   = N_("Enables transparency blurring (off by default)");
    	o->type                       = CompOptionTypeBool;
	o->value.b=FALSE;
	//Deactivate on translucent blur when the window is moving option
	o = &bd->opt[BLUR_DISPLAY_TRANSLUCENT_OFF_ON_MOVE];
   	o->name                       = "off_ontmove";
    	o->shortDesc                  = N_("Disables transparency blurring when moving a window");
    	o->longDesc                   = N_("Disables transparency blurring when moving a window (note this includes damaged regions)");
    	o->type                       = CompOptionTypeBool;
	o->value.b=TRUE;

}

static Bool
BlurInitDisplay (CompPlugin  *p,
		  CompDisplay *d)
{
	//Generate a blur display
	BlurDisplay* bd=(BlurDisplay*)malloc(sizeof(BlurDisplay));
	//Allocate a private index
	bd->PrivateIndex = allocateScreenPrivateIndex (d);
	//Check if its valid
	if (bd->PrivateIndex<0)
	{
		//Its invalid so free memory and return
		free(bd);
		return FALSE;
	}
	//Initiliaze options
	BlurDisplayInitOptions(bd,d);
	//Record the display
	d->privates[displayPrivateIndex].ptr=bd;
	return TRUE;
}

static void
BlurFiniDisplay (CompPlugin *p,
		  CompDisplay *d)
{
	//Get the display handle
	BlurDisplay* bd=(BlurDisplay*)d->privates[displayPrivateIndex].ptr;
	//Free the private index
	freeScreenPrivateIndex (d, bd->PrivateIndex);
	//Free the pointer
	free(bd);
}
static Bool
BlurInit (CompPlugin *p)
{
     displayPrivateIndex = allocateDisplayPrivateIndex ();
    if (displayPrivateIndex < 0)
	return FALSE;

    return TRUE;
}

static void
BlurFini (CompPlugin *p)
{
   if (displayPrivateIndex >= 0)
	freeDisplayPrivateIndex (displayPrivateIndex);
}
//Options
static CompOption *
BlurGetDisplayOptions (CompDisplay *display, int *count)
{
	//Get the display handle
	BlurDisplay* bd=(BlurDisplay*)display->privates[displayPrivateIndex].ptr;
	*count=NUMBER_OF_OPTIONS;
	return &bd->opt[0];

}
void ReInitFactor(CompDisplay     *display)
{
	//Get the display handle
	BlurDisplay* bd=(BlurDisplay*)display->privates[displayPrivateIndex].ptr;
	//Get the blur screen
	CompScreen *screen=display->screens;
	glEnable(GL_TEXTURE_RECTANGLE_ARB);
	
	while (screen!=NULL)
	{
	BlurScreen* bs=(BlurScreen*)screen->privates[bd->PrivateIndex].ptr;
		if (bs->HasInit==1)
		{
			
			//Delete the current texture
			glDeleteTextures(1,&bs->TexTemp.Handle);
			//Generate the OpenGL textures
			glGenTextures (1,&bs->TexTemp.Handle);
			//Record with and height
			bs->TexTemp.Width=(int)floor((float)screen->width/bd->opt[BLUR_DISPLAY_OPTION_BLUR_FACTOR].value.f);
			bs->TexTemp.Height=(int)floor((float)screen->height/bd->opt[BLUR_DISPLAY_OPTION_BLUR_FACTOR].value.f);
			//Bind the texture
			glBindTexture(GL_TEXTURE_RECTANGLE_ARB,bs->TexTemp.Handle);
			//Load the parameters
			glTexParameteri (GL_TEXTURE_RECTANGLE_ARB, GL_TEXTURE_MIN_FILTER, FILTERING);
		    	glTexParameteri (GL_TEXTURE_RECTANGLE_ARB, GL_TEXTURE_MAG_FILTER,FILTERING);
		   	glTexParameteri (GL_TEXTURE_RECTANGLE_ARB, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
		    	glTexParameteri (GL_TEXTURE_RECTANGLE_ARB, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
			glTexImage2D(GL_TEXTURE_RECTANGLE_ARB, 0, GL_RGBA, bs->TexTemp.Width,bs->TexTemp.Height, 0, GL_RGBA, GL_UNSIGNED_BYTE, NULL);
			//Force the display list to regenerate
			glDeleteLists(bs->DList,1);
			bs->DList=0;
			glDeleteLists(bs->BlurList,1);
			bs->BlurList=0;
			//Damage the screen to redraw
			damageScreenRegion(screen,&screen->region);
		}
		screen=screen->next;
	}
	glDisable(GL_TEXTURE_RECTANGLE_ARB);
	

}
void ReInitMode(CompDisplay     *display)
{
	//Get the display handle
	BlurDisplay* bd=(BlurDisplay*)display->privates[displayPrivateIndex].ptr;
	//Get the blur screen
	CompScreen *screen=display->screens;
	glEnable(GL_TEXTURE_RECTANGLE_ARB);
	Bool UseShader=FALSE;
	char *ShaderH=NULL;
	char *ShaderV=NULL;
	//Check if we are reinitiliazing for shader support
	if (g_strcasecmp(bd->opt[BLUR_DISPLAY_OPTION_MODE].value.s,FAST)==0)
	{
		//Setup settings for fast shader
		UseShader=TRUE;
		ShaderH=blurFP_FASTH;
		ShaderV=blurFP_FASTV;

	}
	else if (g_strcasecmp(bd->opt[BLUR_DISPLAY_OPTION_MODE].value.s,BEST)==0)
	{
		//Setup settings for best shader
		UseShader=TRUE;
		ShaderH=blurFP_BESTH;
		ShaderV=blurFP_BESTV;
	}
		
	while (screen!=NULL)
	{
		if ((UseShader==TRUE)&&(screen->fragmentProgram==0))
			UseShader=FALSE;
		BlurScreen* bs=(BlurScreen*)screen->privates[bd->PrivateIndex].ptr;
		if (bs->HasInit==1)
		{
			CompScreen *Current=screen;
			if (bs->ShaderH!=ShaderH)
			{
			if (bs->BlurShaderH==0)
			{
				(*Current->deletePrograms) (1,&bs->BlurShaderV);
				(*Current->deletePrograms) (1,&bs->BlurShaderH);
			}
			bs->UseShader=UseShader;
				bs->ShaderH=ShaderH;
				bs->ShaderV=ShaderV;
			if (UseShader)
			{
			
				
				//Clear all errors before
				glGetError ();
				//Load the fragment program 
				(*Current->genPrograms) (1, &bs->BlurShaderH);
				(*Current->bindProgram) (GL_FRAGMENT_PROGRAM_ARB, bs->BlurShaderH);
				(*Current->programString) (GL_FRAGMENT_PROGRAM_ARB, GL_PROGRAM_FORMAT_ASCII_ARB, strlen (bs->ShaderH),bs->ShaderH);
				int errorPos;
				
				glGetIntegerv (GL_PROGRAM_ERROR_POSITION_ARB, &errorPos);
				if (glGetError () != GL_NO_ERROR || errorPos != -1)
				{
					fprintf (stderr, "%s: error loading fragment program at line: %d\n", programName, errorPos);
					fprintf (stderr, glGetString(GL_PROGRAM_ERROR_STRING_ARB));
					glGetIntegerv(GL_MAX_PROGRAM_INSTRUCTIONS_ARB,&errorPos);
					(*Current->deletePrograms) (1,&bs->BlurShaderH);
					bs->BlurShaderH = 0;
					//return 0;
				}
				//Load the fragment program 
				(*Current->genPrograms) (1, &bs->BlurShaderV);
				//CHECK_ERROR(1)
				(*Current->bindProgram) (GL_FRAGMENT_PROGRAM_ARB, bs->BlurShaderV);
				(*Current->programString) (GL_FRAGMENT_PROGRAM_ARB, GL_PROGRAM_FORMAT_ASCII_ARB, strlen (bs->ShaderV),bs->ShaderV);
				glGetIntegerv (GL_PROGRAM_ERROR_POSITION_ARB, &errorPos);
					if (glGetError () != GL_NO_ERROR || errorPos != -1)
				{
					fprintf (stderr, "%s: error loading fragment program at line: %d\n", programName, errorPos);
					fprintf (stderr, glGetString(GL_PROGRAM_ERROR_STRING_ARB));
					glGetIntegerv(GL_MAX_PROGRAM_INSTRUCTIONS_ARB,&errorPos);
					(*Current->deletePrograms) (1,&bs->BlurShaderV);
					bs->BlurShaderV = 0;
					//return 0;
				}
			}
				}
		}
		else
		{
			bs->UseShader=UseShader;
			bs->ShaderH=ShaderH;
			bs->ShaderV=ShaderV;

		}
		screen=screen->next;
	}
	glDisable(GL_TEXTURE_RECTANGLE_ARB);
}
static Bool
BlurSetDisplayOption (CompDisplay     *display,
		       char	       *name,
		       CompOptionValue *value)
{
	//Get the display handle
	BlurDisplay* bd=(BlurDisplay*)display->privates[displayPrivateIndex].ptr;
	//Get the option and the index
	CompOption *o;
   	int	       index;
	o = compFindOption (bd->opt, NUMBER_OF_OPTIONS, name, &index);
	//Check if we found the option or else return
	if (!o)
		return FALSE;
	//Find the index and set the option
	switch(index)
	{
		case BLUR_DISPLAY_OPTION_OFF_ON_MOVE:
		case BLUR_DISPLAY_OPTION_OFF_ON_OPACITY:
		case BLUR_DISPLAY_OPTION_TRANSLUCENT:
		case BLUR_DISPLAY_TRANSLUCENT_OFF_ON_MOVE:
		if (compSetBoolOption (o, value))
			return TRUE;
		break;
		case BLUR_DISPLAY_OPTION_BLUR_FACTOR:
		if (compSetFloatOption (o, value))
			{
				ReInitFactor(display);
				return TRUE;
			}
		break;
		case BLUR_DISPLAY_OPTION_MODE:
		if (compSetStringOption (o, value))
		{
			ReInitMode(display);
			return TRUE;
		}
		else
		{
			//String might match so play it safe by comparing shader pointers
			ReInitMode(display);
		}
		break;
		default:
		break;
	}

	return FALSE;
}

CompPluginVTable BlurVTable = {
    "blur",
    "Blur",
    "Blur",
    BlurInit,
    BlurFini,
    BlurInitDisplay,
    BlurFiniDisplay,
    BlurInitScreen,
    BlurFiniScreen,
    0,
    0,
   BlurGetDisplayOptions, /* GetDisplayOptions */
   BlurSetDisplayOption, /* SetDisplayOption */
    0,
    0,
    0,
    0
};

CompPluginVTable *
getCompPluginInfo (void)
{
    return &BlurVTable;
}
