/***************************************************************
 *
 * Copyright (C) 1990-2007, Condor Team, Computer Sciences Department,
 * University of Wisconsin-Madison, WI.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License.  You may
 * obtain a copy of the License at
 * 
 *    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***************************************************************/


 
#include "condor_common.h"

#include <ctype.h>

#include "util_lib_proto.h"

/*
**	Get rid of trailing spaces (and newlines and tabs )
**	as well as beginning ones.  This routine just truncates the line in
**  place.
*/
char *
ltrunc(str)
register char *str;
{
	register char * ptr;

	ptr = str;

	// seek to the null
	while(*ptr)ptr++;

	for(ptr--; ptr >= str; --ptr) {
		if( !isspace(*ptr) ) {
			break;
		}
	}
			
	ptr[1] = '\0';
	while(isspace(*str))str++;
	return(str);
}
