# $Progeny$

import pygtk
pygtk.require("2.0")

import gtk

import configlet

debconf_info = None
debconf_results = None
debconf_committed = False
package_list = []
seen_priorities = []

def fix_priority(cfglet):
    global seen_priorities

    priority = cfglet.get_priority()
    while priority in seen_priorities:
        priority = priority + 1

    seen_priorities.append(priority)
    return priority

def on_init(cfglet):
    global package_list

    package_list.extend(cfglet.get_packages())

def on_launch(cfglet):
    global debconf_info
    global package_list

    if not debconf_info:
        debconf_info = configlet.get_debconf(package_list)

    cfglet.gnome_setup()
    cfglet.load_debconf(debconf_info.get())

def on_apply(cfglet):
    global debconf_results

    if not debconf_results:
        debconf_results = {}
    cfglet.on_gnome_close()
    debconf_results[cfglet.get_name()] = cfglet.report_debconf()

def on_exit(cfglet):
    global debconf_info
    global debconf_results
    global debconf_committed

    # Write all debconf results when the first configlet exits.
    if not debconf_committed:
        # Put up a progress window.
        window = gtk.Window(gtk.WINDOW_POPUP)
        window.set_title("Configuring")
        window.set_position(gtk.WIN_POS_CENTER)
        window.set_modal(gtk.TRUE)
        label = gtk.Label("Writing configuration...")
        box = gtk.Frame()
        box.set_border_width(10)
        box.add(label)
        box.set_shadow_type(gtk.SHADOW_NONE)
        frame = gtk.Frame()
        frame.set_shadow_type(gtk.SHADOW_OUT)
        frame.add(box)
        window.add(frame)
        window.show_all()

        while gtk.events_pending():
            gtk.main_iteration(gtk.FALSE)

        all_debconf = []
        for key in debconf_results.keys():
            all_debconf.extend(debconf_results[key])

        debconf_info.set(all_debconf)
        debconf_info.commit()
        debconf_committed = True

        self.window.destroy()
        while gtk.events_pending():
            gtk.main_iteration(gtk.FALSE)
