/*
 *  Author:       Serg Stoyan
 *
 *  Classes:      AppDefaults : NSObject
 *
 *  Description:  Application defaults. Save/Load dictionaries from
 *                defaults file.
 */

#import <Foundation/NSObject.h>

@class NSMutableDictionary;
@class NSArray;
@class NSString;
@class NSFileManager;

@interface AppDefaults : NSObject
{
  NSFileManager       *fileManager;
  NSString            *libraryPath;
  NSString            *sessionsPath;

  NSMutableString     *defaultsFile;
  NSMutableDictionary *defaultsDict;       // whole defaults file
  NSMutableDictionary *sessionsDict;       // Sections = {};
}

- (void) writeToFile;

- (NSMutableDictionary *) defaultsDict;

- (NSMutableDictionary *) sessionsDict;

- (NSArray *) sessionsList;

- (void) setDefaultSessionName: (NSString *)sessionName;

- (void) setRunOnStartupDefaultSession: (NSString *)run;

- (NSString *) defaultSessionName;

- (NSString *) runOnStartupDefaultSession;

- (void) removeSessionWithName: (NSString *)sessionName;

- (NSDictionary *)defaultsForSession: (NSString *)sessionName;

// Session bundles
- (NSString *) bundleDirForSessionWithName: (NSString *)name;

- (BOOL) createSessionBundle: (NSDictionary *)prefs
             withSessionName: (NSString *)name;

- (BOOL) removeSessionBundle: (NSString *)name;

- (BOOL) writeString: (NSString *)string
            intoFile: (NSString *)file
    forSessionBundle: (NSString *)name;

- (BOOL) clearFile: (NSString *)file
  forSessionBundle: (NSString *)name;
  
- (BOOL) removeFile: (NSString *)file
   forSessionBundle: (NSString *)name;

- (NSString *) sessionBundle: (NSString *)name
                fileContents: (NSString *)file;

// Files and directories
- (NSString *) appLibraryDirectory;

- (BOOL) fileExistsAtPath: (NSString *)file
                 isCreate: (BOOL)isCreate
              isDirectory: (BOOL)isDirectory;

@end


