.\" $Id: conquest.man 566 2006-07-30 00:54:31Z jon $
.TH "conqinit" 6 "" ""
.SH NAME
conqinit \- a utility for the Conquest Init parser (CQI)
.SH SYNOPSIS
.PP
\fBconqinit\fP [OPTIONS]
.SH DESCRIPTION
.PP
\fBconqinit\fP can be used to test the parser, perform syntax checking
on conqinitrc and texturesrc files, as well as to generate initdata.h
and sounddata.h header files containing compiled-in defaults.
.PP
CQI is a lex/yacc parser that is used by \fBConquest\fP 8.1.2a or
later for configuration of the planets and other general purpose data,
and for the GL client \fBconquestgl\fP, for the specification of
colors, textures, animation definitions, sound, and music.
.PP
These pre\-generated header files (initdata.h, sounddata.h) contain
defaults compiled directly into conquest, in the event the relevant
CQI config file could not be opened or successfully read on startup.
End users should not generate these files.  Validated header files are
included with the src distribution.
.PP
If you are modifying one of the CQI config files, (conquestrc,
soundrc, etc), you should at least run conqinit on them to check for
syntax or other validation errors.  If conquest (or conquestd) fails
to properly load and parse the file at runtime, the built in internal
defaults will be used (when possible) and a warning message will be
logged. 
.SH "OPTIONS"
.PP
.TP 8
.B \-f <file>
Read data from file <file>.
.TP 8
.B \-v 
Be verbose about everything.
.TP 8
.B \-d
Turns on alot of debugging.
.TP 8
.B \-s 
Treat the input file as a file in soundrc format.  The default is
to treat the file as if it were in conqinitrc format.
.TP 8
.B \-t 
Treat the input file as a file in texturesrc format.  The default is
to treat the file as if it were in conqinitrc format.
.TP 8
.B \-h
Dump the parsed file out to stdout in initdata.h sounddata.h format 
(depending on the presence of the \fB\-s\fP option).
.TP 8
.B \-D
Dump the current universe to stdout in conqinitrc format.
.PP
        This option is sort of a hack.  It loads the current state of
        the universe on the local machine and generates a conqinitrc
        format file on stdout.  This file can be saved and made the
        default conqinitrc for a system.
.PP
        If you do this, you will almost certainly want to edit the
        generated file and at least change the colors of the suns, and
        the sun's
        randomized army counts.  Since this data is not currently
        stored in the common block, conqinit tries to choose
        reasonable defaults for them.  Make sure it actually did :)
.PP
        This capability is useful if you init the universe, then use
        conqoper to edit and or create new planets and arrange them
        just like you want them.  Then, using the above command, dump
        the universe to a conqinitrc file, edit it if neccessary (to
        clean up colors, etc).  
.PP
        Then copy that file over the system's conqinitrc file (or email
        it to your friends :).  From
        then on, whenever the planets are initialized (due to a
        successful conquer, or the actions of an oper in conqoper),
        your definitions will be used as the default planet
        configuration. 

.SH "AUTHOR"
Jon Trulson
.SH "SEE ALSO"
.PP
conquestd(6), conqoper(6), conqdriv(6), conquestsh(6),
conqmetad(6) 
.PP
See the CONQINIT.TXT file in the src distribution (or on the conquest
web page) for detailed information on the syntax of the files parsed
by \fBconqinit\fP, as well as other information not mentioned here.
.SH "COPYRIGHT"
.PP
Copyright (C)1994-2006 by Jon Trulson <jon@radscan.com> under the
ARTISTIC License.


