/*
    This file is part of the KDE project.
    Copyright (c) 2006 Friedrich W. H. Kossebau <Friedrich.W.H@Kossebau.de>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
    Boston, MA 02110-1301  USA
*/



// qt specific
// kde specific
#include <kiconloader.h>
#include <klocale.h>
#include <kapplication.h>
#include <dcopclient.h>
#include <dcopref.h>
// menu specific
#include "lazyfillmenu.h"
#include "emailmenufiller.h"
#include "phonemenufiller.h"
#include "addressmenufiller.h"
#include "webmenufiller.h"
#include "blogmenufiller.h"
#include "immenufiller.h"
#include "contactmenufiller.h"




void ContactMenuFiller::createEntry( const KABC::Addressee Contact, QPopupMenu *Menu )
{
    // get some icon to display in front
    KABC::Picture ABCPicture = Contact.photo();
    if( ABCPicture.data().isNull() )
        ABCPicture = Contact.logo();

    QPixmap Pixmap;
    if( ABCPicture.isIntern() && !ABCPicture.data().isNull() )
        Pixmap = ABCPicture.data();

    // menu
    LazyFillMenu *SubMenu = new LazyFillMenu( new ContactMenuFiller(Contact), false, Menu );
    // put it in
    Menu->insertItem( Pixmap, protectAmpersand(Contact.realName()), SubMenu );
}


ContactMenuFiller::ContactMenuFiller( const KABC::Addressee C )
: Contact( C )
{
}


void ContactMenuFiller::fill( QPopupMenu *Menu )
{
    // contacts
    EmailMenuFiller::createEntry( Contact, Menu );
    IMMenuFiller::createEntry( Contact, Menu );
    PhoneMenuFiller::createEntry( Contact, Menu );
    AddressMenuFiller::createEntry( Contact, Menu );

    // separator usefull?
    if( Menu->count() > 0 )
        Menu->insertSeparator();
    unsigned int LastCount = Menu->count();

    // publics
    WebMenuFiller::createEntry( Contact, Menu );
    BlogMenuFiller::createEntry( Contact, Menu );

    if( Menu->count() > LastCount )
        Menu->insertSeparator();

    // vcard
    //VCardMenuFiller::createEntry( Contact, Menu );

    //int id =  Menu->insertItem( i18n("&Visiting card") );
    //Menu->setItemEnabled( id, false );
    // TODO: action menu for copy to clipboard etc.

    //Menu->insertSeparator();

    Menu->insertItem( SmallIconSet("edit"), i18n("&Edit..."),
                      this, SLOT(launchAddressEditor()) );
}


void ContactMenuFiller::launchAddressEditor() const
{
    if ( kapp->dcopClient()->isApplicationRegistered("kaddressbook") )
        DCOPRef( "kaddressbook", "kaddressbook" ).send( "newInstance()" );
    else
        KApplication::startServiceByDesktopName( "kaddressbook" );

    DCOPRef( "kaddressbook", "KAddressBookIface" ).send( "showContactEditor(QString)", Contact.uid() );
}

#include "contactmenufiller.moc"
