/*
    This file is part of the KDE project.
    Copyright (c) 2006 Friedrich W. H. Kossebau <Friedrich.W.H@Kossebau.de>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
    Boston, MA 02110-1301  USA
*/


#ifndef TOPCONTACTLISTMENUFILLER_H
#define TOPCONTACTLISTMENUFILLER_H


// qt specific
#include <qobjectlist.h>
// menu specific
#include "contactlistmenufiller.h"


class TopContactListMenuFiller : public ContactListMenuFiller
{
public:
    TopContactListMenuFiller();

public:
    void fill( QPopupMenu *Menu, const AddresseeListSpan Span );
    void clear();

protected: // ContactMenuFiller API
    virtual LazyFillMenu *createSubMenu( MenuFiller *Filler, QPopupMenu *Menu );

protected:
    QObjectList SubMenuStore;
};

inline void TopContactListMenuFiller::clear() { SubMenuStore.clear(); }

#endif
