#!/usr/bin/env python
#
#   ConVirt   -  Copyright (c) 2008 Convirture Corp
#   ======
#
# ConVirt is a Xen management tool with a GTK based graphical interface
# that allows for performing the standard set of domain operations
# (start, stop, pause, kill, shutdown, reboot, snapshot, etc...). It
# also attempts to simplify certain aspects such as the creation of
# domains, as well as making the consoles available directly within the
# tool's user interface.
#
#
# This software is subject to the GNU Lesser General Public License (LGPL)
# and for details, please consult it at:
#
#    http://www.fsf.org/licensing/licenses/lgpl.txt
#
# author : Jd <jd_jedi@users.sourceforge.net>
#

# Base class for all Appliance proxies.
# An Appliance proxy will typically expose operations that can be invoked
# on an appliance.
# Examples : Check for update, Take a back up etc.

# A proxy class would implement
#   - A UI integration component
#     - define operations strings and opcodes to be called back with.
#     - A class that would implement the callback. Typically, the callback
#       would show a GUI component if required, get necessary input from the
#       user and invoke the op on the agent 
#   - Actual implementation of methods to talk to the appliance (typically
#     an agent in the vm)

class ApplianceProxy:
    def getProxyIntegration(self):
        # example :
        # ops =  { "Check for updates" : "CHECK_FOR_UPDATE",
        #          "Backup Now" : "BACKUP_NOW"
        #        }
        # return ops
        return None

    # Callback 
    def executeOp(self, context, opcode):
        raise Exception("Appliance operation not implemented ", opcode)


