Summary: A graphical Virtualization management tool
Name: convirt
Version: 0.9.6
License: GPL
Group: Applications/System
Packager: Jd  <jd_jedi@users.sourceforge.net>
URL: http://www.convirt.net
BuildArchitectures: noarch
Source: http://prdownloads.sourceforge.net/xenman/%{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-buildroot
%if "%{_vendor}" == "suse"
Release: 1.suse
Requires: python >= 2.4, xen >= 3.0.3, python-gtk, vte
Requires: python-paramiko >= 1.6.4
%define distext suse
%else
Release: 1.fedora
Requires: python >= 2.4, xen >= 3.0.3, pygtk2, vte
Requires: python-paramiko >= 1.6.4
%define distext fedora
%endif

%description
ConVirt is an intuitive, graphical management tool aimed at operational 
lifecycle management for virtualization platform. ConVirt is built 
on the firm design philosophy that ease-of-use and sophistication can, 
and should, co-exist in a single management tool. So, ConVirt should 
hopefully prove valuable to both seasoned Administrators as well as 
those just seeking an introduction to Virtualization.

%prep
%setup -q

%install
[ %{buildroot} != / ] && %{__rm} -rf %{buildroot}

%{__mkdir_p} %{buildroot}%{_datadir}/%{name}/doc
%{__mkdir_p} %{buildroot}%{_datadir}/%{name}/src
%{__mkdir_p} %{buildroot}%{_datadir}/%{name}/install
%{__mkdir_p} %{buildroot}%{_localstatedir}/cache/%{name}
%{__mkdir_p} %{buildroot}%{_localstatedir}/cache/%{name}/image_store
%{__mkdir_p} %{buildroot}%{_localstatedir}/cache/%{name}/storage
%{__mkdir_p} %{buildroot}%{_localstatedir}/cache/%{name}/appliance_store
%{__mkdir_p} %{buildroot}%{_bindir}

%{__install} -Dp -m0644 install/client/distros/%{distext}/%{name}.conf %{buildroot}%{_sysconfdir}/%{name}.conf
find src | %{__cpio} -pdm %{buildroot}%{_datadir}/%{name}
find doc | %{__cpio} -pdm %{buildroot}%{_datadir}/%{name}
find storage | %{__cpio} -pdm %{buildroot}%{_datadir}/%{name}
find install | %{__cpio} -pdm %{buildroot}%{_datadir}/%{name}
find image_store | %{__cpio} -pdm %{buildroot}%{_localstatedir}/cache/%{name}
find appliance_store | %{__cpio} -pdm %{buildroot}%{_localstatedir}/cache/%{name}

%{__chmod} 0755 %{buildroot}%{_datadir}/%{name}/src/convirt/client/%{name}_client.py
%{__chmod} 0755 %{buildroot}%{_datadir}/%{name}/install/common/mk_image_store
%{__chmod} 0544 %{buildroot}%{_datadir}/%{name}/install/common/patches/patch_paramiko
imagelist="Windows_CD_Install Fedora_PV_Install CentOS_PV_Install Linux_CD_Install _template_ example"
for image in $imagelist
do
%{__chmod} 0744 %{buildroot}%{_localstatedir}/cache/%{name}/image_store/$image/provision.sh
done 
%{__chmod} 0744 %{buildroot}%{_datadir}/%{name}/src/convirt/core/appliance/xen/provision.sh
%{__chmod} 0744 %{buildroot}%{_datadir}/%{name}/src/convirt/core/appliance/kvm/provision.sh


%{__ln_s} ../share/%{name}/install/client/ConVirt %{buildroot}%{_bindir}/%{name}
%{__ln_s} ../share/%{name}/install/common/mk_image_store %{buildroot}%{_bindir}/mk_image_store


%clean
[ %{buildroot} != / ] && %{__rm} -rf %{buildroot}


%files
%defattr(-,root,root,-)
%doc doc/* 
%config %{_sysconfdir}/%{name}.conf
%{_bindir}/%{name}
%{_bindir}/mk_image_store
%{_datadir}/%{name}
%{_localstatedir}/cache/%{name}/image_store
%{_localstatedir}/cache/%{name}/appliance_store
%dir %{_localstatedir}/cache/%{name}

%changelog
* Mon Sep 22 2008 Jd <jd_jedi@users.sourceforge.net> 0.9.5-1
- minor change for 0.9.5 version 

* Tue Jun 10 2008 Jd <jd_jedi@users.sourceforge.net> 0.9-1
- major changes for 0.9 version 

* Thu Jan 04 2008 Jd <jd_jedi@users.sourceforge.net> 0.7-1
- changes for 0.7 version 

* Thu Nov 29 2007 Jd <jd_jedi@users.sourceforge.net> 0.7-1
- prelim modification for new version

* Mon Dec 28 2006 Haphazard <haphazard1@users.sourceforge.net> 0.6-1
- new version

* Thu Sep 28 2006 Haphazard <haphazard1@users.sourceforge.net> 0.5-1
- new version

* Thu Aug 24 2006 Jd <jd_jedi@users.sourceforge.net> 0.4.2.2
- hotfix for start up problem.

* Sun Aug 13 2006 Haphazard <haphazard1@users.sourceforge.net> 0.4.2-1
- extended SUSE dependency list.

* Tue Jul 25 2006 Yves Perrenoud <yves@xpand.org> 0.4.1-2
- added some SUSE specific elements to ultimately support the post-install
  creating of an install initial ramdisk
- now marks the config file as one

* Mon Jul 24 2006 Yves Perrenoud <yves@xpand.org> 0.4.1-1
- new version
- added Suse support

* Wed Jul 19 2006 Yves Perrenoud <yves@xpand.org> 0.4-1
- new version
- added the change log to the doc files

* Thu Jun 8 2006 Yves Perrenoud <yves@xpand.org> 0.3-1
- Initial build.
