#!/bin/bash
# 
# This script modifies the xend configuration file: xend-config.sxp
# to allow xmlrpc access over tcp and to allow domain relocation
# (migration) to all hosts.
#
#
#  Author - Haphazard
#  Copyright (c) 2007 Convirture Corporation
# 
#
# This software is subject to the GNU Lesser General Public License (LGPL)
# available at: http://www.fsf.org/licensing/licenses/lgpl.txt
#



ORIGCONFIG="/etc/xen/xend-config.sxp"
XEN_VER="3.1"
if [ "$1" !=  "" ]; then
    XEN_VER="$1"
fi

if [ "$XEN_VER" != "3.1" ]; then
    echo "Only Xen 3.1 supported."
    exit 1
fi

USE_SSL=""
# check if SSL setup needs to be done or not.
if [ "$2" ==  "SSL" ]; then
    USE_SSL="SSL"
fi

OPENSSL=openssl
if [ "$USE_SSL" == "SSL" ]; then
    python -c "import OpenSSL" &> /dev/null
    if [ "$?" != 0 ]; then
       echo "pyOpenSSL not found. Please make sure that pyOpenSSL is installed."
       exit 1 
    fi
    
    echo "Setting up self signed certificates"
    $OPENSSL version &> /dev/null
    if [ "$?" != 0 ]; then
       echo "$OPENSSL not found. Please make sure that openssl is installed and is in path."
       exit 1 
    fi
    # create a respose file for ssl certificate creation

    # Modify the certificate params for deployment details on response 
    # is as follows

    # Country Name (2 letter code)
    # State or Province Name (full name)
    # Locality Name (e.g. city)
    # Organization Name (eg, company)
    # Organizational Unit Name (eg, section)
    # Common Name (eg, your name or your server's hostname) 
    # Email Address 
    # A challenge password 
    # An optional company name 

    cat  <<EOF > /tmp/open_ssl.res
US
CA
SF
Test Corp
.
$HOSTNAME
.
.
.
EOF
    KEY=/etc/xen/xmlrpc.key
    CSR=/etc/xen/xmlrpc.csr
    CRT=/etc/xen/xmlrpc.crt
    $OPENSSL genrsa -out $KEY 1024
    $OPENSSL req -new -key $KEY -out $CSR < /tmp/open_ssl.res
    $OPENSSL x509 -req -in $CSR -signkey $KEY -out $CRT
    rm /tmp/open_ssl.res    
fi

# Adjust the regexp for the config file
SPACE=" "
if [ "$USE_SSL" == "SSL" ]; then
   SPACE=""
fi


# make the necessary configuration changes to 
# enable xml-tcp-rpc and domain relocation.
sed  "
# Enable tcp-xmlrpc
/xend-tcp-xmlrpc-server$SPACE/ {s/^#//;s/no/yes/}
/xen-tcp-xmlrpc-server-/ {s/^#//;s/xen-tcp/xend-tcp/;s/localhost//}

# Enable relocation server and addresses
/(xend-relocation-port/ s/^#//
/(xend-relocation-server/ {s/^#//;s/no/yes/}
/(xend-relocation-address/ s/^#//

# Allow relocation to any host.
/(xend-relocation-hosts-allow '')/ s/^#//
/^(xend-relocation-hosts-allow.*localhost/ s/^/#/

# for ubuntu fix the bridge entry
/(network-script / s/network-dummy/network-bridge/

" < "$ORIGCONFIG" > "$ORIGCONFIG.new"

# swap the new and original configurations
mv $ORIGCONFIG $ORIGCONFIG.orig
mv $ORIGCONFIG.new $ORIGCONFIG

echo "Modified xend-config successfully"

## THIS IS NOT REQUIRED and DOES NOT WORK.
## TYPO IN xend-config.sxp is fixed through regexp above
# patch XMLRPCServer
#sh ./patch_XMLRPCServer XMLRPCServer.py-$XEN_VER-diff

# restart xend for the new config to take effect.
#/sbin/service xend restart
/etc/init.d/xend restart
if [ $? -ne 0 ]; then
    exit 1
fi
exit 0

