(***********************************************************************)
(*  v      *   The Coq Proof Assistant  /  The Coq Development Team    *)
(* <O___,, *        INRIA-Rocquencourt  &  LRI-CNRS-Orsay              *)
(*   \VV/  *************************************************************)
(*    //   *      This file is distributed under the terms of the      *)
(*         *       GNU Lesser General Public License Version 2.1       *)
(***********************************************************************)

(*i $Id: rtree.mli,v 1.1 2002/02/14 15:54:00 barras Exp $ i*)

(* Type of regular tree with nodes labelled by values of type 'a *)
type 'a t

(* Building trees *)
(* build a recursive call *) 
val mk_param : int -> 'a t
(* build a node given a label and the vector of sons *)
val mk_node  : 'a -> 'a t array -> 'a t
(* build mutually dependent trees *)
val mk_rec   : 'a t array -> 'a t array

(* [lift k t] increases of [k] the free parameters of [t]. Needed
   to avoid captures when a tree appears under mk_rec *) 
val lift : int -> 'a t -> 'a t

(* Destructors (recursive calls are expanded) *)
val dest_param : 'a t -> int
val dest_node  : 'a t -> 'a * 'a t array

(* Tells if a tree has an infinite branch *)
val is_infinite : 'a t -> bool

(* A rather simple minded pretty-printer *)
val pp_tree : ('a -> Pp.std_ppcmds) -> 'a t -> Pp.std_ppcmds
