(************************************************************************)
(*  v      *   The Coq Proof Assistant  /  The Coq Development Team     *)
(* <O___,, * CNRS-Ecole Polytechnique-INRIA Futurs-Universite Paris Sud *)
(*   \VV/  **************************************************************)
(*    //   *      This file is distributed under the terms of the       *)
(*         *       GNU Lesser General Public License Version 2.1        *)
(************************************************************************)

(*i $Id: command.mli 9110 2006-09-01 12:30:52Z herbelin $ i*)

(*i*)
open Util
open Names
open Term
open Nametab
open Declare
open Library
open Libnames
open Nametab
open Tacexpr
open Vernacexpr
open Rawterm
open Topconstr
open Decl_kinds
open Redexpr
(*i*)

(*s Declaration functions. The following functions take ASTs,
   transform them into [constr] and then call the corresponding
   functions of [Declare]; they return an absolute reference to the
   defined object *)

val declare_definition : identifier -> definition_kind ->
  local_binder list -> red_expr option -> constr_expr ->
    constr_expr option -> declaration_hook -> unit

val syntax_definition : identifier -> constr_expr -> bool -> bool -> unit

val declare_assumption : identifier located list ->
  coercion_flag -> assumption_kind -> local_binder list -> constr_expr -> unit

val build_mutual : (inductive_expr * decl_notation) list -> bool -> unit

val declare_mutual_with_eliminations :
  bool -> Entries.mutual_inductive_entry -> mutual_inductive

val build_recursive : (fixpoint_expr * decl_notation) list -> bool -> unit

val build_corecursive : (cofixpoint_expr * decl_notation) list -> bool -> unit

val build_scheme : (identifier located * bool * reference * rawsort) list -> unit

val generalize_constr_expr : constr_expr -> local_binder list -> constr_expr

val start_proof : identifier -> goal_kind -> constr ->
  declaration_hook -> unit

val start_proof_com : identifier option -> goal_kind -> 
  (local_binder list * constr_expr) -> declaration_hook -> unit

(*s [save_named b] saves the current completed proof under the name it
was started; boolean [b] tells if the theorem is declared opaque; it
fails if the proof is not completed *)

val save_named : bool -> unit

(* [save_anonymous b name] behaves as [save_named] but declares the theorem
under the name [name] and respects the strength of the declaration *)

val save_anonymous : bool -> identifier -> unit

(* [save_anonymous_with_strength s b name] behaves as [save_anonymous] but
   declares the theorem under the name [name] and gives it the
   strength [strength] *)

val save_anonymous_with_strength : theorem_kind -> bool -> identifier -> unit

(* [admit ()] aborts the current goal and save it as an assmumption *)

val admit : unit -> unit

(* [get_current_context ()] returns the evar context and env of the
   current open proof if any, otherwise returns the empty evar context
   and the current global env *)

val get_current_context : unit -> Evd.evar_map * Environ.env


