;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;  v      ;   The Coq Proof Assistant  /  The Coq Development Team     ;;
;; <O___,, ;   INRIA - CNRS - LIX - LRI - PPS - Copyright 1999-2010     ;;
;;   \VV/  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;    //   ;      This file is distributed under the terms of the       ;;
;;         ;       GNU Lesser General Public License Version 2.1        ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; coqide-rules.scm -- key sequence tables for coqide.scm

;; Copyright (c) 2003-2009 uim Project http://code.google.com/p/uim/
;;
;; All rights reserved.

;; The translation tables in this file were derived from
;; the emacs-lisp source files latin-pre.el, latin-post.el, latin-alt.el
;; included in GNU Emacs.  The following is the original copyright notice
;; therein, with the name GNU Emacs replaced by "this program".

;; Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005,
;;   2006, 2007
;;   Free Software Foundation, Inc.
;; Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005,
;;   2006, 2007
;;   National Institute of Advanced Industrial Science and Technology (AIST)
;;   Registration Number H14PRO021

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, write to the
;; Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
;; Boston, MA 02110-1301, USA.

;;; Commentary:

;; Key translation maps were originally copied from iso-acc.el.
;; latin-1-prefix: extra special characters added, adapted from the vim
;;                 digraphs (from J.H.M.Dassen <jdassen@wi.leidenuniv.nl>)
;;                 by R.F. Smith <rsmith@xs4all.nl>
;;
;; polish-slash:
;; Author: Włodek Bzyl <matwb@univ.gda.pl>
;; Maintainer: Włodek Bzyl <matwb@univ.gda.pl>
;;
;; latin-[89]-prefix: Dave Love <fx@gnu.org>

(define coqide-rules-latin-ltx '(
((("!" "`")) ("¡"))
((("\\" "p" "o" "u" "n" "d" "s")) ("£"))
((("\\" "S")) ("§"))
((("\\" "\"" "{" "}")) ("¨"))
((("\\" "c" "o" "p" "y" "r" "i" "g" "h" "t")) ("©"))
((("$" "^" "a" "$")) ("ª"))
((("\\" "=" "{" "}")) ("¯"))
((("$" "\\" "p" "m" "$")) ("±"))
((("\\" "p" "m")) ("±"))
((("$" "^" "2" "$")) ("²"))
((("$" "^" "3" "$")) ("³"))
((("\\" "'" "{" "}")) ("´"))
((("\\" "P")) ("¶"))
((("$" "\\" "c" "d" "o" "t" "$")) ("·"))
((("\\" "c" "d" "o" "t")) ("·"))
((("\\" "c" "{" "}")) ("¸"))
((("$" "^" "1" "$")) ("¹"))
((("$" "^" "o" "$")) ("º"))
((("?" "`")) ("¿"))
((("\\" "`" "{" "A" "}")) ("À"))
((("\\" "`" "A")) ("À"))
((("\\" "'" "{" "A" "}")) ("Á"))
((("\\" "'" "A")) ("Á"))
((("\\" "^" "{" "A" "}")) ("Â"))
((("\\" "^" "A")) ("Â"))
((("\\" "~" "{" "A" "}")) ("Ã"))
((("\\" "~" "A")) ("Ã"))
((("\\" "\"" "{" "A" "}")) ("Ä"))
((("\\" "\"" "A")) ("Ä"))
((("\\" "k" "{" "A" "}")) ("Ą"))
((("\\" "A" "A")) ("Å"))
((("\\" "A" "E")) ("Æ"))
((("\\" "c" "{" "C" "}")) ("Ç"))
((("\\" "c" "C")) ("Ç"))
((("\\" "`" "{" "E" "}")) ("È"))
((("\\" "`" "E")) ("È"))
((("\\" "'" "{" "E" "}")) ("É"))
((("\\" "'" "E")) ("É"))
((("\\" "^" "{" "E" "}")) ("Ê"))
((("\\" "^" "E")) ("Ê"))
((("\\" "\"" "{" "E" "}")) ("Ë"))
((("\\" "\"" "E")) ("Ë"))
((("\\" "k" "{" "E" "}")) ("Ę"))
((("\\" "`" "{" "I" "}")) ("Ì"))
((("\\" "`" "I")) ("Ì"))
((("\\" "'" "{" "I" "}")) ("Í"))
((("\\" "'" "I")) ("Í"))
((("\\" "^" "{" "I" "}")) ("Î"))
((("\\" "^" "I")) ("Î"))
((("\\" "\"" "{" "I" "}")) ("Ï"))
((("\\" "\"" "I")) ("Ï"))
((("\\" "k" "{" "I" "}")) ("Į"))
((("\\" "~" "{" "N" "}")) ("Ñ"))
((("\\" "~" "N")) ("Ñ"))
((("\\" "`" "{" "O" "}")) ("Ò"))
((("\\" "`" "O")) ("Ò"))
((("\\" "'" "{" "O" "}")) ("Ó"))
((("\\" "'" "O")) ("Ó"))
((("\\" "^" "{" "O" "}")) ("Ô"))
((("\\" "^" "O")) ("Ô"))
((("\\" "~" "{" "O" "}")) ("Õ"))
((("\\" "~" "O")) ("Õ"))
((("\\" "\"" "{" "O" "}")) ("Ö"))
((("\\" "\"" "O")) ("Ö"))
((("\\" "k" "{" "O" "}")) ("Ǫ"))
((("$" "\\" "t" "i" "m" "e" "s" "$")) ("×"))
((("\\" "t" "i" "m" "e" "s")) ("×"))
((("\\" "O")) ("Ø"))
((("\\" "`" "{" "U" "}")) ("Ù"))
((("\\" "`" "U")) ("Ù"))
((("\\" "'" "{" "U" "}")) ("Ú"))
((("\\" "'" "U")) ("Ú"))
((("\\" "^" "{" "U" "}")) ("Û"))
((("\\" "^" "U")) ("Û"))
((("\\" "\"" "{" "U" "}")) ("Ü"))
((("\\" "\"" "U")) ("Ü"))
((("\\" "k" "{" "U" "}")) ("Ų"))
((("\\" "'" "{" "Y" "}")) ("Ý"))
((("\\" "'" "Y")) ("Ý"))
((("\\" "s" "s")) ("ß"))
((("\\" "`" "{" "a" "}")) ("à"))
((("\\" "`" "a")) ("à"))
((("\\" "'" "{" "a" "}")) ("á"))
((("\\" "'" "a")) ("á"))
((("\\" "^" "{" "a" "}")) ("â"))
((("\\" "^" "a")) ("â"))
((("\\" "~" "{" "a" "}")) ("ã"))
((("\\" "~" "a")) ("ã"))
((("\\" "\"" "{" "a" "}")) ("ä"))
((("\\" "\"" "a")) ("ä"))
((("\\" "k" "{" "a" "}")) ("ą"))
((("\\" "a" "a")) ("å"))
((("\\" "a" "e")) ("æ"))
((("\\" "c" "{" "c" "}")) ("ç"))
((("\\" "c" "c")) ("ç"))
((("\\" "`" "{" "e" "}")) ("è"))
((("\\" "`" "e")) ("è"))
((("\\" "'" "{" "e" "}")) ("é"))
((("\\" "'" "e")) ("é"))
((("\\" "^" "{" "e" "}")) ("ê"))
((("\\" "^" "e")) ("ê"))
((("\\" "\"" "{" "e" "}")) ("ë"))
((("\\" "\"" "e")) ("ë"))
((("\\" "k" "{" "e" "}")) ("ę"))
((("\\" "`" "{" "\\" "i" "}")) ("ì"))
((("\\" "`" "i")) ("ì"))
((("\\" "'" "{" "\\" "i" "}")) ("í"))
((("\\" "'" "i")) ("í"))
((("\\" "^" "{" "\\" "i" "}")) ("î"))
((("\\" "^" "i")) ("î"))
((("\\" "\"" "{" "\\" "i" "}")) ("ï"))
((("\\" "\"" "i")) ("ï"))
((("\\" "k" "{" "i" "}")) ("į"))
((("\\" "~" "{" "n" "}")) ("ñ"))
((("\\" "~" "n")) ("ñ"))
((("\\" "`" "{" "o" "}")) ("ò"))
((("\\" "`" "o")) ("ò"))
((("\\" "'" "{" "o" "}")) ("ó"))
((("\\" "'" "o")) ("ó"))
((("\\" "^" "{" "o" "}")) ("ô"))
((("\\" "^" "o")) ("ô"))
((("\\" "~" "{" "o" "}")) ("õ"))
((("\\" "~" "o")) ("õ"))
((("\\" "\"" "{" "o" "}")) ("ö"))
((("\\" "\"" "o")) ("ö"))
((("\\" "k" "{" "o" "}")) ("ǫ"))
((("$" "\\" "d" "i" "v" "$")) ("÷"))
((("\\" "d" "i" "v")) ("÷"))
((("\\" "o")) ("ø"))
((("\\" "`" "{" "u" "}")) ("ù"))
((("\\" "`" "u")) ("ù"))
((("\\" "'" "{" "u" "}")) ("ú"))
((("\\" "'" "u")) ("ú"))
((("\\" "^" "{" "u" "}")) ("û"))
((("\\" "^" "u")) ("û"))
((("\\" "\"" "{" "u" "}")) ("ü"))
((("\\" "\"" "u")) ("ü"))
((("\\" "k" "{" "u" "}")) ("ų"))
((("\\" "'" "{" "y" "}")) ("ý"))
((("\\" "'" "y")) ("ý"))
((("\\" "\"" "{" "y" "}")) ("ÿ"))
((("\\" "\"" "y")) ("ÿ"))
((("\\" "=" "{" "A" "}")) ("Ā"))
((("\\" "=" "A")) ("Ā"))
((("\\" "=" "{" "a" "}")) ("ā"))
((("\\" "=" "a")) ("ā"))
((("\\" "u" "{" "A" "}")) ("Ă"))
((("\\" "u" "A")) ("Ă"))
((("\\" "u" "{" "a" "}")) ("ă"))
((("\\" "u" "a")) ("ă"))
((("\\" "'" "{" "C" "}")) ("Ć"))
((("\\" "'" "C")) ("Ć"))
((("\\" "'" "{" "c" "}")) ("ć"))
((("\\" "'" "c")) ("ć"))
((("\\" "^" "{" "C" "}")) ("Ĉ"))
((("\\" "^" "C")) ("Ĉ"))
((("\\" "^" "{" "c" "}")) ("ĉ"))
((("\\" "^" "c")) ("ĉ"))
((("\\" "." "{" "C" "}")) ("Ċ"))
((("\\" "." "C")) ("Ċ"))
((("\\" "." "{" "c" "}")) ("ċ"))
((("\\" "." "c")) ("ċ"))
((("\\" "v" "{" "C" "}")) ("Č"))
((("\\" "v" "C")) ("Č"))
((("\\" "v" "{" "c" "}")) ("č"))
((("\\" "v" "c")) ("č"))
((("\\" "v" "{" "D" "}")) ("Ď"))
((("\\" "v" "D")) ("Ď"))
((("\\" "v" "{" "d" "}")) ("ď"))
((("\\" "v" "d")) ("ď"))
((("\\" "=" "{" "E" "}")) ("Ē"))
((("\\" "=" "E")) ("Ē"))
((("\\" "=" "{" "e" "}")) ("ē"))
((("\\" "=" "e")) ("ē"))
((("\\" "u" "{" "E" "}")) ("Ĕ"))
((("\\" "u" "E")) ("Ĕ"))
((("\\" "u" "{" "e" "}")) ("ĕ"))
((("\\" "u" "e")) ("ĕ"))
((("\\" "." "{" "E" "}")) ("Ė"))
((("\\" "." "E")) ("Ė"))
((("\\" "e" "{" "e" "}")) ("ė"))
((("\\" "e" "e")) ("ė"))
((("\\" "v" "{" "E" "}")) ("Ě"))
((("\\" "v" "E")) ("Ě"))
((("\\" "v" "{" "e" "}")) ("ě"))
((("\\" "v" "e")) ("ě"))
((("\\" "^" "{" "G" "}")) ("Ĝ"))
((("\\" "^" "G")) ("Ĝ"))
((("\\" "^" "{" "g" "}")) ("ĝ"))
((("\\" "^" "g")) ("ĝ"))
((("\\" "u" "{" "G" "}")) ("Ğ"))
((("\\" "u" "G")) ("Ğ"))
((("\\" "u" "{" "g" "}")) ("ğ"))
((("\\" "u" "g")) ("ğ"))
((("\\" "." "{" "G" "}")) ("Ġ"))
((("\\" "." "G")) ("Ġ"))
((("\\" "." "{" "g" "}")) ("ġ"))
((("\\" "." "g")) ("ġ"))
((("\\" "c" "{" "G" "}")) ("Ģ"))
((("\\" "c" "G")) ("Ģ"))
((("\\" "c" "{" "g" "}")) ("ģ"))
((("\\" "c" "g")) ("ģ"))
((("\\" "^" "{" "H" "}")) ("Ĥ"))
((("\\" "^" "H")) ("Ĥ"))
((("\\" "^" "{" "h" "}")) ("ĥ"))
((("\\" "^" "h")) ("ĥ"))
((("\\" "~" "{" "I" "}")) ("Ĩ"))
((("\\" "~" "I")) ("Ĩ"))
((("\\" "~" "{" "\\" "i" "}")) ("ĩ"))
((("\\" "~" "i")) ("ĩ"))
((("\\" "=" "{" "I" "}")) ("Ī"))
((("\\" "=" "I")) ("Ī"))
((("\\" "=" "{" "\\" "i" "}")) ("ī"))
((("\\" "=" "i")) ("ī"))
((("\\" "u" "{" "I" "}")) ("Ĭ"))
((("\\" "u" "I")) ("Ĭ"))
((("\\" "u" "{" "\\" "i" "}")) ("ĭ"))
((("\\" "u" "i")) ("ĭ"))
((("\\" "." "{" "I" "}")) ("İ"))
((("\\" "." "I")) ("İ"))
((("\\" "i")) ("ı"))
((("\\" "^" "{" "J" "}")) ("Ĵ"))
((("\\" "^" "J")) ("Ĵ"))
((("\\" "^" "{" "\\" "j" "}")) ("ĵ"))
((("\\" "^" "j")) ("ĵ"))
((("\\" "c" "{" "K" "}")) ("Ķ"))
((("\\" "c" "K")) ("Ķ"))
((("\\" "c" "{" "k" "}")) ("ķ"))
((("\\" "c" "k")) ("ķ"))
((("\\" "'" "{" "L" "}")) ("Ĺ"))
((("\\" "'" "L")) ("Ĺ"))
((("\\" "'" "{" "l" "}")) ("ĺ"))
((("\\" "'" "l")) ("ĺ"))
((("\\" "c" "{" "L" "}")) ("Ļ"))
((("\\" "c" "L")) ("Ļ"))
((("\\" "c" "{" "l" "}")) ("ļ"))
((("\\" "c" "l")) ("ļ"))
((("\\" "L")) ("Ł"))
((("\\" "l")) ("ł"))
((("\\" "'" "{" "N" "}")) ("Ń"))
((("\\" "'" "N")) ("Ń"))
((("\\" "'" "{" "n" "}")) ("ń"))
((("\\" "'" "n")) ("ń"))
((("\\" "c" "{" "N" "}")) ("Ņ"))
((("\\" "c" "N")) ("Ņ"))
((("\\" "c" "{" "n" "}")) ("ņ"))
((("\\" "c" "n")) ("ņ"))
((("\\" "v" "{" "N" "}")) ("Ň"))
((("\\" "v" "N")) ("Ň"))
((("\\" "v" "{" "n" "}")) ("ň"))
((("\\" "v" "n")) ("ň"))
((("\\" "=" "{" "O" "}")) ("Ō"))
((("\\" "=" "O")) ("Ō"))
((("\\" "=" "{" "o" "}")) ("ō"))
((("\\" "=" "o")) ("ō"))
((("\\" "u" "{" "O" "}")) ("Ŏ"))
((("\\" "u" "O")) ("Ŏ"))
((("\\" "u" "{" "o" "}")) ("ŏ"))
((("\\" "u" "o")) ("ŏ"))
((("\\" "H" "{" "O" "}")) ("Ő"))
((("\\" "H" "O")) ("Ő"))
((("\\" "U" "{" "o" "}")) ("ő"))
((("\\" "U" "o")) ("ő"))
((("\\" "O" "E")) ("Œ"))
((("\\" "o" "e")) ("œ"))
((("\\" "'" "{" "R" "}")) ("Ŕ"))
((("\\" "'" "R")) ("Ŕ"))
((("\\" "'" "{" "r" "}")) ("ŕ"))
((("\\" "'" "r")) ("ŕ"))
((("\\" "c" "{" "R" "}")) ("Ŗ"))
((("\\" "c" "R")) ("Ŗ"))
((("\\" "c" "{" "r" "}")) ("ŗ"))
((("\\" "c" "r")) ("ŗ"))
((("\\" "v" "{" "R" "}")) ("Ř"))
((("\\" "v" "R")) ("Ř"))
((("\\" "v" "{" "r" "}")) ("ř"))
((("\\" "v" "r")) ("ř"))
((("\\" "'" "{" "S" "}")) ("Ś"))
((("\\" "'" "S")) ("Ś"))
((("\\" "'" "{" "s" "}")) ("ś"))
((("\\" "'" "s")) ("ś"))
((("\\" "^" "{" "S" "}")) ("Ŝ"))
((("\\" "^" "S")) ("Ŝ"))
((("\\" "^" "{" "s" "}")) ("ŝ"))
((("\\" "^" "s")) ("ŝ"))
((("\\" "c" "{" "S" "}")) ("Ş"))
((("\\" "c" "S")) ("Ş"))
((("\\" "c" "{" "s" "}")) ("ş"))
((("\\" "c" "s")) ("ş"))
((("\\" "v" "{" "S" "}")) ("Š"))
((("\\" "v" "S")) ("Š"))
((("\\" "v" "{" "s" "}")) ("š"))
((("\\" "v" "s")) ("š"))
((("\\" "c" "{" "T" "}")) ("Ţ"))
((("\\" "c" "T")) ("Ţ"))
((("\\" "c" "{" "t" "}")) ("ţ"))
((("\\" "c" "t")) ("ţ"))
((("\\" "v" "{" "T" "}")) ("Ť"))
((("\\" "v" "T")) ("Ť"))
((("\\" "v" "{" "t" "}")) ("ť"))
((("\\" "v" "t")) ("ť"))
((("\\" "~" "{" "U" "}")) ("Ũ"))
((("\\" "~" "U")) ("Ũ"))
((("\\" "~" "{" "u" "}")) ("ũ"))
((("\\" "~" "u")) ("ũ"))
((("\\" "=" "{" "U" "}")) ("Ū"))
((("\\" "=" "U")) ("Ū"))
((("\\" "=" "{" "u" "}")) ("ū"))
((("\\" "=" "u")) ("ū"))
((("\\" "u" "{" "U" "}")) ("Ŭ"))
((("\\" "u" "U")) ("Ŭ"))
((("\\" "u" "{" "u" "}")) ("ŭ"))
((("\\" "u" "u")) ("ŭ"))
((("\\" "H" "{" "U" "}")) ("Ű"))
((("\\" "H" "U")) ("Ű"))
((("\\" "H" "{" "u" "}")) ("ű"))
((("\\" "H" "u")) ("ű"))
((("\\" "^" "{" "W" "}")) ("Ŵ"))
((("\\" "^" "W")) ("Ŵ"))
((("\\" "^" "{" "w" "}")) ("ŵ"))
((("\\" "^" "w")) ("ŵ"))
((("\\" "^" "{" "Y" "}")) ("Ŷ"))
((("\\" "^" "Y")) ("Ŷ"))
((("\\" "^" "{" "y" "}")) ("ŷ"))
((("\\" "^" "y")) ("ŷ"))
((("\\" "\"" "{" "Y" "}")) ("Ÿ"))
((("\\" "\"" "Y")) ("Ÿ"))
((("\\" "'" "{" "Z" "}")) ("Ź"))
((("\\" "'" "Z")) ("Ź"))
((("\\" "'" "{" "z" "}")) ("ź"))
((("\\" "'" "z")) ("ź"))
((("\\" "." "{" "Z" "}")) ("Ż"))
((("\\" "." "Z")) ("Ż"))
((("\\" "." "{" "z" "}")) ("ż"))
((("\\" "." "z")) ("ż"))
((("\\" "v" "{" "Z" "}")) ("Ž"))
((("\\" "v" "Z")) ("Ž"))
((("\\" "v" "{" "z" "}")) ("ž"))
((("\\" "v" "z")) ("ž"))
((("\\" "v" "{" "A" "}")) ("Ǎ"))
((("\\" "v" "A")) ("Ǎ"))
((("\\" "v" "{" "a" "}")) ("ǎ"))
((("\\" "v" "a")) ("ǎ"))
((("\\" "v" "{" "I" "}")) ("Ǐ"))
((("\\" "v" "I")) ("Ǐ"))
((("\\" "v" "{" "\\" "i" "}")) ("ǐ"))
((("\\" "v" "i")) ("ǐ"))
((("\\" "v" "{" "O" "}")) ("Ǒ"))
((("\\" "v" "O")) ("Ǒ"))
((("\\" "v" "{" "o" "}")) ("ǒ"))
((("\\" "v" "o")) ("ǒ"))
((("\\" "v" "{" "U" "}")) ("Ǔ"))
((("\\" "v" "U")) ("Ǔ"))
((("\\" "v" "{" "u" "}")) ("ǔ"))
((("\\" "v" "u")) ("ǔ"))
((("\\" "=" "{" "\\" "A" "E" "}")) ("Ǣ"))
((("\\" "=" "\\" "A" "E")) ("Ǣ"))
((("\\" "=" "{" "\\" "a" "e" "}")) ("ǣ"))
((("\\" "=" "\\" "a" "e")) ("ǣ"))
((("\\" "v" "{" "G" "}")) ("Ǧ"))
((("\\" "v" "G")) ("Ǧ"))
((("\\" "v" "{" "g" "}")) ("ǧ"))
((("\\" "v" "g")) ("ǧ"))
((("\\" "v" "{" "K" "}")) ("Ǩ"))
((("\\" "v" "K")) ("Ǩ"))
((("\\" "v" "{" "k" "}")) ("ǩ"))
((("\\" "v" "k")) ("ǩ"))
((("\\" "v" "{" "\\" "j" "}")) ("ǰ"))
((("\\" "v" "j")) ("ǰ"))
((("\\" "'" "{" "G" "}")) ("Ǵ"))
((("\\" "'" "G")) ("Ǵ"))
((("\\" "'" "{" "g" "}")) ("ǵ"))
((("\\" "'" "g")) ("ǵ"))
((("\\" "`" "{" "N" "}")) ("Ǹ"))
((("\\" "`" "N")) ("Ǹ"))
((("\\" "`" "{" "n" "}")) ("ǹ"))
((("\\" "`" "n")) ("ǹ"))
((("\\" "'" "{" "\\" "A" "E" "}")) ("Ǽ"))
((("\\" "'" "\\" "A" "E")) ("Ǽ"))
((("\\" "'" "{" "\\" "a" "e" "}")) ("ǽ"))
((("\\" "'" "\\" "a" "e")) ("ǽ"))
((("\\" "'" "{" "\\" "O" "}")) ("Ǿ"))
((("\\" "'" "\\" "O")) ("Ǿ"))
((("\\" "'" "{" "\\" "o" "}")) ("ǿ"))
((("\\" "'" "\\" "o")) ("ǿ"))
((("\\" "v" "{" "H" "}")) ("Ȟ"))
((("\\" "v" "H")) ("Ȟ"))
((("\\" "v" "{" "h" "}")) ("ȟ"))
((("\\" "v" "h")) ("ȟ"))
((("\\" "." "{" "A" "}")) ("Ȧ"))
((("\\" "." "A")) ("Ȧ"))
((("\\" "." "{" "a" "}")) ("ȧ"))
((("\\" "." "a")) ("ȧ"))
((("\\" "c" "{" "E" "}")) ("Ȩ"))
((("\\" "c" "E")) ("Ȩ"))
((("\\" "c" "{" "e" "}")) ("ȩ"))
((("\\" "c" "e")) ("ȩ"))
((("\\" "." "{" "O" "}")) ("Ȯ"))
((("\\" "." "O")) ("Ȯ"))
((("\\" "." "{" "o" "}")) ("ȯ"))
((("\\" "." "o")) ("ȯ"))
((("\\" "=" "{" "Y" "}")) ("Ȳ"))
((("\\" "=" "Y")) ("Ȳ"))
((("\\" "=" "{" "y" "}")) ("ȳ"))
((("\\" "=" "y")) ("ȳ"))
((("\\" "v" "{" "}")) ("ˇ"))
((("\\" "u" "{" "}")) ("˘"))
((("\\" "." "{" "}")) ("˙"))
((("\\" "~" "{" "}")) ("˜"))
((("\\" "H" "{" "}")) ("˝"))
((("\\" "'")) ("́"))
((("\\" "'" "K")) ("Ḱ"))
((("\\" "'" "M")) ("Ḿ"))
((("\\" "'" "P")) ("Ṕ"))
((("\\" "'" "W")) ("Ẃ"))
((("\\" "'" "k")) ("ḱ"))
((("\\" "'" "m")) ("ḿ"))
((("\\" "'" "p")) ("ṕ"))
((("\\" "'" "w")) ("ẃ"))
((("\\" ",")) (" "))
((("\\" ".")) ("̇"))
((("\\" "." "B")) ("Ḃ"))
((("\\" "." "D")) ("Ḋ"))
((("\\" "." "F")) ("Ḟ"))
((("\\" "." "H")) ("Ḣ"))
((("\\" "." "M")) ("Ṁ"))
((("\\" "." "N")) ("Ṅ"))
((("\\" "." "P")) ("Ṗ"))
((("\\" "." "R")) ("Ṙ"))
((("\\" "." "S")) ("Ṡ"))
((("\\" "." "T")) ("Ṫ"))
((("\\" "." "W")) ("Ẇ"))
((("\\" "." "X")) ("Ẋ"))
((("\\" "." "Y")) ("Ẏ"))
((("\\" "." "b")) ("ḃ"))
((("\\" "." "d")) ("ḋ"))
((("\\" "." "e")) ("ė"))
((("\\" "." "f")) ("ḟ"))
((("\\" "." "h")) ("ḣ"))
((("\\" "." "m")) ("ṁ"))
((("\\" "." "n")) ("ṅ"))
((("\\" "." "p")) ("ṗ"))
((("\\" "." "r")) ("ṙ"))
((("\\" "." "s")) ("ṡ"))
((("\\" "." "t")) ("ṫ"))
((("\\" "." "w")) ("ẇ"))
((("\\" "." "x")) ("ẋ"))
((("\\" "." "y")) ("ẏ"))
((("\\" "/")) ("‌"))
((("\\" ":")) (" "))
((("\\" ";")) (" "))
((("\\" "=")) ("̄"))
((("\\" "=" "G")) ("Ḡ"))
((("\\" "=" "g")) ("ḡ"))
((("^" "(")) ("⁽"))
((("^" ")")) ("⁾"))
((("^" "+")) ("⁺"))
((("^" "-")) ("⁻"))
((("^" "0")) ("⁰"))
((("^" "1")) ("¹"))
((("^" "2")) ("²"))
((("^" "3")) ("³"))
((("^" "4")) ("⁴"))
((("^" "5")) ("⁵"))
((("^" "6")) ("⁶"))
((("^" "7")) ("⁷"))
((("^" "8")) ("⁸"))
((("^" "9")) ("⁹"))
((("^" "=")) ("⁼"))
((("^" "\\" "g" "a" "m" "m" "a")) ("ˠ"))
((("^" "h")) ("ʰ"))
((("^" "j")) ("ʲ"))
((("^" "l")) ("ˡ"))
((("^" "n")) ("ⁿ"))
((("^" "o")) ("º"))
((("^" "r")) ("ʳ"))
((("^" "s")) ("ˢ"))
((("^" "w")) ("ʷ"))
((("^" "x")) ("ˣ"))
((("^" "y")) ("ʸ"))
((("^" "{" "S" "M" "}")) ("℠"))
((("^" "{" "T" "E" "L" "}")) ("℡"))
((("^" "{" "T" "M" "}")) ("™"))
((("_" "(")) ("₍"))
((("_" ")")) ("₎"))
((("_" "+")) ("₊"))
((("_" "-")) ("₋"))
((("_" "0")) ("₀"))
((("_" "1")) ("₁"))
((("_" "2")) ("₂"))
((("_" "3")) ("₃"))
((("_" "4")) ("₄"))
((("_" "5")) ("₅"))
((("_" "6")) ("₆"))
((("_" "7")) ("₇"))
((("_" "8")) ("₈"))
((("_" "9")) ("₉"))
((("_" "=")) ("₌"))
((("\\" "~")) ("̃"))
((("\\" "~" "E")) ("Ẽ"))
((("\\" "~" "V")) ("Ṽ"))
((("\\" "~" "Y")) ("Ỹ"))
((("\\" "~" "e")) ("ẽ"))
((("\\" "~" "v")) ("ṽ"))
((("\\" "~" "y")) ("ỹ"))
((("\\" "\"")) ("̈"))
((("\\" "\"" "H")) ("Ḧ"))
((("\\" "\"" "W")) ("Ẅ"))
((("\\" "\"" "X")) ("Ẍ"))
((("\\" "\"" "h")) ("ḧ"))
((("\\" "\"" "t")) ("ẗ"))
((("\\" "\"" "w")) ("ẅ"))
((("\\" "\"" "x")) ("ẍ"))
((("\\" "^")) ("̂"))
((("\\" "^" "Z")) ("Ẑ"))
((("\\" "^" "z")) ("ẑ"))
((("\\" "`")) ("̀"))
((("\\" "`" "W")) ("Ẁ"))
((("\\" "`" "Y")) ("Ỳ"))
((("\\" "`" "w")) ("ẁ"))
((("\\" "`" "y")) ("ỳ"))
((("\\" "b")) ("̱"))
((("\\" "c")) ("̧"))
((("\\" "c" "{" "D" "}")) ("Ḑ"))
((("\\" "c" "{" "H" "}")) ("Ḩ"))
((("\\" "c" "{" "d" "}")) ("ḑ"))
((("\\" "c" "{" "h" "}")) ("ḩ"))
((("\\" "d")) ("̣"))
((("\\" "d" "{" "A" "}")) ("Ạ"))
((("\\" "d" "{" "B" "}")) ("Ḅ"))
((("\\" "d" "{" "D" "}")) ("Ḍ"))
((("\\" "d" "{" "E" "}")) ("Ẹ"))
((("\\" "d" "{" "H" "}")) ("Ḥ"))
((("\\" "d" "{" "I" "}")) ("Ị"))
((("\\" "d" "{" "K" "}")) ("Ḳ"))
((("\\" "d" "{" "L" "}")) ("Ḷ"))
((("\\" "d" "{" "M" "}")) ("Ṃ"))
((("\\" "d" "{" "N" "}")) ("Ṇ"))
((("\\" "d" "{" "O" "}")) ("Ọ"))
((("\\" "d" "{" "R" "}")) ("Ṛ"))
((("\\" "d" "{" "S" "}")) ("Ṣ"))
((("\\" "d" "{" "T" "}")) ("Ṭ"))
((("\\" "d" "{" "U" "}")) ("Ụ"))
((("\\" "d" "{" "V" "}")) ("Ṿ"))
((("\\" "d" "{" "W" "}")) ("Ẉ"))
((("\\" "d" "{" "Y" "}")) ("Ỵ"))
((("\\" "d" "{" "Z" "}")) ("Ẓ"))
((("\\" "d" "{" "a" "}")) ("ạ"))
((("\\" "d" "{" "b" "}")) ("ḅ"))
((("\\" "d" "{" "d" "}")) ("ḍ"))
((("\\" "d" "{" "e" "}")) ("ẹ"))
((("\\" "d" "{" "h" "}")) ("ḥ"))
((("\\" "d" "{" "i" "}")) ("ị"))
((("\\" "d" "{" "k" "}")) ("ḳ"))
((("\\" "d" "{" "l" "}")) ("ḷ"))
((("\\" "d" "{" "m" "}")) ("ṃ"))
((("\\" "d" "{" "n" "}")) ("ṇ"))
((("\\" "d" "{" "o" "}")) ("ọ"))
((("\\" "d" "{" "r" "}")) ("ṛ"))
((("\\" "d" "{" "s" "}")) ("ṣ"))
((("\\" "d" "{" "t" "}")) ("ṭ"))
((("\\" "d" "{" "u" "}")) ("ụ"))
((("\\" "d" "{" "v" "}")) ("ṿ"))
((("\\" "d" "{" "w" "}")) ("ẉ"))
((("\\" "d" "{" "y" "}")) ("ỵ"))
((("\\" "d" "{" "z" "}")) ("ẓ"))
((("\\" "r" "q")) ("’"))
((("\\" "u")) ("̆"))
((("\\" "v")) ("̌"))
((("\\" "v" "{" "L" "}")) ("Ľ"))
((("\\" "v" "{" "i" "}")) ("ǐ"))
((("\\" "v" "{" "j" "}")) ("ǰ"))
((("\\" "v" "{" "l" "}")) ("ľ"))
((("\\" "y" "e" "n")) ("¥"))
((("\\" "B" "o" "x")) ("□"))
((("\\" "B" "u" "m" "p" "e" "q")) ("≎"))
((("\\" "C" "a" "p")) ("⋒"))
((("\\" "C" "u" "p")) ("⋓"))
((("\\" "D" "e" "l" "t" "a")) ("Δ"))
((("\\" "D" "i" "a" "m" "o" "n" "d")) ("◇"))
((("\\" "D" "o" "w" "n" "a" "r" "r" "o" "w")) ("⇓"))
((("\\" "G" "a" "m" "m" "a")) ("Γ"))
((("\\" "H")) ("̋"))
((("\\" "H" "{" "o" "}")) ("ő"))
((("\\" "I" "m")) ("ℑ"))
((("\\" "J" "o" "i" "n")) ("⋈"))
((("\\" "L" "a" "m" "b" "d" "a")) ("Λ"))
((("\\" "L" "e" "f" "t" "a" "r" "r" "o" "w")) ("⇐"))
((("\\" "L" "e" "f" "t" "r" "i" "g" "h" "t" "a" "r" "r" "o" "w")) ("⇔"))
((("\\" "L" "l")) ("⋘"))
((("\\" "L" "l" "e" "f" "t" "a" "r" "r" "o" "w")) ("⇚"))
((("\\" "L" "o" "n" "g" "l" "e" "f" "t" "a" "r" "r" "o" "w")) ("⇐"))
((("\\" "L" "o" "n" "g" "l" "e" "f" "t" "r" "i" "g" "h" "t" "a" "r" "r" "o" "w")) ("⇔"))
((("\\" "L" "o" "n" "g" "r" "i" "g" "h" "t" "a" "r" "r" "o" "w")) ("⇒"))
((("\\" "L" "s" "h")) ("↰"))
((("\\" "O" "m" "e" "g" "a")) ("Ω"))
((("\\" "P" "h" "i")) ("Φ"))
((("\\" "P" "i")) ("Π"))
((("\\" "P" "s" "i")) ("Ψ"))
((("\\" "R" "e")) ("ℜ"))
((("\\" "R" "i" "g" "h" "t" "a" "r" "r" "o" "w")) ("⇒"))
((("\\" "R" "r" "i" "g" "h" "t" "a" "r" "r" "o" "w")) ("⇛"))
((("\\" "R" "s" "h")) ("↱"))
((("\\" "S" "i" "g" "m" "a")) ("Σ"))
((("\\" "S" "u" "b" "s" "e" "t")) ("⋐"))
((("\\" "S" "u" "p" "s" "e" "t")) ("⋑"))
((("\\" "T" "h" "e" "t" "a")) ("Θ"))
((("\\" "U" "p" "a" "r" "r" "o" "w")) ("⇑"))
((("\\" "U" "p" "d" "o" "w" "n" "a" "r" "r" "o" "w")) ("⇕"))
((("\\" "U" "p" "s" "i" "l" "o" "n")) ("Υ"))
((("\\" "V" "d" "a" "s" "h")) ("⊩"))
((("\\" "V" "e" "r" "t")) ("‖"))
((("\\" "V" "v" "d" "a" "s" "h")) ("⊪"))
((("\\" "X" "i")) ("Ξ"))
((("\\" "a" "l" "e" "p" "h")) ("א"))
((("\\" "a" "l" "p" "h" "a")) ("α"))
((("\\" "a" "m" "a" "l" "g")) ("∐"))
((("\\" "a" "n" "g" "l" "e")) ("∠"))
((("\\" "a" "p" "p" "r" "o" "x")) ("≈"))
((("\\" "a" "p" "p" "r" "o" "x" "e" "q")) ("≊"))
((("\\" "a" "s" "t")) ("∗"))
((("\\" "a" "s" "y" "m" "p")) ("≍"))
((("\\" "b" "a" "c" "k" "c" "o" "n" "g")) ("≌"))
((("\\" "b" "a" "c" "k" "e" "p" "s" "i" "l" "o" "n")) ("∍"))
((("\\" "b" "a" "c" "k" "p" "r" "i" "m" "e")) ("‵"))
((("\\" "b" "a" "c" "k" "s" "i" "m")) ("∽"))
((("\\" "b" "a" "c" "k" "s" "i" "m" "e" "q")) ("⋍"))
((("\\" "b" "a" "c" "k" "s" "l" "a" "s" "h")) ("\\"))
((("\\" "b" "a" "r" "w" "e" "d" "g" "e")) ("⊼"))
((("\\" "b" "e" "c" "a" "u" "s" "e")) ("∵"))
((("\\" "b" "e" "t" "a")) ("β"))
((("\\" "b" "e" "t" "h")) ("ב"))
((("\\" "b" "e" "t" "w" "e" "e" "n")) ("≬"))
((("\\" "b" "i" "g" "c" "a" "p")) ("⋂"))
((("\\" "b" "i" "g" "c" "i" "r" "c")) ("◯"))
((("\\" "b" "i" "g" "c" "u" "p")) ("⋃"))
((("\\" "b" "i" "g" "s" "t" "a" "r")) ("★"))
((("\\" "b" "i" "g" "t" "r" "i" "a" "n" "g" "l" "e" "d" "o" "w" "n")) ("▽"))
((("\\" "b" "i" "g" "t" "r" "i" "a" "n" "g" "l" "e" "u" "p")) ("△"))
((("\\" "b" "i" "g" "v" "e" "e")) ("⋁"))
((("\\" "b" "i" "g" "w" "e" "d" "g" "e")) ("⋀"))
((("\\" "b" "l" "a" "c" "k" "l" "o" "z" "e" "n" "g" "e")) ("✦"))
((("\\" "b" "l" "a" "c" "k" "s" "q" "u" "a" "r" "e")) ("▪"))
((("\\" "b" "l" "a" "c" "k" "t" "r" "i" "a" "n" "g" "l" "e")) ("▴"))
((("\\" "b" "l" "a" "c" "k" "t" "r" "i" "a" "n" "g" "l" "e" "d" "o" "w" "n")) ("▾"))
((("\\" "b" "l" "a" "c" "k" "t" "r" "i" "a" "n" "g" "l" "e" "l" "e" "f" "t")) ("◂"))
((("\\" "b" "l" "a" "c" "k" "t" "r" "i" "a" "n" "g" "l" "e" "r" "i" "g" "h" "t")) ("▸"))
((("\\" "b" "o" "t")) ("⊥"))
((("\\" "b" "o" "w" "t" "i" "e")) ("⋈"))
((("\\" "b" "o" "x" "m" "i" "n" "u" "s")) ("⊟"))
((("\\" "b" "o" "x" "p" "l" "u" "s")) ("⊞"))
((("\\" "b" "o" "x" "t" "i" "m" "e" "s")) ("⊠"))
((("\\" "b" "u" "l" "l" "e" "t")) ("•"))
((("\\" "b" "u" "m" "p" "e" "q")) ("≏"))
((("\\" "c" "a" "p")) ("∩"))
((("\\" "c" "d" "o" "t" "s")) ("⋯"))
((("\\" "c" "e" "n" "t" "e" "r" "d" "o" "t")) ("·"))
((("\\" "c" "h" "e" "c" "k" "m" "a" "r" "k")) ("✓"))
((("\\" "c" "h" "i")) ("χ"))
((("\\" "c" "i" "r" "c")) ("○"))
((("\\" "c" "i" "r" "c" "e" "q")) ("≗"))
((("\\" "c" "i" "r" "c" "l" "e" "a" "r" "r" "o" "w" "l" "e" "f" "t")) ("↺"))
((("\\" "c" "i" "r" "c" "l" "e" "a" "r" "r" "o" "w" "r" "i" "g" "h" "t")) ("↻"))
((("\\" "c" "i" "r" "c" "l" "e" "d" "R")) ("®"))
((("\\" "c" "i" "r" "c" "l" "e" "d" "S")) ("Ⓢ"))
((("\\" "c" "i" "r" "c" "l" "e" "d" "a" "s" "t")) ("⊛"))
((("\\" "c" "i" "r" "c" "l" "e" "d" "c" "i" "r" "c")) ("⊚"))
((("\\" "c" "i" "r" "c" "l" "e" "d" "d" "a" "s" "h")) ("⊝"))
((("\\" "c" "l" "u" "b" "s" "u" "i" "t")) ("♣"))
((("\\" "c" "o" "l" "o" "n")) (":"))
((("\\" "c" "o" "l" "o" "n" "e" "q")) ("≔"))
((("\\" "c" "o" "m" "p" "l" "e" "m" "e" "n" "t")) ("∁"))
((("\\" "c" "o" "n" "g")) ("≅"))
((("\\" "c" "o" "p" "r" "o" "d")) ("∐"))
((("\\" "c" "u" "p")) ("∪"))
((("\\" "c" "u" "r" "l" "y" "e" "q" "p" "r" "e" "c")) ("⋞"))
((("\\" "c" "u" "r" "l" "y" "e" "q" "s" "u" "c" "c")) ("⋟"))
((("\\" "c" "u" "r" "l" "y" "p" "r" "e" "c" "e" "q")) ("≼"))
((("\\" "c" "u" "r" "l" "y" "v" "e" "e")) ("⋎"))
((("\\" "c" "u" "r" "l" "y" "w" "e" "d" "g" "e")) ("⋏"))
((("\\" "c" "u" "r" "v" "e" "a" "r" "r" "o" "w" "l" "e" "f" "t")) ("↶"))
((("\\" "c" "u" "r" "v" "e" "a" "r" "r" "o" "w" "r" "i" "g" "h" "t")) ("↷"))
((("\\" "d" "a" "g")) ("†"))
((("\\" "d" "a" "g" "g" "e" "r")) ("†"))
((("\\" "d" "a" "l" "e" "t" "h")) ("ד"))
((("\\" "d" "a" "s" "h" "v")) ("⊣"))
((("\\" "d" "d" "a" "g")) ("‡"))
((("\\" "d" "d" "a" "g" "g" "e" "r")) ("‡"))
((("\\" "d" "d" "o" "t" "s")) ("⋱"))
((("\\" "d" "e" "l" "t" "a")) ("δ"))
((("\\" "d" "i" "a" "m" "o" "n" "d")) ("⋄"))
((("\\" "d" "i" "a" "m" "o" "n" "d" "s" "u" "i" "t")) ("♢"))
((("\\" "d" "i" "g" "a" "m" "m" "a")) ("Ϝ"))
((("\\" "d" "i" "v" "i" "d" "e" "o" "n" "t" "i" "m" "e" "s")) ("⋇"))
((("\\" "d" "o" "t" "e" "q")) ("≐"))
((("\\" "d" "o" "t" "e" "q" "d" "o" "t")) ("≑"))
((("\\" "d" "o" "t" "p" "l" "u" "s")) ("∔"))
((("\\" "d" "o" "t" "s" "q" "u" "a" "r" "e")) ("⊡"))
((("\\" "d" "o" "w" "n" "a" "r" "r" "o" "w")) ("↓"))
((("\\" "d" "o" "w" "n" "d" "o" "w" "n" "a" "r" "r" "o" "w" "s")) ("⇊"))
((("\\" "d" "o" "w" "n" "l" "e" "f" "t" "h" "a" "r" "p" "o" "o" "n")) ("⇃"))
((("\\" "d" "o" "w" "n" "r" "i" "g" "h" "t" "h" "a" "r" "p" "o" "o" "n")) ("⇂"))
((("\\" "e" "l" "l")) ("ℓ"))
((("\\" "e" "m" "p" "t" "y" "s" "e" "t")) ("∅"))
((("\\" "e" "p" "s" "i" "l" "o" "n")) ("ε"))
((("\\" "e" "q" "c" "i" "r" "c")) ("≖"))
((("\\" "e" "q" "c" "o" "l" "o" "n")) ("≕"))
((("\\" "e" "q" "s" "l" "a" "n" "t" "g" "t" "r")) ("⋝"))
((("\\" "e" "q" "s" "l" "a" "n" "t" "l" "e" "s" "s")) ("⋜"))
((("\\" "e" "q" "u" "i" "v")) ("≡"))
((("\\" "e" "t" "a")) ("η"))
((("\\" "e" "u" "r" "o")) ("€"))
((("\\" "e" "x" "i" "s" "t" "s")) ("∃"))
((("\\" "f" "a" "l" "l" "i" "n" "g" "d" "o" "t" "s" "e" "q")) ("≒"))
((("\\" "f" "l" "a" "t")) ("♭"))
((("\\" "f" "o" "r" "a" "l" "l")) ("∀"))
((("\\" "f" "r" "a" "c" "1")) ("⅟"))
((("\\" "f" "r" "a" "c" "1" "2")) ("½"))
((("\\" "f" "r" "a" "c" "1" "3")) ("⅓"))
((("\\" "f" "r" "a" "c" "1" "4")) ("¼"))
((("\\" "f" "r" "a" "c" "1" "5")) ("⅕"))
((("\\" "f" "r" "a" "c" "1" "6")) ("⅙"))
((("\\" "f" "r" "a" "c" "1" "8")) ("⅛"))
((("\\" "f" "r" "a" "c" "2" "3")) ("⅔"))
((("\\" "f" "r" "a" "c" "2" "5")) ("⅖"))
((("\\" "f" "r" "a" "c" "3" "4")) ("¾"))
((("\\" "f" "r" "a" "c" "3" "5")) ("⅗"))
((("\\" "f" "r" "a" "c" "3" "8")) ("⅜"))
((("\\" "f" "r" "a" "c" "4" "5")) ("⅘"))
((("\\" "f" "r" "a" "c" "5" "6")) ("⅚"))
((("\\" "f" "r" "a" "c" "5" "8")) ("⅝"))
((("\\" "f" "r" "a" "c" "7" "8")) ("⅞"))
((("\\" "f" "r" "o" "w" "n")) ("⌢"))
((("\\" "g" "a" "m" "m" "a")) ("γ"))
((("\\" "g" "e")) ("≥"))
((("\\" "g" "e" "q")) ("≥"))
((("\\" "g" "e" "q" "q")) ("≧"))
((("\\" "g" "e" "q" "s" "l" "a" "n" "t")) ("≥"))
((("\\" "g" "e" "t" "s")) ("←"))
((("\\" "g" "g")) ("≫"))
((("\\" "g" "g" "g")) ("⋙"))
((("\\" "g" "i" "m" "e" "l")) ("ג"))
((("\\" "g" "n" "a" "p" "p" "r" "o" "x")) ("⋧"))
((("\\" "g" "n" "e" "q")) ("≩"))
((("\\" "g" "n" "e" "q" "q")) ("≩"))
((("\\" "g" "n" "s" "i" "m")) ("⋧"))
((("\\" "g" "t" "r" "a" "p" "p" "r" "o" "x")) ("≳"))
((("\\" "g" "t" "r" "d" "o" "t")) ("⋗"))
((("\\" "g" "t" "r" "e" "q" "l" "e" "s" "s")) ("⋛"))
((("\\" "g" "t" "r" "e" "q" "q" "l" "e" "s" "s")) ("⋛"))
((("\\" "g" "t" "r" "l" "e" "s" "s")) ("≷"))
((("\\" "g" "t" "r" "s" "i" "m")) ("≳"))
((("\\" "g" "v" "e" "r" "t" "n" "e" "q" "q")) ("≩"))
((("\\" "h" "b" "a" "r")) ("ℏ"))
((("\\" "h" "e" "a" "r" "t" "s" "u" "i" "t")) ("♥"))
((("\\" "h" "o" "o" "k" "l" "e" "f" "t" "a" "r" "r" "o" "w")) ("↩"))
((("\\" "h" "o" "o" "k" "r" "i" "g" "h" "t" "a" "r" "r" "o" "w")) ("↪"))
((("\\" "i" "f" "f")) ("⇔"))
((("\\" "i" "m" "a" "t" "h")) ("ı"))
((("\\" "i" "n")) ("∈"))
((("\\" "i" "n" "f" "t" "y")) ("∞"))
((("\\" "i" "n" "t")) ("∫"))
((("\\" "i" "n" "t" "e" "r" "c" "a" "l")) ("⊺"))
((("\\" "i" "o" "t" "a")) ("ι"))
((("\\" "k" "a" "p" "p" "a")) ("κ"))
((("\\" "l" "a" "m" "b" "d" "a")) ("λ"))
((("\\" "l" "a" "n" "g" "l" "e")) ("〈"))
((("\\" "l" "b" "r" "a" "c" "e")) ("{"))
((("\\" "l" "b" "r" "a" "c" "k")) ("["))
((("\\" "l" "c" "e" "i" "l")) ("⌈"))
((("\\" "l" "d" "o" "t" "s")) ("…"))
((("\\" "l" "e")) ("≤"))
((("\\" "l" "e" "a" "d" "s" "t" "o")) ("↝"))
((("\\" "l" "e" "f" "t" "a" "r" "r" "o" "w")) ("←"))
((("\\" "l" "e" "f" "t" "a" "r" "r" "o" "w" "t" "a" "i" "l")) ("↢"))
((("\\" "l" "e" "f" "t" "h" "a" "r" "p" "o" "o" "n" "d" "o" "w" "n")) ("↽"))
((("\\" "l" "e" "f" "t" "h" "a" "r" "p" "o" "o" "n" "u" "p")) ("↼"))
((("\\" "l" "e" "f" "t" "l" "e" "f" "t" "a" "r" "r" "o" "w" "s")) ("⇇"))
((("\\" "l" "e" "f" "t" "p" "a" "r" "e" "n" "g" "t" "r")) ("〈"))
((("\\" "l" "e" "f" "t" "r" "i" "g" "h" "t" "a" "r" "r" "o" "w")) ("↔"))
((("\\" "l" "e" "f" "t" "r" "i" "g" "h" "t" "a" "r" "r" "o" "w" "s")) ("⇆"))
((("\\" "l" "e" "f" "t" "r" "i" "g" "h" "t" "h" "a" "r" "p" "o" "o" "n" "s")) ("⇋"))
((("\\" "l" "e" "f" "t" "r" "i" "g" "h" "t" "s" "q" "u" "i" "g" "a" "r" "r" "o" "w")) ("↭"))
((("\\" "l" "e" "f" "t" "t" "h" "r" "e" "e" "t" "i" "m" "e" "s")) ("⋋"))
((("\\" "l" "e" "q")) ("≤"))
((("\\" "l" "e" "q" "q")) ("≦"))
((("\\" "l" "e" "q" "s" "l" "a" "n" "t")) ("≤"))
((("\\" "l" "e" "s" "s" "a" "p" "p" "r" "o" "x")) ("≲"))
((("\\" "l" "e" "s" "s" "d" "o" "t")) ("⋖"))
((("\\" "l" "e" "s" "s" "e" "q" "g" "t" "r")) ("⋚"))
((("\\" "l" "e" "s" "s" "e" "q" "q" "g" "t" "r")) ("⋚"))
((("\\" "l" "e" "s" "s" "g" "t" "r")) ("≶"))
((("\\" "l" "e" "s" "s" "s" "i" "m")) ("≲"))
((("\\" "l" "f" "l" "o" "o" "r")) ("⌊"))
((("\\" "l" "h" "d")) ("◁"))
((("\\" "r" "h" "d")) ("▷"))
((("\\" "l" "l")) ("≪"))
((("\\" "l" "l" "c" "o" "r" "n" "e" "r")) ("⌞"))
((("\\" "l" "n" "a" "p" "p" "r" "o" "x")) ("⋦"))
((("\\" "l" "n" "e" "q")) ("≨"))
((("\\" "l" "n" "e" "q" "q")) ("≨"))
((("\\" "l" "n" "s" "i" "m")) ("⋦"))
((("\\" "l" "o" "n" "g" "l" "e" "f" "t" "a" "r" "r" "o" "w")) ("←"))
((("\\" "l" "o" "n" "g" "l" "e" "f" "t" "r" "i" "g" "h" "t" "a" "r" "r" "o" "w")) ("↔"))
((("\\" "l" "o" "n" "g" "m" "a" "p" "s" "t" "o")) ("↦"))
((("\\" "l" "o" "n" "g" "r" "i" "g" "h" "t" "a" "r" "r" "o" "w")) ("→"))
((("\\" "l" "o" "o" "p" "a" "r" "r" "o" "w" "l" "e" "f" "t")) ("↫"))
((("\\" "l" "o" "o" "p" "a" "r" "r" "o" "w" "r" "i" "g" "h" "t")) ("↬"))
((("\\" "l" "o" "z" "e" "n" "g" "e")) ("✧"))
((("\\" "l" "q")) ("‘"))
((("\\" "l" "r" "c" "o" "r" "n" "e" "r")) ("⌟"))
((("\\" "l" "t" "i" "m" "e" "s")) ("⋉"))
((("\\" "l" "v" "e" "r" "t" "n" "e" "q" "q")) ("≨"))
((("\\" "m" "a" "l" "t" "e" "s" "e")) ("✠"))
((("\\" "m" "a" "p" "s" "t" "o")) ("↦"))
((("\\" "m" "e" "a" "s" "u" "r" "e" "d" "a" "n" "g" "l" "e")) ("∡"))
((("\\" "m" "h" "o")) ("℧"))
((("\\" "m" "i" "d")) ("∣"))
((("\\" "m" "o" "d" "e" "l" "s")) ("⊧"))
((("\\" "m" "p")) ("∓"))
((("\\" "m" "u" "l" "t" "i" "m" "a" "p")) ("⊸"))
((("\\" "n" "L" "e" "f" "t" "a" "r" "r" "o" "w")) ("⇍"))
((("\\" "n" "L" "e" "f" "t" "r" "i" "g" "h" "t" "a" "r" "r" "o" "w")) ("⇎"))
((("\\" "n" "R" "i" "g" "h" "t" "a" "r" "r" "o" "w")) ("⇏"))
((("\\" "n" "V" "D" "a" "s" "h")) ("⊯"))
((("\\" "n" "V" "d" "a" "s" "h")) ("⊮"))
((("\\" "n" "a" "b" "l" "a")) ("∇"))
((("\\" "n" "a" "p" "p" "r" "o" "x")) ("≉"))
((("\\" "n" "a" "t" "u" "r" "a" "l")) ("♮"))
((("\\" "n" "c" "o" "n" "g")) ("≇"))
((("\\" "n" "e")) ("≠"))
((("\\" "n" "e" "a" "r" "r" "o" "w")) ("↗"))
((("\\" "n" "e" "g")) ("¬"))
((("\\" "n" "e" "q")) ("≠"))
((("\\" "n" "e" "q" "u" "i" "v")) ("≢"))
((("\\" "n" "e" "w" "l" "i" "n" "e")) (" "))
((("\\" "n" "e" "x" "i" "s" "t" "s")) ("∄"))
((("\\" "n" "g" "e" "q")) ("≱"))
((("\\" "n" "g" "e" "q" "q")) ("≱"))
((("\\" "n" "g" "e" "q" "s" "l" "a" "n" "t")) ("≱"))
((("\\" "n" "g" "t" "r")) ("≯"))
((("\\" "n" "i")) ("∋"))
((("\\" "n" "l" "e" "f" "t" "a" "r" "r" "o" "w")) ("↚"))
((("\\" "n" "l" "e" "f" "t" "r" "i" "g" "h" "t" "a" "r" "r" "o" "w")) ("↮"))
((("\\" "n" "l" "e" "q")) ("≰"))
((("\\" "n" "l" "e" "q" "q")) ("≰"))
((("\\" "n" "l" "e" "q" "s" "l" "a" "n" "t")) ("≰"))
((("\\" "n" "l" "e" "s" "s")) ("≮"))
((("\\" "n" "m" "i" "d")) ("∤"))
((("\\" "n" "o" "t")) ("̸"))
((("\\" "n" "o" "t" "i" "n")) ("∉"))
((("\\" "n" "p" "a" "r" "a" "l" "l" "e" "l")) ("∦"))
((("\\" "n" "p" "r" "e" "c")) ("⊀"))
((("\\" "n" "p" "r" "e" "c" "e" "q")) ("⋠"))
((("\\" "n" "r" "i" "g" "h" "t" "a" "r" "r" "o" "w")) ("↛"))
((("\\" "n" "s" "h" "o" "r" "t" "m" "i" "d")) ("∤"))
((("\\" "n" "s" "h" "o" "r" "t" "p" "a" "r" "a" "l" "l" "e" "l")) ("∦"))
((("\\" "n" "s" "i" "m")) ("≁"))
((("\\" "n" "s" "i" "m" "e" "q")) ("≄"))
((("\\" "n" "s" "u" "b" "s" "e" "t")) ("⊄"))
((("\\" "n" "s" "u" "b" "s" "e" "t" "e" "q")) ("⊈"))
((("\\" "n" "s" "u" "b" "s" "e" "t" "e" "q" "q")) ("⊈"))
((("\\" "n" "s" "u" "c" "c")) ("⊁"))
((("\\" "n" "s" "u" "c" "c" "e" "q")) ("⋡"))
((("\\" "n" "s" "u" "p" "s" "e" "t")) ("⊅"))
((("\\" "n" "s" "u" "p" "s" "e" "t" "e" "q")) ("⊉"))
((("\\" "n" "s" "u" "p" "s" "e" "t" "e" "q" "q")) ("⊉"))
((("\\" "n" "t" "r" "i" "a" "n" "g" "l" "e" "l" "e" "f" "t")) ("⋪"))
((("\\" "n" "t" "r" "i" "a" "n" "g" "l" "e" "l" "e" "f" "t" "e" "q")) ("⋬"))
((("\\" "n" "t" "r" "i" "a" "n" "g" "l" "e" "r" "i" "g" "h" "t")) ("⋫"))
((("\\" "n" "t" "r" "i" "a" "n" "g" "l" "e" "r" "i" "g" "h" "t" "e" "q")) ("⋭"))
((("\\" "n" "u")) ("ν"))
((("\\" "n" "v" "D" "a" "s" "h")) ("⊭"))
((("\\" "n" "v" "d" "a" "s" "h")) ("⊬"))
((("\\" "n" "w" "a" "r" "r" "o" "w")) ("↖"))
((("\\" "o" "d" "o" "t")) ("⊙"))
((("\\" "o" "i" "n" "t")) ("∮"))
((("\\" "o" "m" "e" "g" "a")) ("ω"))
((("\\" "o" "m" "i" "n" "u" "s")) ("⊖"))
((("\\" "o" "p" "l" "u" "s")) ("⊕"))
((("\\" "o" "s" "l" "a" "s" "h")) ("⊘"))
((("\\" "o" "t" "i" "m" "e" "s")) ("⊗"))
((("\\" "p" "a" "r")) (" "))
((("\\" "p" "a" "r" "a" "l" "l" "e" "l")) ("∥"))
((("\\" "p" "a" "r" "t" "i" "a" "l")) ("∂"))
((("\\" "p" "e" "r" "p")) ("⊥"))
((("\\" "p" "h" "i")) ("φ"))
((("\\" "p" "i")) ("π"))
((("\\" "p" "i" "t" "c" "h" "f" "o" "r" "k")) ("⋔"))
((("\\" "p" "r" "e" "c")) ("≺"))
((("\\" "p" "r" "e" "c" "a" "p" "p" "r" "o" "x")) ("≾"))
((("\\" "p" "r" "e" "c" "e" "q")) ("≼"))
((("\\" "p" "r" "e" "c" "n" "a" "p" "p" "r" "o" "x")) ("⋨"))
((("\\" "p" "r" "e" "c" "n" "s" "i" "m")) ("⋨"))
((("\\" "p" "r" "e" "c" "s" "i" "m")) ("≾"))
((("\\" "p" "r" "i" "m" "e")) ("′"))
((("\\" "p" "r" "o" "d")) ("∏"))
((("\\" "p" "r" "o" "p" "t" "o")) ("∝"))
((("\\" "p" "s" "i")) ("ψ"))
((("\\" "q" "e" "d")) ("∎"))
((("\\" "q" "u" "a" "d")) (" "))
((("\\" "r" "a" "n" "g" "l" "e")) ("〉"))
((("\\" "r" "b" "r" "a" "c" "e")) ("}"))
((("\\" "r" "b" "r" "a" "c" "k")) ("]"))
((("\\" "r" "c" "e" "i" "l")) ("⌉"))
((("\\" "r" "f" "l" "o" "o" "r")) ("⌋"))
((("\\" "r" "i" "g" "h" "t" "a" "r" "r" "o" "w")) ("→"))
((("\\" "r" "i" "g" "h" "t" "a" "r" "r" "o" "w" "t" "a" "i" "l")) ("↣"))
((("\\" "r" "i" "g" "h" "t" "h" "a" "r" "p" "o" "o" "n" "d" "o" "w" "n")) ("⇁"))
((("\\" "r" "i" "g" "h" "t" "h" "a" "r" "p" "o" "o" "n" "u" "p")) ("⇀"))
((("\\" "r" "i" "g" "h" "t" "l" "e" "f" "t" "a" "r" "r" "o" "w" "s")) ("⇄"))
((("\\" "r" "i" "g" "h" "t" "l" "e" "f" "t" "h" "a" "r" "p" "o" "o" "n" "s")) ("⇌"))
((("\\" "r" "i" "g" "h" "t" "p" "a" "r" "e" "n" "g" "t" "r")) ("〉"))
((("\\" "r" "i" "g" "h" "t" "r" "i" "g" "h" "t" "a" "r" "r" "o" "w" "s")) ("⇉"))
((("\\" "r" "i" "g" "h" "t" "t" "h" "r" "e" "e" "t" "i" "m" "e" "s")) ("⋌"))
((("\\" "r" "i" "s" "i" "n" "g" "d" "o" "t" "s" "e" "q")) ("≓"))
((("\\" "r" "t" "i" "m" "e" "s")) ("⋊"))
((("\\" "s" "b" "s")) ("﹨"))
((("\\" "s" "e" "a" "r" "r" "o" "w")) ("↘"))
((("\\" "s" "e" "t" "m" "i" "n" "u" "s")) ("∖"))
((("\\" "s" "h" "a" "r" "p")) ("♯"))
((("\\" "s" "h" "o" "r" "t" "m" "i" "d")) ("∣"))
((("\\" "s" "h" "o" "r" "t" "p" "a" "r" "a" "l" "l" "e" "l")) ("∥"))
((("\\" "s" "i" "g" "m" "a")) ("σ"))
((("\\" "s" "i" "m")) ("∼"))
((("\\" "s" "i" "m" "e" "q")) ("≃"))
((("\\" "s" "m" "a" "l" "l" "a" "m" "a" "l" "g")) ("∐"))
((("\\" "s" "m" "a" "l" "l" "s" "e" "t" "m" "i" "n" "u" "s")) ("∖"))
((("\\" "s" "m" "a" "l" "l" "s" "m" "i" "l" "e")) ("⌣"))
((("\\" "s" "m" "i" "l" "e")) ("⌣"))
((("\\" "s" "p" "a" "d" "e" "s" "u" "i" "t")) ("♠"))
((("\\" "s" "p" "h" "e" "r" "i" "c" "a" "l" "a" "n" "g" "l" "e")) ("∢"))
((("\\" "s" "q" "c" "a" "p")) ("⊓"))
((("\\" "s" "q" "c" "u" "p")) ("⊔"))
((("\\" "s" "q" "s" "u" "b" "s" "e" "t")) ("⊏"))
((("\\" "s" "q" "s" "u" "b" "s" "e" "t" "e" "q")) ("⊑"))
((("\\" "s" "q" "s" "u" "p" "s" "e" "t")) ("⊐"))
((("\\" "s" "q" "s" "u" "p" "s" "e" "t" "e" "q")) ("⊒"))
((("\\" "s" "q" "u" "a" "r" "e")) ("□"))
((("\\" "s" "q" "u" "i" "g" "a" "r" "r" "o" "w" "r" "i" "g" "h" "t")) ("⇝"))
((("\\" "s" "t" "a" "r")) ("⋆"))
((("\\" "s" "t" "r" "a" "i" "g" "h" "t" "p" "h" "i")) ("φ"))
((("\\" "s" "u" "b" "s" "e" "t")) ("⊂"))
((("\\" "s" "u" "b" "s" "e" "t" "e" "q")) ("⊆"))
((("\\" "s" "u" "b" "s" "e" "t" "e" "q" "q")) ("⊆"))
((("\\" "s" "u" "b" "s" "e" "t" "n" "e" "q")) ("⊊"))
((("\\" "s" "u" "b" "s" "e" "t" "n" "e" "q" "q")) ("⊊"))
((("\\" "s" "u" "c" "c")) ("≻"))
((("\\" "s" "u" "c" "c" "a" "p" "p" "r" "o" "x")) ("≿"))
((("\\" "s" "u" "c" "c" "c" "u" "r" "l" "y" "e" "q")) ("≽"))
((("\\" "s" "u" "c" "c" "e" "q")) ("≽"))
((("\\" "s" "u" "c" "c" "n" "a" "p" "p" "r" "o" "x")) ("⋩"))
((("\\" "s" "u" "c" "c" "n" "s" "i" "m")) ("⋩"))
((("\\" "s" "u" "c" "c" "s" "i" "m")) ("≿"))
((("\\" "s" "u" "m")) ("∑"))
((("\\" "s" "u" "p" "s" "e" "t")) ("⊃"))
((("\\" "s" "u" "p" "s" "e" "t" "e" "q")) ("⊇"))
((("\\" "s" "u" "p" "s" "e" "t" "e" "q" "q")) ("⊇"))
((("\\" "s" "u" "p" "s" "e" "t" "n" "e" "q")) ("⊋"))
((("\\" "s" "u" "p" "s" "e" "t" "n" "e" "q" "q")) ("⊋"))
((("\\" "s" "u" "r" "d")) ("√"))
((("\\" "s" "w" "a" "r" "r" "o" "w")) ("↙"))
((("\\" "t" "a" "u")) ("τ"))
((("\\" "t" "h" "e" "r" "e" "f" "o" "r" "e")) ("∴"))
((("\\" "t" "h" "e" "t" "a")) ("θ"))
((("\\" "t" "h" "i" "c" "k" "a" "p" "p" "r" "o" "x")) ("≈"))
((("\\" "t" "h" "i" "c" "k" "s" "i" "m")) ("∼"))
((("\\" "t" "o")) ("→"))
((("\\" "t" "o" "p")) ("⊤"))
((("\\" "t" "r" "i" "a" "n" "g" "l" "e")) ("▵"))
((("\\" "t" "r" "i" "a" "n" "g" "l" "e" "d" "o" "w" "n")) ("▿"))
((("\\" "t" "r" "i" "a" "n" "g" "l" "e" "l" "e" "f" "t")) ("◃"))
((("\\" "t" "r" "i" "a" "n" "g" "l" "e" "l" "e" "f" "t" "e" "q")) ("⊴"))
((("\\" "t" "r" "i" "a" "n" "g" "l" "e" "q")) ("≜"))
((("\\" "t" "r" "i" "a" "n" "g" "l" "e" "r" "i" "g" "h" "t")) ("▹"))
((("\\" "t" "r" "i" "a" "n" "g" "l" "e" "r" "i" "g" "h" "t" "e" "q")) ("⊵"))
((("\\" "t" "w" "o" "h" "e" "a" "d" "l" "e" "f" "t" "a" "r" "r" "o" "w")) ("↞"))
((("\\" "t" "w" "o" "h" "e" "a" "d" "r" "i" "g" "h" "t" "a" "r" "r" "o" "w")) ("↠"))
((("\\" "u" "l" "c" "o" "r" "n" "e" "r")) ("⌜"))
((("\\" "u" "p" "a" "r" "r" "o" "w")) ("↑"))
((("\\" "u" "p" "d" "o" "w" "n" "a" "r" "r" "o" "w")) ("↕"))
((("\\" "u" "p" "l" "e" "f" "t" "h" "a" "r" "p" "o" "o" "n")) ("↿"))
((("\\" "u" "p" "l" "u" "s")) ("⊎"))
((("\\" "u" "p" "r" "i" "g" "h" "t" "h" "a" "r" "p" "o" "o" "n")) ("↾"))
((("\\" "u" "p" "s" "i" "l" "o" "n")) ("υ"))
((("\\" "u" "p" "u" "p" "a" "r" "r" "o" "w" "s")) ("⇈"))
((("\\" "u" "r" "c" "o" "r" "n" "e" "r")) ("⌝"))
((("\\" "u" "{" "i" "}")) ("ĭ"))
((("\\" "v" "D" "a" "s" "h")) ("⊨"))
((("\\" "v" "a" "r" "k" "a" "p" "p" "a")) ("ϰ"))
((("\\" "v" "a" "r" "p" "h" "i")) ("ϕ"))
((("\\" "v" "a" "r" "p" "i")) ("ϖ"))
((("\\" "v" "a" "r" "p" "r" "i" "m" "e")) ("′"))
((("\\" "v" "a" "r" "p" "r" "o" "p" "t" "o")) ("∝"))
((("\\" "v" "a" "r" "r" "h" "o")) ("ϱ"))
((("\\" "v" "a" "r" "s" "i" "g" "m" "a")) ("ς"))
((("\\" "v" "a" "r" "t" "h" "e" "t" "a")) ("ϑ"))
((("\\" "v" "a" "r" "t" "r" "i" "a" "n" "g" "l" "e" "l" "e" "f" "t")) ("⊲"))
((("\\" "v" "a" "r" "t" "r" "i" "a" "n" "g" "l" "e" "r" "i" "g" "h" "t")) ("⊳"))
((("\\" "v" "d" "a" "s" "h")) ("⊢"))
((("\\" "v" "d" "o" "t" "s")) ("⋮"))
((("\\" "v" "e" "e")) ("∨"))
((("\\" "v" "e" "e" "b" "a" "r")) ("⊻"))
((("\\" "v" "e" "r" "t")) ("|"))
((("\\" "w" "e" "d" "g" "e")) ("∧"))
((("\\" "w" "p")) ("℘"))
((("\\" "w" "r")) ("≀"))
((("\\" "x" "i")) ("ξ"))
((("\\" "z" "e" "t" "a")) ("ζ"))
((("\\" "B" "b" "b" "{" "N" "}")) ("ℕ"))
((("\\" "B" "b" "b" "{" "P" "}")) ("ℙ"))
((("\\" "B" "b" "b" "{" "R" "}")) ("ℝ"))
((("\\" "B" "b" "b" "{" "Z" "}")) ("ℤ"))
((("-" "-")) ("–"))
((("-" "-" "-")) ("—"))
((("\\" " ")) (" "))
((("\\" "\\")) ("\\"))
((("\\" "m" "u")) ("μ"))
((("\\" "r" "h" "o")) ("ρ"))
((("\\" "m" "a" "t" "h" "s" "c" "r" "{" "I" "}")) ("ℐ"))
((("\\" "S" "m" "i" "l" "e" "y")) ("☺"))
((("\\" "b" "l" "a" "c" "k" "s" "m" "i" "l" "e" "y")) ("☻"))
((("\\" "F" "r" "o" "w" "n" "y")) ("☹"))
((("\\" "L" "e" "t" "t" "e" "r")) ("✉"))
((("\\" "p" "e" "r" "m" "i" "l")) ("‰"))
((("\\" "r" "e" "g" "i" "s" "t" "e" "r" "e" "d")) ("®"))
((("\\" "c" "u" "r" "r" "e" "n" "c" "y")) ("¤"))
((("\\" "d" "h")) ("ð"))
((("\\" "D" "H")) ("Ð"))
((("\\" "t" "h")) ("þ"))
((("\\" "T" "H")) ("Þ"))
((("\\" "m" "i" "c" "r" "o")) ("µ"))
((("\\" "l" "n" "o" "t")) ("¬"))
((("\\" "o" "r" "d" "f" "e" "m" "i" "n" "i" "n" "e")) ("ª"))
((("\\" "o" "r" "d" "m" "a" "s" "c" "u" "l" "i" "n" "e")) ("º"))
((("\\" "l" "a" "m" "b" "d" "a" "b" "a" "r")) ("ƛ"))
((("\\" "c" "e" "l" "s" "i" "u" "s")) ("℃"))
((("\\" "l" "d" "q")) ("“"))
((("\\" "r" "d" "q")) ("”"))
((("\\" "m" "i" "n" "u" "s")) ("−"))
((("\\" "d" "e" "f" "s")) ("≙"))
((("\\" "l" "l" "b" "r" "a" "c" "k" "e" "t")) ("〚"))
((("\\" "r" "r" "b" "r" "a" "c" "k" "e" "t")) ("〛"))
((("\\" "l" "d" "a" "t" "a")) ("《"))
((("\\" "r" "d" "a" "t" "a")) ("》"))
((("\\" "g" "l" "q")) ("‚"))
((("\\" "g" "r" "q")) ("‘"))
((("\\" "g" "l" "q" "q")) ("„"))
((("\\" "\"" "`")) ("„"))
((("\\" "g" "r" "q" "q")) ("“"))
((("\\" "\"" "'")) ("“"))
((("\\" "f" "l" "q")) ("‹"))
((("\\" "f" "r" "q")) ("›"))
((("\\" "f" "l" "q" "q")) ("«"))
((("\\" "\"" "<")) ("«"))
((("\\" "f" "r" "q" "q")) ("»"))
((("\\" "\"" ">")) ("»"))
((("\\" "-")) ("­"))
((("\\" "t" "e" "x" "t" "m" "u")) ("µ"))
((("\\" "t" "e" "x" "t" "f" "r" "a" "c" "t" "i" "o" "n" "s" "o" "l" "i" "d" "u" "s")) ("⁄"))
((("\\" "t" "e" "x" "t" "b" "i" "g" "c" "i" "r" "c" "l" "e")) ("⃝"))
((("\\" "t" "e" "x" "t" "m" "u" "s" "i" "c" "a" "l" "n" "o" "t" "e")) ("♪"))
((("\\" "t" "e" "x" "t" "d" "i" "e" "d")) ("✝"))
((("\\" "t" "e" "x" "t" "c" "o" "l" "o" "n" "m" "o" "n" "e" "t" "a" "r" "y")) ("₡"))
((("\\" "t" "e" "x" "t" "w" "o" "n")) ("₩"))
((("\\" "t" "e" "x" "t" "n" "a" "i" "r" "a")) ("₦"))
((("\\" "t" "e" "x" "t" "p" "e" "s" "o")) ("₱"))
((("\\" "t" "e" "x" "t" "l" "i" "r" "a")) ("₤"))
((("\\" "t" "e" "x" "t" "r" "e" "c" "i" "p" "e")) ("℞"))
((("\\" "t" "e" "x" "t" "i" "n" "t" "e" "r" "r" "o" "b" "a" "n" "g")) ("‽"))
((("\\" "t" "e" "x" "t" "p" "e" "r" "t" "e" "n" "t" "h" "o" "u" "s" "a" "n" "d")) ("‱"))
((("\\" "t" "e" "x" "t" "b" "a" "h" "t")) ("฿"))
((("\\" "t" "e" "x" "t" "n" "u" "m" "e" "r" "o")) ("№"))
((("\\" "t" "e" "x" "t" "d" "i" "s" "c" "o" "u" "n" "t")) ("⁒"))
((("\\" "t" "e" "x" "t" "e" "s" "t" "i" "m" "a" "t" "e" "d")) ("℮"))
((("\\" "t" "e" "x" "t" "o" "p" "e" "n" "b" "u" "l" "l" "e" "t")) ("◦"))
((("\\" "t" "e" "x" "t" "l" "q" "u" "i" "l" "l")) ("⁅"))
((("\\" "t" "e" "x" "t" "r" "q" "u" "i" "l" "l")) ("⁆"))
((("\\" "t" "e" "x" "t" "c" "i" "r" "c" "l" "e" "d" "P")) ("℗"))
((("\\" "t" "e" "x" "t" "r" "e" "f" "e" "r" "e" "n" "c" "e" "m" "a" "r" "k")) ("※"))
))

;; Local Variables:
;; mode: scheme
;; coding: utf-8
;; End:
