---

license: Licensed to the Apache Software Foundation (ASF) under one or more contributor license agreements. See the NOTICE file distributed with this work for additional information regarding copyright ownership. The ASF licenses this file to you under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at

           http://www.apache.org/licenses/LICENSE-2.0
    
         Unless required by applicable law or agreed to in writing,
         software distributed under the License is distributed on an
         "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
         KIND, either express or implied.  See the License for the
         specific language governing permissions and limitations
    

   under the License.
---

# Metadaten

Eine Schnittstelle, die Informationen über den Status einer Datei oder eines Verzeichnisses angibt.

## Eigenschaften

*   **ModificationTime**: die Zeit, wann die Datei oder das Verzeichnis zuletzt geändert wurde. *(Datum)*

## Informationen

Das `Metadata` -Objekt stellt Informationen über den Status einer Datei oder eines Verzeichnisses dar. Aufruf einer `DirectoryEntry` oder `FileEntry` des Objekts `getMetadata()` Methode führt eine `Metadata` Instanz.

## Unterstützte Plattformen

*   Android
*   BlackBerry WebWorks (OS 5.0 und höher)
*   iOS
*   Windows Phone 7 und 8
*   Windows 8

## Kleines Beispiel

    function win(metadata) {
        console.log("Last Modified: " + metadata.modificationTime);
    }
    
    // Request the metadata object for this entry
    entry.getMetadata(win, null);